<?php
/**
 * classiads functions and definitions.
 *
 * Sets up the theme and provides some helper functions, which are used in the
 * theme as custom template tags. Others are attached to action and filter
 * hooks in WordPress to change core functionality.
 *
 * When using a child theme (see http://codex.wordpress.org/Theme_Development
 * and http://codex.wordpress.org/Child_Themes), you can override certain
 * functions (those wrapped in a function_exists() call) by defining them first
 * in your child theme's functions.php file. The child theme's functions.php
 * file is included before the parent theme's file, so the child theme
 * functions would be used.
 *
 * Functions that are not pluggable (not wrapped in function_exists()) are
 * instead attached to a filter or action hook.
 *
 * For more information on hooks, actions, and filters,
 * see http://codex.wordpress.org/Plugin_API
 *
 * @package WordPress
 * @package WordPress
 * @package WordPress
 * @subpackage classiads
 * @since classiads 1.2.2
 */

/*
 * Makes classiads available for translation.
 *
 * Translations can be added to the /languages/ directory.
 * If you're building a theme based on classiads, use a find and
 * replace to change 'classiads' to the name of your theme in all
 * template files.
 */
load_theme_textdomain( 'classiads', get_template_directory() . '/languages' );

add_action( 'after_setup_theme', 'classiads_theme_setup' );

function classiads_theme_setup() {


    add_theme_support( 'custom-background' );
	add_theme_support( 'woocommerce' );
	
    require_once get_template_directory() . '/inc/general.php';
    require_once get_template_directory() . '/inc/post_meta.php';
    require_once get_template_directory() . '/inc/action.php';
    require_once get_template_directory() . '/inc/woocommerce.php';
	require_once get_template_directory() . '/inc/BFI_Thumb.php';
    require_once get_template_directory() . '/inc/plans.php';
    require_once get_template_directory() . '/inc/post_format.php';
    require_once get_template_directory() . '/inc/page_meta.php';
    require_once get_template_directory() . '/inc/colors.php';
    require_once get_template_directory() . '/inc/package_manage.php';
    require_once get_template_directory() . '/inc/widgets/recent_posts_widget.php';
    require_once get_template_directory() . '/inc/widgets/recent_list_post_widget.php';
    require_once get_template_directory() . '/inc/widgets/twitter_widget.php';
    require_once get_template_directory() . '/inc/widgets/categories.php';
	require_once get_template_directory() . '/inc/twitter-function.php';
	require_once get_template_directory() . '/inc/widgets/social_widget.php';
	require_once get_template_directory() .'/inc/wp-nav-custom-walker.php';
	require_once get_template_directory() .'/inc/default-theme-options.php';
	
	if ( ! function_exists( 'is_plugin_active' ) ){
     require_once( ABSPATH . '/wp-admin/includes/plugin.php' );
	}
	

    /**
     * Sets up the content width value based on the theme's design.
     * @see classiads_content_width() for template-specific adjustments.
     */
    if ( ! isset( $content_width ) )
        $content_width = 1060;

    /**
     * classiads only works in WordPress 3.6 or later.
     */
	 
    if ( version_compare( $GLOBALS['wp_version'], '3.6-alpha', '<' ) )
        require get_template_directory() . '/inc/back-compat.php';

    /**
     * Sets up theme defaults and registers the various WordPress features that
     * classiads supports.
     *
     * @uses load_theme_textdomain() For translation/localization support.
     * @uses add_editor_style() To add Visual Editor stylesheets.
     * @uses add_theme_support() To add support for automatic feed links, post
     * formats, and post thumbnails.
     * @uses register_nav_menu() To add support for a navigation menu.
     * @uses set_post_thumbnail_size() To set a custom post thumbnail size.
     *
     * @since classiads 1.2.2
     *
     * @return void
    */


	/*
	 * This theme styles the visual editor to resemble the theme style,
	 * specifically font, colors, icons, and column width.
	 */
	add_editor_style( array( 'css/editor-style.css', 'fonts/genericons.css', classiads_fonts_url() ) );

	// Adds RSS feed links to <head> for posts and comments.
	add_theme_support( 'automatic-feed-links' );

	// Switches default core markup for search form, comment form, and comments
	// to output valid HTML5.
	add_theme_support( 'html5', array( 'search-form', 'comment-form', 'comment-list' ) );

	// This theme uses wp_nav_menu() in one location.
	register_nav_menu( 'primary', __( 'Navigation Menu', 'classiads' ) );

	/*
	 * This theme uses a custom image size for featured images, displayed on
	 * "standard" posts and pages.
	 */
	add_theme_support( 'post-thumbnails' );
	set_post_thumbnail_size( 440, 266, true );

	// This theme uses its own gallery styles.
	add_filter( 'use_default_gallery_style', '__return_false' );

    // Author add new contact details
    add_filter('user_contactmethods','wpcrown_author_new_contact',10,1);

    // Lost Password and Login Error
    add_action( 'wp_login_failed', 'wpcrown_front_end_login_fail' );  // hook failed login


    // Load scripts and styles
    add_action( 'wp_enqueue_scripts', 'classiads_scripts_styles' );


    //Include the TGM_Plugin_Activation class.
    require_once dirname( __FILE__ ) . '/inc/class-tgm-plugin-activation.php';
    add_action( 'tgmpa_register', 'TW_register_required_plugins' );

    // Google analitycs code
    add_action( 'wp_enqueue_scripts', 'wpcrown_google_analityc_code' );

    // Enqueue main font
    add_action( 'wp_enqueue_scripts', 'wpcrown_main_font' );

    // Enqueue main font
    add_action( 'wp_enqueue_scripts', 'wpcrown_second_font_armata' );

    // Track views
    add_action( 'wp_head', 'wpb_track_post_views');

    // Theme page titles
    add_filter( 'wp_title', 'classiads_wp_title', 10, 2 );

	 // Footer Menu
	add_action( 'init', 'wpcrown_register_my_menu' );

    // classiads sidebars spot
    add_action( 'widgets_init', 'classiads_widgets_init' );

    // classiads body class
    add_filter( 'body_class', 'classiads_body_class' );

    // classiads content width
    add_action( 'template_redirect', 'classiads_content_width' );

    // classiads customize register
    add_action( 'customize_register', 'classiads_customize_register' );

    // classiads customize preview
    add_action( 'customize_preview_init', 'classiads_customize_preview_js' );

    /* Add theme support for automatic feed links. */
    add_theme_support( 'automatic-feed-links' );
	// Custom admin scripts



}
/*-----------------------------------------------------------------------------------*/
/*	Register and load admin styles
/*-----------------------------------------------------------------------------------*/
if( !function_exists( 'classi_admin_styles' ) ){
    function classi_admin_styles($hook){
        wp_register_style( 'Themeinvento-admin-styles', get_template_directory_uri() . '/css/themeinvento-admin-styles.css' );
        wp_enqueue_style('Themeinvento-admin-styles');
    }
}
add_action('admin_enqueue_scripts','classi_admin_styles');
add_action('admin_enqueue_scripts', 'wpcads_custom_admin_scripts' );
// Custom admin scripts
function wpcads_custom_admin_scripts() {
	wp_enqueue_media();
}
/*
 *  Setup main navigation menu
 */
function wpcrown_register_my_menu() {
    // register menu
    register_nav_menus (
        array(
        'primary' =>__('Main menu','classiads'),
        'secondary' =>__('Footer menu','classiads'),
        )
    );
}


// Author add new contact details
function wpcrown_author_new_contact( $contactmethods ) {

	// Add telefone
	$contactmethods['phone'] = 'Phone';
	// add address
	$contactmethods['address'] = 'Address';
			$contactmethods['facebook'] = 'Facebook';
			$contactmethods['google'] = 'Google';
			$contactmethods['linkedin'] = 'Linkedin';
			$contactmethods['instagram'] = 'Instagram';
			$contactmethods['twitter'] = 'Twitter';

	return $contactmethods;

}

// Add user price plan info
function wpcrown_save_extra_profile_fields( $user_id ) {
	update_user_meta( $user_id, 'price_plan' );
	add_user_meta( $user_id, 'price_plan_id' );
}

// Lost Password and Login Error
function wpcrown_front_end_login_fail( $username ) {
   $referrer = $_SERVER['HTTP_REFERER'];  // where did the post submission come from?
   // if there's a valid referrer, and it's not the default log-in screen
   if ( !empty($referrer) && !strstr($referrer,'wp-login') && !strstr($referrer,'wp-admin') && $user!=null ) {
      	wp_redirect( $referrer . '?login=failed' );  // let's append some information (login=failed) to the URL for the theme to use
      	exit;
   } elseif ( is_wp_error($user_verify) )  {
   		wp_redirect( $referrer . '?login=failed-user' );  // let's append some information (login=failed) to the URL for the theme to use
      	exit;
   }
}
// End

// Insert attachments front end
function wpcads_insert_attachment($file_handler,$post_id,$setthumb='false') {

  // check to make sure its a successful upload
  if ($_FILES[$file_handler]['error'] !== UPLOAD_ERR_OK) __return_false();

  require_once(ABSPATH . "wp-admin" . '/includes/image.php');
  require_once(ABSPATH . "wp-admin" . '/includes/file.php');
  require_once(ABSPATH . "wp-admin" . '/includes/media.php');

  $attach_id = media_handle_upload( $file_handler, $post_id );

  if ($setthumb) update_post_meta($post_id,'_thumbnail_id',$attach_id);
  return $attach_id;
}


// Insert attachments front end
function wp_user_profile_image($file_handler,$post_id,$setthumb='false') {

  // check to make sure its a successful upload
  if ($_FILES[$file_handler]['error'] !== UPLOAD_ERR_OK) __return_false();

  require_once(ABSPATH . "wp-admin" . '/includes/image.php');
  require_once(ABSPATH . "wp-admin" . '/includes/file.php');
  require_once(ABSPATH . "wp-admin" . '/includes/media.php');

  $attach_id = media_handle_upload( $file_handler, $post_id );

  if ($setthumb) update_user_meta($post_id,'_user_id',$attach_id);
  return $attach_id;
  
}

function classiads_fonts_url() {
	$fonts_url = '';

	$source_sans_pro = _x( 'on', 'Source Sans Pro font: on or off', 'classiads' );
	$bitter = _x( 'on', 'Bitter font: on or off', 'classiads' );

	if ( 'off' !== $source_sans_pro || 'off' !== $bitter ) {
		$font_families = array();

		if ( 'off' !== $source_sans_pro )
			$font_families[] = 'Montserrat:400,700,400italic,700italic';

		if ( 'off' !== $bitter )
			$font_families[] = 'Lato:400,700,900italic';

		$query_args = array(
			'family' => urlencode( implode( '%7C', $font_families ) ),
			'subset' => urlencode( 'latin,latin-ext' ),
		);
		$fonts_url = esc_url( add_query_arg( $query_args, "//fonts.googleapis.com/css" ) ) ;
	}

	return $fonts_url;
}

//////////////////////////////////////////////////////////////////
//// function to display extra info on category admin
//////////////////////////////////////////////////////////////////
// the option name
define('MY_CATEGORY_FIELDS', 'my_category_fields_option');


// Location Custom fields.
	add_action( 'location_edit_form_fields', 'classi_location_fields', 10, 2 );

	add_action( 'edited_location', 'classi_save_location_fields', 10, 2 );
// A callback function to save our extra taxonomy field(s)
	function  classi_save_location_fields( $term_id ) {
		if ( isset( $_POST['term_meta'] ) ) {
			$t_id = $term_id;
			$term_meta = get_option( "taxonomy_term_$t_id" );
			$cat_keys = array_keys( $_POST['term_meta'] );
				foreach ( $cat_keys as $key ){
				if ( isset( $_POST['term_meta'][$key] ) ){
					$term_meta[$key] = $_POST['term_meta'][$key];
				}
			}
			//save the option array
			update_option( "taxonomy_term_$t_id", $term_meta );
		}
	}


	function classi_location_fields($tag) {
	   // Check for existing taxonomy meta for the term you're editing
		$t_id = $tag->term_id; // Get the ID of the term you're editing
		$term_meta = get_option( "taxonomy_term_$t_id" ); // Do the check
	?>

	<tr class="form-field">
		<th scope="row" valign="top">
			<label for="presenter_id"><?php _e('Location Image', 'classiads'); ?></label>
		</th>
		<td>
			<?php



				if(!empty($term_meta)) {

                echo '<div style="width: 100%; float: left;"><img id="category_image_img" src="'. $term_meta['presenter_id'] .'" style="float: left; margin-bottom: 20px;" /> </div>';
                echo '<input id="category_image" type="text" size="36" name="term_meta[presenter_id]" style="max-width: 200px; float: left; margin-top: 10px; display: none;" value="'.$term_meta['presenter_id'].'" />';

			   echo '<input id="category_image_button_remove" class="button" type="button" style="max-width: 140px; float: left; margin-top: 10px;" value="Remove" /> </br>';
                echo '<input id="category_image_button" class="button" type="button" style="max-width: 140px; float: left; margin-top: 10px; display: none;" value="Upload Image" /> </br>';

            } else {


                echo '<div style="width: 100%; float: left;"><img id="category_image_img" src="'. $term_meta['presenter_id'] .'" style="float: left; margin-bottom: 20px;" /> </div>';
               echo '<input id="category_image" type="text" size="36" name="term_meta[presenter_id]" style="max-width: 200px; float: left; margin-top: 10px; display: none;" value="'.$term_meta['presenter_id'].'" />';

			   echo '<input id="category_image_button_remove" class="button" type="button" style="max-width: 140px; float: left; margin-top: 10px; display: none;" value="Remove" /> </br>';
                echo '<input id="category_image_button" class="button" type="button" style="max-width: 140px; float: left; margin-top: 10px;" value="Upload Image" /> </br>';

            }



            ?>
		</td>
		 <script>
            var image_custom_uploader;
            jQuery('#category_image_button').click(function(e) {
                e.preventDefault();

                //If the uploader object has already been created, reopen the dialog
                if (image_custom_uploader) {
                    image_custom_uploader.open();
                    return;
                }

                //Extend the wp.media object
                image_custom_uploader = wp.media.frames.file_frame = wp.media({
                    title: 'Choose Image',
                    button: {
                        text: 'Choose Image'
                    },
                    multiple: false
                });

                //When a file is selected, grab the URL and set it as the text field's value
                image_custom_uploader.on('select', function() {
                    attachment = image_custom_uploader.state().get('selection').first().toJSON();
                    var url = '';
                    url = attachment['url'];
                    jQuery('#category_image').val(url);
                    jQuery( "img#category_image_img" ).attr({
                        src: url
                    });
                    jQuery("#category_image_button").css("display", "none");
                    jQuery("#category_image_button_remove").css("display", "block");
                });

                //Open the uploader dialog
                image_custom_uploader.open();
             });

             jQuery('#category_image_button_remove').click(function(e) {
                jQuery('#category_image').val('');
                jQuery( "img#category_image_img" ).attr({
                    src: ''
                });
                jQuery("#category_image_button").css("display", "block");
                jQuery("#category_image_button_remove").css("display", "none");
             });
            </script>
	</tr>

	<?php
	}




/**
 * Register the required plugins for this theme.
 *
 * In this example, we register two plugins - one included with the TGMPA library
 * and one from the .org repo.
 *
 * The variable passed to tgmpa_register_plugins() should be an array of plugin
 * arrays.
 *
 * This function is hooked into tgmpa_init, which is fired within the
 * TGM_Plugin_Activation class constructor.
 */
function TW_register_required_plugins() {



$plugins = array(

    	// Facebook Connect
        array(
            'name' => 'Nextend Facebook Connect',
            'slug' => 'nextend-facebook-connect',
            'required' => false,
            'force_activation' => false,
            'force_deactivation' =>false
        ),
        // Twitter Connect
        array(
            'name' => 'Nextend Twitter Connect',
            'slug' => 'nextend-twitter-connect',
            'required' => false,
            'force_activation' => false,
            'force_deactivation' => false
        ),
        // Google Connect
        array(
            'name' => 'Nextend Google Connect',
            'slug' => 'nextend-google-connect',
            'required' => false,
            'force_activation' => false,
            'force_deactivation' => false
        ),
        array(
            'name' => 'WooCommerce',
            'slug' => 'woocommerce',
            'source' => '',
            'required' => false,
            'version' => '',
            'force_activation' => false,
            'force_deactivation' => false
        ),
        array(
            'name' => 'YITH WooCommerce Quick View',
            'slug' => 'yith-woocommerce-quick-view',
            'required' => false,
            'force_activation' => false,
            'force_deactivation' => false
        ),
        array(
            'name' => 'YITH WooCommerce Wishlist',
            'slug' => 'yith-woocommerce-wishlist',
            'required' => false,
            'force_activation' => false,
            'force_deactivation' => false
        ),
        // Layer SLider
        array(
            'name' => 'LayerSlider WP',
            'slug' => 'layerslider',
            'source' => get_template_directory() . '/inc/plugins/layerslider.zip',
            'required' => false,
            'version' => '6.6.4',
            'force_activation' => true,
            'force_deactivation' => true
        ),
        array(
            'name' => 'Classiads Core Features',
            'slug' => 'classiads-core-features',
            'source' => get_template_directory() . '/inc/plugins/classiads-core-features.zip',
            'required' => true,
            'version' => '1.8',
            'force_activation' => false,
            'force_deactivation' => false
        ),
        array(
            'name' => 'Visual Composer',
            'slug' => 'visual-composer',
            'source' => get_template_directory() . '/inc/plugins/js_composer.zip',
            'required' => true,
            'version' => '5.4.7',
            'force_activation' => false,
            'force_deactivation' => false
        ),
		array(
			'name'     				=> 'Contact Form 7', // The plugin name
			'slug'     				=> 'contact-form-7', // The plugin slug (typically the folder name)
			'required' 				=> false, // If false, the plugin is only 'recommended' instead of required
			'version' 				=> '', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
			'force_activation' 		=> false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
			'force_deactivation' 	=> false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
			'external_url' 			=> '', // If set, overrides default API URL and points to an external URL
		),
		array(
            'name' => 'WP-Subscribe',
            'slug' => 'wp-subscribe',
            'required' => false,
            'version' => '',
            'force_activation' => false,
            'force_deactivation' => false
        ),

    );
	$config = array(
		'id'           => 'tgmpa',                 // Unique ID for hashing notices for multiple instances of TGMPA.
		'menu'         => 'tgmpa-install-plugins', // Menu slug.
		'parent_slug'  => 'themes.php',            // Parent menu slug.
		'capability'   => 'edit_theme_options',    // Capability needed to view plugin install page, should be a capability associated with the parent menu used.
		'has_notices'  => true,                    // Show admin notices or not.
		'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
		'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
		'is_automatic' => false,                   // Automatically activate plugins after installation or not.
		'message'      => '',                      // Message to output right before the plugins table.


	);

	tgmpa( $plugins, $config );

}



/**
* Google analytic code
*/
function wpcrown_google_analityc_code() { ?>

	<script type="text/javascript">

	var _gaq = _gaq || [];
	_gaq.push(['_setAccount', '<?php global $redux_demo; $google_id = $redux_demo['google_id']; echo $google_id; ?>']);
	_gaq.push(['_setDomainName', 'none']);
	_gaq.push(['_setAllowLinker', true]);
	_gaq.push(['_trackPageview']);

	(function() {
		var ga = document.createElement('script'); ga.type = 'text/javascript'; ga.async = true;
		ga.src = ('https:' == document.location.protocol ? 'https://ssl' : 'http://www') + '.google-analytics.com/ga.js';
		var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(ga, s);
	})();

</script>

<?php }



/**
 * Enqueues scripts and styles for front end.
 *
 * @since classiads 1.2.2
 *
 * @return void
 */
function classiads_scripts_styles() {

	global $redux_demo;
	// Adds JavaScript to pages with the comment form to support sites with
	// threaded comments (when in use).
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) )
		wp_enqueue_script( 'comment-reply' );
	// Add Open Sans and Bitter fonts, used in the main stylesheet.
	wp_enqueue_style( 'classiads-fonts', classiads_fonts_url(), array(), null );
	// Add Genericons font, used in the main stylesheet.
	wp_enqueue_style( 'genericons', get_template_directory_uri() . '/fonts/genericons.css', array(), '2.09' );
	// Loads our main stylesheet.
	wp_enqueue_style( 'classiads-style', get_stylesheet_uri(), array(), '2014-07-18' );
	// Loads the Internet Explorer specific stylesheet.
	wp_enqueue_style( 'classiads-ie', get_template_directory_uri() . '/css/ie.css', array( 'classiads-style' ), '2013-11-08' );
	wp_style_add_data( 'classiads-ie', 'conditional', 'lt IE 9' );
    wp_enqueue_script( 'formjs', get_template_directory_uri() . '/js/jquery.form.js', array( 'jquery' ), '2016-02-8', true );
	wp_register_script('infnite', get_template_directory_uri() . '/js/blog-infinitescroll.js', 'jquery', '', true);
	wp_enqueue_script( 'infnite' );
	wp_localize_script( 'infnite', 'rel_reg_vars', array(
			'rel_ajax_url' => admin_url( 'admin-ajax.php' ),
		  )
	);

	// Custom scripts ans styles //
    // Load custom script
    wp_enqueue_script( 'classiads-menu-script', get_template_directory_uri() . '/js/menu.js', array( 'jquery' ), '2014-07-18', true );
	wp_enqueue_script( 'classiads-boostrat-script', get_template_directory_uri() . '/js/bootstrap.min.js', array( 'jquery' ), '2014-07-18', true );
	wp_enqueue_script( 'lazyload-min', get_template_directory_uri() . '/js/jquery.lazyload.min.js', array( 'jquery' ), '2017-03-17', true );
	wp_enqueue_script( 'classiads-chosen-script', get_template_directory_uri() . '/js/chosen.jquery.min.js', array( 'jquery' ), '2014-07-18', true );
	wp_enqueue_script( 'classiads-jquery-ui-script', 'https://ajax.googleapis.com/ajax/libs/jqueryui/1.11.4/jquery-ui.min.js', array( 'jquery' ), '2014-07-18', true );
	wp_enqueue_script( 'classiads-jquery-tools-forms-script', get_template_directory_uri() . '/js/jquery.tools.min.js', array( 'jquery' ), '2014-07-18', true );
	wp_enqueue_script( 'classiads-fancybox', get_template_directory_uri() . '/js/fancybox.pack.js', array( 'jquery' ), '2014-07-18', false );


    if( is_page_template('template-add-post.php') || is_page_template('template-edit-post.php') ) {
		
		wp_enqueue_style( 'jquery-filer', get_template_directory_uri() . '/css/jquery.filer.css', array(), '2.09' );
		wp_enqueue_style( 'filer-dragdropbox-theme', get_template_directory_uri() . '/css/jquery.filer-dragdropbox-theme.css', array(), '2.09' );
		$hide_map = $redux_demo['hide-map'];
		if( $hide_map == 1 ){
			wp_enqueue_script( 'google-lib', 'https://maps.googleapis.com/maps/api/js?key=AIzaSyBueyERw9S41n4lblw5fVPAc9UqpAiMgvM', array( 'jquery' ), '2017-02-08', true );
			wp_enqueue_script( 'submit-map-post', get_template_directory_uri() . '/js/submit-map-post.js', array( 'jquery' ), '2014-07-18', true );
		}
		wp_enqueue_script( 'jquery-filer-min-js', get_template_directory_uri() . '/js/jquery.filer.min.js', array( 'jquery' ), '2014-07-18', true );
		wp_enqueue_script( 'jquery-filer-trigger-js', get_template_directory_uri() . '/js/jquery.filer.trigger.js', array( 'jquery' ), '2014-07-18', true );
		
	} 
	
	if( is_single()  ) {
		
		wp_enqueue_script( 'single-post-map', get_template_directory_uri() . '/js/single-post-map.js', array( 'jquery' ), '2014-07-18', true );
		wp_enqueue_script( 'jquery-markerclusterer-js', 'https://developers.google.com/maps/documentation/javascript/examples/markerclusterer/markerclusterer.js', array( 'jquery' ), '2014-07-18', true );
		wp_enqueue_script( 'jquery-singlepostmap-js', 'https://maps.googleapis.com/maps/api/js?key=AIzaSyBueyERw9S41n4lblw5fVPAc9UqpAiMgvM', array( 'jquery' ), '2014-07-18', true );
    }
	
	if( is_search() || is_category() || is_tax('location') ){
		
		wp_enqueue_script( 'jquery-google-lib-js', 'https://maps.googleapis.com/maps/api/js?key=AIzaSyBueyERw9S41n4lblw5fVPAc9UqpAiMgvM&sensor=false', array( 'jquery' ), '2014-07-18', true );
		wp_enqueue_script( 'jquery-markerclusterer-js', 'https://developers.google.com/maps/documentation/javascript/examples/markerclusterer/markerclusterer.js', array( 'jquery' ), '2014-07-18', true );
		
	}

    wp_enqueue_script( 'classiads-modernizer', get_template_directory_uri() . '/js/modernizr.touch.js', array( 'jquery' ), '2014-07-18', true );
    wp_enqueue_script( 'slick-min', get_template_directory_uri() . '/js/slick.min.js', array( 'jquery' ), '2014-07-18', true );
    wp_enqueue_script( 'classiads-slider-mobile', get_template_directory_uri() . '/js/jquery.ui.touch-punch.min.js', array( 'jquery' ), '2014-07-18', true );
	wp_enqueue_script( 'classiads-boostrat-script', get_template_directory_uri() . '/js/webslidemenu.js', array( 'jquery' ), '2014-07-18', true );
    wp_enqueue_script( 'classiads-jquery-validationEngine-en', get_template_directory_uri() . '/js/languages/jquery.validationEngine-en.js', array( 'jquery' ), '2014-07-18', true );
    wp_enqueue_script( 'classiads-jquery-validationEngine', get_template_directory_uri() . '/js/jquery.validationEngine.js', array( 'jquery' ), '2014-07-18', true );
    wp_enqueue_script( 'classiads-custom-script', get_template_directory_uri() . '/js/custom.js', array( 'jquery' ), '2014-07-18', true );
	
	if( is_rtl() ){
		
    wp_enqueue_script( 'vc-rtl-fix', get_template_directory_uri() . '/js/vc-rtl-fix.js', array( 'jquery' ), '2017-03-25', true );
		
	}


    // Load boostratp style
    wp_enqueue_style( 'boostrat-style', get_template_directory_uri() . '/css/bootstrap.css', array(), '2.3.2' );
    wp_enqueue_style( 'awesomefont-style', get_template_directory_uri() .'/css/font-awesome/css/font-awesome.min.css', array(), '4.7' );
    wp_enqueue_style( 'boostrat-chosen', get_template_directory_uri() . '/css/chosen.min.css', array(), '1' );
    wp_enqueue_style( 'slick', get_template_directory_uri() . '/css/slick.css', array(), '1' );
    wp_enqueue_style( 'slick-theme', get_template_directory_uri() . '/css/slick-theme.css', array(), '1' );
    wp_enqueue_style( 'main-style-custom', get_template_directory_uri() . '/css/custom.css', array(), '1' );
    wp_enqueue_style( 'main-fancybox', get_template_directory_uri() . '/css/fancybox.css', array(), '1' );
    wp_enqueue_style( 'boostrat-style-responsive', get_template_directory_uri() . '/css/bootstrap-responsive.css', array(), '2.3.2' );
	
	if(is_admin_bar_showing()) echo "<style type=\"text/css\">.navbar-fixed-top { margin-top: 28px; } </style>";

}
add_image_size( 'premium-post-image', 400, 280, true );
add_image_size( 'hr-slider-thumb-vr-2', 320, 280, true );
add_image_size( 'hr-slider-thumb-vr-3', 700, 399, true );
add_image_size( 'single-post-image', 300, 300, true );
add_image_size( 'single-cat-image', 255, 218, true );
add_image_size( 'blog-image', 870, 506, false );
add_image_size( 'single-thumb', 100, 64, false );
add_image_size( '270x220', 270, 220, true );
add_image_size( '270x274', 270, 274, true );
add_image_size( '270x272', 270, 272, true );
add_image_size( '370x300', 370, 300, true );
add_image_size( 'custom-sizea', 10, 10, true );
function wpcrown_main_font() {
    $protocol = is_ssl() ? 'https' : 'http';
    //wp_enqueue_style( 'classiads-roboto', "$protocol://fonts.googleapis.com/css?family=Roboto:400,400italic,500,300,300italic,500italic,700,700italic" );
}



function wpcrown_second_font_armata() {
    $protocol = is_ssl() ? 'https' : 'http';
    //wp_enqueue_style( 'classiads-armata', "$protocol://fonts.googleapis.com/css?family=Armata" );
}


// Post views
function wpb_set_post_views($postID) {
    $count_key = 'wpb_post_views_count';
    $count = get_post_meta($postID, $count_key, true);
    if($count==''){
        $count = 0;
        delete_post_meta($postID, $count_key);
        add_post_meta($postID, $count_key, '0');
    }else{
        $count++;
        update_post_meta($postID, $count_key, $count);
    }
}
//To keep the count accurate, lets get rid of prefetching


function wpb_track_post_views ($post_id) {
    if ( !is_single() ) return;
    if ( empty ( $post_id) ) {
        global $post;
        $post_id = $post->ID;
    }
    wpb_set_post_views($post_id);
}


function wpb_get_post_views($postID){
    $count_key = 'wpb_post_views_count';
    $count = get_post_meta($postID, $count_key, true);
    if($count==''){
        delete_post_meta($postID, $count_key);
        add_post_meta($postID, $count_key, '0');
        return "0";
    }
    return $count;
}




/**
 * Creates a nicely formatted and more specific title element text for output
 * in head of document, based on current view.
 *
 * @since classiads 1.2.2
 *
 * @param string $title Default title text for current view.
 * @param string $sep Optional separator.
 * @return string The filtered title.
 */
function classiads_wp_title( $title, $sep ) {
	global $paged, $page;

	if ( is_feed() )
		return $title;

	// Add the site name.
	$title .= get_bloginfo( 'name' );

	// Add the site description for the home/front page.
	$site_description = get_bloginfo( 'description', 'display' );
	if ( $site_description && ( is_home() || is_front_page() ) )
		$title = "$title $sep $site_description";

	// Add a page number if necessary.
	if ( $paged >= 2 || $page >= 2 )
		$title = "$title $sep " . sprintf( __( 'Page %s', 'classiads' ), max( $paged, $page ) );

	return $title;
}


/**
 * Registers two widget areas.
 * @since classiads 1.2.2
 * @return void
 */
function classiads_widgets_init() {
	global $redux_demo;
	if(isset($redux_demo['footer-grid'])){
		$footerGrid = $redux_demo['footer-grid']; /*Footer Grid Style ID*/
	}else{
		$footerGrid = 1;
	}

	if ($footerGrid == 1){
		
		register_sidebar( array(
			'name'          => __( 'Footer Widget ', 'classiads' ),
			'id'            => 'footer-one',
			'description'   => __( 'Appears in the footer section of the site.', 'classiads' ),
			'before_widget' => '<div class="col-md-4 col-sm-6 col-xs-12"><div class="block-content clearfix">',
			'after_widget'  => '</div></div>',
			'before_title'  => '<h4 class="block-title">',
			'after_title'   => '</h4>',
		) );
		
	}elseif ($footerGrid == 2){
		
		register_sidebar( array(
			'name'          => __( 'Footer Widget ', 'classiads' ),
			'id'            => 'footer-one',
			'description'   => __( 'Appears in the footer section of the site.', 'classiads' ),
			'before_widget' => '<div class="col-md-3 col-sm-6 col-xs-12"><div class="block-content clearfix">',
			'after_widget'  => '</div></div>',
			'before_title'  => '<h4 class="block-title">',
			'after_title'   => '</h4>',
		) );
		
	}
    register_sidebar( array(
        'name'          => __( 'Forum Widget Area', 'classiads' ),
        'id'            => 'forum',
        'description'   => __( 'Appears on posts and pages in the sidebar.', 'classiads' ),
        'before_widget' => '<div class="cat-widget"><div class="cat-widget-content">',
        'after_widget'  => '</div></div>',
        'before_title'  => '<div class="cat-widget-title"><h4>',
        'after_title'   => '</h4></div>',
    ) );

    register_sidebar( array(
        'name'          => __( 'Footer Subsribe Widget', 'classiads' ),
        'id'            => 'footer_subscribe_widget',
        'description'   => __( 'Footer Subsribe Widget will display upper of the footer.', 'classiads' ),
        'before_widget' => '<div class="cat-widget clearfix"><div class="cat-widget-content">',
        'after_widget'  => '</div></div>',
        'before_title'  => '<div class="cat-widget-title"><h4>',
        'after_title'   => '</h4></div>',
    ) );


	register_sidebar( array(
		'name'          => __( 'Pages Widget Area', 'classiads' ),
		'id'            => 'pages',
		'description'   => __( 'Appears on posts and pages in the sidebar.', 'classiads' ),
		'before_widget' => '<div class="cat-widget"><div class="cat-widget-content">',
		'after_widget'  => '</div></div>',
		'before_title'  => '<div class="cat-widget-title"><h5>',
		'after_title'   => '</h5></div>',
	) );

	register_sidebar( array(
		'name'          => __( 'Blog Widget Area', 'classiads' ),
		'id'            => 'blogsidebar',
		'description'   => __( 'Appears on BLog Archive and post in the sidebar.', 'classiads' ),
		'before_widget' => '<div class="cat-widget"><div class="cat-widget-content">',
		'after_widget'  => '</div></div>',
		'before_title'  => '<div class="cat-widget-title"><h5>',
		'after_title'   => '</h5></div>',
	) );

	register_sidebar( array(
		'name'          => __( 'Listing page Widget Area', 'classiads' ),
		'id'            => 'listing',
		'description'   => __( 'Appears on posts and pages in the sidebar.', 'classiads' ),
		'before_widget' => '<div class="cat-widget"><div class="cat-widget-content">',
		'after_widget'  => '</div></div>',
		'before_title'  => '<div class="cat-widget-title"><h5>',
		'after_title'   => '</h5></div>',
	) );
}

if ( ! function_exists( 'classiads_paging_nav' ) ) :
/**
 * Displays navigation to next/previous set of posts when applicable.
 *
 * @since classiads 1.2.2
 *
 * @return void
 */
function classiads_paging_nav() {
	global $wp_query;

	// Don't print empty markup if there's only one page.
	if ( $wp_query->max_num_pages < 2 )
		return;
	?>
	<nav class="navigation paging-navigation" role="navigation">
		<h1 class="screen-reader-text"><?php _e( 'Posts navigation', 'classiads' ); ?></h1>
		<div class="nav-links">

			<?php if ( get_next_posts_link() ) : ?>
			<div class="nav-previous"><?php next_posts_link( __( '<span class="meta-nav">&larr;</span> Older posts', 'classiads' ) ); ?></div>
			<?php endif; ?>

			<?php if ( get_previous_posts_link() ) : ?>
			<div class="nav-next"><?php previous_posts_link( __( 'Newer posts <span class="meta-nav">&rarr;</span>', 'classiads' ) ); ?></div>
			<?php endif; ?>

		</div><!-- .nav-links -->
	</nav><!-- .navigation -->
	<?php
}
endif;

if ( ! function_exists( 'classiads_post_nav' ) ) :
/**
 * Displays navigation to next/previous post when applicable.
*
* @since classiads 1.2.2
*
* @return void
*/
function classiads_post_nav() {
	global $post;

	// Don't print empty markup if there's nowhere to navigate.
	$previous = ( is_attachment() ) ? get_post( $post->post_parent ) : get_adjacent_post( false, '', true );
	$next     = get_adjacent_post( false, '', false );

	if ( ! $next && ! $previous )
		return;
	?>
	<nav class="navigation post-navigation" role="navigation">
		<h1 class="screen-reader-text"><?php _e( 'Post navigation', 'classiads' ); ?></h1>
		<div class="nav-links">

			<?php previous_post_link( '%link', _x( '<span class="meta-nav">&larr;</span> %title', 'Previous post link', 'classiads' ) ); ?>
			<?php next_post_link( '%link', _x( '%title <span class="meta-nav">&rarr;</span>', 'Next post link', 'classiads' ) ); ?>

		</div><!-- .nav-links -->
	</nav><!-- .navigation -->
	<?php
}
endif;

if ( ! function_exists( 'classiads_entry_meta' ) ) :
/**
 * Prints HTML with meta information for current post: categories, tags, permalink, author, and date.
 *
 * Create your own classiads_entry_meta() to override in a child theme.
 *
 * @since classiads 1.2.2
 *
 * @return void
 */
function classiads_entry_meta() {
	if ( is_sticky() && is_home() && ! is_paged() )
		echo '<span class="featured-post">' . __( 'Sticky', 'classiads' ) . '</span>';

	if ( ! has_post_format( 'link' ) && 'post' == get_post_type() )
		classiads_entry_date();

	// Translators: used between list items, there is a space after the comma.
	$categories_list = get_the_category_list( __( ', ', 'classiads' ) );
	if ( $categories_list ) {
		echo '<span class="categories-links">' . $categories_list . '</span>';
	}

	// Translators: used between list items, there is a space after the comma.
	$tag_list = get_the_tag_list( '', __( ', ', 'classiads' ) );
	if ( $tag_list ) {
		echo '<span class="tags-links">' . $tag_list . '</span>';
	}

	// Post author
	if ( 'post' == get_post_type() ) {
		printf( '<span class="author vcard"><a class="url fn n" href="%1$s" title="%2$s" rel="author">%3$s</a></span>',
			esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
			esc_attr( sprintf( __( 'View all posts by %s', 'classiads' ), get_the_author() ) ),
			get_the_author()
		);
	}
}
endif;

if ( ! function_exists( 'classiads_entry_date' ) ) :
/**
 * Prints HTML with date information for current post.
 *
 * Create your own classiads_entry_date() to override in a child theme.
 *
 * @since classiads 1.2.2
 *
 * @param boolean $echo Whether to echo the date. Default true.
 * @return string The HTML-formatted post date.
 */
function classiads_entry_date( $echo = true ) {
	if ( has_post_format( array( 'chat', 'status' ) ) )
		$format_prefix = _x( '%1$s on %2$s', '1: post format name. 2: date', 'classiads' );
	else
		$format_prefix = '%2$s';

	$date = sprintf( '<span class="date"><a href="%1$s" title="%2$s" rel="bookmark"><time class="entry-date" datetime="%3$s">%4$s</time></a></span>',
		esc_url( get_permalink() ),
		esc_attr( sprintf( __( 'Permalink to %s', 'classiads' ), the_title_attribute( 'echo=0' ) ) ),
		esc_attr( get_the_date( 'c' ) ),
		esc_html( sprintf( $format_prefix, get_post_format_string( get_post_format() ), get_the_date() ) )
	);

	if ( $echo )
		echo $date;

	return $date;
}
endif;

/**
 * Returns the URL from the post.
 *
 * @uses get_url_in_content() to get the URL in the post meta (if it exists) or
 * the first link found in the post content.
 *
 * Falls back to the post permalink if no URL is found in the post.
 *
 * @since classiads 1.2.2
 *
 * @return string The Link format URL.
 */
function classiads_get_link_url() {
	$content = get_the_content();
	$has_url = get_url_in_content( $content );

	return ( $has_url ) ? $has_url : apply_filters( 'the_permalink', get_permalink() );
}

/**
 * Extends the default WordPress body classes.
 *
 * Adds body classes to denote:
 * 1. Single or multiple authors.
 * 2. Active widgets in the sidebar to change the layout and spacing.
 * 3. When avatars are disabled in discussion settings.
 *
 * @since classiads 1.2.2
 *
 * @param array $classes A list of existing body class values.
 * @return array The filtered body class list.
 */
function classiads_body_class( $classes ) {
	global $redux_demo;
	$header_style = $redux_demo['header-style'];
	if ( ! is_multi_author() )
		$classes[] = 'single-author';

	if ( is_active_sidebar( 'sidebar-2' ) && ! is_attachment() && ! is_404() )
		$classes[] = 'sidebar';

	if ( ! get_option( 'show_avatars' ) )
		$classes[] = 'no-avatars';
	
	if( !empty( $header_style ) )
		$classes[] = 'body-header-'.$header_style;
	
	if ( is_search() ):
		
		$search_page_st = $redux_demo['search-page-st'];
		if( $search_page_st == 2 ){
		$classes[] = 'search-full-width';
		}
		
	endif;
	
	$header_position = classiads_options_meta_value('_header_position','header-position');
	
	if($header_position == '1'){
		
		$classes[] = 'page-header-pos-static';
		
	}elseif($header_position == '2'){
		
		$classes[] = 'page-header-pos-absolute';
		
	}elseif($header_position == '3'){
		
		$classes[] = 'page-header-pos-fixed';
		
	}

	return $classes;
}


/**
 * Adjusts content_width value for video post formats and attachment templates.
 *
 * @since classiads 1.2.2
 *
 * @return void
 */
function classiads_content_width() {
	global $content_width;

	if ( is_attachment() )
		$content_width = 724;
	elseif ( has_post_format( 'audio' ) )
		$content_width = 484;
}

/**
 * Add postMessage support for site title and description for the Customizer.
 *
 * @since classiads 1.2.2
 *
 * @param WP_Customize_Manager $wp_customize Customizer object.
 * @return void
 */
function classiads_customize_register( $wp_customize ) {
	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';
}


/**
 * Binds JavaScript handlers to make Customizer preview reload changes
 * asynchronously.
 *
 * @since classiads 1.2.2
 */
function classiads_customize_preview_js() {
	wp_enqueue_script( 'classiads-customizer', get_template_directory_uri() . '/js/theme-customizer.js', array( 'customize-preview' ), '20130226', true );
}


function the_titlesmall($before = '', $after = '', $echo = true, $length = false) { $title = get_the_title();

	if ( $length && is_numeric($length) ) {
		$title = substr( $title, 0, $length );
	}

	if ( strlen($title)> 0 ) {
		$title = apply_filters('the_titlesmall', $before . $title . $after, $before, $after);
		if ( $echo )
			echo $title;
		else
			return $title;
	}
}

add_action('template_redirect', 'add_scripts');

function add_scripts() {
    if (is_singular()) {
      add_thickbox();
    }
}
//Register tag cloud filter callback
add_filter('widget_tag_cloud_args', 'tag_widget_limit');

//Limit number of tags inside widget
function tag_widget_limit($args){
global $redux_demo;
 $tagsnumber= $redux_demo['tags_limit'];
//Check if taxonomy option inside widget is set to tags
if(isset($args['taxonomy']) && $args['taxonomy'] == 'post_tag'){
  $args['number'] = $tagsnumber; //Limit number of tags
}

return $args;
}

function wpcook_get_avatar_url($author_id, $size){
    $get_avatar = get_avatar( $author_id, $size );
    preg_match("/src='(.*?)'/i", $get_avatar, $matches);
    return ( $matches[1] );
}

if ( current_user_can('subscriber') && !current_user_can('upload_files') ) {
    add_action('admin_init', 'wpcook_allow_subscriber_uploads');
}
function wpcook_allow_subscriber_uploads() {
    $contributor = get_role('subscriber');
    $contributor->add_cap('upload_files');
	$contributor->add_cap('delete_published_posts');
}

if(is_page_template('template-edit-post.php')){
	add_filter( 'posts_where', 'wpcook_devplus_attachments_wpquery_where' );
	function wpcook_devplus_attachments_wpquery_where( $where ){
		global $current_user;

		if( is_user_logged_in() ){
			// we spreken over een ingelogde user
			if( isset( $_POST['action'] ) ){
				// library query
				if( $_POST['action'] == 'query-attachments' ){
					$where .= ' AND post_author='.$current_user->data->ID;
				}
			}
		}

		return $where;
	}
}	
add_action('after_setup_theme', 'remove_admin_bar');
function remove_admin_bar() {
	if (!current_user_can('administrator') && !is_admin()) {
	  show_admin_bar(false);
	}
}

add_action( 'wp', 'ad_expiry_schedule' );
/**
 * On an early action hook, check if the hook is scheduled - if not, schedule it.
 */ 
function ad_expiry_schedule() {
	if ( ! wp_next_scheduled( 'ad_expiry_event' ) ) {
		wp_schedule_event( time(), 'hourly', 'ad_expiry_event');
	}
}


add_action( 'ad_expiry_event', 'ad_expiry' );
/**
 * On the scheduled action hook, run a function.
 */
function ad_expiry() {
	global $wpdb;
	global $redux_demo;
	$daystogo = '';
	if (!empty($redux_demo['ad_expiry'])){
		$daystogo = $redux_demo['ad_expiry'];
		$sql =
		"UPDATE {$wpdb->posts}
		SET post_status = 'trash'
		WHERE (post_type = 'post' AND post_status = 'publish')
		AND DATEDIFF(NOW(), post_date) > %d";
		$wpdb->query($wpdb->prepare( $sql, $daystogo ));
	}
}

add_action( 'after_setup_theme', 'admin_featuredPlan' );
function admin_featuredPlan() {
global $wpdb;
	$wpdb->query('CREATE TABLE IF NOT EXISTS `wpcads_paypal` (
                      `main_id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY ,
                      `user_id` TEXT NOT NULL ,
                      `id` TEXT NOT NULL ,
                      `name` TEXT NOT NULL ,
                      `token` TEXT NOT NULL ,
                      `price` FLOAT UNSIGNED NOT NULL ,
                      `currency` TEXT NOT NULL ,
                      `ads` TEXT ,
                      `days` TEXT NOT NULL ,
                      `date` TEXT NOT NULL ,
                      `status` TEXT NOT NULL ,
                      `used` TEXT NOT NULL ,
                      `transaction_id` TEXT NOT NULL ,
                      `firstname` TEXT NOT NULL ,
                      `lastname` TEXT NOT NULL ,
                      `email` TEXT NOT NULL ,
                      `description` TEXT NOT NULL ,
                      `summary` TEXT NOT NULL ,
                      `created` INT( 4 ) UNSIGNED NOT NULL
                      ) ENGINE = MYISAM ;');
  $price_plan_information = array(
    'id' => '1',
    'user_id' => '1',
    'name' => '',
    'token' => "",
    'price' => '',
    'currency' => "",
    'ads' => 'unlimited',
    'days' => 'unlimited',
    'date' => date("m/d/Y H:i:s"),
    'status' => "success",
    'used' => "0",
    'transaction_id' => "",
    'firstname' => "",
    'lastname' => "",
    'email' => "",
    'description' => "",
    'summary' => "",
    'created' => time()
  );

  $insert_format = array('%s', '%s', '%s','%s', '%f', '%s', '%d', '%d', '%s', '%s', '%d', '%s', '%s', '%s', '%s', '%s', '%s');
 $result = $wpdb->get_results( "SELECT * FROM wpcads_paypal WHERE user_id = 1 ORDER BY main_id DESC" );

if (empty($result )) {

  $wpdb->insert('wpcads_paypal', $price_plan_information, $insert_format);
  }
}



function cubiq_login_init () {
    $action = isset($_REQUEST['action']) ? $_REQUEST['action'] : 'login';
	global $redux_demo;
	$login = $redux_demo['login'];
	$reset = '';
    if ( isset( $_POST['wp-submit'] ) ) {
        $action = 'post-data';
    } else if ( isset( $_GET['reauth'] ) ) {
        $action = 'reauth';
    } else if ( isset($_GET['key']) ) {
        $action = 'resetpass-key';
    }

    // redirect to change password form
    if ( $action == 'rp' || $action == 'resetpass' ) {
        wp_redirect( $login.'/?action=resetpass' );
        exit;
    }

	// redirect to change password form
    if ( $action == 'register') {
        wp_redirect( $login.'/?action=resetpass' );
        exit;
    }

    // redirect from wrong key when resetting password
    if ( $action == 'lostpassword' && isset($_GET['error']) && ( $_GET['error'] == 'expiredkey' || $_GET['error'] == 'invalidkey' ) ) {
        wp_redirect($reset.'/?action=forgot&failed=wrongkey' );
        exit;
    }

    if (
        $action == 'post-data'        ||            // don't mess with POST requests
        $action == 'reauth'           ||            // need to reauthorize
        $action == 'resetpass-key'    ||            // password recovery
        $action == 'logout'                         // user is logging out
    ) {
        return;
    }

    wp_redirect( home_url( '/login/' ) );
    exit;
}
add_action('login_init', 'cubiq_login_init');

function cubiq_registration_redirect ($errors, $sanitized_user_login, $user_email) {
	global $redux_demo;
	$login = $redux_demo['login'];
	$register = $redux_demo['register'];
    // don't lose your time with spammers, redirect them to a success page
    if ( !isset($_POST['confirm_email']) || $_POST['confirm_email'] !== '' ) {

        wp_redirect($login. '?action=register&success=1' );
        exit;

    }

    if ( !empty( $errors->errors) ) {
        if ( isset( $errors->errors['username_exists'] ) ) {

            wp_redirect( $register . '?action=register&failed=username_exists' );

        } else if ( isset( $errors->errors['email_exists'] ) ) {

            wp_redirect( $register . '?action=register&failed=email_exists' );

        } else if ( isset( $errors->errors['empty_username'] ) || isset( $errors->errors['empty_email'] ) ) {

            wp_redirect($register . '?action=register&failed=empty' );

        } else if ( !empty( $errors->errors ) ) {

            wp_redirect( $register . '?action=register&failed=generic' );

        }

        exit;
    }

    return $errors;

}
add_filter('registration_errors', 'cubiq_registration_redirect', 10, 3);

/*-----------------------------------------------------------------------------------*/
/*	Infinite Pagination
/*-----------------------------------------------------------------------------------*/

if (!function_exists('infinite')) {

	function infinite($query) {
		$pages = intval($query->max_num_pages);
		$paged = (get_query_var('paged')) ? intval(get_query_var('paged')) : 1;
		if (empty($pages)) {
			$pages = 1;
		}
		if (1 != $pages) {
			echo '<p class="jw-pagination jw-infinite-scroll simple-pagination" data-has-next="' . ($paged === $pages ? 'false' : 'true') . '">';
			echo '<a class="btn btn-small no-more" href="#"><i class="fa fa-refresh"></i>' . __('No more posts', 'classiads') . '</a>';
			echo '<a class="btn btn-small loading" href="#"><i class="fa fa-refresh"></i>' . __('Loading posts ...', 'classiads') . '</a>';
			echo '<a class="btn btn-small next" href="' . get_pagenum_link($paged + 1) . '"><i class="fa fa-refresh"></i>' . __('Load More ', 'classiads') . '</a>';
			echo '</p>';
			?>
			<div class="jw-pagination jw-infinite-scroll" data-has-next="<?php echo ($paged === $pages ? 'false' : 'true'); ?>">
				<div class="clearfix">

				</div>
				<div class="more-btn-main row m-b-60">
					<div class="col-xs-12">
						<div class="view-more-btn">
							<div class="more-btn-inner">
								<a class="next" href="<?php echo get_pagenum_link($paged + 1);?>">
									<i class="fa fa-refresh"></i>
									<span><?php _e( 'load more', 'classiads' ); ?></span>
								</a>
								<a class="loading">
									<i class="fa fa-refresh"></i>
									<span><?php _e( 'Loading posts ...', 'classiads' ); ?></span>
								</a>
								<a class="no-more">
									<i class="fa fa-refresh"></i>
									<span><?php _e( 'No more posts', 'classiads' ); ?></span>
								</a>
							</div>
						</div>
					</div>
				</div>
			</div>
			<?php
		}
	}

}

// Add custom meta (ratings) fields to the default comment form
// Default comment form includes name, email address and website URL
// Default comment form elements are hidden when user is logged in

add_filter('comment_form_default_fields', 'custom_fields');
function custom_fields($fields) {

    $commenter = wp_get_current_commenter();
    $req = get_option( 'require_name_email' );
    $aria_req = ( $req ? " aria-required='true'" : '' );

    $fields[ 'author' ] = '<p class="comment-form-author col-sm-6 col-xs-12">'.
      ( $req ? '' : '' ).
      '<input id="author" class="form-control" placeholder="Your Name" name="author" type="text" value="'. esc_attr( $commenter['comment_author'] ) .
      '" size="30" tabindex="1"' . $aria_req . ' /></p>';

    $fields[ 'email' ] = '<p class="comment-form-email col-sm-6 col-xs-12">'.
      ( $req ? '' : '' ).
      '<input id="email" class="form-control" name="email" placeholder="Your Email" type="text" value="'. esc_attr( $commenter['comment_author_email'] ) .
      '" size="30"  tabindex="2"' . $aria_req . ' /></p>';

    $fields[ 'url' ] = '';


    $fields[ 'subject' ] = '<p class="comment-form-subject col-xs-12">'.
      ''.
      '<input id="subject" class="form-control" placeholder="Subject" name="subject" type="text" size="30"  tabindex="4" /></p>';
	 $fields[ 'comment_field' ] =
        '<p class="comment-form-comment col-xs-12">
			<textarea class="form-control" id="comment" name="comment" placeholder="'.__( 'Write your message here...', 'classiads' ).'" cols="45" rows="8" aria-required="true" required="required"></textarea>
		</p>';

  return $fields;
}
function add_comment_meta_values($comment_id) {

    if(isset($_POST['subject'])) {
        $subject = wp_filter_nohtml_kses($_POST['subject']);
        add_comment_meta($comment_id, 'subject', $subject, false);
    }

}
add_action ('comment_post', 'add_comment_meta_values', 1);

function classiads_comment_field($comment_field)
{

    $comment_field =
        '<p class="comment-form-comment">
			<textarea id="comment" class="form-control" name="comment" placeholder="'.__( 'Write your message here...', 'classiads' ).'" cols="45" rows="8" aria-required="true" required="required"></textarea>
		</p>';

    return $comment_field;
}

if(is_user_logged_in()){
	add_filter('comment_form_field_comment', 'classiads_comment_field');
}

function remove_textarea($defaults)
{
    $defaults['comment_field'] = '';
    return $defaults;
}
if(!is_user_logged_in()){
add_filter( 'comment_form_defaults', 'remove_textarea' );
}


 // Add Class in Post Link

 add_filter('next_posts_link_attributes', 'posts_link_attributes');
add_filter('previous_posts_link_attributes', 'posts_link_attributes');

function posts_link_attributes() {
    return 'class="blog-btn"';
}

function afn_customize_excerpt_more( $more ) {
    return '... ';
}
add_filter('excerpt_more', 'afn_customize_excerpt_more');

add_action('wp_footer','scroll_header');
function scroll_header(){

	global $redux_demo;
	$header_sticky = $redux_demo['header-sticky'];
	if($header_sticky == 1){
	?>
			<script type='text/javascript'>
			jQuery(window).scroll(function() {
				if (jQuery(this).scrollTop() > 1){
					jQuery('header').addClass("header-sticky");
					jQuery('.sticky-logo').removeClass("dis");
					jQuery('.logo-img').addClass("dis");
				}
				else{
					jQuery('header').removeClass("header-sticky");
					jQuery('.sticky-logo').addClass("dis");
					jQuery('.logo-img').removeClass("dis");
				}
			});
		</script>
<?php }
}
	
function category_check() {
   if(is_category()){
	   return 'true';
   }else{
	   return 'false';
   }
}


// @classiads
// @developer waseemjutt
// @since 3.6
if (!function_exists('section_title_style')) {
	function section_title_style($sec_title, $sec_descrpition, $sec_title_bg_color){
		global $redux_demo;
		$section_title = $redux_demo['section-title-st'];
		
		if($section_title == '1'){ ?>
			<div class="section-header-style-1">
				<div class="row">
					<div class="col-xs-12">
						<?php if(!empty($sec_title)){ ?>
						<h2 class="main-title"><?php echo $sec_title; ?></h2>
						<?php } 
							if(!empty($sec_descrpition)){ ?>
						<div class="main-sub-title">
							<?php echo $sec_descrpition; ?>
						</div>
						<?php } ?>
						<div class="h2-seprator"></div>
					</div>
				</div>	
			</div>	
		<?php } elseif($section_title == '2'){ ?>
			<div class="section-header-style-2">
				<div class="row">
					<div class="col-xs-12">
						<?php if( !empty( $sec_title ) ){ ?>
						<h2 class="main-title"><?php echo esc_attr( $sec_title ); ?></h2>
						<div class="main-title-bottom">
							<div class="main-title-bottom-icon" <?php if(!empty($sec_title_bg_color)) { ?> style="background-color:<?php echo esc_attr( $sec_title_bg_color );?>;" <?php } ?>>
								<i class="fa fa-angle-down"></i>
							</div>
							<div class="h2-seprator" ></div>
						</div>
						<?php } ?>
					</div>
				</div>
			</div>
		<?php } elseif($section_title == '3'){ ?>
			<div class="section-header-style-3">
				<div class="row" >
					<div class="col-xs-12" >
						<?php if( !empty( $sec_title ) ){ ?>
							<h2 class="main-title"><?php echo esc_attr( $sec_title ); ?></h2>
						<?php } ?>
						<?php if( !empty( $sec_descrpition ) ){ ?>
						<div class="main-sub-title">
							<?php echo esc_attr( $sec_descrpition ); ?>
						</div>
						<?php } ?>
					</div>
				</div>
			</div>
		<?php }
	}
}

// Filter Email to HTML Email 
add_filter('wp_mail_content_type','set_content_type');
function set_content_type($content_type){
	return 'text/html';
}

// Classids Price Function
function classiads_price( $price ) {
	global $redux_demo;
	$free_listing_tag = $redux_demo['free_price_text'];
	$currency_setup = $redux_demo['currency-setup'];
	$deci = $redux_demo['currency-char-decimal'];
	$c_decimal = $redux_demo['currency-decimals'];
	if($currency_setup == 'cs-new'){
		if( empty($price) || $price == $free_listing_tag  ) {
			return $price;
		}
		$str = $price; 
		$str_arr = explode($deci,$str);
		if( isset( $str_arr[1] ) ){
			$str_arra = $deci.$str_arr[1];
		}else{
			$str_arra = $deci.$c_decimal;
		}
		$pricea = filter_var($str_arr[0], FILTER_SANITIZE_NUMBER_INT);
		
		global $redux_demo;
		if(!empty($pricea) || $pricea == 0){
			$number = number_format( $pricea, $redux_demo['currency-decimals'], $redux_demo['currency-char-decimal'], $redux_demo['currency-char-thousand']);
		}else{
			return $price;
		}
		if(($redux_demo['sign-code'] == 'sign' ) ) {
			$sign = $redux_demo['currency-sign'];
		} elseif(($redux_demo['sign-code'] == 'code' ) ) {
			$sign = $redux_demo['currency-code'];
		}
		if( $redux_demo['currency-position'] == 'p' ) {
			return $sign.$number.$str_arra;
		} else {
			return $number.$str_arra.$sign;
		}
	}elseif($currency_setup == 'cs-old'){	
		return $price;
	}
}

function ajax_category_loop(){
		
	$cl_cat_tit_limit = $_POST['box_cat_tit'];
	$ccounter = $_POST['ccounter'];
	$category_style = $_POST['cat_layout'];
	$box_quan = $_POST['box_quan'];
	
	category_boxes($cl_cat_tit_limit,$ccounter,$category_style,$box_quan);
		
	wp_die();			
}		

add_action('wp_ajax_ajax_category_loop', 'ajax_category_loop');
add_action('wp_ajax_nopriv_ajax_category_loop', 'ajax_category_loop');	

function category_boxes($cl_cat_tit_limit,$ccounter,$category_style,$box_quan,$cl_section_selected,$cl_cat_type = 'latest'){
	
	global $cl_cat_tit_limit2,$box_quan2,$ccounter2,$cl_section_selected2,$cl_cat_type2;
	
	$cl_cat_tit_limit2 =  $cl_cat_tit_limit;
	$box_quan2 =  $box_quan;
	$ccounter2 =  $ccounter;
	$cl_section_selected2 =  $cl_section_selected;
	$cl_cat_type2 =  $cl_cat_type;
	if($category_style == 1) {
		
		get_template_part('templates/category-boxes/category-box','1');
		
	}elseif($category_style == 2) {
		
		get_template_part('templates/category-boxes/category-box','2');
		
	}elseif($category_style == 3) {
		
		get_template_part('templates/category-boxes/category-box','3');
		
	}elseif($category_style == 4) {
		
		get_template_part('templates/category-boxes/category-box','4');
		
	}   
			
}		


function ajax_location_loop(){
		global $redux_demo;
		$ccounter = $_GET['ccounter'];
		$location_version = $_GET['loc_layout']; 
		$location_counter = $_GET['box_quan'];
		
		$locations = get_terms(
			'location', 
			array(
				'parent' => 0,
				'order'=> 'DESC',
				'hide_empty' => false,
				'offset' => $ccounter,
				'number'=> $location_counter,
				'empty'=> 1
			)	
		);
		if($location_version == 1){
			
			foreach ($locations as $location) {
				if(!empty($location)){
					
			?>
			<div class="col-md-3 col-sm-6 col-xs-12 locate-box">
				<div class="span3">
				<a href="<?php echo get_term_link( $location ); ?>"><i class="fa fa-map-marker"></i><?php echo wp_kses_post($location->name); ?></a>
		
				</div>
			</div>
			<?php 
				}
			} 
			
		}elseif($location_version == 2){
			
			foreach ($locations as $location) {
				if(!empty($location)){
				?>
				<div class="col-md-3 col-sm-6 col-xs-12 locate-box">
					<div class="span3">
						<a href="<?php echo get_term_link( $location ); ?>"><i class="fa fa-map-marker"></i><?php echo wp_kses_post($location->name); ?></a>
					</div>
				</div>
				<?php }
			}
			
		}elseif($location_version == 3){
			
			
				foreach ($locations as $location) {
						
						if(!empty($location)){
						$tag = $location->term_id;
						$term_meta = get_option( "taxonomy_term_$tag" );
							
			?>
				
				<div class="col-md-4 col-sm-6 col-xs-12 locate-box">
					<div class="location-box-inner">
						<div class="location-img">
						
							<img src="<?php  if (isset($term_meta["presenter_id"])) { echo $term_meta["presenter_id"];} ?>" />
							<a class="anchor-link" href="<?php echo get_term_link( $location ); ?>"></a>
						</div>
						<div class="location-content">
							<a href="<?php echo get_term_link( $location ); ?>"><?php echo wp_kses_post($location->name); ?></a>
							<p> <?php echo wp_kses_post($location->count); ?> <?php _e( 'Ads Available', 'classiads' ); ?></p>
						</div>
					</div>
				</div>
					<?php
					}
				
				} 
			
		}

	wp_die();			
}		
add_action('wp_ajax_ajax_location_loop', 'ajax_location_loop');
add_action('wp_ajax_nopriv_ajax_location_loop', 'ajax_location_loop');	


add_action('wp_ajax_search_posts', 'search_posts');
add_action('wp_ajax_nopriv_search_posts', 'search_posts');
function search_posts(){

	$ccounter = $_GET['ccounter'];
	$keyword = $_GET['keyword'];
	$cat = $_GET['cat'];
	$loc = $_GET['loc'];
	$min_price = $_GET['min_price'];
	$max_price = $_GET['max_price'];
	$geo_location = $_GET['geo_location'];
	$geo_radius_search2 = $_GET['geo_radius_search2'];
	$geo_search_lat = $_GET['geo_search_lat'];
	$geo_search_lng = $_GET['geo_search_lng'];
	
		
	$post_price = '';
	if(!empty($min_price) || !empty($max_price)){
		$post_price = array(
			'key' => 'post_price',
			'value' => array(  $min_price, $max_price ),
			'compare' => 'BETWEEN',
			'type' => 'numeric',
		);
	}
					
	$temp = $wp_query;
	$qw = array(
		'post_type' => 'post',
		'posts_per_page' => 16,
		's' => $keyword,
		'cat' => $cat,
		'location' => $loc,
		'meta_query' => array(
			$post_price
		),
		'offset' => $ccounter,
	);
	$wp_query = new WP_Query($qw);

	while ($wp_query->have_posts()) : $wp_query->the_post();
	
		if($geo_location == 'on') {
			$emptyPost2++;

			$post_latitude = get_post_meta($post->ID, 'post_latitude', true);
			$post_longitude = get_post_meta($post->ID, 'post_longitude', true);

			if(!empty($post_latitude)) {

				global $redux_demo;
				$measure_system = $redux_demo['measure-system'];

				if(!empty($measure_system)) {

					if($measure_system == "1") {

						$distance = 3958.755864232 * acos(sin($post_latitude / 57.2958) * sin($geo_search_lat / 57.2958) +cos($post_latitude / 57.2958) * cos($geo_search_lat / 57.2958) *cos($geo_search_lng / 57.2958 - $post_longitude / 57.2958));


					} else {

						$distance = 6371 * acos(sin($post_latitude / 57.2958) * sin($geo_search_lat / 57.2958) +cos($post_latitude / 57.2958) * cos($geo_search_lat / 57.2958) *cos($geo_search_lng / 57.2958 - $post_longitude / 57.2958));

					}

				} else {

					$distance = 6371 * acos(sin($post_latitude / 57.2958) * sin($geo_search_lat / 57.2958) +cos($post_latitude / 57.2958) * cos($geo_search_lat / 57.2958) *cos($geo_search_lng / 57.2958 - $post_longitude / 57.2958));

				}

				if( $distance <= $geo_radius_search ) {

					classiads_grid_loop($post->ID,'grid_view');
				} 

			} 
		
		}else{ 

			$emptyPost2++;
			classiads_grid_loop($post->ID,'grid_view');
	
		} 

		endwhile; 
	
	wp_die();	
	
}
// wp_dropdown_categoires Edit with data attribute 
function classiads_dropdown($output){
  return str_replace('<select','<select data-noResult="'.__("No results match","classiads").'"',$output);
}
add_filter('wp_dropdown_cats','classiads_dropdown');



// Pending Post Status Counter
add_filter( 'add_menu_classes', 'show_pending_number');
function show_pending_number( $menu ) {
    $type = "post";
    $status = "pending";
    $num_posts = wp_count_posts( $type, 'readable' );
    $pending_count = 0;
    if ( !empty($num_posts->$status) )
        $pending_count = $num_posts->$status;

    // build string to match in $menu array
    if ($type == 'post') {
        $menu_str = 'edit.php';
    } else {
        $menu_str = 'edit.php?post_type=' . $type;
    }

    // loop through $menu items, find match, add indicator
    foreach( $menu as $menu_key => $menu_data ) {
        if( $menu_str != $menu_data[2] )
            continue;
        $menu[$menu_key][0] .= " <span class='update-plugins count-$pending_count'><span class='plugin-count'>" . number_format_i18n($pending_count) . '</span></span>';
    }
    return $menu;
}
  

// Get User Avatar
if ( ! function_exists('cs_get_user_avatar') ) {

	function cs_get_user_avatar($size = 1, $cs_user_id = '') {

		if ( $cs_user_id != '' ) {
			$cs_user_avatars = get_the_author_meta('classiads_author_avatar_url', $cs_user_id);

			if ( is_array($cs_user_avatars) && isset($cs_user_avatars[$size]) ) {
				return $cs_user_avatars[$size];
			} else if ( ! is_array($cs_user_avatars) && $cs_user_avatars <> '' ) {
				return 'http://0.gravatar.com/avatar/6b4ee819723f1368f1d2d7459b62e41d?s=150&d=mm&r=g';
			}else{
				return 'http://0.gravatar.com/avatar/6b4ee819723f1368f1d2d7459b62e41d?s=150&d=mm&r=g';
			}
			
		}
	}

}

// User Avatar
if ( ! function_exists('cs_user_avatar') ) {
	function cs_user_avatar() {
		if ( is_user_logged_in() && isset($_FILES['user_avatar']) ) {

			$json = array();
			require_once ABSPATH . 'wp-admin/includes/image.php';
			require_once ABSPATH . 'wp-admin/includes/file.php';
			require_once ABSPATH . 'wp-admin/includes/media.php';
			$current_user_id = get_current_user_id();
			$cs_allowed_image_types = array(
				'jpg|jpeg|jpe' => 'image/jpeg',
				'png' => 'image/png',
				'gif' => 'image/gif',
			);
			$status = wp_handle_upload($_FILES['user_avatar'], array( 'test_form' => false ));

			if ( empty($status['error']) ) {
				$image = wp_get_image_editor($status['file']);
				if ( ! is_wp_error($image) ) {

					$sizes_array = array(
						array( 'width' => 270, 'height' => 203, 'crop' => true ),
						array( 'width' => 100, 'height' => 100, 'crop' => true ),
					);
					$resize = $image->multi_resize($sizes_array);
				}
				if ( is_wp_error($image) )
					wp_die($image->get_error_message());
				$uploads = wp_upload_dir();

				$resized_url1 = isset($resize[0]['file']) ? $uploads['url'] . '/' . basename($resize[0]['file']) : '';
				$resized_url2 = isset($resize[1]['file']) ? $uploads['url'] . '/' . basename($resize[1]['file']) : '';

				$resized_url = array( $resized_url1, $resized_url2 );

				update_user_meta($current_user_id, 'classiads_author_avatar_url', $resized_url);
				$cs_display_image = cs_get_user_avatar(0, $current_user_id);
				$cs_display_image2 = cs_get_user_avatar(1, $current_user_id);
				if ( $cs_display_image <> '' ) {
					$json['type'] = 'success';
					$json['message'] = 'success';
					$json['menu_icon'] = '<img width="60" src="' . esc_url($cs_display_image2) . '" alt="" />';
					$json['list_icon'] = '<img width="150" src="' . esc_url($cs_display_image) . '" alt="" />';
				} else {
					update_user_meta($current_user_id, 'classiads_author_avatar_url', array());
					$json['type'] = 'error';
					$json['message'] = 'Please upload Image of required size.';
				}
			} else {
				$json['type'] = 'error';
				$json['message'] = 'error';
			}
			echo json_encode($json);
			die;
		}
		
	}
}

// User File upload

if ( ! function_exists('cs_user_avatar_upload') ) {

	function cs_user_avatar_upload() {

		if ( isset($_FILES['user_avatar']['error']) && $_FILES['user_avatar']['error'] == 0 ) {
			cs_user_avatar();
		}
		die();
	}

}

/*
 * @ Alow Spcial Char For Textfield 
 *
 */
function cs_allow_special_char($input = '') {
    $output = $input;
    return $output;
}

add_action('wp_ajax_cs_user_avatar_upload', 'cs_user_avatar_upload');


/*
* Insert Media Attachment
******/
if ( !function_exists('classiads_insert_attachment') ){
	
	function classiads_insert_attachment($file_handler,$post_id,$set_thu=false) {
		// check to make sure its a successful upload
		if ($_FILES[$file_handler]['error'] !== UPLOAD_ERR_OK) __return_false();

		require_once(ABSPATH . "wp-admin" . '/includes/image.php');
		require_once(ABSPATH . "wp-admin" . '/includes/file.php');
		require_once(ABSPATH . "wp-admin" . '/includes/media.php');

		$attach_id = media_handle_upload( $file_handler, 0);
		return $attach_id;
	}

}

/*
* Property Media Upload
******/
if(! function_exists('classiads_post_media_upload')){
	
	function classiads_post_media_upload(){
		if ( $_FILES ) {
		$files = $_FILES['file'];
		$user = $_POST['user_id'];
		foreach ($files['name'] as $key => $value) {
			if ($files['name'][$key]) {
				$file = array(
					'name'     => $files['name'][$key],
					'type'     => $files['type'][$key],
					'tmp_name' => $files['tmp_name'][$key],
					'error'    => $files['error'][$key],
					'size'     => $files['size'][$key]
					);

					$_FILES = array("file" => $file);
					foreach ($_FILES as $file => $array) {
						$newupload = classiads_insert_attachment($file);
					}
					echo json_encode( array(
						'success' => true,
						'parent_id'  => $newupload,
					));	
				}
			}
		}
		wp_die();
	}
	add_action('wp_ajax_classiads_post_media_upload','classiads_post_media_upload');
	add_action('wp_ajax_nopriv_classiads_post_media_upload','classiads_post_media_upload');
}

function classiads_filter_pre_get_posts( $query ) {
    if ( ( is_category() || is_tag() ) && $query->is_main_query ) {
        $query->set( 'posts_per_page', 12 );
    }
}
add_action( 'pre_get_posts', 'classiads_filter_pre_get_posts' );
function filter_post_for_editor($qry) {
	
	if(is_page_template('template-edit-post.php')){
		
		if (current_user_can('edit_posts')) {
			
			$qry->set('post_status', array('publish','pending','draft','inherit','private'));
			
		}
	}
	
}
add_action('pre_get_posts','filter_post_for_editor');

function classiads_search_get_query($page) {
	
		global $redux_demo, $maximRange, $wp_query, $wp, $paged, $post;
		$min_price = $max_price = '';
		// Retrieve the URL variables (using PHP).
		$keyword = $_GET['s'];
		$post_location_search = $_GET['post_location'];
		$category_name = $_GET['category_name'];
		if( isset( $_GET['min-price'] ) ){
			$min_price = $_GET['min-price'];
		}
		if( isset( $_GET['max-price'] ) ){
			$max_price = $_GET['max-price'];
		}
		if($category_name != "All") {
				$thisCat = get_category(get_query_var('cat'),false);
				$catSearchID = $thisCat->term_id;

		} else {
			$catSearchID = '';
		}

		if($keyword == "all") {
			$keyword = '';
		} else {
			$keyword = $keyword;
		}
		if($post_location_search == "All") {
			$p_location_search = '';
		} else {
			$p_location_search = $post_location_search;
		}
	$post_price = '';
	if(!empty($min_price) || !empty($max_price)){
		$post_price = array(
			'key' => 'post_price',
			'value' => array(  $min_price, $max_price ),
			'compare' => 'BETWEEN',
			'type' => 'numeric',
		);
	}
	$query = array(
		'post_type' => 'post',
		'posts_per_page' => 16,
		's' => $keyword,
		'cat' => $catSearchID,
		'location' => $p_location_search,
		'meta_query' => array(
			$post_price
		),
		'paged' => $page,
	);
	
	return $query;
}

