<?php
/**
 * Template name: Profile Page
 *
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage classiads
 * @since classiads 1.2.2
 */

		
global $user_ID,$w_sidebar;
$w_sidebar = true;
$author = get_user_by( 'slug', get_query_var( 'author_name' ) ); $user_ID = $author->ID;

get_header();

	global $redux_demo, $maximRange;
	$max_range = $redux_demo['max_range'];
	$ads_title_limit = $redux_demo['home-ads-title-limit'];
	if(!empty($max_range)) {
		$maximRange = $max_range;
	} else {
		$maximRange = 1000;
	}
global $redux_demo;

$contact_email = get_the_author_meta( 'user_email', $user_ID );
$wpcrown_contact_email_error = $redux_demo['contact-email-error'];
$wpcrown_contact_name_error = $redux_demo['contact-name-error'];
$wpcrown_contact_message_error = $redux_demo['contact-message-error'];
$wpcrown_contact_thankyou = $redux_demo['contact-thankyou-message'];

global $nameError;
global $emailError;
global $commentError;
global $subjectError;
global $humanTestError;

$facebook = get_the_author_meta('facebook', $user_ID);
$google = get_the_author_meta('google', $user_ID);
$twitter = get_the_author_meta('twitter', $user_ID);
$linkedin = get_the_author_meta('linkedin', $user_ID);
$instagram = get_the_author_meta('instagram', $user_ID);

//If the form is submitted
if(isset($_POST['submitted'])) {

		//Check to make sure that the name field is not empty
		if(trim($_POST['contactName']) === '') {
			$nameError = $wpcrown_contact_name_error;
			$hasError = true;
		} elseif(trim($_POST['contactName']) === 'Name*') {
			$nameError = $wpcrown_contact_name_error;
			$hasError = true;
		}	else {
			$name = trim($_POST['contactName']);
		}

		//Check to make sure that the subject field is not empty
		if(trim($_POST['subject']) === '') {
			$subjectError = $wpcrown_contact_subject_error;
			$hasError = true;
		} elseif(trim($_POST['subject']) === 'Subject*') {
			$subjectError = $wpcrown_contact_subject_error;
			$hasError = true;
		}	else {
			$subject = trim($_POST['subject']);
		}

		//Check to make sure sure that a valid email address is submitted
		if(trim($_POST['email']) === '')  {
			$emailError = $wpcrown_contact_email_error;
			$hasError = true;
		} else if (!preg_match('/[a-z||0-9]@[a-z||0-9].[a-z]/', trim($_POST['email']))) {
			$emailError = $wpcrown_contact_email_error;
			$hasError = true;
		} else {
			$email = trim($_POST['email']);
		}

		//Check to make sure comments were entered
		if(trim($_POST['comments']) === '') {
			$commentError = $wpcrown_contact_message_error;
			$hasError = true;
		} else {
			if(function_exists('stripslashes')) {
				$comments = stripslashes(trim($_POST['comments']));
			} else {
				$comments = trim($_POST['comments']);
			}
		}

		//Check to make sure that the human test field is not empty
		if(trim($_POST['humanTest']) != '8') {
			$humanTestError = "Not Human :(";
			$hasError = true;
		} else {

		}

		//If there is no error, send the email
		if(!isset($hasError)) {

			$emailTo = $contact_email;
			$subject = $subject;
			$body = "Name: $name \n\nEmail: $email \n\nMessage: $comments";
			$headers = 'From <'.$emailTo.'>' . "\r\n" . 'Reply-To: ' . $email;

			wp_mail($emailTo, $subject, $body, $headers);

			$emailSent = true;

	}
}

?>
	<div class="ad-title">

        <h2><?php esc_html_e( 'ADS BY', 'classiads' ); ?> <?php echo get_the_author_meta('display_name', $user_ID ); ?></h2>

	</div>
		<?php
			$gridStyle = $redux_demo['home-ads-style']; /*Grid Style ID*/

		?>
	<div class="container">
		<div class="row margin-top-80">
			<div class="col-md-9 col-sm-12 col-xs-12">
			<div class="margin-bottom-50 clearfix">
				<h5 class="margin-top-0"><?php esc_html_e( 'AUTHOR PROFILE', 'classiads' ); ?></h5>
					<div class="h3-seprator "></div>

				<div class="full profile-content">
					<div class="col-md-6 col-sm-12 col-xs-12 profile-list">
						<span class="author-details"><i class="fa fa-phone"></i><?php esc_html_e( 'Phone:', 'classiads' ); ?> <?php the_author_meta('phone', $user_ID); ?></span>

						<span class="author-details"><i class="fa fa-envelope"></i><?php esc_html_e( 'Email:', 'classiads' ); ?> <a href="mailto:<?php echo get_the_author_meta('user_email', $user_ID); ?>"><?php echo get_the_author_meta('user_email', $user_ID); ?></a></span>

						<span class="author-details"><i class="fa fa-globe"></i><?php esc_html_e( 'Website:', 'classiads' ); ?> <a href="<?php the_author_meta('user_url', $user_ID); ?>"><?php the_author_meta('user_url', $user_ID); ?></a></span>

						<span class="author-details"><i class="fa fa-map-marker"></i><?php esc_html_e( 'Address:', 'classiads' ); ?> <?php the_author_meta('address', $user_ID); ?></span>

						<div class="clearfix"></div>
						<div class="author-social clearfix">

							<?php if(!empty($facebook)){ ?>
							<span class="author-details">
								<a target="_blank" href="<?php echo $facebook; ?>">
									<i class="fa fa-facebook"></i>
								</a>
							</span>
							<?php } ?>
							<?php if(!empty($google)){ ?>
							<span class="author-details">
								<a target="_blank" href="<?php echo $google; ?>">
									<i class="fa fa-google"></i>
								</a>
							</span>
							<?php } ?>
							<?php if(!empty($twitter)){ ?>
							<span class="author-details">
								<a target="_blank" href="<?php echo $twitter; ?>">
									<i class="fa fa-twitter"></i>
								</a>
							</span>
							<?php } ?>
							<?php if(!empty($linkedin)){ ?>
							<span class="author-details">
								<a target="_blank" href="<?php echo $linkedin; ?>">
									<i class="fa fa-linkedin"></i>
								</a>
							</span>
							<?php } ?>
							<?php if(!empty($instagram)){ ?>
							<span class="author-details">
								<a target="_blank" href="<?php echo $instagram; ?>">
									<i class="fa fa-instagram"></i>
								</a>
							</span>
							<?php } ?>
						</div>
					</div>
					<div class="col-md-6 col-sm-12 col-xs-12 description">
						<h5 ><?php esc_html_e( 'DESCRIPTION', 'classiads' ); ?></h5>

						<div class="author-description"><?php  $author_desc = get_the_author_meta('description', $user_ID); echo $author_desc; ?></div>

					</div>

				</div>

			</div>
			<div class="clearfix">
			<?php
				if($gridStyle == 1) {
			?>
				<section id="ads-homepage" class="category-page-ads grid-vr-1">
						<div class="pane latest-ads-holder">

							<div class="classiads-grid-holder row">

							<?php

								global $paged, $wp_query, $wp;

								$args = wp_parse_args($wp->matched_query);

								if ( !empty ( $args['paged'] ) && 0 == $paged ) {

									$wp_query->set('paged', $args['paged']);

									$paged = $args['paged'];

								}

								$cat_id = get_cat_ID(single_cat_title('', false));

								$temp = $wp_query;

								

								$wp_query = new WP_Query();

								$wp_query->query('post_type=post&posts_per_page=12&paged='.$paged.'&cat='.$cat_id.'&author='.$user_ID);

								$current = -1;
								$current2 = 0;

								?>

								<?php while ($wp_query->have_posts()) : $wp_query->the_post(); $current++; $current2++; ?>
			
								<?php get_template_part('templates/loop/grid-loop-1'); ?>
			
								<?php endwhile; ?>

							</div>

						<!-- Begin wpcrown_pagination-->
						<?php get_template_part('pagination'); ?>
						<!-- End wpcrown_pagination-->

						<?php wp_reset_query(); ?>

						</div>
				</section>

			<?php  }elseif($gridStyle == 2){ ?>

				<section id="ads-homepage" class="category-page-ads grid-vr-2">
					<div class="pane latest-ads-holder">

							<div class="classiads-grid-holder row">

							<?php

								global $paged, $wp_query, $wp;

								$args = wp_parse_args($wp->matched_query);

								if ( !empty ( $args['paged'] ) && 0 == $paged ) {

									$wp_query->set('paged', $args['paged']);

									$paged = $args['paged'];

								}

								$cat_id = get_cat_ID(single_cat_title('', false));

								$temp = $wp_query;

								

								$wp_query = new WP_Query();

								$wp_query->query('post_type=post&posts_per_page=12&paged='.$paged.'&cat='.$cat_id.'&author='.$user_ID);

								$current = -1;
								$current2 = 0;

								?>

								<?php while ($wp_query->have_posts()) : $wp_query->the_post(); $current++; $current2++; ?>
									<?php get_template_part('templates/loop/grid-loop-2'); ?>
								<?php endwhile; ?>

							</div>

						<!-- Begin wpcrown_pagination-->
						<?php get_template_part('pagination'); ?>
						<!-- End wpcrown_pagination-->

						<?php wp_reset_query(); ?>

						</div>
				</section>

			<?php  }elseif($gridStyle == 3){ ?>

				<section id="ads-homepage" class="category-page-ads  grid-vr-3">
						<div class="pane latest-ads-holder">

							<div class="classiads-grid-holder row">

							<?php

								global $paged, $wp_query, $wp;

								$args = wp_parse_args($wp->matched_query);

								if ( !empty ( $args['paged'] ) && 0 == $paged ) {

									$wp_query->set('paged', $args['paged']);

									$paged = $args['paged'];

								}

								$cat_id = get_cat_ID(single_cat_title('', false));

								$temp = $wp_query;

								

								$wp_query = new WP_Query();

								$wp_query->query('post_type=post&posts_per_page=12&paged='.$paged.'&cat='.$cat_id.'&author='.$user_ID);

								$current = -1;
								$current2 = 0;

								?>

								<?php while ($wp_query->have_posts()) : $wp_query->the_post(); $current++; $current2++; ?>
									<?php get_template_part('templates/loop/grid-loop-3'); ?>
								<?php endwhile; ?>

							</div>

						<!-- Begin wpcrown_pagination-->
						<?php get_template_part('pagination'); ?>
						<!-- End wpcrown_pagination-->

						<?php wp_reset_query(); ?>

						</div>
				</section>

			<?php } ?>
				<div class="full">
					<h5><?php _e( 'LEAVE MESSAGE TO AUTHOR', 'classiads' ); ?></h5>
					<div class="h3-seprator"></div>

					<div id="contact-ad-owner-v2">

						<?php if(isset($emailSent) && $emailSent == true) { ?>

							<div class="full">
								<h5><?php echo $wpcrown_contact_thankyou ?></h5>
							</div>

						<?php } else { ?>

						<?php if($nameError != '') { ?>
							<div class="full">
								<h5><?php echo $nameError;?></h5>
							</div>
						<?php } ?>

						<?php if($emailError != '') { ?>
							<div class="full">
								<h5><?php echo $emailError;?></h5>
							</div>
						<?php } ?>

						<?php if($subjectError != '') { ?>
							<div class="full">
								<h5><?php echo $subjectError;?></h5>
							</div>
						<?php } ?>

						<?php if($commentError != '') { ?>
							<div class="full">
								<h5><?php echo $commentError;?></h5>
							</div>
						<?php } ?>

						<?php if($humanTestError != '') { ?>
							<div class="full">
								<h5><?php echo $humanTestError;?></h5>
							</div>
						<?php } ?>

						<form name="contactForm" action="" id="contact-form" method="post" class="contactform row" >
							<div class="col-md-6 col-sm-12 col-xs-12">
								<input type="text" placeholder="<?php esc_html_e( 'Full Name', 'classiads' ); ?>" name="contactName" id="contactName" class="form-control" />
							</div>
							<div class="col-md-6 col-sm-12 col-xs-12">
								<input type="text" placeholder="<?php esc_html_e( 'Email', 'classiads' ); ?>" name="email" id="email" class="form-control"/>
							</div>
							<div class="col-xs-12">
								<input type="text" placeholder="<?php esc_html_e( 'Subject', 'classiads' ); ?>" name="subject" id="subject" class="form-control" />
							</div>
							<div class="col-xs-12">
								<textarea class="form-control" placeholder="<?php esc_html_e( 'Write your message here...', 'classiads' ); ?>" name="comments" id="commentsText" cols="8" rows="5" ></textarea>
							</div>
							<div class="col-md-6 col-sm-12 col-xs-12">
								<p class="humantest"><?php esc_html_e("Human Test: Find the X &nbsp; &nbsp; Value 5 + 3 = X  ", "classiads"); ?></p>
							</div>
							<div class="col-md-6 col-sm-12 col-xs-12">
								<input type="text" placeholder="<?php esc_html_e( 'Your answer', 'classiads' ); ?>" name="humanTest" id="humanTest" value="" class="form-control" />
							</div>
							<div class="col-xs-12">
								<input name="submitted" type="submit" value="<?php esc_html_e( 'Send Message', 'classiads' ); ?>" class="input-submit"/>
							</div>
						</form>

						<?php } ?>

					</div>

				</div>

			</div>
			</div>
			<div class="col-md-3 col-sm-12 col-xs-12 classi_sidebar">
				<?php get_sidebar('pages'); ?>
			</div>
		</div>
		</div>
	</div>


<?php get_footer(); ?>
