<?php
/**
 * The template for displaying Archive pages.
 *
 * Used to display archive-type pages if nothing more specific matches a query.
 * For example, puts together date-based pages if no date.php file exists.
 *
 * If you'd like to further customize these archive views, you may create a
 * new template file for each specific one. For example, Twenty Thirteen
 * already has tag.php for Tag archives, category.php for Category archives,
 * and author.php for Author archives.
 *
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage classiads
 * @since classiads 1.2.2
 */

get_header();

	global $redux_demo, $maximRange;
	$max_range = $redux_demo['max_range'];
	$ads_title_limit = $redux_demo['home-ads-title-limit'];

	if(!empty($max_range)) {
		$maximRange = $max_range;
	} else {
		$maximRange = 1000;
	}
	$hide_map = $redux_demo['hide-map'];
?>

	<div class="ad-title" style="margin-bottom:0px;">

        	<h2>
        		<?php

        		global $paged, $wp_query, $wp;


					if ( is_day() ) :

								printf( __( 'Daily Archives: %s', 'classiads' ), get_the_date() );
								$archive_year  = get_the_date('Y');
								$archive_month = get_the_date('m');
								$archive_day   = get_the_date('d');
								global $args; 
								$args = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'monthnum' => $archive_month, 'day' => $archive_day, 'order' => 'DESC', 'post_type' => 'post');
								global $args_popular; 
								$args_popular = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'monthnum' => $archive_month, 'day' => $archive_day, 'post_type' => 'post', 'meta_key' => 'wpb_post_views_count', 'orderby' => 'meta_value_num', 'order' => 'DESC');
								global $args_random; 
								$args_random = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'monthnum' => $archive_month, 'day' => $archive_day, 'order' => 'DESC', 'post_type' => 'post', 'orderby' => 'title');

					elseif ( is_month() ) :

								printf( __( 'Monthly Archives: %s', 'classiads' ), get_the_date( _x( 'F Y', 'monthly archives date format', 'classiads' ) ) );
								$archive_year  = get_the_date('Y');
								$archive_month = get_the_date('m');
								global $args; 
								$args = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'monthnum' => $archive_month, 'order' => 'DESC', 'post_type' => 'post');
								global $args_popular; 
								$args_popular = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'monthnum' => $archive_month, 'post_type' => 'post', 'meta_key' => 'wpb_post_views_count', 'orderby' => 'meta_value_num', 'order' => 'DESC');
								global $args_random; 
								$args_random = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'monthnum' => $archive_month, 'order' => 'DESC', 'post_type' => 'post', 'orderby' => 'title');

					elseif ( is_year() ) :

								printf( __( 'Yearly Archives: %s', 'classiads' ), get_the_date( _x( 'Y', 'yearly archives date format', 'classiads' ) ) );
								$archive_year  = get_the_date('Y');
								global $args; 
								$args = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'order' => 'DESC');
								global $args_popular; 
								$args_popular = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'meta_key' => 'wpb_post_views_count', 'orderby' => 'meta_value_num', 'order' => 'DESC');
								global $args_random; 
								$args_random = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'order' => 'DESC', 'orderby' => 'title');

					elseif ( is_tag() ) :

								printf( single_tag_title(__('Tag: ','classiads') ) );

								global $wp_query;
								$tag = $wp_query->get_queried_object();
								$current_tag = $tag->term_id;

								global $args; 
								$args = array('paged' => $paged, 'posts_per_page' => 9, 'tag_id' => $current_tag, 'order' => 'DESC');
								global $args_popular; 
								$args_popular = array('paged' => $paged, 'posts_per_page' => 9, 'tag_id' => $current_tag, 'meta_key' => 'wpb_post_views_count', 'orderby' => 'meta_value_num', 'order' => 'DESC');
								global $args_random; 
								$args_random = array('paged' => $paged, 'posts_per_page' => 9, 'tag_id' => $current_tag, 'order' => 'DESC', 'orderby' => 'title');

					else :

								_e( 'Archives', 'classiads' );

					endif;
				?>
        	</h2>

        </div>

    <section id="big-map" <?php if($hide_map != 1){ echo 'class="map-hide"';} ?>>
<?php

	if($hide_map == 1){
 ?>
		<div id="classiads-main-map"></div>

		<script type="text/javascript">
		var mapDiv,
			map,
			infobox;
		jQuery(document).ready(function($) {

			mapDiv = jQuery("#classiads-main-map");
			mapDiv.height(650).gmap3({
				map: {
					options: {
						"draggable": true
						,"mapTypeControl": true
						,"mapTypeId": google.maps.MapTypeId.ROADMAP
						,"scrollwheel": false
						,"panControl": true
						,"rotateControl": false
						,"scaleControl": true
						,"streetViewControl": true
						,"zoomControl": true
						<?php global $redux_demo; $map_style = $redux_demo['map-style']; if(!empty($map_style)) { ?>,"styles": <?php echo $map_style; ?> <?php } ?>
					}
				}
				,marker: {
					values: [

					<?php

						global $redux_demo;
						$gridStyle = $redux_demo['home-ads-style']; /*Grid Style ID*/

						

						$wp_query = new WP_Query();

						$wp_query->query($args);

						while ($wp_query->have_posts()) : $wp_query->the_post();

						$post_latitude = get_post_meta($post->ID, 'post_latitude', true);
						$post_longitude = get_post_meta($post->ID, 'post_longitude', true);

						$theTitle = get_the_title(); $theTitle = (strlen($theTitle) > 40) ? substr($theTitle,0,37).'...' : $theTitle;

						$post_price = get_post_meta($post->ID, 'post_price', true);


						$category = get_the_category();

						$tag = $category[0]->cat_ID;

							$tag_extra_fields = get_option(MY_CATEGORY_FIELDS);
							if (isset($tag_extra_fields[$tag])) {
								$category_icon_code = $tag_extra_fields[$tag]['category_icon_code'];
								$category_icon_color = $tag_extra_fields[$tag]['category_icon_color'];
								$your_image_url = $tag_extra_fields[$tag]['your_image_url'];
							}

						if (empty($category_icon_code) || empty($category_icon_color) || empty($your_image_url)) {

							$tag = $category[0]->category_parent;

							$tag_extra_fields = get_option(MY_CATEGORY_FIELDS);
							if (isset($tag_extra_fields[$tag])) {
								if (empty($category_icon_code)){
									$category_icon_code = $tag_extra_fields[$tag]['category_icon_code'];
								}
								if (empty($category_icon_color)){
									$category_icon_color = $tag_extra_fields[$tag]['category_icon_color'];
								}
								if (empty($your_image_url)){
									$your_image_url = $tag_extra_fields[$tag]['your_image_url'];
								}
							}

						}
						if(!empty($category_icon_code)) {

							$category_icon = stripslashes($category_icon_code);

					     }
						if(!empty($your_image_url)) {

					    	$iconPath = $your_image_url;

					    } else {

					    	$iconPath = get_template_directory_uri() .'/images/icon-services.png';

					    }

						if(!empty($post_latitude)) {?>

							 	{
							 		<?php require_once(TEMPLATEPATH . "/inc/BFI_Thumb.php"); ?>
									<?php $params = array( "width" => 370, "height" => 240, "crop" => true ); $image = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), "single-post-thumbnail" ); ?>

									latLng: [<?php echo $post_latitude; ?>,<?php echo $post_longitude; ?>],
									options: {
										icon: "<?php echo $iconPath; ?>",
										shadow: "<?php echo get_template_directory_uri() ?>/images/shadow.png",
									},
									<?php

									if($gridStyle == 1) {
									?>

									data: '<div class="marker-holder map-box-style-1"><div class="marker-content"><div class="marker-image"><img src="<?php echo bfi_thumb( "$image[0]", $params ) ?>" /></div><div class="marker-info-holder"><div class="marker-info-price"><?php echo classiads_price(esc_attr($post_price, 'classiads')); ?></div><div class="marker-info"><div class="marker-info-title"><a href="<?php the_permalink(); ?>"><?php echo $theTitle; ?></a></div><?php if(!empty($category_icon_code)) { ?><div class="marker-icon-box" ><div class="category-icon-box" style="background-color:<?php echo $category_icon_color; ?>"><?php echo $category_icon; ?></div></div><?php } ?></div></div><div class="arrow-down"></div><div class="close"></div></div></div>'
									<?php
									}
									if($gridStyle == 2) {

									?>

									data: '<div class="marker-holder map-box-style-2"><div class="marker-content"><div class="marker-image"><img src="<?php echo bfi_thumb( "$image[0]", $params ) ?>" /></div><div class="marker-info-holder"><div class="add-price"><span><?php echo classiads_price(esc_attr($post_price, 'classiads')); ?></span><div class="pacman"></div></div><div class="marker-info"><div class="marker-info-left"><div class="marker-info-title"><a href="<?php the_permalink(); ?>"><?php echo $theTitle; ?></a></div><a class="feat-category" href="<?php echo get_category_link( $category[0]->term_id ); ?>"><?php echo $category[0]->name; ?></a></div><?php if(!empty($category_icon_code)) { ?><?php echo '<style>.map-box-style-2 .category-icon-box i{color:'.$category_icon_color.' !important;}</style>' ; ?><div class="marker-icon-box marker-info-right" ><div class="category-icon-box" style="border:1px solid <?php echo $category_icon_color; ?>;color:<?php echo $category_icon_color; ?> !important;"><?php echo $category_icon; ?></div><div class="category-icon-box-hover" style="background-color:<?php echo $category_icon_color; ?>;color:#fff;border-color:<?php echo $category_icon_color; ?>;"><?php echo $category_icon; ?></div></div><?php } ?></div></div><div class="arrow-down"></div><div class="close"></div></div></div>'
									<?php
									}
									if($gridStyle == 3) {
									?>

									data: '<div class="marker-holder map-box-style-3"><div class="marker-content"><div class="marker-image"><img src="<?php echo bfi_thumb( "$image[0]", $params ) ?>" /></div><div class="marker-info-holder"><div class="map-category-icon-3"><?php if(!empty($category_icon_code)) { ?><div class="marker-icon-box" ><div class="category-icon-box" style="background-color:<?php echo $category_icon_color; ?>"><?php echo $category_icon; ?></div></div><?php } ?></div><div class="marker-info"><div class="marker-info-title"><a href="<?php the_permalink(); ?>"><?php echo $theTitle; ?></a></div><div class="map-category-bottom-3"><a class="feat-category" href="<?php echo get_category_link( $category[0]->term_id ); ?>"><?php echo $category[0]->name; ?></a><div class="marker-info-price"><?php echo classiads_price(esc_attr($post_price, 'classiads')); ?></div></div></div></div><div class="arrow-down"></div><div class="close"></div></div></div>'
									<?php
									}
									?>

								}
							,

					<?php } endwhile; ?>

					<?php wp_reset_query(); ?>

					],
					options:{
						draggable: false
					},
					cluster:{
		          		radius: 20,
						// This style will be used for clusters with more than 0 markers
						0: {
							content: "<div class='cluster cluster-1'>CLUSTER_COUNT</div>",
							width: 62,
							height: 62
						},
						// This style will be used for clusters with more than 20 markers
						20: {
							content: "<div class='cluster cluster-2'>CLUSTER_COUNT</div>",
							width: 82,
							height: 82
						},
						// This style will be used for clusters with more than 50 markers
						50: {
							content: "<div class='cluster cluster-3'>CLUSTER_COUNT</div>",
							width: 102,
							height: 102
						},
						events: {
							click: function(cluster) {
								map.panTo(cluster.main.getPosition());
								map.setZoom(map.getZoom() + 2);
							}
						}
		          	},
					events: {
						click: function(marker, event, context){
							map.panTo(marker.getPosition());

							var ibOptions = {
							    pixelOffset: new google.maps.Size(-125, -88),
							    alignBottom: true
							};

							infobox.setOptions(ibOptions)

							infobox.setContent(context.data);
							infobox.open(map,marker);

							// if map is small
							var iWidth = 370;
							var iHeight = 370;
							if((mapDiv.width() / 2) < iWidth ){
								var offsetX = iWidth - (mapDiv.width() / 2);
								map.panBy(offsetX,0);
							}
							if((mapDiv.height() / 2) < iHeight ){
								var offsetY = -(iHeight - (mapDiv.height() / 2));
								map.panBy(0,offsetY);
							}

						}
					}
				}
				 		 	},"autofit");

			map = mapDiv.gmap3("get");
		    infobox = new InfoBox({
		    	pixelOffset: new google.maps.Size(-50, -65),
		    	closeBoxURL: '',
		    	enableEventPropagation: true
		    });
		    mapDiv.delegate('.infoBox .close','click',function () {
		    	infobox.close();
		    });

		    if (Modernizr.touch){
		    	map.setOptions({ draggable : true });
		        var draggableClass = 'inactive';
		        var draggableTitle = "Activate map";
		        var draggableButton = $('<div class="draggable-toggle-button '+draggableClass+'">'+draggableTitle+'</div>').appendTo(mapDiv);
		        draggableButton.click(function () {
		        	if($(this).hasClass('active')){
		        		$(this).removeClass('active').addClass('inactive').text("Activate map");
		        		map.setOptions({ draggable : false });
		        	} else {
		        		$(this).removeClass('inactive').addClass('active').text("Deactivate map");
		        		map.setOptions({ draggable : true });
		        	}
		        });
		    }

		jQuery( "#advance-search-slider" ).slider({
		      	range: "min",
		      	value: 500,
		      	min: 1,
		      	max: <?php echo $maximRange; ?>,
		      	slide: function( event, ui ) {
		       		jQuery( "#geo-radius" ).val( ui.value );
		       		jQuery( "#geo-radius-search" ).val( ui.value );

		       		jQuery( ".geo-location-switch" ).removeClass("off");
		      	 	jQuery( ".geo-location-switch" ).addClass("on");
		      	 	jQuery( "#geo-location" ).val("on");

		       		mapDiv.gmap3({
						getgeoloc:{
							callback : function(latLng){
								if (latLng){
									jQuery('#geo-search-lat').val(latLng.lat());
									jQuery('#geo-search-lng').val(latLng.lng());
								}
							}
						}
					});

		      	}
		    });
		    jQuery( "#geo-radius" ).val( jQuery( "#advance-search-slider" ).slider( "value" ) );
		    jQuery( "#geo-radius-search" ).val( jQuery( "#advance-search-slider" ).slider( "value" ) );

		    jQuery('.geo-location-button .fa').click(function()
			{

				if(jQuery('.geo-location-switch').hasClass('off'))
			    {
			        jQuery( ".geo-location-switch" ).removeClass("off");
				    jQuery( ".geo-location-switch" ).addClass("on");
				    jQuery( "#geo-location" ).val("on");

				    mapDiv.gmap3({
						getgeoloc:{
							callback : function(latLng){
								if (latLng){
									jQuery('#geo-search-lat').val(latLng.lat());
									jQuery('#geo-search-lng').val(latLng.lng());
								}
							}
						}
					});

			    } else {
			    	jQuery( ".geo-location-switch" ).removeClass("on");
				    jQuery( ".geo-location-switch" ).addClass("off");
				    jQuery( "#geo-location" ).val("off");
			    }

		    });

		});
		</script>
	<?php } ?>
			<?php

			global $redux_demo;

			$header_version = 2;
			$searchStyle = $redux_demo['search-style']; /*Search Style ID*/

		?>

			<?php if($searchStyle == 1) { ?>

			<?php get_template_part('templates/search1'); ?>

		<?php }elseif($searchStyle == 2){
			get_template_part('templates/search2');
		}elseif($searchStyle == 3){
			get_template_part('templates/search3');
		} elseif($searchStyle == 4){
			get_template_part('templates/search4');
		} ?>

	</section>
	<?php

		global $redux_demo;

		$featured_ads_option = $redux_demo['featured-options-on'];
	$gridStyle = $redux_demo['home-ads-style']; /*Category Style ID*/

	?>

	<?php if($featured_ads_option == 1) { ?>

   <?php if($hrSlider == 1) { ?>

		<?php get_template_part('templates/hr-slider1'); ?>

		<?php }elseif($hrSlider == 2){
			get_template_part('templates/hr-slider2');
		}elseif($hrSlider == 3){
			get_template_part('templates/hr-slider3');
		} ?>

    <?php } ?>

   <?php

			 if($gridStyle == 1) { ?>
   <section id="ads-homepage" class="category-page-ads">

		<div class="container">
			<div class="row">

				<div class="col-md-9 col-sm-12 col-xs-12 ">
					<div class="clearfix" style="height:30px;"></div>

					<div class="pane latest-ads-holder">

						<div class="classiads-grid-holder row">

							<?php

								global $paged, $wp_query, $wp;

								$args = wp_parse_args($wp->matched_query);

								if ( !empty ( $args['paged'] ) && 0 == $paged ) {

									$wp_query->set('paged', $args['paged']);

									$paged = $args['paged'];

								}

									if ( is_day() ) :


												$archive_year  = get_the_date('Y');
												$archive_month = get_the_date('m');
												$archive_day   = get_the_date('d');
												global $args; $args = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'monthnum' => $archive_month, 'day' => $archive_day, 'order' => 'DESC', 'post_type' => 'post');
												global $args_popular; $args_popular = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'monthnum' => $archive_month, 'day' => $archive_day, 'post_type' => 'post', 'meta_key' => 'wpb_post_views_count', 'orderby' => 'meta_value_num', 'order' => 'DESC');
												global $args_random; $args_random = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'monthnum' => $archive_month, 'day' => $archive_day, 'order' => 'DESC', 'post_type' => 'post', 'orderby' => 'title');

									elseif ( is_month() ) :


												$archive_year  = get_the_date('Y');
												$archive_month = get_the_date('m');
												global $args; $args = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'monthnum' => $archive_month, 'order' => 'DESC', 'post_type' => 'post');
												global $args_popular; $args_popular = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'monthnum' => $archive_month, 'post_type' => 'post', 'meta_key' => 'wpb_post_views_count', 'orderby' => 'meta_value_num', 'order' => 'DESC');
												global $args_random; $args_random = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'monthnum' => $archive_month, 'order' => 'DESC', 'post_type' => 'post', 'orderby' => 'title');

									elseif ( is_year() ) :


												$archive_year  = get_the_date('Y');
												global $args; $args = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'order' => 'DESC');
												global $args_popular; $args_popular = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'meta_key' => 'wpb_post_views_count', 'orderby' => 'meta_value_num', 'order' => 'DESC');
												global $args_random; $args_random = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'order' => 'DESC', 'orderby' => 'title');

									elseif ( is_tag() ) :



												global $wp_query;
												$tag = $wp_query->get_queried_object();
												$current_tag = $tag->term_id;

												global $args; $args = array('paged' => $paged, 'posts_per_page' => 9, 'tag_id' => $current_tag, 'order' => 'DESC');
												global $args_popular; $args_popular = array('paged' => $paged, 'posts_per_page' => 9, 'tag_id' => $current_tag, 'meta_key' => 'wpb_post_views_count', 'orderby' => 'meta_value_num', 'order' => 'DESC');
												global $args_random; $args_random = array('paged' => $paged, 'posts_per_page' => 9, 'tag_id' => $current_tag, 'order' => 'DESC', 'orderby' => 'title');

									else :

									endif;
								?>

						<?php

							

							$wp_query = new WP_Query();

							$wp_query->query($args);

							$current = -1;
							$current2 = 0;

							?>

							<?php while ($wp_query->have_posts()) : $wp_query->the_post(); $current++; $current2++; ?>

							<div class="col-md-4 col-sm-6 col-xs-12">
								<div class="ad-box latest-posts-grid">

									<?php
										if ( has_post_thumbnail()) {
										   $large_image_url = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'large');
										   echo '<a class="ad-image" href="' .get_permalink($post->ID). '" title="' . the_title_attribute('echo=0') . '" >';
										   echo get_the_post_thumbnail($post->ID, '270x220');
										   echo '</a>';
										 }
									?>
										<?php
										$post_price = get_post_meta($post->ID, 'post_price', true);
										if(!empty($post_price)){
										?>
										<div class="add-price"><span><?php echo classiads_price(esc_attr($post_price, 'classiads')); ?></span></div>
										<?php } ?>

									<div class="post-title-cat">

											<?php

												$category = get_the_category();

												if ($category[0]->category_parent == 0) {

													$tag = $category[0]->cat_ID;

													$tag_extra_fields = get_option(MY_CATEGORY_FIELDS);
													if (isset($tag_extra_fields[$tag])) {
														$category_icon_code = $tag_extra_fields[$tag]['category_icon_code'];
														$category_icon_color = $tag_extra_fields[$tag]['category_icon_color'];
													}

												} else {

													$tag = $category[0]->category_parent;

													$tag_extra_fields = get_option(MY_CATEGORY_FIELDS);
													if (isset($tag_extra_fields[$tag])) {
														$category_icon_code = $tag_extra_fields[$tag]['category_icon_code'];
														$category_icon_color = $tag_extra_fields[$tag]['category_icon_color'];
													}

												}

												if(!empty($category_icon_code)) {

											?>

											<?php $category_icon = stripslashes($category_icon_code); ?>

											<?php }

											$category_icon_code = "";

											?>





										<div class="post-title">
												<div class="post-title-icon" style="background-color:<?php echo $category_icon_color; ?>"><?php echo $category_icon; ?></div>
												<a href="<?php the_permalink(); ?>"><?php $theTitle = get_the_title(); $theTitle = (strlen($theTitle) > $ads_title_limit) ? substr($theTitle,0,$ads_title_limit).'...' : $theTitle; echo $theTitle; ?></a>
											</div>
									</div>

								</div>
							</div>

							<?php endwhile; ?>

						</div>

					<!-- Begin wpcrown_pagination-->
					<?php get_template_part('pagination'); ?>
					<!-- End wpcrown_pagination-->

					<?php wp_reset_query(); ?>

					</div>



				</div>

				<div class="col-md-3 col-sm-12 col-xs-12">

					<?php get_sidebar('pages'); ?>

				</div>

			</div>
    	</div>

    </section>


			 <?php

				 }elseif($gridStyle == 2){ ?>
   <section id="ads-homepage" class="category-page-ads  grid-vr-2">

		<div class="container">
			<div class="row">

				<div class="col-md-9 col-sm-12 col-xs-12">
					<div class="clearfix" style="height:30px;"></div>

					<div class="pane latest-ads-holder">

						<div class="classiads-grid-holder row">

							<?php

								global $paged, $wp_query, $wp;

								$args = wp_parse_args($wp->matched_query);

								if ( !empty ( $args['paged'] ) && 0 == $paged ) {

									$wp_query->set('paged', $args['paged']);

									$paged = $args['paged'];

								}

									if ( is_day() ) :


												$archive_year  = get_the_date('Y');
												$archive_month = get_the_date('m');
												$archive_day   = get_the_date('d');
												global $args; $args = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'monthnum' => $archive_month, 'day' => $archive_day, 'order' => 'DESC', 'post_type' => 'post');
												global $args_popular; $args_popular = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'monthnum' => $archive_month, 'day' => $archive_day, 'post_type' => 'post', 'meta_key' => 'wpb_post_views_count', 'orderby' => 'meta_value_num', 'order' => 'DESC');
												global $args_random; $args_random = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'monthnum' => $archive_month, 'day' => $archive_day, 'order' => 'DESC', 'post_type' => 'post', 'orderby' => 'title');

									elseif ( is_month() ) :


												$archive_year  = get_the_date('Y');
												$archive_month = get_the_date('m');
												global $args; $args = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'monthnum' => $archive_month, 'order' => 'DESC', 'post_type' => 'post');
												global $args_popular; $args_popular = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'monthnum' => $archive_month, 'post_type' => 'post', 'meta_key' => 'wpb_post_views_count', 'orderby' => 'meta_value_num', 'order' => 'DESC');
												global $args_random; $args_random = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'monthnum' => $archive_month, 'order' => 'DESC', 'post_type' => 'post', 'orderby' => 'title');

									elseif ( is_year() ) :


												$archive_year  = get_the_date('Y');
												global $args; $args = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'order' => 'DESC');
												global $args_popular; $args_popular = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'meta_key' => 'wpb_post_views_count', 'orderby' => 'meta_value_num', 'order' => 'DESC');
												global $args_random; $args_random = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'order' => 'DESC', 'orderby' => 'title');

									elseif ( is_tag() ) :



												global $wp_query;
												$tag = $wp_query->get_queried_object();
												$current_tag = $tag->term_id;

												global $args; $args = array('paged' => $paged, 'posts_per_page' => 9, 'tag_id' => $current_tag, 'order' => 'DESC');
												global $args_popular; $args_popular = array('paged' => $paged, 'posts_per_page' => 9, 'tag_id' => $current_tag, 'meta_key' => 'wpb_post_views_count', 'orderby' => 'meta_value_num', 'order' => 'DESC');
												global $args_random; $args_random = array('paged' => $paged, 'posts_per_page' => 9, 'tag_id' => $current_tag, 'order' => 'DESC', 'orderby' => 'title');

									else :

									endif;
								?>

						<?php

							

							$wp_query = new WP_Query();

							$wp_query->query($args);

							$current = -1;
							$current2 = 0;

							?>

							<?php while ($wp_query->have_posts()) : $wp_query->the_post(); $current++; $current2++; ?>


								<?php

									$postid = get_the_ID();

								?>
							<div class="col-md-4 col-sm-12 col-xs-12">
								<div id="post-<?php echo $postid; ?>" class="ad-box random-posts-grid">

									<?php
										if ( has_post_thumbnail()) {
										   $large_image_url = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'large');
										   echo '<a class="ad-image" href="' .get_permalink($post->ID). '" title="' . the_title_attribute('echo=0') . '" >';
										   echo get_the_post_thumbnail($post->ID, '270x220');
										   echo '</a>';
										 }
									?>

																	<?php
										$post_price = get_post_meta($post->ID, 'post_price', true);
										if(!empty($post_price)){
										?>
										<div class="add-price"><span><?php echo classiads_price(esc_attr($post_price, 'classiads')); ?></span><div class="pacman"></div></div>
										<?php } ?>

									<div class="post-title-cat">


											<?php

												$category = get_the_category();
												if ($category[0]->category_parent == 0) {

													$tag = $category[0]->cat_ID;

													$tag_extra_fields = get_option(MY_CATEGORY_FIELDS);
													if (isset($tag_extra_fields[$tag])) {
														$category_icon_code = $tag_extra_fields[$tag]['category_icon_code'];
														$category_icon_color = $tag_extra_fields[$tag]['category_icon_color'];
													}

												} else {

													$tag = $category[0]->category_parent;

													$tag_extra_fields = get_option(MY_CATEGORY_FIELDS);
													if (isset($tag_extra_fields[$tag])) {
														$category_icon_code = $tag_extra_fields[$tag]['category_icon_code'];
														$category_icon_color = $tag_extra_fields[$tag]['category_icon_color'];
													}

												}

												if(!empty($category_icon_code)) {

											?>

											<?php $category_icon = stripslashes($category_icon_code);  ?>

											<?php }

											$category_icon_code = "";

											?>

										<div class="post-title">

											<div class="post-tit-lft">
												<a class="grid-post-tit" href="<?php the_permalink(); ?>"><?php $theTitle = get_the_title(); $theTitle = (strlen($theTitle) > $ads_title_limit) ? substr($theTitle,0,$ads_title_limit).'...' : $theTitle; echo $theTitle; ?></a>

												<a class="feat-category" href="<?php echo get_category_link( $category[0]->term_id ); ?>">
													<?php echo $category[0]->name; ?>
												</a>
											</div>
											<script>
												jQuery(document).ready(function() {
													jQuery('#post-<?php echo $postid; ?> .post-title-icon i').css( "color", "<?php echo $category_icon_color; ?>" );
													jQuery("#post-<?php echo $postid; ?>").mouseover(function(){
													  jQuery(this).find('.post-title-icon').css( "background-color", "<?php echo $category_icon_color; ?>" );
													  jQuery(this).find('.post-title-icon i').css( "color", "#fff" );
													});

													jQuery("#post-<?php echo $postid; ?>").mouseout(function(){
													  jQuery(this).find('.post-title-icon').css( "background-color", "#fff" );
													  jQuery(this).find('.post-title-icon i').css( "color", "<?php echo $category_icon_color; ?>" );
													});
												});
											</script>
											<div class="post-title-icon" style="border:1px solid <?php echo $category_icon_color; ?>"><?php echo $category_icon; ?></div>
										</div>
									</div>
								</div>
							</div>

							<?php endwhile; ?>

						</div>

					<!-- Begin wpcrown_pagination-->
					<?php get_template_part('pagination'); ?>
					<!-- End wpcrown_pagination-->

					<?php wp_reset_query(); ?>

					</div>



				</div>

				<div class="col-md-3 col-sm-12 col-xs-12">

					<?php get_sidebar('pages'); ?>

				</div>

			</div>
    	</div>

    </section>



			<?php	}elseif($gridStyle == 3){ ?>
   <section id="ads-homepage" class="category-page-ads  grid-vr-3">

		<div class="container">
			<div class="row">

				<div class="col-md-9 col-sm-12 col-xs-12">
					<div class="clearfix" style="height:30px;"></div>

					<div class="pane latest-ads-holder">

						<div class="classiads-grid-holder row">

							<?php

								global $paged, $wp_query, $wp;

								$args = wp_parse_args($wp->matched_query);

								if ( !empty ( $args['paged'] ) && 0 == $paged ) {

									$wp_query->set('paged', $args['paged']);

									$paged = $args['paged'];

								}

									if ( is_day() ) :


												$archive_year  = get_the_date('Y');
												$archive_month = get_the_date('m');
												$archive_day   = get_the_date('d');
												global $args; $args = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'monthnum' => $archive_month, 'day' => $archive_day, 'order' => 'DESC', 'post_type' => 'post');
												global $args_popular; $args_popular = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'monthnum' => $archive_month, 'day' => $archive_day, 'post_type' => 'post', 'meta_key' => 'wpb_post_views_count', 'orderby' => 'meta_value_num', 'order' => 'DESC');
												global $args_random; $args_random = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'monthnum' => $archive_month, 'day' => $archive_day, 'order' => 'DESC', 'post_type' => 'post', 'orderby' => 'title');

									elseif ( is_month() ) :


												$archive_year  = get_the_date('Y');
												$archive_month = get_the_date('m');
												global $args; $args = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'monthnum' => $archive_month, 'order' => 'DESC', 'post_type' => 'post');
												global $args_popular; $args_popular = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'monthnum' => $archive_month, 'post_type' => 'post', 'meta_key' => 'wpb_post_views_count', 'orderby' => 'meta_value_num', 'order' => 'DESC');
												global $args_random; $args_random = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'monthnum' => $archive_month, 'order' => 'DESC', 'post_type' => 'post', 'orderby' => 'title');

									elseif ( is_year() ) :


												$archive_year  = get_the_date('Y');
												global $args; $args = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'order' => 'DESC');
												global $args_popular; $args_popular = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'meta_key' => 'wpb_post_views_count', 'orderby' => 'meta_value_num', 'order' => 'DESC');
												global $args_random; $args_random = array('paged' => $paged, 'posts_per_page' => 9, 'year' => $archive_year, 'order' => 'DESC', 'orderby' => 'title');

									elseif ( is_tag() ) :



												global $wp_query;
												$tag = $wp_query->get_queried_object();
												$current_tag = $tag->term_id;

												global $args; $args = array('paged' => $paged, 'posts_per_page' => 9, 'tag_id' => $current_tag, 'order' => 'DESC');
												global $args_popular; $args_popular = array('paged' => $paged, 'posts_per_page' => 9, 'tag_id' => $current_tag, 'meta_key' => 'wpb_post_views_count', 'orderby' => 'meta_value_num', 'order' => 'DESC');
												global $args_random; $args_random = array('paged' => $paged, 'posts_per_page' => 9, 'tag_id' => $current_tag, 'order' => 'DESC', 'orderby' => 'title');

									else :

									endif;
								?>

						<?php

							

							$wp_query = new WP_Query();

							$wp_query->query($args);

							$current = -1;
							$current2 = 0;

							?>

							<?php while ($wp_query->have_posts()) : $wp_query->the_post(); $current++; $current2++; ?>


							<div class="col-md-4 col-sm-12 col-xs-12">
								<div class="ad-box latest-posts-grid">
									<div class="ads-v2-thumb">
									<?php
										if ( has_post_thumbnail()) {
										   $large_image_url = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'large');
										   echo '<a class="ad-image" href="' .get_permalink($post->ID). '" title="' . the_title_attribute('echo=0') . '" >';
										   echo get_the_post_thumbnail($post->ID, '270x220');
										   echo '</a>';
										 }
									?>
									<?php

										$category = get_the_category();

										if ($category[0]->category_parent == 0) {

											$tag = $category[0]->cat_ID;

											$tag_extra_fields = get_option(MY_CATEGORY_FIELDS);
											if (isset($tag_extra_fields[$tag])) {
												$category_icon_code = $tag_extra_fields[$tag]['category_icon_code'];
												$category_icon_color = $tag_extra_fields[$tag]['category_icon_color'];
											}

										} else {

											$tag = $category[0]->category_parent;

											$tag_extra_fields = get_option(MY_CATEGORY_FIELDS);
											if (isset($tag_extra_fields[$tag])) {
												$category_icon_code = $tag_extra_fields[$tag]['category_icon_code'];
												$category_icon_color = $tag_extra_fields[$tag]['category_icon_color'];
											}

										}

										if(!empty($category_icon_code)) {

									?>

									<?php $category_icon = stripslashes($category_icon_code); ?>

									<?php }

									$category_icon_code = "";

									?>

										<div class="ads-vr-2-category-icon"><span><?php echo $category_icon; ?></span></div>

									</div>

									<div class="post-title-cat">

										<div class="post-title">
											<a href="<?php the_permalink(); ?>"><?php $theTitle = get_the_title(); $theTitle = (strlen($theTitle) > $ads_title_limit) ? substr($theTitle,0,$ads_title_limit).'...' : $theTitle; echo $theTitle; ?></a>

										</div>
										<div class="ads-bottom-line">
											<a class="feat-category" href="<?php echo get_category_link( $category[0]->term_id ); ?>">
												<?php echo $category[0]->name; ?>
											</a>
											<?php
											$post_price = get_post_meta($post->ID, 'post_price', true);
											if(!empty($post_price)){
											?>
											<div class="ads-price-v2"><span><?php echo classiads_price(esc_attr($post_price, 'classiads')); ?></span></div>
										<?php } ?>
										</div>

									</div>

								</div>
							</div>

							<?php endwhile; ?>

						</div>

					<!-- Begin wpcrown_pagination-->
					<?php get_template_part('pagination'); ?>
					<!-- End wpcrown_pagination-->

					<?php wp_reset_query(); ?>

					</div>



				</div>

				<div class="col-md-3 col-sm-12 col-xs-12">

					<?php get_sidebar('pages'); ?>

				</div>

			</div>
    	</div>

    </section>
		<?php		}
   ?>
    <script>
		// perform JavaScript after the document is scriptable.
		jQuery(function() {
			jQuery("ul.tabs").tabs("> .pane", {effect: 'fade', fadeIn: 200});
		});
	</script>

<?php get_footer(); ?>
