<?php
if ( ! defined( 'ABSPATH' ) ) { // Or some other WordPress constant
	exit;
}
/******************************************************************************
 *
 * Shortcode : pgscore_smart_image_view
 *
 ******************************************************************************/
function pgscore_shortcode_smart_image_view( $atts, $content = null, $shortcode_handle = '' ) {
	$default_atts = array(
		'image_gallery'                   => '',
		'element_css'                     => '',
		'element_id'                      => '',
		'element_class'                   => '',
		'show_prev_next_buttons'          => '',
		'show_auto_play_smart_image_view' => '',
		'shortcode_handle'                => $shortcode_handle,
	);

	$atts = shortcode_atts( $default_atts, $atts, $shortcode_handle );

	extract( $atts );

	global $pgscore_shortcodes;
	$pgscore_shortcodes[ $shortcode_handle ]['atts'] = $atts;
	ob_start();
	?>
	<div <?php pgscore_shortcode_id( $atts ); ?> class="<?php pgscore_element_classes( $atts ); ?>"><!-- shortcode-base-wrapper -->
		<?php pgscore_get_shortcode_templates( 'smart_image_view/content' ); ?>
	</div><!-- shortcode-base-wrapper-end -->
	<?php
	return ob_get_clean();
}

/******************************************************************************
 *
 * Visual Composer Integration
 *
 ******************************************************************************/
if ( function_exists( 'vc_map' ) && ( is_admin() || vc_is_frontend_ajax() || vc_is_frontend_editor() || vc_is_inline() ) ) {
	$shortcode_fields = array_merge(
		array(
			array(
				'type'             => 'checkbox',
				'heading'          => esc_html__( 'Show Prev/Next Buttons', 'pgs-core' ),
				'param_name'       => 'show_prev_next_buttons',
				'description'      => esc_html__( 'Check this checkbox to display prev/next buttons.', 'pgs-core' ),
				'value'            => array( esc_html__( 'Yes', 'pgs-core' ) => 'yes' ),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
				'group'            => esc_html__( 'General', 'pgs-core' ),
				'admin_label'      => true,
			),
			array(
				'type'             => 'checkbox',
				'heading'          => esc_html__( 'Autoplay Smart Image View', 'pgs-core' ),
				'param_name'       => 'show_auto_play_smart_image_view',
				'description'      => esc_html__( 'Check this checkbox to display autoplay Smart Image View.', 'pgs-core' ),
				'value'            => array( esc_html__( 'Yes', 'pgs-core' ) => 'yes' ),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
				'group'            => esc_html__( 'General', 'pgs-core' ),
				'admin_label'      => true,
			),
			array(
				'type'       => 'attach_images',
				'heading'    => esc_html__( 'Image Gallery', 'pgs-core' ),
				'param_name' => 'image_gallery',
				'group'      => esc_html__( 'Images', 'pgs-core' ),
			),
			array(
				'type'       => 'css_editor',
				'heading'    => esc_html__( 'CSS box', 'pgs-core' ),
				'param_name' => 'element_css',
				'group'      => esc_html__( 'Design Options', 'pgs-core' ),
			),
			array(
				'type'        => 'el_id',
				'heading'     => esc_html__( 'ID', 'pgs-core' ),
				'param_name'  => 'element_id',
				'description' => sprintf(
					wp_kses(
						__( 'Enter ID (Note: make sure it is unique and valid according to <a href="%s" target="_blank">w3c specification</a>)', 'pgs-core' ),
						array(
							'a' => array(
								'href'   => true,
								'target' => true,
							),
						)
					),
					'http://www.w3schools.com/tags/att_global_id.asp'
				)
				. '<br><span class="pgs-core-red">' .
					sprintf(
						wp_kses(
							__( 'Important : If ID starts with number, it will be prefixed with "%s".', 'pgs-core' ),
							array(
								'atrong' => true,
							)
						),
						'<strong>' . $shortcode_tag . '_' . '</strong>'
					)
					. '</span>',
				'group'       => esc_html__( 'ID/Class', 'pgs-core' ),
			),
			array(
				'type'        => 'textfield',
				'heading'     => esc_html__( 'Extra class name', 'pgs-core' ),
				'param_name'  => 'element_class',
				'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'pgs-core' ),
				'group'       => esc_html__( 'ID/Class', 'pgs-core' ),
			),
		)
	);

	// Params
	$params = array(
		'name'                    => esc_html__( 'Smart Image View', 'pgs-core' ),
		'description'             => esc_html__( 'Display Smart Image View Image.', 'pgs-core' ),
		'base'                    => $shortcode_tag,
		'class'                   => 'pgscore_element_wrapper',
		'controls'                => 'full',
		'icon'                    => PGSCORE_URL . '/images/vc-icon.png',
		'category'                => esc_html__( 'Potenza Core', 'pgs-core' ),
		'show_settings_on_create' => true,
		'params'                  => $shortcode_fields,
	);
	vc_map( $params );
}
?>
