<?php
return array(
	'title'            => esc_html__( 'Maintenance', 'pgs-core' ),
	'id'               => 'maintenance_section',
	'customizer_width' => '400px',
	'icon'             => 'fa fa-toggle-on',
	'desc'             => esc_html__( 'Enable/disable Maintenance or Coming Soon mode', 'pgs-core' ),
	'fields'           => array(
		array(
			'id'      => 'enable_maintenance',
			'type'    => 'switch',
			'title'   => esc_html__( 'Enable Maintenance?', 'pgs-core' ),
			'on'      => esc_html__( 'Yes', 'pgs-core' ),
			'off'     => esc_html__( 'No', 'pgs-core' ),
			'default' => '0',
		),
		array(
			'id'       => 'maintenance_mode',
			'type'     => 'button_set',
			'title'    => esc_html__( 'Maintenance Mode', 'pgs-core' ),
			'options'  => array(
				'maintenance' => esc_html__( 'Maintenance', 'pgs-core' ),
				'comingsoon'  => esc_html__( 'Coming Soon', 'pgs-core' ),
			),
			'default'  => 'maintenance',
			'required' => array( 'enable_maintenance', '=', '1' ),
		),
		array(
			'id'       => 'maintenance_title',
			'type'     => 'text',
			'title'    => esc_html__( 'Maintenance Title', 'pgs-core' ),
			'default'  => esc_html__( 'Site is Under Maintenance', 'pgs-core' ),
			'required' => array( 'maintenance_mode', '=', 'maintenance' ),
		),
		array(
			'id'       => 'maintenance_subtitle',
			'type'     => 'text',
			'title'    => esc_html__( 'Maintenance Subtitle', 'pgs-core' ),
			'default'  => esc_html__( 'This Site is Currently Under Maintenance. We will back shortly', 'pgs-core' ),
			'required' => array( 'maintenance_mode', '=', 'maintenance' ),
		),
		array(
			'id'       => 'comingsoon_title',
			'type'     => 'text',
			'title'    => esc_html__( 'Coming Soon Title', 'pgs-core' ),
			'default'  => esc_html__( 'Coming soon', 'pgs-core' ),
			'required' => array( 'maintenance_mode', '=', 'comingsoon' ),
		),
		array(
			'id'       => 'comingsoon_subtitle',
			'type'     => 'text',
			'title'    => esc_html__( 'Coming Soon Subtitle', 'pgs-core' ),
			'default'  => esc_html__( 'We are currently working on a website and won\'t take long. Don\'t forget to check out our Social updates.', 'pgs-core' ),
			'required' => array( 'maintenance_mode', '=', 'comingsoon' ),
		),
		array(
			'id'          => 'comingsoon_date',
			'type'        => 'date',
			'title'       => esc_html__( 'Coming Soon Date', 'pgs-core' ),
			'subtitle'    => esc_html__( 'Select coming soon date.', 'pgs-core' ),
			'placeholder' => esc_html__( 'Click to enter a date', 'pgs-core' ),
			'required'    => array( 'maintenance_mode', '=', 'comingsoon' ),
			'default'     => date( 'm/d/Y', strtotime( '+1 months' ) ),
		),
		array(
			'id'       => 'comming_soon_social_icons',
			'type'     => 'switch',
			'title'    => esc_html__( 'Social Icons', 'pgs-core' ),
			'subtitle' => esc_html__( 'Show/hide social icons.', 'pgs-core' ),
			'default'  => true,
			'required' => array( 'enable_maintenance', '=', '1' ),
		),
		array(
			'id'       => 'comming_soon_newsletter',
			'type'     => 'switch',
			'title'    => esc_html__( 'Display Newsletter', 'pgs-core' ),
			'subtitle' => esc_html__( 'Show/hide newsletter.', 'pgs-core' ),
			'default'  => false,
			'required' => array( 'enable_maintenance', '=', '1' ),
		),
		array(
			'id'       => 'comming_page_newsletter_shortcode',
			'type'     => 'select',
			'title'    => esc_html__( 'Newsletter Form', 'pgs-core' ),
			'subtitle' => esc_html__( 'Select newsletter form for display newsletter box on Comming Soon/Maintenance Page.', 'pgs-core' ),
			'data'     => 'posts',
			'args'     => array(
				'post_type' => 'mc4wp-form',
			),
			'required' => array(
				array( 'enable_maintenance', '=', '1' ),
				array( 'comming_soon_newsletter', '=', '1' ),
			),
		),
	),
);
