<?php

/* woocommerce plugin is activate then only WooCommerce setting will be appear.  */
if ( function_exists( 'WC' ) ) {
	return array(
		'id'               => 'products_listing',
		'title'            => esc_html__( 'Products Listing', 'pgs-core' ),
		'desc'             => esc_html__( 'Note: Listing pages means for Shop, Product Category, Product Tag and Attributes pages.', 'pgs-core' ),
		'customizer_width' => '400px',
		'subsection'       => true,
		'fields'           => array(
			array(
				'id'       => 'pro-col-sel',
				'type'     => 'select',
				'title'    => esc_html__( 'Product Listing Column', 'pgs-core' ),
				'subtitle' => esc_html__( 'Select number of column on listing page', 'pgs-core' ),
				'options'  => array(
					'2' => esc_html__( '2 Column', 'pgs-core' ),
					'3' => esc_html__( '3 Column', 'pgs-core' ),
					'4' => esc_html__( '4 Column', 'pgs-core' ),
					'5' => esc_html__( '5 Column', 'pgs-core' ),
				),
				'select2'  => array(
					'allowClear' => false,
				),
				'default'  => '3',
			),
			array(
				'id'       => 'products_columns_mobile',
				'type'     => 'select',
				'title'    => esc_html__( 'Products Columns On Mobile ( landscape )', 'pgs-core' ),
				'subtitle' => esc_html__( 'Select how many products you want to show per row on mobile landscape view', 'pgs-core' ),
				'options'  => array(
					'1' => esc_html__( '1 Column', 'pgs-core' ),
					'2' => esc_html__( '2 Column', 'pgs-core' ),
				),
				'select2'  => array(
					'allowClear' => false,
				),
				'default'  => '1',
			),
			array(
				'id'       => 'products_columns_mobile_portrait',
				'type'     => 'select',
				'title'    => esc_html__( 'Products Columns On Mobile ( portrait )', 'pgs-core' ),
				'subtitle' => esc_html__( 'Select how many products you want to show per row on mobile portrait view', 'pgs-core' ),
				'options'  => array(
					'1' => esc_html__( '1 Column', 'pgs-core' ),
					'2' => esc_html__( '2 Column', 'pgs-core' ),
				),
				'select2'  => array(
					'allowClear' => false,
				),
				'default'  => '1',
				'desc'     => esc_html__( 'Note: This option will not work for "Standard Info Transparent" and "Standard Quick Shop" Hover Style.', 'pgs-core' ),
			),
			array(
				'id'       => 'shop_sidebar',
				'type'     => 'select',
				'title'    => esc_html__( 'Product Listing Sidebar', 'pgs-core' ),
				'subtitle' => esc_html__( 'Select sidebar on listing page', 'pgs-core' ),
				'options'  => array(
					'left'  => esc_html__( 'Left Sidebar', 'pgs-core' ),
					'right' => esc_html__( 'Right Sidebar', 'pgs-core' ),
					'no'    => esc_html__( 'No Sidebar', 'pgs-core' ),
				),
				'select2'  => array(
					'allowClear' => false,
				),
				'default'  => 'left',
			),
			array(
				'id'       => 'off_canvas_shop_sidebar',
				'type'     => 'switch',
				'title'    => esc_html__( 'Off Canvas sidebar', 'pgs-core' ),
				'subtitle' => esc_html__( 'You can set the sidebar as off canvas on shop page.', 'pgs-core' ),
				'on'       => esc_html__( 'Yes', 'pgs-core' ),
				'off'      => esc_html__( 'No', 'pgs-core' ),
				'default'  => false,
				'required' => array( 'shop_sidebar', '!=', 'no' ),
			),
			array(
				'id'       => 'off_canvas_mobile_shop_sidebar',
				'type'     => 'switch',
				'title'    => esc_html__( 'Off Canvas sidebar for mobile', 'pgs-core' ),
				'subtitle' => esc_html__( 'You can set the sidebar as off canvas on shop page for mobile.', 'pgs-core' ),
				'on'       => esc_html__( 'Yes', 'pgs-core' ),
				'off'      => esc_html__( 'No', 'pgs-core' ),
				'default'  => false,
				'required' => array( 'shop_sidebar', '!=', 'no' ),
			),
			array(
				'id'       => 'shop-page-width',
				'type'     => 'select',
				'title'    => esc_html__( 'Page Width', 'pgs-core' ),
				'subtitle' => esc_html__( 'Select page width', 'pgs-core' ),
				'options'  => array(
					'fixed' => esc_html__( 'Fixed', 'pgs-core' ),
					'wide'  => esc_html__( 'Wide', 'pgs-core' ),
				),
				'select2'  => array(
					'allowClear' => false,
				),
				'default'  => 'fixed',
			),
			array(
				'id'       => 'show_sidebar_on_mobile',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Sidebar on Mobile Devices', 'pgs-core' ),
				'subtitle' => esc_html__( 'Show Sidebar on mobile devices', 'pgs-core' ),
				'on'       => esc_html__( 'Yes', 'pgs-core' ),
				'off'      => esc_html__( 'No', 'pgs-core' ),
				'default'  => true,
				'required' => array( 'shop_sidebar', '!=', 'no' ),
			),
			array(
				'id'       => 'shop_sidebar_position_mobile',
				'type'     => 'button_set',
				'title'    => esc_html__( 'Sidebar position for mobile', 'pgs-core' ),
				'subtitle' => esc_html__( 'Set sidebar position on mobile.', 'pgs-core' ),
				'options'  => array(
					'top'    => esc_html__( 'Top', 'pgs-core' ),
					'bottom' => esc_html__( 'Bottom', 'pgs-core' ),
				),
				'default'  => 'bottom',
				'required' => array( 'show_sidebar_on_mobile', '=', true ),
			),
			/***********************************************************************************/
			array(
				'id'       => 'ajax_add_to_cart',
				'type'     => 'switch',
				'title'    => esc_html__( 'AJAX Add to cart', 'pgs-core' ),
				'subtitle' => esc_html__( 'Enabling this option will add products using the ajax.', 'pgs-core' ),
				'on'       => esc_html__( 'Enable', 'pgs-core' ),
				'off'      => esc_html__( 'Disable', 'pgs-core' ),
				'default'  => true,
			),
			array(
				'id'       => 'add_quantity_in_cart',
				'type'     => 'switch',
				'title'    => esc_html__( 'Add Quantity input on cart widget', 'pgs-core' ),
				'subtitle' => esc_html__( 'Enabling this option will add quantity input field in cart widget and side widget after product added to cart.', 'pgs-core' ),
				'on'       => esc_html__( 'Enable', 'pgs-core' ),
				'off'      => esc_html__( 'Disable', 'pgs-core' ),
				'default'  => false,
			),
			array(
				'id'       => 'product_after_add_to_cart_action',
				'type'     => 'image_select',
				'title'    => esc_html__( 'After add to cart', 'pgs-core' ),
				'subtitle' => esc_html__( 'Choose between showing informative popup and opening shopping cart widget. Only for shop page.', 'pgs-core' ),
				'options'  => array(
					'popup'       => array(
						'alt' => esc_html__( 'Show Popup', 'pgs-core' ),
						'img' => esc_url( PGSCORE_URL . '/images/options/after_add_to_cart_layout/popup.jpg' ),
					),
					'side_widget' => array(
						'alt' => esc_html__( 'Side Widget', 'pgs-core' ),
						'img' => esc_url( PGSCORE_URL . '/images/options/after_add_to_cart_layout/widget.jpg' ),
					),
					'none'        => array(
						'alt' => esc_html__( 'No action', 'pgs-core' ),
						'img' => esc_url( PGSCORE_URL . '/images/options/after_add_to_cart_layout/default.jpg' ),
					),
				),
				'default'  => 'none',
			),
			array(
				'id'       => 'scroll_to_cart',
				'type'     => 'switch',
				'title'    => esc_html__( 'Scroll After Add To Cart', 'pgs-core' ),
				'subtitle' => esc_html__( 'Scroll to cart after add to cart.', 'pgs-core' ),
				'on'       => esc_html__( 'Yes', 'pgs-core' ),
				'off'      => esc_html__( 'No', 'pgs-core' ),
				'default'  => true,
				'required' => array( 'product_after_add_to_cart_action', '=', 'none' ),
			),
			array(
				'id'            => 'products_per_page',
				'type'          => 'slider',
				'url'           => true,
				'title'         => esc_html__( 'Number of Products per Page', 'pgs-core' ),
				'subtitle'      => esc_html__( 'Select number of products to display per page.', 'pgs-core' ),
				'default'       => 12,
				'min'           => 0,
				'step'          => 1,
				'max'           => 40,
				'display_value' => 'text',
			),
			array(
				'id'            => 'products_per_page_variations',
				'type'          => 'text',
				'url'           => true,
				'title'         => esc_html__( 'Products per page variations', 'pgs-core' ),
				'subtitle'      => esc_html__( "Use ',' seperated values that will be display in the per page variation on shop page ex.: 9,12,15 Use -1 to show all products on the page", 'pgs-core' ),
				'default'       => '9,12,15',
				'display_value' => 'text',
			),
			array(
				'id'      => 'product_pagination',
				'type'    => 'button_set',
				'title'   => esc_html__( 'Product Pagination', 'pgs-core' ),
				'options' => array(
					'pagination'      => esc_html__( 'Pagination', 'pgs-core' ),
					'load_more'       => esc_html__( 'Load More', 'pgs-core' ),
					'infinite_scroll' => esc_html__( 'Infinite Scroll', 'pgs-core' ),
				),
				'default' => 'pagination',
			),

			/**********************************************************************************************/
			array(
				'id'     => 'hot_label_section-start',
				'type'   => 'section',
				'title'  => esc_html__( '"Hot" Label', 'pgs-core' ),
				'indent' => true,
			),
			array(
				'id'       => 'product-hot',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show "Hot" Label', 'pgs-core' ),
				'subtitle' => esc_html__( 'Will be show in the featured product.', 'pgs-core' ),
				'default'  => true,
				'on'       => esc_html__( 'Yes', 'pgs-core' ),
				'off'      => esc_html__( 'No', 'pgs-core' ),
			),
			array(
				'id'       => 'product-hot-label',
				'type'     => 'text',
				'title'    => esc_html__( '"Hot" Text', 'pgs-core' ),
				'default'  => esc_html__( 'Hot', 'pgs-core' ),
				'required' => array( 'product-hot', 'equals', true ),
			),
			array(
				'id'     => 'hot_label_section-end',
				'type'   => 'section',
				'indent' => false,
			),

			/**********************************************************************************************/
			array(
				'id'     => 'product_sale_section-start',
				'type'   => 'section',
				'title'  => esc_html__( '"Sale" Label', 'pgs-core' ),
				'indent' => true,
			),
			array(
				'id'      => 'product-sale',
				'type'    => 'switch',
				'title'   => esc_html__( 'Show "Sale" Label', 'pgs-core' ),
				'default' => true,
				'on'      => esc_html__( 'Yes', 'pgs-core' ),
				'off'     => esc_html__( 'No', 'pgs-core' ),
			),
			array(
				'id'       => 'product_sale_textperc',
				'type'     => 'button_set',
				'title'    => esc_html__( 'Label Type', 'pgs-core' ),
				'subtitle' => esc_html__( 'Select "Sale" label type.', 'pgs-core' ),
				'options'  => array(
					'text'    => esc_html__( 'Text', 'pgs-core' ),
					'percent' => esc_html__( 'Percent', 'pgs-core' ),
				),
				'default'  => 'text',
				'required' => array( 'product-sale', '=', true ),
			),
			array(
				'id'       => 'product-sale-label',
				'type'     => 'text',
				'title'    => esc_html__( '"Sale" Text', 'pgs-core' ),
				'default'  => esc_html__( 'Sale', 'pgs-core' ),
				'required' => array(
					array( 'product-sale', '=', true ),
					array( 'product_sale_textperc', '=', 'text' ),
				),
			),
			array(
				'id'     => 'product_sale_section-end',
				'type'   => 'section',
				'indent' => false,
			),

			/************************************************************************************/
			array(
				'id'       => 'product_header_section-start',
				'type'     => 'section',
				'title'    => esc_html__( 'Header Settings', 'pgs-core' ),
				'subtitle' => esc_html__( 'Here you can set header settings for shop page.', 'pgs-core' ),
				'indent'   => true,
			),
			array(
				'id'       => 'show_header_on_shop_page',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Header On Shop Page', 'pgs-core' ),
				'subtitle' => esc_html__( 'Show Header On Shop Page', 'pgs-core' ),
				'on'       => esc_html__( 'Show', 'pgs-core' ),
				'off'      => esc_html__( 'Hide', 'pgs-core' ),
				'default'  => true,
			),
			array(
				'id'     => 'product_categories_section-start',
				'type'   => 'section',
				'title'  => esc_html__( 'Shop Page Category Icon Carousel', 'pgs-core' ),
				'indent' => true,
			),
			array(
				'id'       => 'show_category_on_shop_header',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Product Category', 'pgs-core' ),
				'subtitle' => esc_html__( 'Show Product Category On Shop Header', 'pgs-core' ),
				'on'       => esc_html__( 'Show', 'pgs-core' ),
				'off'      => esc_html__( 'Hide', 'pgs-core' ),
				'default'  => false,
			),
			array(
				'id'       => 'shop_product_categories',
				'type'     => 'select',
				'multi'    => true,
				'title'    => esc_html__( 'Product Categories', 'pgs-core' ),
				'desc'     => esc_html__( 'Select the categories to display.', 'pgs-core' ),
				'sortable' => true,
				'options'  => ciyashop_get_product_categories(),
				'required' => array( 'show_category_on_shop_header', 'equals', '1' ),
			),
			array(
				'id'       => 'shop_categories_style',
				'type'     => 'select',
				'title'    => esc_html__( 'Categories Listing Style', 'pgs-core' ),
				'subtitle' => esc_html__( 'Select categories style to display.', 'pgs-core' ),
				'options'  => array(
					'style-1' => esc_html__( 'Style 1', 'pgs-core' ),
					'style-2' => esc_html__( 'Style 2', 'pgs-core' ),
					'style-3' => esc_html__( 'Style 3', 'pgs-core' ),
				),
				'select2'  => array(
					'allowClear' => false,
				),
				'default'  => 'style-1',
				'required' => array( 'show_category_on_shop_header', 'equals', '1' ),
			),
			array(
				'id'       => 'shop_categories_text_color',
				'type'     => 'select',
				'title'    => esc_html__( 'Categories Listing Style', 'pgs-core' ),
				'subtitle' => esc_html__( 'Select categories style to display.', 'pgs-core' ),
				'options'  => array(
					'light' => esc_html__( 'Light', 'pgs-core' ),
					'dark'  => esc_html__( 'Dark', 'pgs-core' ),
				),
				'select2'  => array(
					'allowClear' => false,
				),
				'default'  => 'light',
				'required' => array( 'show_category_on_shop_header', 'equals', '1' ),
				'required' => array(
					array( 'show_category_on_shop_header', '=', 1 ),
					array( 'shop_categories_style', '!=', 'style-1' ),
				),
			),
			array(
				'id'       => 'shop_categories_opacity_color',
				'type'     => 'color_rgba',
				'title'    => esc_html__( 'Background Opacity Color', 'pgs-core' ),
				'output'   => array( 'background-color' => '.site-header' ),
				'mode'     => 'background-color',
				'required' => array(
					array( 'show_category_on_shop_header', '=', 1 ),
					array( 'shop_categories_style', '!=', 'style-1' ),
				),
			),
			array(
				'id'            => 'shop_categories_background',
				'type'          => 'background',
				'title'         => esc_html__( 'Background', 'pgs-core' ),
				'desc'          => esc_html__( 'Set site background. This is applicable for fixed width layouts ("Boxed", "Framed" and "Rounded" ) only.', 'pgs-core' ),
				'preview_media' => true,
				'transparent'   => false,
				'default'       => array(
					'background-image' => '',
				),
				'required'      => array(
					array( 'shop_categories_style', 'equals', array( 'style-2', 'style-3' ) ),
				),
			),
			array(
				'id'       => 'shop-categories-width',
				'type'     => 'select',
				'title'    => esc_html__( 'Categories Width', 'pgs-core' ),
				'subtitle' => esc_html__( 'Select categories width', 'pgs-core' ),
				'options'  => array(
					'fixed' => esc_html__( 'Fixed', 'pgs-core' ),
					'wide'  => esc_html__( 'Wide', 'pgs-core' ),
				),
				'select2'  => array(
					'allowClear' => false,
				),
				'required' => array( 'show_category_on_shop_header', 'equals', '1' ),
				'default'  => 'fixed',
			),
			array(
				'id'            => 'shop_categories_per_page',
				'type'          => 'slider',
				'title'         => esc_html__( 'Number of Categories', 'pgs-core' ),
				'desc'          => esc_html__( 'Enter number of Categories show.', 'pgs-core' ),
				'default'       => 5,
				'min'           => 1,
				'step'          => 1,
				'max'           => 10,
				'display_value' => 'text',
				'required'      => array( 'show_category_on_shop_header', 'equals', '1' ),
			),
			/**********************************************************************************/
			array(
				'id'       => 'product_hover_style_section-start',
				'type'     => 'section',
				'title'    => esc_html__( 'Product Hover Style Settings', 'pgs-core' ),
				'subtitle' => esc_html__( 'Here you set product hover style.', 'pgs-core' ),
				'indent'   => true,
			),
			array(
				'id'       => 'product_hover_style_info',
				'type'     => 'info',
				'style'    => 'info',
				'desc'     => esc_html__( "Product hover summery will not display if it's used in slider.", 'pgs-core' ),
				'icon'     => 'el el-info-circle',
				'required' => array( 'product_hover_style', 'equals', 'hover-summary' ),
			),
			array(
				'id'          => 'product_hover_style',
				'type'        => 'select_image_new',
				'title'       => esc_html__( 'Product Hover Style', 'pgs-core' ),
				'placeholder' => esc_html__( 'Select product hover style.', 'pgs-core' ),
				'select2'     => array(
					'allowClear' => 0,
				),
				'options'     => array(
					'default'                   => array(
						'alt'   => esc_html__( 'Default', 'pgs-core' ),
						'title' => esc_html__( 'Default', 'pgs-core' ),
						'img'   => esc_url( PGSCORE_URL . 'images/options/product_hover_style/default.jpg' ),
					),
					'icon-top-left'             => array(
						'alt'   => esc_html__( 'Icon Top Left', 'pgs-core' ),
						'title' => esc_html__( 'Icon Top Left', 'pgs-core' ),
						'img'   => esc_url( PGSCORE_URL . 'images/options/product_hover_style/icon-top-left.jpg' ),
					),
					'icons-top-right'           => array(
						'alt'   => esc_html__( 'Icons Top Right', 'pgs-core' ),
						'title' => esc_html__( 'Icons Top Right', 'pgs-core' ),
						'img'   => esc_url( PGSCORE_URL . '/images/options/product_hover_style/icons-top-right.jpg' ),
					),
					'image-center'              => array(
						'alt'   => esc_html__( 'Icons Center', 'pgs-core' ),
						'title' => esc_html__( 'Icons Center', 'pgs-core' ),
						'img'   => esc_url( PGSCORE_URL . 'images/options/product_hover_style/image-center.jpg' ),
					),
					'image-icon-left'           => array(
						'alt'   => esc_html__( 'Image Left', 'pgs-core' ),
						'title' => esc_html__( 'Image Left', 'pgs-core' ),
						'img'   => esc_url( PGSCORE_URL . 'images/options/product_hover_style/image-icon-left.jpg' ),
					),
					'image-left'                => array(
						'alt'   => esc_html__( 'Standard Icons Left', 'pgs-core' ),
						'title' => esc_html__( 'Standard Icons Left', 'pgs-core' ),
						'img'   => esc_url( PGSCORE_URL . 'images/options/product_hover_style/image-left.jpg' ),
					),
					'image-icon-bottom'         => array(
						'alt'   => esc_html__( 'Image Bottom', 'pgs-core' ),
						'title' => esc_html__( 'Image Bottom', 'pgs-core' ),
						'img'   => esc_url( PGSCORE_URL . 'images/options/product_hover_style/image-icon-bottom.jpg' ),
					),
					'button-standard'           => array(
						'alt'   => esc_html__( 'Button Standard', 'pgs-core' ),
						'title' => esc_html__( 'Button Standard', 'pgs-core' ),
						'img'   => esc_url( PGSCORE_URL . '/images/options/product_hover_style/button-standard.jpg' ),
					),
					'icons-left'                => array(
						'alt'   => esc_html__( 'Icons Left', 'pgs-core' ),
						'title' => esc_html__( 'Icons Left', 'pgs-core' ),
						'img'   => esc_url( PGSCORE_URL . '/images/options/product_hover_style/icons-left.jpg' ),
					),
					'icons-rounded'             => array(
						'alt'   => esc_html__( 'Icons Rounded', 'pgs-core' ),
						'title' => esc_html__( 'Icons Rounded', 'pgs-core' ),
						'img'   => esc_url( PGSCORE_URL . '/images/options/product_hover_style/icons-rounded.jpg' ),
					),
					'icons-bottom-right'        => array(
						'alt'   => esc_html__( 'Icons Bottom Right', 'pgs-core' ),
						'title' => esc_html__( 'Icons Bottom Right', 'pgs-core' ),
						'img'   => esc_url( PGSCORE_URL . '/images/options/product_hover_style/icons-bottom-right.jpg' ),
					),
					'image-bottom'              => array(
						'alt'   => esc_html__( 'Icons Separate', 'pgs-core' ),
						'title' => esc_html__( 'Icons Separate', 'pgs-core' ),
						'img'   => esc_url( PGSCORE_URL . '/images/options/product_hover_style/image-bottom.jpg' ),
					),
					'image-bottom-2'            => array(
						'alt'   => esc_html__( 'Icons Bottom', 'pgs-core' ),
						'title' => esc_html__( 'Icons Bottom', 'pgs-core' ),
						'img'   => esc_url( PGSCORE_URL . '/images/options/product_hover_style/image-bottom-2.jpg' ),
					),
					'image-bottom-bar'          => array(
						'alt'   => esc_html__( 'Icons Bottom Bar', 'pgs-core' ),
						'title' => esc_html__( 'Icons Bottom Bar', 'pgs-core' ),
						'img'   => esc_url( PGSCORE_URL . '/images/options/product_hover_style/image-bottom-bar.jpg' ),
					),
					'info-bottom'               => array(
						'alt'   => esc_html__( 'Info Bottom', 'pgs-core' ),
						'title' => esc_html__( 'Info Bottom', 'pgs-core' ),
						'img'   => esc_url( PGSCORE_URL . '/images/options/product_hover_style/info-bottom.jpg' ),
					),
					'info-bottom-bar'           => array(
						'alt'   => esc_html__( 'Info Bottom Bar', 'pgs-core' ),
						'title' => esc_html__( 'Info Bottom Bar', 'pgs-core' ),
						'img'   => esc_url( PGSCORE_URL . '/images/options/product_hover_style/info-bottom-bar.jpg' ),
					),
					'hover-summary'             => array(
						'alt'   => esc_html__( 'Hover Summary', 'pgs-core' ),
						'title' => esc_html__( 'Hover Summary', 'pgs-core' ),
						'img'   => esc_url( PGSCORE_URL . '/images/options/product_hover_style/hover-summary.jpg' ),
					),
					'minimal-hover-cart'        => array(
						'alt'   => esc_html__( 'Minimal Hover Cart', 'pgs-core' ),
						'title' => esc_html__( 'Minimal Hover Cart', 'pgs-core' ),
						'img'   => esc_url( PGSCORE_URL . '/images/options/product_hover_style/minimal-hover-cart.jpg' ),
					),
					'minimal'                   => array(
						'alt'   => esc_html__( 'Minimal', 'pgs-core' ),
						'title' => esc_html__( 'Minimal', 'pgs-core' ),
						'img'   => esc_url( PGSCORE_URL . '/images/options/product_hover_style/minimal.jpg' ),
					),
					'info-transparent-center'   => array(
						'alt'   => esc_html__( 'Info Transparent Center', 'pgs-core' ),
						'title' => esc_html__( 'Info Transparent Center', 'pgs-core' ),
						'img'   => esc_url( PGSCORE_URL . '/images/options/product_hover_style/info-transparent-center.jpg' ),
					),
					'icons-transparent-center'  => array(
						'alt'   => esc_html__( 'Icons Transparent Center', 'pgs-core' ),
						'title' => esc_html__( 'Icons Transparent Center', 'pgs-core' ),
						'img'   => esc_url( PGSCORE_URL . '/images/options/product_hover_style/icons-transparent-center.jpg' ),
					),
					'standard-info-transparent' => array(
						'alt'   => esc_html__( 'Standard Info Transparent', 'pgs-core' ),
						'title' => esc_html__( 'Standard Info Transparent', 'pgs-core' ),
						'img'   => esc_url( PGSCORE_URL . '/images/options/product_hover_style/standard-info-transparent.jpg' ),
					),
					'standard-quick-shop'       => array(
						'alt'   => esc_html__( 'Standard Quick Shop', 'pgs-core' ),
						'title' => esc_html__( 'Standard Quick Shop', 'pgs-core' ),
						'img'   => esc_url( PGSCORE_URL . '/images/options/product_hover_style/standard-quick-shop.jpg' ),
					),
				),
				'default'     => 'image-center',
			),
			array(
				'id'       => 'product_image_swap',
				'type'     => 'switch',
				'title'    => esc_html__( 'Swape Image On Hover', 'pgs-core' ),
				'subtitle' => esc_html__( "Product image change on hover, This option will not work for mobile if 'Disable Hover Effect For Mobile' is enabled.", 'pgs-core' ),
				'on'       => esc_html__( 'Yes', 'pgs-core' ),
				'off'      => esc_html__( 'No', 'pgs-core' ),
				'default'  => true,
			),
			array(
				'id'       => 'disable_hover_effect_mobile',
				'type'     => 'switch',
				'title'    => esc_html__( 'Disable Hover Effect For Mobile', 'pgs-core' ),
				'subtitle' => esc_html__( 'Disable hover effect for mobile device, This will disable the double click on product for the Mobile devices.', 'pgs-core' ),
				'on'       => esc_html__( 'Yes', 'pgs-core' ),
				'off'      => esc_html__( 'No', 'pgs-core' ),
				'default'  => true,
			),
			array(
				'id'      => 'product_title_length',
				'type'    => 'button_set',
				'title'   => esc_html__( 'Product Title Length', 'pgs-core' ),
				'options' => array(
					'full'        => esc_html__( 'Full', 'pgs-core' ),
					'single_line' => esc_html__( 'Single Line', 'pgs-core' ),
				),
				'default' => 'single_line',
			),
			array(
				'id'       => 'show_product_desc',
				'type'     => 'button_set',
				'title'    => esc_html__( 'Show Product Descriptions.', 'pgs-core' ),
				'options'  => array(
					'yes' => esc_html__( 'Yes', 'pgs-core' ),
					'no'  => esc_html__( 'No', 'pgs-core' ),
				),
				'default'  => 'yes',
				'required' => array( 'product_hover_style', 'equals', 'hover-summary' ),
			),
			array(
				'id'       => 'product_desc_source',
				'type'     => 'button_set',
				'title'    => esc_html__( 'Product Descriptions From.', 'pgs-core' ),
				'desc'     => esc_html__( 'Select option for source of prodcuct description: main content Or short description.', 'pgs-core' ),
				'options'  => array(
					'product_contents'   => esc_html__( 'Product Contents', 'pgs-core' ),
					'product_short_desc' => esc_html__( 'Product Short Description', 'pgs-core' ),
				),
				'default'  => 'product_short_desc',
				'required' => array( 'product_hover_style', 'equals', 'hover-summary' ),
			),
			array(
				'id'       => 'product_hover_button_shape',
				'type'     => 'button_set',
				'title'    => esc_html__( 'Button Shape', 'pgs-core' ),
				'options'  => array(
					'square' => esc_html__( 'Square', 'pgs-core' ),
					'round'  => esc_html__( 'Round', 'pgs-core' ),
				),
				'default'  => 'square',
				'required' => array( 'product_hover_style', '=', array( 'image-center', 'image-icon-left', 'image-icon-bottom', 'image-left', 'image-bottom', 'image-bottom-2', 'info-bottom' ) ),
			),
			array(
				'id'       => 'product_hover_button_style',
				'type'     => 'button_set',
				'title'    => esc_html__( 'Button Style', 'pgs-core' ),
				'options'  => array(
					'flat'   => esc_html__( 'Flat', 'pgs-core' ),
					'border' => esc_html__( 'Border', 'pgs-core' ),
				),
				'default'  => 'flat',
				'required' => array( 'product_hover_style', '=', array( 'image-center', 'image-icon-bottom', 'image-icon-left', 'image-left', 'image-bottom' ) ),
			),
			array(
				'id'       => 'product_hover_bar_style',
				'type'     => 'button_set',
				'title'    => esc_html__( 'Bar Style', 'pgs-core' ),
				'options'  => array(
					'flat'   => esc_html__( 'Flat', 'pgs-core' ),
					'border' => esc_html__( 'Border', 'pgs-core' ),
				),
				'default'  => 'flat',
				'required' => array( 'product_hover_style', '=', array( 'image-bottom-bar', 'info-bottom-bar' ) ),
			),
			array(
				'id'       => 'product_hover_add_to_cart_position',
				'type'     => 'button_set',
				'title'    => esc_html__( '"Add to Cart" Position', 'pgs-core' ),
				'options'  => array(
					'center' => esc_html__( 'Center', 'pgs-core' ),
					'left'   => esc_html__( 'Left', 'pgs-core' ),
				),
				'default'  => 'center',
				'required' => array( 'product_hover_style', '=', array( 'image-bottom-bar', 'info-bottom', 'info-bottom-bar' ) ),
			),
			array(
				'id'       => 'product_hover_default_button_style',
				'type'     => 'button_set',
				'title'    => esc_html__( 'Button Style', 'pgs-core' ),
				'options'  => array(
					'dark'  => esc_html__( 'Dark', 'pgs-core' ),
					'light' => esc_html__( 'Light', 'pgs-core' ),
				),
				'default'  => 'light',
				'required' => array( 'product_hover_style', '=', array( 'default', 'icon-top-left', 'icons-top-right', 'image-left', 'button-standard', 'icons-left', 'icons-rounded', 'icons-bottom-right', 'hover-summary', 'minimal-hover-cart', 'minimal', 'standard-info-transparent', 'standard-quick-shop', 'image-bottom-2' ) ),
			),
			array(
				'id'       => 'product_hover_icon_type',
				'type'     => 'button_set',
				'title'    => esc_html__( 'Product Icons Type', 'pgs-core' ),
				'subtitle' => esc_html__( 'Overall Product Hover Icon Type.', 'pgs-core' ),
				'options'  => array(
					'fill-icon' => esc_html__( 'Flat Icons', 'pgs-core' ),
					'line-icon' => esc_html__( 'Line Icons', 'pgs-core' ),
				),
				'default'  => 'fill-icon',
			),
			array(
				'id'     => 'product_hover_style_section-end',
				'type'   => 'section',
				'indent' => false,
			),
			/*             * ********************************************************************************* */
			array(
				'id'       => 'product-in-stock-icon',
				'type'     => 'switch',
				'title'    => esc_html__( 'Display Available Stock', 'pgs-core' ),
				'subtitle' => esc_html__( 'Show and hide available stock count label.', 'pgs-core' ),
				'default'  => true,
				'on'       => esc_html__( 'Yes', 'pgs-core' ),
				'off'      => esc_html__( 'No', 'pgs-core' ),
			),
			array(
				'id'       => 'product-out-of-stock-icon',
				'type'     => 'switch',
				'title'    => esc_html__( 'Display Out Of Stock', 'pgs-core' ),
				'subtitle' => esc_html__( 'Show and hide out of stock label.', 'pgs-core' ),
				'default'  => true,
				'on'       => esc_html__( 'Yes', 'pgs-core' ),
				'off'      => esc_html__( 'No', 'pgs-core' ),
			),
			array(
				'id'       => 'woocommerce_mobile_sticky_footer',
				'type'     => 'switch',
				'title'    => esc_html__( 'Sticky Footer For Mobile Device', 'pgs-core' ),
				'subtitle' => esc_html__( 'Show and hide the sticky footer for mobile device', 'pgs-core' ),
				'desc'     => esc_html__( 'Enabling this option will display "Home", "Wishlist", "My Account", and "Cart" icons. Note that "Wishlist" is dependent on the YITH Wishlist plugin and "Cart" icon dependent on setting in theme options.', 'pgs-core' ),
				'default'  => true,
				'on'       => esc_html__( 'Show', 'pgs-core' ),
				'off'      => esc_html__( 'Hide', 'pgs-core' ),
			),
			array(
				'id'       => 'woocommerce_catalog_mode',
				'type'     => 'switch',
				'title'    => esc_html__( 'Just Catalog', 'pgs-core' ),
				'subtitle' => esc_html__( 'Disable "Add To Cart" button and shopping cart', 'pgs-core' ),
				'default'  => false,
			),
			array(
				'id'       => 'woocommerce_price_hide',
				'type'     => 'switch',
				'title'    => esc_html__( 'Hide Price', 'pgs-core' ),
				'subtitle' => esc_html__( 'Hide product price on Product pages', 'pgs-core' ),
				'default'  => false,
				'required' => array( 'woocommerce_catalog_mode', '=', true ),
			),
			array(
				'id'       => 'shop_countdown',
				'type'     => 'switch',
				'title'    => esc_html__( 'Countdown Timer', 'pgs-core' ),
				'subtitle' => esc_html__( 'Show timer for products that have scheduled date for the sale price', 'pgs-core' ),
				'default'  => false,
			),
			array(
				'id'       => 'hide_price_for_guest_user',
				'type'     => 'switch',
				'title'    => esc_html__( 'Hide Price & Cart Features for Guest User', 'pgs-core' ),
				'subtitle' => esc_html__( 'Hide "Price","Add to cart" and Cart for guest user', 'pgs-core' ),
				'desc'     => wp_kses(
					__( '<strong>Note</strong>: Enabling this option will hide "<u>Price</u>", "<u>Add to cart</u>" and <u>Cart</u> for the guest users.', 'pgs-core' ),
					array(
						'strong' => array(),
						'u'      => array(),
					)
				),
				'default'  => false,
			),
			array(
				'id'     => 'shop_page_banner-start',
				'type'   => 'section',
				'title'  => esc_html__( 'Shop Page Banner', 'pgs-core' ),
				'indent' => true,
			),
			array(
				'id'       => 'pro-shop-banner_show',
				'type'     => 'switch',
				'title'    => esc_html__( 'Shop Page Banner Display', 'pgs-core' ),
				'subtitle' => esc_html__( 'Show shop page banner at top of product listing.', 'pgs-core' ),
				'default'  => '1', // 1    = on | 0= off
			),
			array(
				'id'       => 'pro-shop-banner',
				'type'     => 'media',
				'url'      => true,
				'title'    => esc_html__( 'Shop Page Banner', 'pgs-core' ),
				'subtitle' => esc_html__( 'Upload any media using the WordPress native uploader', 'pgs-core' ),
				'default'  => array( 'url' => esc_url( get_parent_theme_file_uri( '/images/banner-lising.png' ) ) ),
				'required' => array( 'pro-shop-banner_show', '=', true ),
			),
		),
	);
}
