<?php
$menu_list_items         = isset( $settings['list_items'] ) ? $settings['list_items'] : '';
$menu_list_title         = isset( $settings['menu_list_title'] ) ? $settings['menu_list_title'] : '';

$this->add_render_attribute( 'widget_wrapper', 'class', 'pgscore_menu_list_wrapper' );
?>
<div <?php $this->print_render_attribute_string( 'widget_wrapper' ); ?>>
	<?php
	if ( $menu_list_title ) {
		?>
		<div class="pgscore_menu_list-title">
			<?php echo esc_html( $menu_list_title ); ?>
		</div>
		<?php
	}
	?>
	<ul class="pgscore_menu_list menu_list">
		<?php
		foreach ( $menu_list_items as $list_item ) {
			$li_class = 'elementor-repeater-item-' . $list_item['_id'];
			if ( isset( $list_item['menu_title'] ) && $list_item['menu_title'] ) {
				$link_attr = '';

				if ( isset( $list_item['menu_item_link']['url'] ) && $list_item['menu_item_link']['url'] ) {
					$target    = ( isset( $list_item['menu_item_link']['is_external'] ) && $list_item['menu_item_link']['is_external'] ) ? ' target="_blank"' : '';
					$nofollow  = ( isset( $list_item['menu_item_link']['nofollow'] ) && $list_item['menu_item_link']['nofollow'] ) ? ' rel="nofollow"' : '';
					$link_attr = 'href="' . $list_item['menu_item_link']['url'] . '"' . $target . $nofollow;
				}

				if ( ! $link_attr ) {
					$li_class .= ' empty-link';
				}
				?>
				<li class="<?php echo esc_attr( $li_class ); ?>">

					<?php
					if ( isset( $list_item['add_icon'] ) && 'yes' === $list_item['add_icon'] && isset( $list_item['icon'] ) && $list_item['icon'] ) {
						\Elementor\Icons_Manager::render_icon( $list_item['icon'], [ 'aria-hidden' => 'true' ] );
					}
					?>

					<?php
					if ( $link_attr && isset( $list_item['menu_title'] ) && $list_item['menu_title'] ) {
						?>
						<a class="menu_item_link" <?php echo $link_attr; ?>>
						<?php
					} else {
						?>
						<span class="menu-title">
						<?php
					}

					if ( isset( $list_item['menu_title'] ) && $list_item['menu_title'] ) {
						echo esc_html( $list_item['menu_title'] );
					}

					if ( isset( $list_item['menu_item_label'] ) && $list_item['menu_item_label'] ) {
						?>
						<span class="menu_item_label">
							<?php echo esc_html( $list_item['menu_item_label'] ); ?>
						</span>
						<?php
					}

					if ( $link_attr && isset( $list_item['menu_title'] ) && $list_item['menu_title'] ) {
						?>
						</a>
						<?php
					} else {
						?>
						</span>
						<?php
					}
					?>
				</li>
				<?php
			}
		}
		?>
	</ul>
</div>
