<?php
/**
 * Block: Sliders
 * 
 * @var array  $atts  Shortcode attribs.
 * @var string $tag   Shortcode used, example: highlights.
 * 
 * @var CheerUp_Block $block  Block object from the plugin.
 * @var WP_Query      $query  Query setup by block object.
 * 
 * @see CheerUp_Block::process()
 * @see CheerUp_ShortCodes::_render()
 */

// Add VC design CSS class if needed
$extra_class = '';
if (!empty($css) && function_exists('vc_shortcode_custom_css_class')) {
	$extra_class = apply_filters(VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class($css, ' '), $tag, $atts);
}

$slider_type = !empty($type) ? $type : '';

// Legacy: Fix grids that have changed.
if ($slider_type == 'grid') {
	$slider_type = 'grid-b';
}
else if ($slider_type == 'grid-tall') {
	$slider_type = 'grid-c';
}

?>

	<section <?php Bunyad::markup()->attribs('slider-block', array('class' => array('cf block', $tag, $extra_class), 'data-id' => $block->block_id)); ?>>
	
		<?php echo $block->output_heading(); // XSS ok. HTML generated by CheerUp_Block::output_heading()  ?>
		
		<div class="block-content">
		<?php
		
			/**
			 * Get slider template
			 */
			if (strpos($slider_type, 'grid') === false) {

				$template = 'partials/slider';
				if ($slider_type != 'default') {
					$template .= '-' . sanitize_file_name($slider_type);
				}
			
				Bunyad::core()->partial($template, compact('query', 'slider_parallax'));
			}
			else {

				Bunyad::core()->partial('partials/featured-grid', [
					'query'      => $query, 
					'grid_type'  => $slider_type,
					'grid_width' => $slider_width,
					'has_slider' => !$slider_static
				]);
			}
		
		?>
		</div>
	
	</section>

<?php wp_reset_postdata(); ?>