<?php 
    $ceris_option = ceris_core::bk_get_global_var('ceris_option');
    if ((isset($ceris_option['bk-offcanvas-mobile-logo'])) && (($ceris_option['bk-offcanvas-mobile-logo']) != NULL)){ 
        $logo = $ceris_option['bk-offcanvas-mobile-logo'];
        if (($logo != null) && (array_key_exists('url',$logo))) {
            if ($logo['url'] == '') {
                $logo = ceris_core::bk_get_theme_option('bk-logo');
            }
        }
    }else {
        $logo = ceris_core::bk_get_theme_option('bk-logo');
    }
    // logo dark mode
    $logoDarkMode   = ceris_core::bk_get_theme_option('bk-offcanvas-mobile-logo-dark-mode');
    $logoDarkModeClass = '';
    if (empty($logoDarkMode) || ($logoDarkMode['url'] == '') || !(array_key_exists('url',$logoDarkMode)) ) :
        $logoDarkModeClass = ' not-exist-img-logo';
    endif;
    $darkModeEnabled = ( isset($ceris_option['bk_enable_darkmode']) && $ceris_option['bk_enable_darkmode'] ) ? true : false;
    $darkModeSW      = ( $darkModeEnabled && isset($ceris_option['bk_darkmode_sw']) && $ceris_option['bk_darkmode_sw'] ) ? true : false;
    $darkModeActive  = ceris_core::bk_get_darkmode_cookie();
    $logoDarkModeActiveClass = $darkModeActive ? ' logo-dark-mode-active' : '';
?>
<!-- Off-canvas menu -->
<div id="atbs-ceris-offcanvas-mobile" class="atbs-ceris-offcanvas js-atbs-ceris-offcanvas js-perfect-scrollbar">
	<div class="atbs-ceris-offcanvas__title">
		<h2 class="site-logo atbs-ceris-logo<?php echo esc_attr($logoDarkModeActiveClass); ?><?php echo esc_attr($logoDarkModeClass); ?>">
            <a href="<?php echo esc_url(get_home_url('/'));?>">
				<!-- logo open -->
                <?php if (($logo != null) && (array_key_exists('url',$logo))) {
                        if ($logo['url'] != '') {
                    ?>
                    <img class="ceris-img-logo active" src="<?php echo esc_url($logo['url']);?>" alt="<?php esc_attr_e('logo', 'ceris');?>"/>
                    <!-- logo dark mode -->
                    <?php if ( ($logo != null) && (array_key_exists('url',$logo)) && ($logoDarkMode != null) && (array_key_exists('url',$logoDarkMode)) ) {
                        if ($logoDarkMode['url'] != '') {?>
                        <img class="ceris-img-logo" src="<?php echo esc_url($logoDarkMode['url']);?>" alt="<?php esc_attr_e('logo', 'ceris');?>"/>
                    <?php }
                    }  ?>
                    <!-- logo dark mode -->
    			<!-- logo close -->
                <?php } else {?>
                    <?php echo (bloginfo( 'name' ));?>
                <?php }
                } else {?>
                    <?php echo (bloginfo( 'name' ));?>
                <?php } ?>
			</a>
        </h2>
        <?php if ( isset($ceris_option ['bk-offcanvas-mobile-social']) && ($ceris_option ['bk-offcanvas-mobile-social'] != '') ){ ?>
		<ul class="social-list list-horizontal">
			<?php echo ceris_core::bk_get_social_media_links($ceris_option['bk-offcanvas-mobile-social']);?>
		</ul>
        <?php }?>
		<a href="#atbs-ceris-offcanvas-mobile" class="atbs-ceris-offcanvas-close js-atbs-ceris-offcanvas-close" aria-label="Close"><span aria-hidden="true">&#10005;</span></a>
	</div>

	<div class="atbs-ceris-offcanvas__section atbs-ceris-offcanvas__section-navigation">
		<?php 
            if ( isset($ceris_option ['bk-offcanvas-mobile-menu']) && ($ceris_option ['bk-offcanvas-mobile-menu'] != '') ){
                if ( has_nav_menu( $ceris_option ['bk-offcanvas-mobile-menu'] ) ) : 
                    $menuSettings = array( 
                        'theme_location' => $ceris_option ['bk-offcanvas-mobile-menu'],
                        'container_id' => 'offcanvas-menu-mobile',
                        'menu_class'    => 'navigation navigation--offcanvas',
                        'depth' => '5' 
                    );
                    wp_nav_menu($menuSettings);
                elseif ( has_nav_menu( 'main-menu' ) ) : 
                    $menuSettings = array( 
                        'theme_location' => 'main-menu',
                        'container_id' => 'offcanvas-menu-mobile',
                        'menu_class'    => 'navigation navigation--offcanvas',
                        'depth' => '5' 
                    );
                    wp_nav_menu($menuSettings);
                endif;
            }
        ?>
	</div>
    
    <?php if(isset($ceris_option['bk-offcanvas-mobile-mailchimp-shortcode']) && ($ceris_option['bk-offcanvas-mobile-mailchimp-shortcode'] != '')) :?>
	<div class="atbs-ceris-offcanvas__section">
		<div class="subscribe-form subscribe-form--horizontal text-center">
            <?php echo do_shortcode($ceris_option['bk-offcanvas-mobile-mailchimp-shortcode']);?>
		</div>
	</div>
    <?php endif;?>

</div><!-- Off-canvas menu -->