<?php 
    $ceris_option = ceris_core::bk_get_global_var('ceris_option');
    $logo   = ceris_core::bk_get_theme_option('bk-logo');
    $logoSOption  = ceris_core::bk_get_theme_option('bk-site-logo-size-option');
    if($logoSOption == 'customize') {
        $logoW   = ceris_core::bk_get_theme_option('site-logo-width');
    }else {
        $logoW = '';
    }
    if ((isset($ceris_option['bk-header-inverse'])) && (($ceris_option['bk-header-inverse']) == 1)){ 
        $inverseClass = 'yes';
    }else {
        $inverseClass = '';
    }  
    if ( has_nav_menu( 'top-menu' ) && isset($ceris_option ['bk-social-header']) && !empty($ceris_option ['bk-social-header']) ) : 
        $top_menu = 1;
    else:
        $top_menu = 0;
    endif;
    // logo dark mode
    $logoDarkMode   = ceris_core::bk_get_theme_option('bk-logo-dark-mode');
    $logoDarkModeClass = '';
    if (empty($logoDarkMode) || ($logoDarkMode['url'] == '') || !(array_key_exists('url',$logoDarkMode)) ) :
        $logoDarkModeClass = ' not-exist-img-logo';
    endif;
    $darkModeEnabled = ( isset($ceris_option['bk_enable_darkmode']) && $ceris_option['bk_enable_darkmode'] ) ? true : false;
    $darkModeSW      = ( $darkModeEnabled && isset($ceris_option['bk_darkmode_sw']) && $ceris_option['bk_darkmode_sw'] ) ? true : false;
    $darkModeActive  = ceris_core::bk_get_darkmode_cookie();
    $logoDarkModeActiveClass = $darkModeActive ? ' logo-dark-mode-active' : '';
?>
<header class="site-header ">
    <?php if ($top_menu == 1 ){ ?>
    <!-- Top bar -->
	<div class="top-bar top-bar--fullwidth top-bar--inverse hidden-xs hidden-sm">
		<div class="container">
			<div class="top-bar__inner top-bar__inner--flex">
				<div class="top-bar__section">
					<div class="top-bar__nav">
						<?php 
                            if ( has_nav_menu( 'top-menu' ) ) : 
                                $menuSettings = array( 
                                    'theme_location' => 'top-menu',
                                    'container_id' => 'top-menu',
                                    'menu_class'    => 'navigation navigation--top navigation--center',
                                    'depth' => '10' 
                                );
                                wp_nav_menu($menuSettings);
                            endif;
                        ?>
					</div>
				</div>
				<div class="top-bar__section">
                    <?php if ( isset($ceris_option ['bk-social-header']) && !empty($ceris_option ['bk-social-header']) ){ ?>
    					<ul class="social-list social-list--sm social-list--inverse list-horizontal">
    						<?php echo ceris_core::bk_get_social_media_links($ceris_option['bk-social-header']);?>            						
    					</ul>
                    <?php }?>
				</div>
			</div>
		</div>
	</div><!-- Top bar -->
    <?php }?>
    <!-- Header content -->
	<div class="header-main hidden-xs hidden-sm">
        <?php if (isset($ceris_option['bk-header-bg-style']) && ($ceris_option['bk-header-bg-style'] == 'image')) :?>
		<div class="background-img-wrapper">
			<div class="background-img"></div>
		</div>
        <?php endif;?>
		<div class="container">
			<div class="row row--flex row--vertical-center">
				<div class="col-xs-3">
                    <?php if((isset($ceris_option['bk-header-subscribe-switch'])) && ($ceris_option['bk-header-subscribe-switch'] == 1)):?>
                        <a href="#subscribe-modal" class="btn btn-default" data-toggle="modal" data-target="#subscribe-modal"><i class="mdicon mdicon-mail_outline mdicon--first"></i><span><?php esc_html_e('Subscribe', 'ceris');?></span></a>
                    <?php endif;?>
				</div>
				<div class="col-xs-6">
					<div class="header-logo text-center atbs-ceris-logo<?php echo esc_attr($logoDarkModeActiveClass); ?><?php echo esc_attr($logoDarkModeClass); ?>">
						<a href="<?php echo esc_url(get_home_url('/'));?>">
    						<!-- logo open -->
                            <?php if (($logo != null) && (array_key_exists('url',$logo))) {
                                    if ($logo['url'] != '') {
                                ?>
                                <img class="ceris-img-logo active" src="<?php echo esc_url($logo['url']);?>" alt="<?php esc_attr_e('logo', 'ceris');?>" <?php if($logoW != '') {echo 'width="'.esc_attr($logoW).'px"';}?>/>
                                    <!-- logo dark mode -->
                                    <?php if ( ($logo != null) && (array_key_exists('url',$logo)) && ($logoDarkMode != null) && (array_key_exists('url',$logoDarkMode)) ) {
                                        if ($logoDarkMode['url'] != '') {?>
                                        <img class="ceris-img-logo" src="<?php echo esc_url($logoDarkMode['url']);?>" alt="<?php esc_attr_e('logo', 'ceris');?>"  <?php if($logoW != '') {echo 'width="'.esc_attr($logoW).'px"';}?>/>
                                    <?php }
                                    }  ?>
                                    <!-- logo dark mode -->
                            <?php } else {?>
                                <span class="logo-text">
                                <?php bloginfo('name');?>
                                </span>
                            <?php }
                            } else {?>
                                <span class="logo-text">
                                <?php bloginfo('name');?>
                                </span>
                            <?php } ?>
                            <!-- logo close -->
    					</a>
					</div>
				</div>
				<div class="col-xs-3 text-right">
                    <div class="lwa lwa-template-modal">
                        <?php 
                            if ( function_exists('login_with_ajax') ) {  
                                $bk_home_url = esc_url(get_home_url('/'));
                                $ajaxArgs = array(
                                    'profile_link' => true,
                                    'template' => 'modal',
                                    'registration' => true,
                                    'remember' => true,
                                    'redirect'  => $bk_home_url
                                );
                                login_with_ajax($ajaxArgs);  
                                if(!is_user_logged_in()) {
                                    echo '<a href="#login-modal" class="btn btn-default" data-toggle="modal" data-target="#login-modal"><i class="mdicon mdicon-person mdicon--first"></i><span>'.esc_html__('Login', 'ceris').'</span></a>';
                                }
                        }?>
                    </div>
				</div>
			</div>
		</div>
	</div><!-- Header content -->
    <?php get_template_part( 'library/templates/header/atbs-mobile-header' ); ?>
    <!-- Navigation bar -->
	<nav class="navigation-bar navigation-bar--fullwidth navigation-custom-bg-color <?php if($inverseClass == "yes") echo " navigation-bar--inverse"; ?> hidden-xs hidden-sm js-sticky-header-holder">
		<div class="container">
			<div class="navigation-bar__inner">
                <?php if (is_active_sidebar('offcanvas-widget-area') || has_nav_menu( 'main-menu' ) || has_nav_menu( 'offcanvas-menu' )):?>
                    <?php if ( isset($ceris_option ['bk-offcanvas-desktop-switch']) && ($ceris_option ['bk-offcanvas-desktop-switch'] != 0) ){ ?>
    				<div class="navigation-bar__section flexbox flexbox-center-y">
    					<div class="menu-icon">
                            <a href="#atbs-ceris-offcanvas-primary" class="offcanvas-menu-toggle navigation-bar-btn js-atbs-ceris-offcanvas-toggle">
                                <span></span>
                            </a>
                        </div>
                        <?php if ( $darkModeSW ) : get_template_part( 'library/templates/header/atbs-theme-switch' ); endif; ?>
    				</div>
                    <?php }?>
                <?php endif;?>

				<div class="navigation-wrapper navigation-bar__section js-priority-nav text-center">
					<?php 
                        if ( has_nav_menu( 'main-menu' ) ) : 
                            $menuSettings = array( 
                                'theme_location' => 'main-menu',
                                'container_id' => 'main-menu',
                                'menu_class'    => 'navigation navigation--main navigation--inline',
                                'walker' => new BK_Walker,
                            );
                            wp_nav_menu($menuSettings);
                        endif;
                    ?>
				</div>

				<div class="navigation-bar__section flexbox-wrap flexbox-center-y <?php if(is_user_logged_in()) echo 'has-bookmark-list';?>">
                    <?php
                        if(is_user_logged_in()) : 
                            get_template_part( 'library/templates/bookmark/header-bookmark' ); 
                        endif;        
                    ?>
					<button type="submit" class="navigation-bar-btn js-search-popup"><i class="mdicon mdicon-search"></i></button>
				</div>
			</div><!-- .navigation-bar__inner -->
		</div><!-- .container -->
	</nav><!-- Navigation-bar -->
</header><!-- Site header -->