<?php 
	$ceris_option = ceris_core::bk_get_global_var('ceris_option');
	$logo   = ceris_core::bk_get_theme_option('bk-logo');
    $mobileLogo   = ceris_core::bk_get_theme_option('bk-mobile-logo');
    if (($mobileLogo != null) && (array_key_exists('url',$mobileLogo))) {
        if ($mobileLogo['url'] == '') {
            $mobileLogo = $logo;
        }
    }else {
        $mobileLogo = $logo;
    }
    $mLogoSOption  = ceris_core::bk_get_theme_option('bk-mobile-logo-size-option');
    if($mLogoSOption == 'customize') {
        $mLogoW   = ceris_core::bk_get_theme_option('site-mobile-logo-width');
    }else {
        $mLogoW = '';
    }
	if ((isset($ceris_option['bk-mobile-menu-inverse'])) && (($ceris_option['bk-mobile-menu-inverse']) == 1)){ 
        $inverseClass_Mobile = 'yes';
    }else {
        $inverseClass_Mobile = '';
    }
	// logo dark mode
    $logoDarkMode   = ceris_core::bk_get_theme_option('bk-mobile-logo-dark-mode');
    $logoDarkModeClass = '';
    if (empty($logoDarkMode) || ($logoDarkMode['url'] == '') || !(array_key_exists('url',$logoDarkMode)) ) :
        $logoDarkModeClass = ' not-exist-img-logo';
    endif;
    $darkModeEnabled = ( isset($ceris_option['bk_enable_darkmode']) && $ceris_option['bk_enable_darkmode'] ) ? true : false;
    $darkModeSW      = ( $darkModeEnabled && isset($ceris_option['bk_darkmode_sw']) && $ceris_option['bk_darkmode_sw'] ) ? true : false;
    $darkModeActive  = ceris_core::bk_get_darkmode_cookie();
    $logoDarkModeActiveClass = $darkModeActive ? ' logo-dark-mode-active' : '';
?>
<!-- Mobile header -->
<div id="atbs-ceris-mobile-header" class="mobile-header visible-xs visible-sm <?php if($inverseClass_Mobile == "yes") echo " mobile-header--inverse";?>">
    <div class="mobile-header__inner mobile-header__inner--flex">
        <!-- mobile logo open -->
        <div class="header-branding header-branding--mobile mobile-header__section text-left">
            <div class="header-logo header-logo--mobile flexbox__item text-left atbs-ceris-logo<?php echo esc_attr($logoDarkModeActiveClass); ?><?php echo esc_attr($logoDarkModeClass); ?>">
                <a href="<?php echo esc_url(get_home_url('/'));?>">
                    <?php if (($mobileLogo != null) && (array_key_exists('url',$mobileLogo))) {
                        if ($mobileLogo['url'] != '') {
                    ?>
                    <img class="ceris-img-logo active" src="<?php echo esc_url($mobileLogo['url']);?>" alt="<?php esc_attr_e('mobileLogo', 'ceris');?>" <?php if($mLogoW != '') {echo 'width="'.esc_attr($mLogoW).'"';}?>/>
                    <!-- logo dark mode -->
                    <?php if ( ($mobileLogo != null) && (array_key_exists('url',$mobileLogo)) && ($logoDarkMode != null) && (array_key_exists('url',$logoDarkMode)) ) {
                        if ($logoDarkMode['url'] != '') {?>
                        <img class="ceris-img-logo" src="<?php echo esc_url($logoDarkMode['url']);?>" alt="<?php esc_attr_e('logo', 'ceris');?>" <?php if($mLogoW != '') {echo 'width="'.esc_attr($mLogoW).'"';}?>/>
                    <?php }
                    }  ?>
                    <!-- logo dark mode -->

                    <?php 
                    } else {?>
                            <span class="logo-text">
                            <?php bloginfo('name');?>
                            </span>
                    <?php }
                    } else {?>
                        <span class="logo-text">
                        <?php bloginfo('name');?>
                        </span>
                    <?php } ?>                        
                </a>               
            </div>
        </div>
        <!-- logo close -->
        <div class="mobile-header__section text-right">
            <div class="flexbox flexbox-center-y<?php if(is_user_logged_in()) echo ' has-bookmark-list';?>">
                <?php
                    if(is_user_logged_in()) : 
                        get_template_part( 'library/templates/bookmark/header-bookmark-mobile' ); 
                    endif;        
                ?>
                <button type="submit" class="mobile-header-btn js-search-popup">
                    <span class="hidden-xs"></span><i class="mdicon mdicon-search mdicon--last hidden-xs"></i><i class="mdicon mdicon-search visible-xs-inline-block"></i>
                </button>
                <?php if ( $darkModeSW ) : get_template_part( 'library/templates/header/atbs-theme-switch' ); endif; ?>
                <?php 
                    if ( function_exists('login_with_ajax') ) {  
                        $bk_home_url = esc_url(get_home_url('/'));
                        $ajaxArgs = array(
                            'profile_link' => true,
                            'template' => 'modal',
                            'registration' => true,
                            'remember' => true,
                            'redirect'  => $bk_home_url
                        );
                        login_with_ajax($ajaxArgs);  
                        if(!is_user_logged_in()) {
                            echo '<a href="#login-modal" class="navigation-bar__login-btn navigation-bar-btn" data-toggle="modal" data-target="#login-modal"><i class="mdicon mdicon-person"></i></a>';
                        }
                }?>
                <?php if (is_active_sidebar('mobile-offcanvas-widget-area') || has_nav_menu( 'main-menu' ) || has_nav_menu( 'offcanvas-menu' )):?>
                <div class="menu-icon">
                    <a href="#atbs-ceris-offcanvas-mobile" class="offcanvas-menu-toggle mobile-header-btn js-atbs-ceris-offcanvas-toggle">
                        <span class="mdicon--last hidden-xs"></span>
                        <span class="visible-xs-inline-block"></span>
                    </a>
                </div>
                <?php endif;?>
            </div>
        </div>
    </div>
</div><!-- Mobile header --> 