<?php
if (!class_exists('ceris_thumb_overlap')) {
    class ceris_thumb_overlap {
        
        function render($postAttr) {
            ob_start();
            $postID = $postAttr['postID'];
            $bk_permalink = get_permalink($postID);
            $bk_post_title = get_the_title($postID);
            
            if(isset($postAttr['postIcon']) && ($postAttr['postIcon'] != '')) {
                $postIcon = $postAttr['postIcon']; 
            }else {
                $postIcon = '';
            }
            
            if(isset($postAttr['catClass']) && ($postAttr['catClass'] != '')) {
                $catClass = $postAttr['catClass']; 
            }else {
                $catClass = '';
            }
            $thumbAttr = array (
                'postID'        => $postID,
                'thumbSize'     => $postAttr['thumbSize'],                                
            );
            $theBGLink = ceris_core::bk_get_post_thumbnail_bg_link($thumbAttr);
            $thumbMobileAttr = array (
                'postID'        => $postID,
                'thumbSize'     => $postAttr['thumbSizeMobile'],                                
            );
            $theBGMobileLink = ceris_core::bk_get_post_thumbnail_bg_link($thumbMobileAttr);
            if (isset($postAttr['DarkMode']) && ($postAttr['DarkMode'] != '')) :
                $data_dark_mode = 'true';
            else:
                $data_dark_mode = 'false';
            endif;
            ?>
            <article class="post--thumb-overlap" data-dark-mode="<?php echo esc_attr($data_dark_mode);?>">
				<div class="post__wrap">
					<div class="background-svg-pattern-inverse"></div>
					<div class="post__thumb">
						<a href="<?php echo esc_url($bk_permalink);?>">
							<img class="visible-xs" src="<?php echo esc_url($theBGMobileLink);?>" alt="<?php esc_attr_e('image', 'ceris');?>">
							<div class="background-img hidden-xs" style="background-image: url('<?php echo esc_url($theBGLink);?>');"></div>
						</a>
                        <?php 
                        if($postIcon != '') :
                            echo ceris_core::bk_get_post_icon($postID, $postIcon);
                        endif;
                        ?>
                        <?php if(isset($postAttr['cat']) && ($postAttr['cat'] == '1')) echo ceris_core::bk_get_post_cat_link($postID, $catClass);?>
					</div>
					<div class="post__text">
						<div class="post__meta">
							<?php if(isset($postAttr['cat']) && ($postAttr['cat'] != '') && ($postAttr['cat'] != 1)) echo ceris_core::bk_get_post_cat_link($postID, $catClass);?>
						</div>
						<h3 class="post__title <?php if(isset($postAttr['typescale'])) echo esc_attr($postAttr['typescale']);?>"><a href="<?php echo esc_url($bk_permalink);?>"><?php echo esc_attr($bk_post_title);?></a></h3>
						<?php if (isset($postAttr['meta']) && ($postAttr['meta'] != '')) :?>
                        <div class="post__meta">
							<?php echo ceris_core::bk_meta_cases($postAttr['meta'][0]);?>
						</div>
                        <?php endif;?>
                        <?php if(isset($postAttr['except_length']) && ($postAttr['except_length'] != null)) :?>
						<div class="post__excerpt <?php if(isset($postAttr['additionalExcerptClass']) && ($postAttr['additionalExcerptClass'] != null)) echo esc_attr($postAttr['additionalExcerptClass']);?>">
							<?php echo ceris_core::bk_get_post_excerpt($postAttr['except_length']);?>
						</div>
                        <?php endif;?>
						<?php if (isset($postAttr['meta']) && ($postAttr['meta'] != '')) :?>
                        <div class="post__meta">
							<?php echo ceris_core::bk_meta_cases($postAttr['meta'][1]);?>
							<?php echo ceris_core::bk_meta_cases($postAttr['meta'][2]);?>
						</div>
                        <?php endif;?>
					</div>
				</div>
			</article>
            <?php return ob_get_clean();
        }
        
    }
}