<?php
$ceris_default_options = array
(
    'last_tab' => '',
    'bk-primary-color' => '#3545ee',
    'html-font-size' => array
        (
            'font-size' => '14px',
        ),
    'bk-margin-block' => array
        (
            'margin-bottom' => '',
            'units' => 'px',
        ),
    'bk-block-heading-margin' => array
        (
            'margin-bottom' => '',
            'units' => 'px',
        ),
    'body-typography' => array
        (
            'font-family' => 'Roboto',
            'font-options' => '',
            'google' => '1',
            'font-backup' => 'Arial, Helvetica, sans-serif',
            'subsets' => '',
            'letter-spacing' => '',
        ),
    'heading-typography' => array
        (
            'font-family' => 'Poppins',
            'font-options' => '',
            'google' => '1',
            'font-backup' => 'Arial, Helvetica, sans-serif',
            'subsets' => '',
            'text-transform' => '',
            'letter-spacing' => '',
        ),
    'secondary-typography' => array
        (
            'font-family' => 'Poppins',
            'font-options' => '',
            'google' => '1',
            'font-backup' => 'Arial, Helvetica, sans-serif',
            'subsets' => '',
            'letter-spacing' => '',
        ),
    'tertiary-typography' => array
        (
            'font-family' => 'Poppins',
            'font-options' => '',
            'google' => '1',
            'font-backup' => 'Arial, Helvetica, sans-serif',
            'subsets' => '',
            'letter-spacing' => '',
        ),
    'navigation-typography' => array
        (
            'font-family' => 'Rubik',
            'font-options' => '',
            'google' => '1',
            'font-backup' => 'Arial, Helvetica, sans-serif',
            'font-weight' => '',
            'font-style' => '',
            'text-transform' => 'uppercase',
            'font-size' => '',
            'letter-spacing' => '',
        ),
    'sub-navigation-typography' => array
        (
            'font-family' => 'Rubik',
            'font-options' => '',
            'google' => '1',
            'font-backup' => 'Arial, Helvetica, sans-serif',
            'font-weight' => '',
            'font-style' => '',
            'text-transform' => 'uppercase',
            'font-size' => '',
            'letter-spacing' => '',
        ),
    'offcanvas-navigation-typography' => array
        (
            'font-family' => 'Rubik',
            'font-options' => '',
            'google' => '1',
            'font-backup' => 'Arial, Helvetica, sans-serif',
            'font-weight' => '400',
            'font-style' => '',
            'text-transform' => 'uppercase',
            'font-size' => '',
            'letter-spacing' => '',
        ),
    'off-canvas-sub-navigation-typography' => array
        (
            'font-family' => 'Rubik',
            'font-options' => '',
            'google' => '1',
            'font-backup' => 'Arial, Helvetica, sans-serif',
            'font-weight' => '',
            'font-style' => '',
            'text-transform' => 'uppercase',
            'font-size' => '',
            'letter-spacing' => '',
        ),
    'footer-navigation-typography' => array
        (
            'font-family' => 'Rubik',
            'font-options' => '',
            'google' => '1',
            'font-backup' => 'Arial, Helvetica, sans-serif',
            'font-weight' => '',
            'font-style' => '',
            'text-transform' => 'uppercase',
            'font-size' => '',
            'letter-spacing' => '',
        ),
    'bk-load-more-text' => 'Load more news',
    'bk-no-more-text' => 'No more news',
    'bk-default-module-heading' => 'no-line',
    'module-heading-font' => array
        (
            'font-family' => 'Poppins',
            'font-options' => '',
            'google' => '1',
            'font-backup' => 'Arial, Helvetica, sans-serif',
            'font-weight' => '',
            'font-style' => '',
            'subsets' => '',
            'text-transform' => '',
            'font-size' => '',
            'letter-spacing' => '',
        ),
    'single-section-heading-font' => array
        (
            'font-family' => 'Poppins',
            'font-options' => '',
            'google' => '1',
            'font-backup' => 'Arial, Helvetica, sans-serif',
            'font-weight' => '',
            'font-style' => '',
            'subsets' => '',
            'text-transform' => '',
            'font-size' => '',
            'letter-spacing' => '',
        ),
    'module-sub-heading-font' => array
        (
            'font-family' => 'Poppins',
            'font-options' => '',
            'google' => '1',
            'font-backup' => 'Arial, Helvetica, sans-serif',
            'font-weight' => '',
            'font-style' => '',
            'subsets' => '',
            'text-transform' => '',
            'font-size' => '',
            'letter-spacing' => '',
            'color' => '',
        ),
    'bk-default-widget-heading' => 'line',
    'bk-header-type' => 'site-header-1',
    'bk-header-bg-style' => 'default',
    'bk-header-bg-image' => array
        (
            'background-repeat' => '',
            'background-size' => '',
            'background-attachment' => 'fixed',
            'background-position' => 'center center',
            'background-image' => '',
            'media' => array
                (
                    'id' => '',
                    'height' => '',
                    'width' => '',
                    'thumbnail' => '',
                ),
        ),
    'bk-header-bg-gradient' => array
        (
            'from' => '#1e73be',
            'to' => '#00897e',
        ),
    'bk-header-bg-gradient-direction' => '',
    'bk-header-bg-color' => array
        (
            'background-color' => '#fff',
        ),
    'bk-header-spacing' => array
        (
            'padding-top' => '40px',
            'padding-bottom' => '40px',
            'units' => 'px',
        ),
    'bk-main-menu-bg-color' => array
        (
            'background-color' => '#fff',
        ),
    'bk-header-inverse' => '0',
    'bk-header-element-inverse' => '0',
    'bk-header-module-layout' => 'feature-module-b',
    'header-module-pick-posts-switch' => '1',
    'header-module-pick-posts' => '',
    'header-module-exclude-posts' => '',
    'header-module-featured-post-switch' => 'yes',
    'header-module-post-limit' => '8',
    'bk-logo' => array
        (
            'url' => '',
            'id' => '',
            'height' => '',
            'width' => '',
            'thumbnail' => '',
            'title' => '',
            'caption' => '',
            'alt' => '',
            'description' => '',
        ),
    'bk-site-logo-size-option' => 'original',
    'site-logo-width' => '300',
    'bk-mobile-logo' => array
        (
            'url' => '',
            'id' => '',
            'height' => '',
            'width' => '',
            'thumbnail' => '',
            'title' => '',
            'caption' => '',
            'alt' => '',
            'description' => '',
        ),
    'bk-mobile-logo-size-option' => 'original',
    'site-mobile-logo-width' => '300',
    'bk-mobile-menu-bg-style' => 'default',
    'bk-mobile-menu-bg-gradient' => array
        (
            'from' => '#1e73be',
            'to' => '#00897e',
        ),
    'bk-mobile-menu-bg-gradient-direction' => '',
    'bk-mobile-menu-bg-color' => array
        (
            'background-color' => '#fff',
        ),
    'bk-mobile-menu-inverse' => '0',
    'bk-sticky-menu-switch' => '1',
    'bk-sticky-header-logo' => array
        (
            'url' => '',
            'id' => '',
            'height' => '',
            'width' => '',
            'thumbnail' => '',
            'title' => '',
            'caption' => '',
            'alt' => '',
            'description' => '',
        ),
    'bk-sticky-logo-size-option' => 'original',
    'site-sticky-logo-width' => '300',
    'bk-sticky-menu-bg-style' => 'default',
    'bk-sticky-menu-bg-gradient' => array
        (
            'from' => '#1e73be',
            'to' => '#00897e',
        ),
    'bk-sticky-menu-bg-gradient-direction' => '',
    'bk-sticky-menu-bg-color' => array
        (
            'background-color' => '#fff',
        ),
    'bk-sticky-menu-inverse' => '0',
    'bk-offcanvas-desktop-switch' => '1',
    'bk-offcanvas-desktop-menu' => 'offcanvas-menu',
    'bk-offcanvas-desktop-logo' => array
        (
            'url' => '',
            'id' => '',
            'height' => '',
            'width' => '',
            'thumbnail' => '',
            'title' => '',
            'caption' => '',
            'alt' => '',
            'description' => '',
        ),
    'bk-offcanvas-desktop-subscribe-switch' => '0',
    'bk-offcanvas-desktop-mailchimp-shortcode' => '',
    'bk-offcanvas-mobile-menu' => 'main-menu',
    'bk-offcanvas-mobile-logo' => array
        (
            'url' => '',
            'id' => '',
            'height' => '',
            'width' => '',
            'thumbnail' => '',
            'title' => '',
            'caption' => '',
            'alt' => '',
            'description' => '',
        ),
    'bk-offcanvas-mobile-subscribe-switch' => '0',
    'bk-offcanvas-mobile-mailchimp-shortcode' => '',
    'bk-header-ads' => '0',
    'bk-ads-html' => '',
    'bk-header-subscribe-switch' => '0',
    'bk-mailchimp-title' => '',
    'bk-mailchimp-shortcode' => '',
    'bk-single-header-switch' => '0',
    'bk-single-header-type' => 'site-header-1',
    'bk-single-header-spacing' => array
        (
            'padding-top' => '40px',
            'padding-bottom' => '40px',
            'units' => 'px',
        ),
    'bk-category-header-switch' => '0',
    'bk-category-header-type' => 'site-header-1',
    'bk-category-header-spacing' => array
        (
            'padding-top' => '40px',
            'padding-bottom' => '40px',
            'units' => 'px',
        ),
    'bk-archive-header-switch' => '0',
    'bk-archive-header-type' => 'site-header-1',
    'bk-archive-header-spacing' => array
        (
            'padding-top' => '40px',
            'padding-bottom' => '40px',
            'units' => 'px',
        ),
    'bk-author-header-switch' => '0',
    'bk-author-header-type' => 'site-header-1',
    'bk-author-header-spacing' => array
        (
            'padding-top' => '40px',
            'padding-bottom' => '40px',
            'units' => 'px',
        ),
    'bk-search-header-switch' => '0',
    'bk-search-header-type' => 'site-header-1',
    'bk_search_page_post_bookmark' => 'off',
    'bk-search-header-spacing' => array
        (
            'padding-top' => '40px',
            'padding-bottom' => '40px',
            'units' => 'px',
        ),
    'bk-social-media-links' => array
        (
            'fb' => '',
            'twitter' => '',
            'linkedin' => '',
            'pinterest' => '',
            'instagram' => '',
            'dribbble' => '',
            'youtube' => '',
            'vimeo' => '',
            'vk' => '',
            'vine' => '',
            'snapchat' => '',
            'telegram' => '',
            'rss' => '',
        ),
    'bk-post-view--cache-time' => '300',
    'bk-single-template' => 'single-1',
    'bk-feat-img-status' => '1',
    'bk-current-reading-popup-sw' => '1',
    'single-sections-infinity-scrolling' => '0',
    'bk-infinity-scrolling-term' => 'next',
    'infinity_scrolling_exclude' => '',
    'ceris-ads-editor-1' => '',
    'ceris-ads-editor-2' => '',
    'ceris-ads-editor-3' => '',
    'ceris-ads-editor-4' => '',
    'ceris-ads-editor-5' => '',
    'bk-scroll-percent-sw' => '1',
    'bk-scroll-percent-style' => 'bookmark',
    'single-sections-sorter' => array
        (
            'enabled' => array
                (
                    'placebo' => 'placebo',
                    'related' => 'Related Section',
                    'comment' => 'Comment Section',
                    'same-cat' => 'Same Category Section',
                ),
        ),
    'bk_post_sb_select' => 'home_sidebar',
    'bk_post_sb_position' => 'right',
    'bk_post_sb_sticky' => '1',
    'bk-reaction-sw' => '1',
    'bk-reaction-heading' => 'What is your reaction?',
    'bk-reaction-item-1-sw' => '1',
    'bk-reaction-item-1-svg' => '',
    'bk-reaction-item-1-text' => 'Excited',
    'bk-reaction-item-2-sw' => '1',
    'bk-reaction-item-2-svg' => '',
    'bk-reaction-item-2-text' => 'Happy',
    'bk-reaction-item-3-sw' => '1',
    'bk-reaction-item-3-svg' => '',
    'bk-reaction-item-3-text' => 'In Love',
    'bk-reaction-item-4-sw' => '1',
    'bk-reaction-item-4-svg' => '',
    'bk-reaction-item-4-text' => 'Not Sure',
    'bk-reaction-item-5-sw' => '1',
    'bk-reaction-item-5-svg' => '',
    'bk-reaction-item-5-text' => 'Silly',
    'bk-sharebox-sw' => '1',
    'bk-fb-sw' => '1',
    'bk-tw-sw' => '1',
    'bk-pi-sw' => '1',
    'bk-li-sw' => '1',
    'bk-sticky-share-bar' => '1',
    'bk-authorbox-sw' => '1',
    'bk-postnav-sw' => '1',
    'reader_review_box_title' => 'Product Review',
    'confirmation_box_title' => 'Thank you',
    'confirmation_box_text' => 'Your Review is appreciated',
    'bk-related-sw' => '1',
    'bk_related_post_layout' => 'listing_list',
    'bk_related_heading_style' => 'no-line',
    'bk_related_source' => 'category_tag',
    'bk_number_related' => '3',
    'bk_related_post_icon' => 'disable',
    'bk_related_post_icon_animation' => 'disable',
    'bk-same-cat-sw' => '1',
    'bk_same_cat_post_layout' => 'listing_list',
    'bk_same_cat_heading_style' => 'no-line',
    'bk_same_cat_number_posts' => '3',
    'bk_same_cat_post_icon' => 'disable',
    'bk_same_cat_post_icon_animation' => 'disable',
    'bk_same_cat_more_link' => '0',
    'bk-related-sw-wide' => '1',
    'bk_related_post_layout_wide' => 'listing_grid_no_sidebar',
    'bk_related_heading_style_wide' => 'no-line',
    'bk_related_source_wide' => 'category_tag',
    'bk_related_post_icon_wide' => 'disable',
    'bk_related_post_icon_animation_wide' => 'disable',
    'bk-same-cat-sw-wide' => '1',
    'bk_same_cat_post_layout_wide' => 'listing_list_no_sidebar',
    'bk_same_cat_heading_style_wide' => 'no-line',
    'bk_same_cat_post_icon_wide' => 'disable',
    'bk_same_cat_post_icon_animation_wide' => 'disable',
    'bk_same_cat_more_link_wide' => '1',
    'bk_category_header_style' => 'center',
    'bk_category_page_heading_typography' => array
        (
            'font-family' => 'Rubik',
            'font-options' => '',
            'google' => '1',
            'font-backup' => 'Arial, Helvetica, sans-serif',
            'font-weight' => 'bold',
            'font-style' => '',
            'font-size' => '36px',
            'letter-spacing' => '',
        ),
    'bk_category_page_heading_color' => array
        (
            'color' => '#222',
        ),
    'bk_category_feature_area' => 'disable',
    'bk_category_feature_area__post_option' => 'latest',
    'bk_feature_area__show_hide' => '0',
    'bk_category_content_layout' => 'listing_list',
    'bk_category_page_post_bookmark' => 'off',
    'bk_category_post_icon' => 'enable',
    'bk_category_post_icon_animation' => 'enable',
    'bk_category_pagination' => 'default',
    'bk_category_exclude_posts' => '1',
    'bk_category_sidebar_select' => 'home_sidebar',
    'bk_category_sidebar_position' => 'right',
    'bk_category_sidebar_sticky' => '1',
    'bk_archive_header_style' => 'center',
    'bk_archive_page_heading_typography' => array
        (
            'font-family' => 'Rubik',
            'font-options' => '',
            'google' => '1',
            'font-backup' => 'Arial, Helvetica, sans-serif',
            'font-weight' => 'bold',
            'font-style' => '',
            'font-size' => '36px',
            'letter-spacing' => '',
        ),
    'bk_archive_page_heading_color' => array
        (
            'color' => '#222',
        ),
    'bk_archive_content_layout' => 'listing_list',
    'bk_archive_page_post_bookmark' => 'off',
    'bk_archive_post_icon' => 'enable',
    'bk_archive_post_icon_animation' => 'enable',
    'bk_archive_pagination' => 'default',
    'bk_archive_sidebar_select' => 'home_sidebar',
    'bk_archive_sidebar_position' => 'right',
    'bk_archive_sidebar_sticky' => '1',
    'bk_author_content_layout' => 'listing_list',
    'bk_author_page_post_bookmark' => 'off',
    'bk_author_post_icon' => 'enable',
    'bk_author_post_icon_animation' => 'enable',
    'bk_author_pagination' => 'default',
    'bk_author_sidebar_select' => 'home_sidebar',
    'bk_author_sidebar_position' => 'right',
    'bk_author_sidebar_sticky' => '1',
    'bk_search_header_style' => 'center',
    'bk_search_page_heading_typography' => array
        (
            'font-family' => 'Rubik',
            'font-options' => '',
            'google' => '1',
            'font-backup' => 'Arial, Helvetica, sans-serif',
            'font-weight' => 'bold',
            'font-style' => '',
            'font-size' => '36px',
            'letter-spacing' => '',
        ),
    'bk_search_page_heading_color' => array
        (
            'color' => '#222',
        ),
    'bk_search_content_layout' => 'listing_list',
    'bk_search_post_icon' => 'enable',
    'bk_search_post_icon_animation' => 'enable',
    'bk_search_exclude_page_result' => 'disable',
    'bk_search_pagination' => 'default',
    'bk_search_sidebar_select' => 'home_sidebar',
    'bk_search_sidebar_position' => 'right',
    'bk_search_sidebar_sticky' => '1',
    'search_recommend_heading' => 'Latest Posts',
    'search_recommend_query_option' => 'date',
    'search_panel_tags_headline' => 'Popular Tags',
    'bk_blog_header_style' => 'center',
    'bk_blog_page_heading_typography' => array
        (
            'font-family' => 'Rubik',
            'font-options' => '',
            'google' => '1',
            'font-backup' => 'Arial, Helvetica, sans-serif',
            'font-weight' => 'bold',
            'font-style' => '',
            'font-size' => '36px',
            'letter-spacing' => '',
        ),
    'bk_blog_page_heading_color' => array
        (
            'color' => '#222',
        ),
    'bk_blog_content_layout' => 'listing_list',
    'bk_blog_page_post_bookmark' => 'off',
    'bk_blog_post_icon' => 'enable',
    'bk_blog_post_icon_animation' => 'enable',
    'bk_blog_pagination' => 'default',
    'bk_blog_sidebar_select' => 'home_sidebar',
    'bk_blog_sidebar_position' => 'right',
    'bk_blog_sidebar_sticky' => '1',
    '404-logo' => array
        (
            'url' => '',
            'id' => '',
            'height' => '',
            'width' => '',
            'thumbnail' => '',
            'title' => '',
            'caption' => '',
            'alt' => '',
            'description' => '',
        ),
    '404-logo-width' => '200',
    'bk-404-image' => array
        (
            'url' => '',
            'id' => '',
            'height' => '',
            'width' => '',
            'thumbnail' => '',
            'title' => '',
            'caption' => '',
            'alt' => '',
            'description' => '',
        ),
    '404--main-text' => '',
    '404--sub-text' => '',
    '404-search' => '1',
    'bk-coming-soon-bg-style' => 'default',
    'bk-coming-soon-bg-image' => array
        (
            'background-image' => '',
            'media' => array
                (
                    'id' => '',
                    'height' => '',
                    'width' => '',
                    'thumbnail' => '',
                ),
        ),
    'bk-coming-soon-bg-gradient' => array
        (
            'from' => '#1e73be',
            'to' => '#00897e',
        ),
    'bk-coming-soon-bg-gradient-direction' => '',
    'bk-coming-soon-bg-color' => array
        (
            'background-color' => '#fff',
        ),
    'bk-coming-soon-bg-blur-switch' => '1',
    'coming-soon-logo' => array
        (
            'url' => '',
            'id' => '',
            'height' => '',
            'width' => '',
            'thumbnail' => '',
            'title' => '',
            'caption' => '',
            'alt' => '',
            'description' => '',
        ),
    'coming-soon-logo-width' => '400',
    'coming-soon-introduction--main-text' => 'Be ready, we are launching soon.',
    'coming-soon--date' => '',
    'bk-coming-soon-mailchimp-shortcode' => '',
    'bk_page_header_style' => 'center',
    'bk_default_page_heading_typography' => array
        (
            'font-family' => 'Rubik',
            'font-options' => '',
            'google' => '1',
            'font-backup' => 'Arial, Helvetica, sans-serif',
            'font-weight' => 'bold',
            'font-style' => '',
            'font-size' => '36px',
            'letter-spacing' => '',
        ),
    'bk_default_page_heading_color' => array
        (
            'color' => '#222',
        ),
    'bk_page_feat_img' => '1',
    'bk_page_layout' => 'has_sidebar',
    'bk_page_sidebar_select' => 'home_sidebar',
    'bk_page_sidebar_position' => 'right',
    'bk_page_sidebar_sticky' => '1',
    'bk_authors_list_page_header_style' => 'center',
    'bk_author_list_page_heading_typography' => array
        (
            'font-family' => 'Rubik',
            'font-options' => '',
            'google' => '1',
            'font-backup' => 'Arial, Helvetica, sans-serif',
            'font-weight' => 'bold',
            'font-style' => '',
            'font-size' => '36px',
            'letter-spacing' => '',
        ),
    'bk_author_list_page_heading_color' => array
        (
            'color' => '#222',
        ),
    'bk_authors_list_page_layout' => 'listing-list',
    'bk_authors_list_page_sidebar' => '1',
    'bk_authors_list_page_sidebar_select' => 'home_sidebar',
    'bk_authors_list_page_sidebar_position' => 'right',
    'bk_authors_list_page_sidebar_sticky' => '1',
    'bk_pagebuilder_sidebar_sticky' => '1',
    'bk_bookmark_header_style' => 'center',
    'bk_bookmark_page_heading_typography' => array
        (
            'font-family' => 'Rubik',
            'font-options' => '',
            'google' => '1',
            'font-backup' => 'Arial, Helvetica, sans-serif',
            'font-weight' => 'bold',
            'font-style' => '',
            'font-size' => '36px',
            'letter-spacing' => '',
        ),
    'bk_bookmark_page_heading_color' => array
        (
            'color' => '#222',
        ),
    'bk_bookmark_content_layout' => 'listing_list',
    'bk_bookmark_post_icon' => 'enable',
    'bk_bookmark_post_icon_animation' => 'enable',
    'bk_bookmark_pagination' => 'default',
    'bk_bookmark_sidebar_select' => 'home_sidebar',
    'bk_bookmark_sidebar_position' => 'right',
    'bk_bookmark_sidebar_sticky' => '1',
    'bookmark_dropdown_latest_news' => '',
    'bookmark_dropdown_bookmark_news' => '',
    'bookmark_dropdown_dismiss_news' => '',
    'bk-footer-template' => 'default',
    'footer-col-scale' => '1',
    'footer-col-1' => 'footer_sidebar_1',
    'footer-col-2' => 'footer_sidebar_2',
    'footer-col-3' => 'footer_sidebar_3',
    'bk-footer--mailchimp-bg' => array
        (
            'background-image' => '',
            'media' => array
                (
                    'id' => '',
                    'height' => '',
                    'width' => '',
                    'thumbnail' => '',
                ),
        ),
    'footer-mailchimp--shortcode' => '',
    'bk-footer-bg-style' => 'default',
    'bk-footer-bg-gradient' => array
        (
            'from' => '#1e73be',
            'to' => '#00897e',
        ),
    'bk-footer-bg-gradient-direction' => '',
    'bk-footer-bg-color' => array
        (
            'background-color' => '#333',
        ),
    'bk-footer-inverse' => '0',
    'bk-footer-logo' => array
        (
            'url' => '',
            'id' => '',
            'height' => '',
            'width' => '',
            'thumbnail' => '',
            'title' => '',
            'caption' => '',
            'alt' => '',
            'description' => '',
        ),
    'footer-logo-width' => '200',
    'footer-copyright-text' => 'By BKNinja',
    'REDUX_last_saved' => '1588825044',
    'REDUX_LAST_SAVE' => '1588825044',
);
if (!class_exists('ceris_core')) {
    class ceris_core {
        
        static $globalBuff = array();
        
        static $globalGradientBG = array();
        
        static function bk_get_global_var($bk_var){  
            if ($bk_var == 'ceris_option') {
                if (defined('CERIS_FUNCTIONS_PLUGIN_DIR')) {
                    global $ceris_option;
                    return $ceris_option;
                }else {
                    global $ceris_default_options;
                    return $ceris_default_options;
                }
            }
        }
        static function bk_get_theme_option($theoption = '') {
            $ceris_option = ceris_core::bk_get_global_var('ceris_option');
            $output = '';
            
            if ((isset($ceris_option[$theoption])) && (($ceris_option[$theoption]) != NULL)){ 
                $output = $ceris_option[$theoption];
            }else {
                $output = '';
            }
            
            return $output;
        }
        static function ceris_rwmb_meta($theoption, $arg, $termID ){
            $ret = '';
            if(function_exists('rwmb_meta')) {
                $ret = rwmb_meta( $theoption, $arg, $termID );  
            }else {
                $ret = '';
            }
            return $ret;
        }
        static function bk_check_isset($var, $strCompare) {
            if(isset($var) && ($var != $strCompare)) {
                return 1;
            }else {
                return 0;
            }
        }
        static function bk_check_array($var) {
            if((is_array($var) && (count($var) > 0))) {
                return true;
            }else {
                return false;
            }
        }
/**
* ************* Post Views *********************
*---------------------------------------------------
*/ 
        static function bk_getPostViews($postID){
            $count_key = 'post_views_count';
            $count = get_post_meta($postID, $count_key, true);
            if($count==''){
                delete_post_meta($postID, $count_key);
                add_post_meta($postID, $count_key, '0');
                return "0";
           }
           return $count;
        }
        static function bk_setPostViews($postID){
            $count_key = 'post_views_count';
            $count = get_post_meta($postID, $count_key, true);
            if($count==''){
                $count = 0;
                delete_post_meta($postID, $count_key);
                add_post_meta($postID, $count_key, '0');
            }else{
                $count++;
                update_post_meta($postID, $count_key, $count);
            }
            return false;   
        }
/**
* ************* Socical Media Links *********************
*---------------------------------------------------
*/    
        static function bk_get_social_media_links($socialOptions){
            $socialHTML = '';
            $ceris_option = ceris_core::bk_get_global_var('ceris_option');
            
            if(isset($ceris_option['bk-social-media-links'])):
                $socialItems = $ceris_option['bk-social-media-links'];
            endif;
            
            foreach($socialOptions as $socialItem) :
                switch ($socialItem) {
                    case 'fb':
                        if ($socialItems['fb']){
                            $socialHTML .= '<li><a href="'.$socialItems['fb'].'" target="_blank"><i class="mdicon mdicon-facebook"></i></a></li>';
            			}
                        break;
                    case 'twitter' :
                        if ($socialItems['twitter']){
            				$socialHTML .= '<li><a href="'.$socialItems['twitter'].'" target="_blank"><i class="mdicon mdicon-twitter"></i></a></li>';
            			}
                        break;
                    case 'linkedin' :
                        if ($socialItems['linkedin']){
            				$socialHTML .= '<li><a href="'.$socialItems['linkedin'].'" target="_blank"><i class="mdicon mdicon-linkedin"></i></a></li>';
            			}
                        break;
                    case 'pinterest' :
                        if ($socialItems['pinterest']){
            				$socialHTML .= '<li><a href="'.$socialItems['pinterest'].'" target="_blank"><i class="mdicon mdicon-pinterest-p"></i></a></li>';
            			}
                        break;
                    case 'instagram' :
                        if ($socialItems['instagram']){
            				$socialHTML .= '<li><a href="'.$socialItems['instagram'].'" target="_blank"><i class="mdicon mdicon-instagram"></i></a></li>';
            			}
                        break;
                    case 'dribbble';
                        if ($socialItems['dribbble']){
            				$socialHTML .= '<li><a href="'.$socialItems['dribbble'].'" target="_blank"><i class="mdicon mdicon-dribbble"></i></a></li>';
            			}
                        break;
                    case 'youtube';
                        if ($socialItems['youtube']){
            				$socialHTML .= '<li><a href="'.$socialItems['youtube'].'" target="_blank"><i class="mdicon mdicon-youtube"></i></a></li>';
            			}
                        break;
                    case 'vimeo';
                        if ($socialItems['vimeo']){
            				$socialHTML .= '<li><a href="'.$socialItems['vimeo'].'" target="_blank"><i class="mdicon mdicon-vimeo"></i></a></li>';
            			}
                        break;
                    case 'vk';
                        if ($socialItems['vk']){
            				$socialHTML .= '<li><a href="'.$socialItems['vk'].'" target="_blank"><i class="mdicon mdicon-vk"></i></a></li>';
            			}
                        break;
                    case 'vine';
                        if ($socialItems['vine']){
            				$socialHTML .= '<li><a href="'.$socialItems['vine'].'" target="_blank"><i class="mdicon mdicon-vine"></i></a></li>';
            			}
                        break;
                    case 'snapchat';
                        if ($socialItems['snapchat']){
            				$socialHTML .= '<li><a href="'.$socialItems['snapchat'].'" target="_blank"><i class="mdicon mdicon-snapchat-ghost"></i></a></li>';
            			}
                        break;
                    case 'telegram';
                        if ($socialItems['telegram']){
            				$socialHTML .= '<li><a href="'.$socialItems['telegram'].'" target="_blank"><i class="mdicon mdicon-telegram"></i></a></li>';
            			}
                        break;
                    case 'rss';
                        if ($socialItems['rss']){
            				$socialHTML .= '<li><a href="'.$socialItems['rss'].'" target="_blank"><i class="mdicon mdicon-rss_feed"></i></a></li>';
            			}
                        break;
                    case 'spotify';
                        if ($socialItems['spotify']){
            				$socialHTML .= '<li><a href="'.$socialItems['spotify'].'" target="_blank"><i class="mdicon mdicon-spotify"></i></a></li>';
            			}
                        break;
                        
                    default:
                        break;
                }
            endforeach;
            
            return $socialHTML;
        }
        static function bk_get_gwen_module_small_heading($module_heading_small = ''){
            if($module_heading_small == '') {
                return '';
            }
            $module_heading = '';
            $module_heading .= $module_heading_small;
            
            return $module_heading;
        }
        
        static function bk_render_block_heading_has_sidebar($page_info) {
            $block_str = '';
            $moduleTitle = array(
                'title'     => get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_title', true ),
                'sub_title' => get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_sub_title', true ),
            );
            $moduleConfigs['heading_color'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_heading_color', true );
            $moduleConfigs['heading_style'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_heading_style', true );
            $moduleConfigs['heading_inverse'] = 'no';
            
            $headingClass = '';
            if(isset($moduleConfigs['heading_style'])) {
                $headingClass = self::bk_get_block_heading_class($moduleConfigs['heading_style'], $moduleConfigs['heading_inverse']);
            }
            
            $moduleConfigs['module_custom_spacing_option'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_module_custom_spacing_option', true );
            
            $headingMarginClass = '';
            if($moduleConfigs['module_custom_spacing_option'] != 'disable'){
                $moduleConfigs['heading_margin_bottom'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_heading_margin_bottom', true );
                if($moduleConfigs['heading_margin_bottom'] != '') {
                    $headingMarginClass .= ' atbs-custom-margin-bottom-'.abs($moduleConfigs['heading_margin_bottom']);
                }
            }

            if($moduleTitle['title'] != null){
                $block_str .= self::bk_get_block_heading($moduleTitle, $headingClass, $moduleConfigs['heading_color'], $headingMarginClass);
            }else {
                return '';
            }
            
            return $block_str;
        }
        
        static function bk_detect_heading_size($headingFontSize = ''){
            if($headingFontSize == '') return;

            if($headingFontSize > 36) {
                $moduleHeadingSize = 'the-heading-size-lg';
            }else if($headingFontSize > 30) {
                $moduleHeadingSize = 'the-heading-size-md';
            }else if($headingFontSize > 26) {
                $moduleHeadingSize = 'the-heading-size-sm';
            }else if($headingFontSize > 22) {
                $moduleHeadingSize = 'the-heading-size-xs';
            }else {
                $moduleHeadingSize = 'the-heading-size-xxs';
            }
            
            return $moduleHeadingSize;
        }
        static function bk_render_block_heading($page_info, $containerClass = '') {
            $block_str = '';
            $ceris_option   = ceris_core::bk_get_global_var('ceris_option');
            
            $moduleTitle = array(
                'title'     => get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_title', true ),
                'sub_title' => get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_sub_title', true ),
            );
            
            $moduleConfigs['heading_color'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_heading_color', true );
            $moduleConfigs['heading_style'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_heading_style', true );
            $moduleConfigs['heading_inverse'] = 'no';
            
            $headingClass = '';
            if(isset($moduleConfigs['heading_style'])) {
                $headingClass = self::bk_get_block_heading_class($moduleConfigs['heading_style'], $moduleConfigs['heading_inverse']);
            }
            
            $headingMarginClass = '';
            $moduleConfigs['module_custom_spacing_option'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_module_custom_spacing_option', true );
            if($moduleConfigs['module_custom_spacing_option'] != 'disable'){
                $moduleConfigs['heading_margin_bottom'] = get_post_meta( $page_info['page_id'], $page_info['block_prefix'].'_heading_margin_bottom', true );
                if($moduleConfigs['heading_margin_bottom'] != '') {
                    $headingMarginClass .= ' atbs-custom-margin-bottom-'.abs($moduleConfigs['heading_margin_bottom']);
                }
            }
            
            if($moduleTitle['title'] != null){
                if($containerClass != '') {
                    $containerClass .= ' container';
                }else {
                    $containerClass = 'container';
                }
                
                if(isset($ceris_option['module-heading-font']['font-size']) && ($ceris_option['module-heading-font']['font-size'] != '')) {
                    $headingFontSize = intval($ceris_option['module-heading-font']['font-size'], 10);
                    $containerClass .= ' '.self::bk_detect_heading_size($headingFontSize);
                }
                $block_str .= '<div class="'.$containerClass.'">';
                $block_str .= self::bk_get_block_heading($moduleTitle, $headingClass, $moduleConfigs['heading_color'], $headingMarginClass);
                $block_str .= '</div><!-- .container -->'; 
            }else {
                return '';
            }
            
            return $block_str;
        }
    
        static function bk_get_block_heading($bk_heading, $headingClass = '', $headingColor = '', $headingMarginClass = ''){
            $ceris_option = ceris_core::bk_get_global_var('ceris_option');
            $block_heading = '';
            
            if($bk_heading['title'] != '') {
                $heading_allow_html = array(
                    'span' => array(
                        'style' => array(),
                        'class' => array(),
                    ),
                );
                $headingColorStyle = '';
                if(($headingClass == 'block-heading--style-1') || ($headingClass == 'block-heading--style-2') || ($headingClass == 'block-heading--style-3') || ($headingClass == 'block-heading--style-9')) {
                    if($headingColor != '') {
                        $border_color = 'style="border-color: '.$headingColor .';"';
                        $title_bg = 'style="background-color: '.$headingColor .';"';
                    }else {
                        $border_color = '';
                        $title_bg = '';
                    }
                }elseif($headingClass == 'block-heading--style-7') {
                    $border_color = 'style="border-color: '.$headingColor .';"';
                    $title_bg = '';
                }elseif(($headingClass == 'block-heading--style-10') || ($headingClass == 'block-heading--line') || ($headingClass == 'has-block-heading-line-around')) {
                    $border_color = 'style="border-color: '.$headingColor .';"';
                    $headingColorStyle = 'style="color: '.$headingColor.';"';
                    $title_bg = '';
                }else {
                    if($headingColor != '') {
                        $headingColorStyle = 'style="color: '.$headingColor.';"';
                    }else {
                        $headingColorStyle = '';
                    }
                    $title_bg = '';
                    $border_color = '';
                }
                $headingColorStyle .= ' '.$title_bg;
                $block_heading .= '<div class="block-heading '.$headingClass.$headingMarginClass.'" '.$border_color .'>';
    			$block_heading .= '<h4 class="block-heading__title" '.$headingColorStyle.'>'.wp_kses($bk_heading['title'], $heading_allow_html).'</h4>';
                if(isset($bk_heading['sub_title']) && ($bk_heading['sub_title'] != '')) {
                    $block_heading .= '<div class="page-heading__subtitle"><p>'.wp_kses($bk_heading['sub_title'], $heading_allow_html).'</p></div>';
                }
    			$block_heading .= '</div>';
            }
            return $block_heading;
        }
        static function bk_get_block_heading_class($headingStyle = '', $heading_inverse = 'no'){
            $ceris_option = ceris_core::bk_get_global_var('ceris_option');
            $headingClass = '';
            
            //Check default heading condition
            if(($headingStyle == 'default') && isset($ceris_option['bk-default-module-heading'])) {
                $headingStyle = $ceris_option['bk-default-module-heading'];
            }
            switch($headingStyle) {
                case 'style-1':
                    $headingClass = 'block-heading--style-1';
                    break;
                case 'style-2':
                    $headingClass = 'block-heading--style-2';
                    break;
                case 'style-3':
                    $headingClass = 'block-heading--style-3';
                    break;
                case 'style-4':
                    $headingClass = 'block-heading--style-4';
                    break;
                case 'style-5':
                    $headingClass = 'block-heading--style-5 block-heading--center';
                    break;
                case 'style-6':
                    $headingClass = 'block-heading--style-6';
                    break;
                case 'style-7':
                    $headingClass = 'block-heading--style-7';
                    break;
                case 'style-8':
                    $headingClass = 'block-heading--style-8';
                    break;
                case 'style-9':
                    $headingClass = 'block-heading--style-9';
                    break;
                case 'style-10':
                    $headingClass = 'block-heading--style-10';
                    break;
                case 'line':
                    $headingClass = 'block-heading--line';
                    break;
                case 'large-line':
                    $headingClass = 'block-heading--line block-heading--lg';
                    break;
                case 'no-line':
                    $headingClass = '';
                    break;
                case 'large-no-line':
                    $headingClass = 'block-heading--lg';
                    break;
                case 'line-under':
                    $headingClass = 'block-heading--line-under';
                    break;
                case 'large-line-under':
                    $headingClass = 'block-heading--lg block-heading--line-under';
                    break;
                case 'center':
                    $headingClass = 'block-heading--center';
                    break; 
                case 'large-center':
                    $headingClass = 'block-heading--lg block-heading--center';
                    break;    
                case 'line-around':
                    $headingClass = 'has-block-heading-line-around';
                    break;
                case 'large-line-around':
                    $headingClass = 'block-heading--lg has-block-heading-line-around';
                    break;
                default:
                    $headingClass = 'block-heading--line';
                    break;
            }
            if($heading_inverse == 'yes') {
                $headingClass .= ' block-heading--inverse';
            }
            return $headingClass;
        }
        static function bk_get_widget_heading_class($headingStyle = '', $heading_inverse = 'no'){
            $ceris_option = ceris_core::bk_get_global_var('ceris_option');
            $headingClass = '';
            
            //Check force condition
            if(($headingStyle == 'default') && isset($ceris_option['bk-default-widget-heading'])) {
                $headingStyle = $ceris_option['bk-default-widget-heading'];
            }
            switch($headingStyle) {
                case 'line':
                    $headingClass = 'block-heading--line';
                    break;
                case 'no-line':
                    $headingClass = '';
                    break;
                case 'line-under':
                    $headingClass = 'block-heading--line-under';
                    break;
                case 'center':
                    $headingClass = 'block-heading--center';
                    break;    
                case 'line-around':
                    $headingClass = 'has-block-heading-line-around';
                    break;
                default:
                    $headingClass = 'block-heading--line';
                    break;
            }
            if($heading_inverse == 'yes') {
                $headingClass .= ' block-heading--inverse';
            }
            return $headingClass;
        }
        static function bk_get_post_excerpt($length) {
            $bk_excerpt = '';
            $the_excerpt = get_the_excerpt();
            $bk_excerpt .= '<div class="excerpt">';
            $bk_excerpt .= self::the_excerpt_limit_by_word($the_excerpt, $length); 
            $bk_excerpt .= '</div>';
            return $bk_excerpt;
        }
        static function the_excerpt_limit_by_word($string, $word_limit){
            $words = explode(' ', $string, ($word_limit + 1));
            if(count($words) > $word_limit)
            array_pop($words);
            $strout = implode(' ', $words);
            if (strlen($strout) < strlen($string))
                $strout .=" ...";
            return $strout;
        }
        static function bk_add_buff($buffType= '', $buffID = '', $buffContent = '', $val = ''){  
            
            if($buffType != '') :
                if($buffID != '') :
                    //self::$globalBuff[$buffType][$buffID] = '';
                    if($buffContent != '') :
                        self::$globalBuff[$buffType][$buffID][$buffContent] = $val;
                    endif;
                endif;
            endif;
            
        }
        static function ceris_create_ajax_security_code(){
            $ceris_security_code = wp_create_nonce( 'ceris_ajax_security' );
            self::bk_add_buff('ceris_security', 'ceris_security_code', 'content', $ceris_security_code);
            wp_localize_script( 'ceris-scripts', 'ajax_buff', ceris_core::$globalBuff );
        }
        static function ceris_wcount_cal($wcount = array()){
            if($wcount[0] == '') {
                $wcount[0] = 130;
            }
            wp_localize_script( 'ceris-scripts', 'ceris_wcount', $wcount );
        }
        static function bk_get_sub_categories($bkParentCat) {  
            $catList = array();
            $args = array('child_of' => $bkParentCat);
            $categories = get_categories( $args );
            if(count($categories) > 0) {
                foreach($categories as $key => $category) { 
                    //$catList[$key] = '<a class="post__cat post__cat--bg cat-theme-bg" href="' . get_category_link( $category->term_id ) . '" title="'.$category->name.'" ' . '>' . $category->name.'</a>';
                    $catList[$key] = $category;
                }
            }
            return $catList;
            
        }
        static function bk_get_post_title_link( $bkPostId ) {
            $titleLink = '';
            $category = get_the_category($bkPostId); 
            $titleLink .= '<a href="'.get_permalink($bkPostId).'">';
            $titleLink .= get_the_title($bkPostId);
            $titleLink .= '</a>';
            return $titleLink;
        }
        static function bk_get_post_icon_video_only ($bkPostID) {
            $str_ret = '';
            $postformat = get_post_format( $bkPostID );
            switch($postformat) {
                case "video":
                    $str_ret = '<span><i class="fa fa-play post-icon video-icon"></i></span>';
                    break;
                default:
                    $str_ret = '';
                    break;
            }
            return $str_ret;
        }
        static function bk_check_has_post_thumbnail($postID){
            if($postID == '') {
                $postID = get_the_ID();
            }
            $featured_image_url = wp_get_attachment_url( get_post_thumbnail_id( $postID ) );
            if  ( ! empty( $featured_image_url ) ) {
                return true;
            }else {
                return false;
            }
        }
        static function get_feature_image($postID = '', $thumbSize = '', $clickable = true, $postIcon = ''){
            $feat_img = '';
            
            if($postID == '') {
                $postID = get_the_ID();
            }
            
            if(ceris_core::bk_check_has_post_thumbnail($postID)) { 
                if($clickable == true) {
                    $feat_img .= '<a href="'.get_permalink($postID).'">';
                }
                
                $feat_img .= get_the_post_thumbnail($postID, $thumbSize);
                
                if($postIcon != '') {
                    $feat_img .= self::bk_get_post_icon($postID, $postIcon);
                }
                
                if($clickable == true) {
                    $feat_img .= '</a> <!-- close a tag -->';
                }
            }
            return $feat_img;
        }
        static function bk_get_post_thumbnail_bg_link($customArgs){
            $bkThumbId = get_post_thumbnail_id( $customArgs['postID'] );
            $bkThumbUrl = wp_get_attachment_image_src( $bkThumbId, $customArgs['thumbSize'] );
            if(empty($bkThumbUrl)) {
                return '';
            }
            return esc_url($bkThumbUrl[0]);
            
        }
        
        static function bk_get_primary_category_id($postID) {
            if ( class_exists('WPSEO_Primary_Term') ) {

                 // Show the post's 'Primary' category, if this Yoast feature is available, & one is set
            	$wpseo_primary_term = new WPSEO_Primary_Term( 'category', $postID );
            	$wpseo_primary_term = $wpseo_primary_term->get_primary_term();
            	$term = get_term( $wpseo_primary_term );
            
                 if ( is_wp_error( $term ) ) {
                    return '';            
                 } else {
                    return $term->term_id;;
                 }
            
            } else {
                return '';
            }
        }
/**
 * ********* Get Post Category ***********
 *---------------------------------------------------
 */ 
        static function bk_get_post_cat_link($postID, $catClass = '', $allowALL = ''){
            $html = '';
            global $wp_query;
            
            if(is_category()) {
                if (function_exists('get_queried_object_id')) :
                    $catID          = get_queried_object_id();
                else:
                    $catID          = $wp_query->get_queried_object_id();
                endif;
                $catIDs = array();
                $category = get_the_category($postID); 
                if(isset($category[0]) && $category[0]){
                    foreach ($category as $key => $value) {
                        $catIDs[$key]= $value->term_id;
                    }
                }
                if (in_array($catID, $catIDs)) {
                    $html.= '<a class="cat-'.$catID.' '.$catClass.'" href="'.get_category_link($catID ).'">'.get_cat_name($catID).'</a>';     
                    return $html;
                }
            }
            $primary_category_ID = self::bk_get_primary_category_id($postID);
            
            if(($allowALL != 1) && ($primary_category_ID != '')) {
                $html.= '<a class="cat-'.$primary_category_ID.' '.$catClass.'" href="'.get_category_link($primary_category_ID ).'">'.get_cat_name($primary_category_ID).'</a>';  
                return $html;
            }
            $category = get_the_category($postID); 
            if(isset($category[0]) && $category[0]){
                foreach ($category as $key => $value) {
                    $html.= '<a class="cat-'.$value->term_id.' '.$catClass.'" href="'.get_category_link($value->term_id ).'">'.$value->cat_name.'</a>';  
                    if($allowALL != 1) return $html;
                }
            }
            return $html;
        }
/**
* ********* Count Post Category ************
*---------------------------------------------------
*/ 
        static function bk_count_post_in_category($categoryIDs){
            $html = '';
            $category = array();
            $postCount = array();
            $catArray = array();
            if($categoryIDs[0] == 0) {
                $catArray = get_terms(
                    array( 'category' ), // Taxonomies
                    array( 'fields' => 'ids' ) // Fields
                ); 
            }else {
                $catArray = $categoryIDs;
            }     
            foreach ($catArray as $key => $catID) {               
                $category[$key] = get_category($catID); 
                $postCount[$catID] = $category[$key]->category_count;
            }
            return $postCount;
        }
/**
* ************* Meta Cases *********************
*---------------------------------------------------
*/ 
        static function bk_get_comment_number_and_text ($postID) {
            $comments = '';
            $num_comments = get_comments_number($postID);
            if ( $num_comments == 0 ) {
        		$comments = esc_html__('0 Comments', 'ceris');
        	} elseif ( $num_comments > 1 ) {
        		$comments = $num_comments . esc_html__(' Comments', 'ceris');
        	} else {
        		$comments = esc_html__('1 Comment', 'ceris');
        	}
            return $comments;
        }
        static function bk_meta_cases( $meta_type ) {
            $bk_meta = $meta_type;
            $postID = get_the_ID();
            $ceris_article_date_unix = get_the_time('U', $postID);      
            $bk_meta_str = '';
            switch ($bk_meta) {
                case 'date':
                    $bk_meta_str .= '<time class="time published" datetime="'.date(DATE_W3C, $ceris_article_date_unix).'" title="'.get_the_time('F j, Y \a\t g:i a', $postID) .'"><i class="mdicon mdicon-schedule"></i>'.get_the_date('', $postID).'</time>';
                    break;
                case 'date_without_icon':
                    $bk_meta_str .= '<time class="time published" datetime="'.date(DATE_W3C, $ceris_article_date_unix).'" title="'.get_the_time('F j, Y \a\t g:i a', $postID) .'">'.get_the_date('', $postID).'</time>';
                    break;
                case 'author':
                    $authorArgs = array(
                        'class' => 'entry-author__avatar',
                    );
                    $bk_author_name = get_the_author_meta('display_name', get_the_author_meta( 'ID' ));
                    $authorImgALT = $bk_author_name;
                    $bk_meta_str .=  get_avatar(get_the_author_meta( 'ID' ), '50', '', $authorImgALT, $authorArgs) . '<a class="entry-author__name" href="'. get_author_posts_url(get_the_author_meta( 'ID' )).'">'. get_the_author() .'</a>';
                    break;
                case 'author_name':
                    $bk_author_name = get_the_author_meta('display_name', get_the_author_meta( 'ID' ));
                    $authorImgALT = $bk_author_name;
                    $bk_meta_str .= '<div class="author_name--wrap"><span class="entry-lable">'.esc_html__('By ','ceris').'</span>'. '<a class="entry-author__name" href="'. get_author_posts_url(get_the_author_meta( 'ID' )).'">'. get_the_author() .'</a></div>';
                    break;
                
                case 'author_horizontal':
                    $authorArgs = array(
                        'class' => 'entry-author__avatar',
                    );
                    $bk_author_name = get_the_author_meta('display_name', get_the_author_meta( 'ID' ));
                    $authorImgALT = $bk_author_name;
                    $bk_meta_str .=  '<div class="entry-author entry-author--horizontal">';
                    $bk_meta_str .=  get_avatar(get_the_author_meta( 'ID' ), '50', '', $authorImgALT, $authorArgs) . '<a class="entry-author__name" href="'. get_author_posts_url(get_the_author_meta( 'ID' )).'">'. get_the_author() .'</a>';
                    $bk_meta_str .=  '</div>';
                    break;
                    
                case 'author_has_wrap':
                    $authorArgs = array(
                        'class' => 'entry-author__avatar',
                    );
                    $bk_author_name = get_the_author_meta('display_name', get_the_author_meta( 'ID' ));
                    $authorImgALT = $bk_author_name;
                    $bk_meta_str .=  '<div class="entry-author">';
                    $bk_meta_str .=  get_avatar(get_the_author_meta( 'ID' ), '50', '', $authorImgALT, $authorArgs) . '<a class="entry-author__name" href="'. get_author_posts_url(get_the_author_meta( 'ID' )).'">'. get_the_author() .'</a>';
                    $bk_meta_str .=  '</div>';
                    break;

                case 'bg':
                    $thumb130 = wp_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'ceris-xxs-1_1');
                    $bk_meta_str .=  '<div class="meta-bg" style="background-image:url('.$thumb130['0'].');background-size:cover;background-position:50% 50%;background-repeat:no-repeat;"></div>';
                    break;
                case 'view':
                    if(self::bk_getPostViews($postID) > 1) {
                        $bk_meta_str .=  '<span class="post-view-counter"><i class="mdicon mdicon-visibility"></i>'. self::bk_getPostViews($postID) .' '. esc_html__('views', 'ceris') .'</span>';
                    }else {
                        $bk_meta_str .=  '<span class="post-view-counter"><i class="mdicon mdicon-visibility"></i>'. self::bk_getPostViews($postID) .' '. esc_html__('view', 'ceris') .'</span>';
                    }
                    break;
                case 'comment':
                    $bk_meta_str .=  '<span class="post-comment-counter"><a title="'.self::bk_get_comment_number_and_text($postID).'" href="'.get_permalink($postID).'"><i class="mdicon mdicon-chat_bubble_outline"></i>'.get_comments_number($postID).'</a></span>';                  
                    break;
                case 'comment_text':
                    $bk_meta_str .=  '<span class="post-comment-counter"<a title="'.self::bk_get_comment_number_and_text($postID).'" href="'.get_permalink($postID).'"><i class="mdicon mdicon-chat_bubble_outline"></i>'.self::bk_get_comment_number_and_text($postID).'</a></span>';                  
                    break;
                default:
                    esc_html_e('No Case Matched!', 'ceris');
            }
            return $bk_meta_str;
        }
    
        static function bk_get_post_meta( $meta_arg, $metaSeperator = 0 ) {
            $bk_meta = '';
            $seperator = '';
            if($metaSeperator == 1) {
                $seperator = '<span class="meta-seperator">&middot;</span>';
            }
            if ((isset($meta_arg[0])) && ($meta_arg[0] != null)) {
                $bk_meta .= self::bk_meta_cases($meta_arg[0]);
            }
            if ((isset($meta_arg[1])) && ($meta_arg[1] != null)) {
                $bk_meta .= $seperator;
                $bk_meta .= self::bk_meta_cases($meta_arg[1]);
            }
            if ((isset($meta_arg[2])) && ($meta_arg[2] != null)) {
                $bk_meta .= $seperator;
                $bk_meta .= self::bk_meta_cases($meta_arg[2]);
            }
            if ((isset($meta_arg[3])) && ($meta_arg[3] != null)) {
                $bk_meta .= $seperator;
                $bk_meta .= self::bk_meta_cases($meta_arg[3]);
            }
            if ((isset($meta_arg[4])) && ($meta_arg[4] != null)) {
                $bk_meta .= $seperator;
                $bk_meta .= self::bk_meta_cases($meta_arg[4]);
            }
            if ((isset($meta_arg[5])) && ($meta_arg[5] != null)) {
                $bk_meta .= $seperator;
                $bk_meta .= self::bk_meta_cases($meta_arg[5]);
            }
            if ((isset($meta_arg[6])) && ($meta_arg[6] != null)) {
                $bk_meta .= $seperator;
                $bk_meta .= self::bk_meta_cases($meta_arg[6]);
            }
            if ((isset($meta_arg[7])) && ($meta_arg[7] != null)) {
                $bk_meta .= $seperator;
                $bk_meta .= self::bk_meta_cases($meta_arg[7]);
            }
            return $bk_meta;
        }
        static function bk_count_gallery_length($postID){
            $postFormat = self::bk_post_format_detect($postID);
            $galleryLength = 0;
            if($postFormat == 'gallery') :
                $galleryImages = self::ceris_rwmb_meta( 'bk_gallery_content', $args = array('type' => 'image'), $postID );
                if(is_array(($galleryImages))) :
                    $galleryLength = count($galleryImages); 
                endif;
            endif;
            
            return $galleryLength;
        }
/**
 *  Review Score Star
 */ 
        static function bk_get_post_score_star( $reviewScore = 0 ) {
            $starHalf = '<span class="mdicon mdicon-star_half">';
            $starHTML = '';
            $starCount = intval($reviewScore/2);
            $i = 0;
            for($i = 0; $i < $starCount; $i++) {
                $starHTML .= '<span class="mdicon mdicon-star"></span>';
            }
            if($reviewScore%2){
                $starHTML .= '<span class="mdicon mdicon-star_half">';
            }
            return $starHTML;
        }
/**
 * Return Post Format
 */
        static function bk_post_format_detect($postID) { 
            if(function_exists('has_post_format')) {
                if(get_post_format( $postID ) != '') {
                    return get_post_format( $postID );
                }else {
                    //Is this review post?
                    $reviewCheck = get_post_meta($postID, 'bk_review_checkbox', true );
                    if($reviewCheck == 1) {
                        $postScore = get_post_meta($postID, 'bk_review_score', true );
                        if(($postScore != 0) && ($postScore != '')) {
                            return 'review';
                        }else {
                            return '';
                        }
                    }else {
                        return '';
                    }
                }
            }else {
                return '';
            }
        }
        static function bk_get_post_icon($postID, $postIcon){
            $postIconStr = '';
            if($postID == ''){
                $postID = $postID;
            }
            if(isset($postIcon['postIconClass'])) {
                $iconClass = $postIcon['postIconClass'];
            }else {
                $iconClass = '';
            }
            if($postIcon['iconType'] == 'gallery') {
                $postIconStr .= '<div class="'.$iconClass.'">';
				$postIconStr .= '<i class="mdicon mdicon-filter"></i><span>'.self::bk_count_gallery_length($postID).'</span>';
				$postIconStr .= '</div>';
            }elseif($postIcon['iconType'] == 'review') {
                $reviewScore  = get_post_meta($postID, 'bk_review_score', true);
                $postIconStr  = '<div class="'.$iconClass.'">';
                $postIconStr .= '<div class="post-score-hexagon '.$postID.'">';
				$postIconStr .= '<svg class="hexagon-svg" version="1.1" xmlns="http://www.w3.org/2000/svg" viewbox="-5 -5 184 210">';
				$postIconStr .= '<g>';
				$postIconStr .= '<path fill="#FC3C2D" stroke="#fff" stroke-width="10px" d="M81.40638795573723 2.9999999999999996Q86.60254037844386 0 91.7986928011505 2.9999999999999996L168.0089283341811 47Q173.20508075688772 50 173.20508075688772 56L173.20508075688772 144Q173.20508075688772 150 168.0089283341811 153L91.7986928011505 197Q86.60254037844386 200 81.40638795573723 197L5.196152422706632 153Q0 150 0 144L0 56Q0 50 5.196152422706632 47Z"></path>';
				$postIconStr .= '</g>';
				$postIconStr .= '</svg>';
				$postIconStr .= '<span class="post-score-value">'.$reviewScore.'</span>';
				$postIconStr .= '</div>';
                $postIconStr .= '</div>';
            }elseif($postIcon['iconType'] == 'video') {
                
                $postIconStr .= '<div class="post-type-icon '.$iconClass.'">';
				
                //
                
                //$postIconStr .= '<a href="'.get_permalink($postID).'" title="bk-link" >';
                $postIconStr .= '<svg xmlns="http://www.w3.org/2000/svg" width="80" height="80" viewBox="0 0 80 80">
                
                    <g transform="translate(-3082 -2212)">
                        <g class="c" transform="matrix(1, 0, 0, 1, 3040, 2182)">
                            <circle class="circle" cx="40" cy="40" r="40" transform="translate(42 30)" fill="#fff" />
                        </g>
                        <g class="g-path" transform="translate(3100 2230)">
                            <path class="b" d="M29.608,21.46,16.275,13.126A.833.833,0,0,0,15,13.833V30.5a.833.833,0,0,0,1.275.707l13.333-8.333a.833.833,0,0,0,0-1.414Z" transform="translate(1)" />
                        </g>
                    </g>
               
                </svg>';
                //$postIconStr .= '</a>';
                //
				$postIconStr .= '</div>';
                
            }elseif($postIcon['iconType'] == 'comment_box') {
                if(get_comments_number($postID) > 0) {
                    $postIconStr .= '<a href="'.get_permalink($postID).'" title="'.self::bk_get_comment_number_and_text($postID).'" class="comments-count-box overlay-item">'.get_comments_number($postID).'</a>';
                }else {
                    $postIconStr .= '';
                }
            }else {
                $postIconStr .= '';
            }
            
            return $postIconStr;
        }
/**
 * bk_overlay_footer_style
 * 
 */
        static function bk_overlay_footer_style($footerStyle) { 
            $footerArgs = array();
            switch ($footerStyle) {
                case '1-col':
                    $footerArgs['footerType'] = '';
                    $footerArgs['footerClass'] = '';
                    break;
                case '1-col-border':
                    $footerArgs['footerType'] = '';
                    $footerArgs['footerClass'] = 'post__meta--border-top';
                    break;
                case '2-cols':
                    $footerArgs['footerType'] = '2-cols';
                    $footerArgs['footerClass'] = 'post__meta--flex';
                    break;
                case '2-cols-border':
                    $footerArgs['footerType'] = '2-cols';
                    $footerArgs['footerClass'] = 'post__meta--flex post__meta--border-top';
                    break;
                default:
                    $footerArgs['footerType'] = '';
                    $footerArgs['footerClass'] = '';
                    break;
            }
            return $footerArgs;
        }
/**
 * bk_get_meta_list
 * 
 */
        static function bk_get_meta_list($metaInput) { 
            $metaCase = $metaInput;
            $metaArray = array();
            switch ($metaCase) {
                case 1:
                    $metaArray = array('author');
                    break;
                case 2:
                    $metaArray = array('author', 'date');
                    break;
                case 3:
                    $metaArray = array('author', 'date', 'comment');
                    break;
                case 4:
                    $metaArray = array('author', 'date', 'view');
                    break;
                case 5:
                    $metaArray = array('author', 'comment', 'view');
                    break;
                case 6:
                    $metaArray = array('author', 'view');
                    break;
                case 7:
                    $metaArray = array('author', 'comment');
                    break;
                case 8:
                    $metaArray = array('date');
                    break;
                case 9:
                    $metaArray = array('date', 'comment');
                    break;
                case 10:
                    $metaArray = array('date', 'view');
                    break;
                case 11:
                    $metaArray = array('date', 'comment', 'view');
                    break;
                case 12:
                    $metaArray = array('comment', 'view');
                    break;
                default:
                    $metaArray = array('author', 'date', 'comment');
                    break;
            }
            return $metaArray;
        }
 /**
 * bk_get_cat_class
 *   1           => Category Top Left
 *   2           => Category Overlap
 *   3           => Category Above Title (No Background)
 *   4           => Category Above Title (Has Background)
 *   0           => Disable Category
 * 
 */
        static function bk_get_cat_class($catStyle) {
            $catClass = '';
            switch ($catStyle) {
                case 1:
                    $catClass = 'post__cat post__cat--bg cat-theme-bg overlay-item--top-left';
                    break;
                case 2:
                    $catClass = 'post__cat post__cat--bg post__cat--overlap cat-theme-bg';
                    break;
                case 3:
                    $catClass = 'post__cat cat-theme';
                    break;
                case 4:
                    $catClass = 'post__cat post__cat--bg cat-theme-bg';
                    break;
                default:
                    $catClass = 'post__cat post__cat--bg cat-theme-bg overlay-item--top-left';
                    break;
            }
            return $catClass;
        }
 /**
 * media - post format
 * 
 */
        static function bk_get_gallery_1($postID){
            $htmlOutput = '';
            $galleryImages = self::ceris_rwmb_meta( 'bk_gallery_content', $args = array('type' => 'image'), $postID );
            if($galleryImages != null){
                $htmlOutput .= '<div class="atbs-ceris-gallery-wrap">';
                $htmlOutput .= '<div class="fotorama atbs-ceris-gallery-slider atbs-ceris-post-media-wide" data-width="100%" data-allowfullscreen="true" data-click="false" data-nav="false">';
                foreach ( $galleryImages as $image ){
                    $attachment = wp_get_attachment_image_src($image['ID'], 'ceris-l-16_9');
                    $caption = wp_get_attachment_caption($image['ID']);
                    $htmlOutput .= '<a href="'.$attachment[0].'" data-size="1200x675" data-caption="'.$caption.'"></a>';
                }
                $htmlOutput .= '</div>';
                $htmlOutput .= '</div>';
            }
            
            return $htmlOutput;
        }
        static function bk_get_gallery_2($postID){
            $htmlOutput = '';
            $galleryImages = self::ceris_rwmb_meta( 'bk_gallery_content', $args = array('type' => 'image'), $postID );
            if($galleryImages != null){
                $htmlOutput .= '<div class="atbs-ceris-gallery-wrap">';
                $htmlOutput .= '<div class="fotorama atbs-ceris-gallery-slider atbs-ceris-post-media-wide" data-width="100%" data-allowfullscreen="true" data-click="false">';
                foreach ( $galleryImages as $image ){
                    $attachment = wp_get_attachment_image_src($image['ID'], 'ceris-l-16_9');
                    $caption = wp_get_attachment_caption($image['ID']);
                    $htmlOutput .= '<a href="'.$attachment[0].'" data-size="1200x675" data-caption="'.$caption.'"></a>';
                }
                $htmlOutput .= '</div>';
                $htmlOutput .= '</div>';
            }
            return $htmlOutput;
        }
        static function bk_get_gallery_3($postID){
            $htmlOutput = '';
            $galleryImages = self::ceris_rwmb_meta( 'bk_gallery_content', $args = array('type' => 'image'), $postID );
            if($galleryImages != null){
                $htmlOutput .= '<div class="atbs-ceris-gallery-wrap">';
                $htmlOutput .= '<div class="fotorama atbs-ceris-gallery-slider atbs-ceris-post-media-wide" data-width="100%" data-nav="thumbs" data-allowfullscreen="true" data-click="false">';
                foreach ( $galleryImages as $image ){
                    $attachment = wp_get_attachment_image_src($image['ID'], 'ceris-l-16_9');
                    $attachmentThumb = wp_get_attachment_image_src($image['ID'], 'ceris-xxs-4_3');
                    $caption = wp_get_attachment_caption($image['ID']);
                    $htmlOutput .= '<a href="'.$attachment[0].'" data-size="1200x675" data-caption="'.$caption.'">';
                    $htmlOutput .= '<img src="'.$attachmentThumb[0].'" alt="'.esc_attr__('Image alt', 'ceris').'" width="180" height="135" />';
                    $htmlOutput .= '</a>';
                }
                $htmlOutput .= '</div>';
                $htmlOutput .= '</div>';
            }
            return $htmlOutput;
        }
        static function bk_get_gallery_4($postID){
            $htmlOutput = '';
            $galleryID = uniqid('gallery-');
            $galleryImages = self::ceris_rwmb_meta( 'bk_gallery_content', $args = array('type' => 'image'), $postID );
            if($galleryImages != null){
                $htmlOutput .= '<div id="'.$galleryID.'" class="gallery '.$galleryID.' gallery-columns-4 gallery-size-thumbnail js-atbs-ceris-lightbox-gallery atbs-ceris-post-media-wide">';
                foreach ( $galleryImages as $image ){
                    $attachment = wp_get_attachment_image_src($image['ID'], 'ceris-l-16_9');
                    $attachmentThumb = wp_get_attachment_image($image['ID'], 'ceris-xs-1_1');
                    $caption = wp_get_attachment_caption($image['ID']);
                    $htmlOutput .= '<figure class="gallery-item">';
                	$htmlOutput .= '<div class="gallery-icon landscape">';
                	$htmlOutput .= '<a href="'.$attachment[0].'" title="Image caption">'.$attachmentThumb.'</a>';
                	$htmlOutput .= '</div>';
                	$htmlOutput .= '<figcaption class="wp-caption-text gallery-caption">';
                	$htmlOutput .= $caption;
                	$htmlOutput .= '</figcaption>';
                	$htmlOutput .= '</figure>';
                }
                $htmlOutput .= '</div>';
            }
            return $htmlOutput;
        }
        static function bk_get_video_media($bkURL){
            $htmlOutput = '';
            
            if($bkURL != ''):
                $bkUrlParse = parse_url($bkURL);
                if (isset($bkUrlParse['host']) && (($bkUrlParse['host'] == 'www.youtube.com')||($bkUrlParse['host'] == 'youtube.com'))) { 
                    $videoID = self::bk_parse_youtube($bkURL);
                    $htmlOutput .= '<div class="atbs-ceris-responsive-video">';
                    $htmlOutput .= '<iframe width="1050" height="591" src="//www.youtube.com/embed/'.$videoID.'" allowFullScreen ></iframe>';
                    $htmlOutput .= '</div>';
                }else if (isset($bkUrlParse['host']) && (($bkUrlParse['host'] == 'www.vimeo.com')||($bkUrlParse['host'] == 'vimeo.com'))) {
                    $videoID = self::bk_parse_vimeo($bkURL);
                    $htmlOutput .= '<div class="atbs-ceris-responsive-video">';
                    $htmlOutput .= '<iframe src="//player.vimeo.com/video/'.$videoID.'?title=0&byline=0&portrait=0" allowfullscreen></iframe>';
                    $htmlOutput .= '</div>';
                }else {
                    $htmlOutput .= '<div class="ceris-error--notice"><span>'.esc_html__('Please put the correct video link to the video post format section', 'ceris').'</span></div>';
                }
            endif;
            return $htmlOutput;
        }
    /**
    * ************* Get youtube ID  *****************
    *---------------------------------------------------
    */ 
      
        static function bk_parse_youtube($link){
         
            $regexstr = '~
                # Match Youtube link and embed code
                (?:                             # Group to match embed codes
                    (?:<iframe [^>]*src=")?       # If iframe match up to first quote of src
                    |(?:                        # Group to match if older embed
                        (?:<object .*>)?      # Match opening Object tag
                        (?:<param .*</param>)*  # Match all param tags
                        (?:<embed [^>]*src=")?  # Match embed tag to the first quote of src
                    )?                          # End older embed code group
                )?                              # End embed code groups
                (?:                             # Group youtube url
                    https?:\/\/                 # Either http or https
                    (?:[\w]+\.)*                # Optional subdomains
                    (?:                         # Group host alternatives.
                    youtu\.be/                  # Either youtu.be,
                    | youtube\.com              # or youtube.com
                    | youtube-nocookie\.com     # or youtube-nocookie.com
                    )                           # End Host Group
                    (?:\S*[^\w\-\s])?           # Extra stuff up to VIDEO_ID
                    ([\w\-]{11})                # $1: VIDEO_ID is numeric
                    [^\s]*                      # Not a space
                )                               # End group
                "?                              # Match end quote if part of src
                (?:[^>]*>)?                       # Match any extra stuff up to close brace
                (?:                             # Group to match last embed code
                    </iframe>                 # Match the end of the iframe
                    |</embed></object>          # or Match the end of the older embed
                )?                              # End Group of last bit of embed code
                ~ix';
        
            preg_match($regexstr, $link, $matches);
        
            return $matches[1];
        
        }
        
    /**
     * ************* Get vimeo ID *****************
     *---------------------------------------------------
     */  
        
        static function bk_parse_vimeo($link){
         
            $regexstr = '~
                # Match Vimeo link and embed code
                (?:<iframe [^>]*src=")?       # If iframe match up to first quote of src
                (?:                         # Group vimeo url
                    https?:\/\/             # Either http or https
                    (?:[\w]+\.)*            # Optional subdomains
                    vimeo\.com              # Match vimeo.com
                    (?:[\/\w]*\/videos?)?   # Optional video sub directory this handles groups links also
                    \/                      # Slash before Id
                    ([0-9]+)                # $1: VIDEO_ID is numeric
                    [^\s]*                  # Not a space
                )                           # End group
                "?                          # Match end quote if part of src
                (?:[^>]*></iframe>)?        # Match the end of the iframe
                (?:<p>.*</p>)?              # Match any title information stuff
                ~ix';
        
            preg_match($regexstr, $link, $matches);
        
            return $matches[1];
        }
        /**
         * ************* Get Dailymotion ID *****************
         *---------------------------------------------------
         */  
        static function bk_parse_dailymotion($link){
            preg_match('#<object[^>]+>.+?http://www.dailymotion.com/swf/video/([A-Za-z0-9]+).+?</object>#s', $link, $matches);
        
                // Dailymotion url
                if(!isset($matches[1])) {
                    preg_match('#http://www.dailymotion.com/video/([A-Za-z0-9]+)#s', $link, $matches);
                }
        
                // Dailymotion iframe
                if(!isset($matches[1])) {
                    preg_match('#http://www.dailymotion.com/embed/video/([A-Za-z0-9]+)#s', $link, $matches);
                }
            return $matches[1];
        }
        static function get_post_icon_class($postSource, $iconSize = '', $iconPosition = 'top-right', $addClass = ''){
            
            $postIconClass = '';
            
            if($iconPosition == 'top-right'){
                $postIconClass = 'overlay-item post-type-icon--inverse';
            }elseif($iconPosition == 'top-left'){
                $postIconClass = 'overlay-item--top-left post-type-icon--inverse';
            }elseif($iconPosition == 'left-bottom'){
                $postIconClass = 'overlay-item--left-bottom post-type-icon--inverse';
            }elseif($iconPosition == 'right-bottom'){
                $postIconClass = 'overlay-item--right-bottom post-type-icon--inverse';
            }else {
                $postIconClass = 'overlay-item--center-xy post-type-icon';
            }
            
            if($postSource == 'gallery'){
                $postIconClass = 'overlay-item post-type-icon--inverse gallery-icon';
            }else {
                if($iconSize == 'large') {
                    $postIconClass .= ' post-type-icon--lg';
                }else if($iconSize == 'medium') {
                    $postIconClass .= ' post-type-icon--md';
                }else if($iconSize == 'small') {
                    $postIconClass .= ' post-type-icon--sm';
                }
            }
            
            $postIconClass .= ' '.$addClass;
            
            return $postIconClass;
            
        }
        static function ceris_html_render($html_render, $check = 0){
            if($check != 0) {
                return $html_render;
            }else {
                return $html_render;
            }
        }
        //the default options
        static function pagenavi_init() {
            $pagenavi_options = array();
            $pagenavi_options['pages_text'] = esc_html__('Page %CURRENT_PAGE% of %TOTAL_PAGES%', 'ceris');
            $pagenavi_options['current_text'] = '%PAGE_NUMBER%';
            $pagenavi_options['page_text'] = '%PAGE_NUMBER%';
            $pagenavi_options['first_text'] = esc_html__('1', 'ceris');
            $pagenavi_options['last_text'] = esc_html__('%TOTAL_PAGES%', 'ceris');

            $pagenavi_options['next_text'] = '<span class="atbs-ceris-pagination__item atbs-ceris-pagination__item-next"><i class="mdicon mdicon-arrow_forward"></i></span>';
            $pagenavi_options['prev_text'] = '<span class="atbs-ceris-pagination__item atbs-ceris-pagination__item-prev"><i class="mdicon mdicon-arrow_back"></i></span>';
        
            $pagenavi_options['dotright_text'] = esc_html__('...', 'ceris');
            $pagenavi_options['dotleft_text'] = esc_html__('...', 'ceris');
    
    
            $pagenavi_options['num_pages'] = 3;
    
            $pagenavi_options['always_show'] = 0;
            $pagenavi_options['num_larger_page_numbers'] = 3;
            $pagenavi_options['larger_page_numbers_multiple'] = 1000;
    
            return $pagenavi_options;
        }
        
        static function ceris_round_number($num, $tonearest) {
            return floor($num/$tonearest)*$tonearest;
        }
        
        static function ceris_get_pagination() {
    
            if (is_singular()) {
                return; //no pagination on single pages
            }
    
            global $wpdb, $wp_query;
            $pagenavi_options = self::pagenavi_init();
        
            $pagination_ret = '';
            $request = $wp_query->request;
            $posts_per_page = intval(get_query_var('posts_per_page'));
            $paged = intval(get_query_var('paged'));
            $numposts = $wp_query->found_posts;
            $max_page = $wp_query->max_num_pages;

            if(empty($paged) || $paged == 0) {
                $paged = 1;
            }
            $pages_to_show = intval($pagenavi_options['num_pages']);
            $larger_page_to_show = intval($pagenavi_options['num_larger_page_numbers']);
            $larger_page_multiple = intval($pagenavi_options['larger_page_numbers_multiple']);
            $pages_to_show_minus_1 = $pages_to_show - 1;
            $half_page_start = floor($pages_to_show_minus_1/2);
            $half_page_end = ceil($pages_to_show_minus_1/2);
            $start_page = $paged - $half_page_start;
            if($start_page <= 0) {
                $start_page = 1;
            }
            $end_page = $paged + $half_page_end;
            if(($end_page - $start_page) != $pages_to_show_minus_1) {
                $end_page = $start_page + $pages_to_show_minus_1;
            }
            if($end_page > $max_page) {
                $start_page = $max_page - $pages_to_show_minus_1;
                $end_page = $max_page;
            }
            if($start_page <= 0) {
                $start_page = 1;
            }
            $larger_per_page = $larger_page_to_show*$larger_page_multiple;
            $larger_start_page_start = (self::ceris_round_number($start_page, 10) + $larger_page_multiple) - $larger_per_page;
            $larger_start_page_end = self::ceris_round_number($start_page, 10) + $larger_page_multiple;
            $larger_end_page_start = self::ceris_round_number($end_page, 10) + $larger_page_multiple;
            $larger_end_page_end = self::ceris_round_number($end_page, 10) + ($larger_per_page);
            if($larger_start_page_end - $larger_page_multiple == $start_page) {
                $larger_start_page_start = $larger_start_page_start - $larger_page_multiple;
                $larger_start_page_end = $larger_start_page_end - $larger_page_multiple;
            }
            if($larger_start_page_start <= 0) {
                $larger_start_page_start = $larger_page_multiple;
            }
            if($larger_start_page_end > $max_page) {
                $larger_start_page_end = $max_page;
            }
            if($larger_end_page_end > $max_page) {
                $larger_end_page_end = $max_page;
            }
    
            if($max_page > 1 || intval($pagenavi_options['always_show']) == 1) {
    
                $pagination_ret .= '<div class="atbs-ceris-pagination pagination-circle">';
    			$pagination_ret .= '<h4 class="atbs-ceris-pagination__title sr-only">'.esc_html__('Posts navigation', 'ceris').'</h4>';
                $pagination_ret .= '<div class="atbs-ceris-pagination__links text-center">';
    			$pagination_ret .= get_previous_posts_link($pagenavi_options['prev_text']);
                                             
                if ($start_page >= 2 && $pages_to_show < $max_page) {
                    $first_page_text = str_replace("%TOTAL_PAGES%", number_format_i18n($max_page), $pagenavi_options['first_text']);
                    $pagination_ret .= '<a href="'.esc_url(get_pagenum_link()).'" class="atbs-ceris-pagination__item" title="'.$first_page_text.'">'.$first_page_text.'</a>';
                    if(!empty($pagenavi_options['dotleft_text']) && ($start_page > 2)) {
                        $pagination_ret .= '<span class="atbs-ceris-pagination__item atbs-ceris-pagination__dots">'.$pagenavi_options['dotleft_text'].'</span>';
                    }
                }
                if($larger_page_to_show > 0 && $larger_start_page_start > 0 && $larger_start_page_end <= $max_page) {
                    for($i = $larger_start_page_start; $i < $larger_start_page_end; $i+=$larger_page_multiple) {
                        $page_text = str_replace("%PAGE_NUMBER%", number_format_i18n($i), $pagenavi_options['page_text']);
                        $pagination_ret .= '<a href="'.esc_url(get_pagenum_link($i)).'" class="atbs-ceris-pagination__item" title="'.$page_text.'">'.$page_text.'</a>';
                    }
                }
                
                for($i = $start_page; $i  <= $end_page; $i++) {
                    if($i == $paged) {
                        $current_page_text = str_replace("%PAGE_NUMBER%", number_format_i18n($i), $pagenavi_options['current_text']);
                        $pagination_ret .= '<span class="atbs-ceris-pagination__item atbs-ceris-pagination__item-current">'.$current_page_text.'</span>';
                    } else {
                        $page_text = str_replace("%PAGE_NUMBER%", number_format_i18n($i), $pagenavi_options['page_text']);
                        $pagination_ret .= '<a href="'.esc_url(get_pagenum_link($i)).'" class="atbs-ceris-pagination__item" title="'.$page_text.'">'.$page_text.'</a>';
                    }
                }
                
                if($larger_page_to_show > 0 && $larger_end_page_start < $max_page) {
                    for($i = $larger_end_page_start; $i <= $larger_end_page_end; $i+=$larger_page_multiple) {
                        $page_text = str_replace("%PAGE_NUMBER%", number_format_i18n($i), $pagenavi_options['page_text']);
                        $pagination_ret .= '<a href="'.esc_url(get_pagenum_link($i)).'" class="atbs-ceris-pagination__item" title="'.$page_text.'">'.$page_text.'</a>';
                    }
                }
                if ($end_page < $max_page) {
                    if(!empty($pagenavi_options['dotright_text']) && ($end_page + 1 < $max_page)) {
                        $pagination_ret .= '<span class="atbs-ceris-pagination__item atbs-ceris-pagination__dots">'.$pagenavi_options['dotright_text'].'</span>';
                    }
                    $last_page_text = str_replace("%TOTAL_PAGES%", number_format_i18n($max_page), $pagenavi_options['last_text']);
                    $pagination_ret .= '<a href="'.esc_url(get_pagenum_link($max_page)).'" class="atbs-ceris-pagination__item" title="'.$last_page_text.'">'.$last_page_text.'</a>';
                }
    			$pagination_ret .= get_next_posts_link($pagenavi_options['next_text'], $max_page);
    
                $pagination_ret .= '</div>';
                $pagination_ret .= '</div>';
            }
            
            return $pagination_ret;
        
        }
        static function bk_darkmode_cookie_name() {
            return 'ceris_dark_mode-' . sha1(get_home_url());
        }
        static function bk_remove_darkmode_cookie() {
            $cookie_name = self::bk_darkmode_cookie_name();
            setcookie($cookie_name, '', strtotime( '-30 days' ), '/');
        }
        static function bk_get_darkmode_cookie() {
            $cookie_name = self::bk_darkmode_cookie_name();
            if ( isset($_COOKIE[$cookie_name]) ) {
                return $_COOKIE[$cookie_name];
            }
            return false;
        }
        static function bk_get_darkmode_class() {
            if ( self::bk_get_darkmode_cookie() ) {
                return ' ceris-dark-mode';
            }
            return '';
        }

    } // Close ceris_core class
    
}
