<?php
/* 
 * Sections Configuration
 */
 if ( ! function_exists( 'bk_init_sections' ) ) {
	function bk_init_sections() {
		$sections = array(
            'fullwidth'=>__('FullWidth Section','ceris'), 'has-rsb' => esc_html__('Content Section', 'ceris')
		);
		wp_localize_script( 'bk-composer-script', 'bk_sections', $sections );
        $modules = array(
            'featured_with_list_horizontal' => array(
				'title' => esc_html__( 'Featured With List Horizontal', 'ceris' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/2.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Spacing',
                    
                ),
				'options' => array(
                    //Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
                            'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'ceris' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
                            'top_review'        => esc_html__( 'Best Review', 'ceris' ),
                            'modified'          => esc_html__( 'Modified', 'ceris' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
                        'description' => esc_html__( 'All - Show All Post Type - This module does not show the post icons', 'ceris' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
                            'gallery'    => esc_html__( 'Gallery', 'ceris' ),
                            'review'     => esc_html__( 'Review', 'ceris' ),
						),
					),
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
            ),
	        'featured_slider' => array(
				'title' => esc_html__( 'Featured Slider A', 'ceris' ),
	            'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ceris_1.png',
	            'tabdisable' => 'tab-option-6',
	            'tabnames'  => array(
	                'tab-1' => 'General',
	                'tab-2' => 'Query Option',
	                'tab-3' => 'Manually Pick Post',
	                'tab-4' => 'Post Type',
	                'tab-5' => 'Spacing',
	            ),
				'options' => array(
	                // Tab 1
	                'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
	                'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                
	                // Tab 2
	                'limit' => array(
						'title' => esc_html__('Number of Posts', 'ceris' ),
						'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 4
					),
	                'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'number',
						'default' => 0
					),
	                'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
	                    'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
	                        'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
	                'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
	                        'date'              => esc_html__( 'Latest Posts', 'ceris' ),
	                        'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
	                        'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
	                        'top_review'        => esc_html__( 'Best Review', 'ceris' ),
	                        'modified'          => esc_html__( 'Modified', 'ceris' ),
	                        'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
	                        'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
	                        'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
	                'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'category',
						'default' => '0',
					),
	                // Tab 3
	                'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                // Tab 4
	                'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
	                    'description' => esc_html__( 'All - Show All Post Type, This module does not show the post icons', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
	                        'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
	                        'gallery'    => esc_html__( 'Gallery', 'ceris' ),
	                        'review'     => esc_html__( 'Review', 'ceris' ),
						),
					),  
	                'post_icon' => array(
						'title' => esc_html__('Post Icon', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
						),
					), 
					'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					), 
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
	        ),
			'featured_slider_b' => array(
				'title' => esc_html__( 'Featured Slider B', 'ceris' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ce_17.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Spacing',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'ceris' ),
						'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 3
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
                            'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'ceris' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
                            'top_review'        => esc_html__( 'Best Review', 'ceris' ),
                            'modified'          => esc_html__( 'Modified', 'ceris' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
                        'description' => esc_html__( 'All - Show All Post Type, This module does not show the post icons', 'ceris' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
                            'gallery'    => esc_html__( 'Gallery', 'ceris' ),
                            'review'     => esc_html__( 'Review', 'ceris' ),
						),
					),//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
            ),
			'featured_slider_c' => array(
				'title' => esc_html__( 'Featured Slider C', 'ceris' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ce_29.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Spacing',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'ceris' ),
						'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 3
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
                            'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'ceris' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
                            'top_review'        => esc_html__( 'Best Review', 'ceris' ),
                            'modified'          => esc_html__( 'Modified', 'ceris' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
                        'description' => esc_html__( 'All - Show All Post Type, This module does not show the post icons', 'ceris' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
                            'gallery'    => esc_html__( 'Gallery', 'ceris' ),
                            'review'     => esc_html__( 'Review', 'ceris' ),
						),
					),
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
            ),
			'featured_slider_d' => array(
				'title' => esc_html__( 'Featured Slider D', 'ceris' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ce_31.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Spacing',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'ceris' ),
						'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 3
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
                            'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'ceris' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
                            'top_review'        => esc_html__( 'Best Review', 'ceris' ),
                            'modified'          => esc_html__( 'Modified', 'ceris' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
                        'description' => esc_html__( 'All - Show All Post Type, This module does not show the post icons', 'ceris' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
                            'gallery'    => esc_html__( 'Gallery', 'ceris' ),
                            'review'     => esc_html__( 'Review', 'ceris' ),
						),
					),
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
            ),
			'featured_slider_e' => array(
				'title' => esc_html__( 'Featured Slider E', 'ceris' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ce_27.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Spacing',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'ceris' ),
						'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 3
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
                            'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'ceris' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
                            'top_review'        => esc_html__( 'Best Review', 'ceris' ),
                            'modified'          => esc_html__( 'Modified', 'ceris' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
                        'description' => esc_html__( 'All - Show All Post Type, This module does not show the post icons', 'ceris' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
                            'gallery'    => esc_html__( 'Gallery', 'ceris' ),
                            'review'     => esc_html__( 'Review', 'ceris' ),
						),
					),
					'post_icon' => array(
						'title' => esc_html__('Post Icon', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
						),
					),
					'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
            ),
			'featured_slider_f' => array(
				'title' => esc_html__( 'Featured Slider F', 'ceris' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ce_36.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Spacing',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'ceris' ),
						'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 4
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
                            'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'ceris' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
                            'top_review'        => esc_html__( 'Best Review', 'ceris' ),
                            'modified'          => esc_html__( 'Modified', 'ceris' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
                        'description' => esc_html__( 'All - Show All Post Type, This module does not show the post icons', 'ceris' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
                            'gallery'    => esc_html__( 'Gallery', 'ceris' ),
                            'review'     => esc_html__( 'Review', 'ceris' ),
						),
					),
					'post_icon' => array(
						'title' => esc_html__('Post Icon', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
						),
					),
					'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
            ),
            'featured_module' => array(
				'title' => esc_html__( 'Featured Module A', 'ceris' ),
	            'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ceris_14.png',
	            'tabdisable' => 'tab-option-6',
	            'tabnames'  => array(
	                'tab-1' => 'General',
	                'tab-2' => 'Query Option',
	                'tab-3' => 'Manually Pick Post',
	                'tab-4' => 'Post Type',
	                'tab-5' => 'Spacing',
	            ),
				'options' => array(
	                // Tab 1
	                'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
	                'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'number',
						'default' => 0
					),
	                'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
	                    'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
	                        'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
	                'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
	                        'date'              => esc_html__( 'Latest Posts', 'ceris' ),
	                        'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
	                        'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
	                        'top_review'        => esc_html__( 'Best Review', 'ceris' ),
	                        'modified'          => esc_html__( 'Modified', 'ceris' ),
	                        'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
	                        'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
	                        'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
	                'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'category',
						'default' => '0',
					),
	                // Tab 3
	                'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                // Tab 4
	                'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
	                    'description' => esc_html__( 'All - Show All Post Type, This module does not show the post icons', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
	                        'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
	                        'gallery'    => esc_html__( 'Gallery', 'ceris' ),
	                        'review'     => esc_html__( 'Review', 'ceris' ),
						),
					),   
	                'post_icon' => array(
						'title' => esc_html__('Post Icon', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
						),
					), 
					'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
	        ),
            'featured_module_b' => array(
				'title' => esc_html__( 'Featured Module B', 'ceris' ),
	            'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ceris_26.png',
	            'tabdisable' => 'tab-option-6',
	            'tabnames'  => array(
	                'tab-1' => 'General',
	                'tab-2' => 'Query Option',
	                'tab-3' => 'Manually Pick Post',
	                'tab-4' => 'Post Type',
	                'tab-5' => 'Spacing',
	            ),
				'options' => array(
	                // Tab 1
	                'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
	                'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
					//tag 2
					'limit' => array(
						'title' => esc_html__('Number of Posts', 'ceris' ),
						'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 8
					),
	                'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'number',
						'default' => 0
					),
	                'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
	                    'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
	                        'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
	                'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
	                        'date'              => esc_html__( 'Latest Posts', 'ceris' ),
	                        'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
	                        'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
	                        'top_review'        => esc_html__( 'Best Review', 'ceris' ),
	                        'modified'          => esc_html__( 'Modified', 'ceris' ),
	                        'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
	                        'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
	                        'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
	                'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'category',
						'default' => '0',
					),
	                // Tab 3
	                'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                // Tab 4
	                'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
	                    'description' => esc_html__( 'All - Show All Post Type, This module does not show the post icons', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
	                        'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
	                        'gallery'    => esc_html__( 'Gallery', 'ceris' ),
	                        'review'     => esc_html__( 'Review', 'ceris' ),
						),
					),
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
	        ),
            'featured_module_c' => array(
				'title' => esc_html__( 'Featured Module C', 'ceris' ),
	            'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ceris_27.png',
	            'tabdisable' => 'tab-option-6',
	            'tabnames'  => array(
	                'tab-1' => 'General',
	                'tab-2' => 'Query Option',
	                'tab-3' => 'Manually Pick Post',
	                'tab-4' => 'Post Type',
	                'tab-5' => 'Spacing',
	            ),
				'options' => array(
	                // Tab 1
	                'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
                    'module_style' => array(
						'title' => esc_html__('Module Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'dark',
						'options' => array(
	                        'dark'     => esc_html__( 'Dark Style', 'ceris' ),
	                        'light'    => esc_html__( 'Light Style', 'ceris' ),
						),
					),
	                'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
					//tag 2
					'limit' => array(
						'title' => esc_html__('Number of Posts', 'ceris' ),
						'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 8
					),
	                'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'number',
						'default' => 0
					),
	                'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
	                    'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
	                        'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
	                'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
	                        'date'              => esc_html__( 'Latest Posts', 'ceris' ),
	                        'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
	                        'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
	                        'top_review'        => esc_html__( 'Best Review', 'ceris' ),
	                        'modified'          => esc_html__( 'Modified', 'ceris' ),
	                        'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
	                        'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
	                        'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
	                'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'category',
						'default' => '0',
					),
	                // Tab 3
	                'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                // Tab 4
	                'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
	                    'description' => esc_html__( 'All - Show All Post Type, This module does not show the post icons', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
	                        'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
	                        'gallery'    => esc_html__( 'Gallery', 'ceris' ),
	                        'review'     => esc_html__( 'Review', 'ceris' ),
						),
					),
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ), 
				),
	        ),
            'featured_module_d' => array(
				'title' => esc_html__( 'Featured Module D', 'ceris' ),
	            'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ceris_28.png',
	            'tabdisable' => 'tab-option-6',
	            'tabnames'  => array(
	                'tab-1' => 'General',
	                'tab-2' => 'Query Option',
	                'tab-3' => 'Manually Pick Post',
	                'tab-4' => 'Post Type',
	                'tab-5' => 'Spacing',
	            ),
				'options' => array(
	                // Tab 1
	                'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
	                'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
					//tag 2
					'limit' => array(
						'title' => esc_html__('Number of Posts', 'ceris' ),
						'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 8
					),
	                'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'number',
						'default' => 0
					),
	                'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
	                    'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
	                        'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
	                'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
	                        'date'              => esc_html__( 'Latest Posts', 'ceris' ),
	                        'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
	                        'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
	                        'top_review'        => esc_html__( 'Best Review', 'ceris' ),
	                        'modified'          => esc_html__( 'Modified', 'ceris' ),
	                        'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
	                        'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
	                        'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
	                'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'category',
						'default' => '0',
					),
	                // Tab 3
	                'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                // Tab 4
	                'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
	                    'description' => esc_html__( 'All - Show All Post Type, This module does not show the post icons', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
	                        'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
	                        'gallery'    => esc_html__( 'Gallery', 'ceris' ),
	                        'review'     => esc_html__( 'Review', 'ceris' ),
						),
					),   
	                'post_icon' => array(
						'title' => esc_html__('Post Icon', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
						),
					), 
					'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
	        ),
            'featured_module_e' => array(
				'title' => esc_html__( 'Featured Module E', 'ceris' ),
	            'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ceris_29.png',
	            'tabdisable' => 'tab-option-6',
	            'tabnames'  => array(
	                'tab-1' => 'General',
	                'tab-2' => 'Query Option',
	                'tab-3' => 'Manually Pick Post',
	                'tab-4' => 'Post Type',
	                'tab-5' => 'Spacing',
	            ),
				'options' => array(
	                // Tab 1
	                'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
	                'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
					//tag 2
					'limit' => array(
						'title' => esc_html__('Number of Posts', 'ceris' ),
						'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 8
					),
	                'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'number',
						'default' => 0
					),
	                'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
	                    'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
	                        'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
	                'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
	                        'date'              => esc_html__( 'Latest Posts', 'ceris' ),
	                        'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
	                        'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
	                        'top_review'        => esc_html__( 'Best Review', 'ceris' ),
	                        'modified'          => esc_html__( 'Modified', 'ceris' ),
	                        'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
	                        'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
	                        'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
	                'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'category',
						'default' => '0',
					),
	                // Tab 3
	                'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                // Tab 4
	                'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
	                    'description' => esc_html__( 'All - Show All Post Type, This module does not show the post icons', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
	                        'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
	                        'gallery'    => esc_html__( 'Gallery', 'ceris' ),
	                        'review'     => esc_html__( 'Review', 'ceris' ),
						),
					),   
	                'post_icon' => array(
						'title' => esc_html__('Post Icon', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
						),
					), 
					'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					), 
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
	        ),
            'featured_module_f' => array(
				'title' => esc_html__( 'Featured Module F', 'ceris' ),
	            'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/featured_module_f.png',
	            'tabdisable' => 'tab-option-6',
	            'tabnames'  => array(
	                'tab-1' => 'General',
	                'tab-2' => 'Query Option',
	                'tab-3' => 'Manually Pick Post',
	                'tab-4' => 'Post Type',
	                'tab-5' => 'Spacing',
	            ),
				'options' => array(
	                // Tab 1
	                'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
	                'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
					//tag 2
	                'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'number',
						'default' => 0
					),
	                'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
	                    'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
	                        'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
	                'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
	                        'date'              => esc_html__( 'Latest Posts', 'ceris' ),
	                        'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
	                        'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
	                        'top_review'        => esc_html__( 'Best Review', 'ceris' ),
	                        'modified'          => esc_html__( 'Modified', 'ceris' ),
	                        'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
	                        'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
	                        'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
	                'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'category',
						'default' => '0',
					),
	                // Tab 3
	                'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                // Tab 4
	                'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
	                    'description' => esc_html__( 'All - Show All Post Type, This module does not show the post icons', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
	                        'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
	                        'gallery'    => esc_html__( 'Gallery', 'ceris' ),
	                        'review'     => esc_html__( 'Review', 'ceris' ),
						),
					),   
	                'post_icon' => array(
						'title' => esc_html__('Post Icon', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
						),
					), 
					'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					), 
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
	        ),
            'featured_module_g' => array(
				'title' => esc_html__( 'Featured Module G', 'ceris' ),
	            'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/featured_module_g.png',
	            'tabdisable' => 'tab-option-6',
	            'tabnames'  => array(
	                'tab-1' => 'General',
	                'tab-2' => 'Query Option',
	                'tab-3' => 'Manually Pick Post',
	                'tab-4' => 'Post Type',
	                'tab-5' => 'Spacing',
	            ),
				'options' => array(
	                // Tab 1
	                'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
	                'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'ceris' ),
						'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 6
					),
	                'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'number',
						'default' => 0
					),
	                'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
	                    'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
	                        'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
	                'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
	                        'date'              => esc_html__( 'Latest Posts', 'ceris' ),
	                        'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
	                        'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
	                        'top_review'        => esc_html__( 'Best Review', 'ceris' ),
	                        'modified'          => esc_html__( 'Modified', 'ceris' ),
	                        'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
	                        'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
	                        'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
	                'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'category',
						'default' => '0',
					),
	                // Tab 3
	                'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                // Tab 4
	                'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
	                    'description' => esc_html__( 'All - Show All Post Type, This module does not show the post icons', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
	                        'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
	                        'gallery'    => esc_html__( 'Gallery', 'ceris' ),
	                        'review'     => esc_html__( 'Review', 'ceris' ),
						),
					),   
	                'post_icon' => array(
						'title' => esc_html__('Post Icon', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
						),
					), 
					'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					), 
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
	        ),
            'featured_module_h' => array(
				'title' => esc_html__( 'Featured Module H', 'ceris' ),
	            'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/featured_module_h.png',
	            'tabdisable' => 'tab-option-6',
	            'tabnames'  => array(
	                'tab-1' => 'General',
	                'tab-2' => 'Query Option',
	                'tab-3' => 'Manually Pick Post',
	                'tab-4' => 'Post Type',
	                'tab-5' => 'Spacing',
	            ),
				'options' => array(
	                // Tab 1
	                'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
	                'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'ceris' ),
						'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 6
					),
	                'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'number',
						'default' => 0
					),
	                'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
	                    'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
	                        'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
	                'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
	                        'date'              => esc_html__( 'Latest Posts', 'ceris' ),
	                        'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
	                        'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
	                        'top_review'        => esc_html__( 'Best Review', 'ceris' ),
	                        'modified'          => esc_html__( 'Modified', 'ceris' ),
	                        'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
	                        'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
	                        'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
	                'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'category',
						'default' => '0',
					),
	                // Tab 3
	                'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                // Tab 4
	                'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
	                    'description' => esc_html__( 'All - Show All Post Type, This module does not show the post icons', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
	                        'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
	                        'gallery'    => esc_html__( 'Gallery', 'ceris' ),
	                        'review'     => esc_html__( 'Review', 'ceris' ),
						),
					),   
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
	        ),
            'featured_module_i' => array(
				'title' => esc_html__( 'Featured Module I', 'ceris' ),
	            'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ceris_40.png',
	            'tabdisable' => 'tab-option-6',
	            'tabnames'  => array(
	                'tab-1' => 'General',
	                'tab-2' => 'Query Option',
	                'tab-3' => 'Manually Pick Post',
	                'tab-4' => 'Post Type',
	                'tab-5' => 'Spacing',
	            ),
				'options' => array(
	                // Tab 1
	                'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
                    'small_title' => array(
						'title' => esc_html__('Small Title', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'ceris' ),
						'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 6
					),
	                'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'number',
						'default' => 0
					),
	                'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
	                    'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
	                        'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
	                'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
	                        'date'              => esc_html__( 'Latest Posts', 'ceris' ),
	                        'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
	                        'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
	                        'top_review'        => esc_html__( 'Best Review', 'ceris' ),
	                        'modified'          => esc_html__( 'Modified', 'ceris' ),
	                        'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
	                        'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
	                        'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
	                'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'category',
						'default' => '0',
					),
	                // Tab 3
	                'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                // Tab 4
	                'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
	                    'description' => esc_html__( 'All - Show All Post Type, This module does not show the post icons', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
	                        'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
	                        'gallery'    => esc_html__( 'Gallery', 'ceris' ),
	                        'review'     => esc_html__( 'Review', 'ceris' ),
						),
					),   
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50
                    ),
				),
	        ),
            'featured_module_j' => array(
				'title' => esc_html__( 'Featured Module J', 'ceris' ),
	            'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ceris_41.png',
	            'tabdisable' => 'tab-option-6',
	            'tabnames'  => array(
	                'tab-1' => 'General',
	                'tab-2' => 'Query Option',
	                'tab-3' => 'Manually Pick Post',
	                'tab-4' => 'Post Type',
	                'tab-5' => 'Spacing',
	            ),
				'options' => array(
	                // Tab 1
	                'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
	                'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'ceris' ),
						'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 6
					),
	                'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'number',
						'default' => 0
					),
	                'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
	                    'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
	                        'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
	                'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
	                        'date'              => esc_html__( 'Latest Posts', 'ceris' ),
	                        'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
	                        'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
	                        'top_review'        => esc_html__( 'Best Review', 'ceris' ),
	                        'modified'          => esc_html__( 'Modified', 'ceris' ),
	                        'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
	                        'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
	                        'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
	                'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'category',
						'default' => '0',
					),
	                // Tab 3
	                'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                // Tab 4
	                'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
	                    'description' => esc_html__( 'All - Show All Post Type, This module does not show the post icons', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
	                        'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
	                        'gallery'    => esc_html__( 'Gallery', 'ceris' ),
	                        'review'     => esc_html__( 'Review', 'ceris' ),
						),
					),   
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50
                    ),
				),
	        ),
            'featured_module_l' => array(
				'title' => esc_html__( 'Featured Module L', 'ceris' ),
	            'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ceris_45.png',
	            'tabdisable' => 'tab-option-6',
	            'tabnames'  => array(
	                'tab-1' => 'General',
	                'tab-2' => 'Query Option',
	                'tab-3' => 'Manually Pick Post',
	                'tab-4' => 'Post Type',
	                'tab-5' => 'Spacing',
	            ),
				'options' => array(
	                // Tab 1
	                'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
	                'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'ceris' ),
						'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 6
					),
	                'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'number',
						'default' => 0
					),
	                'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
	                    'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
	                        'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
	                'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
	                        'date'              => esc_html__( 'Latest Posts', 'ceris' ),
	                        'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
	                        'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
	                        'top_review'        => esc_html__( 'Best Review', 'ceris' ),
	                        'modified'          => esc_html__( 'Modified', 'ceris' ),
	                        'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
	                        'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
	                        'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
	                'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'category',
						'default' => '0',
					),
	                // Tab 3
	                'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                // Tab 4
	                'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
	                    'description' => esc_html__( 'All - Show All Post Type, This module does not show the post icons', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
	                        'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
	                        'gallery'    => esc_html__( 'Gallery', 'ceris' ),
	                        'review'     => esc_html__( 'Review', 'ceris' ),
						),
					),  
	                'post_icon' => array(
						'title' => esc_html__('Post Icon', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
						),
					),
					'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),    
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50
                    ),
				),
	        ),
            'featured_module_m' => array(
				'title' => esc_html__( 'Featured Module M', 'ceris' ),
	            'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ceris_featured_module_m.png',
	            'tabdisable' => 'tab-option-6',
	            'tabnames'  => array(
	                'tab-1' => 'General',
	                'tab-2' => 'Query Option',
	                'tab-3' => 'Manually Pick Post',
	                'tab-4' => 'Post Type',
	                'tab-5' => 'Spacing',
	            ),
				'options' => array(
	                // Tab 1
	                'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
	                'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
	                'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'number',
						'default' => 0
					),
	                'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
	                    'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
	                        'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
	                'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
	                        'date'              => esc_html__( 'Latest Posts', 'ceris' ),
	                        'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
	                        'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
	                        'top_review'        => esc_html__( 'Best Review', 'ceris' ),
	                        'modified'          => esc_html__( 'Modified', 'ceris' ),
	                        'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
	                        'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
	                        'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
	                'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'category',
						'default' => '0',
					),
	                // Tab 3
	                'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                // Tab 4
	                'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
	                    'description' => esc_html__( 'All - Show All Post Type, This module does not show the post icons', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
	                        'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
	                        'gallery'    => esc_html__( 'Gallery', 'ceris' ),
	                        'review'     => esc_html__( 'Review', 'ceris' ),
						),
					),  
	                'post_icon' => array(
						'title' => esc_html__('Post Icon', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
						),
					), 
					'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					), 
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
	        ),
	        'block_fullwidth_two_sidebar_listing_list' => array(
				'title' => esc_html__( 'Block Two Sidebar Listing List', 'ceris' ),
	            'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ceris_37.png',
	            'tabdisable' => '',
	            'tabnames'  => array(
	                'tab-1' => esc_html__('General', 'ceris'),
	                'tab-2' => 'Query Option',
	                'tab-3' => 'Manually Pick Post',
	                'tab-4' => 'Post Type',
	                'tab-5' => 'Spacing',
	                'tab-6' => 'Sidebar',
	            ),
				'options' => array(
	                // Tab 1
	                'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
                    'bookmark' => array(
                        'title' => esc_html__('Bookmark', 'ceris'),
                        'description' => esc_html__( 'Allow bookmark buttons in this module', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'field' => 'select',
                        'default' => 'off',
                        'options' => array(
                            'on'   => esc_html__( 'On', 'ceris' ),
                            'off'    => esc_html__( 'Off', 'ceris' ),
                        ),
                    ),
                    'ajax_load_more' => array(
						'title' => esc_html__('Ajax Load More', 'ceris'),
                        'description' => esc_html__( 'Select an Ajax Load More Type', 'ceris' ),
						'optionclass' => 'option-tab-1 ceris-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'ceris' ),
                            'pagination' => esc_html__( 'Ajax Pagination', 'ceris' ),
                            'loadmore' => esc_html__( 'Ajax Load More Button', 'ceris' ),
                            'infinity' => esc_html__( 'Ajax Infinity Scrolling', 'ceris' ),
                            'viewall' => esc_html__( 'View All Button', 'ceris' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'ceris' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'ceris' ),
                        'optionclass' => 'option-tab-1 ceris-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ceris-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'ceris'),
						'optionclass' => 'option-tab-1 ceris-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'ceris' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'ceris' ),
						),
					),
	                'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                
	                // Tab 2

	                'limit' => array(
	                    'title' => esc_html__('Number of Posts', 'ceris' ),
	                    'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'number',
	                    'default' => 10
	                ),
	                'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'number',
						'default' => 0
					),
	                'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
	                    'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
	                        'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
	                'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
	                        'date'              => esc_html__( 'Latest Posts', 'ceris' ),
	                        'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
	                        'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
	                        'top_review'        => esc_html__( 'Best Review', 'ceris' ),
	                        'modified'          => esc_html__( 'Modified', 'ceris' ),
	                        'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
	                        'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
	                        'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
	                'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'category',
						'default' => '0',
					),
					'limit' => array(
                        'title' => esc_html__('Number of Posts', 'ceris' ),
                        'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
                        'optionclass' => 'option-tab-2',
                        'field' => 'number',
                        'default' => 10
                    ),
                    'ajax_load_more' => array(
						'title' => esc_html__('Ajax Load More', 'ceris'),
                        'description' => esc_html__( 'Select an Ajax Load More Type', 'ceris' ),
						'optionclass' => 'option-tab-1 ceris-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'ceris' ),
                            'pagination' => esc_html__( 'Ajax Pagination', 'ceris' ),
                            'loadmore' => esc_html__( 'Ajax Load More Button', 'ceris' ),
                            'infinity' => esc_html__( 'Ajax Infinity Scrolling', 'ceris' ),
                            'viewall' => esc_html__( 'View All Button', 'ceris' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'ceris' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'ceris' ),
                        'optionclass' => 'option-tab-1 ceris-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ceris-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'ceris'),
						'optionclass' => 'option-tab-1 ceris-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'ceris' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'ceris' ),
						),
					),
	                // Tab 3
	                'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                // Tab 4
	                'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
	                    'description' => esc_html__( 'All - Show All Post Type, This module does not show the post icons', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
	                        'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
	                        'gallery'    => esc_html__( 'Gallery', 'ceris' ),
	                        'review'     => esc_html__( 'Review', 'ceris' ),
						),
					),  
	                'post_icon' => array(
						'title' => esc_html__('Post Icon', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
						),
					),
					'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),  
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
                    //tab 6
                    'left_sidebar' => array(
						'title' => esc_html__('Left Sidebar', 'ceris' ),
						'description' => esc_html__( 'Select a sidebar on the left side', 'ceris' ),
	                    'optionclass' => 'option-tab-6',
						'field' => 'sidebar_select',
						'default' => 'home_sidebar',
					),
					'right_sidebar' => array(
						'title' => esc_html__('Right Sidebar', 'ceris' ),
						'description' => esc_html__( 'Select a sidebar on the right side', 'ceris' ),
	                    'optionclass' => 'option-tab-6',
						'field' => 'sidebar_select',
						'default' => 'home_sidebar',
					),
				),
	        ), 
	        'block_fullwidth_two_sidebar_listing_grid' => array(
				'title' => esc_html__( 'Block Two Sidebar Listing Grid', 'ceris' ),
	            'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ceris_38.png',
	            'tabdisable' => '',
	            'tabnames'  => array(
	                'tab-1' => esc_html__('General', 'ceris'),
	                'tab-2' => 'Query Option',
	                'tab-3' => 'Manually Pick Post',
	                'tab-4' => 'Post Type',
	                'tab-5' => 'Spacing',
	                'tab-6' => 'Sidebar',
	            ),
				'options' => array(
	                // Tab 1
	                'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
                    'bookmark' => array(
                        'title' => esc_html__('Bookmark', 'ceris'),
                        'description' => esc_html__( 'Allow bookmark buttons in this module', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'field' => 'select',
                        'default' => 'off',
                        'options' => array(
                            'on'   => esc_html__( 'On', 'ceris' ),
                            'off'    => esc_html__( 'Off', 'ceris' ),
                        ),
                    ),
                    'ajax_load_more' => array(
						'title' => esc_html__('Ajax Load More', 'ceris'),
                        'description' => esc_html__( 'Select an Ajax Load More Type', 'ceris' ),
						'optionclass' => 'option-tab-1 ceris-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'ceris' ),
                            'pagination' => esc_html__( 'Ajax Pagination', 'ceris' ),
                            'loadmore' => esc_html__( 'Ajax Load More Button', 'ceris' ),
                            'infinity' => esc_html__( 'Ajax Infinity Scrolling', 'ceris' ),
                            'viewall' => esc_html__( 'View All Button', 'ceris' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'ceris' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'ceris' ),
                        'optionclass' => 'option-tab-1 ceris-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ceris-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'ceris'),
						'optionclass' => 'option-tab-1 ceris-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'ceris' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'ceris' ),
						),
					),
	                'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                
	                // Tab 2

	                'limit' => array(
	                    'title' => esc_html__('Number of Posts', 'ceris' ),
	                    'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'number',
	                    'default' => 10
	                ),
	                'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'number',
						'default' => 0
					),
	                'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
	                    'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
	                        'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
	                'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
	                        'date'              => esc_html__( 'Latest Posts', 'ceris' ),
	                        'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
	                        'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
	                        'top_review'        => esc_html__( 'Best Review', 'ceris' ),
	                        'modified'          => esc_html__( 'Modified', 'ceris' ),
	                        'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
	                        'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
	                        'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
	                'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'category',
						'default' => '0',
					),
					'limit' => array(
                        'title' => esc_html__('Number of Posts', 'ceris' ),
                        'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
                        'optionclass' => 'option-tab-2',
                        'field' => 'number',
                        'default' => 10
                    ),
                    'ajax_load_more' => array(
						'title' => esc_html__('Ajax Load More', 'ceris'),
                        'description' => esc_html__( 'Select an Ajax Load More Type', 'ceris' ),
						'optionclass' => 'option-tab-1 ceris-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'ceris' ),
                            'pagination' => esc_html__( 'Ajax Pagination', 'ceris' ),
                            'loadmore' => esc_html__( 'Ajax Load More Button', 'ceris' ),
                            'infinity' => esc_html__( 'Ajax Infinity Scrolling', 'ceris' ),
                            'viewall' => esc_html__( 'View All Button', 'ceris' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'ceris' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'ceris' ),
                        'optionclass' => 'option-tab-1 ceris-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ceris-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'ceris'),
						'optionclass' => 'option-tab-1 ceris-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'ceris' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'ceris' ),
						),
					),
	                // Tab 3
	                'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                // Tab 4
	                'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
	                    'description' => esc_html__( 'All - Show All Post Type, This module does not show the post icons', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
	                        'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
	                        'gallery'    => esc_html__( 'Gallery', 'ceris' ),
	                        'review'     => esc_html__( 'Review', 'ceris' ),
						),
					),  
	                'post_icon' => array(
						'title' => esc_html__('Post Icon', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
						),
					),
					'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),  
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
                    //tab 6
                    'left_sidebar' => array(
						'title' => esc_html__('Left Sidebar', 'ceris' ),
						'description' => esc_html__( 'Select a sidebar on the left side', 'ceris' ),
	                    'optionclass' => 'option-tab-6',
						'field' => 'sidebar_select',
						'default' => 'home_sidebar',
					),
					'right_sidebar' => array(
						'title' => esc_html__('Right Sidebar', 'ceris' ),
						'description' => esc_html__( 'Select a sidebar on the right side', 'ceris' ),
	                    'optionclass' => 'option-tab-6',
						'field' => 'sidebar_select',
						'default' => 'home_sidebar',
					),
				),
	        ),
	        'block_fullwidth_two_sidebar_listing_grid_b' => array(
				'title' => esc_html__( 'Block Two Sidebar Listing Grid B', 'ceris' ),
	            'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ceris_39.png',
	            'tabdisable' => '',
	            'tabnames'  => array(
	                'tab-1' => esc_html__('General', 'ceris'),
	                'tab-2' => 'Query Option',
	                'tab-3' => 'Manually Pick Post',
	                'tab-4' => 'Post Type',
	                'tab-5' => 'Spacing',
	                'tab-6' => 'Sidebar',
	            ),
				'options' => array(
	                // Tab 1
	                'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
                    'bookmark' => array(
                        'title' => esc_html__('Bookmark', 'ceris'),
                        'description' => esc_html__( 'Allow bookmark buttons in this module', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'field' => 'select',
                        'default' => 'off',
                        'options' => array(
                            'on'   => esc_html__( 'On', 'ceris' ),
                            'off'    => esc_html__( 'Off', 'ceris' ),
                        ),
                    ),
                    'ajax_load_more' => array(
						'title' => esc_html__('Ajax Load More', 'ceris'),
                        'description' => esc_html__( 'Select an Ajax Load More Type', 'ceris' ),
						'optionclass' => 'option-tab-1 ceris-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'ceris' ),
                            'pagination' => esc_html__( 'Ajax Pagination', 'ceris' ),
                            'loadmore' => esc_html__( 'Ajax Load More Button', 'ceris' ),
                            'infinity' => esc_html__( 'Ajax Infinity Scrolling', 'ceris' ),
                            'viewall' => esc_html__( 'View All Button', 'ceris' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'ceris' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'ceris' ),
                        'optionclass' => 'option-tab-1 ceris-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ceris-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'ceris'),
						'optionclass' => 'option-tab-1 ceris-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'ceris' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'ceris' ),
						),
					),
	                'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                
	                // Tab 2

	                'limit' => array(
	                    'title' => esc_html__('Number of Posts', 'ceris' ),
	                    'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'number',
	                    'default' => 10
	                ),
	                'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'number',
						'default' => 0
					),
	                'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
	                    'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
	                        'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
	                'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
	                        'date'              => esc_html__( 'Latest Posts', 'ceris' ),
	                        'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
	                        'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
	                        'top_review'        => esc_html__( 'Best Review', 'ceris' ),
	                        'modified'          => esc_html__( 'Modified', 'ceris' ),
	                        'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
	                        'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
	                        'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
	                'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'category',
						'default' => '0',
					),
					'limit' => array(
                        'title' => esc_html__('Number of Posts', 'ceris' ),
                        'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
                        'optionclass' => 'option-tab-2',
                        'field' => 'number',
                        'default' => 10
                    ),
                    'ajax_load_more' => array(
						'title' => esc_html__('Ajax Load More', 'ceris'),
                        'description' => esc_html__( 'Select an Ajax Load More Type', 'ceris' ),
						'optionclass' => 'option-tab-1 ceris-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'ceris' ),
                            'pagination' => esc_html__( 'Ajax Pagination', 'ceris' ),
                            'loadmore' => esc_html__( 'Ajax Load More Button', 'ceris' ),
                            'infinity' => esc_html__( 'Ajax Infinity Scrolling', 'ceris' ),
                            'viewall' => esc_html__( 'View All Button', 'ceris' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'ceris' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'ceris' ),
                        'optionclass' => 'option-tab-1 ceris-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ceris-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'ceris'),
						'optionclass' => 'option-tab-1 ceris-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'ceris' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'ceris' ),
						),
					),
	                // Tab 3
	                'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                // Tab 4
	                'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
	                    'description' => esc_html__( 'All - Show All Post Type, This module does not show the post icons', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
	                        'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
	                        'gallery'    => esc_html__( 'Gallery', 'ceris' ),
	                        'review'     => esc_html__( 'Review', 'ceris' ),
						),
					),  
	                'post_icon' => array(
						'title' => esc_html__('Post Icon', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
						),
					),
					'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),  
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
                    //tab 6
                    'left_sidebar' => array(
						'title' => esc_html__('Left Sidebar', 'ceris' ),
						'description' => esc_html__( 'Select a sidebar on the left side', 'ceris' ),
	                    'optionclass' => 'option-tab-6',
						'field' => 'sidebar_select',
						'default' => 'home_sidebar',
					),
					'right_sidebar' => array(
						'title' => esc_html__('Right Sidebar', 'ceris' ),
						'description' => esc_html__( 'Select a sidebar on the right side', 'ceris' ),
	                    'optionclass' => 'option-tab-6',
						'field' => 'sidebar_select',
						'default' => 'home_sidebar',
					),
				),
	        ),
			'about_module' => array(
				'title' => esc_html__( 'About Module', 'ceris' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/about-me.png',
                'tabdisable' => 'tab-option-5 tab-option-3 tab-option-4 tab-option-6',
                'tabnames'  => array(
	                'tab-1' => esc_html__('General', 'ceris'),
	                'tab-2' => 'Spacing',
	            ),
				'options' => array(
                    'about_title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Put Title Text Here', 'ceris' ),
						'optionclass' => 'option-tab-1',
                        'field' => 'text',
						'default' => '',
					),
                    'about_img' => array(
						'title' => esc_html__('About Image URL - #1', 'ceris' ),
						'description' => esc_html__( 'Upload your image here', 'ceris' ),
						'optionclass' => 'option-tab-1',
                        'field' => 'image',
						'default' => '',
					),
                    'about_bio' => array(
						'title' => esc_html__('About Bio', 'ceris' ),
						'description' => esc_html__( 'Put the text here', 'ceris' ),
						'optionclass' => 'option-tab-1',
                        'field' => 'textarea',
						'default' => '',
					),
                    'about_signature' => array(
						'title' => esc_html__('About Signature', 'ceris' ),
						'description' => esc_html__( 'Upload your image here', 'ceris' ),
						'optionclass' => 'option-tab-1',
                        'field' => 'image',
						'default' => '',
					),
                    'about_link' => array(
						'title' => esc_html__('About destination link', 'ceris' ),
						'description' => esc_html__( 'Put the link here', 'ceris' ),
						'optionclass' => 'option-tab-1',
                        'field' => 'text',
						'default' => '',
					),
	                'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-2',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
				),
			),   
	        'grid_carousel' => array(
				'title' => esc_html__( 'Ceris Grid Carousel A', 'ceris' ),
	            'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ceris_2.png',
	            'tabdisable' => 'tab-option-6',
	            'tabnames'  => array(
	                'tab-1' => 'General',
	                'tab-2' => 'Query Option',
	                'tab-3' => 'Manually Pick Post',
	                'tab-4' => 'Post Type',
	                'tab-5' => 'Spacing',
	            ),
				'options' => array(
	                // Tab 1
	                'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
	                'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                
	                // Tab 2
	                'limit' => array(
						'title' => esc_html__('Number of Posts', 'ceris' ),
						'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 8
					),
	                'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'number',
						'default' => 0
					),
	                'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
	                    'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
	                        'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
	                'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
	                        'date'              => esc_html__( 'Latest Posts', 'ceris' ),
	                        'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
	                        'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
	                        'top_review'        => esc_html__( 'Best Review', 'ceris' ),
	                        'modified'          => esc_html__( 'Modified', 'ceris' ),
	                        'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
	                        'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
	                        'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
	                'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'category',
						'default' => '0',
					),
	                // Tab 3
	                'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                // Tab 4
	                'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
	                    'description' => esc_html__( 'All - Show All Post Type, This module does not show the post icons', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
	                        'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
	                        'gallery'    => esc_html__( 'Gallery', 'ceris' ),
	                        'review'     => esc_html__( 'Review', 'ceris' ),
						),
					),  
	                'post_icon' => array(
						'title' => esc_html__('Post Icon', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
						),
					),
					'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),  
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
	        ),
            'grid_carousel_b' => array(
				'title' => esc_html__( 'Ceris Grid Carousel B', 'ceris' ),
	            'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ceris_15.png',
	            'tabdisable' => 'tab-option-6',
	            'tabnames'  => array(
	                'tab-1' => 'General',
	                'tab-2' => 'Query Option',
	                'tab-3' => 'Manually Pick Post',
	                'tab-4' => 'Post Type',
	                'tab-5' => 'Spacing',
	            ),
				'options' => array(
	                // Tab 1
	                'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
	                'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                
	                // Tab 2
	                'limit' => array(
						'title' => esc_html__('Number of Posts', 'ceris' ),
						'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 8
					),
	                'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'number',
						'default' => 0
					),
	                'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
	                    'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
	                        'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
	                'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
	                        'date'              => esc_html__( 'Latest Posts', 'ceris' ),
	                        'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
	                        'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
	                        'top_review'        => esc_html__( 'Best Review', 'ceris' ),
	                        'modified'          => esc_html__( 'Modified', 'ceris' ),
	                        'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
	                        'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
	                        'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
	                'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'category',
						'default' => '0',
					),
	                // Tab 3
	                'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                // Tab 4
	                'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
	                    'description' => esc_html__( 'All - Show All Post Type, This module does not show the post icons', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
	                        'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
	                        'gallery'    => esc_html__( 'Gallery', 'ceris' ),
	                        'review'     => esc_html__( 'Review', 'ceris' ),
						),
					),  
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
	        ),
            'grid_carousel_c' => array(
				'title' => esc_html__( 'Ceris Grid Carousel C', 'ceris' ),
	            'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ceris_36.png',
	            'tabdisable' => 'tab-option-6',
	            'tabnames'  => array(
	                'tab-1' => 'General',
	                'tab-2' => 'Query Option',
	                'tab-3' => 'Manually Pick Post',
	                'tab-4' => 'Post Type',
	                'tab-5' => 'Spacing',
	            ),
				'options' => array(
	                // Tab 1
	                'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
	                'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                
	                // Tab 2
	                'limit' => array(
						'title' => esc_html__('Number of Posts', 'ceris' ),
						'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 8
					),
	                'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'number',
						'default' => 0
					),
	                'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
	                    'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
	                        'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
	                'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
	                        'date'              => esc_html__( 'Latest Posts', 'ceris' ),
	                        'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
	                        'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
	                        'top_review'        => esc_html__( 'Best Review', 'ceris' ),
	                        'modified'          => esc_html__( 'Modified', 'ceris' ),
	                        'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
	                        'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
	                        'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
	                'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'category',
						'default' => '0',
					),
	                // Tab 3
	                'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                // Tab 4
	                'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
	                    'description' => esc_html__( 'All - Show All Post Type, This module does not show the post icons', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
	                        'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
	                        'gallery'    => esc_html__( 'Gallery', 'ceris' ),
	                        'review'     => esc_html__( 'Review', 'ceris' ),
						),
					),      
                    'post_icon' => array(
                        'title' => esc_html__('Post Icon', 'ceris' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
                        'optionclass' => 'option-tab-4',
                        'field' => 'select',
                        'default' => 'disable',
                        'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
                            'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
                        ),
                    ), 
                    'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
	        ),
            'grid_carousel_d' => array(
				'title' => esc_html__( 'Ceris Grid Carousel D', 'ceris' ),
	            'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ceris_43.png',
	            'tabdisable' => 'tab-option-6',
	            'tabnames'  => array(
	                'tab-1' => 'General',
	                'tab-2' => 'Query Option',
	                'tab-3' => 'Manually Pick Post',
	                'tab-4' => 'Post Type',
	                'tab-5' => 'Spacing',
	            ),
				'options' => array(
	                // Tab 1
	                'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
                    /*'link_view_all' => array(
                        'title' => esc_html__('Link Views All', 'ceris' ),
                        'optionclass' => 'option-tab-1 ',
                        'default' => '',
                        'field' => 'text',
                    ),*/
	                'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                
	                // Tab 2
	                'limit' => array(
						'title' => esc_html__('Number of Posts', 'ceris' ),
						'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 8
					),
	                'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'number',
						'default' => 0
					),
	                'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
	                    'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
	                        'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
	                'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
	                        'date'              => esc_html__( 'Latest Posts', 'ceris' ),
	                        'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
	                        'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
	                        'top_review'        => esc_html__( 'Best Review', 'ceris' ),
	                        'modified'          => esc_html__( 'Modified', 'ceris' ),
	                        'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
	                        'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
	                        'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
	                'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'category',
						'default' => '0',
					),
	                // Tab 3
	                'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                // Tab 4
	                'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
	                    'description' => esc_html__( 'All - Show All Post Type, This module does not show the post icons', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
	                        'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
	                        'gallery'    => esc_html__( 'Gallery', 'ceris' ),
	                        'review'     => esc_html__( 'Review', 'ceris' ),
						),
					),      
                    'post_icon' => array(
                        'title' => esc_html__('Post Icon', 'ceris' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
                        'optionclass' => 'option-tab-4',
                        'field' => 'select',
                        'default' => 'disable',
                        'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
                            'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
                        ),
                    ), 
                    'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
	        ),
	        'grid_a' => array(
				'title' => esc_html__( 'Ceris Grid A', 'ceris' ),
	            'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ceris_3.png',
	            'tabdisable' => 'tab-option-6',
	            'tabnames'  => array(
	                'tab-1' => 'General',
	                'tab-2' => 'Query Option',
	                'tab-3' => 'Manually Pick Post',
	                'tab-4' => 'Post Type',
	                'tab-5' => 'Spacing',
	            ),
				'options' => array(
	                // Tab 1
	                'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
	                'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                
	                // Tab 2
	                'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'number',
						'default' => 0
					),
	                'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
	                    'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
	                        'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
	                'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
	                        'date'              => esc_html__( 'Latest Posts', 'ceris' ),
	                        'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
	                        'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
	                        'top_review'        => esc_html__( 'Best Review', 'ceris' ),
	                        'modified'          => esc_html__( 'Modified', 'ceris' ),
	                        'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
	                        'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
	                        'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
	                'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'category',
						'default' => '0',
					),
	                // Tab 3
	                'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                // Tab 4
	                'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
	                    'description' => esc_html__( 'All - Show All Post Type, This module does not show the post icons', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
	                        'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
	                        'gallery'    => esc_html__( 'Gallery', 'ceris' ),
	                        'review'     => esc_html__( 'Review', 'ceris' ),
						),
					),  
	                'post_icon' => array(
						'title' => esc_html__('Post Icon', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
						),
					),
					'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),  
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
	        ), 
	        'grid_b' => array(
				'title' => esc_html__( 'Ceris Grid B', 'ceris' ),
	            'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ceris_4.png',
	            'tabdisable' => 'tab-option-6',
	            'tabnames'  => array(
	                'tab-1' => 'General',
	                'tab-2' => 'Query Option',
	                'tab-3' => 'Manually Pick Post',
	                'tab-4' => 'Post Type',
	                'tab-5' => 'Spacing',
	            ),
				'options' => array(
	                // Tab 1
	                'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
                    'style_reverse' => array(
                        'title' => esc_html__('Style: Reverse', 'ceris' ),
                        'optionclass' => 'option-tab-1 ceris-heading-style',
                        'field' => 'select',
                        'default' => 'default',
                        'options' => array(
                            'default'        => esc_html__( 'Default', 'ceris' ),
                            'reverse'        => esc_html__( 'Reverse', 'ceris' ),
                        ),
                    ),
	                'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                
	                // Tab 2
	                'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'number',
						'default' => 0
					),
	                'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
	                    'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
	                        'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
	                'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
	                        'date'              => esc_html__( 'Latest Posts', 'ceris' ),
	                        'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
	                        'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
	                        'top_review'        => esc_html__( 'Best Review', 'ceris' ),
	                        'modified'          => esc_html__( 'Modified', 'ceris' ),
	                        'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
	                        'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
	                        'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
	                'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'category',
						'default' => '0',
					),
	                // Tab 3
	                'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                // Tab 4
	                'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
	                    'description' => esc_html__( 'All - Show All Post Type, This module does not show the post icons', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
	                        'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
	                        'gallery'    => esc_html__( 'Gallery', 'ceris' ),
	                        'review'     => esc_html__( 'Review', 'ceris' ),
						),
					),  
	                'post_icon' => array(
						'title' => esc_html__('Post Icon', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
						),
					),
					'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),  
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
	        ),
	        'grid_c' => array(
				'title' => esc_html__( 'Ceris Grid C', 'ceris' ),
	            'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ceris_7.png',
	            'tabdisable' => 'tab-option-6',
	            'tabnames'  => array(
	                'tab-1' => 'General',
	                'tab-2' => 'Query Option',
	                'tab-3' => 'Manually Pick Post',
	                'tab-4' => 'Post Type',
	                'tab-5' => 'Spacing',
	            ),
				'options' => array(
	                // Tab 1
	                'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
	                'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                
	                // Tab 2
	                'limit' => array(
						'title' => esc_html__('Number of Posts', 'ceris' ),
						'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 6
					),
	                'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'number',
						'default' => 0
					),
	                'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
	                    'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
	                        'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
	                'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
	                        'date'              => esc_html__( 'Latest Posts', 'ceris' ),
	                        'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
	                        'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
	                        'top_review'        => esc_html__( 'Best Review', 'ceris' ),
	                        'modified'          => esc_html__( 'Modified', 'ceris' ),
	                        'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
	                        'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
	                        'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
	                'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'category',
						'default' => '0',
					),
	                // Tab 3
	                'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                // Tab 4
	                'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
	                    'description' => esc_html__( 'All - Show All Post Type, This module does not show the post icons', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
	                        'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
	                        'gallery'    => esc_html__( 'Gallery', 'ceris' ),
	                        'review'     => esc_html__( 'Review', 'ceris' ),
						),
					),  
	                'post_icon' => array(
						'title' => esc_html__('Post Icon', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
						),
					), 
					'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					), 
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
	        ),
            'grid_d' => array(
				'title' => esc_html__( 'Ceris Grid D', 'ceris' ),
	            'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ceris_16.png',
	            'tabdisable' => 'tab-option-6',
	            'tabnames'  => array(
	                'tab-1' => 'General',
	                'tab-2' => 'Query Option',
	                'tab-3' => 'Manually Pick Post',
	                'tab-4' => 'Post Type',
	                'tab-5' => 'Spacing',
	            ),
				'options' => array(
	                // Tab 1
	                'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
	                'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                
	                // Tab 2
	                'limit' => array(
						'title' => esc_html__('Number of Posts', 'ceris' ),
						'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 6
					),
	                'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'number',
						'default' => 0
					),
	                'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
	                    'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
	                        'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
	                'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
	                        'date'              => esc_html__( 'Latest Posts', 'ceris' ),
	                        'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
	                        'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
	                        'top_review'        => esc_html__( 'Best Review', 'ceris' ),
	                        'modified'          => esc_html__( 'Modified', 'ceris' ),
	                        'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
	                        'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
	                        'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
	                'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'category',
						'default' => '0',
					),
	                // Tab 3
	                'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                // Tab 4
	                'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
	                    'description' => esc_html__( 'All - Show All Post Type, This module does not show the post icons', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
	                        'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
	                        'gallery'    => esc_html__( 'Gallery', 'ceris' ),
	                        'review'     => esc_html__( 'Review', 'ceris' ),
						),
					),  
	                'post_icon' => array(
						'title' => esc_html__('Post Icon', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
						),
					), 
					'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),  
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
	        ),
            'grid_e' => array(
				'title' => esc_html__( 'Ceris Grid E', 'ceris' ),
	            'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ceris_17.png',
	            'tabdisable' => 'tab-option-6',
	            'tabnames'  => array(
	                'tab-1' => 'General',
	                'tab-2' => 'Query Option',
	                'tab-3' => 'Manually Pick Post',
	                'tab-4' => 'Post Type',
	                'tab-5' => 'Spacing',
	            ),
				'options' => array(
	                // Tab 1
	                'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
	                'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                
	                // Tab 2
	                'limit' => array(
						'title' => esc_html__('Number of Posts', 'ceris' ),
						'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 6
					),
	                'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'number',
						'default' => 0
					),
	                'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
	                    'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
	                        'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
	                'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
	                        'date'              => esc_html__( 'Latest Posts', 'ceris' ),
	                        'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
	                        'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
	                        'top_review'        => esc_html__( 'Best Review', 'ceris' ),
	                        'modified'          => esc_html__( 'Modified', 'ceris' ),
	                        'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
	                        'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
	                        'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
	                'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'category',
						'default' => '0',
					),
	                // Tab 3
	                'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                // Tab 4
	                'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
	                    'description' => esc_html__( 'All - Show All Post Type, This module does not show the post icons', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
	                        'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
	                        'gallery'    => esc_html__( 'Gallery', 'ceris' ),
	                        'review'     => esc_html__( 'Review', 'ceris' ),
						),
					), 
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
	        ),
            'grid_f' => array(
				'title' => esc_html__( 'Ceris Grid F', 'ceris' ),
	            'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ceris_18.png',
	            'tabdisable' => 'tab-option-6',
	            'tabnames'  => array(
	                'tab-1' => 'General',
	                'tab-2' => 'Query Option',
	                'tab-3' => 'Manually Pick Post',
	                'tab-4' => 'Post Type',
	                'tab-5' => 'Spacing',
	            ),
				'options' => array(
	                // Tab 1
	                'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
	                'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                
	                // Tab 2
	                'limit' => array(
						'title' => esc_html__('Number of Posts', 'ceris' ),
						'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 6
					),
	                'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'number',
						'default' => 0
					),
	                'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
	                    'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
	                        'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
	                'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
	                        'date'              => esc_html__( 'Latest Posts', 'ceris' ),
	                        'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
	                        'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
	                        'top_review'        => esc_html__( 'Best Review', 'ceris' ),
	                        'modified'          => esc_html__( 'Modified', 'ceris' ),
	                        'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
	                        'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
	                        'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
	                'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'category',
						'default' => '0',
					),
	                // Tab 3
	                'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                // Tab 4
	                'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
	                    'description' => esc_html__( 'All - Show All Post Type, This module does not show the post icons', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
	                        'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
	                        'gallery'    => esc_html__( 'Gallery', 'ceris' ),
	                        'review'     => esc_html__( 'Review', 'ceris' ),
						),
					),  
	                'post_icon' => array(
						'title' => esc_html__('Post Icon', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
						),
					),  
					'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
	        ),
            'grid_g' => array(
				'title' => esc_html__( 'Ceris Grid G', 'ceris' ),
	            'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ceris_20.png',
	            'tabdisable' => 'tab-option-6',
	            'tabnames'  => array(
	                'tab-1' => 'General',
	                'tab-2' => 'Query Option',
	                'tab-3' => 'Manually Pick Post',
	                'tab-4' => 'Post Type',
	                'tab-5' => 'Spacing',
	            ),
				'options' => array(
	                // Tab 1
	                'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
	                'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                
	                // Tab 2
	                'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'number',
						'default' => 0
					),
	                'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
	                    'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
	                        'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
	                'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
	                        'date'              => esc_html__( 'Latest Posts', 'ceris' ),
	                        'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
	                        'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
	                        'top_review'        => esc_html__( 'Best Review', 'ceris' ),
	                        'modified'          => esc_html__( 'Modified', 'ceris' ),
	                        'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
	                        'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
	                        'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
	                'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'category',
						'default' => '0',
					),
	                // Tab 3
	                'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                // Tab 4
	                'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
	                    'description' => esc_html__( 'All - Show All Post Type, This module does not show the post icons', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
	                        'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
	                        'gallery'    => esc_html__( 'Gallery', 'ceris' ),
	                        'review'     => esc_html__( 'Review', 'ceris' ),
						),
					), 
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
	        ),
            'grid_h' => array(
				'title' => esc_html__( 'Ceris Grid H', 'ceris' ),
	            'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ceris_21.png',
	            'tabdisable' => 'tab-option-6',
	            'tabnames'  => array(
	                'tab-1' => 'General',
	                'tab-2' => 'Query Option',
	                'tab-3' => 'Manually Pick Post',
	                'tab-4' => 'Post Type',
	                'tab-5' => 'Spacing',
	            ),
				'options' => array(
	                // Tab 1
	                'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
                    'top_block' => array(
						'title' => esc_html__('Top Block', 'ceris'),
	                    'description' => esc_html__( 'Enable the top block of this module', 'ceris' ),
						'optionclass' => 'option-tab-1',
	                    'field' => 'select',
						'default' => 'yes',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
	                        'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
	                'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                
	                // Tab 2
	                'limit' => array(
						'title' => esc_html__('Number of Posts', 'ceris' ),
						'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 10
					),
	                'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'number',
						'default' => 0
					),
	                'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
	                    'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
	                        'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
	                'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
	                        'date'              => esc_html__( 'Latest Posts', 'ceris' ),
	                        'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
	                        'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
	                        'top_review'        => esc_html__( 'Best Review', 'ceris' ),
	                        'modified'          => esc_html__( 'Modified', 'ceris' ),
	                        'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
	                        'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
	                        'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
	                'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'category',
						'default' => '0',
					),
	                // Tab 3
	                'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                // Tab 4
	                'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
	                    'description' => esc_html__( 'All - Show All Post Type, This module does not show the post icons', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
	                        'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
	                        'gallery'    => esc_html__( 'Gallery', 'ceris' ),
	                        'review'     => esc_html__( 'Review', 'ceris' ),
						),
					),  
	                'post_icon' => array(
						'title' => esc_html__('Post Icon', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
						),
					), 
					'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					), 
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
	        ),
	        'module_video' => array(
				'title' => esc_html__( 'Ceris Grid I', 'ceris' ),
	            'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ceris_5.png',
	            'tabdisable' => 'tab-option-6',
	            'tabnames'  => array(
	                'tab-1' => 'General',
	                'tab-2' => 'Query Option',
	                'tab-3' => 'Manually Pick Post',
	                'tab-4' => 'Post Type',
	                'tab-5' => 'Spacing',
	            ),
				'options' => array(
	                // Tab 1
	                'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
	                'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                
	                // Tab 2
	                'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'number',
						'default' => 0
					),
	                'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
	                    'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
	                        'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
	                'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
	                        'date'              => esc_html__( 'Latest Posts', 'ceris' ),
	                        'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
	                        'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
	                        'top_review'        => esc_html__( 'Best Review', 'ceris' ),
	                        'modified'          => esc_html__( 'Modified', 'ceris' ),
	                        'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
	                        'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
	                        'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
	                'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'category',
						'default' => '0',
					),
	                // Tab 3
	                'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),  
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
	                    'description' => esc_html__( 'All - Show All Post Type, This module does not show the post icons', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
	                        'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
	                        'gallery'    => esc_html__( 'Gallery', 'ceris' ),
	                        'review'     => esc_html__( 'Review', 'ceris' ),
						),
					),
	                'post_icon' => array(
						'title' => esc_html__('Post Icon', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
						),
					),
					'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),  
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
	        ),
            'grid_j' => array(
				'title' => esc_html__( 'Ceris Grid J', 'ceris' ),
	            'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ceris_19.png',
	            'tabdisable' => 'tab-option-6',
	            'tabnames'  => array(
	                'tab-1' => 'General',
	                'tab-2' => 'Query Option',
	                'tab-3' => 'Manually Pick Post',
	                'tab-4' => 'Post Type',
	                'tab-5' => 'Spacing',
	            ),
				'options' => array(
	                // Tab 1
	                'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
                    'top_block' => array(
						'title' => esc_html__('Top Block', 'ceris'),
	                    'description' => esc_html__( 'Enable the top block of this module', 'ceris' ),
						'optionclass' => 'option-tab-1',
	                    'field' => 'select',
						'default' => 'yes',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
	                        'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
	                'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                
	                // Tab 2
	                'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'number',
						'default' => 0
					),
	                'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
	                    'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
	                        'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
	                'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
	                        'date'              => esc_html__( 'Latest Posts', 'ceris' ),
	                        'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
	                        'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
	                        'top_review'        => esc_html__( 'Best Review', 'ceris' ),
	                        'modified'          => esc_html__( 'Modified', 'ceris' ),
	                        'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
	                        'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
	                        'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
	                'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'category',
						'default' => '0',
					),
	                // Tab 3
	                'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                // Tab 4
	                'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
	                    'description' => esc_html__( 'All - Show All Post Type, This module does not show the post icons', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
	                        'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
	                        'gallery'    => esc_html__( 'Gallery', 'ceris' ),
	                        'review'     => esc_html__( 'Review', 'ceris' ),
						),
					),  
	                'post_icon' => array(
						'title' => esc_html__('Post Icon', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
						),
					), 
					'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					), 
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
	        ),
			'grid_k' => array(
				'title' => esc_html__( 'Ceris Grid K', 'ceris' ),
	            'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ceris_22.png',
	            'tabdisable' => 'tab-option-6',
	            'tabnames'  => array(
	                'tab-1' => 'General',
	                'tab-2' => 'Query Option',
	                'tab-3' => 'Manually Pick Post',
	                'tab-4' => 'Post Type',
	                'tab-5' => 'Spacing',
	            ),
				'options' => array(
	                // Tab 1
	                'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
	                'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                
	                // Tab 2
	                'limit' => array(
						'title' => esc_html__('Number of Posts', 'ceris' ),
						'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 10
					),
	                'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'number',
						'default' => 0
					),
	                'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
	                    'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
	                        'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
	                'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
	                        'date'              => esc_html__( 'Latest Posts', 'ceris' ),
	                        'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
	                        'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
	                        'top_review'        => esc_html__( 'Best Review', 'ceris' ),
	                        'modified'          => esc_html__( 'Modified', 'ceris' ),
	                        'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
	                        'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
	                        'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
	                'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'category',
						'default' => '0',
					),
	                // Tab 3
	                'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                // Tab 4
	                'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
	                    'description' => esc_html__( 'All - Show All Post Type, This module does not show the post icons', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
	                        'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
	                        'gallery'    => esc_html__( 'Gallery', 'ceris' ),
	                        'review'     => esc_html__( 'Review', 'ceris' ),
						),
					),   
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
	        ),
			'grid_l' => array(
				'title' => esc_html__( 'Ceris Grid L', 'ceris' ),
	            'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ceris_23.png',
	            'tabdisable' => 'tab-option-6',
	            'tabnames'  => array(
	                'tab-1' => 'General',
	                'tab-2' => 'Query Option',
	                'tab-3' => 'Manually Pick Post',
	                'tab-4' => 'Post Type',
	                'tab-5' => 'Spacing',
	            ),
				'options' => array(
	                // Tab 1
	                'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
	                'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                
	                // Tab 2
	                'limit' => array(
						'title' => esc_html__('Number of Posts', 'ceris' ),
						'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 10
					),
	                'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'number',
						'default' => 0
					),
	                'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
	                    'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
	                        'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
	                'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
	                        'date'              => esc_html__( 'Latest Posts', 'ceris' ),
	                        'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
	                        'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
	                        'top_review'        => esc_html__( 'Best Review', 'ceris' ),
	                        'modified'          => esc_html__( 'Modified', 'ceris' ),
	                        'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
	                        'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
	                        'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
	                'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'category',
						'default' => '0',
					),
	                // Tab 3
	                'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                // Tab 4
	                'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
	                    'description' => esc_html__( 'All - Show All Post Type, This module does not show the post icons', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
	                        'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
	                        'gallery'    => esc_html__( 'Gallery', 'ceris' ),
	                        'review'     => esc_html__( 'Review', 'ceris' ),
						),
					),  
	                'post_icon' => array(
						'title' => esc_html__('Post Icon', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
						),
					),  
					'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
	        ),
			'grid_m' => array(
				'title' => esc_html__( 'Ceris Grid M', 'ceris' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ce_19.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Spacing',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
					'small_title' => array(
						'title' => esc_html__('Small Title', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
					'background_style' => array(
						'title' => esc_html__('Background Style', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 'background_black',
						'options' => array(
                  			'background_black'           => esc_html__( 'Background Black', 'ceris' ),
                  			'background_gray'           => esc_html__( 'Background Gray', 'ceris' ),
                            'background_white' => esc_html__( 'Background White', 'ceris' ),
						),
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'ceris' ),
						'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
						'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 5,
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
                            'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'ceris' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
                            'top_review'        => esc_html__( 'Best Review', 'ceris' ),
                            'modified'          => esc_html__( 'Modified', 'ceris' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
                        'description' => esc_html__( 'All - Show All Post Type, This module does not show the post icons', 'ceris' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
                            'gallery'    => esc_html__( 'Gallery', 'ceris' ),
                            'review'     => esc_html__( 'Review', 'ceris' ),
						),
					),
					'post_icon' => array(
						'title' => esc_html__('Post Icon', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
						),
					),  
					'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
            ),
			'grid_n' => array(
				'title' => esc_html__( 'Ceris Grid N', 'ceris' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ce_37.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Spacing',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
					'thumb_size' => array(
						'title' => esc_html__('Thumbnail size', 'ceris'),
                        'description' => esc_html__( 'select between small or medium', 'ceris' ),
						'optionclass' => 'option-tab-1',
                        'field' => 'select',
						'default' => 'small',
						'options' => array(
							'small' => esc_html__( 'Small', 'ceris' ),
                            'medium' => esc_html__( 'Medium', 'ceris' ),
						),
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'ceris' ),
						'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
						'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 3,
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
                            'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'ceris' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
                            'top_review'        => esc_html__( 'Best Review', 'ceris' ),
                            'modified'          => esc_html__( 'Modified', 'ceris' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
                        'description' => esc_html__( 'All - Show All Post Type, This module does not show the post icons', 'ceris' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
                            'gallery'    => esc_html__( 'Gallery', 'ceris' ),
                            'review'     => esc_html__( 'Review', 'ceris' ),
						),
					),
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
            ),
            'grid_o' => array(
				'title' => esc_html__( 'Ceris Grid O', 'ceris' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/8.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Spacing',  
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),     
                    // Tab 2
                    'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
                            'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'ceris' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
                            'top_review'        => esc_html__( 'Best Review', 'ceris' ),
                            'modified'          => esc_html__( 'Modified', 'ceris' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma - Must Pick The Gallery Post', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'ceris' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
                            'gallery'    => esc_html__( 'Gallery', 'ceris' ),
                            'review'     => esc_html__( 'Review', 'ceris' ),
						),
					), 
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'ceris' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
						),
					),
					'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),  
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
            ),
			'grid_p' => array(
				'title' => esc_html__( 'Ceris Grid P', 'ceris' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/10.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Spacing',  
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),     
                    // Tab 2
                    'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
                            'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'ceris' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
                            'top_review'        => esc_html__( 'Best Review', 'ceris' ),
                            'modified'          => esc_html__( 'Modified', 'ceris' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma - Must Pick The Gallery Post', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'ceris' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
                            'gallery'    => esc_html__( 'Gallery', 'ceris' ),
                            'review'     => esc_html__( 'Review', 'ceris' ),
						),
					), 
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'ceris' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
						),
					),
					'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),  
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
            ),
			'grid_q' => array(
				'title' => esc_html__( 'Ceris Grid Q', 'ceris' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/24.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Spacing',  
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),     
                    // Tab 2
                    'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
                            'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'ceris' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
                            'top_review'        => esc_html__( 'Best Review', 'ceris' ),
                            'modified'          => esc_html__( 'Modified', 'ceris' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma - Must Pick The Gallery Post', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'ceris' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
                            'gallery'    => esc_html__( 'Gallery', 'ceris' ),
                            'review'     => esc_html__( 'Review', 'ceris' ),
						),
					), 
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'ceris' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
						),
					),
					'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),  
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
            ),
			'grid_r' => array(
				'title' => esc_html__( 'Ceris Grid R', 'ceris' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/12.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Spacing',  
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),     
                    // Tab 2
                    'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
                            'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'ceris' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
                            'top_review'        => esc_html__( 'Best Review', 'ceris' ),
                            'modified'          => esc_html__( 'Modified', 'ceris' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma - Must Pick The Gallery Post', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'ceris' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
                            'gallery'    => esc_html__( 'Gallery', 'ceris' ),
                            'review'     => esc_html__( 'Review', 'ceris' ),
						),
					), 
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'ceris' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
						),
					),
					'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),  
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
            ),
            'grid_s' => array(
				'title' => esc_html__( 'Ceris Grid S', 'ceris' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/22.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Spacing',  
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),     
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'ceris' ),
						'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 4
					),     
                    // Tab 2
                    'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
                            'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'ceris' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
                            'top_review'        => esc_html__( 'Best Review', 'ceris' ),
                            'modified'          => esc_html__( 'Modified', 'ceris' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma - Must Pick The Gallery Post', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'ceris' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
                            'gallery'    => esc_html__( 'Gallery', 'ceris' ),
                            'review'     => esc_html__( 'Review', 'ceris' ),
						),
					), 
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'ceris' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
						),
					),
					'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),  
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
            ),
			'grid_t' => array(
				'title' => esc_html__( 'Ceris Grid T', 'ceris' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/50.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Spacing',  
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),     
                    // Tab 2
                    'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
                            'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'ceris' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
                            'top_review'        => esc_html__( 'Best Review', 'ceris' ),
                            'modified'          => esc_html__( 'Modified', 'ceris' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must pick the Review Posts', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'ceris' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
                            'gallery'    => esc_html__( 'Gallery', 'ceris' ),
                            'review'     => esc_html__( 'Review', 'ceris' ),
						),
					), 
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'ceris' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
						),
					),
					'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),  
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
            ),
            'grid_u' => array(
				'title' => esc_html__( 'Ceris Grid U', 'ceris' ),
	            'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ceris_grid_u.png',
	            'tabdisable' => 'tab-option-6',
	            'tabnames'  => array(
	                'tab-1' => 'General',
	                'tab-2' => 'Query Option',
	                'tab-3' => 'Manually Pick Post',
	                'tab-4' => 'Post Type',
	                'tab-5' => 'Spacing',
	            ),
				'options' => array(
	                // Tab 1
	                'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
	                'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                
	                // Tab 2
	                'limit' => array(
						'title' => esc_html__('Number of Posts', 'ceris' ),
						'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 6
					),
	                'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'number',
						'default' => 0
					),
	                'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
	                    'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
	                        'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
	                'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
	                        'date'              => esc_html__( 'Latest Posts', 'ceris' ),
	                        'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
	                        'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
	                        'top_review'        => esc_html__( 'Best Review', 'ceris' ),
	                        'modified'          => esc_html__( 'Modified', 'ceris' ),
	                        'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
	                        'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
	                        'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
	                'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'category',
						'default' => '0',
					),
	                // Tab 3
	                'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                // Tab 4
	                'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
	                    'description' => esc_html__( 'All - Show All Post Type, This module does not show the post icons', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
	                        'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
	                        'gallery'    => esc_html__( 'Gallery', 'ceris' ),
	                        'review'     => esc_html__( 'Review', 'ceris' ),
						),
					),  
	                'post_icon' => array(
						'title' => esc_html__('Post Icon', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
						),
					), 
					'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),  
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
	        ),
			'grid_v' => array(
				'title' => esc_html__( 'Ceris Grid V', 'ceris' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/update_ceris_11.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Spacing',  
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),     
                    // Tab 2
                    'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
                            'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'ceris' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
                            'top_review'        => esc_html__( 'Best Review', 'ceris' ),
                            'modified'          => esc_html__( 'Modified', 'ceris' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must pick the Review Posts', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'ceris' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
                            'gallery'    => esc_html__( 'Gallery', 'ceris' ),
                            'review'     => esc_html__( 'Review', 'ceris' ),
						),
					), 
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'ceris' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
						),
					),
					'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),  
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
            ),
			'grid_w' => array(
				'title' => esc_html__( 'Ceris Grid W', 'ceris' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/update_ceris_18.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Spacing',  
                ),
				'options' => array(
                   // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'ceris' ),
						'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
						'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 6,
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
                            'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'ceris' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
                            'top_review'        => esc_html__( 'Best Review', 'ceris' ),
                            'modified'          => esc_html__( 'Modified', 'ceris' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'ceris' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
                            'gallery'    => esc_html__( 'Gallery', 'ceris' ),
                            'review'     => esc_html__( 'Review', 'ceris' ),
						),
					),
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
            ),
            'grid_x' => array(
				'title' => esc_html__( 'Ceris Grid X', 'ceris' ),
	            'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ceris_grid_x.png',
	            'tabdisable' => 'tab-option-6',
	            'tabnames'  => array(
	                'tab-1' => 'General',
	                'tab-2' => 'Query Option',
	                'tab-3' => 'Manually Pick Post',
	                'tab-4' => 'Post Type',
	                'tab-5' => 'Spacing',
	            ),
				'options' => array(
	                // Tab 1
	                'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
	                'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                
	                // Tab 2
	                'limit' => array(
						'title' => esc_html__('Number of Posts', 'ceris' ),
						'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 6
					),
	                'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'number',
						'default' => 0
					),
	                'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
	                    'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
	                        'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
	                'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
	                        'date'              => esc_html__( 'Latest Posts', 'ceris' ),
	                        'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
	                        'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
	                        'top_review'        => esc_html__( 'Best Review', 'ceris' ),
	                        'modified'          => esc_html__( 'Modified', 'ceris' ),
	                        'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
	                        'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
	                        'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
	                'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'category',
						'default' => '0',
					),
	                // Tab 3
	                'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                // Tab 4
	                'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
	                    'description' => esc_html__( 'All - Show All Post Type, This module does not show the post icons', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
	                        'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
	                        'gallery'    => esc_html__( 'Gallery', 'ceris' ),
	                        'review'     => esc_html__( 'Review', 'ceris' ),
						),
					),  
	                'post_icon' => array(
						'title' => esc_html__('Post Icon', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
						),
					), 
					'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),  
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
	        ),
            'grid_z' => array(
				'title' => esc_html__( 'Ceris Grid Z', 'ceris' ),
	            'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ceris_grid_z.png',
	            'tabdisable' => 'tab-option-6',
	            'tabnames'  => array(
	                'tab-1' => 'General',
	                'tab-2' => 'Query Option',
	                'tab-3' => 'Manually Pick Post',
	                'tab-4' => 'Post Type',
	                'tab-5' => 'Spacing',
	            ),
				'options' => array(
	                // Tab 1
	                'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
	                'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                
	                // Tab 2
	                'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'number',
						'default' => 0
					),
	                'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
	                    'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
	                        'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
	                'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
	                        'date'              => esc_html__( 'Latest Posts', 'ceris' ),
	                        'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
	                        'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
	                        'top_review'        => esc_html__( 'Best Review', 'ceris' ),
	                        'modified'          => esc_html__( 'Modified', 'ceris' ),
	                        'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
	                        'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
	                        'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
	                'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'category',
						'default' => '0',
					),
	                // Tab 3
	                'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                // Tab 4
	                'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
	                    'description' => esc_html__( 'All - Show All Post Type, This module does not show the post icons', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
	                        'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
	                        'gallery'    => esc_html__( 'Gallery', 'ceris' ),
	                        'review'     => esc_html__( 'Review', 'ceris' ),
						),
					),    
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
	        ),
            'posts_block_grid_a_no_sidebar' => array(
    			'title' => esc_html__( 'Post Block Grid A', 'ceris' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ce_35.png',
                'tabdisable' => '',
                'tabnames'  => array(
                    'tab-1' => 'Column 1',
                    'tab-2' => 'Column 2',
                    'tab-3' => 'Column 3',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Custom Class',
                    'tab-6' => 'Spacing',
                ),
    			'options' => array(
                    // Tab 1
                    'title_1' => array(
    					'title' => esc_html__('Title', 'ceris' ),
    					'description' => esc_html__( 'Insert the title text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
    					'field' => 'text',
    					'default' => '',
    				),
                    'heading_color_1' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
                    'limit_1' => array(
    					'title' => esc_html__('Number of Posts', 'ceris' ),
    					'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
                        'optionclass' => 'option-tab-1',
    					'field' => 'number',
    					'default' => 6
    				),
                    'offset_1' => array(
    					'title' => esc_html__('Offset', 'ceris' ),
    					'description' => esc_html__( 'Enter the offset number', 'ceris' ),
    					'optionclass' => 'option-tab-1',
                        'field' => 'number',
    					'default' => 0
    				),
                    'feature_1' => array(
    					'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
    					'optionclass' => 'option-tab-1',
                        'field' => 'select',
    					'default' => 'no',
    					'options' => array(
    						'no' => esc_html__( 'No', 'ceris' ),
                            'yes' => esc_html__( 'Yes', 'ceris' ),
    					),
    				),
                    'orderby_1' => array(
						'title' => esc_html__('Order By', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'ceris' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
                            'top_review'        => esc_html__( 'Best Review', 'ceris' ),
                            'modified'          => esc_html__( 'Modified', 'ceris' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
                    'tags_1' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
    				'category_1' => array(
    					'title' => esc_html__('Category', 'ceris' ),
    					'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
    					'optionclass' => 'option-tab-1',
                        'field' => 'category',
    					'default' => '0',
    				),
    				'editor_pick_1' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude_1' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'viewmore_1' => array(
						'title' => esc_html__('Enable View More Button', 'ceris' ),
                        'description' => esc_html__('Should be displayed at the bottom of column', 'ceris'),
                        'optionclass' => 'option-tab-1 ceris-view-more-button',
						'field' => 'select',
						'default' => 'no',
						'options' => array(
                            'no'  => esc_html__( 'No', 'ceris' ),
							'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
                    'view_more_link_1' => array(
						'title' => esc_html__('View More Button Link', 'ceris' ),
						'description' => esc_html__( 'Insert the link for the View More button', 'ceris' ),
                        'optionclass' => 'option-tab-1 ceris-view-more',
						'field' => 'text',
						'default' => '',
					),
                    'view_more_text_1' => array(
						'title' => esc_html__('View More Button Text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ceris-view-more',
						'field' => 'text',
						'default' => '',
					),
                    'view_more_target_1' => array(
						'title' => esc_html__('Target', 'ceris'),
						'optionclass' => 'option-tab-1 ceris-view-more',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'ceris' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'ceris' ),
						),
					),
                    // Tab 2
                    'title_2' => array(
    					'title' => esc_html__('Title', 'ceris' ),
    					'description' => esc_html__( 'Insert the title text', 'ceris' ),
                        'optionclass' => 'option-tab-2',
    					'field' => 'text',
    					'default' => '',
    				),
                    'heading_color_2' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-2',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
                    'limit_2' => array(
    					'title' => esc_html__('Number of Posts', 'ceris' ),
    					'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
                        'optionclass' => 'option-tab-2',
    					'field' => 'number',
    					'default' => 6
    				),
                    'offset_2' => array(
    					'title' => esc_html__('Offset', 'ceris' ),
    					'description' => esc_html__( 'Enter the offset number', 'ceris' ),
    					'optionclass' => 'option-tab-2',
                        'field' => 'number',
    					'default' => 0
    				),
                    'feature_2' => array(
    					'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
    					'optionclass' => 'option-tab-2',
                        'field' => 'select',
    					'default' => 'no',
    					'options' => array(
    						'no' => esc_html__( 'No', 'ceris' ),
                            'yes' => esc_html__( 'Yes', 'ceris' ),
    					),
    				),
                    'orderby_2' => array(
						'title' => esc_html__('Order By', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'ceris' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
                            'top_review'        => esc_html__( 'Best Review', 'ceris' ),
                            'modified'          => esc_html__( 'Modified', 'ceris' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
                    'tags_2' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
    				'category_2' => array(
    					'title' => esc_html__('Category', 'ceris' ),
    					'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
    					'optionclass' => 'option-tab-2',
                        'field' => 'category',
    					'default' => '0',
    				),
    				'editor_pick_2' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude_2' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
                    'viewmore_2' => array(
						'title' => esc_html__('Enable View More Button', 'ceris' ),
                        'description' => esc_html__('Should be displayed at the bottom of column', 'ceris'),
                        'optionclass' => 'option-tab-2 ceris-view-more-button',
						'field' => 'select',
						'default' => 'no',
						'options' => array(
                            'no'  => esc_html__( 'No', 'ceris' ),
							'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
                    'view_more_link_2' => array(
						'title' => esc_html__('View More Button Link', 'ceris' ),
						'description' => esc_html__( 'Insert the link for the View More button', 'ceris' ),
                        'optionclass' => 'option-tab-2 ceris-view-more',
						'field' => 'text',
						'default' => '',
					),
                    'view_more_text_2' => array(
						'title' => esc_html__('View More Button Text', 'ceris' ),
                        'optionclass' => 'option-tab-2 ceris-view-more',
						'field' => 'text',
						'default' => '',
					),
                    'view_more_target_2' => array(
						'title' => esc_html__('Target', 'ceris'),
						'optionclass' => 'option-tab-2 ceris-view-more',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'ceris' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'ceris' ),
						),
					),
                    // Tab 3
                    'title_3' => array(
    					'title' => esc_html__('Title', 'ceris' ),
    					'description' => esc_html__( 'Insert the title text', 'ceris' ),
                        'optionclass' => 'option-tab-3',
    					'field' => 'text',
    					'default' => '',
    				),
                    'heading_color_3' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-3',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
                    'limit_3' => array(
    					'title' => esc_html__('Number of Posts', 'ceris' ),
    					'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
                        'optionclass' => 'option-tab-3',
    					'field' => 'number',
    					'default' => 6
    				),
                    'offset_3' => array(
    					'title' => esc_html__('Offset', 'ceris' ),
    					'description' => esc_html__( 'Enter the offset number', 'ceris' ),
    					'optionclass' => 'option-tab-3',
                        'field' => 'number',
    					'default' => 0
    				),
                    'feature_3' => array(
    					'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
    					'optionclass' => 'option-tab-3',
                        'field' => 'select',
    					'default' => 'no',
    					'options' => array(
    						'no' => esc_html__( 'No', 'ceris' ),
                            'yes' => esc_html__( 'Yes', 'ceris' ),
    					),
    				),
                    'orderby_3' => array(
						'title' => esc_html__('Order By', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'ceris' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
                            'top_review'        => esc_html__( 'Best Review', 'ceris' ),
                            'modified'          => esc_html__( 'Modified', 'ceris' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
                    'tags_3' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
    				'category_3' => array(
    					'title' => esc_html__('Category', 'ceris' ),
    					'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
    					'optionclass' => 'option-tab-3',
                        'field' => 'category',
    					'default' => '0',
    				),
    				'editor_pick_3' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude_3' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'viewmore_3' => array(
						'title' => esc_html__('Enable View More Button', 'ceris' ),
                        'description' => esc_html__('Should be displayed at the bottom of column', 'ceris'),
                        'optionclass' => 'option-tab-3 ceris-view-more-button',
						'field' => 'select',
						'default' => 'no',
						'options' => array(
                            'no'  => esc_html__( 'No', 'ceris' ),
							'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
                    'view_more_link_3' => array(
						'title' => esc_html__('View More Button Link', 'ceris' ),
						'description' => esc_html__( 'Insert the link for the View More button', 'ceris' ),
                        'optionclass' => 'option-tab-3 ceris-view-more',
						'field' => 'text',
						'default' => '',
					),
                    'view_more_text_3' => array(
						'title' => esc_html__('View More Button Text', 'ceris' ),
                        'optionclass' => 'option-tab-3 ceris-view-more',
						'field' => 'text',
						'default' => '',
					),
                    'view_more_target_3' => array(
						'title' => esc_html__('Target', 'ceris'),
						'optionclass' => 'option-tab-3 ceris-view-more',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'ceris' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'ceris' ),
						),
					),
	                // Tab 4
	                'post_source' => array(
	                    'title' => esc_html__('Show only Post Type', 'ceris' ),
	                    'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
	                    'field' => 'select',
	                    'default' => 'all',
	                    'options' => array(
	                        'all'        => esc_html__( 'All', 'ceris' ),
	                        'video'      => esc_html__( 'Video', 'ceris' ),
	                        'gallery'    => esc_html__( 'Gallery', 'ceris' ),
	                        'review'     => esc_html__( 'Review', 'ceris' ),
	                    ),
	                ),
                    //Tab 5
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'text',
						'default' => '',
					),
					//tab 6
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-6',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-6',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-6',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
    			),
            ),
            'posts_block_grid_b_no_sidebar' => array(
    			'title' => esc_html__( 'Post Block Grid B', 'ceris' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/main-9.png',
                'tabdisable' => '',
                'tabnames'  => array(
                    'tab-1' => 'Column 1',
                    'tab-2' => 'Column 2',
                    'tab-3' => 'Column 3',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Custom Class',
                    'tab-6' => 'Spacing',
                ),
    			'options' => array(
                    // Tab 1
                    'title_1' => array(
    					'title' => esc_html__('Title', 'ceris' ),
    					'description' => esc_html__( 'Insert the title text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
    					'field' => 'text',
    					'default' => '',
    				),
                    'heading_color_1' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
                    'limit_1' => array(
    					'title' => esc_html__('Number of Posts', 'ceris' ),
    					'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
                        'optionclass' => 'option-tab-1',
    					'field' => 'number',
    					'default' => 6
    				),
                    'offset_1' => array(
    					'title' => esc_html__('Offset', 'ceris' ),
    					'description' => esc_html__( 'Enter the offset number', 'ceris' ),
    					'optionclass' => 'option-tab-1',
                        'field' => 'number',
    					'default' => 0
    				),
                    'feature_1' => array(
    					'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
    					'optionclass' => 'option-tab-1',
                        'field' => 'select',
    					'default' => 'no',
    					'options' => array(
    						'no' => esc_html__( 'No', 'ceris' ),
                            'yes' => esc_html__( 'Yes', 'ceris' ),
    					),
    				),
                    'orderby_1' => array(
						'title' => esc_html__('Order By', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'ceris' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
                            'top_review'        => esc_html__( 'Best Review', 'ceris' ),
                            'modified'          => esc_html__( 'Modified', 'ceris' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
                    'tags_1' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
    				'category_1' => array(
    					'title' => esc_html__('Category', 'ceris' ),
    					'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
    					'optionclass' => 'option-tab-1',
                        'field' => 'category',
    					'default' => '0',
    				),
    				'editor_pick_1' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude_1' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'viewmore_1' => array(
						'title' => esc_html__('Enable View More Button', 'ceris' ),
                        'description' => esc_html__('Should be displayed at the bottom of column', 'ceris'),
                        'optionclass' => 'option-tab-1 ceris-view-more-button',
						'field' => 'select',
						'default' => 'no',
						'options' => array(
                            'no'  => esc_html__( 'No', 'ceris' ),
							'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
                    'view_more_link_1' => array(
						'title' => esc_html__('View More Button Link', 'ceris' ),
						'description' => esc_html__( 'Insert the link for the View More button', 'ceris' ),
                        'optionclass' => 'option-tab-1 ceris-view-more',
						'field' => 'text',
						'default' => '',
					),
                    'view_more_text_1' => array(
						'title' => esc_html__('View More Button Text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ceris-view-more',
						'field' => 'text',
						'default' => '',
					),
                    'view_more_target_1' => array(
						'title' => esc_html__('Target', 'ceris'),
						'optionclass' => 'option-tab-1 ceris-view-more',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'ceris' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'ceris' ),
						),
					),
                    // Tab 2
                    'title_2' => array(
    					'title' => esc_html__('Title', 'ceris' ),
    					'description' => esc_html__( 'Insert the title text', 'ceris' ),
                        'optionclass' => 'option-tab-2',
    					'field' => 'text',
    					'default' => '',
    				),
                    'heading_color_2' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-2',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
                    'limit_2' => array(
    					'title' => esc_html__('Number of Posts', 'ceris' ),
    					'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
                        'optionclass' => 'option-tab-2',
    					'field' => 'number',
    					'default' => 6
    				),
                    'offset_2' => array(
    					'title' => esc_html__('Offset', 'ceris' ),
    					'description' => esc_html__( 'Enter the offset number', 'ceris' ),
    					'optionclass' => 'option-tab-2',
                        'field' => 'number',
    					'default' => 0
    				),
                    'feature_2' => array(
    					'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
    					'optionclass' => 'option-tab-2',
                        'field' => 'select',
    					'default' => 'no',
    					'options' => array(
    						'no' => esc_html__( 'No', 'ceris' ),
                            'yes' => esc_html__( 'Yes', 'ceris' ),
    					),
    				),
                    'orderby_2' => array(
						'title' => esc_html__('Order By', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'ceris' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
                            'top_review'        => esc_html__( 'Best Review', 'ceris' ),
                            'modified'          => esc_html__( 'Modified', 'ceris' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
                    'tags_2' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
    				'category_2' => array(
    					'title' => esc_html__('Category', 'ceris' ),
    					'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
    					'optionclass' => 'option-tab-2',
                        'field' => 'category',
    					'default' => '0',
    				),
    				'editor_pick_2' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude_2' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
                    'viewmore_2' => array(
						'title' => esc_html__('Enable View More Button', 'ceris' ),
                        'description' => esc_html__('Should be displayed at the bottom of column', 'ceris'),
                        'optionclass' => 'option-tab-2 ceris-view-more-button',
						'field' => 'select',
						'default' => 'no',
						'options' => array(
                            'no'  => esc_html__( 'No', 'ceris' ),
							'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
                    'view_more_link_2' => array(
						'title' => esc_html__('View More Button Link', 'ceris' ),
						'description' => esc_html__( 'Insert the link for the View More button', 'ceris' ),
                        'optionclass' => 'option-tab-2 ceris-view-more',
						'field' => 'text',
						'default' => '',
					),
                    'view_more_text_2' => array(
						'title' => esc_html__('View More Button Text', 'ceris' ),
                        'optionclass' => 'option-tab-2 ceris-view-more',
						'field' => 'text',
						'default' => '',
					),
                    'view_more_target_2' => array(
						'title' => esc_html__('Target', 'ceris'),
						'optionclass' => 'option-tab-2 ceris-view-more',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'ceris' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'ceris' ),
						),
					),
                    // Tab 3
                    'title_3' => array(
    					'title' => esc_html__('Title', 'ceris' ),
    					'description' => esc_html__( 'Insert the title text', 'ceris' ),
                        'optionclass' => 'option-tab-3',
    					'field' => 'text',
    					'default' => '',
    				),
                    'heading_color_3' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-3',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
                    'limit_3' => array(
    					'title' => esc_html__('Number of Posts', 'ceris' ),
    					'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
                        'optionclass' => 'option-tab-3',
    					'field' => 'number',
    					'default' => 6
    				),
                    'offset_3' => array(
    					'title' => esc_html__('Offset', 'ceris' ),
    					'description' => esc_html__( 'Enter the offset number', 'ceris' ),
    					'optionclass' => 'option-tab-3',
                        'field' => 'number',
    					'default' => 0
    				),
                    'feature_3' => array(
    					'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
    					'optionclass' => 'option-tab-3',
                        'field' => 'select',
    					'default' => 'no',
    					'options' => array(
    						'no' => esc_html__( 'No', 'ceris' ),
                            'yes' => esc_html__( 'Yes', 'ceris' ),
    					),
    				),
                    'orderby_3' => array(
						'title' => esc_html__('Order By', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'ceris' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
                            'top_review'        => esc_html__( 'Best Review', 'ceris' ),
                            'modified'          => esc_html__( 'Modified', 'ceris' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
                    'tags_3' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
    				'category_3' => array(
    					'title' => esc_html__('Category', 'ceris' ),
    					'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
    					'optionclass' => 'option-tab-3',
                        'field' => 'category',
    					'default' => '0',
    				),
    				'editor_pick_3' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude_3' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'viewmore_3' => array(
						'title' => esc_html__('Enable View More Button', 'ceris' ),
                        'description' => esc_html__('Should be displayed at the bottom of column', 'ceris'),
                        'optionclass' => 'option-tab-3 ceris-view-more-button',
						'field' => 'select',
						'default' => 'no',
						'options' => array(
                            'no'  => esc_html__( 'No', 'ceris' ),
							'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
                    'view_more_link_3' => array(
						'title' => esc_html__('View More Button Link', 'ceris' ),
						'description' => esc_html__( 'Insert the link for the View More button', 'ceris' ),
                        'optionclass' => 'option-tab-3 ceris-view-more',
						'field' => 'text',
						'default' => '',
					),
                    'view_more_text_3' => array(
						'title' => esc_html__('View More Button Text', 'ceris' ),
                        'optionclass' => 'option-tab-3 ceris-view-more',
						'field' => 'text',
						'default' => '',
					),
                    'view_more_target_3' => array(
						'title' => esc_html__('Target', 'ceris'),
						'optionclass' => 'option-tab-3 ceris-view-more',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'ceris' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'ceris' ),
						),
					),

	                // Tab 4
	                'post_source' => array(
	                    'title' => esc_html__('Show only Post Type', 'ceris' ),
	                    'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
	                    'field' => 'select',
	                    'default' => 'all',
	                    'options' => array(
	                        'all'        => esc_html__( 'All', 'ceris' ),
	                        'video'      => esc_html__( 'Video', 'ceris' ),
	                        'gallery'    => esc_html__( 'Gallery', 'ceris' ),
	                        'review'     => esc_html__( 'Review', 'ceris' ),
	                    ),
	                ),    
	                'post_icon' => array(
	                    'title' => esc_html__('Post Icon', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
	                    'field' => 'select',
	                    'default' => 'disable',
	                    'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
	                        'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
	                    ),
	                ),
	                'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),
                    //Tab 5
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'text',
						'default' => '',
					),
					//tab 6
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-6',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-6',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-6',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
    			),
            ),
            'posts_block_grid_c_no_sidebar' => array(
				'title' => esc_html__( 'Post Block Grid C', 'ceris' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/15.png',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Custom Class',
                    'tab-6' => 'Spacing',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
                            'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'ceris' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
                            'top_review'        => esc_html__( 'Best Review', 'ceris' ),
                            'modified'          => esc_html__( 'Modified', 'ceris' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must Pick the Video Posts', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
	                'post_source' => array(
	                    'title' => esc_html__('Show only Post Type', 'ceris' ),
	                    'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
	                    'field' => 'select',
	                    'default' => 'all',
	                    'options' => array(
	                        'all'        => esc_html__( 'All', 'ceris' ),
	                        'video'      => esc_html__( 'Video', 'ceris' ),
	                        'gallery'    => esc_html__( 'Gallery', 'ceris' ),
	                        'review'     => esc_html__( 'Review', 'ceris' ),
	                    ),
	                ),    
	                'post_icon' => array(
	                    'title' => esc_html__('Post Icon', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
	                    'field' => 'select',
	                    'default' => 'disable',
	                    'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
	                        'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
	                    ),
	                ),
	                'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),
                    //Tab 5
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'text',
						'default' => '',
					),
					//tab 6
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-6',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-6',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-6',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
            ),
            'posts_block_grid_d_no_sidebar' => array(
				'title' => esc_html__( 'Post Block Grid D', 'ceris' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ceris_100.png',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Custom Class',
                    'tab-6' => 'Spacing',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
                            'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'ceris' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
                            'top_review'        => esc_html__( 'Best Review', 'ceris' ),
                            'modified'          => esc_html__( 'Modified', 'ceris' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must Pick the Video Posts', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
	                'post_source' => array(
	                    'title' => esc_html__('Show only Post Type', 'ceris' ),
	                    'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
	                    'field' => 'select',
	                    'default' => 'all',
	                    'options' => array(
	                        'all'        => esc_html__( 'All', 'ceris' ),
	                        'video'      => esc_html__( 'Video', 'ceris' ),
	                        'gallery'    => esc_html__( 'Gallery', 'ceris' ),
	                        'review'     => esc_html__( 'Review', 'ceris' ),
	                    ),
	                ),    
	                'post_icon' => array(
	                    'title' => esc_html__('Post Icon', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
	                    'field' => 'select',
	                    'default' => 'disable',
	                    'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
	                        'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
	                    ),
	                ),
	                'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),
                    //Tab 5
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'text',
						'default' => '',
					),
					//tab 6
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-6',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-6',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-6',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
            ),
            'posts_block_grid_e_no_sidebar' => array(
				'title' => esc_html__( 'Post Block Grid E', 'ceris' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/tnm_18.png',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Custom Class',
                    'tab-6' => 'Spacing',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
                            'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'ceris' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
                            'top_review'        => esc_html__( 'Best Review', 'ceris' ),
                            'modified'          => esc_html__( 'Modified', 'ceris' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must Pick the Video Posts', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
	                'post_source' => array(
	                    'title' => esc_html__('Show only Post Type', 'ceris' ),
	                    'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
	                    'field' => 'select',
	                    'default' => 'all',
	                    'options' => array(
	                        'all'        => esc_html__( 'All', 'ceris' ),
	                        'video'      => esc_html__( 'Video', 'ceris' ),
	                        'gallery'    => esc_html__( 'Gallery', 'ceris' ),
	                        'review'     => esc_html__( 'Review', 'ceris' ),
	                    ),
	                ),    
	                'post_icon' => array(
	                    'title' => esc_html__('Post Icon', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
	                    'field' => 'select',
	                    'default' => 'disable',
	                    'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
	                        'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
	                    ),
	                ),
	                'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),
                    //Tab 5
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'text',
						'default' => '',
					),
					//tab 6
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-6',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-6',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-6',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
            ),
            'posts_block_grid_f_no_sidebar' => array(
				'title' => esc_html__( 'Post Block Grid F', 'ceris' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/tnm_20.png',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Custom Class',
                    'tab-6' => 'Spacing',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
                            'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'ceris' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
                            'top_review'        => esc_html__( 'Best Review', 'ceris' ),
                            'modified'          => esc_html__( 'Modified', 'ceris' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must Pick the Video Posts', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
	                'post_source' => array(
	                    'title' => esc_html__('Show only Post Type', 'ceris' ),
	                    'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
	                    'field' => 'select',
	                    'default' => 'all',
	                    'options' => array(
	                        'all'        => esc_html__( 'All', 'ceris' ),
	                        'video'      => esc_html__( 'Video', 'ceris' ),
	                        'gallery'    => esc_html__( 'Gallery', 'ceris' ),
	                        'review'     => esc_html__( 'Review', 'ceris' ),
	                    ),
	                ),    
	                'post_icon' => array(
	                    'title' => esc_html__('Post Icon', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
	                    'field' => 'select',
	                    'default' => 'disable',
	                    'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
	                        'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
	                    ),
	                ),
	                'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),
                    //Tab 5
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'text',
						'default' => '',
					),
					//tab 6
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-6',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-6',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-6',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
            ),
            'posts_block_grid_g_no_sidebar' => array(
				'title' => esc_html__( 'Post Block Grid G', 'ceris' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/tnm_19.png',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Custom Class',
                    'tab-6' => 'Spacing',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
                            'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'ceris' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
                            'top_review'        => esc_html__( 'Best Review', 'ceris' ),
                            'modified'          => esc_html__( 'Modified', 'ceris' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must Pick the Video Posts', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
	                'post_source' => array(
	                    'title' => esc_html__('Show only Post Type', 'ceris' ),
	                    'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
	                    'field' => 'select',
	                    'default' => 'all',
	                    'options' => array(
	                        'all'        => esc_html__( 'All', 'ceris' ),
	                        'video'      => esc_html__( 'Video', 'ceris' ),
	                        'gallery'    => esc_html__( 'Gallery', 'ceris' ),
	                        'review'     => esc_html__( 'Review', 'ceris' ),
	                    ),
	                ),    
	                'post_icon' => array(
	                    'title' => esc_html__('Post Icon', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
	                    'field' => 'select',
	                    'default' => 'disable',
	                    'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
	                        'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
	                    ),
	                ),
	                'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),
                    //Tab 5
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'text',
						'default' => '',
					),
					//tab 6
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-6',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-6',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-6',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
            ),
            'posts_block_grid_h_no_sidebar' => array(
				'title' => esc_html__( 'Post Block Grid H', 'ceris' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ceris_103.png',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Custom Class',
                    'tab-6' => 'Spacing',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
                            'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'ceris' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
                            'top_review'        => esc_html__( 'Best Review', 'ceris' ),
                            'modified'          => esc_html__( 'Modified', 'ceris' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must Pick the Video Posts', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
	                'post_source' => array(
	                    'title' => esc_html__('Show only Post Type', 'ceris' ),
	                    'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
	                    'field' => 'select',
	                    'default' => 'all',
	                    'options' => array(
	                        'all'        => esc_html__( 'All', 'ceris' ),
	                        'video'      => esc_html__( 'Video', 'ceris' ),
	                        'gallery'    => esc_html__( 'Gallery', 'ceris' ),
	                        'review'     => esc_html__( 'Review', 'ceris' ),
	                    ),
	                ),    
	                'post_icon' => array(
	                    'title' => esc_html__('Post Icon', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
	                    'field' => 'select',
	                    'default' => 'disable',
	                    'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
	                        'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
	                    ),
	                ),
	                'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),
                    //Tab 5
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'text',
						'default' => '',
					),
					//tab 6
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-6',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-6',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-6',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
            ),
            'carousel_heading_aside' => array(
				'title' => esc_html__( 'Carousel Heading Aside', 'ceris' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/33.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Spacing',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'subtitle' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'The Module Sub Title', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
                    'carousel_loop' => array(
						'title' => esc_html__('Carousel Loop', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 'true',
						'options' => array(
                            'true'     => esc_html__( 'True', 'ceris' ),
							'false'    => esc_html__( 'False', 'ceris' ),
						),
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'ceris' ),
						'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 7
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
                            'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'ceris' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
                            'top_review'        => esc_html__( 'Best Review', 'ceris' ),
                            'modified'          => esc_html__( 'Modified', 'ceris' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma - Must Pick The Video Posts', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'ceris' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
                            'gallery'    => esc_html__( 'Gallery', 'ceris' ),
                            'review'     => esc_html__( 'Review', 'ceris' ),
						),
					),    
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'ceris' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
						),
					), 
	                'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
            ),
	        'listing_grid_overlay_aside' => array(
	            'title' => esc_html__( 'Listing Grid Overlay Aside', 'ceris' ),
	            'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ceris_101.png',
	            'tabdisable' => 'tab-option-6',
	            'tabnames'  => array(
	                'tab-1' => 'General',
	                'tab-2' => 'Query Option',
	                'tab-3' => 'Manually Pick Post',
	                'tab-4' => 'Post Type',
	                'tab-5' => 'Spacing',
	            ),
	            'options' => array(
	                // Tab 1
	                'title' => array(
	                    'title' => esc_html__('Title', 'ceris' ),
	                    'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
                    'banner_title' => array(
						'title' => esc_html__('Banner Title', 'ceris' ),
						'description' => esc_html__( 'Put Title Text Here', 'ceris' ),
						'optionclass' => 'option-tab-1',
                        'field' => 'text',
						'default' => '',
					),
                    'banner_img' => array(
						'title' => esc_html__('Banner Image URL - #1', 'ceris' ),
						'description' => esc_html__( 'Upload your image here', 'ceris' ),
						'optionclass' => 'option-tab-1',
                        'field' => 'image',
						'default' => '',
					),
                    'banner_button' => array(
						'title' => esc_html__('Banner  Button', 'ceris'),
						'optionclass' => 'option-tab-1',
                        'field' => 'select',
						'default' => 'enable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'ceris' ),
                            'enable' => esc_html__( 'Enable', 'ceris' ),
						),
					),
                    'banner_link' => array(
						'title' => esc_html__('Banner Button Link', 'ceris' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'required'    => array('banner_button' => 'enable'),
						'field' => 'text',
						'default' => '',
					),
                    'banner_text' => array(
						'title' => esc_html__('Banner Button Text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'required'    => array('banner_button' => 'enable'),
						'field' => 'text',
						'default' => '',
					),
                    'banner_target' => array(
						'title' => esc_html__('Target', 'ceris'),
						'optionclass' => 'option-tab-1',
                        'field' => 'select',
                        'required'    => array('banner_button' => 'enable'),
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'ceris' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'ceris' ),
						),
					),
	                'ajax_load_more' => array(
	                    'title' => esc_html__('Ajax Load More', 'ceris'),
	                    'description' => esc_html__( 'Select an Ajax Load More Type', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-ajax-load-more',
	                    'field' => 'select',
	                    'default' => 'disable',
	                    'options' => array(
	                        'disable' => esc_html__( 'Disable', 'ceris' ),
	                        'pagination' => esc_html__( 'Ajax Pagination', 'ceris' ),
	                        'loadmore' => esc_html__( 'Ajax Load More Button', 'ceris' ),
	                        'infinity' => esc_html__( 'Ajax Infinity Scrolling', 'ceris' ),
	                        'viewall' => esc_html__( 'View All Button', 'ceris' ),
	                    ),
	                ),
	                'view_all_link' => array(
	                    'title' => esc_html__('View All Button Link', 'ceris' ),
	                    'description' => esc_html__( 'Insert the link for the View All button', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-view-all',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                'view_all_text' => array(
	                    'title' => esc_html__('View All Button Text', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-view-all',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                'view_all_target' => array(
	                    'title' => esc_html__('Target', 'ceris'),
	                    'optionclass' => 'option-tab-1 ceris-view-all',
	                    'field' => 'select',
	                    'default' => '_blank',
	                    'options' => array(
	                        '_blank'   => esc_html__( 'Open link in new tab', 'ceris' ),
	                        '_self'    => esc_html__( 'Open link in current tab', 'ceris' ),
	                    ),
	                ),
                    'bookmark' => array(
                        'title' => esc_html__('Bookmark', 'ceris'),
                        'description' => esc_html__( 'Allow bookmark buttons in this module', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'field' => 'select',
                        'default' => 'off',
                        'options' => array(
                            'on'   => esc_html__( 'On', 'ceris' ),
                            'off'    => esc_html__( 'Off', 'ceris' ),
                        ),
                    ),
	                'custom_class' => array(
	                    'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
	                    'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                // Tab 2
	                'limit' => array(
	                    'title' => esc_html__('Number of Posts', 'ceris' ),
	                    'description' => esc_html__( 'Enter the number of posts (Should be divisible by 3. Default: 6.)', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'number',
	                    'default' => 6
	                ),
	                'offset' => array(
	                    'title' => esc_html__('Offset', 'ceris' ),
	                    'description' => esc_html__( 'Enter the offset number', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'number',
	                    'default' => 0
	                ),
	                'feature' => array(
	                    'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
	                    'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'select',
	                    'default' => 'no',
	                    'options' => array(
	                        'no' => esc_html__( 'No', 'ceris' ),
	                        'yes' => esc_html__( 'Yes', 'ceris' ),
	                    ),
	                ),
	                'orderby' => array(
	                    'title' => esc_html__('Order By', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'select',
	                    'default' => 'date',
	                    'options' => array(
	                        'date'              => esc_html__( 'Latest Posts', 'ceris' ),
	                        'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
	                        'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
	                        'top_review'        => esc_html__( 'Best Review', 'ceris' ),
	                        'modified'          => esc_html__( 'Modified', 'ceris' ),
	                        'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
	                        'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
	                        'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
	                    ),
	                ), 
	                'tags' => array(
	                    'title' => esc_html__('Tags', 'ceris' ),
	                    'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                'category' => array(
	                    'title' => esc_html__('Category', 'ceris' ),
	                    'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'category',
	                    'default' => '0',
	                ),
	                // Tab 3
	                'editor_pick' => array(
	                    'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
	                    'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must Pick the Video Posts', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                'editor_exclude' => array(
	                    'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
	                    'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                // Tab 4
	                'post_source' => array(
	                    'title' => esc_html__('Show only Post Type', 'ceris' ),
	                    'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
	                    'field' => 'select',
	                    'default' => 'all',
	                    'options' => array(
	                        'all'        => esc_html__( 'All', 'ceris' ),
	                        'video'      => esc_html__( 'Video', 'ceris' ),
	                        'gallery'    => esc_html__( 'Gallery', 'ceris' ),
	                        'review'     => esc_html__( 'Review', 'ceris' ),
	                    ),
	                ),    
	                'post_icon' => array(
	                    'title' => esc_html__('Post Icon', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
	                    'field' => 'select',
	                    'default' => 'disable',
	                    'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
	                        'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
	                    ),
	                ),
	                'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
	            ),
	        ),
	        'listing_grid_vertical_aside' => array(
	            'title' => esc_html__( 'Listing Grid Vertical Aside', 'ceris' ),
	            'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ceris_102.png',
	            'tabdisable' => 'tab-option-6',
	            'tabnames'  => array(
	                'tab-1' => 'General',
	                'tab-2' => 'Query Option',
	                'tab-3' => 'Manually Pick Post',
	                'tab-4' => 'Post Type',
	                'tab-5' => 'Spacing',
	            ),
	            'options' => array(
	                // Tab 1
	                'title' => array(
	                    'title' => esc_html__('Title', 'ceris' ),
	                    'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
                    'banner_title' => array(
						'title' => esc_html__('Banner Title', 'ceris' ),
						'description' => esc_html__( 'Put Title Text Here', 'ceris' ),
						'optionclass' => 'option-tab-1',
                        'field' => 'text',
						'default' => '',
					),
                    'banner_img' => array(
						'title' => esc_html__('Banner Image URL - #1', 'ceris' ),
						'description' => esc_html__( 'Upload your image here', 'ceris' ),
						'optionclass' => 'option-tab-1',
                        'field' => 'image',
						'default' => '',
					),
                    'banner_button' => array(
						'title' => esc_html__('Banner  Button', 'ceris'),
						'optionclass' => 'option-tab-1',
                        'field' => 'select',
						'default' => 'enable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'ceris' ),
                            'enable' => esc_html__( 'Enable', 'ceris' ),
						),
					),
                    'banner_link' => array(
						'title' => esc_html__('Banner Button Link', 'ceris' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'required'    => array('banner_button' => 'enable'),
						'field' => 'text',
						'default' => '',
					),
                    'banner_text' => array(
						'title' => esc_html__('Banner Button Text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'required'    => array('banner_button' => 'enable'),
						'field' => 'text',
						'default' => '',
					),
                    'banner_target' => array(
						'title' => esc_html__('Target', 'ceris'),
						'optionclass' => 'option-tab-1',
                        'field' => 'select',
                        'required'    => array('banner_button' => 'enable'),
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'ceris' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'ceris' ),
						),
					),
	                'ajax_load_more' => array(
	                    'title' => esc_html__('Ajax Load More', 'ceris'),
	                    'description' => esc_html__( 'Select an Ajax Load More Type', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-ajax-load-more',
	                    'field' => 'select',
	                    'default' => 'disable',
	                    'options' => array(
	                        'disable' => esc_html__( 'Disable', 'ceris' ),
	                        'pagination' => esc_html__( 'Ajax Pagination', 'ceris' ),
	                        'loadmore' => esc_html__( 'Ajax Load More Button', 'ceris' ),
	                        'infinity' => esc_html__( 'Ajax Infinity Scrolling', 'ceris' ),
	                        'viewall' => esc_html__( 'View All Button', 'ceris' ),
	                    ),
	                ),
	                'view_all_link' => array(
	                    'title' => esc_html__('View All Button Link', 'ceris' ),
	                    'description' => esc_html__( 'Insert the link for the View All button', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-view-all',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                'view_all_text' => array(
	                    'title' => esc_html__('View All Button Text', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-view-all',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                'view_all_target' => array(
	                    'title' => esc_html__('Target', 'ceris'),
	                    'optionclass' => 'option-tab-1 ceris-view-all',
	                    'field' => 'select',
	                    'default' => '_blank',
	                    'options' => array(
	                        '_blank'   => esc_html__( 'Open link in new tab', 'ceris' ),
	                        '_self'    => esc_html__( 'Open link in current tab', 'ceris' ),
	                    ),
	                ),
                    'bookmark' => array(
                        'title' => esc_html__('Bookmark', 'ceris'),
                        'description' => esc_html__( 'Allow bookmark buttons in this module', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'field' => 'select',
                        'default' => 'off',
                        'options' => array(
                            'on'   => esc_html__( 'On', 'ceris' ),
                            'off'    => esc_html__( 'Off', 'ceris' ),
                        ),
                    ),
	                'custom_class' => array(
	                    'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
	                    'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                // Tab 2
	                'limit' => array(
	                    'title' => esc_html__('Number of Posts', 'ceris' ),
	                    'description' => esc_html__( 'Enter the number of posts (Should be divisible by 3. Default: 6.)', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'number',
	                    'default' => 6
	                ),
	                'offset' => array(
	                    'title' => esc_html__('Offset', 'ceris' ),
	                    'description' => esc_html__( 'Enter the offset number', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'number',
	                    'default' => 0
	                ),
	                'feature' => array(
	                    'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
	                    'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'select',
	                    'default' => 'no',
	                    'options' => array(
	                        'no' => esc_html__( 'No', 'ceris' ),
	                        'yes' => esc_html__( 'Yes', 'ceris' ),
	                    ),
	                ),
	                'orderby' => array(
	                    'title' => esc_html__('Order By', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'select',
	                    'default' => 'date',
	                    'options' => array(
	                        'date'              => esc_html__( 'Latest Posts', 'ceris' ),
	                        'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
	                        'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
	                        'top_review'        => esc_html__( 'Best Review', 'ceris' ),
	                        'modified'          => esc_html__( 'Modified', 'ceris' ),
	                        'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
	                        'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
	                        'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
	                    ),
	                ), 
	                'tags' => array(
	                    'title' => esc_html__('Tags', 'ceris' ),
	                    'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                'category' => array(
	                    'title' => esc_html__('Category', 'ceris' ),
	                    'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'category',
	                    'default' => '0',
	                ),
	                // Tab 3
	                'editor_pick' => array(
	                    'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
	                    'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must Pick the Video Posts', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                'editor_exclude' => array(
	                    'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
	                    'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                // Tab 4
	                'post_source' => array(
	                    'title' => esc_html__('Show only Post Type', 'ceris' ),
	                    'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
	                    'field' => 'select',
	                    'default' => 'all',
	                    'options' => array(
	                        'all'        => esc_html__( 'All', 'ceris' ),
	                        'video'      => esc_html__( 'Video', 'ceris' ),
	                        'gallery'    => esc_html__( 'Gallery', 'ceris' ),
	                        'review'     => esc_html__( 'Review', 'ceris' ),
	                    ),
	                ),    
	                'post_icon' => array(
	                    'title' => esc_html__('Post Icon', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
	                    'field' => 'select',
	                    'default' => 'disable',
	                    'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
	                        'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
	                    ),
	                ),
	                'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
	            ),
	        ),
	        'listing_grid_has_slider' => array(
				'title' => esc_html__( 'Ceris Listing Grid Has Slider', 'ceris' ),
	            'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ceris_6.png',
	            'tabdisable' => 'tab-option-6',
	            'tabnames'  => array(
	                'tab-1' => 'General',
	                'tab-2' => 'Query Option',
	                'tab-3' => 'Manually Pick Post',
	                'tab-4' => 'Post Type',
	                'tab-5' => 'Spacing',
	            ),
				'options' => array(
	                // Tab 1
	                'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
	                'small_heading' => array(
						'title' => esc_html__('Title Small', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => 'Popular',
					),
	                'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                
	                // Tab 2
	                'limit' => array(
						'title' => esc_html__('Number of Posts', 'ceris' ),
						'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 9
					),
	                'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'number',
						'default' => 0
					),
	                'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
	                    'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
	                        'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
	                'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
	                        'date'              => esc_html__( 'Latest Posts', 'ceris' ),
	                        'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
	                        'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
	                        'top_review'        => esc_html__( 'Best Review', 'ceris' ),
	                        'modified'          => esc_html__( 'Modified', 'ceris' ),
	                        'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
	                        'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
	                        'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
	                'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
	                    'field' => 'category',
						'default' => '0',
					),
	                // Tab 3
	                'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
	                // Tab 4
	                'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
	                    'description' => esc_html__( 'All - Show All Post Type, This module does not show the post icons', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
	                        'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
	                        'gallery'    => esc_html__( 'Gallery', 'ceris' ),
	                        'review'     => esc_html__( 'Review', 'ceris' ),
						),
					),  
	                'post_icon' => array(
						'title' => esc_html__('Post Icon', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
						),
					),  
					'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
	        ),
	        'posts_listing_grid_overlay_no_sidebar' => array(
	            'title' => esc_html__( 'Posts Listing Grid Overlay', 'ceris' ),
	            'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/Listing_grid_overlay.png',
	            'tabdisable' => 'tab-option-6',
	            'tabnames'  => array(
	                'tab-1' => 'General',
	                'tab-2' => 'Query Option',
	                'tab-3' => 'Manually Pick Post',
	                'tab-4' => 'Post Type',
	                'tab-5' => 'Spacing',
	            ),
	            'options' => array(
	                // Tab 1
	                'title' => array(
	                    'title' => esc_html__('Title', 'ceris' ),
	                    'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
	                'ajax_load_more' => array(
	                    'title' => esc_html__('Ajax Load More', 'ceris'),
	                    'description' => esc_html__( 'Select an Ajax Load More Type', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-ajax-load-more',
	                    'field' => 'select',
	                    'default' => 'disable',
	                    'options' => array(
	                        'disable' => esc_html__( 'Disable', 'ceris' ),
	                        'pagination' => esc_html__( 'Ajax Pagination', 'ceris' ),
	                        'loadmore' => esc_html__( 'Ajax Load More Button', 'ceris' ),
	                        'infinity' => esc_html__( 'Ajax Infinity Scrolling', 'ceris' ),
	                        'viewall' => esc_html__( 'View All Button', 'ceris' ),
	                    ),
	                ),
	                'view_all_link' => array(
	                    'title' => esc_html__('View All Button Link', 'ceris' ),
	                    'description' => esc_html__( 'Insert the link for the View All button', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-view-all',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                'view_all_text' => array(
	                    'title' => esc_html__('View All Button Text', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-view-all',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                'view_all_target' => array(
	                    'title' => esc_html__('Target', 'ceris'),
	                    'optionclass' => 'option-tab-1 ceris-view-all',
	                    'field' => 'select',
	                    'default' => '_blank',
	                    'options' => array(
	                        '_blank'   => esc_html__( 'Open link in new tab', 'ceris' ),
	                        '_self'    => esc_html__( 'Open link in current tab', 'ceris' ),
	                    ),
	                ),
	                'custom_class' => array(
	                    'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
	                    'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                // Tab 2
	                'limit' => array(
	                    'title' => esc_html__('Number of Posts', 'ceris' ),
	                    'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'number',
	                    'default' => 10
	                ),
	                'offset' => array(
	                    'title' => esc_html__('Offset', 'ceris' ),
	                    'description' => esc_html__( 'Enter the offset number', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'number',
	                    'default' => 0
	                ),
	                'feature' => array(
	                    'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
	                    'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'select',
	                    'default' => 'no',
	                    'options' => array(
	                        'no' => esc_html__( 'No', 'ceris' ),
	                        'yes' => esc_html__( 'Yes', 'ceris' ),
	                    ),
	                ),
	                'orderby' => array(
	                    'title' => esc_html__('Order By', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'select',
	                    'default' => 'date',
	                    'options' => array(
	                        'date'              => esc_html__( 'Latest Posts', 'ceris' ),
	                        'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
	                        'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
	                        'top_review'        => esc_html__( 'Best Review', 'ceris' ),
	                        'modified'          => esc_html__( 'Modified', 'ceris' ),
	                        'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
	                        'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
	                        'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
	                    ),
	                ), 
	                'tags' => array(
	                    'title' => esc_html__('Tags', 'ceris' ),
	                    'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                'category' => array(
	                    'title' => esc_html__('Category', 'ceris' ),
	                    'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'category',
	                    'default' => '0',
	                ),
	                // Tab 3
	                'editor_pick' => array(
	                    'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
	                    'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must Pick the Video Posts', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                'editor_exclude' => array(
	                    'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
	                    'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                // Tab 4
	                'post_source' => array(
	                    'title' => esc_html__('Show only Post Type', 'ceris' ),
	                    'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
	                    'field' => 'select',
	                    'default' => 'all',
	                    'options' => array(
	                        'all'        => esc_html__( 'All', 'ceris' ),
	                        'video'      => esc_html__( 'Video', 'ceris' ),
	                        'gallery'    => esc_html__( 'Gallery', 'ceris' ),
	                        'review'     => esc_html__( 'Review', 'ceris' ),
	                    ),
	                ),    
	                'post_icon' => array(
	                    'title' => esc_html__('Post Icon', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
	                    'field' => 'select',
	                    'default' => 'disable',
	                    'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
	                        'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
	                    ),
	                ), 
	                'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
	            ),
	        ),
	        'posts_listing_list_no_sidebar' => array(
	            'title' => esc_html__( 'Posts Listing List A', 'ceris' ),
	            'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ceris_8.png',
	            'tabdisable' => 'tab-option-6',
	            'tabnames'  => array(
	                'tab-1' => 'General',
	                'tab-2' => 'Query Option',
	                'tab-3' => 'Manually Pick Post',
	                'tab-4' => 'Post Type',
	                'tab-5' => 'Spacing',
	            ),
	            'options' => array(
	                // Tab 1
	                'title' => array(
	                    'title' => esc_html__('Title', 'ceris' ),
	                    'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
	                'ajax_load_more' => array(
	                    'title' => esc_html__('Ajax Load More', 'ceris'),
	                    'description' => esc_html__( 'Select an Ajax Load More Type', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-ajax-load-more',
	                    'field' => 'select',
	                    'default' => 'disable',
	                    'options' => array(
	                        'disable' => esc_html__( 'Disable', 'ceris' ),
	                        'pagination' => esc_html__( 'Ajax Pagination', 'ceris' ),
	                        'loadmore' => esc_html__( 'Ajax Load More Button', 'ceris' ),
	                        'infinity' => esc_html__( 'Ajax Infinity Scrolling', 'ceris' ),
	                        'viewall' => esc_html__( 'View All Button', 'ceris' ),
	                    ),
	                ),
	                'view_all_link' => array(
	                    'title' => esc_html__('View All Button Link', 'ceris' ),
	                    'description' => esc_html__( 'Insert the link for the View All button', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-view-all',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                'view_all_text' => array(
	                    'title' => esc_html__('View All Button Text', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-view-all',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                'view_all_target' => array(
	                    'title' => esc_html__('Target', 'ceris'),
	                    'optionclass' => 'option-tab-1 ceris-view-all',
	                    'field' => 'select',
	                    'default' => '_blank',
	                    'options' => array(
	                        '_blank'   => esc_html__( 'Open link in new tab', 'ceris' ),
	                        '_self'    => esc_html__( 'Open link in current tab', 'ceris' ),
	                    ),
	                ),
                    'bookmark' => array(
                        'title' => esc_html__('Bookmark', 'ceris'),
                        'description' => esc_html__( 'Allow bookmark buttons in this module', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'field' => 'select',
                        'default' => 'off',
                        'options' => array(
                            'on'   => esc_html__( 'On', 'ceris' ),
                            'off'    => esc_html__( 'Off', 'ceris' ),
                        ),
                    ),
	                'custom_class' => array(
	                    'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
	                    'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                // Tab 2
	                'limit' => array(
	                    'title' => esc_html__('Number of Posts', 'ceris' ),
	                    'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'number',
	                    'default' => 10
	                ),
	                'offset' => array(
	                    'title' => esc_html__('Offset', 'ceris' ),
	                    'description' => esc_html__( 'Enter the offset number', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'number',
	                    'default' => 0
	                ),
	                'feature' => array(
	                    'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
	                    'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'select',
	                    'default' => 'no',
	                    'options' => array(
	                        'no' => esc_html__( 'No', 'ceris' ),
	                        'yes' => esc_html__( 'Yes', 'ceris' ),
	                    ),
	                ),
	                'orderby' => array(
	                    'title' => esc_html__('Order By', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'select',
	                    'default' => 'date',
	                    'options' => array(
	                        'date'              => esc_html__( 'Latest Posts', 'ceris' ),
	                        'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
	                        'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
	                        'top_review'        => esc_html__( 'Best Review', 'ceris' ),
	                        'modified'          => esc_html__( 'Modified', 'ceris' ),
	                        'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
	                        'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
	                        'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
	                    ),
	                ), 
	                'tags' => array(
	                    'title' => esc_html__('Tags', 'ceris' ),
	                    'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                'category' => array(
	                    'title' => esc_html__('Category', 'ceris' ),
	                    'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'category',
	                    'default' => '0',
	                ),
	                // Tab 3
	                'editor_pick' => array(
	                    'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
	                    'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must Pick the Video Posts', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                'editor_exclude' => array(
	                    'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
	                    'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                // Tab 4
	                'post_source' => array(
	                    'title' => esc_html__('Show only Post Type', 'ceris' ),
	                    'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
	                    'field' => 'select',
	                    'default' => 'all',
	                    'options' => array(
	                        'all'        => esc_html__( 'All', 'ceris' ),
	                        'video'      => esc_html__( 'Video', 'ceris' ),
	                        'gallery'    => esc_html__( 'Gallery', 'ceris' ),
	                        'review'     => esc_html__( 'Review', 'ceris' ),
	                    ),
	                ),    
	                'post_icon' => array(
	                    'title' => esc_html__('Post Icon', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
	                    'field' => 'select',
	                    'default' => 'disable',
	                    'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
	                        'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
	                    ),
	                ), 
	                'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
	            ),
	        ),
	        'posts_listing_list_b_no_sidebar' => array(
	            'title' => esc_html__( 'Posts Listing List B', 'ceris' ),
	            'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ceris_9.png',
	            'tabdisable' => 'tab-option-6',
	            'tabnames'  => array(
	                'tab-1' => 'General',
	                'tab-2' => 'Query Option',
	                'tab-3' => 'Manually Pick Post',
	                'tab-4' => 'Post Type',
	                'tab-5' => 'Spacing',
	            ),
	            'options' => array(
	                // Tab 1
	                'title' => array(
	                    'title' => esc_html__('Title', 'ceris' ),
	                    'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
	                'ajax_load_more' => array(
	                    'title' => esc_html__('Ajax Load More', 'ceris'),
	                    'description' => esc_html__( 'Select an Ajax Load More Type', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-ajax-load-more',
	                    'field' => 'select',
	                    'default' => 'disable',
	                    'options' => array(
	                        'disable' => esc_html__( 'Disable', 'ceris' ),
	                        'pagination' => esc_html__( 'Ajax Pagination', 'ceris' ),
	                        'loadmore' => esc_html__( 'Ajax Load More Button', 'ceris' ),
	                        'infinity' => esc_html__( 'Ajax Infinity Scrolling', 'ceris' ),
	                        'viewall' => esc_html__( 'View All Button', 'ceris' ),
	                    ),
	                ),
	                'view_all_link' => array(
	                    'title' => esc_html__('View All Button Link', 'ceris' ),
	                    'description' => esc_html__( 'Insert the link for the View All button', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-view-all',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                'view_all_text' => array(
	                    'title' => esc_html__('View All Button Text', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-view-all',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                'view_all_target' => array(
	                    'title' => esc_html__('Target', 'ceris'),
	                    'optionclass' => 'option-tab-1 ceris-view-all',
	                    'field' => 'select',
	                    'default' => '_blank',
	                    'options' => array(
	                        '_blank'   => esc_html__( 'Open link in new tab', 'ceris' ),
	                        '_self'    => esc_html__( 'Open link in current tab', 'ceris' ),
	                    ),
	                ),
                    'bookmark' => array(
                        'title' => esc_html__('Bookmark', 'ceris'),
                        'description' => esc_html__( 'Allow bookmark buttons in this module', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'field' => 'select',
                        'default' => 'off',
                        'options' => array(
                            'on'   => esc_html__( 'On', 'ceris' ),
                            'off'    => esc_html__( 'Off', 'ceris' ),
                        ),
                    ),
	                'custom_class' => array(
	                    'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
	                    'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                // Tab 2
	                'limit' => array(
	                    'title' => esc_html__('Number of Posts', 'ceris' ),
	                    'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'number',
	                    'default' => 10
	                ),
	                'offset' => array(
	                    'title' => esc_html__('Offset', 'ceris' ),
	                    'description' => esc_html__( 'Enter the offset number', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'number',
	                    'default' => 0
	                ),
	                'feature' => array(
	                    'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
	                    'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'select',
	                    'default' => 'no',
	                    'options' => array(
	                        'no' => esc_html__( 'No', 'ceris' ),
	                        'yes' => esc_html__( 'Yes', 'ceris' ),
	                    ),
	                ),
	                'orderby' => array(
	                    'title' => esc_html__('Order By', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'select',
	                    'default' => 'date',
	                    'options' => array(
	                        'date'              => esc_html__( 'Latest Posts', 'ceris' ),
	                        'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
	                        'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
	                        'top_review'        => esc_html__( 'Best Review', 'ceris' ),
	                        'modified'          => esc_html__( 'Modified', 'ceris' ),
	                        'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
	                        'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
	                        'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
	                    ),
	                ), 
	                'tags' => array(
	                    'title' => esc_html__('Tags', 'ceris' ),
	                    'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                'category' => array(
	                    'title' => esc_html__('Category', 'ceris' ),
	                    'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'category',
	                    'default' => '0',
	                ),
	                // Tab 3
	                'editor_pick' => array(
	                    'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
	                    'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must Pick the Video Posts', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                'editor_exclude' => array(
	                    'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
	                    'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                // Tab 4
	                'post_source' => array(
	                    'title' => esc_html__('Show only Post Type', 'ceris' ),
	                    'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
	                    'field' => 'select',
	                    'default' => 'all',
	                    'options' => array(
	                        'all'        => esc_html__( 'All', 'ceris' ),
	                        'video'      => esc_html__( 'Video', 'ceris' ),
	                        'gallery'    => esc_html__( 'Gallery', 'ceris' ),
	                        'review'     => esc_html__( 'Review', 'ceris' ),
	                    ),
	                ),    
	                'post_icon' => array(
	                    'title' => esc_html__('Post Icon', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
	                    'field' => 'select',
	                    'default' => 'disable',
	                    'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
	                        'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
	                    ),
	                ), 
	                'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
	            ),
	        ),
            'posts_listing_list_c_no_sidebar' => array(
				'title' => esc_html__( 'Posts Listing List C', 'ceris' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ce_7.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Spacing',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
                    'ajax_load_more' => array(
						'title' => esc_html__('Ajax Load More', 'ceris'),
                        'description' => esc_html__( 'Select an Ajax Load More Type', 'ceris' ),
						'optionclass' => 'option-tab-1 ceris-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'ceris' ),
                            'pagination' => esc_html__( 'Ajax Pagination', 'ceris' ),
                            'loadmore' => esc_html__( 'Ajax Load More Button', 'ceris' ),
                            'infinity' => esc_html__( 'Ajax Infinity Scrolling', 'ceris' ),
                            'viewall' => esc_html__( 'View All Button', 'ceris' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'ceris' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'ceris' ),
                        'optionclass' => 'option-tab-1 ceris-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ceris-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'ceris'),
						'optionclass' => 'option-tab-1 ceris-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'ceris' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'ceris' ),
						),
					),
	                'wide_layout' => array(
						'title' => esc_html__('Wide Option', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Yes/No Wide on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 'No',
						'options' => array(
	                        'No'           => esc_html__( 'No', 'ceris' ),
							'Yes'            => esc_html__( 'Yes', 'ceris' ),
						),
					),
                    'bookmark' => array(
                        'title' => esc_html__('Bookmark', 'ceris'),
                        'description' => esc_html__( 'Allow bookmark buttons in this module', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'field' => 'select',
                        'default' => 'off',
                        'options' => array(
                            'on'   => esc_html__( 'On', 'ceris' ),
                            'off'    => esc_html__( 'Off', 'ceris' ),
                        ),
                    ),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'ceris' ),
						'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 10
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
                            'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'ceris' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
                            'top_review'        => esc_html__( 'Best Review', 'ceris' ),
                            'modified'          => esc_html__( 'Modified', 'ceris' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must Pick the Video Posts', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'ceris' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
                            'gallery'    => esc_html__( 'Gallery', 'ceris' ),
                            'review'     => esc_html__( 'Review', 'ceris' ),
						),
					),    
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'ceris' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
						),
					),
	                'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
            ),
            'posts_listing_list_d_no_sidebar' => array(
				'title' => esc_html__( 'Posts Listing List D', 'ceris' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ce_32.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Spacing',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
                    'ajax_load_more' => array(
						'title' => esc_html__('Ajax Load More', 'ceris'),
                        'description' => esc_html__( 'Select an Ajax Load More Type', 'ceris' ),
						'optionclass' => 'option-tab-1 ceris-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'ceris' ),
                            'pagination' => esc_html__( 'Ajax Pagination', 'ceris' ),
                            'loadmore' => esc_html__( 'Ajax Load More Button', 'ceris' ),
                            'infinity' => esc_html__( 'Ajax Infinity Scrolling', 'ceris' ),
                            'viewall' => esc_html__( 'View All Button', 'ceris' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'ceris' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'ceris' ),
                        'optionclass' => 'option-tab-1 ceris-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ceris-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'ceris'),
						'optionclass' => 'option-tab-1 ceris-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'ceris' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'ceris' ),
						),
					),
	                'wide_layout' => array(
						'title' => esc_html__('Wide Option', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Yes/No Wide on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 'No',
						'options' => array(
	                        'No'           => esc_html__( 'No', 'ceris' ),
							'Yes'            => esc_html__( 'Yes', 'ceris' ),
						),
					),
                    'bookmark' => array(
                        'title' => esc_html__('Bookmark', 'ceris'),
                        'description' => esc_html__( 'Allow bookmark buttons in this module', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'field' => 'select',
                        'default' => 'off',
                        'options' => array(
                            'on'   => esc_html__( 'On', 'ceris' ),
                            'off'    => esc_html__( 'Off', 'ceris' ),
                        ),
                    ),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'ceris' ),
						'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 10
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
                            'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'ceris' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
                            'top_review'        => esc_html__( 'Best Review', 'ceris' ),
                            'modified'          => esc_html__( 'Modified', 'ceris' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must Pick the Video Posts', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'ceris' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
                            'gallery'    => esc_html__( 'Gallery', 'ceris' ),
                            'review'     => esc_html__( 'Review', 'ceris' ),
						),
					),    
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'ceris' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
						),
					), 
	                'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
            ),
            'posts_listing_list_e_no_sidebar' => array(
				'title' => esc_html__( 'Posts Listing List E', 'ceris' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ce_25.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Spacing',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
                    'ajax_load_more' => array(
						'title' => esc_html__('Ajax Load More', 'ceris'),
                        'description' => esc_html__( 'Select an Ajax Load More Type', 'ceris' ),
						'optionclass' => 'option-tab-1 ceris-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'ceris' ),
                            'pagination' => esc_html__( 'Ajax Pagination', 'ceris' ),
                            'loadmore' => esc_html__( 'Ajax Load More Button', 'ceris' ),
                            'infinity' => esc_html__( 'Ajax Infinity Scrolling', 'ceris' ),
                            'viewall' => esc_html__( 'View All Button', 'ceris' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'ceris' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'ceris' ),
                        'optionclass' => 'option-tab-1 ceris-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ceris-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'ceris'),
						'optionclass' => 'option-tab-1 ceris-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'ceris' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'ceris' ),
						),
					),
	                'wide_layout' => array(
						'title' => esc_html__('Wide Option', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Yes/No Wide on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 'No',
						'options' => array(
	                        'No'           => esc_html__( 'No', 'ceris' ),
							'Yes'            => esc_html__( 'Yes', 'ceris' ),
						),
					),
                    'bookmark' => array(
                        'title' => esc_html__('Bookmark', 'ceris'),
                        'description' => esc_html__( 'Allow bookmark buttons in this module', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'field' => 'select',
                        'default' => 'off',
                        'options' => array(
                            'on'   => esc_html__( 'On', 'ceris' ),
                            'off'    => esc_html__( 'Off', 'ceris' ),
                        ),
                    ),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'ceris' ),
						'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 10
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
                            'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'ceris' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
                            'top_review'        => esc_html__( 'Best Review', 'ceris' ),
                            'modified'          => esc_html__( 'Modified', 'ceris' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must Pick the Video Posts', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'ceris' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
                            'gallery'    => esc_html__( 'Gallery', 'ceris' ),
                            'review'     => esc_html__( 'Review', 'ceris' ),
						),
					),    
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'ceris' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
						),
					), 
	                'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
            ),
            'posts_listing_list_f_no_sidebar' => array(
				'title' => esc_html__( 'Posts Listing List F', 'ceris' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/46.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Spacing',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
                    'ajax_load_more' => array(
						'title' => esc_html__('Ajax Load More', 'ceris'),
                        'description' => esc_html__( 'Select an Ajax Load More Type', 'ceris' ),
						'optionclass' => 'option-tab-1 ceris-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'ceris' ),
                            'pagination' => esc_html__( 'Ajax Pagination', 'ceris' ),
                            'loadmore' => esc_html__( 'Ajax Load More Button', 'ceris' ),
                            'infinity' => esc_html__( 'Ajax Infinity Scrolling', 'ceris' ),
                            'viewall' => esc_html__( 'View All Button', 'ceris' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'ceris' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'ceris' ),
                        'optionclass' => 'option-tab-1 ceris-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ceris-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'ceris'),
						'optionclass' => 'option-tab-1 ceris-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'ceris' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'ceris' ),
						),
					),    
                    'post_reverse' => array(
						'title' => esc_html__('Post Reverse', 'ceris' ),
                        'description' => esc_html__( 'Configure Post Reverse on This Module', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Reverse', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Reverse', 'ceris' ),
							'alternate'			=> esc_html__( 'Enable Post Alternate', 'ceris' ),
						),
					),
	                'wide_layout' => array(
						'title' => esc_html__('Wide Option', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Yes/No Wide on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 'No',
						'options' => array(
	                        'No'           => esc_html__( 'No', 'ceris' ),
							'Yes'            => esc_html__( 'Yes', 'ceris' ),
						),
					),
                    'bookmark' => array(
                        'title' => esc_html__('Bookmark', 'ceris'),
                        'description' => esc_html__( 'Allow bookmark buttons in this module', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'field' => 'select',
                        'default' => 'off',
                        'options' => array(
                            'on'   => esc_html__( 'On', 'ceris' ),
                            'off'    => esc_html__( 'Off', 'ceris' ),
                        ),
                    ),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'ceris' ),
						'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 10
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
                            'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'ceris' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
                            'top_review'        => esc_html__( 'Best Review', 'ceris' ),
                            'modified'          => esc_html__( 'Modified', 'ceris' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must Pick the Video Posts', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'ceris' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
                            'gallery'    => esc_html__( 'Gallery', 'ceris' ),
                            'review'     => esc_html__( 'Review', 'ceris' ),
						),
					),    
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'ceris' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
						),
					), 
	                'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
            ),
            'posts_listing_list_g_no_sidebar' => array(
				'title' => esc_html__( 'Posts Listing List G', 'ceris' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ceris_32.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Spacing',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
                    'ajax_load_more' => array(
						'title' => esc_html__('Ajax Load More', 'ceris'),
                        'description' => esc_html__( 'Select an Ajax Load More Type', 'ceris' ),
						'optionclass' => 'option-tab-1 ceris-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'ceris' ),
                            'pagination' => esc_html__( 'Ajax Pagination', 'ceris' ),
                            'loadmore' => esc_html__( 'Ajax Load More Button', 'ceris' ),
                            'infinity' => esc_html__( 'Ajax Infinity Scrolling', 'ceris' ),
                            'viewall' => esc_html__( 'View All Button', 'ceris' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'ceris' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'ceris' ),
                        'optionclass' => 'option-tab-1 ceris-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ceris-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'ceris'),
						'optionclass' => 'option-tab-1 ceris-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'ceris' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'ceris' ),
						),
					),
					'background_color' => array(
						'title' => esc_html__('Post Background Color', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'field' => 'colorpicker',
						'default' => '#fff',
					),
                    'bookmark' => array(
                        'title' => esc_html__('Bookmark', 'ceris'),
                        'description' => esc_html__( 'Allow bookmark buttons in this module', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'field' => 'select',
                        'default' => 'off',
                        'options' => array(
                            'on'   => esc_html__( 'On', 'ceris' ),
                            'off'    => esc_html__( 'Off', 'ceris' ),
                        ),
                    ),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'ceris' ),
						'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 10
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
                            'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'ceris' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
                            'top_review'        => esc_html__( 'Best Review', 'ceris' ),
                            'modified'          => esc_html__( 'Modified', 'ceris' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must Pick the Video Posts', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'ceris' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
                            'gallery'    => esc_html__( 'Gallery', 'ceris' ),
                            'review'     => esc_html__( 'Review', 'ceris' ),
						),
					),    
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'ceris' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
						),
					), 
	                'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
            ),
	        'posts_listing_list_large_a_no_sidebar' => array(
	            'title' => esc_html__( 'Posts Listing List Large A', 'ceris' ),
	            'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ceris_10.png',
	            'tabdisable' => 'tab-option-6',
	            'tabnames'  => array(
	                'tab-1' => 'General',
	                'tab-2' => 'Query Option',
	                'tab-3' => 'Manually Pick Post',
	                'tab-4' => 'Post Type',
	                'tab-5' => 'Spacing',
	            ),
	            'options' => array(
	                // Tab 1
	                'title' => array(
	                    'title' => esc_html__('Title', 'ceris' ),
	                    'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
	                'ajax_load_more' => array(
	                    'title' => esc_html__('Ajax Load More', 'ceris'),
	                    'description' => esc_html__( 'Select an Ajax Load More Type', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-ajax-load-more',
	                    'field' => 'select',
	                    'default' => 'disable',
	                    'options' => array(
	                        'disable' => esc_html__( 'Disable', 'ceris' ),
	                        'pagination' => esc_html__( 'Ajax Pagination', 'ceris' ),
	                        'loadmore' => esc_html__( 'Ajax Load More Button', 'ceris' ),
	                        'infinity' => esc_html__( 'Ajax Infinity Scrolling', 'ceris' ),
	                        'viewall' => esc_html__( 'View All Button', 'ceris' ),
	                    ),
	                ),
	                'view_all_link' => array(
	                    'title' => esc_html__('View All Button Link', 'ceris' ),
	                    'description' => esc_html__( 'Insert the link for the View All button', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-view-all',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                'view_all_text' => array(
	                    'title' => esc_html__('View All Button Text', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-view-all',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                'view_all_target' => array(
	                    'title' => esc_html__('Target', 'ceris'),
	                    'optionclass' => 'option-tab-1 ceris-view-all',
	                    'field' => 'select',
	                    'default' => '_blank',
	                    'options' => array(
	                        '_blank'   => esc_html__( 'Open link in new tab', 'ceris' ),
	                        '_self'    => esc_html__( 'Open link in current tab', 'ceris' ),
	                    ),
	                ),
	                'wide_layout' => array(
						'title' => esc_html__('Wide Option', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Yes/No Wide on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 'No',
						'options' => array(
	                        'No'           => esc_html__( 'No', 'ceris' ),
							'Yes'            => esc_html__( 'Yes', 'ceris' ),
						),
					),
                    'bookmark' => array(
                        'title' => esc_html__('Bookmark', 'ceris'),
                        'description' => esc_html__( 'Allow bookmark buttons in this module', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'field' => 'select',
                        'default' => 'off',
                        'options' => array(
                            'on'   => esc_html__( 'On', 'ceris' ),
                            'off'    => esc_html__( 'Off', 'ceris' ),
                        ),
                    ),
	                'custom_class' => array(
	                    'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
	                    'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                // Tab 2
	                'limit' => array(
	                    'title' => esc_html__('Number of Posts', 'ceris' ),
	                    'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'number',
	                    'default' => 10
	                ),
	                'offset' => array(
	                    'title' => esc_html__('Offset', 'ceris' ),
	                    'description' => esc_html__( 'Enter the offset number', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'number',
	                    'default' => 0
	                ),
	                'feature' => array(
	                    'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
	                    'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'select',
	                    'default' => 'no',
	                    'options' => array(
	                        'no' => esc_html__( 'No', 'ceris' ),
	                        'yes' => esc_html__( 'Yes', 'ceris' ),
	                    ),
	                ),
	                'orderby' => array(
	                    'title' => esc_html__('Order By', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'select',
	                    'default' => 'date',
	                    'options' => array(
	                        'date'              => esc_html__( 'Latest Posts', 'ceris' ),
	                        'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
	                        'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
	                        'top_review'        => esc_html__( 'Best Review', 'ceris' ),
	                        'modified'          => esc_html__( 'Modified', 'ceris' ),
	                        'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
	                        'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
	                        'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
	                    ),
	                ), 
	                'tags' => array(
	                    'title' => esc_html__('Tags', 'ceris' ),
	                    'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                'category' => array(
	                    'title' => esc_html__('Category', 'ceris' ),
	                    'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'category',
	                    'default' => '0',
	                ),
	                // Tab 3
	                'editor_pick' => array(
	                    'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
	                    'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must Pick the Video Posts', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                'editor_exclude' => array(
	                    'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
	                    'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                // Tab 4
	                'post_source' => array(
	                    'title' => esc_html__('Show only Post Type', 'ceris' ),
	                    'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
	                    'field' => 'select',
	                    'default' => 'all',
	                    'options' => array(
	                        'all'        => esc_html__( 'All', 'ceris' ),
	                        'video'      => esc_html__( 'Video', 'ceris' ),
	                        'gallery'    => esc_html__( 'Gallery', 'ceris' ),
	                        'review'     => esc_html__( 'Review', 'ceris' ),
	                    ),
	                ),    
	                'post_icon' => array(
	                    'title' => esc_html__('Post Icon', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
	                    'field' => 'select',
	                    'default' => 'disable',
	                    'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
	                        'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
	                    ),
	                ), 
	                'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
	            ),
	        ),
	        'posts_listing_list_large_b_no_sidebar' => array(
	            'title' => esc_html__( 'Posts Listing List Large B', 'ceris' ),
	            'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ceris_11.png',
	            'tabdisable' => 'tab-option-6',
	            'tabnames'  => array(
	                'tab-1' => 'General',
	                'tab-2' => 'Query Option',
	                'tab-3' => 'Manually Pick Post',
	                'tab-4' => 'Post Type',
	                'tab-5' => 'Spacing',
	            ),
	            'options' => array(
	                // Tab 1
	                'title' => array(
	                    'title' => esc_html__('Title', 'ceris' ),
	                    'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
	                'ajax_load_more' => array(
	                    'title' => esc_html__('Ajax Load More', 'ceris'),
	                    'description' => esc_html__( 'Select an Ajax Load More Type', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-ajax-load-more',
	                    'field' => 'select',
	                    'default' => 'disable',
	                    'options' => array(
	                        'disable' => esc_html__( 'Disable', 'ceris' ),
	                        'pagination' => esc_html__( 'Ajax Pagination', 'ceris' ),
	                        'loadmore' => esc_html__( 'Ajax Load More Button', 'ceris' ),
	                        'infinity' => esc_html__( 'Ajax Infinity Scrolling', 'ceris' ),
	                        'viewall' => esc_html__( 'View All Button', 'ceris' ),
	                    ),
	                ),
	                'view_all_link' => array(
	                    'title' => esc_html__('View All Button Link', 'ceris' ),
	                    'description' => esc_html__( 'Insert the link for the View All button', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-view-all',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                'view_all_text' => array(
	                    'title' => esc_html__('View All Button Text', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-view-all',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                'view_all_target' => array(
	                    'title' => esc_html__('Target', 'ceris'),
	                    'optionclass' => 'option-tab-1 ceris-view-all',
	                    'field' => 'select',
	                    'default' => '_blank',
	                    'options' => array(
	                        '_blank'   => esc_html__( 'Open link in new tab', 'ceris' ),
	                        '_self'    => esc_html__( 'Open link in current tab', 'ceris' ),
	                    ),
	                ),
	                'wide_layout' => array(
						'title' => esc_html__('Wide Option', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Yes/No Wide on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 'No',
						'options' => array(
	                        'No'           => esc_html__( 'No', 'ceris' ),
							'Yes'            => esc_html__( 'Yes', 'ceris' ),
						),
					),
                    'bookmark' => array(
                        'title' => esc_html__('Bookmark', 'ceris'),
                        'description' => esc_html__( 'Allow bookmark buttons in this module', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'field' => 'select',
                        'default' => 'off',
                        'options' => array(
                            'on'   => esc_html__( 'On', 'ceris' ),
                            'off'    => esc_html__( 'Off', 'ceris' ),
                        ),
                    ),
	                'custom_class' => array(
	                    'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
	                    'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                // Tab 2
	                'limit' => array(
	                    'title' => esc_html__('Number of Posts', 'ceris' ),
	                    'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'number',
	                    'default' => 10
	                ),
	                'offset' => array(
	                    'title' => esc_html__('Offset', 'ceris' ),
	                    'description' => esc_html__( 'Enter the offset number', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'number',
	                    'default' => 0
	                ),
	                'feature' => array(
	                    'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
	                    'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'select',
	                    'default' => 'no',
	                    'options' => array(
	                        'no' => esc_html__( 'No', 'ceris' ),
	                        'yes' => esc_html__( 'Yes', 'ceris' ),
	                    ),
	                ),
	                'orderby' => array(
	                    'title' => esc_html__('Order By', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'select',
	                    'default' => 'date',
	                    'options' => array(
	                        'date'              => esc_html__( 'Latest Posts', 'ceris' ),
	                        'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
	                        'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
	                        'top_review'        => esc_html__( 'Best Review', 'ceris' ),
	                        'modified'          => esc_html__( 'Modified', 'ceris' ),
	                        'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
	                        'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
	                        'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
	                    ),
	                ), 
	                'tags' => array(
	                    'title' => esc_html__('Tags', 'ceris' ),
	                    'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                'category' => array(
	                    'title' => esc_html__('Category', 'ceris' ),
	                    'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'category',
	                    'default' => '0',
	                ),
	                // Tab 3
	                'editor_pick' => array(
	                    'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
	                    'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must Pick the Video Posts', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                'editor_exclude' => array(
	                    'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
	                    'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                // Tab 4
	                'post_source' => array(
	                    'title' => esc_html__('Show only Post Type', 'ceris' ),
	                    'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
	                    'field' => 'select',
	                    'default' => 'all',
	                    'options' => array(
	                        'all'        => esc_html__( 'All', 'ceris' ),
	                        'video'      => esc_html__( 'Video', 'ceris' ),
	                        'gallery'    => esc_html__( 'Gallery', 'ceris' ),
	                        'review'     => esc_html__( 'Review', 'ceris' ),
	                    ),
	                ),    
	                'post_icon' => array(
	                    'title' => esc_html__('Post Icon', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
	                    'field' => 'select',
	                    'default' => 'disable',
	                    'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
	                        'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
	                    ),
	                ), 
	                'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
	            ),
	        ),
            'posts_listing_list_large_c_no_sidebar' => array(
	            'title' => esc_html__( 'Posts Listing List Large C', 'ceris' ),
	            'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/tnm_11.png',
	            'tabdisable' => 'tab-option-6',
	            'tabnames'  => array(
	                'tab-1' => 'General',
	                'tab-2' => 'Query Option',
	                'tab-3' => 'Manually Pick Post',
	                'tab-4' => 'Post Type',
	                'tab-5' => 'Spacing',
	            ),
	            'options' => array(
	                // Tab 1
	                'title' => array(
	                    'title' => esc_html__('Title', 'ceris' ),
	                    'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
	                'ajax_load_more' => array(
	                    'title' => esc_html__('Ajax Load More', 'ceris'),
	                    'description' => esc_html__( 'Select an Ajax Load More Type', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-ajax-load-more',
	                    'field' => 'select',
	                    'default' => 'disable',
	                    'options' => array(
	                        'disable' => esc_html__( 'Disable', 'ceris' ),
	                        'pagination' => esc_html__( 'Ajax Pagination', 'ceris' ),
	                        'loadmore' => esc_html__( 'Ajax Load More Button', 'ceris' ),
	                        'infinity' => esc_html__( 'Ajax Infinity Scrolling', 'ceris' ),
	                        'viewall' => esc_html__( 'View All Button', 'ceris' ),
	                    ),
	                ),
	                'view_all_link' => array(
	                    'title' => esc_html__('View All Button Link', 'ceris' ),
	                    'description' => esc_html__( 'Insert the link for the View All button', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-view-all',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                'view_all_text' => array(
	                    'title' => esc_html__('View All Button Text', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-view-all',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                'view_all_target' => array(
	                    'title' => esc_html__('Target', 'ceris'),
	                    'optionclass' => 'option-tab-1 ceris-view-all',
	                    'field' => 'select',
	                    'default' => '_blank',
	                    'options' => array(
	                        '_blank'   => esc_html__( 'Open link in new tab', 'ceris' ),
	                        '_self'    => esc_html__( 'Open link in current tab', 'ceris' ),
	                    ),
	                ),
	                'thumbnail_size' => array(
						'title' => esc_html__('Thumbnail Size', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => '16_9',
						'options' => array(
	                        'auto'           => esc_html__( 'Auto', 'ceris' ),
							'16_9'           => esc_html__( '16:9', 'ceris' ),
						),
					),
                    'bookmark' => array(
                        'title' => esc_html__('Bookmark', 'ceris'),
                        'description' => esc_html__( 'Allow bookmark buttons in this module', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'field' => 'select',
                        'default' => 'off',
                        'options' => array(
                            'on'   => esc_html__( 'On', 'ceris' ),
                            'off'    => esc_html__( 'Off', 'ceris' ),
                        ),
                    ),
	                'custom_class' => array(
	                    'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
	                    'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                // Tab 2
	                'limit' => array(
	                    'title' => esc_html__('Number of Posts', 'ceris' ),
	                    'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'number',
	                    'default' => 10
	                ),
	                'offset' => array(
	                    'title' => esc_html__('Offset', 'ceris' ),
	                    'description' => esc_html__( 'Enter the offset number', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'number',
	                    'default' => 0
	                ),
	                'feature' => array(
	                    'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
	                    'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'select',
	                    'default' => 'no',
	                    'options' => array(
	                        'no' => esc_html__( 'No', 'ceris' ),
	                        'yes' => esc_html__( 'Yes', 'ceris' ),
	                    ),
	                ),
	                'orderby' => array(
	                    'title' => esc_html__('Order By', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'select',
	                    'default' => 'date',
	                    'options' => array(
	                        'date'              => esc_html__( 'Latest Posts', 'ceris' ),
	                        'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
	                        'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
	                        'top_review'        => esc_html__( 'Best Review', 'ceris' ),
	                        'modified'          => esc_html__( 'Modified', 'ceris' ),
	                        'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
	                        'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
	                        'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
	                    ),
	                ), 
	                'tags' => array(
	                    'title' => esc_html__('Tags', 'ceris' ),
	                    'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                'category' => array(
	                    'title' => esc_html__('Category', 'ceris' ),
	                    'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'category',
	                    'default' => '0',
	                ),
	                // Tab 3
	                'editor_pick' => array(
	                    'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
	                    'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must Pick the Video Posts', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                'editor_exclude' => array(
	                    'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
	                    'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                // Tab 4
	                'post_source' => array(
	                    'title' => esc_html__('Show only Post Type', 'ceris' ),
	                    'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
	                    'field' => 'select',
	                    'default' => 'all',
	                    'options' => array(
	                        'all'        => esc_html__( 'All', 'ceris' ),
	                        'video'      => esc_html__( 'Video', 'ceris' ),
	                        'gallery'    => esc_html__( 'Gallery', 'ceris' ),
	                        'review'     => esc_html__( 'Review', 'ceris' ),
	                    ),
	                ),    
	                'post_icon' => array(
	                    'title' => esc_html__('Post Icon', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
	                    'field' => 'select',
	                    'default' => 'disable',
	                    'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
	                        'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
	                    ),
	                ), 
	                'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
	            ),
	        ),
	        'posts_listing_grid_no_sidebar' => array(
	            'title' => esc_html__( 'Posts Listing Grid', 'ceris' ),
	            'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ceris_update_1.png',
	            'tabdisable' => 'tab-option-6',
	            'tabnames'  => array(
	                'tab-1' => 'General',
	                'tab-2' => 'Query Option',
	                'tab-3' => 'Manually Pick Post',
	                'tab-4' => 'Post Type',
	                'tab-5' => 'Spacing',
	            ),
	            'options' => array(
	                // Tab 1
	                'title' => array(
	                    'title' => esc_html__('Title', 'ceris' ),
	                    'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
	                'ajax_load_more' => array(
	                    'title' => esc_html__('Ajax Load More', 'ceris'),
	                    'description' => esc_html__( 'Select an Ajax Load More Type', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-ajax-load-more',
	                    'field' => 'select',
	                    'default' => 'disable',
	                    'options' => array(
	                        'disable' => esc_html__( 'Disable', 'ceris' ),
	                        'pagination' => esc_html__( 'Ajax Pagination', 'ceris' ),
	                        'loadmore' => esc_html__( 'Ajax Load More Button', 'ceris' ),
	                        'infinity' => esc_html__( 'Ajax Infinity Scrolling', 'ceris' ),
	                        'viewall' => esc_html__( 'View All Button', 'ceris' ),
	                    ),
	                ),
	                'view_all_link' => array(
	                    'title' => esc_html__('View All Button Link', 'ceris' ),
	                    'description' => esc_html__( 'Insert the link for the View All button', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-view-all',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                'view_all_text' => array(
	                    'title' => esc_html__('View All Button Text', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-view-all',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                'view_all_target' => array(
	                    'title' => esc_html__('Target', 'ceris'),
	                    'optionclass' => 'option-tab-1 ceris-view-all',
	                    'field' => 'select',
	                    'default' => '_blank',
	                    'options' => array(
	                        '_blank'   => esc_html__( 'Open link in new tab', 'ceris' ),
	                        '_self'    => esc_html__( 'Open link in current tab', 'ceris' ),
	                    ),
	                ),
                    'bookmark' => array(
                        'title' => esc_html__('Bookmark', 'ceris'),
                        'description' => esc_html__( 'Allow bookmark buttons in this module', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'field' => 'select',
                        'default' => 'off',
                        'options' => array(
                            'on'   => esc_html__( 'On', 'ceris' ),
                            'off'    => esc_html__( 'Off', 'ceris' ),
                        ),
                    ),
	                'custom_class' => array(
	                    'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
	                    'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                // Tab 2
	                'limit' => array(
	                    'title' => esc_html__('Number of Posts', 'ceris' ),
	                    'description' => esc_html__( 'Enter the number of posts (Should be divisible by 3. Default: 6.)', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'number',
	                    'default' => 6
	                ),
	                'offset' => array(
	                    'title' => esc_html__('Offset', 'ceris' ),
	                    'description' => esc_html__( 'Enter the offset number', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'number',
	                    'default' => 0
	                ),
	                'feature' => array(
	                    'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
	                    'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'select',
	                    'default' => 'no',
	                    'options' => array(
	                        'no' => esc_html__( 'No', 'ceris' ),
	                        'yes' => esc_html__( 'Yes', 'ceris' ),
	                    ),
	                ),
	                'orderby' => array(
	                    'title' => esc_html__('Order By', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'select',
	                    'default' => 'date',
	                    'options' => array(
	                        'date'              => esc_html__( 'Latest Posts', 'ceris' ),
	                        'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
	                        'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
	                        'top_review'        => esc_html__( 'Best Review', 'ceris' ),
	                        'modified'          => esc_html__( 'Modified', 'ceris' ),
	                        'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
	                        'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
	                        'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
	                    ),
	                ), 
	                'tags' => array(
	                    'title' => esc_html__('Tags', 'ceris' ),
	                    'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                'category' => array(
	                    'title' => esc_html__('Category', 'ceris' ),
	                    'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'category',
	                    'default' => '0',
	                ),
	                // Tab 3
	                'editor_pick' => array(
	                    'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
	                    'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must Pick the Video Posts', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                'editor_exclude' => array(
	                    'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
	                    'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                // Tab 4
	                'post_source' => array(
	                    'title' => esc_html__('Show only Post Type', 'ceris' ),
	                    'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
	                    'field' => 'select',
	                    'default' => 'all',
	                    'options' => array(
	                        'all'        => esc_html__( 'All', 'ceris' ),
	                        'video'      => esc_html__( 'Video', 'ceris' ),
	                        'gallery'    => esc_html__( 'Gallery', 'ceris' ),
	                        'review'     => esc_html__( 'Review', 'ceris' ),
	                    ),
	                ),    
	                'post_icon' => array(
	                    'title' => esc_html__('Post Icon', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
	                    'field' => 'select',
	                    'default' => 'disable',
	                    'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
	                        'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
	                    ),
	                ),
	                'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
	            ),
	        ),
	        'posts_listing_grid_b_no_sidebar' => array(
	            'title' => esc_html__( 'Posts Listing Grid B', 'ceris' ),
	            'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ceris_update_2.png',
	            'tabdisable' => 'tab-option-6',
	            'tabnames'  => array(
	                'tab-1' => 'General',
	                'tab-2' => 'Query Option',
	                'tab-3' => 'Manually Pick Post',
	                'tab-4' => 'Post Type',
	                'tab-5' => 'Spacing',
	            ),
	            'options' => array(
	                // Tab 1
	                'title' => array(
	                    'title' => esc_html__('Title', 'ceris' ),
	                    'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
	                'ajax_load_more' => array(
	                    'title' => esc_html__('Ajax Load More', 'ceris'),
	                    'description' => esc_html__( 'Select an Ajax Load More Type', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-ajax-load-more',
	                    'field' => 'select',
	                    'default' => 'disable',
	                    'options' => array(
	                        'disable' => esc_html__( 'Disable', 'ceris' ),
	                        'pagination' => esc_html__( 'Ajax Pagination', 'ceris' ),
	                        'loadmore' => esc_html__( 'Ajax Load More Button', 'ceris' ),
	                        'infinity' => esc_html__( 'Ajax Infinity Scrolling', 'ceris' ),
	                        'viewall' => esc_html__( 'View All Button', 'ceris' ),
	                    ),
	                ),
	                'view_all_link' => array(
	                    'title' => esc_html__('View All Button Link', 'ceris' ),
	                    'description' => esc_html__( 'Insert the link for the View All button', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-view-all',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                'view_all_text' => array(
	                    'title' => esc_html__('View All Button Text', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-view-all',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                'view_all_target' => array(
	                    'title' => esc_html__('Target', 'ceris'),
	                    'optionclass' => 'option-tab-1 ceris-view-all',
	                    'field' => 'select',
	                    'default' => '_blank',
	                    'options' => array(
	                        '_blank'   => esc_html__( 'Open link in new tab', 'ceris' ),
	                        '_self'    => esc_html__( 'Open link in current tab', 'ceris' ),
	                    ),
	                ),
                    'bookmark' => array(
                        'title' => esc_html__('Bookmark', 'ceris'),
                        'description' => esc_html__( 'Allow bookmark buttons in this module', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'field' => 'select',
                        'default' => 'off',
                        'options' => array(
                            'on'   => esc_html__( 'On', 'ceris' ),
                            'off'    => esc_html__( 'Off', 'ceris' ),
                        ),
                    ),
	                'custom_class' => array(
	                    'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
	                    'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                // Tab 2
	                'limit' => array(
	                    'title' => esc_html__('Number of Posts', 'ceris' ),
	                    'description' => esc_html__( 'Enter the number of posts (Should be divisible by 3. Default: 6.)', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'number',
	                    'default' => 6
	                ),
	                'offset' => array(
	                    'title' => esc_html__('Offset', 'ceris' ),
	                    'description' => esc_html__( 'Enter the offset number', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'number',
	                    'default' => 0
	                ),
	                'feature' => array(
	                    'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
	                    'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'select',
	                    'default' => 'no',
	                    'options' => array(
	                        'no' => esc_html__( 'No', 'ceris' ),
	                        'yes' => esc_html__( 'Yes', 'ceris' ),
	                    ),
	                ),
	                'orderby' => array(
	                    'title' => esc_html__('Order By', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'select',
	                    'default' => 'date',
	                    'options' => array(
	                        'date'              => esc_html__( 'Latest Posts', 'ceris' ),
	                        'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
	                        'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
	                        'top_review'        => esc_html__( 'Best Review', 'ceris' ),
	                        'modified'          => esc_html__( 'Modified', 'ceris' ),
	                        'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
	                        'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
	                        'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
	                    ),
	                ), 
	                'tags' => array(
	                    'title' => esc_html__('Tags', 'ceris' ),
	                    'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                'category' => array(
	                    'title' => esc_html__('Category', 'ceris' ),
	                    'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
	                    'optionclass' => 'option-tab-2',
	                    'field' => 'category',
	                    'default' => '0',
	                ),
	                // Tab 3
	                'editor_pick' => array(
	                    'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
	                    'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must Pick the Video Posts', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                'editor_exclude' => array(
	                    'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
	                    'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
	                    'optionclass' => 'option-tab-3',
	                    'field' => 'text',
	                    'default' => '',
	                ),
	                // Tab 4
	                'post_source' => array(
	                    'title' => esc_html__('Show only Post Type', 'ceris' ),
	                    'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
	                    'field' => 'select',
	                    'default' => 'all',
	                    'options' => array(
	                        'all'        => esc_html__( 'All', 'ceris' ),
	                        'video'      => esc_html__( 'Video', 'ceris' ),
	                        'gallery'    => esc_html__( 'Gallery', 'ceris' ),
	                        'review'     => esc_html__( 'Review', 'ceris' ),
	                    ),
	                ),    
	                'post_icon' => array(
	                    'title' => esc_html__('Post Icon', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
	                    'field' => 'select',
	                    'default' => 'disable',
	                    'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
	                        'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
	                    ),
	                ),
	                'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
	            ),
	        ),
            'posts_listing_grid_c_no_sidebar' => array(
				'title' => esc_html__( 'Posts Listing Grid C', 'ceris' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ceris_33.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Spacing',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
                    'content_show_hide' => array(
                        'title' => esc_html__('Post Content Show/Hide', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'field' => 'select',
                        'default' => 'always_show',
                        'options' => array(
                            'always_show'       => esc_html__( 'Content always show', 'ceris' ),
                            'show_on_hover'     => esc_html__( 'Hide and Show on hover', 'ceris' ),
                        ),
                    ),
                    'ajax_load_more' => array(
						'title' => esc_html__('Ajax Load More', 'ceris'),
                        'description' => esc_html__( 'Select an Ajax Load More Type', 'ceris' ),
						'optionclass' => 'option-tab-1 ceris-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'ceris' ),
                            'pagination' => esc_html__( 'Ajax Pagination', 'ceris' ),
                            'loadmore' => esc_html__( 'Ajax Load More Button', 'ceris' ),
                            'infinity' => esc_html__( 'Ajax Infinity Scrolling', 'ceris' ),
                            'viewall' => esc_html__( 'View All Button', 'ceris' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'ceris' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'ceris' ),
                        'optionclass' => 'option-tab-1 ceris-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ceris-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'ceris'),
						'optionclass' => 'option-tab-1 ceris-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'ceris' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'ceris' ),
						),
					),
                    'bookmark' => array(
                        'title' => esc_html__('Bookmark', 'ceris'),
                        'description' => esc_html__( 'Allow bookmark buttons in this module', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'field' => 'select',
                        'default' => 'off',
                        'options' => array(
                            'on'   => esc_html__( 'On', 'ceris' ),
                            'off'    => esc_html__( 'Off', 'ceris' ),
                        ),
                    ),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'ceris' ),
						'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 7
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
                            'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'ceris' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
                            'top_review'        => esc_html__( 'Best Review', 'ceris' ),
                            'modified'          => esc_html__( 'Modified', 'ceris' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must Pick the Video Posts', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'ceris' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
                            'gallery'    => esc_html__( 'Gallery', 'ceris' ),
                            'review'     => esc_html__( 'Review', 'ceris' ),
						),
					),    
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'ceris' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
						),
					), 
	                'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
            ),
            'posts_listing_grid_d_no_sidebar' => array(
				'title' => esc_html__( 'Posts Listing Grid D', 'ceris' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ceris_34.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Spacing',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
                    'content_show_hide' => array(
                        'title' => esc_html__('Post Content Show/Hide', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'field' => 'select',
                        'default' => 'always_show',
                        'options' => array(
                            'always_show'       => esc_html__( 'Content always show', 'ceris' ),
                            'show_on_hover'     => esc_html__( 'Hide and Show on hover', 'ceris' ),
                        ),
                    ),
                    'ajax_load_more' => array(
						'title' => esc_html__('Ajax Load More', 'ceris'),
                        'description' => esc_html__( 'Select an Ajax Load More Type', 'ceris' ),
						'optionclass' => 'option-tab-1 ceris-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'ceris' ),
                            'pagination' => esc_html__( 'Ajax Pagination', 'ceris' ),
                            'loadmore' => esc_html__( 'Ajax Load More Button', 'ceris' ),
                            'infinity' => esc_html__( 'Ajax Infinity Scrolling', 'ceris' ),
                            'viewall' => esc_html__( 'View All Button', 'ceris' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'ceris' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'ceris' ),
                        'optionclass' => 'option-tab-1 ceris-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ceris-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'ceris'),
						'optionclass' => 'option-tab-1 ceris-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'ceris' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'ceris' ),
						),
					),
                    'bookmark' => array(
                        'title' => esc_html__('Bookmark', 'ceris'),
                        'description' => esc_html__( 'Allow bookmark buttons in this module', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'field' => 'select',
                        'default' => 'off',
                        'options' => array(
                            'on'   => esc_html__( 'On', 'ceris' ),
                            'off'    => esc_html__( 'Off', 'ceris' ),
                        ),
                    ),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'ceris' ),
						'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 6
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
                            'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'ceris' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
                            'top_review'        => esc_html__( 'Best Review', 'ceris' ),
                            'modified'          => esc_html__( 'Modified', 'ceris' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must Pick the Video Posts', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'ceris' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
                            'gallery'    => esc_html__( 'Gallery', 'ceris' ),
                            'review'     => esc_html__( 'Review', 'ceris' ),
						),
					),    
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'ceris' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
						),
					), 
	                'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
            ),
            'posts_listing_grid_e_no_sidebar' => array(
				'title' => esc_html__( 'Posts Listing Grid E', 'ceris' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ceris_35.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Spacing',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
                    'ajax_load_more' => array(
						'title' => esc_html__('Ajax Load More', 'ceris'),
                        'description' => esc_html__( 'Select an Ajax Load More Type', 'ceris' ),
						'optionclass' => 'option-tab-1 ceris-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'ceris' ),
                            'pagination' => esc_html__( 'Ajax Pagination', 'ceris' ),
                            'loadmore' => esc_html__( 'Ajax Load More Button', 'ceris' ),
                            'infinity' => esc_html__( 'Ajax Infinity Scrolling', 'ceris' ),
                            'viewall' => esc_html__( 'View All Button', 'ceris' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'ceris' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'ceris' ),
                        'optionclass' => 'option-tab-1 ceris-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ceris-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'ceris'),
						'optionclass' => 'option-tab-1 ceris-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'ceris' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'ceris' ),
						),
					),
                    'bookmark' => array(
                        'title' => esc_html__('Bookmark', 'ceris'),
                        'description' => esc_html__( 'Allow bookmark buttons in this module', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'field' => 'select',
                        'default' => 'off',
                        'options' => array(
                            'on'   => esc_html__( 'On', 'ceris' ),
                            'off'    => esc_html__( 'Off', 'ceris' ),
                        ),
                    ),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'ceris' ),
						'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 6
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
                            'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'ceris' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
                            'top_review'        => esc_html__( 'Best Review', 'ceris' ),
                            'modified'          => esc_html__( 'Modified', 'ceris' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must Pick the Video Posts', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'ceris' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
                            'gallery'    => esc_html__( 'Gallery', 'ceris' ),
                            'review'     => esc_html__( 'Review', 'ceris' ),
						),
					),    
                    'post_icon' => array(
						'title' => esc_html__('Post Icon', 'ceris' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'disable',
						'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
						),
					), 
	                'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
            ),
            'posts_listing_grid_f_no_sidebar' => array(
				'title' => esc_html__( 'Posts Listing Grid F', 'ceris' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ceris_42.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Spacing',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
                    'ajax_load_more' => array(
						'title' => esc_html__('Ajax Load More', 'ceris'),
                        'description' => esc_html__( 'Select an Ajax Load More Type', 'ceris' ),
						'optionclass' => 'option-tab-1 ceris-ajax-load-more',
                        'field' => 'select',
						'default' => 'disable',
						'options' => array(
							'disable' => esc_html__( 'Disable', 'ceris' ),
                            'pagination' => esc_html__( 'Ajax Pagination', 'ceris' ),
                            'loadmore' => esc_html__( 'Ajax Load More Button', 'ceris' ),
                            'infinity' => esc_html__( 'Ajax Infinity Scrolling', 'ceris' ),
                            'viewall' => esc_html__( 'View All Button', 'ceris' ),
						),
					),
                    'view_all_link' => array(
						'title' => esc_html__('View All Button Link', 'ceris' ),
						'description' => esc_html__( 'Insert the link for the View All button', 'ceris' ),
                        'optionclass' => 'option-tab-1 ceris-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_text' => array(
						'title' => esc_html__('View All Button Text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ceris-view-all',
						'field' => 'text',
						'default' => '',
					),
                    'view_all_target' => array(
						'title' => esc_html__('Target', 'ceris'),
						'optionclass' => 'option-tab-1 ceris-view-all',
                        'field' => 'select',
						'default' => '_blank',
						'options' => array(
							'_blank'   => esc_html__( 'Open link in new tab', 'ceris' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'ceris' ),
						),
					),
                    'bookmark' => array(
                        'title' => esc_html__('Bookmark', 'ceris'),
                        'description' => esc_html__( 'Allow bookmark buttons in this module', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'field' => 'select',
                        'default' => 'off',
                        'options' => array(
                            'on'   => esc_html__( 'On', 'ceris' ),
                            'off'    => esc_html__( 'Off', 'ceris' ),
                        ),
                    ),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 2
                    'limit' => array(
						'title' => esc_html__('Number of Posts', 'ceris' ),
						'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'number',
						'default' => 6
					),
                    'offset' => array(
						'title' => esc_html__('Offset', 'ceris' ),
						'description' => esc_html__( 'Enter the offset number', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'number',
						'default' => 0
					),
                    'feature' => array(
						'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'select',
						'default' => 'no',
						'options' => array(
							'no' => esc_html__( 'No', 'ceris' ),
                            'yes' => esc_html__( 'Yes', 'ceris' ),
						),
					),
                    'orderby' => array(
						'title' => esc_html__('Order By', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
						'default' => 'date',
						'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'ceris' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
                            'top_review'        => esc_html__( 'Best Review', 'ceris' ),
                            'modified'          => esc_html__( 'Modified', 'ceris' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
						),
					), 
                    'tags' => array(
						'title' => esc_html__('Tags', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-2',
                        'field' => 'category',
						'default' => '0',
					),
                    // Tab 3
                    'editor_pick' => array(
						'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must Pick the Video Posts', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    'editor_exclude' => array(
						'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
						'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'text',
						'default' => '',
					),
                    // Tab 4
                    'post_source' => array(
						'title' => esc_html__('Show only Post Type', 'ceris' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'ceris' ),
                        'optionclass' => 'option-tab-4',
						'field' => 'select',
						'default' => 'all',
						'options' => array(
                            'all'        => esc_html__( 'All', 'ceris' ),
							'video'      => esc_html__( 'Video', 'ceris' ),
                            'gallery'    => esc_html__( 'Gallery', 'ceris' ),
                            'review'     => esc_html__( 'Review', 'ceris' ),
						),
					), 
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
            ),
            'authors_list' => array(
				'title' => esc_html__( 'Authors List', 'ceris' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ce_22.png',
                'tabdisable' => 'tab-option-4 tab-option-5 tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Custom Class',
                    'tab-3' => 'Spacing',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
					'author_id' => array(
						'title' => esc_html__('Author', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate ID by a space. e.g. 1,2,3,4', 'ceris' ),
						'optionclass' => 'option-tab-1',
                        'field' => 'text',
						'default' => '',
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					//tab 3
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-3',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-3',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
            ),
            'category_tiles' => array(
				'title' => esc_html__( 'Category Tiles', 'ceris' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ce_21.png',
                'tabdisable' => 'tab-option-4 tab-option-5 tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Custom Class',
                    'tab-3' => 'Spacing',
                ),
				'options' => array(
                    // Tab 1
                    'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
					'category' => array(
						'title' => esc_html__('Category', 'ceris' ),
						'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
						'optionclass' => 'option-tab-1',
                        'field' => 'category',
						'default' => '0',
					),
                    'category_description' => array(
						'title' => esc_html__('Category Description', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'select',
						'default' => 'post-count',
						'options' => array(
                            'description'       => esc_html__( 'Category Description', 'ceris' ),
                            'post-count'        => esc_html__( 'Post Count', 'ceris' ),
                            'disable'           => esc_html__( 'Disable', 'ceris' ),
						),
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'text',
						'default' => '',
					),
					//tab 3
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-3',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-3',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-3',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
            ),
            /* end ceris */
            'video_slider' => array(
				'title' => esc_html__( 'Video Slider', 'ceris'),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/videoSlider.png',
                'tabdisable' => 'tab-option-3 tab-option-4 tab-option-5 tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'Video Config Panel',
                    'tab-2' => 'Spacing',
                ),
				'options' => array(
                    'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'video_1' => array(
						'title' => esc_html__('Youtube Link - 1', 'ceris' ),
						'description' => esc_html__( 'Put your youtube link ', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
					'video_img_1' => array(
						'title' => esc_html__('Video Image 1', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'description' => esc_html__( 'Upload video image here', 'ceris' ),
                        'field' => 'image',
						'default' => '',
					),
					'video_2' => array(
						'title' => esc_html__('Youtube Link - 2', 'ceris' ),
						'description' => esc_html__( 'Put your youtube link ', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
					'video_img_2' => array(
						'title' => esc_html__('Video Image 2', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'description' => esc_html__( 'Upload video image here', 'ceris' ),
                        'field' => 'image',
						'default' => '',
					),
					'video_3' => array(
						'title' => esc_html__('Youtube Link - 3', 'ceris' ),
						'description' => esc_html__( 'Put your youtube link ', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
					'video_img_3' => array(
						'title' => esc_html__('Video Image 3', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'description' => esc_html__( 'Upload video image here', 'ceris' ),
                        'field' => 'image',
						'default' => '',
					),
					'video_4' => array(
						'title' => esc_html__('Youtube Link - 4', 'ceris' ),
						'description' => esc_html__( 'Put your youtube link ', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
					'video_img_4' => array(
						'title' => esc_html__('Video Image 4', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'description' => esc_html__( 'Upload video image here', 'ceris' ),
                        'field' => 'image',
						'default' => '',
					),
					'video_5' => array(
						'title' => esc_html__('Youtube Link - 5', 'ceris' ),
						'description' => esc_html__( 'Put your youtube link ', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
					'video_img_5' => array(
						'title' => esc_html__('Video Image 5', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'description' => esc_html__( 'Upload video image here', 'ceris' ),
                        'field' => 'image',
						'default' => '',
					),
					//tab 2
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-2',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-2',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
			), 
            'custom_html' => array(
				'title' => esc_html__( 'Custom HTML', 'ceris'),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/51.png',
                'tabdisable' => 'tab-option-3 tab-option-4 tab-option-5 tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'HTML Config Panel',
                    'tab-2' => 'Spacing',
                ),
				'options' => array(
                    'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
                    'custom_html' => array(
						'title' => esc_html__('HTML Code', 'ceris'),
						'description' => esc_html__( 'Put your custom HTML code here', 'ceris'),
						'field' => 'textarea',
						'optionclass' => 'option-tab-1',
						'default' => '',
					),
                    'custom_class' => array(
						'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
						'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
					//tab 2
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-2',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-2',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
				),
			), 
            'shortcode' => array(
				'title' => esc_html__( 'Short Code', 'ceris'),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/52.png',
                'tabdisable' => 'tab-option-3 tab-option-4 tab-option-5 tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'Shortcode Config Panel',
                    'tab-2' => 'Spacing',
                ),
				'options' => array(
                    'title' => array(
						'title' => esc_html__('Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
                    'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
                    'shortcode' => array(
						'title' => esc_html__('Shortcode -- separated by [shortcode_separator]', 'ceris'),
						'description' => esc_html__( 'Put Shortcode here -- the shortcodes are separated by [shortcode_separator] -- eg: [shortcode1]  [shortcode_separator]  [shortcode2]', 'ceris'),
						'field' => 'textarea',
						'optionclass' => 'option-tab-1',
						'default' => '',
					),
					//tab 2
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-2',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-2',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-2',
                    	'field' => 'range_slider_positive',	
                    	'default' => 50,
                    ),
				),
			), 
        );
		wp_localize_script( 'bk-composer-script', 'bk_fullwidth_modules', $modules );
        $modules = array(

            /* begin ceris */
            'posts_listing_list' => array(
                'title' => esc_html__( 'Posts Listing List A', 'ceris' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ceris_8.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Spacing',
                    
                ),
                'options' => array(
                    // Tab 1
                    'title' => array(
                        'title' => esc_html__('Title', 'ceris' ),
                        'description' => esc_html__( 'Insert the title text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'field' => 'text',
                        'default' => '',
                    ),
                    'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
                    'ajax_load_more' => array(
                        'title' => esc_html__('Ajax Load More', 'ceris'),
                        'description' => esc_html__( 'Select an Ajax Load More Type', 'ceris' ),
                        'optionclass' => 'option-tab-1 ceris-ajax-load-more',
                        'field' => 'select',
                        'default' => 'disable',
                        'options' => array(
                            'disable' => esc_html__( 'Disable', 'ceris' ),
                            'pagination' => esc_html__( 'Ajax Pagination', 'ceris' ),
                            'loadmore' => esc_html__( 'Ajax Load More Button', 'ceris' ),
                            'infinity' => esc_html__( 'Ajax Infinity Scrolling', 'ceris' ),
                            'viewall' => esc_html__( 'View All Button', 'ceris' ),
                        ),
                    ),
                    'view_all_link' => array(
                        'title' => esc_html__('View All Button Link', 'ceris' ),
                        'description' => esc_html__( 'Insert the link for the View All button', 'ceris' ),
                        'optionclass' => 'option-tab-1 ceris-view-all',
                        'field' => 'text',
                        'default' => '',
                    ),
                    'view_all_text' => array(
                        'title' => esc_html__('View All Button Text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ceris-view-all',
                        'field' => 'text',
                        'default' => '',
                    ),
                    'view_all_target' => array(
                        'title' => esc_html__('Target', 'ceris'),
                        'optionclass' => 'option-tab-1 ceris-view-all',
                        'field' => 'select',
                        'default' => '_blank',
                        'options' => array(
                            '_blank'   => esc_html__( 'Open link in new tab', 'ceris' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'ceris' ),
                        ),
                    ),
                    'bookmark' => array(
                        'title' => esc_html__('Bookmark', 'ceris'),
                        'description' => esc_html__( 'Allow bookmark buttons in this module', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'field' => 'select',
                        'default' => 'off',
                        'options' => array(
                            'on'   => esc_html__( 'On', 'ceris' ),
                            'off'    => esc_html__( 'Off', 'ceris' ),
                        ),
                    ),
                    'custom_class' => array(
                        'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
                        'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'field' => 'text',
                        'default' => '',
                    ),
                    // Tab 2
                    'limit' => array(
                        'title' => esc_html__('Number of Posts', 'ceris' ),
                        'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
                        'optionclass' => 'option-tab-2',
                        'field' => 'number',
                        'default' => 10
                    ),
                    'offset' => array(
                        'title' => esc_html__('Offset', 'ceris' ),
                        'description' => esc_html__( 'Enter the offset number', 'ceris' ),
                        'optionclass' => 'option-tab-2',
                        'field' => 'number',
                        'default' => 0
                    ),
                    'feature' => array(
                        'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
                        'optionclass' => 'option-tab-2',
                        'field' => 'select',
                        'default' => 'no',
                        'options' => array(
                            'no' => esc_html__( 'No', 'ceris' ),
                            'yes' => esc_html__( 'Yes', 'ceris' ),
                        ),
                    ),
                    'orderby' => array(
                        'title' => esc_html__('Order By', 'ceris' ),
                        'optionclass' => 'option-tab-2',
                        'field' => 'select',
                        'default' => 'date',
                        'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'ceris' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
                            'top_review'        => esc_html__( 'Best Review', 'ceris' ),
                            'modified'          => esc_html__( 'Modified', 'ceris' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
                        ),
                    ), 
                    'tags' => array(
                        'title' => esc_html__('Tags', 'ceris' ),
                        'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
                        'optionclass' => 'option-tab-2',
                        'field' => 'text',
                        'default' => '',
                    ),
                    'category' => array(
                        'title' => esc_html__('Category', 'ceris' ),
                        'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
                        'optionclass' => 'option-tab-2',
                        'field' => 'category',
                        'default' => '0',
                    ),
                    // Tab 3
                    'editor_pick' => array(
                        'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
                        'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must Pick the Video Posts', 'ceris' ),
                        'optionclass' => 'option-tab-3',
                        'field' => 'text',
                        'default' => '',
                    ),
                    'editor_exclude' => array(
                        'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
                        'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
                        'optionclass' => 'option-tab-3',
                        'field' => 'text',
                        'default' => '',
                    ),
                    // Tab 4
                    'post_source' => array(
                        'title' => esc_html__('Show only Post Type', 'ceris' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'ceris' ),
                        'optionclass' => 'option-tab-4',
                        'field' => 'select',
                        'default' => 'all',
                        'options' => array(
                            'all'        => esc_html__( 'All', 'ceris' ),
                            'video'      => esc_html__( 'Video', 'ceris' ),
                            'gallery'    => esc_html__( 'Gallery', 'ceris' ),
                            'review'     => esc_html__( 'Review', 'ceris' ),
                        ),
                    ),    
                    'post_icon' => array(
                        'title' => esc_html__('Post Icon', 'ceris' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
                        'optionclass' => 'option-tab-4',
                        'field' => 'select',
                        'default' => 'disable',
                        'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
                            'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
                        ),
                    ), 
                    'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
                ),
            ),
            'posts_listing_list_b' => array(
                'title' => esc_html__( 'Posts Listing List B', 'ceris' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ceris_9.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Spacing',
                ),
                'options' => array(
                    // Tab 1
                    'title' => array(
                        'title' => esc_html__('Title', 'ceris' ),
                        'description' => esc_html__( 'Insert the title text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'field' => 'text',
                        'default' => '',
                    ),
                    'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
                    'ajax_load_more' => array(
                        'title' => esc_html__('Ajax Load More', 'ceris'),
                        'description' => esc_html__( 'Select an Ajax Load More Type', 'ceris' ),
                        'optionclass' => 'option-tab-1 ceris-ajax-load-more',
                        'field' => 'select',
                        'default' => 'disable',
                        'options' => array(
                            'disable' => esc_html__( 'Disable', 'ceris' ),
                            'pagination' => esc_html__( 'Ajax Pagination', 'ceris' ),
                            'loadmore' => esc_html__( 'Ajax Load More Button', 'ceris' ),
                            'infinity' => esc_html__( 'Ajax Infinity Scrolling', 'ceris' ),
                            'viewall' => esc_html__( 'View All Button', 'ceris' ),
                        ),
                    ),
                    'view_all_link' => array(
                        'title' => esc_html__('View All Button Link', 'ceris' ),
                        'description' => esc_html__( 'Insert the link for the View All button', 'ceris' ),
                        'optionclass' => 'option-tab-1 ceris-view-all',
                        'field' => 'text',
                        'default' => '',
                    ),
                    'view_all_text' => array(
                        'title' => esc_html__('View All Button Text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ceris-view-all',
                        'field' => 'text',
                        'default' => '',
                    ),
                    'view_all_target' => array(
                        'title' => esc_html__('Target', 'ceris'),
                        'optionclass' => 'option-tab-1 ceris-view-all',
                        'field' => 'select',
                        'default' => '_blank',
                        'options' => array(
                            '_blank'   => esc_html__( 'Open link in new tab', 'ceris' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'ceris' ),
                        ),
                    ),
                    'bookmark' => array(
                        'title' => esc_html__('Bookmark', 'ceris'),
                        'description' => esc_html__( 'Allow bookmark buttons in this module', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'field' => 'select',
                        'default' => 'off',
                        'options' => array(
                            'on'   => esc_html__( 'On', 'ceris' ),
                            'off'    => esc_html__( 'Off', 'ceris' ),
                        ),
                    ),
                    'custom_class' => array(
                        'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
                        'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'field' => 'text',
                        'default' => '',
                    ),
                    // Tab 2
                    'limit' => array(
                        'title' => esc_html__('Number of Posts', 'ceris' ),
                        'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
                        'optionclass' => 'option-tab-2',
                        'field' => 'number',
                        'default' => 10
                    ),
                    'offset' => array(
                        'title' => esc_html__('Offset', 'ceris' ),
                        'description' => esc_html__( 'Enter the offset number', 'ceris' ),
                        'optionclass' => 'option-tab-2',
                        'field' => 'number',
                        'default' => 0
                    ),
                    'feature' => array(
                        'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
                        'optionclass' => 'option-tab-2',
                        'field' => 'select',
                        'default' => 'no',
                        'options' => array(
                            'no' => esc_html__( 'No', 'ceris' ),
                            'yes' => esc_html__( 'Yes', 'ceris' ),
                        ),
                    ),
                    'orderby' => array(
                        'title' => esc_html__('Order By', 'ceris' ),
                        'optionclass' => 'option-tab-2',
                        'field' => 'select',
                        'default' => 'date',
                        'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'ceris' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
                            'top_review'        => esc_html__( 'Best Review', 'ceris' ),
                            'modified'          => esc_html__( 'Modified', 'ceris' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
                        ),
                    ), 
                    'tags' => array(
                        'title' => esc_html__('Tags', 'ceris' ),
                        'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
                        'optionclass' => 'option-tab-2',
                        'field' => 'text',
                        'default' => '',
                    ),
                    'category' => array(
                        'title' => esc_html__('Category', 'ceris' ),
                        'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
                        'optionclass' => 'option-tab-2',
                        'field' => 'category',
                        'default' => '0',
                    ),
                    // Tab 3
                    'editor_pick' => array(
                        'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
                        'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must Pick the Video Posts', 'ceris' ),
                        'optionclass' => 'option-tab-3',
                        'field' => 'text',
                        'default' => '',
                    ),
                    'editor_exclude' => array(
                        'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
                        'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
                        'optionclass' => 'option-tab-3',
                        'field' => 'text',
                        'default' => '',
                    ),
                    // Tab 4
                    'post_source' => array(
                        'title' => esc_html__('Show only Post Type', 'ceris' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'ceris' ),
                        'optionclass' => 'option-tab-4',
                        'field' => 'select',
                        'default' => 'all',
                        'options' => array(
                            'all'        => esc_html__( 'All', 'ceris' ),
                            'video'      => esc_html__( 'Video', 'ceris' ),
                            'gallery'    => esc_html__( 'Gallery', 'ceris' ),
                            'review'     => esc_html__( 'Review', 'ceris' ),
                        ),
                    ),    
                    'post_icon' => array(
                        'title' => esc_html__('Post Icon', 'ceris' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
                        'optionclass' => 'option-tab-4',
                        'field' => 'select',
                        'default' => 'disable',
                        'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
                            'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
                        ),
                    ), 
                    'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
                ),
            ),
            'posts_listing_list_large_a' => array(
                'title' => esc_html__( 'Posts Listing List Large A', 'ceris' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ceris_10.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Spacing',
                    
                ),
                'options' => array(
                    // Tab 1
                    'title' => array(
                        'title' => esc_html__('Title', 'ceris' ),
                        'description' => esc_html__( 'Insert the title text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'field' => 'text',
                        'default' => '',
                    ),
                    'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
                    'ajax_load_more' => array(
                        'title' => esc_html__('Ajax Load More', 'ceris'),
                        'description' => esc_html__( 'Select an Ajax Load More Type', 'ceris' ),
                        'optionclass' => 'option-tab-1 ceris-ajax-load-more',
                        'field' => 'select',
                        'default' => 'disable',
                        'options' => array(
                            'disable' => esc_html__( 'Disable', 'ceris' ),
                            'pagination' => esc_html__( 'Ajax Pagination', 'ceris' ),
                            'loadmore' => esc_html__( 'Ajax Load More Button', 'ceris' ),
                            'infinity' => esc_html__( 'Ajax Infinity Scrolling', 'ceris' ),
                            'viewall' => esc_html__( 'View All Button', 'ceris' ),
                        ),
                    ),
                    'view_all_link' => array(
                        'title' => esc_html__('View All Button Link', 'ceris' ),
                        'description' => esc_html__( 'Insert the link for the View All button', 'ceris' ),
                        'optionclass' => 'option-tab-1 ceris-view-all',
                        'field' => 'text',
                        'default' => '',
                    ),
                    'view_all_text' => array(
                        'title' => esc_html__('View All Button Text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ceris-view-all',
                        'field' => 'text',
                        'default' => '',
                    ),
                    'view_all_target' => array(
                        'title' => esc_html__('Target', 'ceris'),
                        'optionclass' => 'option-tab-1 ceris-view-all',
                        'field' => 'select',
                        'default' => '_blank',
                        'options' => array(
                            '_blank'   => esc_html__( 'Open link in new tab', 'ceris' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'ceris' ),
                        ),
                    ),
                    'bookmark' => array(
                        'title' => esc_html__('Bookmark', 'ceris'),
                        'description' => esc_html__( 'Allow bookmark buttons in this module', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'field' => 'select',
                        'default' => 'off',
                        'options' => array(
                            'on'   => esc_html__( 'On', 'ceris' ),
                            'off'    => esc_html__( 'Off', 'ceris' ),
                        ),
                    ),
                    'custom_class' => array(
                        'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
                        'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'field' => 'text',
                        'default' => '',
                    ),
                    // Tab 2
                    'limit' => array(
                        'title' => esc_html__('Number of Posts', 'ceris' ),
                        'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
                        'optionclass' => 'option-tab-2',
                        'field' => 'number',
                        'default' => 10
                    ),
                    'offset' => array(
                        'title' => esc_html__('Offset', 'ceris' ),
                        'description' => esc_html__( 'Enter the offset number', 'ceris' ),
                        'optionclass' => 'option-tab-2',
                        'field' => 'number',
                        'default' => 0
                    ),
                    'feature' => array(
                        'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
                        'optionclass' => 'option-tab-2',
                        'field' => 'select',
                        'default' => 'no',
                        'options' => array(
                            'no' => esc_html__( 'No', 'ceris' ),
                            'yes' => esc_html__( 'Yes', 'ceris' ),
                        ),
                    ),
                    'orderby' => array(
                        'title' => esc_html__('Order By', 'ceris' ),
                        'optionclass' => 'option-tab-2',
                        'field' => 'select',
                        'default' => 'date',
                        'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'ceris' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
                            'top_review'        => esc_html__( 'Best Review', 'ceris' ),
                            'modified'          => esc_html__( 'Modified', 'ceris' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
                        ),
                    ), 
                    'tags' => array(
                        'title' => esc_html__('Tags', 'ceris' ),
                        'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
                        'optionclass' => 'option-tab-2',
                        'field' => 'text',
                        'default' => '',
                    ),
                    'category' => array(
                        'title' => esc_html__('Category', 'ceris' ),
                        'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
                        'optionclass' => 'option-tab-2',
                        'field' => 'category',
                        'default' => '0',
                    ),
                    // Tab 3
                    'editor_pick' => array(
                        'title' => esc_html__('Manually Pick Post (By Post IDs)', 'ceris' ),
                        'description' => esc_html__( 'Insert the post IDs here, separated by a comma, Must Pick the Video Posts', 'ceris' ),
                        'optionclass' => 'option-tab-3',
                        'field' => 'text',
                        'default' => '',
                    ),
                    'editor_exclude' => array(
                        'title' => esc_html__('Manually Exclude Posts (By Post IDs)', 'ceris' ),
                        'description' => esc_html__( 'Insert the post IDs here, separated by a comma', 'ceris' ),
                        'optionclass' => 'option-tab-3',
                        'field' => 'text',
                        'default' => '',
                    ),
                    // Tab 4
                    'post_source' => array(
                        'title' => esc_html__('Show only Post Type', 'ceris' ),
                        'description' => esc_html__( 'All - Show All Post Type and Will Not Display Post Icon', 'ceris' ),
                        'optionclass' => 'option-tab-4',
                        'field' => 'select',
                        'default' => 'all',
                        'options' => array(
                            'all'        => esc_html__( 'All', 'ceris' ),
                            'video'      => esc_html__( 'Video', 'ceris' ),
                            'gallery'    => esc_html__( 'Gallery', 'ceris' ),
                            'review'     => esc_html__( 'Review', 'ceris' ),
                        ),
                    ),    
                    'post_icon' => array(
                        'title' => esc_html__('Post Icon', 'ceris' ),
                        'description' => esc_html__( 'Configure Post Icon on This Module', 'ceris' ),
                        'optionclass' => 'option-tab-4',
                        'field' => 'select',
                        'default' => 'disable',
                        'options' => array(
                            'disable'           => esc_html__( 'Disable Post Icon', 'ceris' ),
                            'enable'            => esc_html__( 'Enable Post Icon', 'ceris' ),
                        ),
                    ), 
                    'post_icon_animation' => array(
						'title' => esc_html__('Post Icon Animation', 'ceris' ),
	                    'description' => esc_html__( 'Configure Post Icon Animation on This Module', 'ceris' ),
	                    'optionclass' => 'option-tab-4',
						'field' => 'select',
						'required'    => array('post_icon' => 'enable'),
						'default' => 'disable',
						'options' => array(
	                        'disable'           => esc_html__( 'Disable Post Icon Animation', 'ceris' ),
							'enable'            => esc_html__( 'Enable Post Icon Animation', 'ceris' ),
						),
					),
					//tab 5
                    'module_custom_spacing_option' => array(
						'title' => esc_html__('Module Custom Spacing Option', 'ceris' ),
                        'description' => esc_html__( 'Enable / Disable Custom Spacing of this module', 'ceris' ),
                        'optionclass' => 'option-tab-5',
						'field' => 'select',
                        'options' => array(
                            'disable'    => esc_html__( 'Disable', 'ceris' ),
                            'enable'     => esc_html__( 'Enable', 'ceris' ),
						),
						'default' => 'disable',
					),
                    'module_margin_top' => array(
                    	'title' => esc_html__('Module Margin Top', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider',
                    	'default' => 0,
                    ),
                    'heading_margin_bottom' => array(
                    	'title' => esc_html__('Heading Margin Bottom', 'ceris' ),
                    	'description' => esc_html__( 'Setup to a margin number', 'ceris' ),
                        'required'    => array('module_custom_spacing_option' => 'enable'),
                        'optionclass' => 'option-tab-5',
                    	'field' => 'range_slider_positive',
                    	'default' => 50,
                    ),
                ),
            ),
            'posts_listing_list_large_b' => array(
                'title' => esc_html__( 'Posts Listing List Large B', 'ceris' ),
                'img'   => get_template_directory_uri().'/images/admin_panel/pagebuilder-modules/ceris_11.png',
                'tabdisable' => 'tab-option-6',
                'tabnames'  => array(
                    'tab-1' => 'General',
                    'tab-2' => 'Query Option',
                    'tab-3' => 'Manually Pick Post',
                    'tab-4' => 'Post Type',
                    'tab-5' => 'Spacing',
                    
                ),
                'options' => array(
                    // Tab 1
                    'title' => array(
                        'title' => esc_html__('Title', 'ceris' ),
                        'description' => esc_html__( 'Insert the title text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'field' => 'text',
                        'default' => '',
                    ),
                    'sub_title' => array(
						'title' => esc_html__('Sub Title', 'ceris' ),
						'description' => esc_html__( 'Insert the title text', 'ceris' ),
	                    'optionclass' => 'option-tab-1',
						'field' => 'text',
						'default' => '',
					),
	                'heading_style' => array(
						'title' => esc_html__('Title Style', 'ceris' ),
	                    'optionclass' => 'option-tab-1 ceris-heading-style',
						'field' => 'select',
						'default' => 'default',
						'options' => array(
	                        'default'           => esc_html__( 'Default - From Theme Option', 'ceris' ),
                            'style-1'           => esc_html__( 'Heading Style 1', 'ceris' ),
                            'style-2'           => esc_html__( 'Heading Style 2', 'ceris' ),
                            'style-3'           => esc_html__( 'Heading Style 3', 'ceris' ),
                            'style-4'           => esc_html__( 'Heading Style 4', 'ceris' ),
                            'style-5'           => esc_html__( 'Heading Style 5', 'ceris' ),
                            'style-6'           => esc_html__( 'Heading Style 6', 'ceris' ),
                            'style-7'           => esc_html__( 'Heading Style 7', 'ceris' ),
                            'style-8'           => esc_html__( 'Heading Style 8', 'ceris' ),
                            'style-9'           => esc_html__( 'Heading Style 9', 'ceris' ),
                            'style-10'          => esc_html__( 'Heading Style 10', 'ceris' ),
	                        'line'              => esc_html__( 'Heading Style 11', 'ceris' ),
	                        'no-line'           => esc_html__( 'Heading Style 12', 'ceris' ),
	                        'line-under'        => esc_html__( 'Heading Style 13', 'ceris' ),
	                        'center'            => esc_html__( 'Heading Style 14', 'ceris' ),
	                        'line-around'       => esc_html__( 'Heading Style 15', 'ceris' ),
						),
					),
                    'heading_color' => array(
                        'title' => esc_html__('Heading Color', 'ceris' ),
                        'description' => esc_html__( '[Optional] set the color for the heading text', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'default' => '#222',
                        'field' => 'colorpicker',
                    ),
                    'ajax_load_more' => array(
                        'title' => esc_html__('Ajax Load More', 'ceris'),
                        'description' => esc_html__( 'Select an Ajax Load More Type', 'ceris' ),
                        'optionclass' => 'option-tab-1 ceris-ajax-load-more',
                        'field' => 'select',
                        'default' => 'disable',
                        'options' => array(
                            'disable' => esc_html__( 'Disable', 'ceris' ),
                            'pagination' => esc_html__( 'Ajax Pagination', 'ceris' ),
                            'loadmore' => esc_html__( 'Ajax Load More Button', 'ceris' ),
                            'infinity' => esc_html__( 'Ajax Infinity Scrolling', 'ceris' ),
                            'viewall' => esc_html__( 'View All Button', 'ceris' ),
                        ),
                    ),
                    'view_all_link' => array(
                        'title' => esc_html__('View All Button Link', 'ceris' ),
                        'description' => esc_html__( 'Insert the link for the View All button', 'ceris' ),
                        'optionclass' => 'option-tab-1 ceris-view-all',
                        'field' => 'text',
                        'default' => '',
                    ),
                    'view_all_text' => array(
                        'title' => esc_html__('View All Button Text', 'ceris' ),
                        'optionclass' => 'option-tab-1 ceris-view-all',
                        'field' => 'text',
                        'default' => '',
                    ),
                    'view_all_target' => array(
                        'title' => esc_html__('Target', 'ceris'),
                        'optionclass' => 'option-tab-1 ceris-view-all',
                        'field' => 'select',
                        'default' => '_blank',
                        'options' => array(
                            '_blank'   => esc_html__( 'Open link in new tab', 'ceris' ),
                            '_self'    => esc_html__( 'Open link in current tab', 'ceris' ),
                        ),
                    ),
                    'bookmark' => array(
                        'title' => esc_html__('Bookmark', 'ceris'),
                        'description' => esc_html__( 'Allow bookmark buttons in this module', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'field' => 'select',
                        'default' => 'off',
                        'options' => array(
                            'on'   => esc_html__( 'On', 'ceris' ),
                            'off'    => esc_html__( 'Off', 'ceris' ),
                        ),
                    ),
                    'custom_class' => array(
                        'title' => esc_html__('Custom Class [Should be added to the div wrap of the module]', 'ceris' ),
                        'description' => esc_html__( '[Optional] Separate classes by a space. e.g. class1 class2 class3', 'ceris' ),
                        'optionclass' => 'option-tab-1',
                        'field' => 'text',
                        'default' => '',
                    ),
                    // Tab 2
                    'limit' => array(
                        'title' => esc_html__('Number of Posts', 'ceris' ),
                        'description' => esc_html__( 'Enter the number of posts', 'ceris' ),
                        'optionclass' => 'option-tab-2',
                        'field' => 'number',
                        'default' => 10
                    ),
                    'offset' => array(
                        'title' => esc_html__('Offset', 'ceris' ),
                        'description' => esc_html__( 'Enter the offset number', 'ceris' ),
                        'optionclass' => 'option-tab-2',
                        'field' => 'number',
                        'default' => 0
                    ),
                    'feature' => array(
                        'title' => esc_html__('Display featured posts as highest priority', 'ceris'),
                        'description' => esc_html__( 'Yes: Display featured posts as highest priority', 'ceris' ),
                        'optionclass' => 'option-tab-2',
                        'field' => 'select',
                        'default' => 'no',
                        'options' => array(
                            'no' => esc_html__( 'No', 'ceris' ),
                            'yes' => esc_html__( 'Yes', 'ceris' ),
                        ),
                    ),
                    'orderby' => array(
                        'title' => esc_html__('Order By', 'ceris' ),
                        'optionclass' => 'option-tab-2',
                        'field' => 'select',
                        'default' => 'date',
                        'options' => array(
                            'date'              => esc_html__( 'Latest Posts', 'ceris' ),
                            'comment_count'     => esc_html__( 'Popular Post by Comments', 'ceris' ),
                            'view_count'        => esc_html__( 'Popular Post by Views', 'ceris' ),
                            'top_review'        => esc_html__( 'Best Review', 'ceris' ),
                            'modified'          => esc_html__( 'Modified', 'ceris' ),
                            'speed_reads'       => esc_html__( 'Speed Reads', 'ceris' ),
                            'alphabetical_asc'  => esc_html__( 'Alphabetical A->Z', 'ceris' ),
                            'alphabetical_decs' => esc_html__( 'Alphabetical Z->A', 'ceris' ),
                        ),
                    ), 
                    'tags' => array(
                        'title' => esc_html__('Tags', 'ceris' ),
                        'description' => esc_html__( '[Optional] Separate tags by the comma. e.g. tag1,tag2', 'ceris' ),
                        'optionclass' => 'option-tab-2',
                        'field' => 'text',
                        'default' => '',
                    ),
                    'category' => array(
                        'title' => esc_html__('Category', 'ceris' ),
                        'description' => esc_html__( 'Choose a post category to be shown up', 'ceris' ),
            