function jobsearch_listing_top_map(top_dataobj, is_ajax) {
    var map_id = top_dataobj.map_id,
        map_zoom = top_dataobj.map_zoom,
        this_map_style = top_dataobj.map_style,
        latitude = top_dataobj.latitude,
        longitude = top_dataobj.longitude,
        cluster_icon = top_dataobj.cluster_icon,
        map_cords_list = top_dataobj.cords_list,
        cordsActualLimit = 1000;

    var open_info_window;
    if (latitude != '' && longitude != '') {
        var marker;
        all_marker = [];
        reset_top_map_marker = [];
        var LatLngList = [];

        if (is_ajax != 'true') {
            map_zoom = parseInt(map_zoom);
            if (!jQuery.isNumeric(map_zoom)) {
                map_zoom = 9;
            }
            
            // Initialize Leaflet map
            jobsearch_listing_map = L.map('listings-map-' + map_id, {
                center: [latitude, longitude],
                zoom: map_zoom,
                zoomControl: false,
                scrollWheelZoom: false,
                dragging: true
            });

            // Add OSM tile layer
            L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
                attribution: '&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors'
            }).addTo(jobsearch_listing_map);

            // Add custom zoom controls
            var zoomControl = L.control.zoom({
                position: 'topleft',
                zoomInText: '<i class="fa fa-plus"></i>',
                zoomOutText: '<i class="fa fa-minus"></i>'
            });
            zoomControl.addTo(jobsearch_listing_map);
        } else {
            jobsearch_listing_map.setView([latitude, longitude], map_zoom);
        }

        // Custom map styles would need to be converted to Leaflet equivalent
        // This would typically involve using a different tile provider or custom CSS

        if (typeof map_cords_list === 'object' && map_cords_list.length > 0) {
            var actual_length;
            if (map_cords_list.length > cordsActualLimit) {
                actual_length = cordsActualLimit;
            } else {
                actual_length = map_cords_list.length;
            }

            var def_cords_obj = [];
            var def_cords_creds = [];

            // variables for same lat lng merge
            var ohterLatLonObj = [];
            var sameLatLonObjMajor = [];
            var sameLatLonIndObj = [];

            var sameAddIndex = [];
            var allPostsMajorObj = [];

            jQuery.each(map_cords_list, function (index, element) {
                if (typeof element.lat !== 'undefined' && typeof element.lat != '' && typeof element.long !== 'undefined' && typeof element.long != '') {
                    var other_pos = true;
                    for (var oi = 0; oi < map_cords_list.length; oi++) {
                        if (
                            oi !== index &&
                            sameAddIndex.indexOf(oi) === -1 &&
                            map_cords_list[oi]['lat'] === element.lat &&
                            map_cords_list[oi]['long'] === element.long
                        ) {
                            sameAddIndex.push(oi);
                            other_pos = false;
                        }
                    }
                    if (other_pos === true && sameAddIndex.indexOf(index) === -1) {
                        var thisObj = {
                            obj_type: 'single',
                            lat: element.lat,
                            long: element.long,
                            id: element.id,
                            title: element.title,
                            link: element.link,
                            marker: element.marker,
                            logo_img_url: element.logo_img_url,
                            address: element.address,
                            employer: element.employer,
                            sector: element.sector,
                        };
                        ohterLatLonObj.push(thisObj);
                        allPostsMajorObj.push(thisObj);
                    } else {
                        var sameLatLonObj = [];
                        for (var oi = 0; oi < map_cords_list.length; oi++) {
                            if (map_cords_list[oi]['lat'] === element.lat && map_cords_list[oi]['long'] === element.long && sameLatLonIndObj.indexOf(oi) === -1) {
                                var thisObj = {
                                    lat: map_cords_list[oi]['lat'],
                                    long: map_cords_list[oi]['long'],
                                    id: map_cords_list[oi]['id'],
                                    title: map_cords_list[oi]['title'],
                                    link: map_cords_list[oi]['link'],
                                    marker: map_cords_list[oi]['marker'],
                                    logo_img_url: map_cords_list[oi]['logo_img_url'],
                                    address: map_cords_list[oi]['address'],
                                    employer: map_cords_list[oi]['employer'],
                                    sector: map_cords_list[oi]['sector'],
                                };
                                sameLatLonObj.push(thisObj);
                                sameLatLonIndObj.push(oi);
                            }
                        }
                        if (sameLatLonObj.length > 0) {
                            var thisObj = {
                                obj_type: 'multiple',
                                allObjs: sameLatLonObj,
                            };
                            sameLatLonObjMajor.push(thisObj);
                            allPostsMajorObj.push(thisObj);
                        }
                    }
                }
            });

            // Create a marker cluster group
            var markers = L.markerClusterGroup({
                iconCreateFunction: function(cluster) {
                    var childCount = cluster.getChildCount();
                    return L.divIcon({
                        html: '<div style="background-image: url(' + cluster_icon + '); width: 28px; height: 41px; background-size: cover; display: flex; align-items: center; justify-content: center;"><span style="color: #ffffff; font-size: 12px; margin-top: 5px;">' + childCount + '</span></div>',
                        className: 'marker-cluster',
                        iconSize: L.point(28, 41)
                    });
                }
            });

            jQuery.each(allPostsMajorObj, function (index, element) {
                if (element.obj_type == 'multiple') {
                    if (element.allObjs.length > 0) {
                        var post_lats = [];
                        var post_longs = [];
                        var post_ids = [];
                        var post_titles = [];
                        var post_links = [];
                        var post_markers = [];
                        var post_logo_img_urls = [];
                        var post_addresss = [];
                        var post_employers = [];
                        var post_sectors = [];

                        for (var oi = 0; oi < element.allObjs.length; oi++) {
                            var thisElem = element.allObjs[oi];

                            post_lats.push(thisElem.lat);
                            post_longs.push(thisElem.long);
                            post_ids.push(thisElem.id);
                            post_titles.push(thisElem.title);
                            post_links.push(thisElem.link);
                            post_markers.push(thisElem.marker);
                            post_logo_img_urls.push(thisElem.logo_img_url);
                            post_addresss.push(thisElem.address);
                            post_employers.push(thisElem.employer);
                            post_sectors.push(thisElem.sector);
                        }

                        var thisElemF = element.allObjs[0];

                        if (index === actual_length) {
                            return false;
                        }

                        var db_lat = parseFloat(thisElemF.lat);
                        var db_long = parseFloat(thisElemF.long);
                        var list_title = thisElemF.title;
                        var list_marker = thisElemF.marker;

                        var db_latLng = [db_lat, db_long];
                        LatLngList.push(db_latLng);

                        // Create custom cluster marker
                        var customIcon = L.divIcon({
                            html: '<div style="background-image: url(' + cluster_icon + '); width: 28px; height: 41px; background-size: cover; display: flex; align-items: center; justify-content: center;"><span style="color: #ffffff; font-size: 12px; margin-top: 5px;">' + element.allObjs.length + '</span></div>',
                            className: 'custom-marker',
                            iconSize: [28, 41]
                        });

                        marker = L.marker(db_latLng, {
                            icon: customIcon
                        });

                        // Store additional data
                        marker.post_lats = post_lats;
                        marker.post_longs = post_longs;
                        marker.post_ids = post_ids;
                        marker.post_titles = post_titles;
                        marker.post_links = post_links;
                        marker.post_markers = post_markers;
                        marker.post_logo_img_urls = post_logo_img_urls;
                        marker.post_addresss = post_addresss;
                        marker.post_employers = post_employers;
                        marker.post_sectors = post_sectors;

                        marker.on('click', function(e) {
                            var contentString = '';
                            for (var oi = 0; oi < this.post_ids.length; oi++) {
                                var infoElemObj = {
                                    lat: this.post_lats[oi],
                                    long: this.post_longs[oi],
                                    id: this.post_ids[oi],
                                    title: this.post_titles[oi],
                                    link: this.post_links[oi],
                                    marker: this.post_markers[oi],
                                    logo_img_url: this.post_logo_img_urls[oi],
                                    address: this.post_addresss[oi],
                                    employer: this.post_employers[oi],
                                    sector: this.post_sectors[oi],
                                };

                                contentString += infoContentString(infoElemObj);
                            }

                            if (open_info_window) {
                                jobsearch_listing_map.closePopup();
                            }

                            open_info_window = L.popup()
                                .setLatLng(e.latlng)
                                .setContent('<div class="jobsearch_map_info multi_listings">' + contentString + '</div>')
                                .openOn(jobsearch_listing_map);
                        });

                        markers.addLayer(marker);
                        all_marker.push(marker);
                        reset_top_map_marker.push(marker);
                    }
                } else {
                    if (index === actual_length) {
                        return false;
                    }
                    
                    var db_lat = parseFloat(element.lat);
                    var db_long = parseFloat(element.long);
                    var list_title = element.title;
                    var list_id = element.id;
                    var list_marker = element.marker;
                    var list_marker_hover = element.marker_hover;

                    var db_latLng = [db_lat, db_long];
                    LatLngList.push(db_latLng);

                    // Create custom icon
                    var customIcon = L.icon({
                        iconUrl: list_marker,
                        iconSize: [32, 32], // adjust based on your marker size
                        iconAnchor: [16, 32] // point of the icon which will correspond to marker's location
                    });

                    marker = L.marker(db_latLng, {
                        icon: customIcon,
                        title: list_title
                    });

                    // Store additional data
                    marker.id = list_id;
                    marker.icon_marker = list_marker;
                    marker.icon_marker_hover = list_marker_hover;

                    marker.on('click', function(e) {
                        var contentString = infoContentString(element);

                        if (open_info_window) {
                            jobsearch_listing_map.closePopup();
                        }

                        open_info_window = L.popup()
                            .setLatLng(e.latlng)
                            .setContent('<div class="jobsearch_map_info">' + contentString + '</div>')
                            .openOn(jobsearch_listing_map);
                    });

                    markers.addLayer(marker);
                    all_marker.push(marker);
                    reset_top_map_marker.push(marker);
                }
            });

            // Add markers to map
            jobsearch_listing_map.addLayer(markers);

            // Fit bounds to include all markers
            if (LatLngList.length > 0) {
                var bounds = new L.LatLngBounds(LatLngList);
                jobsearch_listing_map.fitBounds(bounds);
            }

            // Close popup when clicking on map
            jobsearch_listing_map.on('click', function() {
                if (open_info_window) {
                    jobsearch_listing_map.closePopup();
                    open_info_window = null;
                }
            });
        }

        function infoContentString(element) {
            var listing_id = element.id;
            var list_title = element.title;
            var list_link = element.link;
            var list_logo_img_url = element.logo_img_url;
            var list_address = element.address;
            var list_employer = element.employer;
            var list_sector = element.sector;

            var contentString = '\
            <div id="listing-info-' + listing_id + '" class="listing-info-inner">\
                <div class="info-main-container">\
                    ' + (list_logo_img_url != '' ? '<div class="img-con"><img src="' + list_logo_img_url + '" alt=""></div>' : '') + '\
                    <div class="info-txt-holder">\
                        <a class="info-title" href="' + list_link + '">' + list_title + '</a>\
                        <div class="post-secin">' + list_employer + list_sector + '</div>\
                        ' + list_address + '\
                    </div>\
                </div>\
            </div>';

            return contentString;
        }
    }
}