<?php

use WP_Jobsearch\Candidate_Profile_Restriction;
use WP_Jobsearch\Package_Limits;

if (!function_exists('jobsearch_candidate_get_profile_image')) {

    function jobsearch_candidate_get_profile_image($candidate_id)
    {
        $post_thumbnail_id = '';
        if (isset($candidate_id) && $candidate_id != '' && has_post_thumbnail($candidate_id)) {
            $post_thumbnail_id = get_post_thumbnail_id($candidate_id);
        }
        return $post_thumbnail_id;
    }

}

if (!function_exists('jobsearch_candidate_get_company_name')) {

    function jobsearch_candidate_get_company_name($candidate_id, $before_title = '', $after_title = '') {
        $company_name_str = '';
        $candidate_field_user = get_post_meta($candidate_id, 'jobsearch_field_candidate_posted_by', true);
        if (isset($candidate_field_user) && $candidate_field_user != '') {
            $company_name_str = '<a href="' . get_permalink($candidate_field_user) . '">' . $before_title . get_the_title($candidate_field_user) . $after_title . '</a>';
        }
        return $company_name_str;
    }

}

function jobsearch_add_field_label_tooltip($label = '', $help_textopt_key = '', $help_text = '', $label_tag = 'label') {
    ob_start();
    $help_text_str = '';
    if ($help_text != '') {
        $help_text_str = $help_text;
    } else if ($help_textopt_key != '') {
        global $jobsearch_plugin_options;
        $help_text_str = isset($jobsearch_plugin_options[$help_textopt_key]) ? $jobsearch_plugin_options[$help_textopt_key] : '';
    }
    if ($help_text_str != '') {
        ?>
        <div class="jobsearch-labl-with-tooltip">
            <?php echo '<' . $label_tag . '>' . $label . '</' . $label_tag . '>'; ?>
            <span class="help-icon-con jobsearch-tooltipcon" title="<?php echo ($help_text_str) ?>"><i class="fa fa-question-circle"></i></span>
        </div>
        <?php
    } else {
        echo '<' . $label_tag . '>' . $label . '</' . $label_tag . '>';
    }
    $html = ob_get_clean();
    return $html;
}

add_action('jobsearch_user_data_save_onprofile', 'jobsearch_user_data_save_onprofile', 10, 3);

function jobsearch_user_data_save_onprofile($user_id, $post_id, $post_type = 'candidate')
{

    $allow_fields = array(
        'jobsearch_field_user_phone',
        'jobsearch_field_candidate_jobtitle',
        'jobsearch_field_candidate_salary',
        'jobsearch_field_user_facebook_url',
        'jobsearch_field_user_twitter_url',
        'jobsearch_field_user_google_plus_url',
        'jobsearch_field_user_linkedin_url',
        'jobsearch_field_user_dribbble_url',
        'jobsearch_field_location_address',
    );

    $cand_custom_fields = get_option('jobsearch_custom_field_candidate');
    if (is_array($cand_custom_fields) && sizeof($cand_custom_fields) > 0) {
        $field_names_counter = 0;
        foreach ($cand_custom_fields as $f_key => $custom_field_saved_data) {
            $cusfield_name = isset($custom_field_saved_data['name']) ? $custom_field_saved_data['name'] : '';
            if ($cusfield_name != '') {
                $allow_fields[] = $cusfield_name;
            }
        }
    }

    $emp_custom_fields = get_option('jobsearch_custom_field_employer');
    if (is_array($emp_custom_fields) && sizeof($emp_custom_fields) > 0) {
        $field_names_counter = 0;
        foreach ($emp_custom_fields as $f_key => $custom_field_saved_data) {
            $cusfield_name = isset($custom_field_saved_data['name']) ? $custom_field_saved_data['name'] : '';
            if ($cusfield_name != '') {
                $allow_fields[] = $cusfield_name;
            }
        }
    }

    $allow_fields = apply_filters('jobsearch_user_metadata_saving_list', $allow_fields);

    	

    $user_obj = get_user_by('ID', $user_id);
    if (isset($user_obj->ID) && get_post_type($post_id) == $post_type) {
        foreach ($allow_fields as $meta_key) {
            $meta_val = get_post_meta($post_id, $meta_key, true);
            update_user_meta($user_id, $meta_key, $meta_val);
        }
    }
    
    //
}

function jobsearch_candidate_img_url_comn($candidate_id, $dimen = '150')
{
    $user_id = jobsearch_get_candidate_user_id($candidate_id);
    $user_gravatar_url = get_avatar_url($user_id, array('size' => 132));
    $user_avatar_dburl = get_post_meta($candidate_id, 'jobsearch_user_avatar_url', true);
    
    $user_def_avatar_url = '';
    if (isset($user_avatar_dburl['file_url']) && $user_avatar_dburl['file_url'] != '') {
        $user_img_name = $user_avatar_dburl['file_name'];
        $user_img_path = $user_avatar_dburl['file_path'];
        $filetype = $user_avatar_dburl['mime_type'];
        $file_ext = isset($filetype['ext']) ? $filetype['ext'] : 'png';
        $img_150_path = $user_img_path . '/user-img-150.' . $file_ext;
        $user_def_avatar_url = isset($user_avatar_dburl['orig_file_url']) ? $user_avatar_dburl['orig_file_url'] : '';
        $user_def_avatar_url = apply_filters('wp_jobsearch_cand_profile_img_url', $user_def_avatar_url, $candidate_id, $dimen);
    } else {
        $user_avatar_id = get_post_thumbnail_id($candidate_id);
        if ($user_avatar_id > 0) {
            $user_has_cimg = true;
            $def_img_size = 'thumbnail';
            $def_img_size = apply_filters('jobsearch_cand_dashside_pimg_size', $def_img_size);
            $user_thumbnail_image = wp_get_attachment_image_src($user_avatar_id, $def_img_size);
            $user_def_avatar_url = isset($user_thumbnail_image[0]) && esc_url($user_thumbnail_image[0]) != '' ? $user_thumbnail_image[0] : '';
        }
    }
    if ($user_def_avatar_url == '') {
        $user_def_avatar_url = $user_gravatar_url != '' ? $user_gravatar_url : jobsearch_candidate_image_placeholder();
    }
    return $user_def_avatar_url;
}

function jobsearch_candidate_covr_url_comn($candidate_id)
{
    global $jobsearch_plugin_options;
    $user_cover_img_url = '';
    $user_avatar_dburl = get_post_meta($candidate_id, 'jobsearch_user_cover_imge', true);
    if (isset($user_avatar_dburl['file_url']) && $user_avatar_dburl['file_url'] != '') {
        $user_cover_img_url = $user_avatar_dburl['file_url'];
        $user_cover_img_url = apply_filters('wp_jobsearch_cand_ccovr_img_url', $user_cover_img_url, $candidate_id);
    } else if (class_exists('JobSearchMultiPostThumbnails')) {
        $cover_image_src = JobSearchMultiPostThumbnails::get_post_thumbnail_url('candidate', 'cover-image', $candidate_id);
        if ($cover_image_src != '') {
            $user_cover_img_url = $cover_image_src;
        }
    }
    if ($user_cover_img_url == '') {
        $user_cover_img_url = isset($jobsearch_plugin_options['cand_default_coverimg']['url']) && $jobsearch_plugin_options['cand_default_coverimg']['url'] != '' ? $jobsearch_plugin_options['cand_default_coverimg']['url'] : '';
    }

    return $user_cover_img_url;
}

add_action('jobsearch_user_dash_instart_act', 'jobsearch_cand_movepimg_cover_sett', 15, 1);

function jobsearch_cand_movepimg_cover_sett($user_id)
{
    $user_is_candidate = jobsearch_user_is_candidate($user_id);
    if ($user_is_candidate) {
        $candidate_id = jobsearch_get_user_candidate_id($user_id);
        global $jobsearch_uploding_candimg, $jobsearch_download_locations;
        $jobsearch_download_locations = false;
        $jobsearch_uploding_candimg = true;
        add_filter('jobsearch_candimg_upload_dir', 'jobsearch_upload_candimg_path', 10, 1);

        $cand_thumb_id = get_post_thumbnail_id($candidate_id);
        $full_image = wp_get_attachment_image_src($cand_thumb_id, 'full');
        if (isset($full_image[0]) && $full_image[0] != '') {
            $img_path = get_attached_file($cand_thumb_id);
            $wp_upload_dir = wp_upload_dir();
            $img_url = $full_image[0];
            $img_base_name = basename($img_url);
            $filetype = wp_check_filetype($img_base_name, null);
            $file_ext = isset($filetype['ext']) ? $filetype['ext'] : '';
            $uplod_direc_path = $wp_upload_dir['path'];
            $uplod_direc_url = $wp_upload_dir['url'];
            $img_new_path = $uplod_direc_path . '/' . $img_base_name;
            @copy($img_path, $img_new_path);
            $new_img_url = $uplod_direc_url . '/' . $img_base_name;
            $file_uniqid = jobsearch_get_unique_folder_byurl($new_img_url);

            // image crop
            $crop_file_url = '';
            $image_editor = wp_get_image_editor($img_new_path);
            if (!is_wp_error($image_editor)) {

                $image_editor->resize(150, 150, true);

                $crop_file_name = $uplod_direc_path . '/user-img-150.' . $file_ext;
                $image_editor->save($crop_file_name);

                //
                $image_350 = wp_get_image_editor($img_new_path);
                $image_350->resize(350, 450, true);
                $crop_file_name = $uplod_direc_path . '/user-img-350.' . $file_ext;
                $image_350->save($crop_file_name);
                //

                $crop_file_url = $uplod_direc_url . '/user-img-150.' . $file_ext;
            }
            // end cropping

            $fileuplod_time = current_time('timestamp');

            $arg_arr = array(
                'file_name' => $img_base_name,
                'mime_type' => $filetype,
                'time' => $fileuplod_time,
                'orig_file_url' => $new_img_url,
                'file_url' => $crop_file_url,
                'file_path' => $uplod_direc_path,
                'file_id' => $file_uniqid,
            );
            update_post_meta($candidate_id, 'jobsearch_user_avatar_url', $arg_arr);

            wp_delete_attachment($cand_thumb_id, true);
        }
        if (class_exists('JobSearchMultiPostThumbnails')) {
            $cover_image_src = JobSearchMultiPostThumbnails::get_post_thumbnail_url('candidate', 'cover-image', $candidate_id);
            if ($cover_image_src != '') {
                $user_cover_img_url = $cover_image_src;
                $cover_image_id = JobSearchMultiPostThumbnails::get_post_thumbnail_id('candidate', 'cover-image', $candidate_id);

                $img_path = get_attached_file($cover_image_id);
                $wp_upload_dir = wp_upload_dir();
                $img_url = $user_cover_img_url;
                $img_base_name = basename($img_url);
                $uplod_direc_path = $wp_upload_dir['path'];
                $uplod_direc_url = $wp_upload_dir['url'];
                $img_new_path = $uplod_direc_path . '/' . $img_base_name;
                @copy($img_path, $img_new_path);
                $new_img_url = $uplod_direc_url . '/' . $img_base_name;
                $file_uniqid = jobsearch_get_unique_folder_byurl($new_img_url);

                $filetype = wp_check_filetype($img_base_name, null);
                $fileuplod_time = current_time('timestamp');

                $arg_arr = array(
                    'file_name' => $img_base_name,
                    'mime_type' => $filetype,
                    'time' => $fileuplod_time,
                    'file_url' => $new_img_url,
                    'file_path' => $uplod_direc_path,
                    'file_id' => $file_uniqid,
                );
                update_post_meta($candidate_id, 'jobsearch_user_cover_imge', $arg_arr);

                wp_delete_attachment($cover_image_id, true);
            }
        }
        remove_filter('jobsearch_candimg_upload_dir', 'jobsearch_upload_candimg_path', 10, 1);
    }
}

add_action('jobsearch_candidate_update_bkend_all_fileds', 'jobsearch_candidate_update_bkend_status_update');

function jobsearch_candidate_update_bkend_status_update($candidate_id) {
    
    // WPML compatible
    if (function_exists('icl_object_id') && function_exists('wpml_init_language_switcher')) {
        global $sitepress, $wpdb;

        $current_lang = $sitepress->get_current_language();

        $wpml_all_langs = icl_get_languages();
        if (!empty($wpml_all_langs)) {
            $_status = get_post_meta($candidate_id, 'jobsearch_field_candidate_approved', true);
            
            foreach ($wpml_all_langs as $lang_code => $wpml_lang) {
                if ($lang_code != $current_lang) {
                    $trans_candidate_id = icl_object_id($candidate_id, 'candidate', false, $lang_code);
                    
                    update_post_meta($trans_candidate_id, 'jobsearch_field_candidate_approved', $_status);
                }
            }
        }
    }
}

add_filter( 'kses_allowed_protocols', 'jobsearch_kses_allowed_protocols', 10, 1 );
               
function jobsearch_kses_allowed_protocols( $protocols ) {
    $protocols[] = 'data';
    return $protocols;
}

add_filter('wp_jobsearch_cand_profile_img_url', 'wp_jobsearch_user_profile_img_url', 10, 3);

function wp_jobsearch_user_profile_img_url($url, $candidate_id = '', $size = '150')
{

    $user_id = jobsearch_get_candidate_user_id($candidate_id);
    $user_gravatar_url = get_avatar_url($user_id, array('size' => 132));
    $url = $user_gravatar_url != '' ? $user_gravatar_url : jobsearch_candidate_image_placeholder();

    $attach_id = $candidate_id;
    if ($attach_id != '') {
        $attach_size = $size;
        if ($attach_id > 0 && get_post_type($attach_id) == 'candidate') {

            $user_avatar_dburl = get_post_meta($attach_id, 'jobsearch_user_avatar_url', true);
            if (isset($user_avatar_dburl['file_url']) && $user_avatar_dburl['file_url'] != '') {

                require_once(ABSPATH . 'wp-admin/includes/file.php');
                WP_Filesystem();
                global $wp_filesystem;

                $folder_path = $user_avatar_dburl['file_path'];
                $user_def_avatar_url = isset($user_avatar_dburl['orig_file_url']) ? jobsearch_url_str_reomve_http($user_avatar_dburl['orig_file_url']) : '';

                $file_name = $user_avatar_dburl['file_name'];
                $filetype = $user_avatar_dburl['mime_type'];
                $file_ext = isset($filetype['ext']) ? $filetype['ext'] : 'png';
                if (!$file_ext) {
                    $file_ext = 'jpg';
                }

                $site_url = get_site_url() . '/';
                $site_url_str = jobsearch_url_str_reomve_http($site_url);

                if ($attach_size == 'full') {
                    $file_path = $folder_path . '/' . $file_name;
                    if ($user_def_avatar_url != '') {
                        $file_path = str_replace($site_url_str, ABSPATH, $user_def_avatar_url);
                    }
                } else {
                    $file_path = $folder_path . '/user-img-150.' . $file_ext;
                    //var_dump($file_path);
                    if (!file_exists($file_path)) {
                        $file_path = str_replace($site_url_str, ABSPATH, $user_def_avatar_url);
                    }
                    //var_dump($file_path);
                }

                $data = @$wp_filesystem->get_contents($file_path);
                $imge_base64 = 'data:image/' . $file_ext . ';base64,' . base64_encode($data);
                return $imge_base64;
            }
        }
    }

    return $url;
}

function jobsearch_url_str_reomve_http($url) {
    $url = str_replace(array('https:', 'http:'), array('', ''), $url);

    return $url;
}

add_filter('wp_jobsearch_cand_ccovr_img_url', 'wp_jobsearch_user_ccover_img_url', 10, 2);

function wp_jobsearch_user_ccover_img_url($url, $candidate_id = '')
{

    global $jobsearch_plugin_options;
    $user_coverimg_url = $user_cover_img_url = isset($jobsearch_plugin_options['cand_default_coverimg']['url']) && $jobsearch_plugin_options['cand_default_coverimg']['url'] != '' ? $jobsearch_plugin_options['cand_default_coverimg']['url'] : '';
    $url = $user_coverimg_url;

    $attach_id = $candidate_id;
    if ($attach_id != '') {
        if ($attach_id > 0 && get_post_type($attach_id) == 'candidate') {

            $user_avatar_dburl = get_post_meta($attach_id, 'jobsearch_user_cover_imge', true);
            if (isset($user_avatar_dburl['file_url']) && $user_avatar_dburl['file_url'] != '') {

                require_once(ABSPATH . 'wp-admin/includes/file.php');
                WP_Filesystem();
                global $wp_filesystem;

                $folder_path = $user_avatar_dburl['file_path'];
                $file_name = $user_avatar_dburl['file_name'];
                $filetype = $user_avatar_dburl['mime_type'];
                $file_ext = isset($filetype['ext']) ? $filetype['ext'] : 'png';

                $file_path = $folder_path . '/' . $file_name;

                $data = @$wp_filesystem->get_contents($file_path);
                $imge_base64 = 'data:image/' . $file_ext . ';base64,' . base64_encode($data);
                return $imge_base64;
            }
        }
    }

    return $url;
}

function jobsearch_candidate_detail_whatsapp_btn($candidate_id, $view = 'view_1')
{

    global $jobsearch_plugin_options;

    $cand_profile_restrict = new Candidate_Profile_Restriction;

    $cand_whatsapp_msgallow = isset($jobsearch_plugin_options['cand_whatsapp_msgallow']) ? $jobsearch_plugin_options['cand_whatsapp_msgallow'] : '';
    $cand_whatsapp_defmsg = isset($jobsearch_plugin_options['cand_whatsapp_defmsg']) ? $jobsearch_plugin_options['cand_whatsapp_defmsg'] : '';

    $user_phone = get_post_meta($candidate_id, 'jobsearch_field_user_phone', true);

    if ($user_phone != '' && $cand_whatsapp_msgallow == 'on') {
        $message = $cand_whatsapp_defmsg;
        if (!$cand_profile_restrict::cand_field_is_locked('profile_fields|phone', 'detail_page')) {
            ?>
            <div class="jobsearch-whatsapp-msgcon jobsearch_whatsap_<?php echo($view) ?>">
                <a href="https://wa.me/<?php echo jobsearch_esc_html($user_phone) ?>?text=<?php echo urlencode($message) ?>"
                   target="_blank">
                    <i class="fa fa-whatsapp"></i>
                    <small><?php esc_html_e('WhatsApp', 'wp-jobsearch') ?></small>
                </a>
            </div>
            <?php
        }
    }
}

add_filter('jobsearch_candidate_listing_item_title', 'jobsearch_candidate_listing_item_title', 10, 2);

function jobsearch_candidate_listing_item_title($title = '', $candidate_id = 0)
{

    $cand_profile_restrict = new Candidate_Profile_Restriction;
    if ($cand_profile_restrict::cand_field_is_locked('profile_fields|display_name', 'page', $candidate_id)) {
        $title = $cand_profile_restrict::cand_restrict_display_name($candidate_id);
    }
    return $title;
}

function jobsearch_get_candidate_salary_format($candidate_id = 0, $price = 0, $cur_tag = '')
{
    
    global $jobsearch_currencies_list, $jobsearch_plugin_options;
    $post_custom_currency_switch = isset($jobsearch_plugin_options['job_custom_currency']) ? $jobsearch_plugin_options['job_custom_currency'] : '';
    $candidate_currency = get_post_meta($candidate_id, 'jobsearch_field_candidate_salary_currency', true);
    $candidate_currency = jobsearch_esc_html($candidate_currency);
    if ($candidate_currency != 'default' && $post_custom_currency_switch == 'on') {
        $candidate_currency = isset($jobsearch_currencies_list[$candidate_currency]['symbol']) ? $jobsearch_currencies_list[$candidate_currency]['symbol'] : jobsearch_get_currency_symbol();
    } else {
        $candidate_currency = 'default';
    }
    $cur_pos = get_post_meta($candidate_id, 'jobsearch_field_candidate_salary_pos', true);
    $candidate_salary_sep = get_post_meta($candidate_id, 'jobsearch_field_candidate_salary_sep', true);
    $candidate_salary_deci = get_post_meta($candidate_id, 'jobsearch_field_candidate_salary_deci', true);

    $cur_pos = jobsearch_esc_html($cur_pos);
    $candidate_salary_sep = jobsearch_esc_html($candidate_salary_sep);
    $candidate_salary_deci = jobsearch_esc_html($candidate_salary_deci);

    $candidate_salary_deci = $candidate_salary_deci < 10 ? absint($candidate_salary_deci) : 2;
    
    $decimal_sep = isset($jobsearch_plugin_options['jobsearch_cur_decimal_separator']) && $jobsearch_plugin_options['jobsearch_cur_decimal_separator'] != '' ? $jobsearch_plugin_options['jobsearch_cur_decimal_separator'] : '.';

    if ($candidate_currency == 'default') {
        $ret_price = jobsearch_get_price_format($price, '', 'candidate');
    } else {
        $price = $price > 0 ? $price : 0;
        $price = preg_replace("/[^0-9.,]+/iu", "", $price);
        $price = str_replace(array(','), array('.'), $price);
        
        $price_exp = explode('.', $price);
        if (!empty($price_exp) && count($price_exp) > 2) {
            $price = str_replace(array('.'), array(''), $price);
        }
        
        if ($price == '') {
            $price = 0;
        }
        
        if ($cur_pos == 'left_space') {
            $ret_price = ($cur_tag != '' ? '<' . $cur_tag . '>' : '') . $candidate_currency . ' ' . ($cur_tag != '' ? '</' . $cur_tag . '>' : '') . number_format($price, $candidate_salary_deci, $decimal_sep, $candidate_salary_sep);
        } else if ($cur_pos == 'right') {
            $ret_price = number_format($price, $candidate_salary_deci, $decimal_sep, $candidate_salary_sep) . ($cur_tag != '' ? '<' . $cur_tag . '>' : '') . $candidate_currency . ($cur_tag != '' ? '</' . $cur_tag . '>' : '');
        } else if ($cur_pos == 'right_space') {
            $ret_price = number_format($price, $candidate_salary_deci, $decimal_sep, $candidate_salary_sep) . ($cur_tag != '' ? '<' . $cur_tag . '>' : '') . ' ' . $candidate_currency . ($cur_tag != '' ? '</' . $cur_tag . '>' : '');
        } else {
            $ret_price = ($cur_tag != '' ? '<' . $cur_tag . '>' : '') . $candidate_currency . ($cur_tag != '' ? '</' . $cur_tag . '>' : '') . number_format($price, $candidate_salary_deci, $decimal_sep, $candidate_salary_sep);
        }
    }
    return $ret_price;
}

if (!function_exists('jobsearch_candidate_current_salary')) {

    function jobsearch_candidate_current_salary($id, $before_str = '', $after_str = '', $cur_tag = '')
    {
        global $jobsearch_plugin_options, $sitepress;

        $lang_code = '';
        if (function_exists('icl_object_id') && function_exists('wpml_init_language_switcher')) {
            $lang_code = $sitepress->get_current_language();
        }

        $post_salary_types = isset($jobsearch_plugin_options['job-salary-types']) ? $jobsearch_plugin_options['job-salary-types'] : '';

        $salary_str = $before_str;
        $_post_salary_type = get_post_meta($id, 'jobsearch_field_candidate_salary_type', true);
        $_candidate_salary = get_post_meta($id, 'jobsearch_field_candidate_salary', true);

        $_candidate_salary = jobsearch_esc_html($_candidate_salary);

        $salary_type_val_str = '';
        if (!empty($post_salary_types)) {
            $slar_type_count = 1;
            foreach ($post_salary_types as $post_salary_typ) {
                $post_salary_typ = apply_filters('wpml_translate_single_string', $post_salary_typ, 'JobSearch Options', 'Salary Type - ' . $post_salary_typ, $lang_code);
                if ($_post_salary_type == 'type_' . $slar_type_count) {
                    $salary_type_val_str = $post_salary_typ;
                }
                $slar_type_count++;
            }
        }

        if ($_candidate_salary != '') {
            $salary_str .= jobsearch_get_candidate_salary_format($id, $_candidate_salary, $cur_tag) . ($salary_type_val_str != '' ? ' / ' . $salary_type_val_str : '');
        }
        $salary_str .= $after_str;
        return $salary_str;
    }

}

add_action('wp_ajax_jobsearch_candash_load_portfolio_html_call', 'jobsearch_candash_load_portfolio_html_call');

function jobsearch_candash_load_portfolio_html_call() {

    $nonce_val = sanitize_key(wp_unslash($_POST['_nonce']));
    if (!wp_verify_nonce($nonce_val, 'jobsearch_ajax_nonce')) {
        $msg = esc_html__('You are not allowed to do this.', 'wp-jobsearch');
        echo json_encode(array('msg' => $msg, 'error' => '1'));
        die;
    }
    
    $user_id = get_current_user_id();

    $candidate_id = jobsearch_get_user_candidate_id($user_id);

    ob_start();

    $script_data = '';

    $exfield_list_val = get_post_meta($candidate_id, 'jobsearch_field_portfolio_image', true);
    if (is_array($exfield_list_val) && sizeof($exfield_list_val) > 0) {

        $exfield_counter = 0;
        foreach ($exfield_list_val as $exfield) {

            $portfolio_img = $exfield;

            $portfolio_img_src = jobsearch_get_cand_portimg_url($candidate_id, $portfolio_img);
            $script_data .= 'jQuery("#cand-portfolio-img-' . $exfield_counter . '").css({"background-image": "url(\'' . $portfolio_img_src . '\')"}); jQuery("#cand-portfolio-upd-img-' . $exfield_counter . '").attr("src", "' . $portfolio_img_src . '");';
            $exfield_counter++;
        }
    }
    $script_data = apply_filters('jobsearch_portfolio_imgs_lodhtml_script_data', $script_data, $candidate_id);
    if ($script_data != '') {
        ?>
        <script>
            <?php echo ($script_data) ?>
        </script>
        <?php
    }
    $html = ob_get_clean();
    
    wp_send_json(array('html' => $html));
}

if (!function_exists('jobsearch_candidate_age')) {

    function jobsearch_candidate_age($id)
    {
        global $jobsearch_plugin_options;

        $dob_dd = get_post_meta($id, 'jobsearch_field_user_dob_dd', true);
        $dob_mm = get_post_meta($id, 'jobsearch_field_user_dob_mm', true);
        $dob_yy = get_post_meta($id, 'jobsearch_field_user_dob_yy', true);

        //
        if ($dob_dd != '' && $dob_mm != '' && $dob_yy != '') {
            $dob_yy = str_replace('-', '', $dob_yy);
            if ($dob_yy > date('Y')) {
                $dob_yy = date('Y');
            }
            //date in mm/dd/yyyy format; or it can be in other formats as well
            $birthDate = "{$dob_mm}/{$dob_dd}/{$dob_yy}";
            //explode the date to get month, day and year
            $birthDate = explode("/", $birthDate);
            //get age from date or birthdate
            $age = (date("md", date("U", mktime(0, 0, 0, $birthDate[0], $birthDate[1], $birthDate[2]))) > date("md") ? ((date("Y") - $birthDate[2]) - 1) : (date("Y") - $birthDate[2]));
            return $age;
        }

        $current_year = date('Y');
        if ($dob_yy > 0 && $dob_yy < $current_year) {
            $age = ($current_year - $dob_yy);
            return $age;
        }
    }

}

function jobsearch_detail_common_ad_code($args = array())
{
    global $jobsearch_plugin_options;
    if (isset($args['post_type']) && $args['post_type'] != '' && isset($args['position']) && $args['position'] != '') {
        $option_name = $args['post_type'] . '_detail_adcode_' . $args['position'];
        
        ob_start();
        if (isset($jobsearch_plugin_options[$option_name]) && $jobsearch_plugin_options[$option_name] != '') {
            ?>
            <div class="jobsearch-det-adver-wrap <?php echo(isset($args['view']) && $args['view'] != '' ? $args['post_type'] . '_' . $args['position'] . '_' . $args['view'] : '') ?>">
                <div class="detail-adver-codecon">
                    <?php echo do_shortcode($jobsearch_plugin_options[$option_name]); ?>
                </div>
            </div>
            <?php
        }
        $ad_html = ob_get_clean();
        echo apply_filters('jobsearch_detail_common_ad_code_html', $ad_html, $args);
    }
}

add_action('wp_ajax_jobsearch_userreg_form_after_nonce', 'jobsearch_logreg_forms_add_nonce');
add_action('wp_ajax_nopriv_jobsearch_userreg_form_after_nonce', 'jobsearch_logreg_forms_add_nonce');

function jobsearch_logreg_forms_add_nonce()
{

    $allow_args = array(
        'input' => array(
            'name' => array(),
            'value' => array(),
            'type' => array(),
        ),
    );

    $form_type = 'register-security';
    if (isset($_POST['secure_form']) && $_POST['secure_form'] != '') {
        $form_type = $_POST['secure_form'];
    }

    ob_start();
    wp_nonce_field('ajax-login-nonce', $form_type);
    $secur_field = ob_get_clean();
    echo wp_kses($secur_field, $allow_args);

    die;
}

if (!function_exists('jobsearch_candidate_get_all_candidatetypes')) {

    function jobsearch_candidate_get_all_candidatetypes($candidate_id, $link_class = 'jobsearch-option-btn', $before_title = '', $after_title = '', $before_tag = '', $after_tag = '')
    {
        $candidate_type = wp_get_post_terms($candidate_id, 'candidatetype');
        ob_start();
        $html = '';
        if (!empty($candidate_type)) {
            $link_class_str = '';
            if ($link_class != '') {
                $link_class_str = 'class="' . $link_class . '"';
            }
            echo($before_tag);
            foreach ($candidate_type as $term) :
                $candidatetype_color = get_term_meta($term->term_id, 'jobsearch_field_candidatetype_color', true);
                $candidatetype_textcolor = get_term_meta($term->term_id, 'jobsearch_field_candidatetype_textcolor', true);
                $candidatetype_color_str = '';
                if ($candidatetype_color != '') {
                    $candidatetype_color_str = 'style="background-color: ' . esc_attr($candidatetype_color) . '; color: ' . esc_attr($candidatetype_textcolor) . ' "';
                }
                ?>
                <a <?php echo($link_class_str) ?> <?php echo($candidatetype_color_str); ?>>
                    <?php
                    echo($before_title);
                    echo esc_html($term->name);
                    echo($after_title);
                    ?>
                </a>
            <?php
            endforeach;
            echo($after_tag);
        }
        $html .= ob_get_clean();
        return $html;
    }

}

if (!function_exists('jobsearch_candidate_not_allow_to_mod')) {

    function jobsearch_candidate_not_allow_to_mod($user_id = 0)
    {
        global $jobsearch_plugin_options;
        if ($user_id <= 0 && is_user_logged_in()) {
            $user_id = get_current_user_id();
        }
        $user_is_candidate = jobsearch_user_is_candidate($user_id);
        if ($user_is_candidate) {
            $demo_user_login = isset($jobsearch_plugin_options['demo_user_login']) ? $jobsearch_plugin_options['demo_user_login'] : '';
            $demo_user_mod = isset($jobsearch_plugin_options['demo_user_mod']) ? $jobsearch_plugin_options['demo_user_mod'] : '';
            $demo_candidate = isset($jobsearch_plugin_options['demo_candidate']) ? $jobsearch_plugin_options['demo_candidate'] : '';
            $_demo_user_obj = get_user_by('login', $demo_candidate);
            $_demo_user_id = isset($_demo_user_obj->ID) ? $_demo_user_obj->ID : '';
            if ($user_id == $_demo_user_id && $demo_user_login == 'on' && $demo_user_mod != 'on') {
                return true;
            }
        }
        return false;
    }

}

if (!function_exists('jobsearch_candidate_get_all_sectors')) {

    function jobsearch_candidate_get_all_sectors($candidate_id, $link_class = '', $before_title = '', $after_title = '', $before_tag = '', $after_tag = '')
    {

        $sectors = wp_get_post_terms($candidate_id, 'sector');
        ob_start();
        $html = '';
        if (!empty($sectors)) {
            $term_ids_arr = array();
            $link_class_str = '';
            if ($link_class != '') {
                $link_class_str = 'class="' . $link_class . '"';
            }
            echo($before_tag);
            $flag = 0;
            foreach ($sectors as $term) :
                $term_id = isset($term->term_id) ? $term->term_id : '';

                if (in_array($term_id, $term_ids_arr)) {
                    continue;
                }

                $term_ids_arr[] = $term_id;

                if ($flag > 0) {
                    echo ", ";
                }
                ?>
                <a class="<?php echo($link_class) ?>">
                    <?php
                    echo($before_title);
                    echo esc_html($term->name);
                    echo($after_title);
                    ?>
                </a>
                <?php
                $flag++;
            endforeach;
            echo($after_tag);
        }
        $html .= ob_get_clean();
        return $html;
    }

}

if (!function_exists('jobsearch_candidate_views_count')) {

    function jobsearch_candidate_views_count($postID)
    {
        $jobsearch_candidate_views_count = get_post_meta($postID, "jobsearch_candidate_views_count", true);
        if ($jobsearch_candidate_views_count == '') {
            $jobsearch_candidate_views_count = 0;
        }
        if (!isset($_COOKIE["jobsearch_candidate_views_count" . $postID])) {
            setcookie("jobsearch_candidate_views_count" . $postID, time() + 86400);
            $jobsearch_candidate_views_count = $jobsearch_candidate_views_count + 1;
            update_post_meta($postID, 'jobsearch_candidate_views_count', $jobsearch_candidate_views_count);
        }
    }

}

function jobsearch_post_city_contry_txtstr($post_id, $is_country = true, $is_state = false, $is_city = true, $is_full_address = false)
{
    global $jobsearch_plugin_options, $sitepress;

    $all_locations_type = isset($jobsearch_plugin_options['all_locations_type']) ? $jobsearch_plugin_options['all_locations_type'] : '';

    $post_location_txt = '';

    $get_post_city = get_post_meta($post_id, 'jobsearch_field_location_location4', true);
    $get_post_city = jobsearch_esc_html($get_post_city);
    if ($get_post_city == '') {
        $get_post_city = get_post_meta($post_id, 'jobsearch_field_location_location3', true);
        $get_post_city = jobsearch_esc_html($get_post_city);
    }

    $get_post_state = get_post_meta($post_id, 'jobsearch_field_location_location2', true);
    $get_post_country = get_post_meta($post_id, 'jobsearch_field_location_location1', true);
    $full_address = get_post_meta($post_id, 'jobsearch_field_location_address', true);

    $get_post_state = jobsearch_esc_html($get_post_state);
    $get_post_country = jobsearch_esc_html($get_post_country);
    $full_address = jobsearch_esc_html($full_address);

    if ($all_locations_type == 'api') {
        $retrn_arr = array();
        if ($get_post_city != '' && $is_city) {
            $retrn_arr[] = $get_post_city;
        }
        if ($get_post_state != '' && $is_state) {
            $retrn_arr[] = $get_post_state;
        }
        if ($get_post_country != '' && $is_country) {
            $retrn_arr[] = $get_post_country;
        }
        if ($full_address != '' && $is_full_address) {
            $retrn_arr[] = $full_address;
        }
        if (!empty($retrn_arr)) {
            $post_location_txt = implode(', ', $retrn_arr);
        }
    } else {
        if (function_exists('icl_object_id') && function_exists('wpml_init_language_switcher')) {
            $sitepress_def_lang = $sitepress->get_default_language();
            $sitepress_curr_lang = $sitepress->get_current_language();

            //$sitepress->switch_lang($sitepress_def_lang, true);
        }
        $post_country_tax = $get_post_country != '' ? jobsearch_get_custom_term_by('slug', $get_post_country, 'job-location') : '';
        $post_state_tax = $get_post_state != '' ? jobsearch_get_custom_term_by('slug', $get_post_state, 'job-location') : '';
        $post_city_tax = $get_post_city != '' ? jobsearch_get_custom_term_by('slug', $get_post_city, 'job-location') : '';
        if (function_exists('icl_object_id') && function_exists('wpml_init_language_switcher')) {
            //$sitepress->switch_lang($sitepress_curr_lang, true);
            //var_dump($sitepress->get_current_language());
            if (is_object($post_city_tax) && isset($post_city_tax->term_id) && $is_city) {
                $get_post_cityid = $post_city_tax->term_id;
                $get_post_cityid = apply_filters('wpml_object_id', $get_post_cityid, 'job-location', true);
                $post_city_tax = jobsearch_get_custom_term_by('term_id', $get_post_cityid, 'job-location');
            }
            if (is_object($post_state_tax) && isset($post_state_tax->term_id) && $is_state) {
                $get_post_stateid = $post_state_tax->term_id;
                $get_post_stateid = apply_filters('wpml_object_id', $get_post_stateid, 'job-location', true);
                $post_state_tax = jobsearch_get_custom_term_by('term_id', $get_post_stateid, 'job-location');
            }
            if (is_object($post_country_tax) && isset($post_country_tax->term_id) && $is_country) {
                $get_post_contryid = $post_country_tax->term_id;
                $get_post_contryid = apply_filters('wpml_object_id', $get_post_contryid, 'job-location', true);
                $post_country_tax = jobsearch_get_custom_term_by('term_id', $get_post_contryid, 'job-location');
            }
        }

        $retrn_arr = array();
        if (is_object($post_city_tax) && isset($post_city_tax->name) && $is_city) {
            $retrn_arr[] = $post_city_tax->name;
        }
        if (is_object($post_state_tax) && isset($post_state_tax->name) && $is_state) {
            $retrn_arr[] = $post_state_tax->name;
        }
        if (is_object($post_country_tax) && isset($post_country_tax->name) && $is_country) {
            $retrn_arr[] = $post_country_tax->name;
        }
        if ($full_address != '' && $is_full_address) {
            $retrn_arr[] = $full_address;
        }
        if (!empty($retrn_arr)) {
            $post_location_txt = implode(', ', $retrn_arr);
        }
    }

    if ($post_location_txt == '') {
        $post_location_txt = get_post_meta($post_id, 'jobsearch_field_location_address', true);
        $post_location_txt = jobsearch_esc_html($post_location_txt);
    }

    return stripslashes(urldecode($post_location_txt));
}

if (!function_exists('jobsearch_get_candidate_item_count')) {

    function jobsearch_get_candidate_item_count($left_filter_count_switch, $count_posts_in, $count_arr, $candidate_short_counter, $field_meta_key, $open_house = '')
    {
        global $wpdb;

        $total_num = 0;
        if ($left_filter_count_switch == 'yes') {
            if (!empty($count_posts_in) && is_array($count_posts_in)) {

                if (isset($count_arr[0]['key']) && $count_arr[0]['key'] != '' && !isset($count_arr[1]['key'])) {
                    $count_arr_o = $count_arr[0];
                    $get_meta_cond = get_meta_condition($count_arr_o);
                    $meta_post_ids = $wpdb->get_col("SELECT post_id FROM $wpdb->postmeta WHERE {$get_meta_cond}");
                    if (!empty($meta_post_ids)) {
                        $to_countmeta_arr = array_intersect($count_posts_in, $meta_post_ids);
                        $total_num = !empty($to_countmeta_arr) ? count($to_countmeta_arr) : 0;
                    }
                } else if (isset($count_arr[0]['type']) && $count_arr[0]['type'] == 'numeric' && isset($count_arr[1]['key'])) {
                    $count_arr_o = $count_arr[0];
                    $count_arr_1 = $count_arr[1];
                    $the_meta_key = $count_arr_o['key'];
                    $from_meta_val = $count_arr_o['value'];
                    $to_meta_val = $count_arr_1['value'];
                    $meta_post_ids = $wpdb->get_col("SELECT post_id FROM $wpdb->postmeta WHERE meta_key='{$the_meta_key}' AND meta_value BETWEEN {$from_meta_val} AND {$to_meta_val}");
                    if (!empty($meta_post_ids)) {
                        $to_countmeta_arr = array_intersect($count_posts_in, $meta_post_ids);
                        $total_num = !empty($to_countmeta_arr) ? count($to_countmeta_arr) : 0;
                    }
                } else {
                    $total_num = !empty($count_posts_in) ? count($count_posts_in) : 0;
                }
            }
        }
        return $total_num;
    }

    function jobsearch_get_candidate_item_count_depricate($left_filter_count_switch, $args, $count_arr, $candidate_short_counter, $field_meta_key, $open_house = '')
    {
        if ($left_filter_count_switch == 'yes') {
            global $jobsearch_shortcode_candidates_frontend;

            // get all arguments from getting flters
            $left_filter_arr = array();
            $left_filter_arr = $jobsearch_shortcode_candidates_frontend->get_filter_arg($candidate_short_counter, $field_meta_key);
            if (!empty($count_arr)) {
                // check if count array has multiple condition
                foreach ($count_arr as $count_arr_single) {
                    $left_filter_arr[] = $count_arr_single;
                }
            }

            $post_ids = '';
            if (!empty($left_filter_arr)) {
                // apply all filters and get ids
                $post_ids = $jobsearch_shortcode_candidates_frontend->get_candidate_id_by_filter($left_filter_arr);
            }

            if (isset($_REQUEST['location']) && $_REQUEST['location'] != '' && !isset($_REQUEST['loc_polygon_path'])) {
                $post_ids = $jobsearch_shortcode_candidates_frontend->candidate_location_filter($post_ids);
                if (empty($post_ids)) {
                    $post_ids = array(0);
                }
            }

            $all_post_ids = $post_ids;
            if (!empty($all_post_ids)) {
                $args['post__in'] = $all_post_ids;
            }

            $args = apply_filters('jobsearch_candidates_listing_filter_args', $args);

            $restaurant_loop_obj = jobsearch_get_cached_obj('candidate_result_cached_loop_count_obj', $args, 12, false, 'wp_query');
            $restaurant_totnum = $restaurant_loop_obj->found_posts;
            return $restaurant_totnum;
        }
    }

}

if (!function_exists('jobsearch_candidate_skills_set_array')) {

    function jobsearch_candidate_skills_set_array()
    {

        $skills_array = array(
            'jobsearch_display_name' => array(
                'name' => esc_html__('Full Name', 'wp-jobsearch'),
            ),
            'jobsearch_user_img' => array(
                'name' => esc_html__('Profile Image', 'wp-jobsearch'),
            ),
            'jobsearch_post_title' => array(
                'name' => esc_html__('Job Title', 'wp-jobsearch'),
            ),
            'jobsearch_minimum_salary' => array(
                'name' => esc_html__('Salary', 'wp-jobsearch'),
            ),
            'jobsearch_sectors' => array(
                'name' => esc_html__('Sectors', 'wp-jobsearch'),
            ),
            'jobsearch_description' => array(
                'name' => esc_html__('Description', 'wp-jobsearch'),
            ),
            'jobsearch_social_network' => array(
                'name' => esc_html__('Social Network', 'wp-jobsearch'),
                'list' => array(
                    'jobsearch_facebook' => array(
                        'name' => esc_html__('Facebook', 'wp-jobsearch'),
                    ),
                    'jobsearch_twitter' => array(
                        'name' => esc_html__('Twitter', 'wp-jobsearch'),
                    ),
                    'jobsearch_linkedin' => array(
                        'name' => esc_html__('Linkedin', 'wp-jobsearch'),
                    ),
                ),
            ),
            'contact_info' => array(
                'name' => esc_html__('Contact Information', 'wp-jobsearch'),
                'list' => array(
                    'jobsearch_user_phone' => array(
                        'name' => esc_html__('Phone Number', 'wp-jobsearch'),
                    ),
                    'jobsearch_user_email' => array(
                        'name' => esc_html__('Email', 'wp-jobsearch'),
                    ),
                    'jobsearch_location_address' => array(
                        'name' => esc_html__('Complete Address', 'wp-jobsearch'),
                    ),
                ),
            ),
            'resume' => array(
                'name' => esc_html__('Resume', 'wp-jobsearch'),
                'list' => array(
                    'jobsearch_education_title' => array(
                        'name' => esc_html__('Education', 'wp-jobsearch'),
                    ),
                    'jobsearch_experience_title' => array(
                        'name' => esc_html__('Experience', 'wp-jobsearch'),
                    ),
                    'jobsearch_portfolio_title' => array(
                        'name' => esc_html__('Portfolio', 'wp-jobsearch'),
                    ),
                    'jobsearch_skill_title' => array(
                        'name' => esc_html__('Expertise', 'wp-jobsearch'),
                    ),
                    'jobsearch_award_title' => array(
                        'name' => esc_html__('Honors & Awards', 'wp-jobsearch'),
                    ),
                ),
            ),
            'cv_cover_letter' => array(
                'name' => esc_html__('CV &amp; Cover Letter', 'wp-jobsearch'),
                'list' => array(
                    'jobsearch_candidate_cv' => array(
                        'name' => esc_html__('CV', 'wp-jobsearch'),
                    ),
                    'jobsearch_cover_letter' => array(
                        'name' => esc_html__('Cover Letter', 'wp-jobsearch'),
                    ),
                ),
            ),
        );
        $skills_array = apply_filters('jobsearch_custom_fields_load_precentage_array', 'candidate', $skills_array);
        return $skills_array;
    }

}

function jobsearch_skill_add_to_link($dashbord_page_url, $skill_key, $tab = 'dashboard-settings') {
    $quer_args = [];
    if ($tab != '') {
        $quer_args['tab'] = $tab;
    }
    if (!empty($quer_args)) {
        $url = add_query_arg($quer_args, $dashbord_page_url);
    } else {
        $url = $dashbord_page_url;
    }
    $skill_key = str_replace(array('jobsearch_'), array(''), $skill_key);
    $url .= '#' . $skill_key . '_skillid';
    
    return $url;
}

if (!function_exists('jobsearch_candidate_skill_percent_count')) {

    function jobsearch_candidate_skill_percent_count($user_id, $return_type = 'return')
    {
        global $jobsearch_plugin_options;
        $skills_perc = 0;
        
        $user_dashboard_page = isset($jobsearch_plugin_options['user-dashboard-template-page']) ? $jobsearch_plugin_options['user-dashboard-template-page'] : '';
        $page_id = jobsearch__get_post_id($user_dashboard_page, 'page');
        $dashbord_page_url = jobsearch_wpml_lang_page_permalink($page_id, 'page');

        $msgs_array = array();

        $is_candidate = jobsearch_user_is_candidate($user_id);
        if ($is_candidate) {
            $candidate_id = jobsearch_get_user_candidate_id($user_id);
            $skills_array = jobsearch_candidate_skills_set_array();
            foreach ($skills_array as $skill_key => $skill_val) {
                if ($skill_key == 'jobsearch_display_name') {
                    $this_opt_id = str_replace('jobsearch_', '', $skill_key) . '_skill';
                    $def_percentage = isset($jobsearch_plugin_options[$this_opt_id]) ? $jobsearch_plugin_options[$this_opt_id] : '';
                    $candidate_name_title = get_the_title($candidate_id);
                    if ($candidate_name_title != '') {
                        $skills_perc += ($def_percentage > 0 ? $def_percentage : 0);
                    } else {
                        if ($def_percentage > 0) {
                            $msgs_array[] = sprintf(__('<a href="%s"><small> %s </small> Increase profile score by Full Name.</a>', 'wp-jobsearch'), jobsearch_skill_add_to_link($dashbord_page_url, $skill_key), $def_percentage . '%');
                        }
                    }
                }
                if ($skill_key == 'jobsearch_user_img') {
                    $this_opt_id = str_replace('jobsearch_', '', $skill_key) . '_skill';
                    $def_percentage = isset($jobsearch_plugin_options[$this_opt_id]) ? $jobsearch_plugin_options[$this_opt_id] : '';

                    $user_avatar_dburl = get_post_meta($candidate_id, 'jobsearch_user_avatar_url', true);

                    if (isset($user_avatar_dburl['file_url']) && $user_avatar_dburl['file_url'] != '') {
                        $skills_perc += ($def_percentage > 0 ? $def_percentage : 0);
                    } else {
                        if ($def_percentage > 0) {
                            $msgs_array[] = sprintf(__('<a href="%s"><small> %s </small> Increase profile score by Profile Image.</a>', 'wp-jobsearch'), jobsearch_skill_add_to_link($dashbord_page_url, $skill_key), $def_percentage . '%');
                        }
                    }
                }
                if ($skill_key == 'jobsearch_post_title') {
                    $this_opt_id = str_replace('jobsearch_', '', $skill_key) . '_skill';
                    $def_percentage = isset($jobsearch_plugin_options[$this_opt_id]) ? $jobsearch_plugin_options[$this_opt_id] : '';
                    $candidate_post_title = get_post_meta($candidate_id, 'jobsearch_field_candidate_jobtitle', true);
                    if ($candidate_post_title != '') {
                        $skills_perc += ($def_percentage > 0 ? $def_percentage : 0);
                    } else {
                        if ($def_percentage > 0) {
                            $msgs_array[] = sprintf(__('<a href="%s"><small> %s </small> Increase profile score by Job Title.</a>', 'wp-jobsearch'), jobsearch_skill_add_to_link($dashbord_page_url, $skill_key), $def_percentage . '%');
                        }
                    }
                }
                if ($skill_key == 'jobsearch_minimum_salary') {
                    $this_opt_id = str_replace('jobsearch_', '', $skill_key) . '_skill';
                    $def_percentage = isset($jobsearch_plugin_options[$this_opt_id]) ? $jobsearch_plugin_options[$this_opt_id] : '';
                    $candidate_salary = get_post_meta($candidate_id, 'jobsearch_field_candidate_salary', true);
                    if ($candidate_salary != '') {
                        $skills_perc += ($def_percentage > 0 ? $def_percentage : 0);
                    } else {
                        if ($def_percentage > 0) {
                            $msgs_array[] = sprintf(__('<a href="%s"><small> %s </small> Increase profile score by Salary.</a>', 'wp-jobsearch'), jobsearch_skill_add_to_link($dashbord_page_url, $skill_key), $def_percentage . '%');
                        }
                    }
                }
                if ($skill_key == 'jobsearch_sectors') {
                    $this_opt_id = str_replace('jobsearch_', '', $skill_key) . '_skill';
                    $def_percentage = isset($jobsearch_plugin_options[$this_opt_id]) ? $jobsearch_plugin_options[$this_opt_id] : '';
                    $candidate_sectors = wp_get_post_terms($candidate_id, 'sector');
                    if (!empty($candidate_sectors)) {
                        $skills_perc += ($def_percentage > 0 ? $def_percentage : 0);
                    } else {
                        if ($def_percentage > 0) {
                            $msgs_array[] = sprintf(__('<a href="%s"><small> %s </small> Increase profile score by Sector.</a>', 'wp-jobsearch'), jobsearch_skill_add_to_link($dashbord_page_url, $skill_key), $def_percentage . '%');
                        }
                    }
                }
                if ($skill_key == 'jobsearch_description') {
                    $this_opt_id = str_replace('jobsearch_', '', $skill_key) . '_skill';
                    $def_percentage = isset($jobsearch_plugin_options[$this_opt_id]) ? $jobsearch_plugin_options[$this_opt_id] : '';
                    $candidate_obj = get_post($candidate_id);
                    $candidate_desc = isset($candidate_obj->post_content) ? $candidate_obj->post_content : '';
                    if ($candidate_desc != '') {
                        $skills_perc += ($def_percentage > 0 ? $def_percentage : 0);
                    } else {
                        if ($def_percentage > 0) {
                            $msgs_array[] = sprintf(__('<a href="%s"><small> %s </small> Increase profile score by Description.</a>', 'wp-jobsearch'), jobsearch_skill_add_to_link($dashbord_page_url, $skill_key), $def_percentage . '%');
                        }
                    }
                }
                if ($skill_key == 'jobsearch_social_network') {
                    if (isset($skill_val['list'])) {
                        foreach ($skill_val['list'] as $skill_social_key => $skill_social_val) {
                            $this_opt_id = str_replace('jobsearch_', '', $skill_social_key) . '_skill';
                            $def_percentage = isset($jobsearch_plugin_options[$this_opt_id]) ? $jobsearch_plugin_options[$this_opt_id] : '';
                            //
                            $this_meta_id = 'jobsearch_field_user_' . str_replace('jobsearch_', '', $skill_social_key) . '_url';
                            $candidate_social_val = get_post_meta($candidate_id, $this_meta_id, true);
                            if ($candidate_social_val != '') {
                                $skills_perc += ($def_percentage > 0 ? $def_percentage : 0);
                            } else {
                                if ($def_percentage > 0) {
                                    $msgs_array[] = sprintf(__('<a href="%s"><small> %s </small> Increase profile score by %s.</a>', 'wp-jobsearch'), jobsearch_skill_add_to_link($dashbord_page_url, $skill_key), $def_percentage . '%', $skill_social_val['name']);
                                }
                            }
                        }
                    }
                }
                if ($skill_key == 'contact_info') {
                    if (isset($skill_val['list'])) {
                        foreach ($skill_val['list'] as $skill_contact_key => $skill_contact_val) {
                            $this_opt_id = str_replace('jobsearch_', '', $skill_contact_key) . '_skill';
                            $def_percentage = isset($jobsearch_plugin_options[$this_opt_id]) ? $jobsearch_plugin_options[$this_opt_id] : '';
                            //
                            if ($skill_contact_key != 'jobsearch_user_email' && $skill_contact_key != 'jobsearch_user_url') {
                                $switch_location_fields = isset($jobsearch_plugin_options['switch_location_fields']) ? $jobsearch_plugin_options['switch_location_fields'] : '';
                                $to_chek_field = true;
                                $to_chek_field = apply_filters('jobsearch_cand_profile_location_address', $to_chek_field);
                                if ($skill_contact_key == 'jobsearch_location_address' && $switch_location_fields != 'on') {
                                    $to_chek_field = false;
                                }
                                if ($to_chek_field) {
                                    $this_meta_id = str_replace('jobsearch_', 'jobsearch_field_', $skill_contact_key);
                                    $candidate_contact_val = get_post_meta($candidate_id, $this_meta_id, true);
                                    if ($candidate_contact_val != '') {
                                        $skills_perc += ($def_percentage > 0 ? $def_percentage : 0);
                                    } else {
                                        if ($def_percentage > 0) {
                                            $msgs_array[] = sprintf(__('<a href="%s"><small> %s </small> Increase profile score by %s.</a>', 'wp-jobsearch'), jobsearch_skill_add_to_link($dashbord_page_url, $skill_contact_key), $def_percentage . '%', $skill_contact_val['name']);
                                        }
                                    }
                                }
                            } else {
                                $user_obj = get_user_by('ID', $user_id);
                                if ($skill_contact_key == 'jobsearch_user_email' && isset($user_obj->user_email) && $user_obj->user_email != '') {
                                    $skills_perc += ($def_percentage > 0 ? $def_percentage : 0);
                                } else {
                                    if ($def_percentage > 0) {
                                        $msgs_array[] = sprintf(__('<a href="%s"><small> %s </small> Increase profile score by %s.</a>', 'wp-jobsearch'), jobsearch_skill_add_to_link($dashbord_page_url, $skill_contact_key), $def_percentage . '%', $skill_contact_val['name']);
                                    }
                                }
                            }
                        }
                    }
                }
                if ($skill_key == 'resume') {
                    if (isset($skill_val['list'])) {
                        foreach ($skill_val['list'] as $skill_resume_key => $skill_resume_val) {
                            $this_opt_id = str_replace('jobsearch_', '', $skill_resume_key) . '_skill';
                            $def_percentage = isset($jobsearch_plugin_options[$this_opt_id]) ? $jobsearch_plugin_options[$this_opt_id] : '';
                            //
                            $this_meta_id = str_replace('jobsearch_', 'jobsearch_field_', $skill_resume_key);
                            $candidate_resume_val = get_post_meta($candidate_id, $this_meta_id, true);
                            if (!empty($candidate_resume_val)) {
                                $skills_perc += ($def_percentage > 0 ? $def_percentage : 0);
                            } else {
                                if ($def_percentage > 0) {
                                    $msgs_array[] = sprintf(__('<a href="%s"><small> %s </small> Increase profile score by %s.</a>', 'wp-jobsearch'), jobsearch_skill_add_to_link($dashbord_page_url, $skill_resume_key, 'my-resume'), $def_percentage . '%', $skill_resume_val['name']);
                                }
                            }
                        }
                    }
                }
                if ($skill_key == 'cv_cover_letter') {
                    if (isset($skill_val['list'])) {
                        foreach ($skill_val['list'] as $skill_cv_key => $skill_cv_val) {
                            $this_opt_id = str_replace('jobsearch_', '', $skill_cv_key) . '_skill';
                            $def_percentage = isset($jobsearch_plugin_options[$this_opt_id]) ? $jobsearch_plugin_options[$this_opt_id] : '';
                            //
                            if ($skill_cv_key == 'jobsearch_candidate_cv') {
                                $candidate_cv_file = get_post_meta($candidate_id, 'candidate_cv_file', true);
                                $multiple_cv_files_allow = isset($jobsearch_plugin_options['multiple_cv_uploads']) ? $jobsearch_plugin_options['multiple_cv_uploads'] : '';
                                $ca_at_cv_files = get_post_meta($candidate_id, 'candidate_cv_files', true);
                                if ($multiple_cv_files_allow == 'on' && !empty($ca_at_cv_files)) {
                                    $skills_perc += ($def_percentage > 0 ? $def_percentage : 0);
                                } else if (!empty($candidate_cv_file)) {
                                    $skills_perc += ($def_percentage > 0 ? $def_percentage : 0);
                                } else {
                                    if ($def_percentage > 0) {
                                        $msgs_array[] = sprintf(__('<a href="%s"><small> %s </small> Increase profile score by CV.</a>', 'wp-jobsearch'), jobsearch_skill_add_to_link($dashbord_page_url, $skill_key, 'cv-manager'), $def_percentage . '%');
                                    }
                                }
                            }
                            if ($skill_cv_key == 'jobsearch_cover_letter') {
                                $candidate_cover = get_post_meta($candidate_id, 'jobsearch_field_resume_cover_letter', true);
                                $cand_cover_file = get_post_meta($candidate_id, 'candidate_cover_letter_file', true);
                                if (!empty($candidate_cover) || !empty($cand_cover_file)) {
                                    $skills_perc += ($def_percentage > 0 ? $def_percentage : 0);
                                } else {
                                    if ($def_percentage > 0) {
                                        $msgs_array[] = sprintf(__('<a href="%s"><small> %s </small> Increase profile score by Cover Letter.</a>', 'wp-jobsearch'), jobsearch_skill_add_to_link($dashbord_page_url, $skill_key, 'my-resume'), $def_percentage . '%');
                                    }
                                }
                            }
                        }
                    }
                }

                //
                if ($skill_key == 'custom_fields') {
                    $field_db_slug = "jobsearch_custom_field_candidate";
                    $jobsearch_post_cus_fields = get_option($field_db_slug);
                    if (is_array($jobsearch_post_cus_fields) && sizeof($jobsearch_post_cus_fields) > 0) {
                        foreach ($jobsearch_post_cus_fields as $custom_field) {
                            $custom_meta_key = isset($custom_field['name']) ? $custom_field['name'] : '';
                            $custom_field_name = isset($custom_field['label']) ? $custom_field['label'] : '';

                            if ($custom_meta_key != '') {
                                $this_opt_id = str_replace('jobsearch_', '', $custom_meta_key) . '_skill';
                                $def_percentage = isset($jobsearch_plugin_options[$this_opt_id]) ? $jobsearch_plugin_options[$this_opt_id] : '';
                                //
                                if (isset($custom_field['type']) && $custom_field['type'] == 'upload_file') {
                                    $custom_meta_key = 'jobsearch_cfupfiles_' . $custom_meta_key;
                                }
                                $custom_f_val = get_post_meta($candidate_id, $custom_meta_key, true);
                                if (!empty($custom_f_val)) {
                                    $skills_perc += ($def_percentage > 0 ? $def_percentage : 0);
                                } else {
                                    if ($def_percentage > 0) {
                                        $msgs_array[] = sprintf(__('<a href="%s"><small> %s </small> Increase profile score by %s.</a>', 'wp-jobsearch'), jobsearch_skill_add_to_link($dashbord_page_url, $skill_key), $def_percentage . '%', $custom_field_name);
                                    }
                                }
                            }
                        }
                    }
                }
                //
            }
            
            $msgs_array = apply_filters('jobsearch_cand_overall_skills_msgs', $msgs_array, $candidate_id);
            $skills_perc = apply_filters('jobsearch_cand_overall_skills_percentage', $skills_perc, $candidate_id);

            if ($skills_perc > 100) {
                $skills_perc = 100;
            }
            
            update_post_meta($candidate_id, 'overall_skills_percentage', $skills_perc);
        }

        if ($return_type == 'return') {
            return $skills_perc;
        }
        if ($return_type == 'msgs') {
            return $msgs_array;
        }
    }

}

add_action('jobsearch_user_dash_instart_act', 'jobsearch_candash_send_profile_comp_email', 20);

function jobsearch_candash_send_profile_comp_email($user_id)
{
    global $jobsearch_plugin_options;
    
    $cand_skills_switch = isset($jobsearch_plugin_options['jobsearch_candidate_skills']) ? $jobsearch_plugin_options['jobsearch_candidate_skills'] : '';
    $required_skills_percent = isset($jobsearch_plugin_options['jobsearch-candidate-skills-percentage']) ? $jobsearch_plugin_options['jobsearch-candidate-skills-percentage'] : '';
    
    $user_is_candidate = jobsearch_user_is_candidate($user_id);
    
    $candidate_id = $candidate_id = jobsearch_get_user_candidate_id($user_id);
    $candidate_skill_perc = get_post_meta($candidate_id, 'overall_skills_percentage', true);

    if ($user_is_candidate && $cand_skills_switch == 'on' && $required_skills_percent > 0 && $required_skills_percent > $candidate_skill_perc) {
        $cachetime = 86400; // 1 day
        $transient = 'jobsearch_send_profile_comp_email_' . $user_id;

        $check_transient = get_transient($transient);
        if (empty($check_transient)) {

            $user_obj = get_user_by('id', $user_id);

            do_action('jobsearch_profile_complete_candidate_email', $user_obj);
            set_transient($transient, true, $cachetime);
        }
    }
}

if (!function_exists('jobsearch_candidate_skills_set_plugin_option_array')) {

    add_filter('jobsearch_poptions_apply_jobsett_after', 'jobsearch_candidate_skills_set_plugin_option_array', 1);

    function jobsearch_candidate_skills_set_plugin_option_array($sections)
    {
        $skills_array = jobsearch_candidate_skills_set_array();
        $jobsearch_setting_options = array();
        $jobsearch_setting_options[] = array(
            'id' => 'jobsearch_candidate_skills',
            'type' => 'button_set',
            'title' => __('Profile Completion', 'wp-jobsearch'),
            'subtitle' => '',
            'options' => array(
                'on' => __('On', 'wp-jobsearch'),
                'off' => __('Off', 'wp-jobsearch'),
            ),
            'desc' => '',
            'default' => 'off',
        );
        $jobsearch_setting_options[] = array(
            'id' => 'profile_approve_compfields_base',
            'type' => 'button_set',
            'title' => __('Auto Approve Profile by filling fields values', 'wp-jobsearch'),
            'subtitle' => __('Candidate profile will auto approve once a candidate fill all fields like profile picture, resume fields, and other compulsory profile fields.', 'wp-jobsearch'),
            'options' => array(
                'on' => __('On', 'wp-jobsearch'),
                'off' => __('Off', 'wp-jobsearch'),
            ),
            'desc' => '',
            'default' => 'off',
        );
        $jobsearch_setting_options[] = array(
            'id' => 'jobsearch_candidate_profilescore_sort',
            'type' => 'button_set',
            'required' => array('jobsearch_candidate_skills', 'equals', 'on'),
            'title' => __('Candidates sorting with profile score', 'wp-jobsearch'),
            'subtitle' => __('In Candidates listing all the candidates will sort on the basis of profile score.', 'wp-jobsearch'),
            'options' => array(
                'on' => __('On', 'wp-jobsearch'),
                'off' => __('Off', 'wp-jobsearch'),
            ),
            'desc' => '',
            'default' => 'off',
        );
        $jobsearch_setting_options[] = array(
            'id' => 'jobsearch-candidate-skills-percentage',
            'type' => 'text',
            'title' => __('Minimum Score Percentage', 'wp-jobsearch'),
            'subtitle' => __("Set Candidate Profile Score Percentage such as 50. If Candidate's Profile Score Percentage less than this Percentage then He/She will not able to apply any Job.", 'wp-jobsearch'),
            'desc' => '',
            'default' => '50',
        );
        $jobsearch_setting_options[] = array(
            'id' => 'cand_min_listpecent',
            'type' => 'text',
            'title' => __('Minimum Listing Percentage', 'wp-jobsearch'),
            'subtitle' => __("Set Candidate Profile Score Percentage such as 30. If Candidate's Profile Score Percentage less than this Percentage then He/She will not be display in list.", 'wp-jobsearch'),
            'desc' => '',
            'default' => '',
        );
        $jobsearch_setting_options[] = array(
            'id' => 'skill_low_set_color',
            'type' => 'color',
            'transparent' => false,
            'title' => __('Low Profile Color', 'wp-jobsearch'),
            'subtitle' => '',
            'desc' => __("Set color for Low Profile. Profile Score percentage from 0 to 25%.", 'wp-jobsearch'),
            'default' => '#ff5b5b',
        );
        $jobsearch_setting_options[] = array(
            'id' => 'skill_med_set_color',
            'type' => 'color',
            'transparent' => false,
            'title' => __('Basic Profile Color', 'wp-jobsearch'),
            'subtitle' => '',
            'desc' => __("Set color for Basic Profile. Profile Score percentage from 26% to 50%.", 'wp-jobsearch'),
            'default' => '#ffbb00',
        );
        $jobsearch_setting_options[] = array(
            'id' => 'skill_high_set_color',
            'type' => 'color',
            'transparent' => false,
            'title' => __('Professional Profile Color', 'wp-jobsearch'),
            'subtitle' => '',
            'desc' => __("Set color for Professional Profile. Profile Score percentage from 51% to 75%.", 'wp-jobsearch'),
            'default' => '#13b5ea',
        );
        $jobsearch_setting_options[] = array(
            'id' => 'skill_ahigh_set_color',
            'type' => 'color',
            'transparent' => false,
            'title' => __('Complete Profile Color', 'wp-jobsearch'),
            'subtitle' => '',
            'desc' => __("Set color for Complete Profile. Profile Score percentage from 76% to 100%.", 'wp-jobsearch'),
            'default' => '#40d184',
        );
        if (is_array($skills_array) && sizeof($skills_array) > 0) {

            foreach ($skills_array as $skills_array_key => $skills_array_set) {

                if (array_key_exists('list', $skills_array_set) && is_array($skills_array_set['list'])) {

                    $skill_sec_name = isset($skills_array_set['name']) ? $skills_array_set['name'] : '';
                    if ($skill_sec_name != '' && $skills_array_key != '') {
                        $jobsearch_setting_options[] = array(
                            'id' => "tab-settings-$skills_array_key-skill",
                            'type' => 'section',
                            'title' => $skill_sec_name,
                            'subtitle' => '',
                            'indent' => true,
                        );
                    }
                    foreach ($skills_array_set['list'] as $skill_list_key => $skill_list_set) {
                        $skill_name = isset($skill_list_set['name']) ? $skill_list_set['name'] : '';
                        if ($skill_list_key != '' && $skill_name != '') {

                            $this_opt_id = str_replace('jobsearch_', '', $skill_list_key) . '_skill';

                            $jobsearch_setting_options[] = array(
                                'id' => $this_opt_id,
                                'type' => 'text',
                                'title' => $skill_name,
                                'desc' => '',
                                'default' => '',
                            );
                        }
                    }
                } else {
                    $skill_name = isset($skills_array_set['name']) ? $skills_array_set['name'] : '';
                    if ($skills_array_key != '' && $skill_name != '') {
                        $this_opt_id = str_replace('jobsearch_', '', $skills_array_key) . '_skill';
                        $jobsearch_setting_options[] = array(
                            'id' => $this_opt_id,
                            'type' => 'text',
                            'title' => $skill_name,
                            'desc' => '',
                            'default' => '',
                        );
                    }
                }
            }
        }

        $sections = array(
            'title' => __('Profile Completion', 'wp-jobsearch'),
            'id' => 'required-skill-set',
            'desc' => '',
            'subsection' => true,
            'fields' => $jobsearch_setting_options,
        );
        return $sections;
    }

}

function jobsearch_upload_candidate_cv($Fieldname = 'file', $post_id = 0, $user_dir_filter = true)
{

    global $jobsearch_uploding_resume, $jobsearch_download_locations;
    $jobsearch_download_locations = false;
    $jobsearch_uploding_resume = true;
    $jobsearch__options = get_option('jobsearch_plugin_options');

    if (isset($_FILES[$Fieldname]) && $_FILES[$Fieldname] != '') {
        if ($user_dir_filter === true) {
            add_filter('jobsearch_resume_upload_dir', 'jobsearch_upload_cvmod_path', 10, 1);
        }

        // Get the path to the upload directory.
        $wp_upload_dir = wp_upload_dir();

        $orig_upload_file = $upload_file = $_FILES[$Fieldname];

        //var_dump($upload_file);

        $file_name = isset($upload_file['name']) ? $upload_file['name'] : '';
        if (empty($file_name)) {
            return false;
        }

        $uploded_file_extype = wp_check_filetype($file_name);
        $file_ext = isset($uploded_file_extype['ext']) ? $uploded_file_extype['ext'] : '';
        $allowed_exts = jobsearch_allowed_uploding_files_exts();
        if (!in_array($file_ext, $allowed_exts)) {
            return false;
        }

        require_once ABSPATH . 'wp-admin/includes/image.php';
        require_once ABSPATH . 'wp-admin/includes/file.php';
        require_once ABSPATH . 'wp-admin/includes/media.php';

        $allowed_file_types_list = isset($jobsearch__options['cand_cv_types']) ? $jobsearch__options['cand_cv_types'] : '';
        if (empty($allowed_file_types_list)) {
            $allowed_file_types = array(
                'doc' => 'application/msword',
                'docx' => 'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
                'pdf' => 'application/pdf',
            );
        } else {
            $allowed_file_types = array();
            if (in_array('image/jpeg', $allowed_file_types_list)) {
                $allowed_file_types['jpg|jpeg|jpe'] = 'image/jpeg';
                $allowed_file_types['png'] = 'image/png';
            }
            if (in_array('image/png', $allowed_file_types_list)) {
                $allowed_file_types['jpg|jpeg|jpe'] = 'image/jpeg';
                $allowed_file_types['png'] = 'image/png';
            }
            if (in_array('text/plain', $allowed_file_types_list)) {
                $allowed_file_types['txt|asc|c|cc|h'] = 'text/plain';
            }
            if (in_array('application/msword', $allowed_file_types_list)) {
                $allowed_file_types['doc'] = 'application/msword';
            }
            if (in_array('application/vnd.openxmlformats-officedocument.wordprocessingml.document', $allowed_file_types_list)) {
                $allowed_file_types['docx'] = 'application/vnd.openxmlformats-officedocument.wordprocessingml.document';
            }
            if (in_array('application/pdf', $allowed_file_types_list)) {
                $allowed_file_types['pdf'] = 'application/pdf';
            }
            if (in_array('application/vnd.ms-excel', $allowed_file_types_list)) {
                $allowed_file_types['xla|xls|xlt|xlw'] = 'application/vnd.ms-excel';
            }
            if (in_array('application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', $allowed_file_types_list)) {
                $allowed_file_types['xlsx'] = 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet';
            }
        }

        $test_uploaded_file = is_uploaded_file($upload_file['tmp_name']);

        do_action('jobsearch_trigger_before_cv_file_upload', $orig_upload_file, $post_id);

        //
        $candidate_username = 'cv';
        if (get_post_type($post_id) == 'candidate') {
            $candidate_user_id = jobsearch_get_candidate_user_id($post_id);
            $candidate_user_obj = get_user_by('ID', $candidate_user_id);
            $candidate_username = $candidate_user_obj->user_login . '_cv';
        }

        $file_ex_name = $candidate_username . '_' . rand(1000000000, 9999999999) . '_';

        $file_ex_name = apply_filters('jobsearch_cand_cvupload_file_extlabel', $file_ex_name, $post_id);

        if (isset($upload_file['name'])) {
            $upload_file['name'] = $upload_file['name'];
            $upload_file['name'] = $file_ex_name . $upload_file['name'];
        }

        $status_upload = wp_handle_upload($upload_file, array('test_form' => false, 'mimes' => $allowed_file_types));

        if ($test_uploaded_file && !isset($status_upload['file'])) {
            //$status_upload = jobsearch_wp_handle_upload($upload_file, array('test_form' => false, 'mimes' => $allowed_file_types));
        }

        if (empty($status_upload['error'])) {

            do_action('jobsearch_act_after_cand_cv_upload', $status_upload, $post_id, $wp_upload_dir);

            $file_url = isset($status_upload['url']) ? $status_upload['url'] : '';

            $upload_file_path = $wp_upload_dir['path'] . '/' . basename($file_url);

            // Check the type of file. We'll use this as the 'post_mime_type'.
            $filetype = wp_check_filetype(basename($file_url), null);

            return $file_url;
        }

        if ($user_dir_filter === true) {
            remove_filter('jobsearch_resume_upload_dir', 'jobsearch_upload_cvmod_path', 10, 1);
        }
    }

    return false;
}

function jobsearch_upload_cand_cover_letter($Fieldname = 'file', $post_id = 0, $user_dir_filter = true, $return = 'url') {

    global $jobsearch_uploding_resume, $jobsearch_download_locations;
    $jobsearch_download_locations = false;
    $jobsearch_uploding_resume = true;
    $jobsearch__options = get_option('jobsearch_plugin_options');

    if (isset($_FILES[$Fieldname]) && $_FILES[$Fieldname] != '') {
        if ($user_dir_filter === true) {
            add_filter('jobsearch_resume_upload_dir', 'jobsearch_upload_cvmod_path', 10, 1);
        }

        // Get the path to the upload directory.
        $wp_upload_dir = wp_upload_dir();

        $orig_upload_file = $upload_file = $_FILES[$Fieldname];

        $file_name = isset($upload_file['name']) ? $upload_file['name'] : '';
        if (empty($file_name)) {
            return false;
        }

        $uploded_file_extype = wp_check_filetype($file_name);
        $file_ext = isset($uploded_file_extype['ext']) ? $uploded_file_extype['ext'] : '';
        $allowed_exts = jobsearch_allowed_uploding_files_exts();
        if (!in_array($file_ext, $allowed_exts)) {
            return false;
        }

        require_once ABSPATH . 'wp-admin/includes/image.php';
        require_once ABSPATH . 'wp-admin/includes/file.php';
        require_once ABSPATH . 'wp-admin/includes/media.php';

        $allowed_file_types_list = isset($jobsearch__options['cand_cover_letter_types']) ? $jobsearch__options['cand_cover_letter_types'] : '';
        if (empty($allowed_file_types_list)) {
            $allowed_file_types = array(
                'doc' => 'application/msword',
                'docx' => 'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
                'pdf' => 'application/pdf',
            );
        } else {
            $allowed_file_types = array();
            if (in_array('image/jpeg', $allowed_file_types_list)) {
                $allowed_file_types['jpg|jpeg|jpe'] = 'image/jpeg';
                $allowed_file_types['png'] = 'image/png';
            }
            if (in_array('image/png', $allowed_file_types_list)) {
                $allowed_file_types['jpg|jpeg|jpe'] = 'image/jpeg';
                $allowed_file_types['png'] = 'image/png';
            }
            if (in_array('text/plain', $allowed_file_types_list)) {
                $allowed_file_types['txt|asc|c|cc|h'] = 'text/plain';
            }
            if (in_array('application/msword', $allowed_file_types_list)) {
                $allowed_file_types['doc'] = 'application/msword';
            }
            if (in_array('application/vnd.openxmlformats-officedocument.wordprocessingml.document', $allowed_file_types_list)) {
                $allowed_file_types['docx'] = 'application/vnd.openxmlformats-officedocument.wordprocessingml.document';
            }
            if (in_array('application/pdf', $allowed_file_types_list)) {
                $allowed_file_types['pdf'] = 'application/pdf';
            }
            if (in_array('application/vnd.ms-excel', $allowed_file_types_list)) {
                $allowed_file_types['xla|xls|xlt|xlw'] = 'application/vnd.ms-excel';
            }
            if (in_array('application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', $allowed_file_types_list)) {
                $allowed_file_types['xlsx'] = 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet';
            }
        }

        $test_uploaded_file = is_uploaded_file($upload_file['tmp_name']);

        do_action('jobsearch_trigger_before_cover_file_upload', $orig_upload_file, $post_id);

        //
        $candidate_username = 'cover';
        if (get_post_type($post_id) == 'candidate') {
            $candidate_user_id = jobsearch_get_candidate_user_id($post_id);
            $candidate_user_obj = get_user_by('ID', $candidate_user_id);
            $candidate_username = $candidate_user_obj->user_login . '_cover';
        }

        $file_ex_name = $candidate_username . '_' . rand(1000000000, 9999999999) . '_';

        $file_ex_name = apply_filters('jobsearch_cand_cover_upload_file_extlabel', $file_ex_name, $post_id);

        if (isset($upload_file['name'])) {
            $upload_file['name'] = $upload_file['name'];
            $upload_file['name'] = $file_ex_name . $upload_file['name'];
        }

        $status_upload = wp_handle_upload($upload_file, array('test_form' => false, 'mimes' => $allowed_file_types));

        if ($test_uploaded_file && !isset($status_upload['file'])) {
            //$status_upload = jobsearch_wp_handle_upload($upload_file, array('test_form' => false, 'mimes' => $allowed_file_types));
        }

        if (empty($status_upload['error'])) {

            do_action('jobsearch_act_after_cand_cover_upload', $status_upload, $post_id, $wp_upload_dir);

            $file_url = isset($status_upload['url']) ? $status_upload['url'] : '';

            $upload_file_path = $wp_upload_dir['path'] . '/' . basename($file_url);

            // Check the type of file. We'll use this as the 'post_mime_type'.
            $filetype = wp_check_filetype(basename($file_url), null);

            if ($return == 'path') {
                return $upload_file_path;
            } else {
                return $file_url;
            }
        }

        if ($user_dir_filter === true) {
            remove_filter('jobsearch_resume_upload_dir', 'jobsearch_upload_cvmod_path', 10, 1);
        }
    }

    return false;
}

add_action('wp_ajax_wp_jobsearch_get_user_cv_file_download', 'wp_jobsearch_get_user_cv_file_download');
add_action('wp_ajax_nopriv_wp_jobsearch_get_user_cv_file_download', 'wp_jobsearch_get_user_cv_file_download');

function wp_jobsearch_get_user_cv_file_download() {

    $attachment_id = isset($_GET['file_id']) ? $_GET['file_id'] : '';
    $attachment_user_id = isset($_GET['user_id']) ? $_GET['user_id'] : '';

    $error_page_url = home_url('/404_error');

    if ($attachment_id != '') {

        $jobsearch__options = get_option('jobsearch_plugin_options');
        $multiple_cv_files_allow = isset($jobsearch__options['multiple_cv_uploads']) ? $jobsearch__options['multiple_cv_uploads'] : '';

        $is_attachment = false;
        if (is_numeric($attachment_id) && get_post_type($attachment_id) == 'attachment') {
            $is_attachment = true;
        }

        $uplod_dir = wp_upload_dir();
        $uplod_dirpath = $uplod_dir['basedir'];
        $file_path = '';
        // Get post from database 
        if ($is_attachment) {
            $file_post = get_post($attachment_id);
            $file_path = get_attached_file($attachment_id);
            $file_mimetype = $file_post->post_mime_type;
        } else {

            if ($multiple_cv_files_allow == 'on') {
                $ca_at_cv_files = get_post_meta($attachment_user_id, 'candidate_cv_files', true);

                $attach_key = 0;
                if (!empty($ca_at_cv_files)) {
                    $file_url = '';
                    $attach_counter = 0;
                    foreach ($ca_at_cv_files as $ca_at_cv_file) {
                        if (isset($ca_at_cv_file['file_id']) && $ca_at_cv_file['file_id'] == $attachment_id) {
                            $file_url = isset($ca_at_cv_file['file_url']) ? $ca_at_cv_file['file_url'] : '';
                            $attach_key = $attach_counter;
                        }
                        $attach_counter++;
                    }

                    if ($file_url == '') {
                        $file_url = isset($ca_at_cv_files[$attachment_id]['file_url']) ? $ca_at_cv_files[$attachment_id]['file_url'] : '';
                    }
                    $file_mimetype = isset($ca_at_cv_files[$attach_key]['mime_type']) ? $ca_at_cv_files[$attach_key]['mime_type'] : '';
                    $file_mimetype = isset($file_mimetype['type']) ? $file_mimetype['type'] : '';

                    $in_foldr_file = false;
                    if (strpos($file_url, 'jobsearch-user-files/')) {
                        $in_foldr_file = true;
                        $sub_file_url = substr($file_url, strpos($file_url, 'jobsearch-user-files/'), strlen($file_url));
                    } else if (strpos($file_url, 'jobsearch-resumes/')) {
                        $in_foldr_file = true;
                        $sub_file_url = substr($file_url, strpos($file_url, 'jobsearch-resumes/'), strlen($file_url));
                    }

                    if ($in_foldr_file) {
                        $file_path = $uplod_dirpath . '/' . $sub_file_url;
                    } else {
                        $file_path = str_replace(get_site_url() . '/', ABSPATH, $file_url);
                    }
                }
            } else {
                $candidate_cv_file = get_post_meta($attachment_user_id, 'candidate_cv_file', true);
                $file_url = isset($candidate_cv_file['file_url']) ? $candidate_cv_file['file_url'] : '';
                $file_mimetype = isset($candidate_cv_file['mime_type']) ? $candidate_cv_file['mime_type'] : '';
                $file_mimetype = isset($file_mimetype['type']) ? $file_mimetype['type'] : '';
                if (strpos($file_url, 'jobsearch-user-files/')) {
                    $sub_file_url = substr($file_url, strpos($file_url, 'jobsearch-user-files/'), strlen($file_url));
                } else {
                    $sub_file_url = substr($file_url, strpos($file_url, 'jobsearch-resumes/'), strlen($file_url));
                }
                $file_path = $uplod_dirpath . '/' . $sub_file_url;
            }
        }
        
        if (!$file_path || !file_exists($file_path)) {
            wp_redirect($error_page_url);
        } else {

            if ($is_attachment) {
                $attch_parnt = get_post_ancestors($attachment_id);
                if (isset($attch_parnt[0])) {
                    $attch_parnt = $attch_parnt[0];
                }
            }

            //
            $downlod_err = 1;
            if (!is_user_logged_in()) {
                wp_redirect($error_page_url);
                exit;
            }
            $user_id = get_current_user_id();

            $cur_user_obj = wp_get_current_user();
            if (jobsearch_user_isemp_member($user_id)) {
                $downlod_err = 0;
            }
            $user_is_employer = jobsearch_user_is_employer($user_id);
            if ($user_is_employer) {
                $downlod_err = 0;
            }

            $user_is_candidate = jobsearch_user_is_candidate($user_id);
            if ($user_is_candidate) {
                $user_cand_id = jobsearch_get_user_candidate_id($user_id);
                if ($is_attachment && $user_cand_id == $attch_parnt) {
                    $downlod_err = 0;
                } else if ($user_cand_id == $attachment_user_id) {
                    $downlod_err = 0;
                }
            }

            if (in_array('administrator', (array)$cur_user_obj->roles) || current_user_can('administrator')) {
                $downlod_err = 0;
            }

            $downlod_err = apply_filters('jobsearch_candidate_getcvfile_acces_err', $downlod_err);

            if ($downlod_err == 1) {
                wp_redirect($error_page_url);
                exit;
            }
            
            $filename = basename($file_path);

            ob_start();
            header('Content-Description: File Transfer');
            header('Content-Type: ' . $file_mimetype);
            header("Content-type: application/force-download");
            header('Content-Disposition: attachment; filename="' . $filename . '"');
            header('Content-Transfer-Encoding: Binary');
            header('Expires: 0');
            header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
            header('Pragma: public');
            header('Content-Length: ' . @filesize($file_path));

            ob_end_clean();
            flush();
            @readfile($file_path);
            exit;
        }
    } else {
        wp_redirect($error_page_url);
    }

    die;
}

add_filter('wp_jobsearch_user_cvfile_downlod_url', 'wp_jobsearch_user_cvfile_downlod_url', 10, 3);

function wp_jobsearch_user_cvfile_downlod_url($url, $attach_id = '', $candidate_id = '')
{

    $url = add_query_arg(array('action' => 'wp_jobsearch_get_user_cv_file_download', 'file_id' => $attach_id, 'user_id' => $candidate_id), admin_url('admin-ajax.php'));

    return $url;
}

add_action('wp_ajax_wp_jobsearch_get_user_cover_file_download', 'wp_jobsearch_get_user_cover_file_download');
add_action('wp_ajax_nopriv_wp_jobsearch_get_user_cover_file_download', 'wp_jobsearch_get_user_cover_file_download');

function wp_jobsearch_get_user_cover_file_download() {

    $attachment_id = isset($_GET['file_id']) ? $_GET['file_id'] : '';
    $attachment_user_id = isset($_GET['user_id']) ? $_GET['user_id'] : '';

    $error_page_url = home_url('/404_error');

    if ($attachment_id != '') {

        $uplod_dir = wp_upload_dir();
        $uplod_dirpath = $uplod_dir['basedir'];
        $file_path = '';
        
        // Get post from database 
        $candidate_cover_file = get_post_meta($attachment_user_id, 'candidate_cover_letter_file', true);
        $file_url = isset($candidate_cover_file['file_url']) ? $candidate_cover_file['file_url'] : '';
        $file_mimetype = isset($candidate_cover_file['mime_type']) ? $candidate_cover_file['mime_type'] : '';
        $file_mimetype = isset($file_mimetype['type']) ? $file_mimetype['type'] : '';
        if (strpos($file_url, 'jobsearch-user-files/')) {
            $sub_file_url = substr($file_url, strpos($file_url, 'jobsearch-user-files/'), strlen($file_url));
        } else {
            $sub_file_url = substr($file_url, strpos($file_url, 'jobsearch-resumes/'), strlen($file_url));
        }
        $file_path = $uplod_dirpath . '/' . $sub_file_url;

        if (!$file_path || !file_exists($file_path)) {
            wp_redirect($error_page_url);
        } else {

            if ($is_attachment) {
                $attch_parnt = get_post_ancestors($attachment_id);
                if (isset($attch_parnt[0])) {
                    $attch_parnt = $attch_parnt[0];
                }
            }

            //
            $downlod_err = 1;
            if (!is_user_logged_in()) {
                wp_redirect($error_page_url);
                exit;
            }
            $user_id = get_current_user_id();

            $cur_user_obj = wp_get_current_user();
            if (jobsearch_user_isemp_member($user_id)) {
                $downlod_err = 0;
            }
            $user_is_employer = jobsearch_user_is_employer($user_id);
            if ($user_is_employer) {
                $downlod_err = 0;
            }

            $user_is_candidate = jobsearch_user_is_candidate($user_id);
            if ($user_is_candidate) {
                $user_cand_id = jobsearch_get_user_candidate_id($user_id);
                if ($is_attachment && $user_cand_id == $attch_parnt) {
                    $downlod_err = 0;
                } else if ($user_cand_id == $attachment_user_id) {
                    $downlod_err = 0;
                }
            }

            if (in_array('administrator', (array)$cur_user_obj->roles)) {
                $downlod_err = 0;
            }

            $downlod_err = apply_filters('jobsearch_candidate_getcvfile_acces_err', $downlod_err);

            if ($downlod_err == 1) {
                wp_redirect($error_page_url);
                exit;
            }

            header('Content-Description: File Transfer');
            header('Content-Type: ' . $file_mimetype);
            header("Content-type: application/force-download");
            header('Content-Disposition: attachment; filename="' . basename($file_path) . '"');
            header('Content-Transfer-Encoding: Binary');
            header('Expires: 0');
            header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
            header('Pragma: public');
            header('Content-Length: ' . @filesize($file_path));

            ob_end_clean();
            flush();
            @readfile($file_path);
            exit;
        }
    } else {
        wp_redirect($error_page_url);
    }

    die;
}

add_filter('wp_jobsearch_user_coverfile_downlod_url', 'wp_jobsearch_user_coverfile_downlod_url', 10, 3);

function wp_jobsearch_user_coverfile_downlod_url($url, $file_id = '', $candidate_id = '') {

    $url = add_query_arg(array('action' => 'wp_jobsearch_get_user_cover_file_download', 'file_id' => $file_id, 'user_id' => $candidate_id), admin_url('admin-ajax.php'));

    return $url;
}

add_action('wp_ajax_wp_jobsearch_get_email_cv_file_download', 'wp_jobsearch_get_email_cv_file_download');
add_action('wp_ajax_nopriv_wp_jobsearch_get_email_cv_file_download', 'wp_jobsearch_get_email_cv_file_download');

function wp_jobsearch_get_email_cv_file_download()
{

    $attachment_id = isset($_GET['file_id']) ? absint($_GET['file_id']) : '';
    $aap_id = isset($_GET['eaap_id']) ? $_GET['eaap_id'] : '';

    $error_page_url = home_url('/404_error');

    if (is_numeric($aap_id) && get_post_type($aap_id) == 'email_apps') {

        $file_path = get_post_meta($aap_id, 'jobsearch_app_att_file_path', true);
        
        if (isset($file_path[$attachment_id])) {
            $file_path = $file_path[$attachment_id];
        } else if (is_array($file_path) && isset($file_path[0])) {
            $file_path = $file_path[0];
        }

        if (!$file_path || !file_exists($file_path)) {
            wp_redirect($error_page_url);
        } else {

            //
            $downlod_err = 1;
            if (!is_user_logged_in()) {
                wp_redirect($error_page_url);
                exit;
            }
            $user_id = get_current_user_id();
            $cur_user_obj = wp_get_current_user();
            $user_is_employer = jobsearch_user_is_employer($user_id);
            if ($user_is_employer) {
                $downlod_err = 0;
            }

            if (in_array('administrator', (array)$cur_user_obj->roles)) {
                $downlod_err = 0;
            }

            if ($downlod_err == 1) {
                wp_redirect($error_page_url);
                exit;
            }

            header('Content-Description: File Transfer');
            header('Content-Type: ' . $file_mimetype);
            header('Content-Disposition: attachment; filename="' . basename($file_path) . '"');
            header('Content-Transfer-Encoding: Binary');
            header('Expires: 0');
            header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
            header('Pragma: public');
            header('Content-Length: ' . @filesize($file_path));

            ob_clean();
            flush();
            @readfile($file_path);
            exit;
        }
    } else {
        wp_redirect($error_page_url);
    }

    die;
}

add_filter('wp_jobsearch_email_cvfile_downlod_url', 'wp_jobsearch_email_cvfile_downlod_url', 10, 3);

function wp_jobsearch_email_cvfile_downlod_url($url, $attach_id = '', $email_app_id = '')
{

    $url = add_query_arg(array('action' => 'wp_jobsearch_get_email_cv_file_download', 'file_id' => $attach_id, 'eaap_id' => $email_app_id), admin_url('admin-ajax.php'));

    return $url;
}

function jobsearch_in_aplyjob_uplodin_logcand_cover_html($candidate_id) {
    global $jobsearch_plugin_options;
    ?>
    <div class="jobsearch-candcover-uplodholdr">
        <?php
        $cand_cover_file = get_post_meta($candidate_id, 'candidate_cover_letter_file', true);
        $cover_rand_id = rand(100000, 999999);
        $have_cover = false;
        if (!empty($cand_cover_file)) {
            $filename = isset($cand_cover_file['file_name']) ? $cand_cover_file['file_name'] : '';
            $filetype = isset($cand_cover_file['mime_type']) ? $cand_cover_file['mime_type'] : '';
            $fileuplod_time = isset($cand_cover_file['time']) ? $cand_cover_file['time'] : '';
            $file_attach_id = $file_uniqid = isset($cand_cover_file['file_id']) ? $cand_cover_file['file_id'] : '';
            $file_url = isset($cand_cover_file['file_url']) ? $cand_cover_file['file_url'] : '';

            $file_url = apply_filters('wp_jobsearch_user_coverfile_downlod_url', $file_url, $file_uniqid, $candidate_id);

            $cv_file_title = $filename;

            $attach_date = $fileuplod_time;
            $attach_mime = isset($filetype['type']) ? $filetype['type'] : '';

            if ($attach_mime == 'application/pdf') {
                $attach_icon = 'fa fa-file-pdf-o';
            } else if ($attach_mime == 'application/msword' || $attach_mime == 'application/vnd.openxmlformats-officedocument.wordprocessingml.document') {
                $attach_icon = 'fa fa-file-word-o';
            } else if ($attach_mime == 'text/plain') {
                $attach_icon = 'fa fa-file-text-o';
            } else if ($attach_mime == 'application/vnd.ms-excel' || $attach_mime == 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet') {
                $attach_icon = 'fa fa-file-excel-o';
            } else if ($attach_mime == 'image/jpeg' || $attach_mime == 'image/png') {
                $attach_icon = 'fa fa-file-image-o';
            } else {
                $attach_icon = 'fa fa-file-word-o';
            }
            if (!empty($filetype)) {
                $have_cover = true;
                ?>
                <ul id="cover-uploded-<?php echo ($cover_rand_id) ?>" class="user-cover-uploded user-cvs-list">
                    <li class="active">
                        <i class="<?php echo($attach_icon) ?>"></i>
                        <label for="cv_file_<?php echo($file_attach_id) ?>">
                            <input id="cv_file_<?php echo($file_attach_id) ?>"
                                   type="radio" class="cv_file_item"
                                   name="cover_file_item" checked="checked"
                                   value="<?php echo($file_attach_id) ?>">
                            <?php echo(strlen($cv_file_title) > 40 ? substr($cv_file_title, 0, 40) . '...' : $cv_file_title) ?>
                            <?php
                            if ($attach_date != '') {
                                ?>
                                <span class="upload-datetime"><i class="fa fa-calendar"></i> <?php echo date_i18n(get_option('date_format'), ($attach_date)) . ' ' . date_i18n(get_option('time_format'), ($attach_date)) ?></span>
                                <?php
                            }
                            ?>
                        </label>
                    </li>
                </ul>
                <?php
            }
        }
        if (!$have_cover) {
            echo '<ul id="cover-uploded-' . $cover_rand_id . '" class="user-cover-uploded" style="display:none;"></ul>';
        }

        $file_sizes_arr = array(
            '300' => __('300KB', 'wp-jobsearch'),
            '500' => __('500KB', 'wp-jobsearch'),
            '750' => __('750KB', 'wp-jobsearch'),
            '1024' => __('1Mb', 'wp-jobsearch'),
            '2048' => __('2Mb', 'wp-jobsearch'),
            '3072' => __('3Mb', 'wp-jobsearch'),
            '4096' => __('4Mb', 'wp-jobsearch'),
            '5120' => __('5Mb', 'wp-jobsearch'),
            '10120' => __('10Mb', 'wp-jobsearch'),
            '50120' => __('50Mb', 'wp-jobsearch'),
            '100120' => __('100Mb', 'wp-jobsearch'),
            '200120' => __('200Mb', 'wp-jobsearch'),
            '300120' => __('300Mb', 'wp-jobsearch'),
            '500120' => __('500Mb', 'wp-jobsearch'),
            '1000120' => __('1Gb', 'wp-jobsearch'),
        );
        $cvfile_size = '5120';
        $cvfile_size_str = __('5 Mb', 'wp-jobsearch');
        $cand_cv_file_size = isset($jobsearch_plugin_options['cand_cover_letter_file_size']) ? $jobsearch_plugin_options['cand_cover_letter_file_size'] : '';
        if (isset($file_sizes_arr[$cand_cv_file_size])) {
            $cvfile_size = $cand_cv_file_size;
            $cvfile_size_str = $file_sizes_arr[$cand_cv_file_size];
        }

        $filesize_act = ($cvfile_size/1000);

        $cand_files_types = isset($jobsearch_plugin_options['cand_cover_letter_types']) ? $jobsearch_plugin_options['cand_cover_letter_types'] : '';
        if (empty($cand_files_types)) {
            $cand_files_types = array(
                'application/msword',
                'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
                'application/pdf',
            );
        }
        $sutable_files_arr = array();
        $sutable_files_mimes = array();
        $file_typs_comarr = array(
            'text/plain' => __('text', 'wp-jobsearch'),
            'image/jpeg' => __('jpeg', 'wp-jobsearch'),
            'image/png' => __('png', 'wp-jobsearch'),
            'application/msword' => __('doc', 'wp-jobsearch'),
            'application/vnd.openxmlformats-officedocument.wordprocessingml.document' => __('docx', 'wp-jobsearch'),
            'application/vnd.ms-excel' => __('xls', 'wp-jobsearch'),
            'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet' => __('xlsx', 'wp-jobsearch'),
            'application/pdf' => __('pdf', 'wp-jobsearch'),
        );
        foreach ($file_typs_comarr as $file_typ_key => $file_typ_comar) {
            if (in_array($file_typ_key, $cand_files_types)) {
                $sutable_files_arr[] = '.' . $file_typ_comar;
                $sutable_files_mimes[] = $file_typ_key;
            }
        }
        $sutable_files_str = implode(', ', $sutable_files_arr);
        ?>
        <div id="jobsearch-upload-cover-<?php echo ($cover_rand_id) ?>" class="jobsearchupoldcover-con jobsearch-fileUpload">
            <span><i class="jobsearch-icon jobsearch-arrows-2"></i> <?php esc_html_e('Upload Cover Letter', 'wp-jobsearch') ?></span>
            <input name="candidate_apply_cover" type="file" data-id="<?php echo ($cover_rand_id) ?>"
                   class="upload jobsearch-upload jobsearch-uploadfile-field"
                   onchange="jobsearch_upload_cand_aply_cover_letter(event)">
            <div class="fileUpLoader"></div>
        </div>
        <div class="jobsearch-fileUpload-info">
            <p><?php printf(__('To upload file size is <strong>(Max %s)</strong> <strong class="uplod-info-and">and</strong> allowed file types are <strong>(%s)</strong>', 'wp-jobsearch'), $cvfile_size_str, $sutable_files_str) ?></p>
        </div>
    </div>
    <?php
}

add_action('wp_ajax_jobsearch_aplyjob_uplodin_candidate_cover_file', 'jobsearch_aplyjob_uplodin_candidate_cover_file');

function jobsearch_aplyjob_uplodin_candidate_cover_file() {

    global $jobsearch_plugin_options;

    $nonce_val = sanitize_key(wp_unslash($_POST['_nonce']));
    if (!wp_verify_nonce($nonce_val, 'jobsearch_ajax_nonce')) {
        $msg = esc_html__('You are not allowed to do this.', 'wp-jobsearch');
        echo json_encode(array('msg' => $msg, 'error' => '1'));
        die;
    }

    $user_id = get_current_user_id();

    $user_is_candidate = jobsearch_user_is_candidate($user_id);

    if ($user_is_candidate) {
        if (jobsearch_candidate_not_allow_to_mod()) {
            $msg = esc_html__('You are not allowed to upload files.', 'wp-jobsearch');
            echo json_encode(array('err_msg' => $msg));
            die;
        }

        $candidate_id = jobsearch_get_user_candidate_id($user_id);

        $_file_key_name = 'file';
        if (isset($_FILES['candidate_apply_cover'])) {
            $_file_key_name = 'candidate_apply_cover';
        }

        $atach_url = jobsearch_upload_cand_cover_letter($_file_key_name, $candidate_id);

        if ($atach_url != '') {
            $file_url = $atach_url;

            $file_uniqid = uniqid();

            $filename = basename($file_url);
            $filetype = wp_check_filetype($filename, null);
            $fileuplod_time = current_time('timestamp');

            $arg_arr = array(
                'file_name' => $filename,
                'mime_type' => $filetype,
                'time' => $fileuplod_time,
                'file_url' => $file_url,
                'file_id' => $file_uniqid,
            );
            update_post_meta($candidate_id, 'candidate_cover_letter_file', $arg_arr);

            $cv_file_title = $filename;

            $attach_date = $fileuplod_time;
            $attach_mime = isset($filetype['type']) ? $filetype['type'] : '';

            if ($attach_mime == 'application/pdf') {
                $attach_icon = 'fa fa-file-pdf-o';
            } else if ($attach_mime == 'application/msword' || $attach_mime == 'application/vnd.openxmlformats-officedocument.wordprocessingml.document') {
                $attach_icon = 'fa fa-file-word-o';
            } else if ($attach_mime == 'text/plain') {
                $attach_icon = 'fa fa-file-text-o';
            } else if ($attach_mime == 'application/vnd.ms-excel' || $attach_mime == 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet') {
                $attach_icon = 'fa fa-file-excel-o';
            } else if ($attach_mime == 'image/jpeg' || $attach_mime == 'image/png') {
                $attach_icon = 'fa fa-file-image-o';
            } else {
                $attach_icon = 'fa fa-file-word-o';
            }

            $file_url = apply_filters('wp_jobsearch_user_coverfile_downlod_url', $file_url, $file_uniqid, $candidate_id);

            ob_start();
            ?>
            <li class="active">
                <i class="<?php echo($attach_icon) ?>"></i>
                <label for="cv_file_<?php echo($file_uniqid) ?>">
                    <input id="cv_file_<?php echo($file_uniqid) ?>"
                           type="radio" class="cv_file_item"
                           name="cover_file_item" checked="checked"
                           value="<?php echo($file_uniqid) ?>">
                    <?php echo(strlen($cv_file_title) > 40 ? substr($cv_file_title, 0, 40) . '...' : $cv_file_title) ?>
                    <?php
                    if ($attach_date != '') {
                        ?>
                        <span class="upload-datetime"><i class="fa fa-calendar"></i> <?php echo date_i18n(get_option('date_format'), ($attach_date)) . ' ' . date_i18n(get_option('time_format'), ($attach_date)) ?></span>
                        <?php
                    }
                    ?>
                </label>
            </li>
            <?php
            $file_html = ob_get_clean();

            echo json_encode(array('fileUrl' => $file_url, 'filehtml' => $file_html));
        }
    }
    wp_die();
}

function jobsearch_in_aplyjob_uplodin_withoutlog_cover_html() {
    global $jobsearch_plugin_options;
    ?>
    <div class="jobsearch-candcover-uplodholdr">
        <?php
        $cover_rand_id = rand(100000, 999999);

        $file_sizes_arr = array(
            '300' => __('300KB', 'wp-jobsearch'),
            '500' => __('500KB', 'wp-jobsearch'),
            '750' => __('750KB', 'wp-jobsearch'),
            '1024' => __('1Mb', 'wp-jobsearch'),
            '2048' => __('2Mb', 'wp-jobsearch'),
            '3072' => __('3Mb', 'wp-jobsearch'),
            '4096' => __('4Mb', 'wp-jobsearch'),
            '5120' => __('5Mb', 'wp-jobsearch'),
            '10120' => __('10Mb', 'wp-jobsearch'),
            '50120' => __('50Mb', 'wp-jobsearch'),
            '100120' => __('100Mb', 'wp-jobsearch'),
            '200120' => __('200Mb', 'wp-jobsearch'),
            '300120' => __('300Mb', 'wp-jobsearch'),
            '500120' => __('500Mb', 'wp-jobsearch'),
            '1000120' => __('1Gb', 'wp-jobsearch'),
        );
        $cvfile_size = '5120';
        $cvfile_size_str = __('5 Mb', 'wp-jobsearch');
        $cand_cv_file_size = isset($jobsearch_plugin_options['cand_cover_letter_file_size']) ? $jobsearch_plugin_options['cand_cover_letter_file_size'] : '';
        if (isset($file_sizes_arr[$cand_cv_file_size])) {
            $cvfile_size = $cand_cv_file_size;
            $cvfile_size_str = $file_sizes_arr[$cand_cv_file_size];
        }

        $filesize_act = ($cvfile_size/1000);

        $cand_files_types = isset($jobsearch_plugin_options['cand_cover_letter_types']) ? $jobsearch_plugin_options['cand_cover_letter_types'] : '';
        if (empty($cand_files_types)) {
            $cand_files_types = array(
                'application/msword',
                'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
                'application/pdf',
            );
        }
        $sutable_files_arr = array();
        $sutable_files_mimes = array();
        $file_typs_comarr = array(
            'text/plain' => __('text', 'wp-jobsearch'),
            'image/jpeg' => __('jpeg', 'wp-jobsearch'),
            'image/png' => __('png', 'wp-jobsearch'),
            'application/msword' => __('doc', 'wp-jobsearch'),
            'application/vnd.openxmlformats-officedocument.wordprocessingml.document' => __('docx', 'wp-jobsearch'),
            'application/vnd.ms-excel' => __('xls', 'wp-jobsearch'),
            'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet' => __('xlsx', 'wp-jobsearch'),
            'application/pdf' => __('pdf', 'wp-jobsearch'),
        );
        foreach ($file_typs_comarr as $file_typ_key => $file_typ_comar) {
            if (in_array($file_typ_key, $cand_files_types)) {
                $sutable_files_arr[] = '.' . $file_typ_comar;
                $sutable_files_mimes[] = $file_typ_key;
            }
        }
        $sutable_files_str = implode(', ', $sutable_files_arr);
        ?>
        <div id="jobsearch-upload-cover-<?php echo ($cover_rand_id) ?>" class="jobsearchupoldcover-con jobsearch-fileUpload">
            <span><i class="jobsearch-icon jobsearch-arrows-2"></i> <?php esc_html_e('Upload Cover Letter', 'wp-jobsearch') ?></span>
            <input name="candidate_apply_cover" type="file" data-id="<?php echo ($cover_rand_id) ?>" class="upload jobsearch-upload jobsearch-uploadfile-field">
        </div>
        <div class="jobsearch-fileUpload-info">
            <p><?php printf(__('To upload file size is <strong>(Max %s)</strong> <strong class="uplod-info-and">and</strong> allowed file types are <strong>(%s)</strong>', 'wp-jobsearch'), $cvfile_size_str, $sutable_files_str) ?></p>
        </div>
    </div>
    <?php
}

function jobsearch_show_cand_onaply_pckges()
{
    global $jobsearch_plugin_options;
    $free_job_apply = isset($jobsearch_plugin_options['free-job-apply-allow']) ? $jobsearch_plugin_options['free-job-apply-allow'] : '';
    if ($free_job_apply != 'on' && is_user_logged_in()) {
        $current_user_id = get_current_user_id();
        $candidate_id = jobsearch_get_user_candidate_id($current_user_id);
        if ($candidate_id > 0) {
            $user_app_pkg = jobsearch_candidate_first_subscribed_app_pkg();
            if (!$user_app_pkg) {
                $user_app_pkg = jobsearch_candprof_first_pkg_subscribed();
            }
            if (!$user_app_pkg) {
                return true;
            }
        }
    }
    return false;
}

function jobsearch_cand_inaply_slected_pckges()
{
    global $jobsearch_plugin_options;
    $onaply_slectd_pkgs = isset($jobsearch_plugin_options['preselect_onaply_appkgs']) ? $jobsearch_plugin_options['preselect_onaply_appkgs'] : '';
    if (empty($onaply_slectd_pkgs)) {
        $onaply_slectd_pkgs = array(0);
    }
    $args = array(
        'post_type' => 'package',
        'posts_per_page' => -1,
        'post_status' => 'publish',
        'fields' => 'ids',
        'order' => 'ASC',
        'orderby' => 'title',
        'meta_query' => array(
            array(
                'key' => 'jobsearch_field_package_type',
                'value' => array('candidate', 'candidate_profile'),
                'compare' => 'IN',
            ),
        ),
    );
    $args['post__in'] = $onaply_slectd_pkgs;
    $pkgs_query = new WP_Query($args);
    $pkgs_items = $pkgs_query->posts;
    return $pkgs_items;
}

function jobsearch_cand_onaply_pckges_list()
{
    global $jobsearch_plugin_options;
    $onaply_slectd_pkgs = isset($jobsearch_plugin_options['preselect_onaply_appkgs']) ? $jobsearch_plugin_options['preselect_onaply_appkgs'] : '';

    $args = array(
        'post_type' => 'package',
        'posts_per_page' => -1,
        'post_status' => 'publish',
        'fields' => 'ids',
        'order' => 'ASC',
        'orderby' => 'title',
        'meta_query' => array(
            array(
                'key' => 'jobsearch_field_package_type',
                'value' => array('candidate', 'candidate_profile'),
                'compare' => 'IN',
            ),
        ),
    );
    if (!empty($onaply_slectd_pkgs)) {
        $args['post__in'] = $onaply_slectd_pkgs;
    }
    $pkgs_query = new WP_Query($args);
    $pkgs_items = $pkgs_query->posts;
    return $pkgs_items;
}

function jobsearch_cand_onaply_pckge_chose_html()
{
    $onaply_pckgs_list = jobsearch_cand_onaply_pckges_list();
    if (!empty($onaply_pckgs_list)) {
        wp_enqueue_script('jobsearch-packages-scripts');
        ?>
        <div class="jobsearch-onaply-priceplan">
            <?php
            foreach ($onaply_pckgs_list as $pkg_id) {
                $pkg_type = get_post_meta($pkg_id, 'jobsearch_field_charges_type', true);
                $pkg_price = get_post_meta($pkg_id, 'jobsearch_field_package_price', true);
                $pkg_recomnded = get_post_meta($pkg_id, 'jobsearch_field_feature_pkg', true);
                $pkg_exfield_title = get_post_meta($pkg_id, 'jobsearch_field_package_exfield_title', true);
                $pkg_exfield_status = get_post_meta($pkg_id, 'jobsearch_field_package_exfield_status', true);
                $package_type = get_post_meta($pkg_id, 'jobsearch_field_package_type', true);

                $unlimited_pkg = get_post_meta($pkg_id, 'jobsearch_field_unlimited_pkg', true);
                $pkg_exp_dur = get_post_meta($pkg_id, 'jobsearch_field_package_expiry_time', true);
                $pkg_exp_dur_unit = get_post_meta($pkg_id, 'jobsearch_field_package_expiry_time_unit', true);

                $expiry_text = absint($pkg_exp_dur) . ' ' . jobsearch_get_duration_unit_str($pkg_exp_dur_unit);
                if ($unlimited_pkg == 'on') {
                    $expiry_text = esc_html__('Never Expire', 'wp-jobsearch');
                }

                $buy_btn_class = 'jobsearch-subscribe-candidate-pkg';
                if ($package_type == 'candidate_profile') {
                    $buy_btn_class = 'jobsearch-subscand-profile-pkg';
                }
                ?>
                <div class="jobsearch-popupplan-wrap<?php echo($pkg_recomnded == 'yes' ? ' jobsearch-recmnded-plan' : '') ?>">
                    <div class="jobsearch-popupplan">
                        <h2><?php echo get_the_title($pkg_id) ?></h2>
                        <?php
                        if (!empty($pkg_exfield_title)) { ?>
                            <ul class="popupplan-features-list">
                                <?php
                                if (!empty($pkg_exfield_title)) {
                                    $_exf_counter = 0;
                                    foreach ($pkg_exfield_title as $_exfield_title) {
                                        $_exfield_status = isset($pkg_exfield_status[$_exf_counter]) ? $pkg_exfield_status[$_exf_counter] : '';
                                        ?>
                                        <li<?php echo($_exfield_status == 'active' ? ' class="active"' : '') ?>><i class="fa fa-check-square-o"></i><?php echo($_exfield_title) ?></li>
                                        <?php
                                        $_exf_counter++;
                                    }
                                }
                                ?>
                            </ul>
                            <?php
                        }
                        ?>
                        <div class="popupplan-pricebtn-con">
                            <div class="jobsearch-poprice-wrp">
                                <?php
                                if ($pkg_type == 'paid') {
                                    $ret_price = '';
                                    if (!empty($pkg_price)) {
                                        if (function_exists('wc_price')) {
                                            $ret_price = wc_price($pkg_price);
                                            $ret_price = wp_kses($pkg_price, array());
                                        } else {
                                            $ret_price = preg_replace("/[^0-9,.]+/iu", "", $pkg_price);
                                            $ret_price = number_format($ret_price, 2, ".", ",");
                                        }
                                    }
                                    if (!empty($ret_price)) {
                                        echo '<span class="price-holdr">' . jobsearch_get_currency_symbol() . '' . ($ret_price) . ' / </span>' . '<span class="expiry-holdr">' . $expiry_text . '</span>';
                                    }
                                } else {
                                    echo '<span class="price-holdr">' . esc_html__('Free', 'wp-jobsearch') . '</span>';
                                }
                                ?>
                            </div>
                            <div class="jobsearch-popupplan-btn">
                                <a href="javascript:void(0);"
                                   class="<?php echo($buy_btn_class) ?>"
                                   data-id="<?php echo($pkg_id) ?>"><?php esc_html_e('Select Plan', 'wp-jobsearch') ?></a>
                            </div>
                        </div>
                    </div>
                </div>
                <?php
            }
            ?>
        </div>
        <?php
    }
}

// get user package used apps
function jobsearch_pckg_order_used_apps($order_id = 0)
{
    $jobsearch_order = '';
    if (function_exists('wc_get_order')) {
        $jobsearch_order = wc_get_order($order_id);
    }
    $apps_list_count = 0;
    if ($order_id > 0 && is_object($jobsearch_order)) {
        $total_apps = $jobsearch_order->get_meta('num_of_apps');
        $apps_list = $jobsearch_order->get_meta('jobsearch_order_apps_list');

        if (!empty($apps_list)) {
            $apps_list_count = count(explode(',', $apps_list));
        }
    }

    return $apps_list_count;
}

// get user package remaining apps
function jobsearch_pckg_order_remaining_apps($order_id = 0)
{
    $remaining_apps = 0;
    if ($order_id > 0) {
        $jobsearch_order = '';
        if (function_exists('wc_get_order')) {
            $jobsearch_order = wc_get_order($order_id);
        }
        if (is_object($jobsearch_order)) {
            $total_apps = $jobsearch_order->get_meta('num_of_apps');
            $used_apps = jobsearch_pckg_order_used_apps($order_id);

            $remaining_apps = $total_apps > $used_apps ? $total_apps - $used_apps : 0;
        }
    }

    return $remaining_apps;
}

// check if user package subscribed
function jobsearch_app_pckg_is_subscribed($pckg_id = 0, $user_id = 0)
{
    if ($user_id <= 0 && is_user_logged_in()) {
        $user_id = get_current_user_id();
    }
    
    $pkgs_query_posts = '';
    if(function_exists('wc_get_orders')){
        $pkgs_query_posts = wc_get_orders(array( 
            'status' => array('wc-completed'),
            'order' => 'DESC',
            'orderby' => 'ID',
            'customer_id' => $user_id,
            'jobsearch_order_package' => $pckg_id,
            'jobsearch_order_user' => $user_id,
            'package_expiry_timestamp' => strtotime(current_time('d-m-Y H:i:s')),
            'package_type' => array('candidate'),
        ));
    }

    if (!empty($pkgs_query_posts)) {
        foreach ($pkgs_query_posts as $order) {
            //'customer_id' => $user_id,
            $jobsearch_order_package = $order->get_meta('jobsearch_order_package');
            $jobsearch_order_user = $order->get_meta('jobsearch_order_user');
            $package_expiry_timestamp = $order->get_meta('package_expiry_timestamp');
            $package_type            = $order->get_meta('package_type');

            if (
                $jobsearch_order_package == $pckg_id && 
                $jobsearch_order_user == $user_id && 
                $package_type == 'candidate' &&
                $package_expiry_timestamp > strtotime(current_time('d-m-Y H:i:s'))
            ) {
                $order_post_id = $order->get_id();
                $remaining_apps = jobsearch_pckg_order_remaining_apps($order_post_id);
                if ($remaining_apps > 0) {
                    return $order_post_id;
                }
            }
        }
    }
    return false;
}

// check if user package subscribed
function jobsearch_candidate_first_subscribed_app_pkg($user_id = 0)
{
    if ($user_id <= 0 && is_user_logged_in()) {
        $user_id = get_current_user_id();
    }
    
    $pkgs_query_posts = '';
    if(function_exists('wc_get_orders')){
        $pkgs_query_posts = wc_get_orders(array( 
            'status' => array('wc-completed'),
            'order' => 'DESC',
            'orderby' => 'ID',
            'customer_id' => $user_id,
            'jobsearch_order_attach_with' => 'package',
            'jobsearch_order_user' => $user_id,
            'package_expiry_timestamp' => strtotime(current_time('d-m-Y H:i:s')),
            'package_type' => array('candidate'),
        ));
    }

    if (!empty($pkgs_query_posts)) {
        foreach ($pkgs_query_posts as $order) {   
              //'customer_id' => $user_id,
              $jobsearch_order_attach_with = $order->get_meta('jobsearch_order_attach_with');
              $jobsearch_order_user = $order->get_meta('jobsearch_order_user');
              $package_expiry_timestamp = $order->get_meta('package_expiry_timestamp');
              $package_type            = $order->get_meta('package_type');
             
  
              if (
                  $jobsearch_order_user == $user_id && 
                  $package_type == 'candidate' && 
                  $jobsearch_order_attach_with == 'package' && 
                  $package_expiry_timestamp > strtotime(current_time('d-m-Y H:i:s'))
              ) {
                $order_post_id = $order->get_id();
                
                //$remaining_apps = jobsearch_candprofpckg_order_remaining_apps($order_post_id);
                $remaining_apps = jobsearch_pckg_order_remaining_apps($order_post_id);
                if ($remaining_apps > 0) {
                    return $order_post_id;
                }
            }
        }
    }
    return false;
}

// check if user app package expired
function jobsearch_app_pckg_order_is_expired($order_id = 0)
{
    $jobsearch_order = '';
    if (function_exists('wc_get_order')) {
        $jobsearch_order = wc_get_order($order_id);
    }
    if ($order_id > 0 && is_object($jobsearch_order)) {
        $order_post_id = $order_id;
        $expiry_timestamp = $jobsearch_order->get_meta('package_expiry_timestamp');


        if ($expiry_timestamp <= strtotime(current_time('d-m-Y H:i:s'))) {
            return true;
        }

        $remaining_apps = jobsearch_pckg_order_remaining_apps($order_post_id);
        if ($remaining_apps < 1) {
            return true;
        }
    } else {
        return true;
    }
    return false;
}

// get used cvs
function jobsearch_candprofpckg_order_used_apps($order_id = 0)
{
    $jobsearch_order = '';
    if (function_exists('wc_get_order')) {
        $jobsearch_order = wc_get_order($order_id);
    }
    $apps_list_count = 0;
    if ($order_id > 0 && is_object($jobsearch_order)) {
        $apps_list = $jobsearch_order->get_meta('jobsearch_order_apps_list');

        if (!empty($apps_list)) {
            $apps_list_count = count(explode(',', $apps_list));
        }
    }

    return $apps_list_count;
}

// get remaining apps
function jobsearch_candprofpckg_order_remaining_apps($order_id = 0)
{
    $remaining_apps = 0;
    $jobsearch_order = '';
    if (function_exists('wc_get_order')) {
        $jobsearch_order = wc_get_order($order_id);
    }
    if ($order_id > 0 && is_object($jobsearch_order)) {
        $total_apps = $jobsearch_order->get_meta('candprof_num_apps');
        $used_apps = jobsearch_candprofpckg_order_used_apps($order_id);

        $remaining_apps = $total_apps > $used_apps ? $total_apps - $used_apps : 0;
    }

    return $remaining_apps;
}

// check if user package subscribed
function jobsearch_candprofpckg_is_subscribed($pckg_id = 0, $user_id = 0)
{
    if ($user_id <= 0 && is_user_logged_in()) {
        $user_id = get_current_user_id();
    }
   
    $pkgs_query_posts = '';
    if(function_exists('wc_get_orders')){
        $pkgs_query_posts = wc_get_orders(array( 
            'status' => array('wc-completed'),
            'order' => 'DESC',
            'orderby' => 'ID',
            'customer_id' => $user_id,
            'jobsearch_order_package' => $pckg_id,
            'jobsearch_order_user' => $user_id,
            'package_expiry_timestamp' => strtotime(current_time('d-m-Y H:i:s')),
            'package_type' => array('candidate_profile'),
        ));
    }
    if (!empty($pkgs_query_posts)) {
        foreach ($pkgs_query_posts as $order) {
            $order_post_id = $order->get_id();

            //'customer_id' => $user_id,
            $jobsearch_order_package = $order->get_meta('jobsearch_order_package');
            $jobsearch_order_user = $order->get_meta('jobsearch_order_user');
            $package_expiry_timestamp = $order->get_meta('package_expiry_timestamp');
            $package_type            = $order->get_meta('package_type');

            if (
                $jobsearch_order_user == $user_id && 
                $jobsearch_order_package == $pckg_id && 
                $package_type == 'candidate_profile' && 
                $package_expiry_timestamp > strtotime(current_time('d-m-Y H:i:s'))
            ) {
                $remaining_apps = jobsearch_candprofpckg_order_remaining_apps($order_post_id);
                if ($remaining_apps > 0) {
                    return $order_post_id;
                }
            }
        }
    }
    return false;
}

// check if user package subscribed
function jobsearch_candprof_first_pkg_subscribed($user_id = 0)
{

    if ($user_id <= 0 && is_user_logged_in()) {
        $user_id = get_current_user_id();
    }
    
    $pkgs_query_posts = '';
    if(function_exists('wc_get_orders')){
        $pkgs_query_posts = wc_get_orders(array( 
            'status' => array('wc-completed'),
            'order' => 'DESC',
            'orderby' => 'ID',
            'customer_id' => $user_id,
            'jobsearch_order_user' => $user_id,
            'package_expiry_timestamp' => strtotime(current_time('d-m-Y H:i:s')),
            'package_type' => array('candidate_profile'),
        ));
    }
    if (!empty($pkgs_query_posts)) {
        foreach ($pkgs_query_posts as $order) {           
             $jobsearch_order_user = $order->get_meta('jobsearch_order_user');
             $package_expiry_timestamp = $order->get_meta('package_expiry_timestamp');
             $package_type            = $order->get_meta('package_type');
 
             if (
                 $jobsearch_order_user == $user_id && 
                 $package_type == 'candidate_profile' && 
                 $package_expiry_timestamp > strtotime(current_time('d-m-Y H:i:s'))
             ) {
                $order_post_id = $order->get_id();
                $remaining_apps = jobsearch_candprofpckg_order_remaining_apps($order_post_id);
                if ($remaining_apps > 0) {
                    return $order_post_id;
                }
            }
        }
    }
    return false;
}

// check if user package subscribed
function jobsearch_candprofpckg_order_is_expired($order_id = 0)
{

    $jobsearch_order = '';
    if (function_exists('wc_get_order')) {
        $jobsearch_order = wc_get_order($order_id);
    }
    if ($order_id > 0 && is_object($jobsearch_order)) {
        $order_post_id = $order_id;
        $expiry_timestamp = $jobsearch_order->get_meta('package_expiry_timestamp');


        if ($expiry_timestamp <= strtotime(current_time('d-m-Y H:i:s'))) {
            return true;
        }

        $remaining_apps = jobsearch_candprofpckg_order_remaining_apps($order_post_id);

        if ($remaining_apps < 1) {
            return true;
        }
    } else {
        return true;
    }
    return false;
}

//
function jobsearch_cand_profile_pckg_is_subscribed($pckg_id = 0, $user_id = 0)
{
    if ($user_id <= 0 && is_user_logged_in()) {
        $user_id = get_current_user_id();
    }
    if ( !class_exists( 'woocommerce' ) ) { return false; }
    $pkgs_query_posts = wc_get_orders(array( 
        'status' => array('wc-completed'),
        'order' => 'DESC',
        'orderby' => 'ID',
        'customer_id' => $user_id,
        'jobsearch_order_user' => $user_id,
        'jobsearch_order_package' => $pckg_id,
        'package_expiry_timestamp' => strtotime(current_time('d-m-Y H:i:s')),
        'package_type' => array('candidate_profile'),
    ));
    if (!empty($pkgs_query_posts)) {
        foreach ($pkgs_query_posts as $order) {           

            //'customer_id' => $user_id,
            $jobsearch_order_package = $order->get_meta('jobsearch_order_package');
            $jobsearch_order_user = $order->get_meta('jobsearch_order_user');
            $package_expiry_timestamp = $order->get_meta('package_expiry_timestamp');
            $package_type            = $order->get_meta('package_type');

            if (
                $jobsearch_order_user == $user_id && 
                $jobsearch_order_package == $pckg_id && 
                $package_type == 'candidate_profile' && 
                $package_expiry_timestamp > strtotime(current_time('d-m-Y H:i:s'))
            ) {
                $order_post_id = $order->get_id();
                if ($order_post_id) {
                    return $order_post_id;
                }
            }
        }
    }
    
    return false;
}

function jobsearch_cand_profile_pkg_is_expired($order_id = 0)
{

    $jobsearch_order = '';
    if (function_exists('wc_get_order')) {
        $jobsearch_order = wc_get_order($order_id);
    }
    if ($order_id > 0 && is_object($jobsearch_order)) {
        $order_post_id = $order_id;
        $expiry_timestamp = $jobsearch_order->get_meta('package_expiry_timestamp');


        if ($expiry_timestamp <= strtotime(current_time('d-m-Y H:i:s'))) {
            return true;
        }
    } else {
        return true;
    }

    return false;
}

//
//
function jobsearch_member_promote_profile_pkg_sub($pckg_id = 0, $user_id = 0)
{
    if ($user_id <= 0 && is_user_logged_in()) {
        $user_id = get_current_user_id();
    }
    if ( !class_exists( 'woocommerce' ) ) { return false; }
    $pkgs_query_posts = wc_get_orders(array( 
        'status' => array('wc-completed'),
        'order' => 'DESC',
        'orderby' => 'ID',
        'customer_id' => $user_id,
        'jobsearch_order_user' => $user_id,
        'jobsearch_order_package' => $pckg_id,
        'jobsearch_order_attach_with' => 'package',
        'package_expiry_timestamp' => strtotime(current_time('d-m-Y H:i:s')),
        'package_type' => array('promote_profile'),
    ));
    $order_post_id = false;
    if (!empty($pkgs_query_posts)) {
        foreach ($pkgs_query_posts as $order) {
            //'customer_id' => $user_id,
            $jobsearch_order_package = $order->get_meta('jobsearch_order_package');
            $jobsearch_order_attach_with = $order->get_meta('jobsearch_order_attach_with');
            $jobsearch_order_user = $order->get_meta('jobsearch_order_user');
            $package_expiry_timestamp = $order->get_meta('package_expiry_timestamp');
            $package_type            = $order->get_meta('package_type');

            if (
                $jobsearch_order_user == $user_id && 
                $jobsearch_order_package == $pckg_id && 
                $package_type == 'promote_profile' && 
                $jobsearch_order_attach_with == 'package' && 
                $package_expiry_timestamp > strtotime(current_time('d-m-Y H:i:s'))
            ) {
                $order_post_id = $order->get_id();
                if ($order_post_id) {
                    break;
                }
            }
        }
        
    }    
    return $order_post_id;   
}

function jobsearch_member_first_promote_profile_pkg($user_id = 0)
{
    if ($user_id <= 0 && is_user_logged_in()) {
        $user_id = get_current_user_id();
    }
    if ( !class_exists( 'woocommerce' ) ) { return false; }
    $pkgs_query_posts = wc_get_orders(array( 
        'status' => array('wc-completed'),
        'order' => 'DESC',
        'orderby' => 'ID',
        'customer_id' => $user_id,
        'jobsearch_order_user' => $user_id,
        'jobsearch_order_attach_with' => 'package',
        'package_expiry_timestamp' => strtotime(current_time('d-m-Y H:i:s')),
        'package_type' => array('promote_profile'),
    ));
    $order_post_id = false;
    if (!empty($pkgs_query_posts)) {
        foreach ($pkgs_query_posts as $order) {
            //'customer_id' => $user_id,
            $jobsearch_order_package = $order->get_meta('jobsearch_order_package');
            $jobsearch_order_attach_with = $order->get_meta('jobsearch_order_attach_with');
            $jobsearch_order_user = $order->get_meta('jobsearch_order_user');
            $package_expiry_timestamp = $order->get_meta('package_expiry_timestamp');
            $package_type = $order->get_meta('package_type');

            if (
                $jobsearch_order_user == $user_id && 
                $package_type == 'promote_profile' && 
                $jobsearch_order_attach_with == 'package' && 
                $package_expiry_timestamp > strtotime(current_time('d-m-Y H:i:s'))
            ) {
                $order_post_id = $order->get_id();
                if ($order_post_id) {
                    break;
                }
            }
        }
        
    }    
    return $order_post_id;
}

function jobsearch_promote_profile_pkg_is_expired($order_id = 0)
{
    $jobsearch_order = '';
    if (function_exists('wc_get_order')) {
        $jobsearch_order = wc_get_order($order_id);
    }
    if ($order_id > 0 && is_object($jobsearch_order)) {
        $expiry_timestamp = $jobsearch_order->get_meta('package_expiry_timestamp');

        if ($expiry_timestamp <= current_time('timestamp')) {
            return true;
        }
    } else {
        return true;
    }
    return false;
}

function jobsearch_member_urgent_pkg_sub($pckg_id = 0, $user_id = 0)
{
    if ($user_id <= 0 && is_user_logged_in()) {
        $user_id = get_current_user_id();
    }
    if ( !class_exists( 'woocommerce' ) ) { return false; }
    $pkgs_query_posts = wc_get_orders(array( 
        'status' => array('wc-completed'),
        'order' => 'DESC',
        'orderby' => 'ID',
        'customer_id' => $user_id,
        'jobsearch_order_user' => $user_id,
        'jobsearch_order_package' => $pckg_id,
        'jobsearch_order_attach_with' => 'package',
        'package_expiry_timestamp' => strtotime(current_time('d-m-Y H:i:s')),
        'package_type' => array('urgent_pkg'),
    ));
    $order_post_id = false;
    if (!empty($pkgs_query_posts)) {
        foreach ($pkgs_query_posts as $order) {
            //'customer_id' => $user_id,
            $jobsearch_order_package = $order->get_meta('jobsearch_order_package');
            $jobsearch_order_attach_with = $order->get_meta('jobsearch_order_attach_with');
            $jobsearch_order_user = $order->get_meta('jobsearch_order_user');
            $package_expiry_timestamp = $order->get_meta('package_expiry_timestamp');
            $package_type            = $order->get_meta('package_type');

            if (
                $jobsearch_order_user == $user_id && 
                $jobsearch_order_package == $pckg_id && 
                $package_type == 'urgent_pkg' && 
                $jobsearch_order_attach_with == 'package' && 
                $package_expiry_timestamp > strtotime(current_time('d-m-Y H:i:s'))
            ) {
                $order_post_id = $order->get_id();
                if ($order_post_id) {
                    break;
                }
            }
        }
        
    }    
    return $order_post_id;
}

function jobsearch_member_first_urgent_pkg($user_id = 0)
{
    if ($user_id <= 0 && is_user_logged_in()) {
        $user_id = get_current_user_id();
    }
    if ( !class_exists( 'woocommerce' ) ) { return false; }
    $pkgs_query_posts = wc_get_orders(array( 
        'status' => array('wc-completed'),
        'order' => 'DESC',
        'orderby' => 'ID',
        'jobsearch_order_user' => $user_id,
        'jobsearch_order_attach_with' => 'package',
        'package_expiry_timestamp' => strtotime(current_time('d-m-Y H:i:s')),
        'package_type' => array('urgent_pkg'),
    ));
    $order_post_id = false;
    if (!empty($pkgs_query_posts)) {
        foreach ($pkgs_query_posts as $order) {
            //'customer_id' => $user_id,
            $jobsearch_order_package = $order->get_meta('jobsearch_order_package');
            $jobsearch_order_attach_with = $order->get_meta('jobsearch_order_attach_with');
            $jobsearch_order_user = $order->get_meta('jobsearch_order_user');
            $package_expiry_timestamp = $order->get_meta('package_expiry_timestamp');
            $package_type            = $order->get_meta('package_type');

            if (
                $jobsearch_order_user == $user_id && 
                $package_type == 'urgent_pkg' && 
                $jobsearch_order_attach_with == 'package' && 
                $package_expiry_timestamp > strtotime(current_time('d-m-Y H:i:s'))
            ) {
                $order_post_id = $order->get_id();
                if ($order_post_id) {
                    break;
                }
            }
        }
        
    }    
    return $order_post_id;
}

function jobsearch_member_urgent_pkg_is_expired($order_id = 0)
{
    $jobsearch_order = '';
    if (function_exists('wc_get_order')) {
        $jobsearch_order = wc_get_order($order_id);
    }
    if ($order_id > 0 && is_object($jobsearch_order)) {
        $expiry_timestamp = $jobsearch_order->get_meta('package_expiry_timestamp');

        if ($expiry_timestamp <= current_time('timestamp')) {
            return true;
        }
    } else {
        return true;
    }
    return false;
}

add_action('jobsearch_before_add_pkge_fields_in_order', 'jobsearch_add_member_profilepkg_attach', 10, 3);

function jobsearch_add_member_profilepkg_attach($package_id, $order_id, $order_pkg_type)
{
    $jobsearch_order = '';
    if (function_exists('wc_get_order')) {
        $jobsearch_order = wc_get_order($order_id);
    }
    if ($order_id > 0 && is_object($jobsearch_order)) {
        $order_user_id = $jobsearch_order->get_meta('jobsearch_order_user');
        if ($order_pkg_type == 'candidate_profile' || $order_pkg_type == 'employer_profile') {
            update_user_meta($order_user_id, 'att_profpckg_orderid', $order_id);
        }
    }
}

add_action('jobsearch_before_add_pkge_fields_in_order', 'jobsearch_add_member_promote_profile_datetime', 10, 3);

function jobsearch_add_member_promote_profile_datetime($package_id, $order_id, $order_pkg_type)
{
    $order_user_id = 0;
    $jobsearch_order = '';
    if (function_exists('wc_get_order')) {
        $jobsearch_order = wc_get_order($order_id);
    }
    if ($order_id > 0 && is_object($jobsearch_order)) {
        $order_user_id = $jobsearch_order->get_meta('jobsearch_order_user');
    }
    if ($order_pkg_type == 'promote_profile') {
        $user_is_candidate = jobsearch_user_is_candidate($order_user_id);
        $user_is_employer = jobsearch_user_is_employer($order_user_id);

        if ($user_is_candidate) {
            $candidate_id = jobsearch_get_user_candidate_id($order_user_id);
            update_post_meta($candidate_id, 'promote_profile_substime', current_time('timestamp'));
            update_post_meta($candidate_id, 'att_promote_profile_pkgorder', $order_id);
            delete_post_meta($candidate_id, '_feature_mber_frmadmin');
            delete_post_meta($candidate_id, 'cusemp_feature_fbckend');
            
            do_action('jobsearch_promotprof_pkg_after_buy_cand', $candidate_id, $order_id);
        }
        if ($user_is_employer) {
            $employer_id = jobsearch_get_user_employer_id($order_user_id);
            update_post_meta($employer_id, 'promote_profile_substime', current_time('timestamp'));
            update_post_meta($employer_id, 'att_promote_profile_pkgorder', $order_id);
            delete_post_meta($employer_id, '_feature_mber_frmadmin');
            delete_post_meta($employer_id, 'cusemp_feature_fbckend');
            
            do_action('jobsearch_promotprof_pkg_after_buy_emp', $employer_id, $order_id);
        }
    }
    if ($order_pkg_type == 'employer_profile') {
        $employer_id = jobsearch_get_user_employer_id($order_user_id);
        $pkg_with_promote = get_post_meta($package_id, 'jobsearch_field_emprof_promote_profile', true);
        if ($pkg_with_promote == 'on') {
            update_post_meta($employer_id, 'promote_profile_substime', current_time('timestamp'));
            update_post_meta($employer_id, 'att_promote_profile_pkgorder', $order_id);
            delete_post_meta($employer_id, '_feature_mber_frmadmin');
            delete_post_meta($employer_id, 'cusemp_feature_fbckend');
        }
    }
    if ($order_pkg_type == 'candidate_profile') {
        $candidate_id = jobsearch_get_user_candidate_id($order_user_id);
        $pkg_with_promote = get_post_meta($package_id, 'jobsearch_field_candprof_promote_profile', true);
        if ($pkg_with_promote == 'on') {
            update_post_meta($candidate_id, 'promote_profile_substime', current_time('timestamp'));
            update_post_meta($candidate_id, 'att_promote_profile_pkgorder', $order_id);
            delete_post_meta($candidate_id, '_feature_mber_frmadmin');
            delete_post_meta($candidate_id, 'cusemp_feature_fbckend');
        }
    }
}

add_action('jobsearch_before_add_pkge_fields_in_order', 'jobsearch_add_member_urgentpkg_attach', 10, 3);

function jobsearch_add_member_urgentpkg_attach($package_id, $order_id, $order_pkg_type)
{
    $jobsearch_order = '';
    if (function_exists('wc_get_order')) {
        $jobsearch_order = wc_get_order($order_id);
    }
    if ($order_id > 0 && is_object($jobsearch_order)) {
        $order_user_id = $jobsearch_order->get_meta('jobsearch_order_user');
    }
    if ($order_pkg_type == 'urgent_pkg') {
        $user_is_candidate = jobsearch_user_is_candidate($order_user_id);
        $user_is_employer = jobsearch_user_is_employer($order_user_id);

        if ($user_is_candidate) {
            $candidate_id = jobsearch_get_user_candidate_id($order_user_id);
            update_post_meta($candidate_id, 'urgent_pkg_substime', current_time('timestamp'));
            update_post_meta($candidate_id, 'att_urgent_pkg_orderid', $order_id);
        }
        if ($user_is_employer) {
            $employer_id = jobsearch_get_user_employer_id($order_user_id);
            update_post_meta($employer_id, 'urgent_pkg_substime', current_time('timestamp'));
            update_post_meta($employer_id, 'att_urgent_pkg_orderid', $order_id);
        }
    }
}

//add_action('init', 'jobsearch_sectors_job_counts_initkey', 5);

function jobsearch_sectors_job_counts_initkey()
{
    global $wpdb, $sitepress;

    $cachetime = 900;
    $transient = 'jobsearch_sectors_job_counts_initkey';
    if (function_exists('icl_object_id')) {
        $transient = 'jobsearch_sectors_job_counts_initkey_' . $sitepress->get_current_language();
    }

    $check_transient = get_transient($transient);
    if (empty($check_transient)) {
        $cats_query = "SELECT terms.term_id FROM $wpdb->terms AS terms";
        $cats_query .= " LEFT JOIN $wpdb->term_taxonomy AS term_tax ON(terms.term_id = term_tax.term_id) ";
        if (function_exists('icl_object_id')) {
            $trans_tble = $wpdb->prefix . 'icl_translations';
            $cats_query .= " LEFT JOIN $trans_tble AS icl_trans ON (terms.term_id = icl_trans.element_id AND icl_trans.element_type = 'tax_sector')";
        }
        $cats_query .= " WHERE term_tax.taxonomy=%s";
        if (function_exists('icl_object_id')) {
            $cats_query .= " AND icl_trans.language_code='" . $sitepress->get_current_language() . "'";
        }
        $cats_query .= " GROUP BY terms.term_id";
        $get_db_terms = $wpdb->get_col($wpdb->prepare($cats_query, 'sector'));

        if (!empty($get_db_terms) && !is_wp_error($get_db_terms)) {
            foreach ($get_db_terms as $term_id) {
                if (!metadata_exists('term', $term_id, 'active_jobs_count')) {
                    update_term_meta($term_id, 'active_jobs_count', 0);
                }
            }
        }

        set_transient($transient, true, $cachetime);
    }
}

add_action('wp', 'jobsearch_remove_member_promote_profile');

function jobsearch_remove_member_promote_profile()
{
    $cachetime = 900;
    $transient = 'jobsearch_remove_exp_member_promote';

    $current_time = current_time('timestamp');

    $check_transient = get_transient($transient);
    if (empty($check_transient)) {

        $emp_args = array(
            'post_type' => 'employer',
            'posts_per_page' => '100',
            'post_status' => 'publish',
            'fields' => 'ids',
            'meta_query' => array(
                array(
                    'key' => 'att_promote_profile_pkgorder',
                    'value' => '',
                    'compare' => '!=',
                ),
            ),
        );
        $emp_query = new WP_Query($emp_args);
        $emp_posts = $emp_query->posts;
        if (!empty($emp_posts)) {
            foreach ($emp_posts as $employer_id) {
                $mber_feature_bk = get_post_meta($employer_id, '_feature_mber_frmadmin', true);
                $att_promote_pckg = get_post_meta($employer_id, 'att_promote_profile_pkgorder', true);
                $pakg_type = '';
                $jobsearch_order = '';
                if (function_exists('wc_get_order')) {
                    $jobsearch_order = wc_get_order($att_promote_pckg);
                }
                if ($att_promote_pckg > 0 && is_object($jobsearch_order)) {
                    $pakg_type = $jobsearch_order->get_meta('package_type');
                }
                if ($mber_feature_bk != 'yes') {
                    if ($pakg_type == 'employer_profile') {
                        $promote_expiry_timestamp = $jobsearch_order->get_meta('emprof_promote_expiry_timestamp');
                        if ($current_time > $promote_expiry_timestamp) {
                            delete_post_meta($employer_id, 'promote_profile_substime');
                            delete_post_meta($employer_id, 'att_promote_profile_pkgorder');
                        }
                    } else {
                        if (jobsearch_promote_profile_pkg_is_expired($att_promote_pckg)) {
                            delete_post_meta($employer_id, 'promote_profile_substime');
                            delete_post_meta($employer_id, 'att_promote_profile_pkgorder');
                        }
                    }
                }
            }
        }
        wp_reset_postdata();

        $cand_args = array(
            'post_type' => 'candidate',
            'posts_per_page' => '100',
            'post_status' => 'publish',
            'fields' => 'ids',
            'meta_query' => array(
                array(
                    'key' => 'att_promote_profile_pkgorder',
                    'value' => '',
                    'compare' => '!=',
                ),
            ),
        );
        $cand_query = new WP_Query($cand_args);
        $cand_posts = $cand_query->posts;
        if (!empty($cand_posts)) {
            foreach ($cand_posts as $candidate_id) {
                $mber_feature_bk = get_post_meta($candidate_id, '_feature_mber_frmadmin', true);
                $att_promote_pckg = get_post_meta($candidate_id, 'att_promote_profile_pkgorder', true);
                $pakg_type = '';
                $jobsearch_order = '';
                if (function_exists('wc_get_order')) {
                    $jobsearch_order = wc_get_order($att_promote_pckg);
                }
                if ($att_promote_pckg > 0 && is_object($jobsearch_order)) {
                    $pakg_type = $jobsearch_order->get_meta('package_type');
                }
                if ($mber_feature_bk != 'yes') {
                    if ($pakg_type == 'candidate_profile') {
                        $promote_expiry_timestamp = $jobsearch_order->get_meta('candprof_promote_expiry_timestamp');
                        if ($current_time > $promote_expiry_timestamp) {
                            delete_post_meta($candidate_id, 'promote_profile_substime');
                            delete_post_meta($candidate_id, 'att_promote_profile_pkgorder');
                        }
                    } else {
                        if (jobsearch_promote_profile_pkg_is_expired($att_promote_pckg)) {
                            delete_post_meta($candidate_id, 'promote_profile_substime');
                            delete_post_meta($candidate_id, 'att_promote_profile_pkgorder');
                        }
                    }
                }
            }
        }
        wp_reset_postdata();
        //
        set_transient($transient, true, $cachetime);
    }
}

function jobsearch_member_promote_profile_iconlab($id = 0, $view = '')
{

    $promote_pckg_subtime = get_post_meta($id, 'promote_profile_substime', true);
    $att_promote_pckg = get_post_meta($id, 'att_promote_profile_pkgorder', true);

    // form backend
    $mber_feature_bk = get_post_meta($id, '_feature_mber_frmadmin', true);

    $show_badge = false;

    if (!jobsearch_promote_profile_pkg_is_expired($att_promote_pckg)) {
        $show_badge = true;
    }

    if ($mber_feature_bk == 'yes') {
        $show_badge = true;
    } else if ($mber_feature_bk == 'no') {
        $show_badge = false;
    }

    if ($show_badge) {
        ob_start();
        if ($view == 'simple_employer_list_style3') {
            ?>
            <i class="top-companies-list-feature fa fa-star"></i>
        <?php } else if ($view == 'employer_list') { ?>
            <span class="promotepof-badgeemp"><?php esc_html_e('Featured', 'wp-jobsearch') ?> <i class="fa fa-star"
                                                                                                 title="<?php esc_html_e('Featured', 'wp-jobsearch') ?>"></i></span>
        <?php } else if ($view == 'employer_detv1') { ?>
            <span class="promotepof-detv1"><?php esc_html_e('Featured', 'wp-jobsearch') ?> <i class="fa fa-star"
                                                                                              title="<?php esc_html_e('Featured', 'wp-jobsearch') ?>"></i></span>
        <?php } else if ($view == 'cand_listv1') { ?>
            <span class="promotepof-badge"><?php esc_html_e('Featured', 'wp-jobsearch') ?> <i class="fa fa-star"
                                                                                              title="<?php esc_html_e('Featured', 'wp-jobsearch') ?>"></i></span>
        <?php } else if ($view == 'employer_list_grid') { ?>
            <span class="promotepof-badge-grid"><i class="fa fa-star jobsearch-tooltipcon"
                                                   title="<?php esc_html_e('Featured', 'wp-jobsearch') ?>"></i></span>
        <?php } else if ($view == 'employer_list2') { ?>
            <span><i class="fa fa-star" title="<?php esc_html_e('Featured', 'wp-jobsearch') ?>"></i> <?php esc_html_e('Featured', 'wp-jobsearch') ?></span>
        <?php } else { ?>
            <span class="promotepof-badge"><i class="fa fa-star"
                                              title="<?php esc_html_e('Featured', 'wp-jobsearch') ?>"></i></span>
            <?php
        }
        $html = ob_get_clean();
        echo apply_filters('jobsearch_member_promot_profile_star_html', $html, $id, $view);
    }
}

function jobsearch_cand_urgent_pkg_iconlab($id = 0, $view = '')
{

    $pckg_subtime = get_post_meta($id, 'urgent_pkg_substime', true);
    $att_pckg = get_post_meta($id, 'att_urgent_pkg_orderid', true);

    // form backend
    $cand_urgent_bk = get_post_meta($id, '_urgent_cand_frmadmin', true);

    $show_badge = false;

    if (!jobsearch_promote_profile_pkg_is_expired($att_pckg)) {
        $show_badge = true;
    }

    if ($cand_urgent_bk == 'yes') {
        $show_badge = true;
    } else if ($cand_urgent_bk == 'no') {
        $show_badge = false;
    }

    if ($show_badge) {
        if ($view == 'cand_dclassic' || $view == 'cand_dmodren' || $view == 'cand_listv4') {
            ?>
            <span class="urgntpkg-detilbadge"><?php esc_html_e('urgent', 'wp-jobsearch') ?></span>
        <?php } else if ($view == 'cand_listv1') { ?>
            <span class="urgntpkg-candv1"><?php esc_html_e('urgent', 'wp-jobsearch') ?></span>
        <?php } else if ($view == 'cand_listv6') { ?>
            <span class="urgntpkg-candv5"><?php esc_html_e('urgent', 'wp-jobsearch') ?></span>

        <?php } else if ($view == 'cand_listv2') { ?>
            <div class="urgntpkg-candv2"><span><?php esc_html_e('urgent', 'wp-jobsearch') ?></span></div>
        <?php } else { ?>
            <span class="urgntpkg-badge"><?php esc_html_e('urgent', 'wp-jobsearch') ?></span>
            <?php
        }
    }
}

function jobsearch_empjobs_urgent_pkg_iconlab($emp_id = 0, $post_id = 0, $view = '') {

    $pckg_subtime = get_post_meta($emp_id, 'urgent_pkg_substime', true);
    $att_pckg = get_post_meta($emp_id, 'att_urgent_pkg_orderid', true);
    //
    $post_is_urgent = get_post_meta($post_id, 'jobsearch_field_urgent_job', true);

    // form backend
    $post_urgent_bk = get_post_meta($post_id, '_urgent_job_frmadmin', true);

    $show_badge = false;

    if (!jobsearch_promote_profile_pkg_is_expired($att_pckg)) {
        $show_badge = true;
    }

    if ($post_urgent_bk == 'yes') {
        $show_badge = true;
    } else if ($post_urgent_bk == 'no') {
        $show_badge = false;
    }

    if ($show_badge && $post_is_urgent == 'on') {
        ob_start();
        if ($view == 'post_v_grid' || $view == 'post_v_grid2') { ?>
            <span class="urgntpkg-gridv-badge"><small><?php esc_html_e('urgent', 'wp-jobsearch') ?></small></span>
        <?php } else if ($view == 'job_listv1') { ?>
            <span class="urgntpkg-jobv1"><?php esc_html_e('urgent', 'wp-jobsearch') ?></span>
        <?php } else if ($view == 'job_listin2') { ?>
            <div class="urgntpkg-job-listin2"><span><?php esc_html_e('Urgent', 'wp-jobsearch') ?></span></div>
        <?php } else if ($view == 'style9') { ?>
            <span class="urgntpkg-badge-style9"><?php esc_html_e('urgent', 'wp-jobsearch') ?></span>
        <?php } else if ($view == 'style10') { ?>
            <div class="urgntpkg-badge-style10"><span><?php esc_html_e('urgent', 'wp-jobsearch') ?></span></div>
        <?php } else { ?>
            <span class="urgntpkg-badge"> <small><?php esc_html_e('urgent', 'wp-jobsearch') ?></small></span>
            <?php
        }
        $html = ob_get_clean();
        echo apply_filters('jobsearch_job_urgent_tag_html', $html, $view);
    }
}

//

add_filter('jobsearch_user_attach_cv_file_url', 'jobsearch_user_attach_cv_file_url', 10, 3);

function jobsearch_user_attach_cv_file_url($cv_file_url, $candidate_id, $post_id = 0)
{
    global $jobsearch_plugin_options;
    $multiple_cv_files_allow = isset($jobsearch_plugin_options['multiple_cv_uploads']) ? $jobsearch_plugin_options['multiple_cv_uploads'] : '';
    if ($multiple_cv_files_allow == 'on') {
        $ca_at_cv_files = get_post_meta($candidate_id, 'candidate_cv_files', true);
        if (!empty($ca_at_cv_files)) {
            $files_counter = 1;

            foreach ($ca_at_cv_files as $cv_file_key => $cv_file_val) {
                $file_attach_id = isset($cv_file_val['file_id']) ? $cv_file_val['file_id'] : '';
                $file_url = isset($cv_file_val['file_url']) ? $cv_file_val['file_url'] : '';
                $cv_primary = isset($cv_file_val['primary']) ? $cv_file_val['primary'] : '';
                if ($file_url != '') {
                    $cv_file_url = $file_url;
                    $to_attach_id = $file_attach_id;
                }
                if ($cv_primary == 'yes' && $file_url != '') {
                    $primcv_file_url = $file_url;
                    $prime_attach_id = $file_attach_id;
                }

                $files_counter++;
            }
            if (isset($prime_attach_id)) {
                $cv_file_url = apply_filters('wp_jobsearch_user_cvfile_downlod_url', $primcv_file_url, $prime_attach_id, $candidate_id);
            } else if (isset($to_attach_id)) {
                $cv_file_url = apply_filters('wp_jobsearch_user_cvfile_downlod_url', $cv_file_url, $to_attach_id, $candidate_id);
            }

            if ($post_id > 0) {
                $get_post_apps_cv_att = get_post_meta($post_id, 'post_apps_cv_att', true);
                $attach_cv_job = isset($get_post_apps_cv_att[$candidate_id]) ? $get_post_apps_cv_att[$candidate_id] : '';
                if ($attach_cv_job > 0 && is_numeric($attach_cv_job)) {
                    $att_file_post = get_post($attach_cv_job);
                    if (is_object($att_file_post) && isset($att_file_post->ID)) {
                        $file_attach_id = $att_file_post->ID;
                        $cv_file_url = $att_file_post->guid;
                        $cv_file_url = apply_filters('wp_jobsearch_user_cvfile_downlod_url', $cv_file_url, $file_attach_id, $candidate_id);
                    }
                }
            }
        }
    }
    return $cv_file_url;
}

add_filter('jobsearch_user_attach_cv_file_title', 'jobsearch_user_attach_cv_file_title', 10, 3);

function jobsearch_user_attach_cv_file_title($cv_file_title, $candidate_id, $post_id = 0)
{
    global $jobsearch_plugin_options;
    $multiple_cv_files_allow = isset($jobsearch_plugin_options['multiple_cv_uploads']) ? $jobsearch_plugin_options['multiple_cv_uploads'] : '';
    if ($multiple_cv_files_allow == 'on') {
        $ca_at_cv_files = get_post_meta($candidate_id, 'candidate_cv_files', true);
        if (!empty($ca_at_cv_files)) {
            $files_counter = 1;
            foreach ($ca_at_cv_files as $cv_file_key => $cv_file_val) {
                $file_attach_id = isset($cv_file_val['file_id']) ? $cv_file_val['file_id'] : '';
                $file_url = isset($cv_file_val['file_url']) ? $cv_file_val['file_url'] : '';
                $cv_primary = isset($cv_file_val['primary']) ? $cv_file_val['primary'] : '';
                $att_file_post = get_post($file_attach_id);
                if (is_numeric($file_attach_id) && get_post_type($file_attach_id) == 'attachment' && is_object($att_file_post) && isset($att_file_post->ID)) {
                    if ($files_counter == 1) {
                        $file_path = get_attached_file($file_attach_id);
                        $cv_file_title = basename($file_path);
                    }
                    if ($cv_primary == 'yes') {
                        $file_path = get_attached_file($file_attach_id);
                        $cv_file_title = basename($file_path);
                    }
                } else {
                    $cv_file_title = isset($cv_file_val['file_name']) ? $cv_file_val['file_name'] : '';
                }
                $files_counter++;
            }
            if ($post_id > 0) {
                $get_post_apps_cv_att = get_post_meta($post_id, 'post_apps_cv_att', true);
                $attach_cv_job = isset($get_post_apps_cv_att[$candidate_id]) ? $get_post_apps_cv_att[$candidate_id] : '';
                if ($attach_cv_job > 0 && is_numeric($attach_cv_job)) {
                    $att_file_post = get_post($attach_cv_job);
                    if (is_object($att_file_post) && isset($att_file_post->ID)) {
                        $file_path = get_attached_file($attach_cv_job);
                        $cv_file_title = basename($file_path);
                    }
                }
            }
        }
    }
    return $cv_file_title;
}

add_action('jobsearch_cand_listin_sh_after_jobs_found', 'jobsearch_cand_listin_totalcands_found_html', 10, 3);
add_filter('jobsearch_cand_listin_top_jobfounds_html', 'jobsearch_cand_listin_top_jobfounds_html', 12, 4);
add_filter('jobsearch_cand_listin_before_top_jobfounds_html', 'jobsearch_cand_listin_before_top_jobfounds_html', 12, 4);
add_filter('jobsearch_cand_listin_after_sort_orders_html', 'jobsearch_cand_listin_after_sort_orders_html', 12, 4);

function jobsearch_cand_listin_totalcands_found_html($post_totnum, $candidate_short_counter, $atts)
{

    $counts_on = true;
    if (isset($atts['display_per_page']) && $atts['display_per_page'] == 'no') {
        $counts_on = false;
    }
    if ($counts_on) {
        $per_page = isset($atts['candidate_per_page']) && absint($atts['candidate_per_page']) > 0 ? $atts['candidate_per_page'] : 0;
        if (isset($_REQUEST['per-page']) && $_REQUEST['per-page'] > 1) {
            $per_page = $_REQUEST['per-page'];
        }
        if ($per_page > 1) {
            $page_num = isset($_REQUEST['candidate_page']) && $_REQUEST['candidate_page'] > 1 ? $_REQUEST['candidate_page'] : 1;
            $start_frm = $page_num > 1 ? (($page_num - 1) * $per_page) : 1;
            $offset = $page_num > 1 ? ($page_num * $per_page) : $per_page;

            $offset = $offset > $post_totnum ? $post_totnum : $offset;

            $strt_toend_disp = absint($post_totnum) > 0 ? ($start_frm > 1 ? ($start_frm + 1) : $start_frm) . ' - ' . $offset : '0';
            ?>
            <div class="displayed-here"><?php printf(esc_html__('Displayed Here: %s Candidates', 'wp-jobsearch'), $strt_toend_disp) ?></div>
            <?php
        } else {
            $per_page = isset($atts['candidate_per_page']) && absint($atts['candidate_per_page']) > 0 ? $atts['candidate_per_page'] : $post_totnum;
            $per_page = $per_page > $post_totnum ? $post_totnum : $per_page;

            $strt_toend_disp = absint($post_totnum) > 0 ? '1 - ' . $per_page : '0';
            ?>
            <div class="displayed-here"><?php printf(esc_html__('Displayed Here: %s Candidates', 'wp-jobsearch'), $strt_toend_disp) ?></div>
            <?php
        }
    }
}

function jobsearch_cand_listin_top_jobfounds_html($html, $post_totnum, $candidate_short_counter, $atts)
{
    $counts_on = true;
    if (isset($atts['display_per_page']) && $atts['display_per_page'] == 'no') {
        $counts_on = false;
    }
    if ($counts_on) {
        $html = '';
    }
    return $html;
}

function jobsearch_cand_listin_before_top_jobfounds_html($html, $post_totnum, $candidate_short_counter, $atts)
{
    $counts_on = true;
    if (isset($atts['display_per_page']) && $atts['display_per_page'] == 'no') {
        $counts_on = false;
    }
    if ($counts_on) {
        ob_start();
        ?>
        <div class="jobsearch-filterable jobsearch-filter-sortable jobsearch-topfound-title">
            <h2 class="jobsearch-fltcount-title">
                <?php
                echo '<span class="listing-counts-num">' . absint($post_totnum) . '</span>&nbsp;';
                echo '<span class="listing-counts-numtxt">';
                if ($post_totnum == 1) {
                    echo esc_html__('Candidate Found', 'wp-jobsearch');
                } else {
                    echo esc_html__('Candidates Found', 'wp-jobsearch');
                }
                echo '</span>';
                do_action('jobsearch_cand_listin_sh_after_jobs_found', $post_totnum, $candidate_short_counter, $atts);
                ?>
            </h2>
        </div>
        <?php
        echo '<div class="jobsearch-topsort-holder">';
        $html = ob_get_clean();
    }
    return $html;
}

function jobsearch_cand_listin_after_sort_orders_html($html, $post_totnum, $candidate_short_counter, $atts)
{
    $counts_on = true;
    if (isset($atts['display_per_page']) && $atts['display_per_page'] == 'no') {
        $counts_on = false;
    }
    if ($counts_on) {
        $html = '</div>';
    }
    return $html;
}

function jobsearch_phonenum_itltell_input($field_name, $rand_numb, $field_val = '', $atts = array()) {
    $set_before_vals = isset($atts['set_before_vals']) ? $atts['set_before_vals'] : '';
    $is_required_field = isset($atts['is_required']) ? $atts['is_required'] : '';

    $name_atr = $field_name;
    if (isset($atts['sepc_name']) && $atts['sepc_name'] != '') {
        $name_atr = $atts['sepc_name'];
    }
    ?>
    <div id="phon-fieldcon-<?php echo absint($rand_numb) ?>" class="phon-num-fieldcon phonefild-wout-valid">
        <input class="required<?php echo(isset($atts['classes']) && $atts['classes'] != '' ? ' ' . $atts['classes'] : '') ?>" <?php echo($is_required_field ? 'required' : '') ?>
               name="<?php echo($name_atr) ?>"
               id="<?php echo($field_name) ?>_<?php echo absint($rand_numb) ?>"
               type="tel" <?php echo($field_val != '' ? 'value="' . $field_val . '"' : '') ?>
               placeholder="<?php _e('Phone Number', 'wp-jobsearch'); ?> <?php echo($is_required_field ? ' *' : '') ?>">
        <input id="dial_code_<?php echo absint($rand_numb) ?>" type="hidden" name="dial_code">
        <input id="contry_code_<?php echo absint($rand_numb) ?>" type="hidden" name="contry_iso_code">
    </div>
    <?php
    if (isset($atts['field_icon']) && $atts['field_icon'] == 'yes') {
        ?>
        <i class="jobsearch-icon jobsearch-technology"></i>
        <?php
    }
    ?>
    <script>
        function jobseachPhoneValidInit<?php echo absint($rand_numb) ?>() {
            var input_<?php echo absint($rand_numb) ?> = document.querySelector("#<?php echo($field_name) ?>_<?php echo absint($rand_numb) ?>");
            var iti_<?php echo absint($rand_numb) ?> = intlTelInput(input_<?php echo absint($rand_numb) ?>, {
                initialCountry: "auto",
                geoIpLookup: callback => {
                    fetch("https://ipinfo.io/json")
                    .then(res => res.json())
                    .then(data => callback(data.country))
                    .catch(() => callback("us"));
                },
                strictMode: true,
                separateDialCode: true,
                utilsScript: "<?php echo jobsearch_plugin_get_url('js/utils.js') ?>?<?php echo time() ?>"
            });
            var reset_phone_field_<?php echo absint($rand_numb) ?> = function () {
                input_<?php echo absint($rand_numb) ?>.classList.remove("phone-input-error");
            };
            // on blur: validate
            input_<?php echo absint($rand_numb) ?>.addEventListener('blur', function () {
                reset_phone_field_<?php echo absint($rand_numb) ?>();
                if (input_<?php echo absint($rand_numb) ?>.value.trim()) {
                    if (iti_<?php echo absint($rand_numb) ?>.isValidNumber()) {
                        jQuery(input_<?php echo absint($rand_numb) ?>).css({'border': '1px solid #efefef'});
                    } else {
                        input_<?php echo absint($rand_numb) ?>.classList.add("phone-input-error");
                        jQuery(input_<?php echo absint($rand_numb) ?>).css({'border': '1px solid #ff0000'});
                    }
                }
            });
            // for first time
            jQuery('#dial_code_<?php echo absint($rand_numb) ?>').val('+' + iti_<?php echo absint($rand_numb) ?>.getSelectedCountryData().dialCode);
            jQuery('#contry_code_<?php echo absint($rand_numb) ?>').val(iti_<?php echo absint($rand_numb) ?>.getSelectedCountryData().iso2);
            //
            input_<?php echo absint($rand_numb) ?>.addEventListener('countrychange', () => {
                jQuery('#dial_code_<?php echo absint($rand_numb) ?>').val('+' + iti_<?php echo absint($rand_numb) ?>.getSelectedCountryData().dialCode);
                jQuery('#contry_code_<?php echo absint($rand_numb) ?>').val(iti_<?php echo absint($rand_numb) ?>.getSelectedCountryData().iso2);
            });
        }

        jQuery(document).on('click', '#<?php echo($field_name) ?>_<?php echo absint($rand_numb) ?>', function () {
            if (jQuery('#phon-fieldcon-<?php echo absint($rand_numb) ?>').hasClass('phonefild-wout-valid')) {
                jQuery('#<?php echo($field_name) ?>_<?php echo absint($rand_numb) ?>').removeAttr('placeholder');
                jobseachPhoneValidInit<?php echo absint($rand_numb) ?>();
            }
            jQuery('#phon-fieldcon-<?php echo absint($rand_numb) ?>').removeClass('phonefild-wout-valid');
        });
        jQuery('body').on('focus', '#<?php echo($field_name) ?>_<?php echo absint($rand_numb) ?>', function(e) {
            e.preventDefault();
            if (jQuery('#phon-fieldcon-<?php echo absint($rand_numb) ?>').hasClass('phonefild-wout-valid')) {
                jQuery('#<?php echo($field_name) ?>_<?php echo absint($rand_numb) ?>').removeAttr('placeholder');
                jobseachPhoneValidInit<?php echo absint($rand_numb) ?>();
            }
            jQuery('#phon-fieldcon-<?php echo absint($rand_numb) ?>').removeClass('phonefild-wout-valid');
            return false;
        });
    </script>
    <?php
}

function jobsearch_phonenum_itltell_input_bk($field_name, $rand_numb, $field_val = '', $atts = array())
{

    $set_before_vals = isset($atts['set_before_vals']) ? $atts['set_before_vals'] : '';
    $is_required_field = isset($atts['is_required']) ? $atts['is_required'] : '';

    $name_atr = $field_name;
    if (isset($atts['sepc_name']) && $atts['sepc_name'] != '') {
        $name_atr = $atts['sepc_name'];
    }
    ?>
    <div id="phon-fieldcon-<?php echo absint($rand_numb) ?>" class="phon-num-fieldcon phonefild-wout-valid">
        <input class="required<?php echo(isset($atts['classes']) && $atts['classes'] != '' ? ' ' . $atts['classes'] : '') ?>" <?php echo($is_required_field ? 'required' : '') ?>
               name="<?php echo($name_atr) ?>"
               id="<?php echo($field_name) ?>_<?php echo absint($rand_numb) ?>"
               type="tel" <?php echo($field_val != '' ? 'value="' . $field_val . '"' : '') ?>
               placeholder="<?php _e('Phone Number', 'wp-jobsearch'); ?> <?php echo($is_required_field ? ' *' : '') ?>">
        <input id="dial_code_<?php echo absint($rand_numb) ?>" type="hidden" name="dial_code">
        <input id="contry_code_<?php echo absint($rand_numb) ?>" type="hidden" name="contry_iso_code">
    </div>
    <?php
    if (isset($atts['field_icon']) && $atts['field_icon'] == 'yes') {
        ?>
        <i class="jobsearch-icon jobsearch-technology"></i>
        <?php
    }
    ?>
    <script>
        function onChangeContryCallAct<?php echo absint($rand_numb) ?>(iti_randadn) {
            var _this_<?php echo absint($rand_numb) ?> = jQuery('#phon-fieldcon-<?php echo absint($rand_numb) ?>').find('.intl-tel-input .intl-tel-input ul.country-list > li.active');
            var dial_code_val_<?php echo absint($rand_numb) ?> = _this_<?php echo absint($rand_numb) ?>.attr('data-dial-code');
            var contry_code_val_<?php echo absint($rand_numb) ?> = _this_<?php echo absint($rand_numb) ?>.attr('data-country-code');
            var this_contry_name_<?php echo absint($rand_numb) ?> = _this_<?php echo absint($rand_numb) ?>.find('.country-name').html();
            jQuery('#dialcode-con-<?php echo absint($rand_numb) ?>').html('+' + dial_code_val_<?php echo absint($rand_numb) ?>);
            jQuery('#dial_code_<?php echo absint($rand_numb) ?>').val(dial_code_val_<?php echo absint($rand_numb) ?>);
            jQuery('#contry_code_<?php echo absint($rand_numb) ?>').val(contry_code_val_<?php echo absint($rand_numb) ?>);
            jQuery('#contry-name-<?php echo absint($rand_numb) ?>').html('');
            if (typeof contry_code_val_<?php echo absint($rand_numb) ?> !== 'undefined') {
                iti_randadn.setCountry(contry_code_val_<?php echo absint($rand_numb) ?>);
            }
        }

        function jobseachPhoneValidInit<?php echo absint($rand_numb) ?>() {
            var input_<?php echo absint($rand_numb) ?> = document.querySelector("#<?php echo($field_name) ?>_<?php echo absint($rand_numb) ?>");
            var iti_<?php echo absint($rand_numb) ?> = intlTelInput(input_<?php echo absint($rand_numb) ?>);
            var reset_phone_field_<?php echo absint($rand_numb) ?> = function () {
                input_<?php echo absint($rand_numb) ?>.classList.remove("phone-input-error");
            };
            <?php
            if (isset($atts['set_condial_intrvl']) && $atts['set_condial_intrvl'] == 'yes') {
            ?>
            //            var afterLoadIntrvl<?php echo absint($rand_numb) ?> = setInterval(function () {
            //                jQuery('#phon-fieldcon-<?php echo absint($rand_numb) ?>').find('.contry-info-con .country-name-con').attr('id', 'contry-name-<?php echo absint($rand_numb) ?>');
            //                jQuery('#phon-fieldcon-<?php echo absint($rand_numb) ?>').find('.contry-info-con .dialcode-num-con').attr('id', 'dialcode-con-<?php echo absint($rand_numb) ?>');
            //                clearInterval(afterLoadIntrvl<?php echo absint($rand_numb) ?>);
            //            }, 2000);
            <?php
            }
            ?>
            // on blur: validate
            input_<?php echo absint($rand_numb) ?>.addEventListener('blur', function () {
                reset_phone_field_<?php echo absint($rand_numb) ?>();
                if (input_<?php echo absint($rand_numb) ?>.value.trim()) {
                    if (iti_<?php echo absint($rand_numb) ?>.isValidNumber()) {
                        jQuery(input_<?php echo absint($rand_numb) ?>).css({'border': '1px solid #efefef'});
                    } else {
                        input_<?php echo absint($rand_numb) ?>.classList.add("phone-input-error");
                        jQuery(input_<?php echo absint($rand_numb) ?>).css({'border': '1px solid #ff0000'});
                    }
                }
            });
            <?php
            if (wp_is_mobile()) {
            ?>
            jQuery(document).on('click', '.intl-tel-input ul.country-list > li', function () {
                var _this_<?php echo absint($rand_numb) ?> = jQuery(this);
                var dial_code_val_<?php echo absint($rand_numb) ?> = _this_<?php echo absint($rand_numb) ?>.attr('data-dial-code');
                var contry_code_val_<?php echo absint($rand_numb) ?> = _this_<?php echo absint($rand_numb) ?>.attr('data-country-code');
                var this_contry_name_<?php echo absint($rand_numb) ?> = _this_<?php echo absint($rand_numb) ?>.find('.country-name').html();
                jQuery('#dialcode-con-<?php echo absint($rand_numb) ?>').html('+' + dial_code_val_<?php echo absint($rand_numb) ?>);
                jQuery('#dial_code_<?php echo absint($rand_numb) ?>').val(dial_code_val_<?php echo absint($rand_numb) ?>);
                jQuery('#contry_code_<?php echo absint($rand_numb) ?>').val(contry_code_val_<?php echo absint($rand_numb) ?>);
                jQuery('#contry-name-<?php echo absint($rand_numb) ?>').html('');
                iti_<?php echo absint($rand_numb) ?>.setCountry(contry_code_val_<?php echo absint($rand_numb) ?>);
            });
            <?php
            } else {
            ?>
            input_<?php echo absint($rand_numb) ?>.addEventListener("countrychange", function () {
                onChangeContryCallAct<?php echo absint($rand_numb) ?>(iti_<?php echo absint($rand_numb) ?>);
            });
            <?php
            }
            ?>
            var iti_init_<?php echo absint($rand_numb) ?> = window.intlTelInput(input_<?php echo absint($rand_numb) ?>, {
                initialCountry: "auto",
                geoIpLookup: function (callback_<?php echo absint($rand_numb) ?>) {
                    jQuery.get('https://ipinfo.io', function () {
                    }, "jsonp").always(function (resp) {
                        var countryCode = (resp && resp.country) ? resp.country : "";
                        callback_<?php echo absint($rand_numb) ?>(countryCode);
                        iti_<?php echo absint($rand_numb) ?>.setCountry(countryCode);
                        var countryData_<?php echo absint($rand_numb) ?> = iti_<?php echo absint($rand_numb) ?>.getSelectedCountryData();
                        if (typeof countryData_<?php echo absint($rand_numb) ?>.dialCode !== 'undefined') {
                            //console.log(countryData_<?php echo absint($rand_numb) ?>);
                            //console.log('<?php echo absint($rand_numb) ?>');
                            jQuery("input[<?php echo('id=' . $field_name . '_' . $rand_numb) ?>]").before('<div class="contry-info-con">\
                                <span id="contry-name-<?php echo absint($rand_numb) ?>" class="country-name-con"></span>\
                                <span id="dialcode-con-<?php echo absint($rand_numb) ?>" class="dialcode-num-con">+' + countryData_<?php echo absint($rand_numb) ?>.dialCode + '</span>\
                            </div>');
                            jQuery('#dial_code_<?php echo absint($rand_numb) ?>').val(countryData_<?php echo absint($rand_numb) ?>.dialCode);
                            jQuery('#contry_code_<?php echo absint($rand_numb) ?>').val(countryData_<?php echo absint($rand_numb) ?>.iso2);
                        }
                    });
                },
                preferredCountries: [],
                utilsScript: "<?php echo jobsearch_plugin_get_url('js/utils.js') ?>?<?php echo time() ?>" // just for formatting/placeholders etc
            });
            var afterLoadIntFunc<?php echo absint($rand_numb) ?> = setInterval(function () {
                var selectd_flag_class = jQuery('#phon-fieldcon-<?php echo absint($rand_numb) ?> > .intl-tel-input > .flag-container > .selected-flag .iti-flag').attr('class');
                jQuery('#phon-fieldcon-<?php echo absint($rand_numb) ?> .selected-flag .iti-flag').attr('class', selectd_flag_class);
                clearInterval(afterLoadIntFunc<?php echo absint($rand_numb) ?>);
            }, 500);
        }

        jQuery(document).on('click', '#<?php echo($field_name) ?>_<?php echo absint($rand_numb) ?>', function () {
            if (jQuery('#phon-fieldcon-<?php echo absint($rand_numb) ?>').hasClass('phonefild-wout-valid')) {
                jQuery('#<?php echo($field_name) ?>_<?php echo absint($rand_numb) ?>').removeAttr('placeholder');
                jobseachPhoneValidInit<?php echo absint($rand_numb) ?>();
            }
            jQuery('#phon-fieldcon-<?php echo absint($rand_numb) ?>').removeClass('phonefild-wout-valid');
        });
        jQuery('body').on('focus', '#<?php echo($field_name) ?>_<?php echo absint($rand_numb) ?>', function(e) {
            e.preventDefault();
            if (jQuery('#phon-fieldcon-<?php echo absint($rand_numb) ?>').hasClass('phonefild-wout-valid')) {
                jQuery('#<?php echo($field_name) ?>_<?php echo absint($rand_numb) ?>').removeAttr('placeholder');
                jobseachPhoneValidInit<?php echo absint($rand_numb) ?>();
            }
            jQuery('#phon-fieldcon-<?php echo absint($rand_numb) ?>').removeClass('phonefild-wout-valid');
            return false;
        });
    </script>
    <?php
}

add_filter('careerfy_subheader_post_page_title', 'jobsearch_careerfy_subheader_dash_titles', 11, 2);

function jobsearch_careerfy_subheader_dash_titles($title, $page_id)
{
    global $jobsearch_plugin_options;

    $user_dashboard_page = isset($jobsearch_plugin_options['user-dashboard-template-page']) ? $jobsearch_plugin_options['user-dashboard-template-page'] : '';
    $dashboard_page_id = jobsearch__get_post_id($user_dashboard_page, 'page');
    if ($dashboard_page_id == $page_id) {
        $user_id = get_current_user_id();
        $user_obj = get_user_by('ID', $user_id);
        $user_displayname = isset($user_obj->display_name) ? $user_obj->display_name : '';
        $user_displayname = apply_filters('jobsearch_user_display_name', $user_displayname, $user_obj);

        if ($user_displayname != '') {
            $title = $user_displayname;
        }
    }
    return $title;
}

add_filter('careerfy_subheader_postpage_bg_img', 'jobsearch_careerfy_subheader_userdash_bg_img', 11, 2);

function jobsearch_careerfy_subheader_userdash_bg_img($bg_img, $page_id)
{
    global $jobsearch_plugin_options;

    $user_dashboard_page = isset($jobsearch_plugin_options['user-dashboard-template-page']) ? $jobsearch_plugin_options['user-dashboard-template-page'] : '';
    $dashboard_page_id = jobsearch__get_post_id($user_dashboard_page, 'page');
    if ($dashboard_page_id == $page_id) {
        $user_id = get_current_user_id();
        $user_is_employer = jobsearch_user_is_employer($user_id);
        $user_is_candidate = jobsearch_user_is_candidate($user_id);
        if ($user_is_employer) {
            $bg_img = '';
            $employer_id = jobsearch_get_user_employer_id($user_id);
            if (class_exists('JobSearchMultiPostThumbnails')) {
                $employer_cover_image_src = JobSearchMultiPostThumbnails::get_post_thumbnail_url('employer', 'cover-image', $employer_id);
                if ($employer_cover_image_src != '') {
                    $bg_img = $employer_cover_image_src;
                }
            }
            if ($bg_img == '') {
                $bg_img = isset($jobsearch_plugin_options['cand_default_coverimg']['url']) ? $jobsearch_plugin_options['cand_default_coverimg']['url'] : '';
            }
        } else if ($user_is_candidate) {
            $candidate_id = jobsearch_get_user_candidate_id($user_id);
            $bg_img = jobsearch_candidate_covr_url_comn($candidate_id);
        }
    }
    return $bg_img;
}

add_action('admin_init', 'jobsearch_redirect_memb_from_admin_to_dash');
add_action('init', 'jobsearch_redirect_memb_from_admin_to_dash');

function jobsearch_redirect_memb_from_admin_to_dash()
{
    global $pagenow;
    //
    if (is_super_admin() || current_user_can('administrator')) {
        return false;
    }
    if (current_user_can('jobsearch_candidate') || current_user_can('jobsearch_employer')) {

        if (is_admin()) {
            $to_view = false;
            if ($pagenow == 'admin-ajax.php' || $pagenow == 'async-upload.php') {
                $to_view = true;
            }

            if ($to_view === false) {
                $jobsearch__options = get_option('jobsearch_plugin_options');
                $page_id = isset($jobsearch__options['user-dashboard-template-page']) ? $jobsearch__options['user-dashboard-template-page'] : '';
                $page_id = jobsearch__get_post_id($page_id, 'page');
                $page_url = jobsearch_wpml_lang_page_permalink($page_id, 'page');
                wp_redirect($page_url);
                exit();
            }
        }
    }
}

add_action('init', 'jobsearch_allow_memb_candidate_media');

function jobsearch_allow_memb_candidate_media()
{

    $role = 'jobsearch_candidate';
    if (!current_user_can($role) || current_user_can('upload_files')) {
        return;
    }
    $subscriber = get_role($role);

    $subscriber = get_role($role);
    $subscriber->add_cap('upload_files');
    $subscriber->add_cap('edit_post');
    $subscriber->add_cap('edit_published_pages');
    $subscriber->add_cap('edit_others_pages');
    $subscriber->add_cap('edit_others_posts');
}

add_action('init', 'jobsearch_allow_memb_employer_media');

function jobsearch_allow_memb_employer_media()
{
    $role = 'jobsearch_employer';
    if (!current_user_can($role) || current_user_can('upload_files')) {
        return;
    }
    $subscriber = get_role($role);
    $subscriber->add_cap('upload_files');
    $subscriber->add_cap('edit_post');
    $subscriber->add_cap('edit_published_pages');
    $subscriber->add_cap('edit_others_pages');
    $subscriber->add_cap('edit_others_posts');
}

add_filter('ajax_query_attachments_args', 'jobsearch_show_current_memberuser_attachments');

function jobsearch_show_current_memberuser_attachments($query)
{
    $user_id = get_current_user_id();
    if ($user_id && !current_user_can('administrator') && !is_super_admin()) {
        $query['author'] = $user_id;
    }
    return $query;
}

add_filter('media_view_strings', 'jobsearch_show_media_tabs_strings_member', 20, 2);

function jobsearch_show_media_tabs_strings_member($strings, $post)
{

    if (is_user_logged_in()) {
        $media_tabs_hide = false;
        $user_id = get_current_user_id();
        if ($user_id && !current_user_can('administrator') && !is_super_admin()) {
            $media_tabs_hide = true;
        }
        if ($media_tabs_hide) {
            $strings['createGalleryTitle'] = '';
            $strings['createPlaylistTitle'] = '';
            $strings['createVideoPlaylistTitle'] = '';
            $strings['setFeaturedImageTitle'] = '';
            $strings['setFeaturedImage'] = '';
            $strings['insertFromUrlTitle'] = '';
        }
    }
    return $strings;
}

//
add_filter('post_type_link', 'jobsearch_candpost_type_link_chnge', 1, 3);

function jobsearch_candpost_type_link_chnge($link, $post = 0)
{
    $jobsearch__options = get_option('jobsearch_plugin_options');
    $cand_post_writeslug = isset($jobsearch__options['candidate_rewrite_slug']) && $jobsearch__options['candidate_rewrite_slug'] != '' ? $jobsearch__options['candidate_rewrite_slug'] : 'candidate';

    if ($post->post_type == 'candidate') {
        $candidate_id = $post->ID;

        $cand_profile_restrict = new Candidate_Profile_Restriction;

        $candidate_user_id = jobsearch_get_candidate_user_id($candidate_id);

        $view_candidate = true;
        $restrict_candidates = isset($jobsearch__options['restrict_candidates']) ? $jobsearch__options['restrict_candidates'] : '';

        $view_cand_type = 'fully';
        $emp_cvpbase_restrictions = isset($jobsearch__options['emp_cv_pkgbase_restrictions']) ? $jobsearch__options['emp_cv_pkgbase_restrictions'] : '';
        $restrict_cand_type = isset($jobsearch__options['restrict_candidates_for_users']) ? $jobsearch__options['restrict_candidates_for_users'] : '';
        if ($emp_cvpbase_restrictions == 'on') {
            $view_cand_type = 'partly';
        }
        if ($restrict_candidates == 'on' && $view_cand_type == 'fully') {
            $view_candidate = false;

            $restrict_candidates_for_users = isset($jobsearch__options['restrict_candidates_for_users']) ? $jobsearch__options['restrict_candidates_for_users'] : '';

            if (is_user_logged_in()) {
                $cur_user_id = get_current_user_id();
                $cur_user_obj = wp_get_current_user();
                if (jobsearch_user_isemp_member($cur_user_id)) {
                    $employer_id = jobsearch_user_isemp_member($cur_user_id);
                    $cur_user_id = jobsearch_get_employer_user_id($employer_id);
                } else {
                    $employer_id = jobsearch_get_user_employer_id($cur_user_id);
                }
                $ucandidate_id = jobsearch_get_user_candidate_id($cur_user_id);
                $employer_dbstatus = get_post_meta($employer_id, 'jobsearch_field_employer_approved', true);
                if ($employer_id > 0 && $employer_dbstatus == 'on') {
                    $is_employer = true;
                    $is_applicant = false;
                    
                    $employer_resumes_list = get_post_meta($employer_id, 'jobsearch_candidates_list', true);
                    $employer_resumes_list = explode(',', $employer_resumes_list);

                    //
                    $employer_post_args = array(
                        'post_type' => 'job',
                        'posts_per_page' => '-1',
                        'post_status' => 'publish',
                        'fields' => 'ids',
                        'meta_query' => array(
                            array(
                                'key' => 'jobsearch_field_post_posted_by',
                                'value' => $employer_id,
                                'compare' => '=',
                            ),
                        ),
                    );
                    $employer_jobs_query = new WP_Query($employer_post_args);
                    $employer_jobs_posts = $employer_jobs_query->posts;
                    if (!empty($employer_jobs_posts) && is_array($employer_jobs_posts)) {
                        foreach ($employer_jobs_posts as $employer_post_id) {
                            $finded_result_list = jobsearch_find_index_user_meta_list($employer_post_id, 'jobsearch-user-jobs-applied-list', 'post_id', $candidate_user_id);
                            if (is_array($finded_result_list) && !empty($finded_result_list)) {
                                //$is_applicant = true;
                                break;
                            }
                        }
                    }
                    //
                    if ($restrict_candidates_for_users == 'register_resume') {
                        $user_cv_pkg = jobsearch_employer_first_subscribed_cv_pkg($cur_user_id);
                        if (!$user_cv_pkg) {
                            $user_cv_pkg = jobsearch_allin_first_pkg_subscribed($cur_user_id, 'cvs');
                        }
                        if (!$user_cv_pkg) {
                            $user_cv_pkg = jobsearch_emprof_first_pkg_subscribed($cur_user_id, 'cvs');
                        }
                        if ($user_cv_pkg) {
                            //if (in_array($candidate_id, $employer_resumes_list)) {
                                $view_candidate = true;
                            //}
                        } else {
                            if ($is_applicant) {
                                //$view_candidate = true;
                            }
                        }
                    } else if ($restrict_candidates_for_users == 'only_applicants') {
                        if ($is_applicant) {
                            //$view_candidate = true;
                        }
                    } else {
                        $view_candidate = true;
                    }
                } else if (in_array('administrator', (array)$cur_user_obj->roles)) {
                    $view_candidate = true;
                } else if ($ucandidate_id > 0 && $ucandidate_id == $candidate_id) {
                    $view_candidate = true;
                } else if ($restrict_candidates_for_users == 'register_empcand' && ($ucandidate_id > 0 || $employer_id > 0)) {
                    $view_candidate = true;
                }
            }
        } else if ($view_cand_type == 'partly') {
            $view_candidate = false;
            if (!$cand_profile_restrict::cand_field_is_locked('profile_fields|display_name', 'detail_page')) {
                $view_candidate = true;
            }
        }

        if ($view_candidate) {
            return $link;
        } else {
            return home_url($cand_post_writeslug . '/detail_page/' . $candidate_id);
        }
    } else {
        return $link;
    }
}

add_filter('pre_get_document_title', 'jobsearch_filter_cand_wp_title', 10000, 1);

function jobsearch_filter_cand_wp_title($title)
{

    $jobsearch__options = get_option('jobsearch_plugin_options');

    $curr_post = get_post();

    if (isset($curr_post->post_type) && $curr_post->post_type == 'candidate') {
        $candidate_id = $curr_post->ID;

        $cand_profile_restrict = new Candidate_Profile_Restriction;

        $candidate_user_id = jobsearch_get_candidate_user_id($candidate_id);

        $view_candidate = true;
        $restrict_candidates = isset($jobsearch__options['restrict_candidates']) ? $jobsearch__options['restrict_candidates'] : '';

        $view_cand_type = 'fully';
        $emp_cvpbase_restrictions = isset($jobsearch__options['emp_cv_pkgbase_restrictions']) ? $jobsearch__options['emp_cv_pkgbase_restrictions'] : '';
        $restrict_cand_type = isset($jobsearch__options['restrict_candidates_for_users']) ? $jobsearch__options['restrict_candidates_for_users'] : '';
        if ($emp_cvpbase_restrictions == 'on') {
            $view_cand_type = 'partly';
        }
        if ($restrict_candidates == 'on' && $view_cand_type == 'fully') {
            $view_candidate = false;

            $restrict_candidates_for_users = isset($jobsearch__options['restrict_candidates_for_users']) ? $jobsearch__options['restrict_candidates_for_users'] : '';

            if (is_user_logged_in()) {
                $cur_user_id = get_current_user_id();
                $cur_user_obj = wp_get_current_user();
                if (jobsearch_user_isemp_member($cur_user_id)) {
                    $employer_id = jobsearch_user_isemp_member($cur_user_id);
                    $cur_user_id = jobsearch_get_employer_user_id($employer_id);
                } else {
                    $employer_id = jobsearch_get_user_employer_id($cur_user_id);
                }
                $ucandidate_id = jobsearch_get_user_candidate_id($cur_user_id);
                $employer_dbstatus = get_post_meta($employer_id, 'jobsearch_field_employer_approved', true);
                if ($employer_id > 0 && $employer_dbstatus == 'on') {
                    $is_employer = true;
                    $is_applicant = false;
                    
                    $employer_resumes_list = get_post_meta($employer_id, 'jobsearch_candidates_list', true);
                    $employer_resumes_list = explode(',', $employer_resumes_list);
                    
                    //
                    $employer_post_args = array(
                        'post_type' => 'job',
                        'posts_per_page' => '-1',
                        'post_status' => 'publish',
                        'fields' => 'ids',
                        'meta_query' => array(
                            array(
                                'key' => 'jobsearch_field_post_posted_by',
                                'value' => $employer_id,
                                'compare' => '=',
                            ),
                        ),
                    );
                    $employer_jobs_query = new WP_Query($employer_post_args);
                    $employer_jobs_posts = $employer_jobs_query->posts;
                    if (!empty($employer_jobs_posts) && is_array($employer_jobs_posts)) {
                        foreach ($employer_jobs_posts as $employer_post_id) {
                            $finded_result_list = jobsearch_find_index_user_meta_list($employer_post_id, 'jobsearch-user-jobs-applied-list', 'post_id', $candidate_user_id);
                            if (is_array($finded_result_list) && !empty($finded_result_list)) {
                                //$is_applicant = true;
                                break;
                            }
                        }
                    }
                    //
                    if ($restrict_candidates_for_users == 'register_resume') {
                        $user_cv_pkg = jobsearch_employer_first_subscribed_cv_pkg($cur_user_id);
                        if (!$user_cv_pkg) {
                            $user_cv_pkg = jobsearch_allin_first_pkg_subscribed($cur_user_id, 'cvs');
                        }
                        if (!$user_cv_pkg) {
                            $user_cv_pkg = jobsearch_emprof_first_pkg_subscribed($cur_user_id, 'cvs');
                        }
                        if ($user_cv_pkg) {
                            //if (in_array($candidate_id, $employer_resumes_list)) {
                                $view_candidate = true;
                            //}
                        } else {
                            if ($is_applicant) {
                                //$view_candidate = true;
                            }
                        }
                    } else if ($restrict_candidates_for_users == 'only_applicants') {
                        if ($is_applicant) {
                            //$view_candidate = true;
                        }
                    } else {
                        $view_candidate = true;
                    }
                } else if (in_array('administrator', (array)$cur_user_obj->roles)) {
                    $view_candidate = true;
                } else if ($ucandidate_id > 0 && $ucandidate_id == $candidate_id) {
                    $view_candidate = true;
                } else if ($restrict_candidates_for_users == 'register_empcand' && ($ucandidate_id > 0 || $employer_id > 0)) {
                    $view_candidate = true;
                }
            }
        } else if ($view_cand_type == 'partly') {
            $view_candidate = false;
            if (!$cand_profile_restrict::cand_field_is_locked('profile_fields|display_name', 'detail_page')) {
                $view_candidate = true;
            }
        }
        if (!$view_candidate) {
            $title = esc_html__('Unlock to reveal name', 'wp-jobsearch');
        }
    }
    //var_dump($title);

    return $title;
}

function jobsearch_listins_locfilter_manula_dropdown($loc_filter_collapse, $global_rand_id, $is_ajax, $post_type = 'job')
{
    global $jobsearch_form_fields, $sitepress, $job_location_flag, $loc_counter, $jobsearch_plugin_options, $jobsearch_gdapi_allocation;
    $rand_num = rand(1000000, 9999999);
    $lang_code = '';
    if (function_exists('icl_object_id') && function_exists('wpml_init_language_switcher')) {
        $lang_code = $sitepress->get_current_language();
    }
    $required_fields_count = isset($jobsearch_plugin_options['jobsearch-location-required-fields-count']) ? $jobsearch_plugin_options['jobsearch-location-required-fields-count'] : 'all';
    $label_location1 = isset($jobsearch_plugin_options['jobsearch-location-label-location1']) ? apply_filters('wpml_translate_single_string', $jobsearch_plugin_options['jobsearch-location-label-location1'], 'JobSearch Options', 'Location First Field - ' . $jobsearch_plugin_options['jobsearch-location-label-location1'], $lang_code) : esc_html__('Country', 'wp-jobsearch');
    $label_location2 = isset($jobsearch_plugin_options['jobsearch-location-label-location2']) ? apply_filters('wpml_translate_single_string', $jobsearch_plugin_options['jobsearch-location-label-location2'], 'JobSearch Options', 'Location Second Field - ' . $jobsearch_plugin_options['jobsearch-location-label-location2'], $lang_code) : esc_html__('State', 'wp-jobsearch');
    $label_location3 = isset($jobsearch_plugin_options['jobsearch-location-label-location3']) ? apply_filters('wpml_translate_single_string', $jobsearch_plugin_options['jobsearch-location-label-location3'], 'JobSearch Options', 'Location Third Field - ' . $jobsearch_plugin_options['jobsearch-location-label-location3'], $lang_code) : esc_html__('Region', 'wp-jobsearch');
    $label_location4 = isset($jobsearch_plugin_options['jobsearch-location-label-location4']) ? apply_filters('wpml_translate_single_string', $jobsearch_plugin_options['jobsearch-location-label-location4'], 'JobSearch Options', 'Location Forth Field - ' . $jobsearch_plugin_options['jobsearch-location-label-location4'], $lang_code) : esc_html__('City', 'wp-jobsearch');

    $loc_location1 = isset($_REQUEST['location_location1']) ? $_REQUEST['location_location1'] : '';
    $loc_location2 = isset($_REQUEST['location_location2']) ? $_REQUEST['location_location2'] : '';
    $loc_location3 = isset($_REQUEST['location_location3']) ? $_REQUEST['location_location3'] : '';
    $loc_location4 = isset($_REQUEST['location_location4']) ? $_REQUEST['location_location4'] : '';

    $please_select = esc_html__('Please select', 'wp-jobsearch');
    $location_location1 = array('' => $please_select . ' ' . $label_location1);
    $location_location2 = array('' => $please_select . ' ' . $label_location2);
    $location_location3 = array('' => $please_select . ' ' . $label_location3);
    $location_location4 = array('' => $please_select . ' ' . $label_location4);
    $location_obj = jobsearch_custom_get_terms('job-location');
    foreach ($location_obj as $country_arr) {
        $location_location1[$country_arr->slug] = $country_arr->name;
    }
    ?>
    <div class="jobsearch-checkbox-toggle" style="display: <?php echo($loc_filter_collapse == 'yes' ? 'none' : 'block') ?>;">
        <script>
            <?php
            if ($is_ajax) {
                ?>
                if (jQuery('.filter_location_location1').length > 0) {
                    jQuery('.filter_location_location1').change();
                }
                <?php
            } else {
                ?>
                jQuery(document).ready(function () {
                    if (jQuery('.filter_location_location1').length > 0) {
                        jQuery('.filter_location_location1').trigger('change');
                    }
                });
                <?php
            }
            ?>
        </script>
        <ul class="jobsearch-row jobsearch-employer-profile-form">
            <li class="jobsearch-column-12">
                <label><?php echo esc_html($label_location1) ?></label>
                <div class="jobsearch-profile-select">
                    <?php
                    $field_params = array(
                        'classes' => 'filter_location_location1 selectize-select',
                        'id' => 'location_location1_' . $rand_num,
                        'cus_name' => 'location_location1',
                        'options' => $location_location1,
                        'force_std' => $loc_location1,
                        'ext_attr' => ' data-randid="' . $rand_num . '" data-nextfieldelement="' . $please_select . ' ' . $label_location2 . '" data-nextfieldval="' . $loc_location2 . '"',
                    );
                    $jobsearch_form_fields->select_field($field_params);
                    ?>
                </div>
            </li>
            <?php
            if ($required_fields_count > 1 || $required_fields_count == 'all') {
                ?>
                <li class="jobsearch-column-12">
                    <label><?php echo esc_html($label_location2) ?></label>
                    <div class="jobsearch-profile-select">
                        <?php
                        $field_params = array(
                            'classes' => 'filter_location_location2 location_location2_selectize',
                            'id' => 'location_location2_' . $rand_num,
                            'cus_name' => 'location_location2',
                            'options' => $location_location2,
                            'force_std' => $loc_location2,
                            'ext_attr' => ' data-randid="' . $rand_num . '" data-nextfieldelement="' . $please_select . ' ' . $label_location3 . '" data-nextfieldval="' . $loc_location3 . '"',
                        );
                        $jobsearch_form_fields->select_field($field_params);
                        ?>
                        <span class="jobsearch-field-loader location_location2_<?php echo absint($rand_num); ?>"></span>
                    </div>
                </li>
                <?php
            }
            if ($required_fields_count > 2 || $required_fields_count == 'all') {
                ?>
                <li class="jobsearch-column-12">
                    <label><?php echo esc_html($label_location3) ?></label>
                    <div class="jobsearch-profile-select">
                        <?php
                        $field_params = array(
                            'classes' => 'filter_location_location3 location_location3_selectize',
                            'id' => 'location_location3_' . $rand_num,
                            'cus_name' => 'location_location3',
                            'options' => $location_location3,
                            'force_std' => $loc_location3,
                            'ext_attr' => ' data-randid="' . $rand_num . '" data-nextfieldelement="' . $please_select . ' ' . $label_location4 . '" data-nextfieldval="' . $loc_location4 . '"',
                        );
                        $jobsearch_form_fields->select_field($field_params);
                        ?>
                        <span class="jobsearch-field-loader location_location3_<?php echo absint($rand_num); ?>"></span>
                    </div>
                </li>
            <?php }
            if ($required_fields_count > 3 || $required_fields_count == 'all') {
                ?>
                <li class="jobsearch-column-12">
                    <label><?php echo esc_html($label_location4) ?></label>
                    <div class="jobsearch-profile-select">
                        <?php
                        $field_params = array(
                            'classes' => 'filter_location_location4 location_location4_selectize',
                            'id' => 'location_location4_' . $rand_num,
                            'cus_name' => 'location_location4',
                            'options' => $location_location4,
                            'force_std' => $loc_location4,
                            'ext_attr' => ' data-randid="' . $rand_num . '"',
                        );
                        $jobsearch_form_fields->select_field($field_params);
                        ?>
                        <span class="jobsearch-field-loader location_location4_<?php echo absint($rand_num); ?>"></span>
                    </div>
                </li>
                <?php
            }
            ?>
        </ul>
        <?php
        $onclik_func_name = 'jobsearch_job_content_load';
        if ($post_type == 'employer') {
            $onclik_func_name = 'jobsearch_employer_content_load';
        }
        if ($post_type == 'candidate') {
            $onclik_func_name = 'jobsearch_candidate_content_load';
        }
        ?>
        <div class="onsubmit-apilocs-con">
            <a href="javascript:void(0);" class="jobsearch-onsubmit-apilocs btn jobsearch-bgcolor"
               onclick="<?php echo($onclik_func_name) ?>(<?php echo absint($global_rand_id); ?>);"><?php esc_html_e('Submit', 'wp-jobsearch') ?></a>
        </div>
    </div>
    <?php
}

add_action('init', 'jobsearch_candpost_type_link_rewrite');

function jobsearch_candpost_type_link_rewrite()
{
    $jobsearch__options = get_option('jobsearch_plugin_options');
    $cand_post_writeslug = isset($jobsearch__options['candidate_rewrite_slug']) && $jobsearch__options['candidate_rewrite_slug'] != '' ? $jobsearch__options['candidate_rewrite_slug'] : 'candidate';

    add_rewrite_rule($cand_post_writeslug . '/detail_page/([0-9]+)?$', 'index.php?post_type=candidate&p=$matches[1]', 'top');
}

//
//
function jobsearch_usersback_sortable_columns($columns)
{
    $custom = array(
        'username' => 'username',
        'email' => 'email',
        'jobsearch_adminprove' => 'jobsearch_adminprove',
    );
    return wp_parse_args($custom, $columns);
}

add_filter('manage_users_sortable_columns', 'jobsearch_usersback_sortable_columns');

function jobsearch_usersback_sort_columns($WP_User_Query)
{
    global $wpdb, $pagenow;

    if (isset($WP_User_Query->query_vars['orderby'])) {
        if ('jobsearch_adminprove' === $WP_User_Query->query_vars['orderby']) {
            $WP_User_Query->query_vars["meta_key"] = "jobsearch_accaprov_allow";
            $WP_User_Query->query_vars["orderby"] = "meta_value";
        }
    }
}

add_filter('pre_get_users', 'jobsearch_usersback_sort_columns');

function jobsearch_users_admin_columns_css()
{
    global $pagenow;
    if ($pagenow == 'users.php') {
        echo '<style>body.users-php th#jobsearch_adminprove{width:12%;}</style>';
    }
}

add_action('admin_head', 'jobsearch_users_admin_columns_css');

function jobsearch_users_admin_aprove_js()
{
    global $pagenow;
    if ($pagenow == 'users.php') {
        ?>
        <script>
            jQuery(document).on('click', '.user-adminprove-btn', function () {
                var _this = jQuery(this);
                var this_loader = _this.parent('.user-manulaprove-btncon').find('.loader-con');
                var userid = _this.attr('data-id');

                if (!_this.hasClass('has-approved')) {
                    this_loader.html('<i class="fa fa-refresh fa-spin"></i>');
                    var request = jQuery.ajax({
                        url: ajaxurl,
                        method: "POST",
                        data: {
                            user_id: userid,
                            _nonce: jobsearch_comon_script_vars.nonce,
                            action: 'jobsearch_user_acountaprovl_by_admin',
                        },
                        dataType: "json"
                    });

                    request.done(function (response) {
                        if (typeof response.error !== 'undefined' && response.error == '0') {
                            _this.removeClass('to-approve').addClass('has-approved');
                            this_loader.html('<strong><em style="color:#17aa00;"> (' + response.msg + ')</em></strong>');
                            return false;
                        }
                        this_loader.html('');
                    });

                    request.fail(function (jqXHR, textStatus) {
                        this_loader.html('');
                    });
                }
            });
        </script>
        <?php
    }
}

add_action('admin_footer', 'jobsearch_users_admin_aprove_js');

function jobsearch_users_admin_add_column($column)
{
    $column['jobsearch_adminprove'] = esc_html__('Email Verification', 'wp-jobsearch');
    return $column;
}

add_filter('manage_users_columns', 'jobsearch_users_admin_add_column');

/* this will add column value in user list table */

function jobsearch_users_admin_add_colval($val, $column_name, $user_id)
{
    switch ($column_name) {

        case 'jobsearch_adminprove' :
            $social_user = false;
            $jobsearch_facebook_id = get_user_meta($user_id, 'jobsearch_facebook_id', true);
            if ($jobsearch_facebook_id != '') {
                $social_user = true;
            }
            $jobsearch_google_id = get_user_meta($user_id, 'jobsearch_google_id', true);
            if ($jobsearch_google_id != '') {
                $social_user = true;
            }
            $jobsearch_linkedin_id = get_user_meta($user_id, 'jobsearch_linkedin_id', true);
            if ($jobsearch_linkedin_id != '') {
                $social_user = true;
            }
            $jobsearch_twitter_id = get_user_meta($user_id, 'jobsearch_twitter_id', true);
            if ($jobsearch_twitter_id != '') {
                $social_user = true;
            }
            $jobsearch_xing_id = get_user_meta($user_id, 'jobsearch_xing_id', true);
            if ($jobsearch_xing_id != '') {
                $social_user = true;
            }
            $user_login_auth = get_user_meta($user_id, 'jobsearch_accaprov_allow', true);
            ob_start();
            if ($user_login_auth == '0') {
                ?>
                <div class="user-manulaprove-btncon">
                    <a href="javascript:void(0);" class="user-adminprove-btn to-approve"
                       data-id="<?php echo($user_id) ?>"
                       style="color: #ff0000; font-weight: bold;"><?php esc_html_e('Verify', 'wp-jobsearch') ?></a>
                    <span class="loader-con"></span>
                </div>
                <?php
            } else if ($social_user) {
                ?>
                <div class="user-manulaprove-btncon">
                    <a class="user-adminprove-btn has-approved"
                       style="color: #17aa00;"><?php esc_html_e('Verified', 'wp-jobsearch') ?></a>
                </div>
                <?php
            } else if ($user_login_auth == '1') {
                ?>
                <div class="user-manulaprove-btncon">
                    <a class="user-adminprove-btn has-approved"
                       style="color: #17aa00;"><?php esc_html_e('Verified', 'wp-jobsearch') ?></a>
                </div>
                <?php
            } else {
                echo '-';
            }
            $html = ob_get_clean();
            return $html;
            break;

        default:
    }
}

add_filter('manage_users_custom_column', 'jobsearch_users_admin_add_colval', 10, 3);

function jobsearch_user_acountaprovl_by_admin()
{
    $nonce_val = sanitize_key(wp_unslash($_POST['_nonce']));
    if (!current_user_can('administrator') || !wp_verify_nonce($nonce_val, 'jobsearch_ajax_nonce')) {
        $msg = esc_html__('You are not allowed to do this.', 'wp-jobsearch');
        echo json_encode(array('msg' => $msg, 'error' => '1'));
        die;
    }
    $user_id = isset($_POST['user_id']) ? $_POST['user_id'] : '';
    $c_user = get_user_by('ID', $user_id);

    $jobsearch__options = get_option('jobsearch_plugin_options');

    $candidate_auto_approve = isset($jobsearch__options['candidate_auto_approve']) ? $jobsearch__options['candidate_auto_approve'] : '';
    $employer_auto_approve = isset($jobsearch__options['employer_auto_approve']) ? $jobsearch__options['employer_auto_approve'] : '';

    $user_is_candidate = jobsearch_user_is_candidate($user_id);
    $user_is_employer = jobsearch_user_is_employer($user_id);

    if ($user_is_candidate && $candidate_auto_approve == 'email') {
        $candidate_id = jobsearch_get_user_candidate_id($user_id);
        update_post_meta($candidate_id, 'jobsearch_field_candidate_approved', 'on');
    }
    if ($user_is_employer && $employer_auto_approve == 'email') {
        $employer_id = jobsearch_get_user_employer_id($user_id);
        update_post_meta($employer_id, 'jobsearch_field_employer_approved', 'on');
    }
    update_user_meta($user_id, 'jobsearch_accaprov_allow', '1');
    
    $user_pass = get_user_meta($user_id, 'jobsearch_new_user_regtpass', true);
    if ($user_pass != '') {
        $user_pass = base64_decode($user_pass);
        do_action('jobsearch_new_user_register', $c_user, $user_pass);
    }

    echo json_encode(array('error' => '0', 'msg' => esc_html__('Approved', 'wp-jobsearch')));
    die;
}

add_action('wp_ajax_jobsearch_user_acountaprovl_by_admin', 'jobsearch_user_acountaprovl_by_admin');
//

add_filter('wp_insert_post_data', 'jobsearch_prevent_post_creation_and_update', 15, 2);

function jobsearch_prevent_post_creation_and_update($data, $postarr) {
    if (is_admin() && !defined('DOING_AUTOSAVE') && !defined('REST_REQUEST')) {
        $user_reg_email = isset($postarr['user_reg_with_email']) ? esc_html(sanitize_text_field($postarr['user_reg_with_email'])) : '';

        if ($data['post_type'] == 'candidate' || $data['post_type'] == 'employer') {

            if ($user_reg_email != '' && email_exists($user_reg_email)) {

                $user_obj = get_user_by('email', $user_reg_email);
                $user_id = $user_obj->ID;
                if (jobsearch_user_is_candidate($user_id) || jobsearch_user_is_employer($user_id)) {
                    set_transient('jobsearch_invalid_member_reg_email', '1', 120);
                    wp_redirect($postarr['_wp_http_referer'] . '&jobsearch_err=invalid_reg_email');
                    exit;
                }
            }
            if ($user_reg_email != '') {
                $post_id = isset($_POST['post_ID']) ? $_POST['post_ID'] : '';
                if ($data['post_type'] == 'candidate') {
                    jobsearch_new_cand_add_bk_action($post_id, $user_reg_email);
                } else if ($data['post_type'] == 'employer') {
                    jobsearch_new_employer_add_bk_action($post_id, $user_reg_email);
                }
            }
        }
    }
    return $data;
}

add_action('admin_notices', 'jobsearch_user_postsave_wrong_regemail_error_notice', 90);

function jobsearch_user_postsave_wrong_regemail_error_notice() {
    // Check if our transient is set
    if (isset($_GET['jobsearch_err']) && 'invalid_reg_email' == sanitize_text_field($_GET['jobsearch_err']) && get_transient('jobsearch_invalid_member_reg_email')) {
        echo '<div class="notice notice-error is-dismissible"><p>' . esc_html__('Email is already attached with a user profile. Please choose another email.', 'wp-jobsearch') . '</p></div>';
        // Delete the transient after displaying the notice
        delete_transient('jobsearch_invalid_member_reg_email');
    }
}

//
function jobsearch_new_cand_add_bk_action($post_id, $user_email)
{
    if (filter_var($user_email, FILTER_VALIDATE_EMAIL)) {

        if (!email_exists($user_email)) {
            $user_pass = wp_generate_password(12);

            $username = $user_email;
            if (isset($_POST['post_title']) && $_POST['post_title'] != '') {
                $username = sanitize_title($_POST['post_title']);
            }

            $create_user = wp_create_user($username, $user_pass, $user_email);

            if (!is_wp_error($create_user)) {
                $user_id = $create_user;
                $update_user_arr = array(
                    'ID' => $user_id,
                    'role' => 'jobsearch_candidate'
                );
                wp_update_user($update_user_arr);

                $user_cand_id = get_user_meta($user_id, 'jobsearch_candidate_id', true);
                if ($user_cand_id > 0 && get_post_type($user_cand_id) == 'candidate') {
                    wp_delete_post($user_cand_id, true);
                }

                //
                update_user_meta($user_id, 'jobsearch_candidate_id', $post_id);
                update_post_meta($post_id, 'jobsearch_user_id', $user_id);
                update_post_meta($post_id, 'jobsearch_field_user_email', $user_email);
                update_user_option($user_id, 'show_admin_bar_front', false);
                //
                jobsearch_update_post_author_by_id($post_id, $user_id);

                $c_user = get_user_by('email', $user_email);
                do_action('jobsearch_new_user_register', $c_user, $user_pass);
            }
        } else {
            $user_obj = get_user_by('email', $user_email);
            if (in_array('administrator', (array)$user_obj->roles)) {
                return false;
            }
            $user_id = $user_obj->ID;

            $user_cand_id = get_user_meta($user_id, 'jobsearch_candidate_id', true);
            //
            update_user_meta($user_id, 'jobsearch_candidate_id', $post_id);
            update_post_meta($post_id, 'jobsearch_user_id', $user_id);
            update_post_meta($post_id, 'jobsearch_field_user_email', $user_email);
            //
            jobsearch_update_post_author_by_id($post_id, $user_id);
        }
    }
}

add_action('wp_ajax_jobsearch_user_delete_email_apply_job', 'jobsearch_user_delete_email_apply_job');

function jobsearch_user_delete_email_apply_job()
{
    $nonce_val = sanitize_key(wp_unslash($_POST['_nonce']));
    if (!wp_verify_nonce($nonce_val, 'jobsearch_ajax_nonce')) {
        wp_send_json(array('delete' => '0'));
    }
    
    $user_email = $_POST['email'];
    $job_id = $_POST['id'];

    $is_emp_job = jobsearch_is_employer_job($job_id);
    if (!$is_emp_job && !current_user_can('administrator')) {
        wp_send_json(array('delete' => '0'));
    }

    $args = array(
        'post_type' => 'email_apps',
        'posts_per_page' => 1,
        'post_status' => 'publish',
        'fields' => 'ids',
        'meta_query' => array(
            array(
                'key' => 'jobsearch_app_user_email',
                'value' => $user_email,
                'compare' => '=',
            ),
            array(
                'key' => 'jobsearch_app_job_id',
                'value' => $job_id,
                'compare' => '=',
            ),
        ),
    );
    $aplics_query = new WP_Query($args);

    $aplics_posts = $aplics_query->posts;

    if (isset($aplics_posts[0])) {
        $aplic_emailid = $aplics_posts[0];
        wp_delete_post($aplic_emailid, true);
    }

    $job_applicants_list = get_post_meta($job_id, 'jobsearch_job_emailapps_list', true);
    if (!empty($job_applicants_list)) {
        $new_applics_list = array();
        foreach ($job_applicants_list as $email_applic) {
            $app_email = isset($email_applic['user_email']) ? $email_applic['user_email'] : '';
            if ($app_email == $user_email) {
                continue;
            } else {
                $new_applics_list[] = $email_applic;
            }
        }
        update_post_meta($job_id, 'jobsearch_job_emailapps_list', $new_applics_list);
    }

    if (isset($_COOKIE["jobsearch_email_apply_job_" . $job_id])) {
        unset($_COOKIE["jobsearch_email_apply_job_" . $job_id]);
    }
    setcookie("jobsearch_email_apply_job_" . $job_id, '', time() - 3600, "/");

    wp_send_json(array('delete' => '1'));
}

add_action('jobsearch_candidate_profile_save_after_end', 'jobsearch_profileres_redirect_on_dashb_saving', 100);

function jobsearch_profileres_redirect_on_dashb_saving($candidate_id)
{

    global $jobsearch_plugin_options;

    $user_pkg_limits = new Package_Limits;

    $dashmenu_links_cand = isset($jobsearch_plugin_options['cand_dashbord_menu']) ? $jobsearch_plugin_options['cand_dashbord_menu'] : '';
    $dashmenu_links_cand = apply_filters('jobsearch_cand_dashbord_menu_items_arr', $dashmenu_links_cand);

    $inopt_cover_letr = isset($jobsearch_plugin_options['cand_resm_cover_letr']) ? $jobsearch_plugin_options['cand_resm_cover_letr'] : '';
    $cand_skills_switch = isset($jobsearch_plugin_options['cand_skills_switch']) ? $jobsearch_plugin_options['cand_skills_switch'] : '';

    $inopt_resm_education = isset($jobsearch_plugin_options['cand_resm_education']) ? $jobsearch_plugin_options['cand_resm_education'] : '';
    $inopt_resm_experience = isset($jobsearch_plugin_options['cand_resm_experience']) ? $jobsearch_plugin_options['cand_resm_experience'] : '';
    $inopt_resm_portfolio = isset($jobsearch_plugin_options['cand_resm_portfolio']) ? $jobsearch_plugin_options['cand_resm_portfolio'] : '';
    $inopt_resm_skills = isset($jobsearch_plugin_options['cand_resm_skills']) ? $jobsearch_plugin_options['cand_resm_skills'] : '';
    $inopt_resm_langs = isset($jobsearch_plugin_options['cand_resm_langs']) ? $jobsearch_plugin_options['cand_resm_langs'] : '';
    $inopt_resm_honsawards = isset($jobsearch_plugin_options['cand_resm_honsawards']) ? $jobsearch_plugin_options['cand_resm_honsawards'] : '';

    $cover_letter = get_post_meta($candidate_id, 'jobsearch_field_resume_cover_letter', true);
    $educs_list = get_post_meta($candidate_id, 'jobsearch_field_education_title', true);
    $exps_list = get_post_meta($candidate_id, 'jobsearch_field_experience_title', true);
    $ports_list = get_post_meta($candidate_id, 'jobsearch_field_portfolio_title', true);
    $exprties_list = get_post_meta($candidate_id, 'jobsearch_field_skill_title', true);
    $langs_list = get_post_meta($candidate_id, 'jobsearch_field_lang_title', true);
    $awards_list = get_post_meta($candidate_id, 'jobsearch_field_award_title', true);

    $user_dashboard_page = isset($jobsearch_plugin_options['user-dashboard-template-page']) ? $jobsearch_plugin_options['user-dashboard-template-page'] : '';
    $page_id = jobsearch__get_post_id($user_dashboard_page, 'page');
    $page_url = jobsearch_wpml_lang_page_permalink($page_id, 'page');

    $redirect = false;

    if (isset($dashmenu_links_cand['my_resume']) && $dashmenu_links_cand['my_resume'] == '1' && !$user_pkg_limits::cand_field_is_locked('dashtab_fields|my_resume')) {
        if ($inopt_cover_letr != 'off' && empty($cover_letter) && !$user_pkg_limits::cand_field_is_locked('coverltr_defields')) {
            $redirect = true;
        }
        if ($inopt_resm_education != 'off' && empty($educs_list) && !$user_pkg_limits::cand_field_is_locked('resmedu_defields')) {
            $redirect = true;
        }
        if ($inopt_resm_experience != 'off' && empty($exps_list) && !$user_pkg_limits::cand_field_is_locked('resmexp_defields')) {
            $redirect = true;
        }
        if ($inopt_resm_portfolio != 'off' && empty($ports_list) && !$user_pkg_limits::cand_field_is_locked('resmport_defields')) {
            $redirect = true;
        }
        if ($inopt_resm_skills != 'off' && empty($exprties_list) && !$user_pkg_limits::cand_field_is_locked('resmskills_defields')) {
            $redirect = true;
        }
        if ($inopt_resm_langs != 'off' && empty($langs_list)) {
            $redirect = true;
        }
        if ($inopt_resm_honsawards != 'off' && empty($awards_list) && !$user_pkg_limits::cand_field_is_locked('resmawards_defields')) {
            $redirect = true;
        }
    }

    if ($redirect) {
        $redirct_page_url = add_query_arg(array('tab' => 'my-resume'), $page_url);
        wp_safe_redirect($redirct_page_url);
    }
}

add_action('jobsearch_candidate_dash_resume_save_after', 'jobsearch_profilecv_redirect_on_dashb_saving', 100);

function jobsearch_profilecv_redirect_on_dashb_saving($candidate_id)
{
    global $jobsearch_plugin_options;

    $user_pkg_limits = new Package_Limits;

    $dashmenu_links_cand = isset($jobsearch_plugin_options['cand_dashbord_menu']) ? $jobsearch_plugin_options['cand_dashbord_menu'] : '';
    $dashmenu_links_cand = apply_filters('jobsearch_cand_dashbord_menu_items_arr', $dashmenu_links_cand);

    $multiple_cv_files_allow = isset($jobsearch_plugin_options['multiple_cv_uploads']) ? $jobsearch_plugin_options['multiple_cv_uploads'] : '';

    $user_dashboard_page = isset($jobsearch_plugin_options['user-dashboard-template-page']) ? $jobsearch_plugin_options['user-dashboard-template-page'] : '';
    $page_id = jobsearch__get_post_id($user_dashboard_page, 'page');
    $page_url = jobsearch_wpml_lang_page_permalink($page_id, 'page');

    $redirect = false;

    if (isset($dashmenu_links_cand['cv_manager']) && $dashmenu_links_cand['cv_manager'] == '1' && !$user_pkg_limits::cand_field_is_locked('dashtab_fields|cv_manager')) {
        if ($multiple_cv_files_allow == 'on') {
            $cand_cv_files = array();
            $ca_at_cv_files = get_post_meta($candidate_id, 'candidate_cv_files', true);
            if (!empty($ca_at_cv_files)) {
                foreach ($ca_at_cv_files as $cv_file_key => $cv_file_val) {
                    $filetype = isset($cv_file_val['mime_type']) ? $cv_file_val['mime_type'] : '';
                    if (!empty($filetype)) {
                        $cand_cv_files[] = $cv_file_val;
                    }
                }
            }
        } else {
            $cand_cv_files = get_post_meta($candidate_id, 'candidate_cv_file', true);
        }
        if (empty($cand_cv_files)) {
            $redirect = true;
        }
    }

    if ($redirect) {
        $redirct_page_url = add_query_arg(array('tab' => 'cv-manager'), $page_url);
        wp_safe_redirect($redirct_page_url);
    }
}

//

function jobsearch_addto_candidate_exp_inyears($candidate_id)
{
    $cand_exp_startdate = get_post_meta($candidate_id, 'jobsearch_field_exp_start_date_hiden', true);
    $cand_exp_enddate = get_post_meta($candidate_id, 'jobsearch_field_exp_end_date_hiden', true);
    $cand_exp_present = get_post_meta($candidate_id, 'jobsearch_field_experience_date_prsnt', true);
    if (!empty($cand_exp_startdate)) {
        $new_exp_filedsarr = array();
        $exfield_counter = 0;
        foreach ($cand_exp_startdate as $start_date) {

            $exfield_start_date = isset($cand_exp_startdate[$exfield_counter]) ? $cand_exp_startdate[$exfield_counter] : '';
            $exfield_end_date = isset($cand_exp_enddate[$exfield_counter]) ? $cand_exp_enddate[$exfield_counter] : '';
            $exfield_prsnt_field = isset($cand_exp_present[$exfield_counter]) ? $cand_exp_present[$exfield_counter] : '';

            $exp_sort_date = 0;
            if ($exfield_start_date != '') {
                $exp_sort_date = strtotime($exfield_start_date);
            }

            $new_exp_filedsarr[] = array(
                'start_date' => $exfield_start_date,
                'end_date' => $exfield_end_date,
                'present' => $exfield_prsnt_field,
                'sort_date' => $exp_sort_date,
            );

            $exfield_counter++;
        }
        usort($new_exp_filedsarr, function ($a, $b) {
            if ($a['sort_date'] == $b['sort_date']) {
                $ret_val = 0;
            }
            $ret_val = ($a['sort_date'] < $b['sort_date']) ? -1 : 1;
            return $ret_val;
        });
        //echo '<pre>';
        //var_dump($new_exp_filedsarr);
        //echo '</pre>';
        $start_date = $new_exp_filedsarr[0]['start_date'];
        $all_arr_end = end($new_exp_filedsarr);
        $end_date = $all_arr_end['end_date'];
        if ($all_arr_end['present'] == 'on' || $end_date == '') {
            $end_date = current_time('d-m-Y');
        }

        $start_date_str = $end_date_str = 0;
        if ($start_date != '') {
            $start_date_str = strtotime($start_date);
        }
        if ($end_date != '') {
            $end_date_str = strtotime($end_date);
        }

        if ($start_date_str > 0 && $end_date_str > 0 && $end_date_str > $start_date_str) {
            $date_diff = abs($end_date_str - $start_date_str);
            $overall_exp = floor($date_diff / (365*60*60*24));
        } else {
            $overall_exp = 0;
        }
        $overall_exp = absint($overall_exp);
        update_post_meta($candidate_id, 'jobsearch_candidate_experience_inyears', $overall_exp);
    }
}

add_action('pre_get_terms', 'jobsearch_owncustax_chnge_get_terms');

function jobsearch_owncustax_chnge_get_terms($query)
{
    global $pagenow;
    if (isset($query->query_vars)) {
        $qury_vars = $query->query_vars;
        if ($pagenow != 'edit-tags.php' && $pagenow != 'admin.php' && $pagenow != 'index.php' && isset($qury_vars['taxonomy'][0]) && $qury_vars['taxonomy'][0] == 'job-location') {
            //
            $query->query_vars['taxonomy'][0] = 'jobsearch_owncustax';
        }
    }
}

add_filter('get_terms', 'jobsearch_custom_modify_terms', 12, 4);

function jobsearch_custom_modify_terms($terms, $taxonomy, $query_vars, $term_query)
{
    global $wpdb, $pagenow;
    if (isset($taxonomy[0]) && $taxonomy[0] == 'jobsearch_owncustax') {

        if ($pagenow != 'edit.php' && $pagenow != 'index.php' && !is_page() && $pagenow != 'post.php' && $pagenow != 'post-new.php' && $pagenow != 'nav-menus.php' && $pagenow != 'admin-ajax.php') {
            $get_db_terms = $wpdb->get_results($wpdb->prepare("SELECT * FROM $wpdb->terms AS terms"
                . " LEFT JOIN $wpdb->term_taxonomy AS term_tax ON(terms.term_id = term_tax.term_id) "
                . " WHERE term_tax.taxonomy = %s", 'job-location'));

            $terms = $get_db_terms;
        } else {
            $terms = array();
        }
    }

    return $terms;
}

function jobsearch_get_custom_term_by($field = 'term_id', $value = '0', $taxonomy = 'job-location')
{
    global $wpdb;
    if (function_exists('icl_object_id')) {
        global $sitepress;
        $sitepress_curr_lang = $sitepress->get_current_language();

        $trans_tble = $wpdb->prefix . 'icl_translations';
        $terms = $wpdb->get_results($wpdb->prepare("SELECT * FROM $wpdb->terms AS terms"
            . " LEFT JOIN $wpdb->term_taxonomy AS term_tax ON(terms.term_id = term_tax.term_id) "
            . " LEFT JOIN $trans_tble AS icl_trans ON (terms.term_id = icl_trans.element_id AND icl_trans.element_type = 'tax_$taxonomy') "
            . " WHERE term_tax.taxonomy = '%s' AND terms." . $field . "='" . $value . "'"
            . " AND icl_trans.language_code='" . $sitepress_curr_lang . "'", $taxonomy));
    } else {
        $terms = $wpdb->get_results($wpdb->prepare("SELECT * FROM $wpdb->terms AS terms"
            . " LEFT JOIN $wpdb->term_taxonomy AS term_tax ON(terms.term_id = term_tax.term_id) "
            . " WHERE term_tax.taxonomy = '%s' AND terms." . $field . "='" . $value . "'", $taxonomy));
    }
    if (isset($terms[0])) {
        return $terms[0];
    }
    return false;
}

function jobsearch_custom_get_terms($taxonomy = 'job-location', $parent = 0, $orderby = 'terms.name', $order = 'ASC', $hide_empty = false)
{
    global $wpdb;

    if (function_exists('icl_object_id')) {
        global $sitepress;
        $trans_tble = $wpdb->prefix . 'icl_translations';
        $terms = $wpdb->get_results($wpdb->prepare("SELECT * FROM $wpdb->terms AS terms"
            . " LEFT JOIN $wpdb->term_taxonomy AS term_tax ON(terms.term_id = term_tax.term_id) "
            . " LEFT JOIN $trans_tble AS icl_trans ON (terms.term_id = icl_trans.element_id AND icl_trans.element_type = 'tax_$taxonomy') "
            . " WHERE term_tax.taxonomy = '%s' AND term_tax.parent = " . $parent
            . " AND icl_trans.element_type='tax_{$taxonomy}'"
            . " AND icl_trans.language_code='" . $sitepress->get_current_language() . "'"
            . " GROUP BY terms.term_id"
            . " ORDER BY " . $orderby . " " . $order, $taxonomy));
    } else {
        $terms = $wpdb->get_results($wpdb->prepare("SELECT * FROM $wpdb->terms AS terms"
            . " LEFT JOIN $wpdb->term_taxonomy AS term_tax ON(terms.term_id = term_tax.term_id) "
            . " WHERE term_tax.taxonomy = '%s' AND term_tax.parent = " . $parent
            . " GROUP BY terms.term_id"
            . " ORDER BY " . $orderby . " " . $order, $taxonomy));
    }
    return $terms;
}

function jobsearch_get_terms_woutparnt($taxonomy = 'job-location', $orderby = 'terms.name', $order = 'ASC', $hide_empty = false)
{
    global $wpdb;

    $order_by_metakey = false;
    if (is_array($orderby) && isset($orderby[0]) && $orderby[0] == 'meta_value_num') {
        $order_by_metakey = true;
        $meta_key = $orderby[1];
    }

    if (function_exists('icl_object_id')) {
        global $sitepress;
        $trans_tble = $wpdb->prefix . 'icl_translations';
        $query = "SELECT * FROM $wpdb->terms AS terms";
        $query .= " LEFT JOIN $wpdb->term_taxonomy AS term_tax ON(terms.term_id = term_tax.term_id)";
        $query .= " LEFT JOIN $trans_tble AS icl_trans ON (terms.term_id = icl_trans.element_id AND icl_trans.element_type = 'tax_$taxonomy')";
        if ($order_by_metakey) {
            $query .= " LEFT JOIN $wpdb->termmeta AS term_meta ON(terms.term_id = term_meta.term_id)";
            $query .= " WHERE term_tax.taxonomy='%s' AND term_meta.meta_key='{$meta_key}'";
        } else {
            $query .= " WHERE term_tax.taxonomy='%s'";
        }
        $query .= " AND icl_trans.element_type='tax_{$taxonomy}'";
        $query .= " AND icl_trans.language_code='" . $sitepress->get_current_language() . "'";
        $query .= " GROUP BY terms.term_id";
        if ($order_by_metakey) {
            $query .= " ORDER BY cast(term_meta.meta_value as unsigned) " . $order;
        } else {
            $query .= " ORDER BY " . $orderby . " " . $order;
        }
        $terms = $wpdb->get_results($wpdb->prepare($query, $taxonomy));
    } else {
        $query = "SELECT * FROM $wpdb->terms AS terms";
        $query .= " LEFT JOIN $wpdb->term_taxonomy AS term_tax ON(terms.term_id = term_tax.term_id)";
        if ($order_by_metakey) {
            $query .= " LEFT JOIN $wpdb->termmeta AS term_meta ON(terms.term_id = term_meta.term_id)";
            $query .= " WHERE term_tax.taxonomy='%s' AND term_meta.meta_key='{$meta_key}'";
        } else {
            $query .= " WHERE term_tax.taxonomy='%s'";
        }
        $query .= " GROUP BY terms.term_id";
        if ($order_by_metakey) {
            $query .= " ORDER BY cast(term_meta.meta_value as unsigned) " . $order;
        } else {
            $query .= " ORDER BY " . $orderby . " " . $order;
        }
        //var_dump($wpdb->prepare($query, $taxonomy));
        $terms = $wpdb->get_results($wpdb->prepare($query, $taxonomy));
    }

    return $terms;
}

function jobsearch_get_terms_wlimit($taxonomy = 'job-location', $limit = 10, $offset = 0, $orderby = 'terms.name', $order = 'ASC')
{
    global $wpdb;
    if (function_exists('icl_object_id')) {
        global $sitepress;
        $trans_tble = $wpdb->prefix . 'icl_translations';
        $terms = $wpdb->get_results($wpdb->prepare("SELECT * FROM $wpdb->terms AS terms"
            . " LEFT JOIN $wpdb->term_taxonomy AS term_tax ON(terms.term_id = term_tax.term_id) "
            . " LEFT JOIN $trans_tble AS icl_trans ON (terms.term_id = icl_trans.element_id AND icl_trans.element_type = 'tax_$taxonomy') "
            . " WHERE term_tax.taxonomy = '%s'"
            . " AND icl_trans.element_type='tax_{$taxonomy}'"
            . " AND icl_trans.language_code='" . $sitepress->get_current_language() . "'"
            . " GROUP BY terms.term_id"
            . " ORDER BY " . $orderby . " " . $order
            . " LIMIT " . $limit . " OFFSET " . $offset, $taxonomy));
    } else {
        $terms = $wpdb->get_results($wpdb->prepare("SELECT * FROM $wpdb->terms AS terms"
            . " LEFT JOIN $wpdb->term_taxonomy AS term_tax ON(terms.term_id = term_tax.term_id) "
            . " WHERE term_tax.taxonomy = '%s' "
            . " GROUP BY terms.term_id"
            . " ORDER BY " . $orderby . " " . $order
            . " LIMIT " . $limit . " OFFSET " . $offset, $taxonomy));
    }

    return $terms;
}

function jobsearch_get_terms_wcounts($taxonomy = 'job-location', $post_type = 'job', $orderby = 'terms.name', $order = 'ASC')
{
    global $wpdb;
    if (function_exists('icl_object_id')) {
        global $sitepress;
        $trans_tble = $wpdb->prefix . 'icl_translations';
        $terms = $wpdb->get_results($wpdb->prepare("SELECT * FROM $wpdb->terms AS terms"
            . " LEFT JOIN $wpdb->term_taxonomy AS term_tax ON(terms.term_id = term_tax.term_id) "
            . " LEFT JOIN $trans_tble AS icl_trans ON (terms.term_id = icl_trans.element_id AND icl_trans.element_type = 'tax_$taxonomy') "
            . " WHERE term_tax.taxonomy = '%s' AND term_meta.meta_key='active_" . $post_type . "s_loc_count' AND term_meta.meta_value > 0 "
            . " AND icl_trans.element_type='tax_{$taxonomy}'"
            . " AND icl_trans.language_code='" . $sitepress->get_current_language() . "'"
            . " GROUP BY terms.term_id"
            . " ORDER BY " . $orderby . " " . $order, $taxonomy));
    } else {
        $terms = $wpdb->get_results($wpdb->prepare("SELECT * FROM $wpdb->terms AS terms"
            . " LEFT JOIN $wpdb->term_taxonomy AS term_tax ON(terms.term_id = term_tax.term_id) "
            . " LEFT JOIN $wpdb->termmeta AS term_meta ON(terms.term_id = term_meta.term_id) "
            . " WHERE term_tax.taxonomy = '%s' AND term_meta.meta_key='active_" . $post_type . "s_loc_count' AND term_meta.meta_value > 0 "
            . " GROUP BY terms.term_id"
            . " ORDER BY " . $orderby . " " . $order, $taxonomy));
    }

    return $terms;
}

if (!function_exists('jobsearch_candidate_listing_custom_fields_callback')) {

    function jobsearch_candidate_listing_custom_fields_callback($atts = array(), $candidate_id = '', $candidate_cus_field_arr = array(), $view = 'view-1')
    {
        $candidate_custom_fields_switch = isset($atts['candidate_custom_fields_switch']) ? $atts['candidate_custom_fields_switch'] : 'no';
        if ($candidate_custom_fields_switch == 'yes' && !empty($candidate_cus_field_arr)) {
            $cus_fields = array(
                'content' => '',
                'candidate_list' => true,
            );

            if ($view == 'default') {
                $cus_fields = apply_filters('jobsearch_custom_fields_list', 'candidate', $candidate_id, $cus_fields, '<li>', '</li>', '', true, true, true, 'jobsearch', $candidate_cus_field_arr);
            } else {
                $cus_fields = apply_filters('jobsearch_custom_fields_list', 'candidate', $candidate_id, $cus_fields, '', '', '', true, true, true, 'jobsearch', $candidate_cus_field_arr);
            }
            if (isset($cus_fields['content']) && $cus_fields['content'] != '') {
                if ($view == 'default') {
                    echo '<ul class="jobsearch-custom-field">' . force_balance_tags($cus_fields['content']) . ' </ul> ';
                } else {
                    echo '<small class="careerfy-candidate-style8-options">' . force_balance_tags($cus_fields['content']) . '</small>';
                }
            }
        }
    }

    add_action('jobsearch_candidate_listing_custom_fields', 'jobsearch_candidate_listing_custom_fields_callback', 10, 4);
}

add_filter('author_link', function ($link, $user_id) {
    $user_is_candidate = jobsearch_user_is_candidate($user_id);
    $user_is_employer = jobsearch_user_is_employer($user_id);
    $user_obj = get_user_by('id', $user_id);
    if ( isset($user_obj->roles) ) {
      if ($user_is_employer && in_array('jobsearch_employer', (array)$user_obj->roles)) {
          $employer_id = jobsearch_get_user_employer_id($user_id);
          if ($employer_id > 0 && get_post_type($employer_id) == 'employer') {
              $link = get_permalink($employer_id);
          }
      } else if ($user_is_candidate && in_array('jobsearch_candidate', (array)$user_obj->roles)) {
          $candidate_id = jobsearch_get_user_candidate_id($user_id);
          if ($candidate_id > 0 && get_post_type($candidate_id) == 'candidate') {
              $link = get_permalink($candidate_id);
          }
      }
    }

    return $link;
}, 10, 2);

function jobsearch_applicant_pend_profile_review_txt() {

    return '<span class="pending-profile-applicant">' . esc_html__('This applicant profile is not complete.', 'wp-jobsearch') . '<br><small>' . esc_html__('Pending for review.', 'wp-jobsearch') . '</small></span>';
}

function jobsearch_applicant_cand_profile_notaprov_txt() {

    return '<span class="pending-profile-applicant">' . esc_html__('This candidate account is not approved.', 'wp-jobsearch') . '<br><small>' . esc_html__('Pending for admin review.', 'wp-jobsearch') . '</small></span>';
}

function jobsearch_get_applicant_status_tarr($candidate_id, $job_id)
{
    global $jobsearch_plugin_options;
    $candidate_skills = isset($jobsearch_plugin_options['jobsearch_candidate_skills']) ? $jobsearch_plugin_options['jobsearch_candidate_skills'] : '';
    if ($candidate_skills == 'on') {
        $candidate_skill_perc = get_post_meta($candidate_id, 'overall_skills_percentage', true);
        $candidate_approve_skill = isset($jobsearch_plugin_options['jobsearch-candidate-skills-percentage']) ? $jobsearch_plugin_options['jobsearch-candidate-skills-percentage'] : 0;
        if (($candidate_approve_skill > 0 && $candidate_skill_perc < $candidate_approve_skill)) {
            return array('status' => 'pending', 'status_str' => esc_html_x('Pending due to incomplete profile', 'applicant status', 'wp-jobsearch'));
        }
    }
    $job_reject_int_list = get_post_meta($job_id, '_job_reject_interview_list', true);
    $job_reject_int_list = $job_reject_int_list != '' ? explode(',', $job_reject_int_list) : '';
    $job_reject_int_list = jobsearch_is_post_ids_array($job_reject_int_list, 'candidate');
    if (!empty($job_reject_int_list) && in_array($candidate_id, $job_reject_int_list)) {
        return array('status' => 'rejected', 'status_str' => esc_html_x('Rejected', 'applicant status', 'wp-jobsearch'));
    }

    $job_short_int_list = get_post_meta($job_id, '_job_short_interview_list', true);
    $job_short_int_list = $job_short_int_list != '' ? explode(',', $job_short_int_list) : '';
    $job_short_int_list = jobsearch_is_post_ids_array($job_short_int_list, 'candidate');
    if (!empty($job_short_int_list) && in_array($candidate_id, $job_short_int_list)) {
        return array('status' => 'shortlist', 'status_str' => esc_html_x('Shortlist', 'applicant status', 'wp-jobsearch'));
    }
}

add_action('wp_ajax_jobsearch_get_all_cands', 'jobsearch_get_all_cands');
add_action('wp_ajax_nopriv_jobsearch_get_all_cands', 'jobsearch_get_all_cands');

function jobsearch_get_all_cands()
{
    global $jobsearch_plugin_options;
    $nonce_val = sanitize_key(wp_unslash($_POST['_nonce']));
    if (!wp_verify_nonce($nonce_val, 'jobsearch_ajax_nonce')) {
        $msg = esc_html__('You are not allowed to do this.', 'wp-jobsearch');
        echo json_encode(array('msg' => $msg, 'error' => '1'));
        die;
    }
    $job_id = isset($_POST['job_id']) ? $_POST['job_id'] : '';
    $employer_id = isset($_POST['employer_id']) ? $_POST['employer_id'] : '';
    $apps_start = isset($_POST['apps_start']) ? $_POST['apps_start'] : 0;
    $job_applicants_list = get_post_meta($job_id, 'jobsearch_job_applicants_list', true);
    $job_applicants_list = jobsearch_is_post_ids_array($job_applicants_list, 'candidate');

    arsort($job_applicants_list);

    if (empty($job_applicants_list)) {
        $job_applicants_list = array();
    }

    $viewed_candidates = get_post_meta($job_id, 'jobsearch_viewed_candidates', true);
    if (empty($viewed_candidates)) {
        $viewed_candidates = array();
    }
    $viewed_candidates = jobsearch_is_post_ids_array($viewed_candidates, 'candidate');

    $job_short_int_list = get_post_meta($job_id, '_job_short_interview_list', true);
    $job_short_int_list = $job_short_int_list != '' ? explode(',', $job_short_int_list) : '';
    if (empty($job_short_int_list)) {
        $job_short_int_list = array();
    }
    $job_short_int_list = jobsearch_is_post_ids_array($job_short_int_list, 'candidate');

    $job_reject_int_list = get_post_meta($job_id, '_job_reject_interview_list', true);
    $job_reject_int_list = $job_reject_int_list != '' ? explode(',', $job_reject_int_list) : '';
    if (empty($job_reject_int_list)) {
        $job_reject_int_list = array();
    }
    $job_reject_int_list = jobsearch_is_post_ids_array($job_reject_int_list, 'candidate');
    //
    $apps_offset = 6;
    if ($apps_start > 0) {
        $apps_start = ($apps_start - 1) * ($apps_offset);
    }
    $job_applicants_list = array_slice($job_applicants_list, $apps_start, $apps_offset);

    if (!empty($job_applicants_list)) {

        foreach ($job_applicants_list as $_candidate_id) {

            $candidate_user_id = jobsearch_get_candidate_user_id($_candidate_id);
            if (absint($candidate_user_id) <= 0) {
                continue;
            }
            $candidate_user_obj = get_user_by('ID', $candidate_user_id);
            $user_def_avatar_url = jobsearch_candidate_img_url_comn($_candidate_id);

            $candidate_jobtitle = get_post_meta($_candidate_id, 'jobsearch_field_candidate_jobtitle', true);
            $get_candidate_location = get_post_meta($_candidate_id, 'jobsearch_field_location_address', true);

            $job_short_int_list = get_post_meta($job_id, '_job_short_interview_list', true);
            $job_short_int_list = $job_short_int_list != '' ? explode(',', $job_short_int_list) : '';
            if (empty($job_short_int_list)) {
                $job_short_int_list = array();
            }
            $job_short_int_list = jobsearch_is_post_ids_array($job_short_int_list, 'candidate');


            $job_reject_int_list = get_post_meta($job_id, '_job_reject_interview_list', true);
            $job_reject_int_list = $job_reject_int_list != '' ? explode(',', $job_reject_int_list) : '';
            if (empty($job_reject_int_list)) {
                $job_reject_int_list = array();
            }
            $job_reject_int_list = jobsearch_is_post_ids_array($job_reject_int_list, 'candidate');

            $candidate_city_title = '';
            $get_candidate_city = get_post_meta($_candidate_id, 'jobsearch_field_location_location3', true);
            if ($get_candidate_city == '') {
                $get_candidate_city = get_post_meta($_candidate_id, 'jobsearch_field_location_location2', true);
            }
            if ($get_candidate_city == '') {
                $get_candidate_city = get_post_meta($_candidate_id, 'jobsearch_field_location_location1', true);
            }

            $candidate_city_tax = $get_candidate_city != '' ? get_term_by('slug', $get_candidate_city, 'job-location') : '';
            if (is_object($candidate_city_tax)) {
                $candidate_city_title = $candidate_city_tax->name;
            }

            $sectors = wp_get_post_terms($_candidate_id, 'sector');
            $candidate_sector = isset($sectors[0]->name) ? $sectors[0]->name : '';
            $candidate_salary = jobsearch_candidate_current_salary($_candidate_id);
            $candidate_age = jobsearch_candidate_age($_candidate_id);
            $candidate_phone = get_post_meta($_candidate_id, 'jobsearch_field_user_phone', true);
            $job_cver_ltrs = get_post_meta($job_id, 'jobsearch_job_apply_cvrs', true);
            $send_message_form_rand = rand(100000, 999999);
            $applicant_status = jobsearch_get_applicant_status_tarr($_candidate_id, $job_id);
            
            $candidate_status = get_post_meta($_candidate_id, 'jobsearch_field_candidate_approved', true);
            ?>
            <li class="jobsearch-column-12<?php echo ((isset($applicant_status['status']) && $applicant_status['status'] == 'pending') || $candidate_status != 'on' ? ' applicant-status-pending' : '') ?>">
                <script>
                    jQuery(document).on('click', '.jobsearch-modelemail-btn-<?php echo($send_message_form_rand) ?>', function () {
                        jobsearch_modal_popup_open('JobSearchModalSendEmailComm');
                        jQuery('#JobSearchModalSendEmailComm').find('form').attr('id', 'jobsearch_send_email_form<?php echo($send_message_form_rand) ?>');
                        jQuery('#JobSearchModalSendEmailComm').find('.loader-box').attr('class', 'loader-box loader-box-<?php echo($send_message_form_rand) ?>');
                        jQuery('#JobSearchModalSendEmailComm').find('.message-box').attr('class', 'message-box message-box-<?php echo($send_message_form_rand) ?>');
                        jQuery('#JobSearchModalSendEmailComm').find('.input-field-submit').find('input[type=submit]').attr('data-randid', '<?php echo($send_message_form_rand) ?>');
                        jQuery('#JobSearchModalSendEmailComm').find('.input-field-submit').find('input[type=submit]').attr('data-jid', '<?php echo($job_id) ?>');
                        jQuery('#JobSearchModalSendEmailComm').find('.input-field-submit').find('input[type=submit]').attr('data-cid', '<?php echo($_candidate_id) ?>');
                        jQuery('#JobSearchModalSendEmailComm').find('.input-field-submit').find('input[type=submit]').attr('data-eid', '<?php echo($employer_id) ?>');
                    });
                    jQuery(document).on('click', '.jobsearch-modelcvrltr-btn-<?php echo($send_message_form_rand) ?>', function () {
                        jobsearch_modal_popup_open('JobSearchCandCovershwModal<?php echo($send_message_form_rand) ?>');
                    });
                </script>
                <div class="jobsearch-applied-jobs-wrap">
                    <?php
                    $cand_is_pending = false;
                    if ($candidate_status != 'on') {
                        $cand_is_pending = true;
                        echo jobsearch_applicant_cand_profile_notaprov_txt();
                    } else if (isset($applicant_status['status']) && $applicant_status['status'] == 'pending') {
                        $cand_is_pending = true;
                        echo jobsearch_applicant_pend_profile_review_txt();
                    }
                    ?>
                    <a class="jobsearch-applied-jobs-thumb">
                        <?php
                        if (!$cand_is_pending) {
                            echo do_action('jobsearch_export_selection_emp', $_candidate_id, $job_id);
                        }
                        ?>
                        <img src="<?php echo($user_def_avatar_url) ?>" alt="">
                    </a>
                    <div class="jobsearch-applied-jobs-text">
                        <div class="jobsearch-applied-jobs-left">
                            <?php
                            $user_apply_data = get_user_meta($candidate_user_id, 'jobsearch-user-jobs-applied-list', true);
                            $aply_date_time = '';
                            if (!empty($user_apply_data)) {
                                $user_apply_key = array_search($job_id, array_column($user_apply_data, 'post_id'));
                                $aply_date_time = isset($user_apply_data[$user_apply_key]['date_time']) ? $user_apply_data[$user_apply_key]['date_time'] : '';
                            }
                            if ($candidate_jobtitle != '') { ?>
                                <span> <?php echo apply_filters('jobsearch_cand_jobtitle_indisplay', $candidate_jobtitle, $_candidate_id) ?></span>
                                <?php
                            }

                            if (in_array($_candidate_id, $viewed_candidates)) { ?>
                                <small class="profile-view viewed"><?php esc_html_e('(Viewed)', 'wp-jobsearch') ?></small>
                            <?php } else { ?>
                                <small class="profile-view unviewed"><?php esc_html_e('(Unviewed)', 'wp-jobsearch') ?></small>
                                <?php
                            }
                            $user_email_adr = isset($candidate_user_obj->user_email) ? $candidate_user_obj->user_email : '';
                            ?>
                            <a href="javascript:void(0);"
                               class="jobsearch-modelemail-btn-<?php echo($send_message_form_rand) ?> jobsearch-user-email">
                                <small> <?php printf(esc_html__('Email: %s', 'wp-jobsearch'), $user_email_adr) ?></small>
                            </a>
                            <?php
                            if (in_array($_candidate_id, $job_short_int_list)) {
                                ?>
                                <small class="profile-view viewed"><?php esc_html_e('(Shortlisted)', 'wp-jobsearch') ?></small>
                                <?php
                            }

                            if (in_array($_candidate_id, $job_reject_int_list)) { ?>
                                <small class="profile-view unviewed"><?php esc_html_e('(Rejected)', 'wp-jobsearch') ?></small>
                            <?php }

                            apply_filters('Jobsearch_Cand_shortlisted_View', $_candidate_id, $job_short_int_list);

                            echo apply_filters('jobsearch_applicants_list_before_title', '', $_candidate_id, $job_id);
                            ?>
                            <h2 class="jobsearch-pst-title">
                                <a href="<?php echo add_query_arg(array('job_id' => $job_id, 'employer_id' => $employer_id, 'action' => 'preview_profile'), get_permalink($_candidate_id)) ?>"><?php echo get_the_title($_candidate_id) ?></a>
                                <?php if ($candidate_age != '') { ?>
                                    <small><?php echo apply_filters('jobsearch_dash_applicants_age_html', sprintf(esc_html__('(Age: %s years)', 'wp-jobsearch'), $candidate_age)) ?></small>
                                    <?php
                                }
                                if ($candidate_phone != '') { ?>
                                    <small><?php printf(esc_html__('Phone: %s', 'wp-jobsearch'), $candidate_phone) ?></small>
                                <?php } ?>
                            </h2>
                            <ul>
                                <?php
                                if ($aply_date_time > 0) {
                                    ?>
                                    <li>
                                        <i class="jobsearch-icon jobsearch-calendar"></i> <?php printf(esc_html__('Applied at: %s', 'wp-jobsearch'), (date_i18n(get_option('date_format'), $aply_date_time) . ' ' . date_i18n(get_option('time_format'), $aply_date_time))) ?>
                                    </li>
                                    <?php
                                }
                                if ($candidate_salary != '') {
                                    ?>
                                    <li>
                                        <i class="fa fa-money"></i> <?php printf(esc_html__('Salary: %s', 'wp-jobsearch'), $candidate_salary) ?>
                                    </li>
                                    <?php
                                }
                                if ($candidate_city_title != '') {
                                    ?>
                                    <li><i class="jobsearch-icon jobsearch-maps-and-flags"></i> <?php echo($candidate_city_title) ?>
                                    </li>
                                    <?php
                                }
                                if ($candidate_sector != '') {
                                    ?>
                                    <li><i class="jobsearch-icon jobsearch-filter-tool-black-shape"></i>
                                        <a><?php echo($candidate_sector) ?></a></li>
                                    <?php
                                }
                                ?>
                            </ul>
                        </div>
                        <div class="jobsearch-applied-job-btns">
                            <?php
                            echo apply_filters('employer_dash_apps_acts_listul_after', '', $_candidate_id, $job_id);
                            ?>
                            <ul>
                                <li>
                                    <a href="<?php echo add_query_arg(array('job_id' => $job_id, 'employer_id' => $employer_id, 'action' => 'preview_profile'), get_permalink($_candidate_id)) ?>"
                                       class="preview-candidate-profile"><i
                                                class="fa fa-eye"></i> <?php esc_html_e('Preview', 'wp-jobsearch') ?>
                                    </a>
                                </li>
                                <li>
                                    <div class="candidate-more-acts-con">
                                        <a href="javascript:void(0);"
                                           class="more-actions"><?php esc_html_e('Actions', 'wp-jobsearch') ?>
                                            <i class="fa fa-angle-down"></i></a>
                                        <ul>
                                            <?php
                                            $multiple_cv_files_allow = isset($jobsearch_plugin_options['multiple_cv_uploads']) ? $jobsearch_plugin_options['multiple_cv_uploads'] : '';
                                            $candidate_cv_file = get_post_meta($_candidate_id, 'candidate_cv_file', true);

                                            if ($multiple_cv_files_allow == 'on') {
                                                $ca_at_cv_files = get_post_meta($_candidate_id, 'candidate_cv_files', true);
                                                if (!empty($ca_at_cv_files)) {
                                                    ?>
                                                    <li>
                                                        <a href="<?php echo apply_filters('jobsearch_user_attach_cv_file_url', '', $_candidate_id, $job_id) ?>"
                                                           oncontextmenu="javascript: return false;"
                                                           onclick="javascript: if ((event.button == 0 && event.ctrlKey)) {return false};"
                                                           download="<?php echo apply_filters('jobsearch_user_attach_cv_file_title', '', $_candidate_id, $job_id) ?>"><?php esc_html_e('Download CV', 'wp-jobsearch') ?></a>
                                                    </li>
                                                    <?php
                                                }
                                            } else if (!empty($candidate_cv_file)) {
                                                $file_attach_id = isset($candidate_cv_file['file_id']) ? $candidate_cv_file['file_id'] : '';
                                                $file_url = isset($candidate_cv_file['file_url']) ? $candidate_cv_file['file_url'] : '';

                                                $filename = isset($candidate_cv_file['file_name']) ? $candidate_cv_file['file_name'] : '';

                                                $file_url = apply_filters('wp_jobsearch_user_cvfile_downlod_url', $file_url, $file_attach_id, $_candidate_id);
                                                ?>
                                                <li><a href="<?php echo($file_url) ?>"
                                                       oncontextmenu="javascript: return false;"
                                                       onclick="javascript: if ((event.button == 0 && event.ctrlKey)) {return false};"
                                                       download="<?php echo($filename) ?>"><?php esc_html_e('Download CV', 'wp-jobsearch') ?></a>
                                                </li>
                                                <?php
                                            }
                                            echo apply_filters('employer_dash_apps_acts_list_after_download_link', '', $_candidate_id, $job_id);

                                            //
                                            if (isset($job_cver_ltrs[$_candidate_id]) && $job_cver_ltrs[$_candidate_id] != '') {
                                                ?>
                                                <li><a href="javascript:void(0);"
                                                       class="jobsearch-modelcvrltr-btn-<?php echo($send_message_form_rand) ?>"><?php esc_html_e('View Cover Letter', 'wp-jobsearch') ?></a>
                                                </li>
                                                <?php
                                            }
                                            ?>
                                            <li>
                                                <a href="javascript:void(0);"
                                                   class="jobsearch-modelemail-btn-<?php echo($send_message_form_rand) ?>"><?php esc_html_e('Email to Candidate', 'wp-jobsearch') ?></a>
                                                <?php
                                                $popup_args = array('p_job_id' => $_job_id, 'cand_id' => $_candidate_id, 'p_emp_id' => $employer_id, 'p_masg_rand' => $send_message_form_rand);
                                                add_action('wp_footer', function () use ($popup_args) {

                                                    extract(shortcode_atts(array(
                                                        'p_job_id' => '',
                                                        'p_emp_id' => '',
                                                        'cand_id' => '',
                                                        'p_masg_rand' => ''
                                                    ), $popup_args));
                                                    ?>
                                                    <div class="jobsearch-modal fade"
                                                         id="JobSearchModalSendEmail<?php echo($p_masg_rand) ?>">
                                                        <div class="modal-inner-area">&nbsp;</div>
                                                        <div class="modal-content-area">
                                                            <div class="modal-box-area">
                                                                        <span class="modal-close"><i class="fa fa-times"></i></span>
                                                                <div class="jobsearch-send-message-form">
                                                                    <form autocomplete="off" method="post"
                                                                          id="jobsearch_send_email_form<?php echo esc_html($p_masg_rand); ?>">
                                                                        <div class="jobsearch-user-form">
                                                                            <ul class="email-fields-list">
                                                                                <li>
                                                                                    <label>
                                                                                        <?php echo esc_html__('Subject', 'wp-jobsearch'); ?>
                                                                                        :
                                                                                    </label>
                                                                                    <div class="input-field">
                                                                                        <input type="text"
                                                                                               name="send_message_subject"
                                                                                               value=""/>
                                                                                    </div>
                                                                                </li>
                                                                                <li>
                                                                                    <label>
                                                                                        <?php echo esc_html__('Message', 'wp-jobsearch'); ?>
                                                                                        :
                                                                                    </label>
                                                                                    <div class="input-field">
                                                                                                <textarea
                                                                                                        name="send_message_content"></textarea>
                                                                                    </div>
                                                                                </li>
                                                                                <li>
                                                                                    <div class="input-field-submit">
                                                                                        <input type="submit"
                                                                                               class="applicantto-email-submit-btn"
                                                                                               data-jid="<?php echo absint($p_job_id); ?>"
                                                                                               data-eid="<?php echo absint($p_emp_id); ?>"
                                                                                               data-cid="<?php echo absint($cand_id); ?>"
                                                                                               data-randid="<?php echo esc_html($p_masg_rand); ?>"
                                                                                               name="send_message_content"
                                                                                               value="<?php echo esc_html__('Send', 'wp-jobsearch') ?>"/>
                                                                                        <span class="loader-box loader-box-<?php echo esc_html($p_masg_rand); ?>"></span>
                                                                                    </div>
                                                                                    <?php jobsearch_terms_and_con_link_txt(); ?>
                                                                                </li>
                                                                            </ul>
                                                                            <div class="message-box message-box-<?php echo esc_html($p_masg_rand); ?>"
                                                                                 style="display:none;"></div>
                                                                        </div>
                                                                    </form>
                                                                </div>

                                                            </div>
                                                        </div>
                                                    </div>
                                                    <?php
                                                }, 11, 1);
                                                ?>
                                            </li>
                                            <?php if (in_array($_candidate_id, $job_reject_int_list)) { ?>
                                                <li>
                                                    <a href="javascript:void(0);"
                                                       class="undoreject-cand-to-list ajax-enable"
                                                       data-jid="<?php echo absint($job_id); ?>"
                                                       data-cid="<?php echo absint($_candidate_id); ?>"><?php esc_html_e('Undo Reject', 'wp-jobsearch') ?>
                                                        <span class="app-loader"></span></a>
                                                </li>
                                            <?php } else { ?>
                                                <li>
                                                    <?php if (in_array($_candidate_id, $job_short_int_list)) { ?>
                                                        <a href="javascript:void(0);"
                                                           class="shortlist-cand-to-intrview"><?php esc_html_e('Shortlisted', 'wp-jobsearch') ?></a>
                                                    <?php } else { ?>
                                                        <a href="javascript:void(0);"
                                                           class="shortlist-cand-to-intrview ajax-enable"
                                                           data-jid="<?php echo absint($job_id); ?>"
                                                           data-cid="<?php echo absint($_candidate_id); ?>"><?php esc_html_e('Shortlist for Interview', 'wp-jobsearch') ?>
                                                            <span class="app-loader"></span></a>
                                                    <?php } ?>
                                                </li>
                                                <li>
                                                    <?php
                                                    if (in_array($_candidate_id, $job_reject_int_list)) {
                                                        ?>
                                                        <a href="javascript:void(0);"
                                                           class="reject-cand-to-intrview"><?php esc_html_e('Rejected', 'wp-jobsearch') ?></a>
                                                        <?php
                                                    } else {
                                                        ?>
                                                        <a href="javascript:void(0);"
                                                           class="reject-cand-to-intrview ajax-enable"
                                                           data-jid="<?php echo absint($job_id); ?>"
                                                           data-cid="<?php echo absint($_candidate_id); ?>"><?php esc_html_e('Reject', 'wp-jobsearch') ?>
                                                            <span class="app-loader"></span></a>
                                                        <?php
                                                    }
                                                    ?>
                                                </li>
                                                <?php
                                            }
                                            ?>
                                            <li>
                                                <a href="javascript:void(0);"
                                                   class="delete-cand-from-job ajax-enable"
                                                   data-jid="<?php echo absint($job_id); ?>"
                                                   data-cid="<?php echo absint($_candidate_id); ?>"><?php esc_html_e('Delete', 'wp-jobsearch') ?>
                                                    <span class="app-loader"></span></a>
                                            </li>
                                        </ul>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </li>
            <?php
            $popup_args = array(
                'job_id' => $job_id,
                'rand_num' => $send_message_form_rand,
                'candidate_id' => $_candidate_id,
            );
            add_action('wp_footer', function () use ($popup_args) {

                global $jobsearch_plugin_options;

                extract(shortcode_atts(array(
                    'job_id' => '',
                    'rand_num' => '',
                    'candidate_id' => '',
                ), $popup_args));

                $job_cver_ltrs = get_post_meta($job_id, 'jobsearch_job_apply_cvrs', true);
                if (isset($job_cver_ltrs[$candidate_id]) && $job_cver_ltrs[$candidate_id] != '') {
                    ?>
                    <div class="jobsearch-modal jobsearch-typo-wrap jobsearch-candcover-popup fade"
                         id="JobSearchCandCovershwModal<?php echo($rand_num) ?>">
                        <div class="modal-inner-area">&nbsp;</div>
                        <div class="modal-content-area">
                            <div class="modal-box-area">
                                <div class="jobsearch-modal-title-box">
                                    <h2><?php esc_html_e('Cover Letter', 'wp-jobsearch') ?></h2>
                                    <span class="modal-close"><i class="fa fa-times"></i></span>
                                </div>
                                <p><?php echo($job_cver_ltrs[$candidate_id]) ?></p>
                            </div>
                        </div>
                    </div>
                    <?php
                }
            }, 11, 1);
        }
    }
    wp_die();
}

function jobsearch_front_search_location_suggestion_input($map_type, $location_val, $citystat_zip_title, $field_name = 'location', $backend = false) {
    global $jobsearch_plugin_options;
    
    $hook_name = 'wp_footer';
    if ($backend == true) {
        $hook_name = 'admin_footer';
    }
    $citystat_zip_title = $citystat_zip_title == '' ? esc_html__('Location', 'wp-jobsearch') : $citystat_zip_title;
    if ($map_type == 'mapbox') {
        $geo_rand_id = rand(1000000, 9999999);
        
        $mapbox_access_token = isset($jobsearch_plugin_options['mapbox_access_token']) ? $jobsearch_plugin_options['mapbox_access_token'] : '';
        $mapbox_style_url = isset($jobsearch_plugin_options['mapbox_style_url']) ? $jobsearch_plugin_options['mapbox_style_url'] : '';
        
        if ($mapbox_access_token != '' && $mapbox_style_url != '') {
            //add_action($hook_name, function() use ($geo_rand_id, $location_val, $citystat_zip_title) {
                global $jobsearch_plugin_options;
                $autocomplete_adres_type = isset($jobsearch_plugin_options['autocomplete_adres_type']) ? $jobsearch_plugin_options['autocomplete_adres_type'] : '';
                $autocomplete_countries_json = '';
                $autocomplete_countries = isset($jobsearch_plugin_options['restrict_contries_locsugg']) ? $jobsearch_plugin_options['restrict_contries_locsugg'] : '';
                if (!empty($autocomplete_countries) && is_array($autocomplete_countries)) {
                    $autocomplete_countries_json = json_encode($autocomplete_countries);
                }
                $mapbox_access_token = isset($jobsearch_plugin_options['mapbox_access_token']) ? $jobsearch_plugin_options['mapbox_access_token'] : '';
                $mapbox_style_url = isset($jobsearch_plugin_options['mapbox_style_url']) ? $jobsearch_plugin_options['mapbox_style_url'] : '';
                ?>
                <script>
                    <?php
                    if (isset($_POST['action']) && ($_POST['action'] == 'jobsearch_jobs_content' || $_POST['action'] == 'jobsearch_employers_content' || $_POST['action'] == 'jobsearch_candidates_content')) {
                        //
                    } else {
                        ?>
                        jQuery(document).ready(function() {
                        <?php
                    }
                    ?>
                    var check_webgl_comp = jobsearch_check_webgl_compatibility();
                    if (check_webgl_comp) {
                        jQuery('body').append('<div id="jobsearch-bodymapbox-genmap-<?php echo ($geo_rand_id) ?>" style="height:0;display:none;"></div>');
                        mapboxgl.accessToken = '<?php echo ($mapbox_access_token) ?>';
                        var cityAcMap = new mapboxgl.Map({
                            container: 'jobsearch-bodymapbox-genmap-<?php echo ($geo_rand_id) ?>',
                            style: '<?php echo ($mapbox_style_url) ?>',
                            center: [-96, 37.8],
                            scrollZoom: false,
                            zoom: 3
                        });
                        var geocodParams = {
                            accessToken: mapboxgl.accessToken,
                            marker: false,
                            flyTo: false,
                            mapboxgl: mapboxgl,
                            placeholder: '<?php echo ($citystat_zip_title) ?>'
                        };
                        var selected_contries = '<?php echo ($autocomplete_countries_json) ?>';
                        if (selected_contries != '') {
                            var selected_contries_tojs = jQuery.parseJSON(selected_contries);
                            var sel_countries_str = selected_contries_tojs.join();
                            geocodParams['countries'] = sel_countries_str;
                        }
                        var mapboxGeocoder<?php echo($geo_rand_id) ?> = new MapboxGeocoder(geocodParams);
                        document.getElementById('jobsearch-bodymapbox-gensbox-<?php echo ($geo_rand_id) ?>').appendChild(mapboxGeocoder<?php echo($geo_rand_id) ?>.onAdd(cityAcMap));
                        mapboxGeocoder<?php echo($geo_rand_id) ?>.setInput('<?php echo urldecode($location_val) ?>');

                        mapboxGeocoder<?php echo($geo_rand_id) ?>.on('result', function(obj) {
                            var place_name = obj.result.place_name;
                            jQuery('#lochiden_addr_<?php echo($geo_rand_id) ?>').val(place_name);
                        });
                        jQuery(document).on('change', '#jobsearch-bodymapbox-gensbox-<?php echo ($geo_rand_id) ?> input[type=text]', function() {
                            var this_input_val = jQuery(this).val();
                            jQuery('#lochiden_addr_<?php echo ($geo_rand_id) ?>').val(this_input_val);
                        });
                    } else {
                        document.getElementById('jobsearch-bodymapbox-gensbox-<?php echo ($geo_rand_id) ?>').innerHTML = '<input placeholder="<?php esc_html_e('City, State or ZIP', 'wp-jobsearch') ?>" class="srch_autogeo_location" name="location" type="text" value="<?php echo urldecode($location_val) ?>">';
                        console.log('Failed to initialize WebGL.');
                    }
                    <?php
                    if (isset($_POST['action']) && ($_POST['action'] == 'jobsearch_jobs_content' || $_POST['action'] == 'jobsearch_employers_content' || $_POST['action'] == 'jobsearch_candidates_content')) {
                        //
                    } else {
                        ?>
                        });
                        <?php
                    }
                    ?>
                </script>
                <?php
            //}, 999, 3);
            ?>
            <div id="jobsearch-bodymapbox-gensbox-<?php echo ($geo_rand_id) ?>"></div>
            <input id="lochiden_addr_<?php echo($geo_rand_id) ?>" type="hidden" name="<?php echo ($field_name) ?>" value="<?php echo urldecode($location_val) ?>">
            <?php
        } else {
            ?>
            <input placeholder="<?php esc_html_e('City, State or ZIP', 'wp-jobsearch') ?>" class="srch_autogeo_location" name="location" type="text" value="<?php echo urldecode($location_val) ?>">
            <?php
        }
    } else if ($map_type == 'openstreet') {
        $geo_rand_id = rand(1000000, 9999999);
        ?>
        <input id="location-address-<?php echo($geo_rand_id) ?>" class="jobsearch_search_location_field" placeholder="<?php echo apply_filters('jobsearch_listin_serchbox_location_title', $citystat_zip_title) ?>"
           name="<?php echo ($field_name) ?>"
           value="<?php echo urldecode($location_val) ?>"
           type="text">
        <?php
    } else if ($map_type == 'google') {
        $geo_rand_id = rand(1000000, 9999999);
        ?>
        <input id="location-address-<?php echo($geo_rand_id) ?>" class="jobsearch_search_location_field" placeholder="<?php echo apply_filters('jobsearch_listin_serchbox_location_title', $citystat_zip_title) ?>"
           name="<?php echo ($field_name) ?>"
           value="<?php echo urldecode($location_val) ?>"
           type="text">
        <?php
    }
}

add_action('wp_ajax_jobsearch_get_shortlisted_cands', 'jobsearch_get_shortlisted_cands');
add_action('wp_ajax_nopriv_jobsearch_get_shortlisted_cands', 'jobsearch_get_shortlisted_cands');

function jobsearch_get_shortlisted_cands()
{
    global $jobsearch_plugin_options;
    $nonce_val = sanitize_key(wp_unslash($_POST['_nonce']));
    if (!wp_verify_nonce($nonce_val, 'jobsearch_ajax_nonce')) {
        wp_send_json(array('html' => ''));
    }
    $job_id = isset($_POST['job_id']) ? $_POST['job_id'] : '';

    $is_emp_job = jobsearch_is_employer_job($job_id);
    if (!$is_emp_job) {
        wp_send_json(array('msg' => esc_html__('You are not allowed to do this.', 'wp-jobsearch'), 'error' => '1'));
    }
    
    $employer_id = isset($_POST['employer_id']) ? $_POST['employer_id'] : '';
    $apps_start = isset($_POST['apps_start']) ? $_POST['apps_start'] : 0;

    $viewed_candidates = get_post_meta($job_id, 'jobsearch_viewed_candidates', true);
    $job_applicants_list = get_post_meta($job_id, '_job_short_interview_list', true);

    $job_applicants_list = explode(',', $job_applicants_list);

    $apps_offset = 6;
    if ($apps_start > 0) {
        $apps_start = ($apps_start - 1) * ($apps_offset);
    }
    $job_applicants_list = array_slice($job_applicants_list, $apps_start, $apps_offset);
    ob_start();
    if (!empty($job_applicants_list)) {

        foreach ($job_applicants_list as $_candidate_id) {

            $candidate_user_id = jobsearch_get_candidate_user_id($_candidate_id);
            if (absint($candidate_user_id) <= 0) {
                continue;
            }
            $candidate_user_obj = get_user_by('ID', $candidate_user_id);
            $user_def_avatar_url = jobsearch_candidate_img_url_comn($_candidate_id);

            $candidate_jobtitle = get_post_meta($_candidate_id, 'jobsearch_field_candidate_jobtitle', true);
            $get_candidate_location = get_post_meta($_candidate_id, 'jobsearch_field_location_address', true);

            $job_short_int_list = get_post_meta($job_id, '_job_short_interview_list', true);
            $job_short_int_list = $job_short_int_list != '' ? explode(',', $job_short_int_list) : '';
            if (empty($job_short_int_list)) {
                $job_short_int_list = array();
            }
            $job_short_int_list = jobsearch_is_post_ids_array($job_short_int_list, 'candidate');


            $job_reject_int_list = get_post_meta($job_id, '_job_reject_interview_list', true);
            $job_reject_int_list = $job_reject_int_list != '' ? explode(',', $job_reject_int_list) : '';
            if (empty($job_reject_int_list)) {
                $job_reject_int_list = array();
            }
            $job_reject_int_list = jobsearch_is_post_ids_array($job_reject_int_list, 'candidate');

            $candidate_city_title = '';
            $get_candidate_city = get_post_meta($_candidate_id, 'jobsearch_field_location_location3', true);
            if ($get_candidate_city == '') {
                $get_candidate_city = get_post_meta($_candidate_id, 'jobsearch_field_location_location2', true);
            }
            if ($get_candidate_city == '') {
                $get_candidate_city = get_post_meta($_candidate_id, 'jobsearch_field_location_location1', true);
            }

            $candidate_city_tax = $get_candidate_city != '' ? get_term_by('slug', $get_candidate_city, 'job-location') : '';
            if (is_object($candidate_city_tax)) {
                $candidate_city_title = $candidate_city_tax->name;
            }

            $sectors = wp_get_post_terms($_candidate_id, 'sector');
            $candidate_sector = isset($sectors[0]->name) ? $sectors[0]->name : '';
            $candidate_salary = jobsearch_candidate_current_salary($_candidate_id);
            $candidate_age = jobsearch_candidate_age($_candidate_id);
            $candidate_phone = get_post_meta($_candidate_id, 'jobsearch_field_user_phone', true);
            $job_cver_ltrs = get_post_meta($job_id, 'jobsearch_job_apply_cvrs', true);
            $send_message_form_rand = rand(100000, 999999);
            $applicant_status = jobsearch_get_applicant_status_tarr($_candidate_id, $job_id);
            $candidate_status = get_post_meta($_candidate_id, 'jobsearch_field_candidate_approved', true);
            ?>
            <li class="jobsearch-column-12<?php echo ((isset($applicant_status['status']) && $applicant_status['status'] == 'pending') || $candidate_status != 'on' ? ' applicant-status-pending' : '') ?>">
                <script>
                    jQuery(document).on('click', '.jobsearch-modelemail-btn-<?php echo($send_message_form_rand) ?>', function () {
                        jobsearch_modal_popup_open('JobSearchModalSendEmailComm');
                        jQuery('#JobSearchModalSendEmailComm').find('form').attr('id', 'jobsearch_send_email_form<?php echo($send_message_form_rand) ?>');
                        jQuery('#JobSearchModalSendEmailComm').find('.loader-box').attr('class', 'loader-box loader-box-<?php echo($send_message_form_rand) ?>');
                        jQuery('#JobSearchModalSendEmailComm').find('.message-box').attr('class', 'message-box message-box-<?php echo($send_message_form_rand) ?>');
                        jQuery('#JobSearchModalSendEmailComm').find('.input-field-submit').find('input[type=submit]').attr('data-randid', '<?php echo($send_message_form_rand) ?>');
                        jQuery('#JobSearchModalSendEmailComm').find('.input-field-submit').find('input[type=submit]').attr('data-jid', '<?php echo($job_id) ?>');
                        jQuery('#JobSearchModalSendEmailComm').find('.input-field-submit').find('input[type=submit]').attr('data-cid', '<?php echo($_candidate_id) ?>');
                        jQuery('#JobSearchModalSendEmailComm').find('.input-field-submit').find('input[type=submit]').attr('data-eid', '<?php echo($employer_id) ?>');
                    });
                    jQuery(document).on('click', '.jobsearch-modelcvrltr-btn-<?php echo($send_message_form_rand) ?>', function () {
                        jobsearch_modal_popup_open('JobSearchCandCovershwModal<?php echo($send_message_form_rand) ?>');
                    });
                </script>
                <div class="jobsearch-applied-jobs-wrap">
                    <?php
                    $cand_is_pending = false;
                    if ($candidate_status != 'on') {
                        $cand_is_pending = true;
                        echo jobsearch_applicant_cand_profile_notaprov_txt();
                    } else if (isset($applicant_status['status']) && $applicant_status['status'] == 'pending') {
                        $cand_is_pending = true;
                        echo jobsearch_applicant_pend_profile_review_txt();
                    }
                    ?>
                    <a class="jobsearch-applied-jobs-thumb">
                        <?php
                        if (!$cand_is_pending) {
                            echo do_action('jobsearch_export_selection_emp', $_candidate_id, $job_id);
                        }
                        ?>
                        <img src="<?php echo($user_def_avatar_url) ?>" alt="">
                    </a>
                    <div class="jobsearch-applied-jobs-text">
                        <div class="jobsearch-applied-jobs-left">
                            <?php
                            $user_apply_data = get_user_meta($candidate_user_id, 'jobsearch-user-jobs-applied-list', true);
                            $aply_date_time = '';
                            if (!empty($user_apply_data)) {
                                $user_apply_key = array_search($job_id, array_column($user_apply_data, 'post_id'));
                                $aply_date_time = isset($user_apply_data[$user_apply_key]['date_time']) ? $user_apply_data[$user_apply_key]['date_time'] : '';
                            }
                            if ($candidate_jobtitle != '') { ?>
                                <span> <?php echo apply_filters('jobsearch_cand_jobtitle_indisplay', $candidate_jobtitle, $_candidate_id) ?></span>
                                <?php
                            }

                            if (in_array($_candidate_id, $viewed_candidates)) { ?>
                                <small class="profile-view viewed"><?php esc_html_e('(Viewed)', 'wp-jobsearch') ?></small>
                            <?php } else { ?>
                                <small class="profile-view unviewed"><?php esc_html_e('(Unviewed)', 'wp-jobsearch') ?></small>
                                <?php
                            }
                            $user_email_adr = isset($candidate_user_obj->user_email) ? $candidate_user_obj->user_email : '';
                            ?>
                            <a href="javascript:void(0);"
                               class="jobsearch-modelemail-btn-<?php echo($send_message_form_rand) ?> jobsearch-user-email">
                                <small> <?php printf(esc_html__('Email: %s', 'wp-jobsearch'), $user_email_adr) ?></small>
                            </a>
                            <small class="profile-view viewed"><?php esc_html_e('(Shortlisted)', 'wp-jobsearch') ?></small>
                            <?php

                            apply_filters('Jobsearch_Cand_shortlisted_View', $_candidate_id, $job_short_int_list);

                            echo apply_filters('jobsearch_applicants_list_before_title', '', $_candidate_id, $job_id);
                            ?>
                            <h2 class="jobsearch-pst-title">
                                <a href="<?php echo add_query_arg(array('job_id' => $job_id, 'employer_id' => $employer_id, 'action' => 'preview_profile'), get_permalink($_candidate_id)) ?>"><?php echo get_the_title($_candidate_id) ?></a>
                                <?php if ($candidate_age != '') { ?>
                                    <small><?php echo apply_filters('jobsearch_dash_applicants_age_html', sprintf(esc_html__('(Age: %s years)', 'wp-jobsearch'), $candidate_age)) ?></small>
                                    <?php
                                }
                                if ($candidate_phone != '') { ?>
                                    <small><?php printf(esc_html__('Phone: %s', 'wp-jobsearch'), $candidate_phone) ?></small>
                                <?php } ?>
                            </h2>
                            <ul>
                                <?php
                                if ($aply_date_time > 0) {
                                    ?>
                                    <li>
                                        <i class="jobsearch-icon jobsearch-calendar"></i> <?php printf(esc_html__('Applied at: %s', 'wp-jobsearch'), (date_i18n(get_option('date_format'), $aply_date_time) . ' ' . date_i18n(get_option('time_format'), $aply_date_time))) ?>
                                    </li>
                                    <?php
                                }
                                if ($candidate_salary != '') {
                                    ?>
                                    <li>
                                        <i class="fa fa-money"></i> <?php printf(esc_html__('Salary: %s', 'wp-jobsearch'), $candidate_salary) ?>
                                    </li>
                                    <?php
                                }
                                if ($candidate_city_title != '') {
                                    ?>
                                    <li><i class="jobsearch-icon jobsearch-maps-and-flags"></i> <?php echo($candidate_city_title) ?>
                                    </li>
                                    <?php
                                }
                                if ($candidate_sector != '') {
                                    ?>
                                    <li><i class="jobsearch-icon jobsearch-filter-tool-black-shape"></i>
                                        <a><?php echo($candidate_sector) ?></a></li>
                                    <?php
                                }
                                ?>
                            </ul>
                        </div>
                        <div class="jobsearch-applied-job-btns">
                            <?php
                            echo apply_filters('employer_dash_apps_acts_listul_after', '', $_candidate_id, $job_id);
                            ?>
                            <ul>
                                <li>
                                    <a href="<?php echo add_query_arg(array('job_id' => $job_id, 'employer_id' => $employer_id, 'action' => 'preview_profile'), get_permalink($_candidate_id)) ?>"
                                       class="preview-candidate-profile"><i
                                                class="fa fa-eye"></i> <?php esc_html_e('Preview', 'wp-jobsearch') ?>
                                    </a>
                                </li>
                                <li>
                                    <div class="candidate-more-acts-con">
                                        <a href="javascript:void(0);"
                                           class="more-actions"><?php esc_html_e('Actions', 'wp-jobsearch') ?>
                                            <i class="fa fa-angle-down"></i></a>
                                        <ul>
                                            <?php
                                            $multiple_cv_files_allow = isset($jobsearch_plugin_options['multiple_cv_uploads']) ? $jobsearch_plugin_options['multiple_cv_uploads'] : '';
                                            $candidate_cv_file = get_post_meta($_candidate_id, 'candidate_cv_file', true);

                                            if ($multiple_cv_files_allow == 'on') {
                                                $ca_at_cv_files = get_post_meta($_candidate_id, 'candidate_cv_files', true);
                                                if (!empty($ca_at_cv_files)) {
                                                    ?>
                                                    <li>
                                                        <a href="<?php echo apply_filters('jobsearch_user_attach_cv_file_url', '', $_candidate_id, $job_id) ?>"
                                                           oncontextmenu="javascript: return false;"
                                                           onclick="javascript: if ((event.button == 0 && event.ctrlKey)) {return false};"
                                                           download="<?php echo apply_filters('jobsearch_user_attach_cv_file_title', '', $_candidate_id, $job_id) ?>"><?php esc_html_e('Download CV', 'wp-jobsearch') ?></a>
                                                    </li>
                                                    <?php
                                                }
                                            } else if (!empty($candidate_cv_file)) {
                                                $file_attach_id = isset($candidate_cv_file['file_id']) ? $candidate_cv_file['file_id'] : '';
                                                $file_url = isset($candidate_cv_file['file_url']) ? $candidate_cv_file['file_url'] : '';

                                                $filename = isset($candidate_cv_file['file_name']) ? $candidate_cv_file['file_name'] : '';

                                                $file_url = apply_filters('wp_jobsearch_user_cvfile_downlod_url', $file_url, $file_attach_id, $_candidate_id);
                                                ?>
                                                <li><a href="<?php echo($file_url) ?>"
                                                       oncontextmenu="javascript: return false;"
                                                       onclick="javascript: if ((event.button == 0 && event.ctrlKey)) {return false};"
                                                       download="<?php echo($filename) ?>"><?php esc_html_e('Download CV', 'wp-jobsearch') ?></a>
                                                </li>
                                                <?php
                                            }
                                            echo apply_filters('employer_dash_apps_acts_list_after_download_link', '', $_candidate_id, $job_id);

                                            //
                                            if (isset($job_cver_ltrs[$_candidate_id]) && $job_cver_ltrs[$_candidate_id] != '') {
                                                ?>
                                                <li><a href="javascript:void(0);"
                                                       class="jobsearch-modelcvrltr-btn-<?php echo($send_message_form_rand) ?>"><?php esc_html_e('View Cover Letter', 'wp-jobsearch') ?></a>
                                                </li>
                                                <?php
                                            }
                                            ?>
                                            <li>
                                                <a href="javascript:void(0);"
                                                   class="jobsearch-modelemail-btn-<?php echo($send_message_form_rand) ?>"><?php esc_html_e('Email to Candidate', 'wp-jobsearch') ?></a>
                                                <?php
                                                $popup_args = array('p_job_id' => $_job_id, 'cand_id' => $_candidate_id, 'p_emp_id' => $employer_id, 'p_masg_rand' => $send_message_form_rand);
                                                add_action('wp_footer', function () use ($popup_args) {

                                                    extract(shortcode_atts(array(
                                                        'p_job_id' => '',
                                                        'p_emp_id' => '',
                                                        'cand_id' => '',
                                                        'p_masg_rand' => ''
                                                    ), $popup_args));
                                                    ?>
                                                    <div class="jobsearch-modal fade"
                                                         id="JobSearchModalSendEmail<?php echo($p_masg_rand) ?>">
                                                        <div class="modal-inner-area">&nbsp;</div>
                                                        <div class="modal-content-area">
                                                            <div class="modal-box-area">
                                                                        <span class="modal-close"><i
                                                                                    class="fa fa-times"></i></span>
                                                                <div class="jobsearch-send-message-form">
                                                                    <form autocomplete="off" method="post"
                                                                          id="jobsearch_send_email_form<?php echo esc_html($p_masg_rand); ?>">
                                                                        <div class="jobsearch-user-form">
                                                                            <ul class="email-fields-list">
                                                                                <li>
                                                                                    <label>
                                                                                        <?php echo esc_html__('Subject', 'wp-jobsearch'); ?>
                                                                                        :
                                                                                    </label>
                                                                                    <div class="input-field">
                                                                                        <input type="text"
                                                                                               name="send_message_subject"
                                                                                               value=""/>
                                                                                    </div>
                                                                                </li>
                                                                                <li>
                                                                                    <label>
                                                                                        <?php echo esc_html__('Message', 'wp-jobsearch'); ?>
                                                                                        :
                                                                                    </label>
                                                                                    <div class="input-field">
                                                                                                <textarea
                                                                                                        name="send_message_content"></textarea>
                                                                                    </div>
                                                                                </li>
                                                                                <li>
                                                                                    <div class="input-field-submit">
                                                                                        <input type="submit"
                                                                                               class="applicantto-email-submit-btn"
                                                                                               data-jid="<?php echo absint($p_job_id); ?>"
                                                                                               data-eid="<?php echo absint($p_emp_id); ?>"
                                                                                               data-cid="<?php echo absint($cand_id); ?>"
                                                                                               data-randid="<?php echo esc_html($p_masg_rand); ?>"
                                                                                               name="send_message_content"
                                                                                               value="<?php echo esc_html__('Send', 'wp-jobsearch') ?>"/>
                                                                                        <span class="loader-box loader-box-<?php echo esc_html($p_masg_rand); ?>"></span>
                                                                                    </div>
                                                                                    <?php jobsearch_terms_and_con_link_txt(); ?>
                                                                                </li>
                                                                            </ul>
                                                                            <div class="message-box message-box-<?php echo esc_html($p_masg_rand); ?>"
                                                                                 style="display:none;"></div>
                                                                        </div>
                                                                    </form>
                                                                </div>

                                                            </div>
                                                        </div>
                                                    </div>
                                                    <?php
                                                }, 11, 1);
                                                ?>
                                            </li>
                                            <?php if (in_array($_candidate_id, $job_reject_int_list)) { ?>
                                                <li>
                                                    <a href="javascript:void(0);"
                                                       class="undoreject-cand-to-list ajax-enable"
                                                       data-jid="<?php echo absint($job_id); ?>"
                                                       data-cid="<?php echo absint($_candidate_id); ?>"><?php esc_html_e('Undo Reject', 'wp-jobsearch') ?>
                                                        <span class="app-loader"></span></a>
                                                </li>
                                            <?php } else { ?>
                                                <li>
                                                    <?php if (in_array($_candidate_id, $job_short_int_list)) { ?>
                                                        <a href="javascript:void(0);"
                                                           class="shortlist-cand-to-intrview"><?php esc_html_e('Shortlisted', 'wp-jobsearch') ?></a>
                                                    <?php } else { ?>
                                                        <a href="javascript:void(0);"
                                                           class="shortlist-cand-to-intrview ajax-enable"
                                                           data-jid="<?php echo absint($job_id); ?>"
                                                           data-cid="<?php echo absint($_candidate_id); ?>"><?php esc_html_e('Shortlist for Interview', 'wp-jobsearch') ?>
                                                            <span class="app-loader"></span></a>
                                                    <?php } ?>
                                                </li>
                                                <li>
                                                    <?php
                                                    if (in_array($_candidate_id, $job_reject_int_list)) {
                                                        ?>
                                                        <a href="javascript:void(0);"
                                                           class="reject-cand-to-intrview"><?php esc_html_e('Rejected', 'wp-jobsearch') ?></a>
                                                        <?php
                                                    } else {
                                                        ?>
                                                        <a href="javascript:void(0);"
                                                           class="reject-cand-to-intrview ajax-enable"
                                                           data-jid="<?php echo absint($job_id); ?>"
                                                           data-cid="<?php echo absint($_candidate_id); ?>"><?php esc_html_e('Reject', 'wp-jobsearch') ?>
                                                            <span class="app-loader"></span></a>
                                                        <?php
                                                    }
                                                    ?>
                                                </li>
                                                <?php
                                            }
                                            ?>
                                            <li>
                                                <a href="javascript:void(0);"
                                                   class="delete-cand-from-job ajax-enable"
                                                   data-jid="<?php echo absint($job_id); ?>"
                                                   data-cid="<?php echo absint($_candidate_id); ?>"><?php esc_html_e('Delete', 'wp-jobsearch') ?>
                                                    <span class="app-loader"></span></a>
                                            </li>
                                        </ul>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </li>
            <?php


            $job_cver_ltrs = get_post_meta($job_id, 'jobsearch_job_apply_cvrs', true);
            if (isset($job_cver_ltrs[$_candidate_id]) && $job_cver_ltrs[$_candidate_id] != '') {
                ?>
                <div class="jobsearch-modal jobsearch-typo-wrap jobsearch-candcover-popup fade"
                     id="JobSearchCandCovershwModal<?php echo($send_message_form_rand) ?>">
                    <div class="modal-inner-area">&nbsp;</div>
                    <div class="modal-content-area">
                        <div class="modal-box-area">
                            <div class="jobsearch-modal-title-box">
                                <h2><?php esc_html_e('Cover Letter', 'wp-jobsearch') ?></h2>
                                <span class="modal-close"><i class="fa fa-times"></i></span>
                            </div>
                            <p><?php echo($job_cver_ltrs[$_candidate_id]) ?></p>
                        </div>
                    </div>
                </div>
                <?php
            }
        }
    }

    $html = ob_get_clean();
    echo json_encode(array('html' => $html));
    wp_die();
}

add_action('wp_ajax_jobsearch_act_user_cvbk_delete', 'jobsearch_action_user_cvbk_delete');

function jobsearch_action_user_cvbk_delete() {
    
    global $jobsearch_plugin_options;
    $nonce_val = sanitize_key(wp_unslash($_POST['_nonce']));
    if (!wp_verify_nonce($nonce_val, 'jobsearch_ajax_nonce')) {
        $msg = esc_html__('You are not allowed to do this.', 'wp-jobsearch');
        echo json_encode(array('msg' => $msg, 'error' => '1'));
        die;
    }

    $user_id = get_current_user_id();
    //$candidate_id = jobsearch_get_user_candidate_id($user_id);
    $candidate_id = isset($_POST['user_id']) ? $_POST['user_id'] : '';
    if (!$candidate_id || !current_user_can('administrator')) {
        $msg = esc_html__('You are not allowed to do this.', 'wp-jobsearch');
        echo json_encode(array('msg' => $msg, 'error' => '1'));
        die;
    }
    
    $multiple_cv_files_allow = isset($jobsearch_plugin_options['multiple_cv_uploads']) ? $jobsearch_plugin_options['multiple_cv_uploads'] : '';
    
    if ($multiple_cv_files_allow == 'on') {
        $attach_id = isset($_POST['attach_id']) ? $_POST['attach_id'] : '';
        $ca_at_cv_files = get_post_meta($candidate_id, 'candidate_cv_files', true);
        $ca_jat_cv_files = get_post_meta($candidate_id, 'jobsearch_field_user_cv_attachments', true);
        $ca_at_cv_files = !empty($ca_at_cv_files) ? $ca_at_cv_files : array();
        $ca_jat_cv_files = !empty($ca_jat_cv_files) ? $ca_jat_cv_files : array();

        $newca_atcv_files = array();
        if (!empty($ca_at_cv_files)) {
            foreach ($ca_at_cv_files as $ca_atcv_file) {
                if ($ca_atcv_file['file_id'] != $attach_id) {
                    $newca_atcv_files[] = $ca_atcv_file;
                }
            }
        }

        $newca_jatcv_files = array();
        if (!empty($ca_jat_cv_files)) {
            foreach ($ca_jat_cv_files as $ca_jatcv_file) {
                if ($ca_jatcv_file['file_id'] != $attach_id) {
                    $newca_jatcv_files[] = $ca_jatcv_file;
                }
            }
        }

        update_post_meta($candidate_id, 'candidate_cv_files', $newca_atcv_files);

        update_post_meta($candidate_id, 'jobsearch_field_user_cv_attachments', $newca_jatcv_files);

    } else {

        update_post_meta($candidate_id, 'candidate_cv_file', '');
        update_post_meta($candidate_id, 'jobsearch_field_user_cv_attachment', '');
    }

    echo json_encode(array('delete' => '1'));
    
    die;
}

add_action('wp_ajax_jobsearch_get_rejected_cands', 'jobsearch_get_rejected_cands');
add_action('wp_ajax_nopriv_jobsearch_get_rejected_cands', 'jobsearch_get_rejected_cands');

function jobsearch_get_rejected_cands()
{
    global $jobsearch_plugin_options;
    $nonce_val = sanitize_key(wp_unslash($_POST['_nonce']));
    if (!wp_verify_nonce($nonce_val, 'jobsearch_ajax_nonce')) {
        $msg = esc_html__('You are not allowed to do this.', 'wp-jobsearch');
        echo json_encode(array('msg' => $msg, 'error' => '1'));
        die;
    }
    $nonce_val = sanitize_key(wp_unslash($_POST['_nonce']));
    if (!wp_verify_nonce($nonce_val, 'jobsearch_ajax_nonce')) {
        $msg = esc_html__('You are not allowed to do this.', 'wp-jobsearch');
        echo json_encode(array('msg' => $msg, 'error' => '1'));
        die;
    }
    $job_id = isset($_POST['job_id']) ? $_POST['job_id'] : '';
    $employer_id = isset($_POST['employer_id']) ? $_POST['employer_id'] : '';
    $apps_start = isset($_POST['apps_start']) ? $_POST['apps_start'] : 0;

    $viewed_candidates = get_post_meta($job_id, 'jobsearch_viewed_candidates', true);
    $job_applicants_list = get_post_meta($job_id, '_job_reject_interview_list', true);
    $job_applicants_list = explode(',', $job_applicants_list);

    $apps_offset = 6;
    if ($apps_start > 0) {
        $apps_start = ($apps_start - 1) * ($apps_offset);
    }

    $job_applicants_list = array_slice($job_applicants_list, $apps_start, $apps_offset);
    ob_start();
    if (!empty($job_applicants_list)) {
        foreach ($job_applicants_list as $_candidate_id) {
            $candidate_user_id = jobsearch_get_candidate_user_id($_candidate_id);
            if (absint($candidate_user_id) <= 0) {
                continue;
            }
            $candidate_user_obj = get_user_by('ID', $candidate_user_id);
            $user_def_avatar_url = jobsearch_candidate_img_url_comn($_candidate_id);

            $candidate_jobtitle = get_post_meta($_candidate_id, 'jobsearch_field_candidate_jobtitle', true);
            $get_candidate_location = get_post_meta($_candidate_id, 'jobsearch_field_location_address', true);

            $job_short_int_list = get_post_meta($job_id, '_job_short_interview_list', true);
            $job_short_int_list = $job_short_int_list != '' ? explode(',', $job_short_int_list) : '';
            if (empty($job_short_int_list)) {
                $job_short_int_list = array();
            }
            $job_short_int_list = jobsearch_is_post_ids_array($job_short_int_list, 'candidate');


            $job_reject_int_list = get_post_meta($job_id, '_job_reject_interview_list', true);
            $job_reject_int_list = $job_reject_int_list != '' ? explode(',', $job_reject_int_list) : '';
            if (empty($job_reject_int_list)) {
                $job_reject_int_list = array();
            }
            $job_reject_int_list = jobsearch_is_post_ids_array($job_reject_int_list, 'candidate');

            $candidate_city_title = '';
            $get_candidate_city = get_post_meta($_candidate_id, 'jobsearch_field_location_location3', true);
            if ($get_candidate_city == '') {
                $get_candidate_city = get_post_meta($_candidate_id, 'jobsearch_field_location_location2', true);
            }
            if ($get_candidate_city == '') {
                $get_candidate_city = get_post_meta($_candidate_id, 'jobsearch_field_location_location1', true);
            }

            $candidate_city_tax = $get_candidate_city != '' ? get_term_by('slug', $get_candidate_city, 'job-location') : '';
            if (is_object($candidate_city_tax)) {
                $candidate_city_title = $candidate_city_tax->name;
            }

            $sectors = wp_get_post_terms($_candidate_id, 'sector');
            $candidate_sector = isset($sectors[0]->name) ? $sectors[0]->name : '';
            $candidate_salary = jobsearch_candidate_current_salary($_candidate_id);
            $candidate_age = jobsearch_candidate_age($_candidate_id);
            $candidate_phone = get_post_meta($_candidate_id, 'jobsearch_field_user_phone', true);
            $job_cver_ltrs = get_post_meta($job_id, 'jobsearch_job_apply_cvrs', true);
            $send_message_form_rand = rand(100000, 999999);
            $applicant_status = jobsearch_get_applicant_status_tarr($_candidate_id, $job_id);
            
            $candidate_status = get_post_meta($_candidate_id, 'jobsearch_field_candidate_approved', true);
            ?>
            <li class="jobsearch-column-12<?php echo ((isset($applicant_status['status']) && $applicant_status['status'] == 'pending') || $candidate_status != 'on' ? ' applicant-status-pending' : '') ?>">
                <script>
                    jQuery(document).on('click', '.jobsearch-modelemail-btn-<?php echo($send_message_form_rand) ?>', function () {
                        jobsearch_modal_popup_open('JobSearchModalSendEmailComm');
                        jQuery('#JobSearchModalSendEmailComm').find('form').attr('id', 'jobsearch_send_email_form<?php echo($send_message_form_rand) ?>');
                        jQuery('#JobSearchModalSendEmailComm').find('.loader-box').attr('class', 'loader-box loader-box-<?php echo($send_message_form_rand) ?>');
                        jQuery('#JobSearchModalSendEmailComm').find('.message-box').attr('class', 'message-box message-box-<?php echo($send_message_form_rand) ?>');
                        jQuery('#JobSearchModalSendEmailComm').find('.input-field-submit').find('input[type=submit]').attr('data-randid', '<?php echo($send_message_form_rand) ?>');
                        jQuery('#JobSearchModalSendEmailComm').find('.input-field-submit').find('input[type=submit]').attr('data-jid', '<?php echo($job_id) ?>');
                        jQuery('#JobSearchModalSendEmailComm').find('.input-field-submit').find('input[type=submit]').attr('data-cid', '<?php echo($_candidate_id) ?>');
                        jQuery('#JobSearchModalSendEmailComm').find('.input-field-submit').find('input[type=submit]').attr('data-eid', '<?php echo($employer_id) ?>');
                    });
                    jQuery(document).on('click', '.jobsearch-modelcvrltr-btn-<?php echo($send_message_form_rand) ?>', function () {
                        jobsearch_modal_popup_open('JobSearchCandCovershwModal<?php echo($send_message_form_rand) ?>');
                    });
                </script>
                <div class="jobsearch-applied-jobs-wrap">
                    <?php
                    $cand_is_pending = false;
                    if ($candidate_status != 'on') {
                        $cand_is_pending = true;
                        echo jobsearch_applicant_cand_profile_notaprov_txt();
                    } else if (isset($applicant_status['status']) && $applicant_status['status'] == 'pending') {
                        $cand_is_pending = true;
                        echo jobsearch_applicant_pend_profile_review_txt();
                    }
                    ?>
                    <a class="jobsearch-applied-jobs-thumb">
                        <?php
                        if (!$cand_is_pending) {
                            echo do_action('jobsearch_export_selection_emp', $_candidate_id, $job_id);
                        }
                        ?>
                        <img src="<?php echo($user_def_avatar_url) ?>" alt="">
                    </a>
                    <div class="jobsearch-applied-jobs-text">
                        <div class="jobsearch-applied-jobs-left">
                            <?php
                            $user_apply_data = get_user_meta($candidate_user_id, 'jobsearch-user-jobs-applied-list', true);
                            $aply_date_time = '';
                            if (!empty($user_apply_data)) {
                                $user_apply_key = array_search($job_id, array_column($user_apply_data, 'post_id'));
                                $aply_date_time = isset($user_apply_data[$user_apply_key]['date_time']) ? $user_apply_data[$user_apply_key]['date_time'] : '';
                            }
                            if ($candidate_jobtitle != '') { ?>
                                <span> <?php echo apply_filters('jobsearch_cand_jobtitle_indisplay', $candidate_jobtitle, $_candidate_id) ?></span>
                                <?php
                            }

                            if (in_array($_candidate_id, $viewed_candidates)) { ?>
                                <small class="profile-view viewed"><?php esc_html_e('(Viewed)', 'wp-jobsearch') ?></small>
                            <?php } else { ?>
                                <small class="profile-view unviewed"><?php esc_html_e('(Unviewed)', 'wp-jobsearch') ?></small>
                                <?php
                            }
                            $user_email_adr = isset($candidate_user_obj->user_email) ? $candidate_user_obj->user_email : '';
                            ?>
                            <a href="javascript:void(0);" class="jobsearch-modelemail-btn-<?php echo($send_message_form_rand) ?> jobsearch-user-email">
                                <small> <?php printf(esc_html__('Email: %s', 'wp-jobsearch'), $user_email_adr) ?></small>
                            </a>
                            <small class="profile-view unviewed"><?php esc_html_e('(Rejected)', 'wp-jobsearch') ?></small>
                            <?php
                            apply_filters('Jobsearch_Cand_shortlisted_View', $_candidate_id, $job_short_int_list);

                            echo apply_filters('jobsearch_applicants_list_before_title', '', $_candidate_id, $job_id);
                            ?>
                            <h2 class="jobsearch-pst-title">
                                <a href="<?php echo add_query_arg(array('job_id' => $job_id, 'employer_id' => $employer_id, 'action' => 'preview_profile'), get_permalink($_candidate_id)) ?>"><?php echo get_the_title($_candidate_id) ?></a>
                                <?php if ($candidate_age != '') { ?>
                                    <small><?php echo apply_filters('jobsearch_dash_applicants_age_html', sprintf(esc_html__('(Age: %s years)', 'wp-jobsearch'), $candidate_age)) ?></small>
                                    <?php
                                }
                                if ($candidate_phone != '') { ?>
                                    <small><?php printf(esc_html__('Phone: %s', 'wp-jobsearch'), $candidate_phone) ?></small>
                                <?php } ?>
                            </h2>
                            <ul>
                                <?php
                                if ($aply_date_time > 0) {
                                    ?>
                                    <li>
                                        <i class="jobsearch-icon jobsearch-calendar"></i> <?php printf(esc_html__('Applied at: %s', 'wp-jobsearch'), (date_i18n(get_option('date_format'), $aply_date_time) . ' ' . date_i18n(get_option('time_format'), $aply_date_time))) ?>
                                    </li>
                                    <?php
                                }
                                if ($candidate_salary != '') {
                                    ?>
                                    <li>
                                        <i class="fa fa-money"></i> <?php printf(esc_html__('Salary: %s', 'wp-jobsearch'), $candidate_salary) ?>
                                    </li>
                                    <?php
                                }
                                if ($candidate_city_title != '') {
                                    ?>
                                    <li><i class="jobsearch-icon jobsearch-maps-and-flags"></i> <?php echo($candidate_city_title) ?>
                                    </li>
                                    <?php
                                }
                                if ($candidate_sector != '') {
                                    ?>
                                    <li><i class="jobsearch-icon jobsearch-filter-tool-black-shape"></i>
                                        <a><?php echo($candidate_sector) ?></a></li>
                                    <?php
                                }
                                ?>
                            </ul>
                        </div>
                        <div class="jobsearch-applied-job-btns">
                            <?php
                            echo apply_filters('employer_dash_apps_acts_listul_after', '', $_candidate_id, $job_id);
                            ?>
                            <ul>
                                <li>
                                    <a href="<?php echo add_query_arg(array('job_id' => $job_id, 'employer_id' => $employer_id, 'action' => 'preview_profile'), get_permalink($_candidate_id)) ?>"
                                       class="preview-candidate-profile"><i
                                                class="fa fa-eye"></i> <?php esc_html_e('Preview', 'wp-jobsearch') ?>
                                    </a>
                                </li>
                                <li>
                                    <div class="candidate-more-acts-con">
                                        <a href="javascript:void(0);"
                                           class="more-actions"><?php esc_html_e('Actions', 'wp-jobsearch') ?>
                                            <i class="fa fa-angle-down"></i></a>
                                        <ul>
                                            <?php
                                            $multiple_cv_files_allow = isset($jobsearch_plugin_options['multiple_cv_uploads']) ? $jobsearch_plugin_options['multiple_cv_uploads'] : '';
                                            $candidate_cv_file = get_post_meta($_candidate_id, 'candidate_cv_file', true);

                                            if ($multiple_cv_files_allow == 'on') {
                                                $ca_at_cv_files = get_post_meta($_candidate_id, 'candidate_cv_files', true);
                                                if (!empty($ca_at_cv_files)) {
                                                    ?>
                                                    <li>
                                                        <a href="<?php echo apply_filters('jobsearch_user_attach_cv_file_url', '', $_candidate_id, $job_id) ?>"
                                                           oncontextmenu="javascript: return false;"
                                                           onclick="javascript: if ((event.button == 0 && event.ctrlKey)) {return false};"
                                                           download="<?php echo apply_filters('jobsearch_user_attach_cv_file_title', '', $_candidate_id, $job_id) ?>"><?php esc_html_e('Download CV', 'wp-jobsearch') ?></a>
                                                    </li>
                                                    <?php
                                                }
                                            } else if (!empty($candidate_cv_file)) {
                                                $file_attach_id = isset($candidate_cv_file['file_id']) ? $candidate_cv_file['file_id'] : '';
                                                $file_url = isset($candidate_cv_file['file_url']) ? $candidate_cv_file['file_url'] : '';

                                                $filename = isset($candidate_cv_file['file_name']) ? $candidate_cv_file['file_name'] : '';

                                                $file_url = apply_filters('wp_jobsearch_user_cvfile_downlod_url', $file_url, $file_attach_id, $_candidate_id);
                                                ?>
                                                <li><a href="<?php echo($file_url) ?>"
                                                       oncontextmenu="javascript: return false;"
                                                       onclick="javascript: if ((event.button == 0 && event.ctrlKey)) {return false};"
                                                       download="<?php echo($filename) ?>"><?php esc_html_e('Download CV', 'wp-jobsearch') ?></a>
                                                </li>
                                                <?php
                                            }
                                            echo apply_filters('employer_dash_apps_acts_list_after_download_link', '', $_candidate_id, $job_id);

                                            //
                                            if (isset($job_cver_ltrs[$_candidate_id]) && $job_cver_ltrs[$_candidate_id] != '') {
                                                ?>
                                                <li><a href="javascript:void(0);"
                                                       class="jobsearch-modelcvrltr-btn-<?php echo($send_message_form_rand) ?>"><?php esc_html_e('View Cover Letter', 'wp-jobsearch') ?></a>
                                                </li>
                                                <?php
                                            }
                                            ?>
                                            <li>
                                                <a href="javascript:void(0);"
                                                   class="jobsearch-modelemail-btn-<?php echo($send_message_form_rand) ?>"><?php esc_html_e('Email to Candidate', 'wp-jobsearch') ?></a>
                                                <?php
                                                $popup_args = array('p_job_id' => $_job_id, 'cand_id' => $_candidate_id, 'p_emp_id' => $employer_id, 'p_masg_rand' => $send_message_form_rand);
                                                add_action('wp_footer', function () use ($popup_args) {

                                                    extract(shortcode_atts(array(
                                                        'p_job_id' => '',
                                                        'p_emp_id' => '',
                                                        'cand_id' => '',
                                                        'p_masg_rand' => ''
                                                    ), $popup_args));
                                                    ?>
                                                    <div class="jobsearch-modal fade"
                                                         id="JobSearchModalSendEmail<?php echo($p_masg_rand) ?>">
                                                        <div class="modal-inner-area">&nbsp;</div>
                                                        <div class="modal-content-area">
                                                            <div class="modal-box-area">
                                                                        <span class="modal-close"><i
                                                                                    class="fa fa-times"></i></span>
                                                                <div class="jobsearch-send-message-form">
                                                                    <form autocomplete="off" method="post"
                                                                          id="jobsearch_send_email_form<?php echo esc_html($p_masg_rand); ?>">
                                                                        <div class="jobsearch-user-form">
                                                                            <ul class="email-fields-list">
                                                                                <li>
                                                                                    <label>
                                                                                        <?php echo esc_html__('Subject', 'wp-jobsearch'); ?>
                                                                                        :
                                                                                    </label>
                                                                                    <div class="input-field">
                                                                                        <input type="text"
                                                                                               name="send_message_subject"
                                                                                               value=""/>
                                                                                    </div>
                                                                                </li>
                                                                                <li>
                                                                                    <label>
                                                                                        <?php echo esc_html__('Message', 'wp-jobsearch'); ?>
                                                                                        :
                                                                                    </label>
                                                                                    <div class="input-field">
                                                                                                <textarea
                                                                                                        name="send_message_content"></textarea>
                                                                                    </div>
                                                                                </li>
                                                                                <li>
                                                                                    <div class="input-field-submit">
                                                                                        <input type="submit"
                                                                                               class="applicantto-email-submit-btn"
                                                                                               data-jid="<?php echo absint($p_job_id); ?>"
                                                                                               data-eid="<?php echo absint($p_emp_id); ?>"
                                                                                               data-cid="<?php echo absint($cand_id); ?>"
                                                                                               data-randid="<?php echo esc_html($p_masg_rand); ?>"
                                                                                               name="send_message_content"
                                                                                               value="<?php echo esc_html__('Send', 'wp-jobsearch') ?>"/>
                                                                                        <span class="loader-box loader-box-<?php echo esc_html($p_masg_rand); ?>"></span>
                                                                                    </div>
                                                                                    <?php jobsearch_terms_and_con_link_txt(); ?>
                                                                                </li>
                                                                            </ul>
                                                                            <div class="message-box message-box-<?php echo esc_html($p_masg_rand); ?>"
                                                                                 style="display:none;"></div>
                                                                        </div>
                                                                    </form>
                                                                </div>

                                                            </div>
                                                        </div>
                                                    </div>
                                                    <?php
                                                }, 11, 1);
                                                ?>
                                            </li>
                                            <?php if (in_array($_candidate_id, $job_reject_int_list)) { ?>
                                                <li>
                                                    <a href="javascript:void(0);"
                                                       class="undoreject-cand-to-list ajax-enable"
                                                       data-jid="<?php echo absint($job_id); ?>"
                                                       data-cid="<?php echo absint($_candidate_id); ?>"><?php esc_html_e('Undo Reject', 'wp-jobsearch') ?>
                                                        <span class="app-loader"></span></a>
                                                </li>
                                            <?php } else { ?>
                                                <li>
                                                    <?php if (in_array($_candidate_id, $job_short_int_list)) { ?>
                                                        <a href="javascript:void(0);"
                                                           class="shortlist-cand-to-intrview"><?php esc_html_e('Shortlisted', 'wp-jobsearch') ?></a>
                                                    <?php } else { ?>
                                                        <a href="javascript:void(0);"
                                                           class="shortlist-cand-to-intrview ajax-enable"
                                                           data-jid="<?php echo absint($job_id); ?>"
                                                           data-cid="<?php echo absint($_candidate_id); ?>"><?php esc_html_e('Shortlist for Interview', 'wp-jobsearch') ?>
                                                            <span class="app-loader"></span></a>
                                                    <?php } ?>
                                                </li>
                                                <li>
                                                    <?php
                                                    if (in_array($_candidate_id, $job_reject_int_list)) {
                                                        ?>
                                                        <a href="javascript:void(0);"
                                                           class="reject-cand-to-intrview"><?php esc_html_e('Rejected', 'wp-jobsearch') ?></a>
                                                        <?php
                                                    } else {
                                                        ?>
                                                        <a href="javascript:void(0);"
                                                           class="reject-cand-to-intrview ajax-enable"
                                                           data-jid="<?php echo absint($job_id); ?>"
                                                           data-cid="<?php echo absint($_candidate_id); ?>"><?php esc_html_e('Reject', 'wp-jobsearch') ?>
                                                            <span class="app-loader"></span></a>
                                                        <?php
                                                    }
                                                    ?>
                                                </li>
                                                <?php
                                            }
                                            ?>
                                            <li>
                                                <a href="javascript:void(0);"
                                                   class="delete-cand-from-job ajax-enable"
                                                   data-jid="<?php echo absint($job_id); ?>"
                                                   data-cid="<?php echo absint($_candidate_id); ?>"><?php esc_html_e('Delete', 'wp-jobsearch') ?>
                                                    <span class="app-loader"></span></a>
                                            </li>
                                        </ul>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </li>
            <?php

            $job_cver_ltrs = get_post_meta($job_id, 'jobsearch_job_apply_cvrs', true);
            if (isset($job_cver_ltrs[$_candidate_id]) && $job_cver_ltrs[$_candidate_id] != '') {
                ?>
                <div class="jobsearch-modal jobsearch-typo-wrap jobsearch-candcover-popup fade"
                     id="JobSearchCandCovershwModal<?php echo($send_message_form_rand) ?>">
                    <div class="modal-inner-area">&nbsp;</div>
                    <div class="modal-content-area">
                        <div class="modal-box-area">
                            <div class="jobsearch-modal-title-box">
                                <h2><?php esc_html_e('Cover Letter', 'wp-jobsearch') ?></h2>
                                <span class="modal-close"><i class="fa fa-times"></i></span>
                            </div>
                            <p><?php echo($job_cver_ltrs[$_candidate_id]) ?></p>
                        </div>
                    </div>
                </div>
                <?php
            }
        }
    }

    $html = ob_get_clean();
    echo json_encode(array('html' => $html));
    wp_die();
}

add_filter('jobsearch_candidate_dash_profile_img_html', function($html) {
    global $jobsearch_plugin_options;
    $cand_img_switch = isset($jobsearch_plugin_options['candidate_profile_img_switch']) ? $jobsearch_plugin_options['candidate_profile_img_switch'] : '';
    if ($cand_img_switch == 'off') {
        $html = '';
    }
    return $html;
}, 15);

add_filter('jobsearch_employer_dash_profile_img_html', function($html) {
    global $jobsearch_plugin_options;
    $company_img_switch = isset($jobsearch_plugin_options['company_profile_img_switch']) ? $jobsearch_plugin_options['company_profile_img_switch'] : '';
    if ($company_img_switch == 'off') {
        $html = '';
    }
    return $html;
}, 15);

add_filter('jobsearch_emp_dash_profile_imguplodbtn_html', function($html) {
    global $jobsearch_plugin_options;
    $cand_img_switch = isset($jobsearch_plugin_options['candidate_profile_img_switch']) ? $jobsearch_plugin_options['candidate_profile_img_switch'] : '';
    $company_img_switch = isset($jobsearch_plugin_options['company_profile_img_switch']) ? $jobsearch_plugin_options['company_profile_img_switch'] : '';
    
    $user_id = get_current_user_id();
    
    if (jobsearch_user_is_employer($user_id) && $company_img_switch == 'off') {
        $html = '';
    }
    if (jobsearch_user_is_candidate($user_id) && $cand_img_switch == 'off') {
        $html = '';
    }
    
    return $html;
}, 15);

add_action('jobsearch_registration_extra_fields_after_sector', 'jobsearch_preg_signup_location_fields', 15);

function jobsearch_preg_signup_location_fields($args) {
    global $jobsearch_plugin_options, $jobsearch_gdapi_allocation;
    $signup_loc_address = isset($jobsearch_plugin_options['signup_loc_address']) ? $jobsearch_plugin_options['signup_loc_address'] : '';
    $all_locations_type = isset($jobsearch_plugin_options['all_locations_type']) ? $jobsearch_plugin_options['all_locations_type'] : '';
    if ($all_locations_type == 'api') {
        $jobsearch_gdapi_allocation->load_locations_js(true, false);
    }
    if ($signup_loc_address == 'on') {
        do_action('jobsearch_dashboard_location_map', 0, 'reg', 'no');
    }
}

add_filter('jobsearch_user_frontloc_fields_ul_atts', 'jobsearch_preg_signup_loc_fields_ul_style', 15);

function jobsearch_preg_signup_loc_fields_ul_style($atts) {

    $atts .= ' style="background:none; padding:0;"';
    return $atts;
}

add_filter('jobsearch_user_frontloc_loc1_fieldclass', 'jobsearch_preg_reg_half_field_class', 15, 2);
add_filter('jobsearch_user_frontloc_loc2_fieldclass', 'jobsearch_preg_reg_half_field_class', 15, 2);
add_filter('jobsearch_user_frontloc_loc3_fieldclass', 'jobsearch_preg_reg_half_field_class', 15, 2);
add_filter('jobsearch_user_frontloc_loc4_fieldclass', 'jobsearch_preg_reg_half_field_class', 15, 2);
add_filter('jobsearch_user_frontloc_contry_fieldclass', 'jobsearch_preg_reg_half_field_class', 15, 2);
add_filter('jobsearch_user_frontloc_state_fieldclass', 'jobsearch_preg_reg_half_field_class', 15, 2);
add_filter('jobsearch_user_frontloc_city_fieldclass', 'jobsearch_preg_reg_half_field_class', 15, 2);

function jobsearch_preg_reg_half_field_class($class, $positon) {
    global $jobsearch_plugin_options;
    $switch_location_fields = isset($jobsearch_plugin_options['switch_location_fields']) ? $jobsearch_plugin_options['switch_location_fields'] : '';
    if ($positon === 'reg') {
        $jobsearch_locsetin_options = get_option('jobsearch_locsetin_options');
        $loc_required_fields = isset($jobsearch_locsetin_options['loc_required_fields']) ? $jobsearch_locsetin_options['loc_required_fields'] : '';
        if ($switch_location_fields != 'on') {
            $loc_required_fields = '';
        }
        $class = '';
        if ($loc_required_fields == 'yes') {
            $class = 'class="regrequire-field-li"';
        }
    }
    return $class;
}

add_filter('jobsearch_user_frontloc_postcode_fieldclass', 'jobsearch_preg_reg_latlng_code_field_class', 15, 2);
add_filter('jobsearch_user_frontloc_lat_fieldclass', 'jobsearch_preg_reg_latlng_code_field_class', 15, 2);
add_filter('jobsearch_user_frontloc_lng_fieldclass', 'jobsearch_preg_reg_latlng_code_field_class', 15, 2);

function jobsearch_preg_reg_latlng_code_field_class($class, $positon) {
    if ($positon === 'reg') {
        $class = '';
    }
    return $class;
}

add_filter('jobsearch_user_frontloc_fulladrs_fieldclass', 'jobsearch_preg_reg_full_field_class', 15, 2);

function jobsearch_preg_reg_full_field_class($class, $positon) {
    if ($positon === 'reg') {
        $class = 'class="jobsearch-user-form-coltwo-full"';
    }
    return $class;
}

add_filter('jobsearch_user_frontloc_zoom_fieldclass', 'jobsearch_preg_reg_remve_field_class', 15, 2);
add_filter('jobsearch_user_frontloc_findmap_fieldclass', 'jobsearch_preg_reg_remve_field_class', 15, 2);
add_filter('jobsearch_user_frontloc_map_fieldclass', 'jobsearch_preg_reg_remve_field_class', 15, 2);

function jobsearch_preg_reg_remve_field_class($class, $positon) {
    if ($positon === 'reg') {
        $class = 'style="display:none;"';
    }
    return $class;
}

add_action('jobsearch_member_after_making_cand_or_emp', 'jobsearch_preg_regloc_fields_save', 15, 2);

function jobsearch_preg_regloc_fields_save($user_id, $user_role) {
    if ($user_role == 'jobsearch_employer') {
        $member_id = jobsearch_get_user_employer_id($user_id);
    } else {
        $member_id = jobsearch_get_user_candidate_id($user_id);
    }
    $location_1 = $location_2 = $location_3 = '';
    if (isset($_POST['jobsearch_field_location_location1'])) {
        $location_1 = $_POST['jobsearch_field_location_location1'];
    } else if (isset($_POST['location_location1'])) {
        $location_1 = $_POST['location_location1'];
    }
    if (isset($_POST['jobsearch_field_location_location2'])) {
        $location_2 = $_POST['jobsearch_field_location_location2'];
    } else if (isset($_POST['location_location2'])) {
        $location_2 = $_POST['location_location2'];
    }
    if (isset($_POST['jobsearch_field_location_location3'])) {
        $location_3 = $_POST['jobsearch_field_location_location3'];
    } else if (isset($_POST['location_location3'])) {
        $location_3 = $_POST['location_location3'];
    }
    $post_code = isset($_POST['jobsearch_field_location_postalcode']) ? ($_POST['jobsearch_field_location_postalcode']) : '';
    $full_address = isset($_POST['jobsearch_field_location_address']) ? ($_POST['jobsearch_field_location_address']) : '';
    $lat = isset($_POST['jobsearch_field_location_lat']) ? ($_POST['jobsearch_field_location_lat']) : '';
    $long = isset($_POST['jobsearch_field_location_lng']) ? ($_POST['jobsearch_field_location_lng']) : '';

    update_post_meta($member_id, 'jobsearch_field_location_location1', $location_1);
    update_post_meta($member_id, 'jobsearch_field_location_location2', $location_2);
    update_post_meta($member_id, 'jobsearch_field_location_location3', $location_3);
    update_post_meta($member_id, 'jobsearch_field_location_postalcode', $post_code);
    update_post_meta($member_id, 'jobsearch_field_location_address', $full_address);
    update_post_meta($member_id, 'jobsearch_field_location_lat', $lat);
    update_post_meta($member_id, 'jobsearch_field_location_lng', $long);
}

add_action('post_edit_form_tag', 'jobsearch_add_bkpost_enctype');

function jobsearch_add_bkpost_enctype() {
    echo ' enctype="multipart/form-data"';
}

add_filter('jobsearch_datepicker_custom_format', function($date_format) {
    
    $date_format = str_replace(array(','), array(''), $date_format);
    
    return $date_format;
});

//
add_action('wp_footer', function() {
    
    if (is_singular(array('job'))) {
        
        $user_id = get_current_user_id();
        $candidate_id = jobsearch_get_user_candidate_id($user_id);
        
        $reg_job_id = get_user_meta($user_id, 'jobsearch_accaprov_jobaply_id', true);
        
        if ($reg_job_id > 0 && get_post_type($reg_job_id) == 'job') {
            $jobsearch__options = get_option('jobsearch_plugin_options');
            
            $job_apply_type = get_post_meta($reg_job_id, 'jobsearch_field_job_apply_type', true);

            $can_apply = true;
            $candidate_skills = isset($jobsearch__options['jobsearch_candidate_skills']) ? $jobsearch__options['jobsearch_candidate_skills'] : '';
            if ($candidate_skills == 'on') {
                $candidate_approve_skill = isset($jobsearch__options['jobsearch-candidate-skills-percentage']) ? $jobsearch__options['jobsearch-candidate-skills-percentage'] : 0;
                $candidate_skill_perc = get_post_meta($candidate_id, 'overall_skills_percentage', true);
                if (($candidate_approve_skill > 0 && $candidate_skill_perc < $candidate_approve_skill)) {
                    $can_apply = false;
                    $msg = sprintf(esc_html__('You are not able to apply job. You must have at least %s profile score to apply for this job.', 'wp-jobsearch'), $candidate_approve_skill . '%');
                }
            }
            $candidate_auto_approve = isset($jobsearch__options['candidate_auto_approve']) ? $jobsearch__options['candidate_auto_approve'] : '';
            if ($candidate_auto_approve == 'admin_email') {
                $can_apply = false;
                $msg = esc_html__('You are not able to apply job. Because your profile is not approved by admin till yet.', 'wp-jobsearch');
            }
            
            if (!$can_apply && ($job_apply_type != 'with_email' && $job_apply_type != 'external')) {
                ?>
                <div class="jobsearch-modal fade" id="JobSearchModalApplyjobErrMsg">
                    <div class="modal-inner-area">&nbsp;</div>
                    <div class="modal-content-area">
                        <div class="modal-box-area">
                            <div class="jobsearch-modal-title-box">
                                <h2><?php esc_html_e('Cannot Apply Job', 'wp-jobsearch'); ?></h2>
                                <span class="modal-close"><i class="fa fa-times"></i></span>
                            </div>
                            <p><?php echo ($msg) ?></p>
                        </div>
                    </div>
                    <script type="text/javascript">
                        jQuery(document).ready(function () {
                            jobsearch_modal_popup_open('JobSearchModalApplyjobErrMsg');
                        });
                    </script>
                </div>
                <?php
            }
            
            //
            update_user_meta($user_id, 'jobsearch_accaprov_jobaply_id', '');
        }
    }
});

function jobsearch_user_member_phone_number($member_id) {
    $phone_number = get_post_meta($member_id, 'jobsearch_field_user_phone', true);
    $just_phone = get_post_meta($member_id, 'jobsearch_field_user_justphone', true);
    $dial_code = get_post_meta($member_id, 'jobsearch_field_user_dial_code', true);
    
    if ($just_phone != '' && $dial_code != '') {
        $dial_code = preg_replace('/[+]/i', '', $dial_code);
        
        $user_phone_number = '+' . $dial_code . ' ' . $just_phone;
        
        return $user_phone_number;
    }
    
    if ($phone_number != '' && $dial_code != '') {
        $dial_code = preg_replace('/[+]/i', '', $dial_code);
        $phone_number = preg_replace('/[+]/i', '', $phone_number);
        $phone_number = '+' . $phone_number;
        
        $replce_str = '[+]' . $dial_code;
        $user_phone_number = preg_replace("/$replce_str/i", "+$dial_code ", $phone_number);
        
        return $user_phone_number;
    }
    
    return $phone_number;
}

function jobsearch_cand_check_profile_fields_for_aprove($user_id, $candidate_id, $fields_for = 'check') {
    global $jobsearch_plugin_options;
    
    $all_fields_pass = true;
    $fileds_msgs = [];
            
    $user_obj = get_user_by('ID', $user_id);
    $user_displayname = isset($user_obj->display_name) ? $user_obj->display_name : '';
    $user_displayname = apply_filters('jobsearch_user_display_name', $user_displayname, $user_obj);
    $user_firstname = isset($user_obj->first_name) ? $user_obj->first_name : '';
    $user_lastname = isset($user_obj->last_name) ? $user_obj->last_name : '';
    
    $flnames_fields_allow = isset($jobsearch_plugin_options['signup_user_flname']) ? $jobsearch_plugin_options['signup_user_flname'] : '';

    if ($flnames_fields_allow == 'on') {
        if ($user_firstname == '' || $user_lastname == '') {
            $all_fields_pass = false;
            //
            $fileds_msgs['display_name'] = array(
                'label' => esc_html__('Full Name', 'wp-jobsearch'),
                'msg' => esc_html__('Enter first name and last name fields.', 'wp-jobsearch'),
            );
        }
    } else {
        if ($user_displayname == '') {
            $all_fields_pass = false;
            //
            $fileds_msgs['display_name'] = array(
                'label' => esc_html__('Full Name', 'wp-jobsearch'),
                'msg' => esc_html__('Enter your full name field.', 'wp-jobsearch'),
            );
        }
    }
    
    $candidate_profile_img = isset($jobsearch_plugin_options['candidate_profile_img_switch']) ? $jobsearch_plugin_options['candidate_profile_img_switch'] : '';
    if ($candidate_profile_img != 'off') {
        $user_avatar_dburl = get_post_meta($candidate_id, 'jobsearch_user_avatar_url', true);

        if (isset($user_avatar_dburl['file_url']) && $user_avatar_dburl['file_url'] != '') {
            //
        } else {
            $all_fields_pass = false;
            //
            $fileds_msgs['profile_img'] = array(
                'label' => esc_html__('Profile Picture', 'wp-jobsearch'),
                'msg' => esc_html__('Enter your phone profile picture.', 'wp-jobsearch'),
            );
        }
    }

    $candidate_cv_file = get_post_meta($candidate_id, 'candidate_cv_file', true);
    $multiple_cv_files_allow = isset($jobsearch_plugin_options['multiple_cv_uploads']) ? $jobsearch_plugin_options['multiple_cv_uploads'] : '';
    $ca_at_cv_files = get_post_meta($candidate_id, 'candidate_cv_files', true);

    $have_resume = true;
    if ($multiple_cv_files_allow == 'on') {
        if (empty($ca_at_cv_files)) {
            $have_resume = false;
        }
    } else {
        if (empty($candidate_cv_file)) {
            $have_resume = false;
        }
    }
    if (!$have_resume) {
        $all_fields_pass = false;
        //
        $fileds_msgs['resume'] = array(
            'label' => esc_html__('Resume', 'wp-jobsearch'),
            'msg' => esc_html__('Please upload your resume.', 'wp-jobsearch'),
        );
    }
    
    //
    $cand_phone_switch = isset($jobsearch_plugin_options['cand_phone_switch']) ? $jobsearch_plugin_options['cand_phone_switch'] : '';
    if ($cand_phone_switch == 'on_req') {
        $user_phone = get_post_meta($candidate_id, 'jobsearch_field_user_phone', true);
        if ($user_phone == '') {
            $all_fields_pass = false;
            //
            $fileds_msgs['phone'] = array(
                'label' => esc_html__('Phone Number', 'wp-jobsearch'),
                'msg' => esc_html__('Enter your phone number field.', 'wp-jobsearch'),
            );
        }
    }
    
    //
    // $sectors_enable_switch = isset($jobsearch_plugin_options['usersector_onoff_switch']) ? $jobsearch_plugin_options['usersector_onoff_switch'] : '';
    // if ($sectors_enable_switch == 'on_cand' || $sectors_enable_switch == 'on_both') {
    //     $sector_selct_method = isset($jobsearch_plugin_options['cand_sector_selct_method']) ? $jobsearch_plugin_options['cand_sector_selct_method'] : '';
    //     if ($sector_selct_method == 'single_req' || $sector_selct_method == 'multi_req') {
    //         $candidate_sectors = wp_get_post_terms($candidate_id, 'sector');
    //         if (!isset($candidate_sectors[0])) {
    //             $all_fields_pass = false;
    //             //
    //             $fileds_msgs['sector'] = array(
    //                 'label' => esc_html__('Sector', 'wp-jobsearch'),
    //                 'msg' => esc_html__('Selece a sector from list.', 'wp-jobsearch'),
    //             );
    //         }
    //     }
    // }
    
    //
    $field_db_slug = "jobsearch_custom_field_candidate";
    $custom_fields_data = get_option($field_db_slug);

    if (is_array($custom_fields_data) && sizeof($custom_fields_data) > 0) {

        foreach ($custom_fields_data as $f_key => $custom_field_saved_data) {
            $field_name = isset($custom_field_saved_data['name']) ? $custom_field_saved_data['name'] : '';
            $is_required = isset($custom_field_saved_data['required']) ? $custom_field_saved_data['required'] : '';
            if ($field_name != '' && $is_required == 'yes') {
                $field_label = isset($custom_field_saved_data['label']) ? $custom_field_saved_data['label'] : '';
                $user_saved_val = get_post_meta($candidate_id, $field_name, true);
                if ($user_saved_val == '') {
                    $all_fields_pass = false;
                    //
                    $fileds_msgs['custom_filed_' . $field_name] = array(
                        'label' => $field_label,
                        'msg' => sprintf(esc_html__('Enter your %s field.', 'wp-jobsearch'), $field_label),
                    );
                }
            }
        }
    }
    
    $candidate_edu_swich = isset($jobsearch_plugin_options['cand_resm_education']) ? $jobsearch_plugin_options['cand_resm_education'] : '';
    $candidate_exp_swich = isset($jobsearch_plugin_options['cand_resm_experience']) ? $jobsearch_plugin_options['cand_resm_experience'] : '';
    $candidate_port_swich = isset($jobsearch_plugin_options['cand_resm_portfolio']) ? $jobsearch_plugin_options['cand_resm_portfolio'] : '';
    $candidate_skill_swich = isset($jobsearch_plugin_options['cand_resm_skills']) ? $jobsearch_plugin_options['cand_resm_skills'] : '';
    $candidate_lang_swich = isset($jobsearch_plugin_options['cand_resm_langs']) ? $jobsearch_plugin_options['cand_resm_langs'] : '';
    $candidate_award_swich = isset($jobsearch_plugin_options['cand_resm_honsawards']) ? $jobsearch_plugin_options['cand_resm_honsawards'] : '';
                     
    if ($candidate_edu_swich == 'on') {
        $candidate_edu = get_post_meta($candidate_id, 'jobsearch_field_education_title', true);
        if (empty($candidate_edu)) {
            $all_fields_pass = false;
            //
            $fileds_msgs['education'] = array(
                'label' => esc_html__('Education', 'wp-jobsearch'),
                'msg' => esc_html__('Enter your education.', 'wp-jobsearch'),
            );
        }
    }                        
    if ($candidate_exp_swich == 'on') {
        $candidate_edu = get_post_meta($candidate_id, 'jobsearch_field_experience_title', true);
        if (empty($candidate_edu)) {
            $all_fields_pass = false;
            //
            $fileds_msgs['experience'] = array(
                'label' => esc_html__('Experience', 'wp-jobsearch'),
                'msg' => esc_html__('Enter your experience.', 'wp-jobsearch'),
            );
        }
    }                        
    if ($candidate_port_swich == 'on') {
        $candidate_edu = get_post_meta($candidate_id, 'jobsearch_field_portfolio_title', true);
        if (empty($candidate_edu)) {
            $all_fields_pass = false;
            //
            $fileds_msgs['portfolio'] = array(
                'label' => esc_html__('Portfolio', 'wp-jobsearch'),
                'msg' => esc_html__('Enter your portfolio.', 'wp-jobsearch'),
            );
        }
    }                        
    if ($candidate_skill_swich == 'on') {
        $candidate_edu = get_post_meta($candidate_id, 'jobsearch_field_skill_title', true);
        if (empty($candidate_edu)) {
            $all_fields_pass = false;
            //
            $fileds_msgs['expertise'] = array(
                'label' => esc_html__('Expertise', 'wp-jobsearch'),
                'msg' => esc_html__('Enter your expertise.', 'wp-jobsearch'),
            );
        }
    }                        
    if ($candidate_lang_swich == 'on') {
        $candidate_edu = get_post_meta($candidate_id, 'jobsearch_field_lang_title', true);
        if (empty($candidate_edu)) {
            $all_fields_pass = false;
            //
            $fileds_msgs['language'] = array(
                'label' => esc_html__('Languages', 'wp-jobsearch'),
                'msg' => esc_html__('Enter your languages.', 'wp-jobsearch'),
            );
        }
    }                        
    if ($candidate_award_swich == 'on') {
        $candidate_edu = get_post_meta($candidate_id, 'jobsearch_field_award_title', true);
        if (empty($candidate_edu)) {
            $all_fields_pass = false;
            //
            $fileds_msgs['award'] = array(
                'label' => esc_html__('Honors & Awards', 'wp-jobsearch'),
                'msg' => esc_html__('Enter your honors & awards.', 'wp-jobsearch'),
            );
        }
    }

    $fileds_msgs = apply_filters('jobsearch_cand_for_aprove_check_msgs_for', $fileds_msgs, $user_id, $candidate_id, $fields_for);
    $all_fields_pass = apply_filters('jobsearch_cand_for_aprove_check_pass_for', $all_fields_pass, $user_id, $candidate_id, $fields_for);
    
    if ($fields_for == 'msgs') {
        return $fileds_msgs;
    }
    
    return $all_fields_pass;
}

add_action('jobsearch_candidate_profile_save_after', 'jobsearch_check_cand_profile_fields_and_approve', 15, 1);
add_action('jobsearch_candidate_dash_resume_save_after', 'jobsearch_check_cand_profile_fields_and_approve', 15, 1);

function jobsearch_check_cand_profile_fields_and_approve($candidate_id) {
    global $jobsearch_plugin_options;
    
    $candidate_auto_approve = isset($jobsearch_plugin_options['profile_approve_compfields_base']) ? $jobsearch_plugin_options['profile_approve_compfields_base'] : '';
    
    if ($candidate_auto_approve != 'on') {
        return false;
    }
    
    $user_id = get_current_user_id();
    
    $cand_status = get_post_meta($candidate_id, 'jobsearch_field_candidate_approved', true);
    
    if ($cand_status == 'on') {
        return false;
    }
    
    $chek_pas = jobsearch_cand_check_profile_fields_for_aprove($user_id, $candidate_id);
    
    if ($chek_pas) {
        update_post_meta($candidate_id, 'jobsearch_field_candidate_approved', 'on');
    }
}

function jobsearch_before_cand_dash_stats_alerts($user_id, $candidate_id) {
    global $jobsearch_plugin_options;
    
    $candidate_auto_approve = isset($jobsearch_plugin_options['profile_approve_compfields_base']) ? $jobsearch_plugin_options['profile_approve_compfields_base'] : '';
    
    echo apply_filters('jobsearch_before_dashstats_alert_notifications', '', $user_id, $candidate_id);
    
    if ($candidate_auto_approve != 'on') {
        //return false;
    }
    $cand_status = get_post_meta($candidate_id, 'jobsearch_field_candidate_approved', true);
    
    if ($cand_status == 'on') {
        $active_alert_closed = get_post_meta($candidate_id, 'profile_active_alert_closed', true);
        if (!$active_alert_closed) {
            ?>
            <div class="jobsearch-profil-approv-alrt">
                <div class="alrt-cover-area alert-success">
                    <div class="alrt-icon"><i class="fa fa-check"></i></div>
                    <div class="alrt-msg">
                        <span><?php esc_html_e('Your account is active, you can now apply to the desired jobs.', 'wp-jobsearch') ?></span>
                    </div>
                    <a href="#" class="close-alrt-btn profile-activalrt-closbtn"><i class="fa fa-times"></i></a>
                </div>
            </div>
            <?php
        }
    } else {
        $chek_pas_fields = jobsearch_cand_check_profile_fields_for_aprove($user_id, $candidate_id, 'msgs');
        ?>
        <div class="jobsearch-profil-noapprov-alrt">
            <div class="alrt-cover-area alert-warning">
                <div class="alrt-icon"><i class="fa fa-check"></i></div>
                <div class="alrt-msg">
                    <span><?php esc_html_e('Your account is not active, to activate your
    account, upload your Profile Picture, current resume in the My Resume section. And complete all mandatory fields in \'My Profile\' section.', 'wp-jobsearch') ?></span>
                </div>
            </div>
        </div>
        <?php
        if (!empty($chek_pas_fields)) {
            echo '<div class="comprofil-dashb-boxes">';
            foreach ($chek_pas_fields as $field_key => $chek_pas_field) {
                ?>
                <div class="user-compriofil-boxitm">
                    <div class="icon-boxcon"><i class="fa fa-user"></i></div>
                    <div class="porf-info-con">
                        <strong><?php echo ($chek_pas_field['label']) ?></strong>
                        <span><?php echo ($chek_pas_field['msg']) ?></span>
                    </div>
                </div>
                <?php
            }
            echo '</div>';
            ?>
            <div class="activte-fields-msg" style="display: inline-block; width: 100%; margin-bottom: 20px;">
                <p><strong><?php esc_html_e('To activate your account - complete all items listed above.', 'wp-jobsearch') ?></strong></p>
            </div>
            <?php
        }
    }
}