<?php
add_action("admin_init", "auto_repair_search_setting_fields");
add_action( 'admin_menu', 'auto_repair_search_main_plugin_menu' );
add_action( 'init', 'auto_repair_search_add_catagory'  );
add_action( 'init', 'auto_repair_search_post_types'  );
add_action( 'init', 'auto_repair_search_option_activate'  );
add_action( 'do_meta_boxes', 'auto_repair_search_do_metaboxes' );
add_action( 'save_post','auto_repair_search_saveData', 10, 2 );
add_shortcode( 'repair-search-form', 'auto_repair_search_car_search_function'  );
add_action( 'wp_enqueue_scripts',  'auto_repair_search_enqueue_scripts' );
add_action('wp_ajax_submit-form', 'auto_repair_search_handle_form_action');
add_action('wp_ajax_nopriv_submit-form', 'auto_repair_search_handle_form_action');
add_action( 'wp_ajax_get_option_data', 'auto_repair_search_get_option_data' );
add_action( 'wp_ajax_nopriv_get_option_data', 'auto_repair_search_get_option_data' );
add_action( 'plugins_loaded', 'auto_repair_search_load_textdomain' );

function auto_repair_search_load_textdomain() {
  load_plugin_textdomain( 'auto-repair-search', false, basename( dirname( __FILE__ ) ) . '/languages' ); 
} 
function auto_repair_search_option_activate(){
    add_option('oil_change_title','Change oil form Here');
    add_option('oil_change_content','<div class="store"><p class="location">Store <a class="store-number" href="#">#7056</a>5731 Riverdale Rd, Riverdale, MD<a href="#">Change Store</a></p><p class="directions"><a class="directions" href="#">DIRECTIONS</a></p><p class="directions">Hours:</p><p class="directions">MON-FRI:&nbsp;7:00am-7:00pm</p><p class="directions">SAT:&nbsp;7:00am-6:00pm</p><p class="directions">SUN:&nbsp;8:00am-5:00pm</p></div>');
    add_option('brake_change_title','Get An Brakes  Change');
    add_option('brake_change_content','<div class="store"><p class="location">Store <a class="store-number" href="#">#7056</a>5731 Riverdale Rd, Riverdale, MD<a href="#">Change Store</a></p><p class="directions"><a class="directions" href="#">DIRECTIONS</a></p><p class="directions">Hours:</p><p class="directions">MON-FRI:&nbsp;7:00am-7:00pm</p><p class="directions">SAT:&nbsp;7:00am-6:00pm</p><p class="directions">SUN:&nbsp;8:00am-5:00pm</p></div>');
    add_option('brake_map_address','SH49, Albania');
    add_option('oil_map_address','SH49, Albania');
    add_option('oil_map_address_hidden','SH49, Albania');
    add_option('brake_map_address_hidden','SH49, Albania');
    add_option('tires_checkbox','1');
    add_option('tires_vehicle_checkbox','1');
    add_option('tires_tire_checkbox','1');
    add_option('oilchange_checkbox','1');
    add_option('brake_checkbox','1');
    add_option('alignment_checkbox','1');
    add_option('batteries_checkbox','1');
}

function auto_repair_search_settings_page()
{
    ?><div class="wrap">
        <h1>Theme Panel</h1>
        <form method="post" action="options.php">
            <?php
                settings_fields("section");
                do_settings_sections("ar-setting");      
                submit_button();
            ?>          
        </form>
        </div>
    <?php
}
function auto_repair_search_display_oil_title()
{
    echo '<input value="'.get_option('oil_change_title').'" name="oil_change_title">';
}

function auto_repair_search_display_oil_element()
{
    $content = get_option('oil_change_content');
    wp_editor( $content, 'oil_change_content', $settings = array('textarea_rows'=> '10') );
}
function auto_repair_search_display_brake_title()
{
    echo '<input value="'.get_option('brake_change_title').'" name="brake_change_title">';
}
function auto_repair_search_display_brake_element()
{
    $content = get_option('brake_change_content');
    wp_editor( $content, 'brake_change_content', $settings = array('textarea_rows'=> '10') );
}
function auto_repair_search_display_brake_map()
{
    echo '<input id="brake_map_address" value="'.get_option('brake_map_address').'" name="brake_map_address">';
}
function auto_repair_search_display_oil_map()
{
    echo '<input  id="oil_map_address" value="'.get_option('oil_map_address').'" name="oil_map_address">';
}

function auto_repair_search_display_oil_map_hidden()
{
    echo '<input type="hidden" value="'.get_option('oil_map_address_hidden').'" name="oil_map_address_hidden">';
}
function auto_repair_search_display_brake_map_hidden()
{
    echo '<input type="hidden" value="'.get_option('brake_map_address_hidden').'" name="brake_map_address_hidden">';
}




function auto_repair_search_display_tires_checkbox()
{
?>
    <input name="tires_checkbox" type="checkbox" value="1" <?php checked( '1', get_option( 'tires_checkbox' ) ); ?> /> 
<?php
}
function auto_repair_search_display_tires_vehicle_checkbox()
{
?>
    <input name="tires_vehicle_checkbox" type="checkbox" value="1" <?php checked( '1', get_option( 'tires_vehicle_checkbox' ) ); ?> /> 
<?php
}
function auto_repair_search_display_tires_tire_checkbox()
{
?>
    <input name="tires_tire_checkbox" type="checkbox" value="1" <?php checked( '1', get_option( 'tires_tire_checkbox' ) ); ?> /> 
<?php
}

function auto_repair_search_display_oilchange_checkbox()
{
?>
    <input name="oilchange_checkbox" type="checkbox" value="1" <?php checked( '1', get_option( 'oilchange_checkbox' ) ); ?> /> 
<?php
}
function auto_repair_search_display_brake_checkbox()
{
?>
    <input name="brake_checkbox" type="checkbox" value="1" <?php checked( '1', get_option( 'brake_checkbox' ) ); ?> /> 
<?php
}
function auto_repair_search_display_alignment_checkbox()
{
?>
    <input name="alignment_checkbox" type="checkbox" value="1" <?php checked( '1', get_option( 'alignment_checkbox' ) ); ?> /> 
<?php
}
function auto_repair_search_display_batteries_checkbox()
{
?>
    <input name="batteries_checkbox" type="checkbox" value="1" <?php checked( '1', get_option( 'batteries_checkbox' ) ); ?> /> 
<?php
    //echo '<input type="checkbox" name="batteries_checkbox" value="1" '.checked(1, get_option('batteries_checkbox'), true).' /> ';
}




function auto_repair_search_setting_fields()
{
    add_settings_section("section", "Oil & Brakes Change Settings", null, "ar-setting");
    add_settings_field("oil_change_title", "Oil Change Title", "auto_repair_search_display_oil_title", "ar-setting", "section");
    add_settings_field("oil_map_address", "Map adderss", "auto_repair_search_display_oil_map", "ar-setting", "section");
    add_settings_field("oil_change_content", "Oil Change Content", "auto_repair_search_display_oil_element", "ar-setting", "section");
    add_settings_field("brake_change_title", "Brakes Change Title", "auto_repair_search_display_brake_title", "ar-setting", "section");
    add_settings_field("brake_map_address", "Map adderss", "auto_repair_search_display_brake_map", "ar-setting", "section");
    add_settings_field("brake_change_content", "Brakes Change Content", "auto_repair_search_display_brake_element", "ar-setting", "section");
    add_settings_field("brake_map_address_hidden", "", "auto_repair_search_display_brake_map_hidden", "ar-setting", "section");
    add_settings_field("oil_map_address_hidden", "", "auto_repair_search_display_oil_map_hidden", "ar-setting", "section");
    
    
    add_settings_field("tires_checkbox", "Active Tires Tab", "auto_repair_search_display_tires_checkbox", "ar-setting", "section");
    add_settings_field("tires_vehicle_checkbox", "Active Tires By Vehicle Tab", "auto_repair_search_display_tires_vehicle_checkbox", "ar-setting", "section");
    add_settings_field("tires_tire_checkbox", "Active Tires By Tires Tab", "auto_repair_search_display_tires_tire_checkbox", "ar-setting", "section");
    add_settings_field("oilchange_checkbox", "Active Oil Change Tab", "auto_repair_search_display_oilchange_checkbox", "ar-setting", "section");
    add_settings_field("brake_checkbox", "Active Brakes Tab", "auto_repair_search_display_brake_checkbox", "ar-setting", "section");
    add_settings_field("alignment_checkbox", "Active Alignment Tab", "auto_repair_search_display_alignment_checkbox", "ar-setting", "section");
    add_settings_field("batteries_checkbox", "Active Batteries Tab", "auto_repair_search_display_batteries_checkbox", "ar-setting", "section");
    
    
    register_setting("section", "oil_change_title");
    register_setting("section", "oil_change_content");
    register_setting("section", "brake_change_title");
    register_setting("section", "brake_change_content");
    register_setting("section", "brake_map_address");
    register_setting("section", "oil_map_address");
    register_setting("section", "brake_map_address_hidden");
    register_setting("section", "oil_map_address_hidden");
    
    register_setting("section", "tires_checkbox");
    register_setting("section", "tires_vehicle_checkbox");
    register_setting("section", "tires_tire_checkbox");
    register_setting("section", "oilchange_checkbox");
    register_setting("section", "brake_checkbox");
    register_setting("section", "alignment_checkbox");
    register_setting("section", "batteries_checkbox");
}
function auto_repair_search_new_excerpt_more($more) {
    return '...';
}
add_filter('excerpt_more', 'auto_repair_search_new_excerpt_more');

function auto_repair_search_handle_form_action(){
    //print_r($_POST);
    $list = array();
    $item = array();
    foreach($_POST['search'] as $key => $value){
        if($value != '' && $value != '0'){
            $item['taxonomy'] = htmlspecialchars($key);
            $item['terms'] = htmlspecialchars($value);
            $item['field'] = 'name';
            $list[] = $item;
        }
    }
    $cleanArray = array_merge(array('relation' => 'AND'), $list);
    $args['post_type'] = $_POST['type'];
    $args['showposts'] = 9;
    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
    $args['paged'] = $paged;
    $args['tax_query'] = $cleanArray;
    $args['post_status'] = 'publish';
    $the_query = new WP_Query( $args );
    echo ($the_query->found_posts > 0) ? '' : '<h3 class="foundPosts">We found no results</h3>';
        while ( $the_query->have_posts() ) : $the_query->the_post();
            //echo '<div><img src="'.the_post_thumbnail("thumbnail").'"> </div>';
            echo '<div>'.the_title().'</div>';
            //echo '<div>'.'<a href="'.get_permalink().'">Read</a>'.'</div>';
            $get_terms=wp_get_object_terms( get_the_ID(), 'product_price');
            echo '<div>'.'price is '.$get_terms[0]->name.'</div>';
           // print_r($get_terms);
            exit();
        endwhile;
    wp_reset_postdata();
    /*next_posts_link('&laquo; Older Entries', $the_query->max_num_pages) ."
    previous_posts_link('Newer Entries &raquo;') */
    exit();
}
function auto_repair_search_enqueue_scripts() {
    wp_enqueue_style( 'auto-repair-search-style', plugin_dir_url( __FILE__ ) . 'assets/css/plugin-style.css' );
    wp_enqueue_script( 'autorepair', plugin_dir_url( __FILE__ ) . 'assets/js/autorepair.js', array('jquery') );
    wp_localize_script( 'autorepair', 'ajax_object',array( 'ajax_url' => admin_url( 'admin-ajax.php' ) ) );
}
function auto_repair_search_main_plugin_menu(){
    global $submenu;
    add_menu_page( 'Auto repair', "Auto repair",'manage_options' , 'autorepair', 'auto_repair_search_setting', '', 10);
    add_submenu_page( 'autorepair', 'Add Car', 'Cars', 'manage_options', 'edit.php?post_type=addscars', NULL );
    add_submenu_page( 'autorepair', 'Tires', 'Tires', 'manage_options', 'edit.php?post_type=tires', NULL );
    add_submenu_page( 'autorepair', 'Batteries', 'Batteries', 'manage_options', 'edit.php?post_type=battery', NULL );
    add_submenu_page( 'autorepair', 'Alignment', 'Alignment', 'manage_options', 'edit.php?post_type=alignment', NULL );
    add_submenu_page( 'autorepair', 'Year', 'Year', 'manage_options', 'edit-tags.php?taxonomy=product_year', NULL );
    add_submenu_page( 'autorepair', 'Make', 'Make', 'manage_options', 'edit-tags.php?taxonomy=product_make', NULL );
    add_submenu_page( 'autorepair', 'Model', 'Model', 'manage_options', 'edit-tags.php?taxonomy=product_model', NULL );
    add_submenu_page( 'autorepair', 'Sub Model', 'Sub Model', 'manage_options', 'edit-tags.php?taxonomy=product_submodel', NULL );
    add_submenu_page( 'autorepair', 'Cross Section', 'Cross Section', 'manage_options', 'edit-tags.php?taxonomy=product_crosssection', NULL );
    add_submenu_page( 'autorepair', 'Aspect Ratio', 'Aspect Ratio', 'manage_options', 'edit-tags.php?taxonomy=product_aspectratio', NULL );
    add_submenu_page( 'autorepair', 'Rim Diameter', 'Rim Diameter', 'manage_options', 'edit-tags.php?taxonomy=product_rimdiameter', NULL );
    add_submenu_page("autorepair", "Setting", "Setting", "manage_options", "autorepair","auto_repair_search_settings_page");
    unset($submenu['autorepair'][0]);
}

function auto_repair_search_setting(){
    echo '';
}
function auto_repair_search_do_metaboxes(){
    global $post;
        add_meta_box( 'car-price', __( 'Price and category selection', 'auto-repair-search' ), 'auto_repair_search_metadata', array('tires','addscars','alignment','battery'), 'side', 'high');
        if(isset($post->post_type)){
            remove_meta_box( 'product_year'.'div', $post->post_type, 'side' );
            remove_meta_box( 'product_make'.'div', $post->post_type, 'side' );
            remove_meta_box( 'product_model'.'div', $post->post_type, 'side' );
            remove_meta_box( 'product_submodel'.'div', $post->post_type, 'side' );
        }
        add_meta_box( 'cross-section', __( 'Size selection', 'auto-repair-search' ), 'auto_repair_search_metadataFoeSize', array('tires'), 'side', 'high');
        if(isset($post->post_type)){
            remove_meta_box( 'product_price'.'div', $post->post_type, 'side' );
            remove_meta_box( 'product_crosssection'.'div', $post->post_type, 'side' );
            remove_meta_box( 'product_rimdiameter'.'div', $post->post_type, 'side' );
            remove_meta_box( 'product_aspectratio'.'div', $post->post_type, 'side' );
        }
    }
function auto_repair_search_add_catagory() {
    if(!taxonomy_exists('product_year')) {
        register_taxonomy(
            'product_year',array( 'addscars', 'tires','battery','alignment'  ),
            array(
                'hierarchical'  => true,
                'label'         =>  esc_html__( 'Year', 'auto-repair-search' ), 
                'query_var'     => true,
                'rewrite'       => array( 'slug' => 'product_year' )
            )
        );
    }
    if(!taxonomy_exists('product_make')) {

        register_taxonomy(
            'product_make', array( 'addscars', 'tires' ,'battery','alignment' ),
            array(
                'hierarchical'  => true,
                'label'         => esc_html__( 'Make', 'auto-repair-search' ), 
                'query_var'     => true,
                'rewrite'       => array( 'slug' => 'product_make' )
            )
        );
    }
    if(!taxonomy_exists('product_model')) {

        register_taxonomy(
            'product_model',array( 'addscars', 'tires','battery','alignment'  ),
            array(
                'hierarchical'  => true,
                'label'         => esc_html__( 'Model', 'auto-repair-search' ), 
                'query_var'     => true,
                'rewrite'       =>  array(  'slug' => 'product_model')
            )
        );
    }
    if(!taxonomy_exists('product_submodel')) {
        register_taxonomy(
            'product_submodel',array( 'addscars', 'tires','battery','alignment' ),
            array(
                'hierarchical'  => true,
                'label'         => esc_html__( 'Sub Model', 'auto-repair-search' ), 
                'query_var'     => true,
                'rewrite'       =>  array(  'slug' => 'product_submodel' )
            )
        );
    }
    if(!taxonomy_exists('product_price')) {
        register_taxonomy(
            'product_price',array( 'addscars', 'tires','battery','alignment' ),
            array(
                'hierarchical'  => true,
                'label'         => esc_html__( 'Price', 'auto-repair-search' ), 
                'query_var'     => true,
                'rewrite'       =>  array( 'slug' => 'product_price' )
            )
        );
    }
    if(!taxonomy_exists('product_crosssection')) {
        register_taxonomy(
            'product_crosssection',array('tires'),
            array(
                'hierarchical'  => true,
                'label'         => esc_html__( 'Cross Section', 'auto-repair-search' ),
                'query_var'     => true,
                'rewrite'       => array( 'slug' => 'crosssection')
            )
        );
    }
    if(!taxonomy_exists('product_aspectratio')) {
        register_taxonomy(
            'product_aspectratio',array( 'tires' ),
            array(
                'hierarchical'  => true,
                'label'         => esc_html__( 'Aspect Ratio', 'auto-repair-search' ),  
                'query_var'     => true,
                'rewrite'       => array( 'slug' => 'aspectratio' )
            )
        );
    }
    if(!taxonomy_exists('product_rimdiameter')) {
        register_taxonomy(
            'product_rimdiameter',array( 'tires'),
            array(
                'hierarchical'  => true,
                'label'         => esc_html__( 'Rim Diameter', 'auto-repair-search' ),
                'query_var'     => true,
                'rewrite'       =>  array(  'slug' => 'rimdiameter')
            )
        );
    }
}

function auto_repair_search_post_types() {
        $capability = 'manage_options';
        register_post_type( 'addscars', array(
                'label'           => __( 'Car', 'auto-repair-search' ),
                'description'     => '',
                'public'          => true,
                'show_ui'         => true,
                'show_in_menu'    => false,
                'capability_type' => 'post',
                'hierarchical'    => false,
                'rewrite'         => array('slug' => 'car'),
                'query_var'       => false,
                'taxonomies'      => array( 'car_categories' ),
                'supports'        => array(
                    'title',
                    'editor',
                    'revisions',
                    'thumbnail'
                ),
                'menu_icon'       => 'dashicons-sos',
                'capabilities'    => array(
                    'edit_post'          => $capability,
                    'read_post'          => $capability,
                    'delete_posts'       => $capability,
                    'edit_posts'         => $capability,
                    'edit_others_posts'  => $capability,
                    'publish_posts'      => $capability,
                    'read_private_posts' => $capability,
                    'create_posts'       => $capability,
                    'delete_post'        => $capability
                ),
                'labels'          => array(
                    'name'               => __( 'Car', 'auto-repair-search' ),
                    'singular_name'      => __( 'car', 'auto-repair-search' ),
                    'menu_name'          => __( 'Car', 'auto-repair-search' ),
                    'add_new'            => __( 'Add Car', 'auto-repair-search' ),
                    'add_new_item'       => __( 'Add New Car', 'auto-repair-search' ),
                    'edit'               => __( 'Edit', 'auto-repair-search' ),
                    'edit_item'          => __( 'Edit Car', 'auto-repair-search' ),
                    'new_item'           => __( 'New Car', 'auto-repair-search' ),
                    'view'               => __( 'View Car', 'auto-repair-search' ),
                    'view_item'          => __( 'View Car', 'auto-repair-search' ),
                    'search_items'       => __( 'Search Car', 'auto-repair-search' ),
                    'not_found'          => __( 'No Car Found', 'auto-repair-search' ),
                    'not_found_in_trash' => __( 'No Car found in trash', 'auto-repair-search' ),
                    'parent'             => __( 'Parent Car', 'auto-repair-search' )
                )
            )
        );



        register_post_type( 'tires', array(
                'label'           => __( 'Tires', 'auto-repair-search' ),
                'description'     => '',
                'public'          => true,
                'show_ui'         => true,
                'show_in_menu'    => false,
                'capability_type' => 'post',
                'hierarchical'    => false,
                'rewrite'         => array('slug' => 'tires'),
                'query_var'       => false,
                'taxonomies'      => array( 'tires_categories' ),
                'supports'        => array(
                    'title',
                    'editor',
                    'revisions',
                    'thumbnail'
                ),
                'menu_icon'       => 'dashicons-sos',
                'capabilities'    => array(
                    'edit_post'          => $capability,
                    'read_post'          => $capability,
                    'delete_posts'       => $capability,
                    'edit_posts'         => $capability,
                    'edit_others_posts'  => $capability,
                    'publish_posts'      => $capability,
                    'read_private_posts' => $capability,
                    'create_posts'       => $capability,
                    'delete_post'        => $capability
                ),
                'labels'          => array(
                    'name'               => __( 'Tires', 'auto-repair-search' ),
                    'singular_name'      => __( 'tire', 'auto-repair-search' ),
                    'menu_name'          => __( 'Tires', 'auto-repair-search' ),
                    'add_new'            => __( 'Add tires', 'auto-repair-search' ),
                    'add_new_item'       => __( 'Add New tires', 'auto-repair-search' ),
                    'edit'               => __( 'Edit', 'auto-repair-search' ),
                    'edit_item'          => __( 'Edit tires', 'auto-repair-search' ),
                    'new_item'           => __( 'New tires', 'auto-repair-search' ),
                    'view'               => __( 'View tires', 'auto-repair-search' ),
                    'view_item'          => __( 'View tires', 'auto-repair-search' ),
                    'search_items'       => __( 'Search tires', 'auto-repair-search' ),
                    'not_found'          => __( 'No tires Found', 'auto-repair-search' ),
                    'not_found_in_trash' => __( 'No tires found in trash', 'auto-repair-search' ),
                    'parent'             => __( 'Parent tires', 'auto-repair-search' )
                )
            )
        );

        register_post_type( 'battery', array(
                'label'           => __( 'Battery', 'auto-repair-search' ),
                'description'     => '',
                'public'          => true,
                'show_ui'         => true,
                'show_in_menu'    => false,
                'capability_type' => 'post',
                'hierarchical'    => false,
                'rewrite'         => array('slug' => 'battery'),
                'query_var'       => false,
                'taxonomies'      => array( 'battery_categories' ),
                'supports'        => array(
                    'title',
                    'editor',
                    'revisions',
                    'thumbnail'
                ),
                'menu_icon'       => 'dashicons-sos',
                'capabilities'    => array(
                    'edit_post'          => $capability,
                    'read_post'          => $capability,
                    'delete_posts'       => $capability,
                    'edit_posts'         => $capability,
                    'edit_others_posts'  => $capability,
                    'publish_posts'      => $capability,
                    'read_private_posts' => $capability,
                    'create_posts'       => $capability,
                    'delete_post'        => $capability
                ),
                'labels'          => array(
                    'name'               => __( 'battery', 'auto-repair-search' ),
                    'singular_name'      => __( 'battery', 'auto-repair-search' ),
                    'menu_name'          => __( 'battery', 'auto-repair-search' ),
                    'add_new'            => __( 'Add battery', 'auto-repair-search' ),
                    'add_new_item'       => __( 'Add New battery', 'auto-repair-search' ),
                    'edit'               => __( 'Edit', 'auto-repair-search' ),
                    'edit_item'          => __( 'Edit battery', 'auto-repair-search' ),
                    'new_item'           => __( 'New battery', 'auto-repair-search' ),
                    'view'               => __( 'View battery', 'auto-repair-search' ),
                    'view_item'          => __( 'View battery', 'auto-repair-search' ),
                    'search_items'       => __( 'Search batteries', 'auto-repair-search' ),
                    'not_found'          => __( 'No battery Found', 'auto-repair-search' ),
                    'not_found_in_trash' => __( 'No battery found in trash', 'auto-repair-search' ),
                    'parent'             => __( 'Parent battery', 'auto-repair-search' )
                )
            )
        );

        register_post_type( 'alignment', array(
                'label'           => __( 'alignment', 'auto-repair-search' ),
                'description'     => '',
                'public'          => true,
                'show_ui'         => true,
                'show_in_menu'    => false,
                'capability_type' => 'post',
                'hierarchical'    => false,
                'rewrite'         => array('slug' => 'alignment'),
                'query_var'       => false,
                'taxonomies'      => array( 'alignment_categories' ),
                'supports'        => array(
                    'title',
                    'editor',
                    'revisions',
                    'thumbnail'
                ),
                'menu_icon'       => 'dashicons-sos',
                'capabilities'    => array(
                    'edit_post'          => $capability,
                    'read_post'          => $capability,
                    'delete_posts'       => $capability,
                    'edit_posts'         => $capability,
                    'edit_others_posts'  => $capability,
                    'publish_posts'      => $capability,
                    'read_private_posts' => $capability,
                    'create_posts'       => $capability,
                    'delete_post'        => $capability
                ),
                'labels'          => array(
                    'name'               => __( 'Alignment', 'auto-repair-search' ),
                    'singular_name'      => __( 'alignment', 'auto-repair-search' ),
                    'menu_name'          => __( 'alignment', 'auto-repair-search' ),
                    'add_new'            => __( 'Add alignment', 'auto-repair-search' ),
                    'add_new_item'       => __( 'Add New alignment', 'auto-repair-search' ),
                    'edit'               => __( 'Edit', 'auto-repair-search' ),
                    'edit_item'          => __( 'Edit alignment', 'auto-repair-search' ),
                    'new_item'           => __( 'New alignment', 'auto-repair-search' ),
                    'view'               => __( 'View alignment', 'auto-repair-search' ),
                    'view_item'          => __( 'View alignment', 'auto-repair-search' ),
                    'search_items'       => __( 'Search alignment', 'auto-repair-search' ),
                    'not_found'          => __( 'No tires Found', 'auto-repair-search' ),
                    'not_found_in_trash' => __( 'No tires found in trash', 'auto-repair-search' ),
                    'parent'             => __( 'Parent alignment', 'auto-repair-search' )
                )
            )
        );

    }

function auto_repair_search_saveData( $post_id, $post ){
        $taxonomyarray=auto_repair_search_getTaxnomy();
        foreach($taxonomyarray as $key=>$taxonomy){
            if(isset($_POST[$taxonomy] )){
                if(term_exists( $_POST[$taxonomy] , $taxonomy)){
                    
                }else{
                    wp_insert_term( $_POST[$taxonomy] , $taxonomy);
                }
                wp_set_object_terms( $post_id, $_POST[$taxonomy] , $taxonomy );
            }

        }

        $getTaxnomySize=auto_repair_search_get_Taxnomy_Size();
        foreach($getTaxnomySize as $key=>$taxonomy){
            if(isset($_POST[$taxonomy] )){
                if(term_exists( $_POST[$taxonomy] , $taxonomy)){
                    
                }else{
                    wp_insert_term( $_POST[$taxonomy] , $taxonomy);
                }
                wp_set_object_terms( $post_id, $_POST[$taxonomy] , $taxonomy );
            }

        }
        
    }
    
function auto_repair_search_getTaxnomy(){
    return array('price'=>'product_price','year'=>'product_year','make'=>'product_make','model'=>'product_model','sub model'=>'product_submodel');
}
function auto_repair_search_get_Taxnomy_Without_Price(){
    return array('year'=>'product_year','make'=>'product_make','model'=>'product_model','sub model'=>'product_submodel');
}




function auto_repair_search_get_Taxnomy_Size(){
    return array('Cross Section'=>'product_crosssection','Aspect Ratio'=>'product_aspectratio','Rim Diameter'=>'product_rimdiameter');
}
function auto_repair_search_metadata($post_id){
    global $post;
    $taxonomyarray=auto_repair_search_getTaxnomy();
    foreach($taxonomyarray as $key=>$taxonomy){
        $get_terms=wp_get_object_terms( $post->ID, $taxonomy);
        if(!empty($get_terms)){
            $$taxonomy= $get_terms[0]->name;
        }else{
            $$taxonomy= '';
        }
        $all_categories = get_terms( $taxonomy, array( 'hide_empty' => false ) );
        echo '<label>Select '.ucwords($key).'</label>';
        auto_repair_search_dropDown_Html( $taxonomy, $$taxonomy, $all_categories );
    }
}

function auto_repair_search_metadataFoeSize($post_id){
    global $post;
    $taxonomyarray=auto_repair_search_get_Taxnomy_Size();
    foreach($taxonomyarray as $key=>$taxonomy){
        $get_terms=wp_get_object_terms( $post->ID, $taxonomy);
        if(!empty($get_terms)){
            $$taxonomy= $get_terms[0]->name;
        }else{
            $$taxonomy= '';
        }
        $all_categories = get_terms( $taxonomy, array( 'hide_empty' => false ) );
        echo '<label>Select '.ucwords($key).'</label>';
        auto_repair_search_dropDown_Html( $taxonomy, $$taxonomy, $all_categories );
    }
}


function auto_repair_search_dropDown_Html($select_drop_down_name, $selected_term_id, $all_categories){
    if($select_drop_down_name=="product_price"){
        echo'<input type="text" name="'.$select_drop_down_name.'" value="'.$selected_term_id.'" style="width:100%">';
    }else{
        ?>
        <div class="select-wrapper">
            <select name="<?php echo $select_drop_down_name;?>" class="widefat">
                <?php if ( count($all_categories) > 0 ) : ?>
                    <?php foreach ( $all_categories as $key => $value ) : ?>
                        <?php if ( $value->name == $selected_term_id ) : ?>
                            <option value="<?php echo $value->name;?>" selected="selected">
                                <?php echo $value->name;?>        
                            </option>
                        <?php else : ?>
                            <option value="<?php echo $value->name;?>">
                                <?php echo $value->name;?>
                            </option>
                        <?php endif;?>
                    <?php endforeach;?>
                <?php endif;?>
            </select>
        </div>

        <?php
    }
 }
function auto_repair_search_car_search_function( $atts ) {
    ob_start();
    include plugin_dir_path( __FILE__ ). '/view/index.php';
    $content = ob_get_clean();
    return $content;
}




function auto_repair_search_get_option_data(){
    if(isset($_POST['size'])){
        $taxonomy=auto_repair_search_get_Taxnomy_Size();
    }else{
        $taxonomy=auto_repair_search_get_Taxnomy_Without_Price();
    }
    $list = array();
    $item = array();
    foreach($_POST['search'] as $key => $value){
        if($value != '' && $value != '0'){
            $item['taxonomy'] = htmlspecialchars($key);
            $item['terms'] = htmlspecialchars($value);
            $item['field'] = 'name';
            
            $list[] = $item;
            $taxonomy = array_diff($taxonomy, array(htmlspecialchars($key)));
        }
    }
    $cleanArray = array_merge(array('relation' => 'AND'), $list);
    $args['post_type'] = $_POST['type'];
    $args['showposts'] = -1;
    $args['tax_query'] = $cleanArray;
    $args['post_status'] = 'publish';
    //$args['orderby'] = 'name';
    $the_query = new WP_Query( $args );
    $str='';
    $nameArray=array();
    while ( $the_query->have_posts() ) : $the_query->the_post();
        $post_term= wp_get_post_terms( get_the_ID(),  reset($taxonomy) ); 
        $nameArray[]=$post_term[0]->name;          
    endwhile;
     $nameArray=array_unique($nameArray);
     sort($nameArray);
     print_r($nameArray );
     foreach($nameArray as $name){
          $str.='<option class="ajax_get_option" value="'.$name.'">'.$name.'</option>'; 
     }
    
    echo $str;
    wp_reset_postdata();       
exit();

}
function auto_repair_search_dropDown_Html_Frontend($taxonomyarray,$post_type){
    global $wpdb;
    reset($taxonomyarray);
    $first_key = key($taxonomyarray);
    end($taxonomyarray);
    $last_key = key($taxonomyarray);
    $query = $wpdb->prepare(
        "SELECT t.*, COUNT(*) from $wpdb->terms AS t
        INNER JOIN $wpdb->term_taxonomy AS tt ON t.term_id = tt.term_id
        INNER JOIN $wpdb->term_relationships AS r ON r.term_taxonomy_id = tt.term_taxonomy_id
        INNER JOIN $wpdb->posts AS p ON p.ID = r.object_id
        WHERE p.post_type IN('%s') AND tt.taxonomy IN('%s')
        GROUP BY t.term_id",
        join( "', '", array($post_type) ),
        join( "', '", array(reset($taxonomyarray)) )
    );
    $results = $wpdb->get_results( $query ); 
    
    ?>
    <div class="form-group">
        <div class="select-wrapper">
            <select name="search[<?php echo reset($taxonomyarray) ?>]" class="input-custom search-value first-value">
                <option value="0"><?php echo esc_html__(ucwords($first_key),'auto-repair-search')   ?></option>
                <?php foreach ( $results as $key => $value ) : ?>
                    <option value="<?php echo $value->name;?>">
                        <?php echo $value->name;?>        
                    </option>
                <?php endforeach;?>
                <?php array_shift($taxonomyarray) ;?>
                 </select>
                </div>
            </div>
        <?php 
        foreach ( $taxonomyarray as $key => $value ) : 
            $add_class="";
            if ($key == $last_key) {
                $add_class="last-value";
            }
            echo'<div class="form-group">
            <div class="select-wrapper">
                <select name="search['.$value.']" class="input-custom search-value '.$add_class.'" disabled>
                    <option value="0"> '. esc_html__(ucwords($key),'auto-repair-search').'</option>
                     </select>
                    </div>
                </div>';
        endforeach;
        ?>
    <?php
}
