<?php
add_filter( 'pt-ocdi/import_files', function() {
    return array(
        array(
            'import_file_name'             => esc_html__('Elementor Demo 01 ', 'chaoz'),
            'local_import_file'            =>  plugin_dir_path( __FILE__ ). 'demo-data/demo4/contents.xml',
            'local_import_widget_file'     =>  plugin_dir_path( __FILE__ ). 'demo-data/demo4/widgets.wie',
			'import_preview_image_url'     => plugin_dir_url( __FILE__ ). 'demo-data/demo4/screen-image.png',
			'local_import_customizer_file' =>  plugin_dir_path( __FILE__ ). 'demo-data/demo4/customize.dat',
            'import_notice'                => esc_html__( 'Install and active all required plugins before you click on the "Yes! Important" button.', 'chaoz' ),
            'preview_url'                  => 'https://smartdata.tonytemplates.com/car-repair-service-v4/car1/',
            'local_import_redux'           => array(
                array(
                    'file_path'   =>  plugin_dir_path( __FILE__ ). 'demo-data/demo4/settings.json',
                    'option_name' => 'car_repair_services_opt',
                ),
            ),
        ),
        array(
            'import_file_name'             => esc_html__('Elementor Demo 02 ', 'chaoz'),
            'local_import_file'            =>  plugin_dir_path( __FILE__ ). 'demo-data/demo5/contents.xml',
            'local_import_widget_file'     =>  plugin_dir_path( __FILE__ ). 'demo-data/demo5/widgets.wie',
			'import_preview_image_url'     => plugin_dir_url( __FILE__ ). 'demo-data/demo5/screen-image.png',
			'local_import_customizer_file' =>  plugin_dir_path( __FILE__ ). 'demo-data/demo5/customize.dat',
            'import_notice'                => esc_html__( 'Install and active all required plugins before you click on the "Yes! Important" button.', 'chaoz' ),
            'preview_url'                  => 'https://smartdata.tonytemplates.com/car-repair-service-v4/car1/',
            'local_import_redux'           => array(
                array(
                    'file_path'   =>  plugin_dir_path( __FILE__ ). 'demo-data/demo5/settings.json',
                    'option_name' => 'car_repair_services_opt',
                ),
            ),
		),
    );
},15);


add_action( 'pt-ocdi/after_import', function() {
	$top_menu = get_term_by( 'name', 'Primary Menu', 'nav_menu' );
	$footer_menu = get_term_by('name', 'Footer Menu', 'nav_menu');
	if ( isset( $top_menu->term_id ) ) {
		set_theme_mod( 'nav_menu_locations', array(
                'theme_location' => 'primary',
				'primary' => $top_menu->term_id,
				'footer-menu'  => $footer_menu->term_id
			)
		);
	}
	$home_page = get_page_by_title( "Home" );
	update_option( 'page_on_front', $home_page->ID );
	update_option( 'show_on_front', 'page' );

	$blog_page = get_page_by_title( "Blog Posts" );
	update_option( 'page_for_posts', $blog_page->ID );
});
$token=get_option('envato_theme_license_token');
if($token!=''){
	add_filter( 'pt-ocdi/plugin_page_setup',  function() {
		return array(
		'parent_slug' => 'envato-theme-license-dashboard',
		'page_title'  => esc_html__( 'One Click Demo Import' , 'pt-ocdi' ),
		'menu_title'  => esc_html__( 'Import Demo Data' , 'pt-ocdi' ),
		'capability'  => 'manage_options',
		'menu_slug'   => 'envato-theme-license-one-click-demo-import',
		);
	});
}else{
    add_filter( 'pt-ocdi/plugin_page_setup',  function() {
		return array(
		'parent_slug' => '',
		'page_title'  =>'',
		'menu_title'  => '',
		'capability'  => '',
		'menu_slug'   => '',
		);
	});
}
add_filter( 'pt-ocdi/disable_pt_branding', '__return_true' );

