<?php
// Register Custom Post Type
function car_repair_services_coupons_post_type() {
	if ( function_exists( 'car_repair_services_options' ) ) {
		$car_repair_services = car_repair_services_options();
		if(isset($car_repair_services['theme_setting'])){
			$theme = $car_repair_services['theme_setting'];
		}else{
			$theme = '';
		}
		
	
		if($theme != '2'){

		$labels = array(
			'name'                  => _x( 'Coupons', 'Post Type General Name', 'car-repair-services' ),
			'singular_name'         => _x( 'Coupon', 'Post Type Singular Name', 'car-repair-services' ),
			'menu_name'             => __( 'Coupons', 'car-repair-services' ),
			'name_admin_bar'        => __( 'Coupon', 'car-repair-services' ),
			'archives'              => __( 'Item Archives', 'car-repair-services' ),
			'parent_item_colon'     => __( 'Parent Item:', 'car-repair-services' ),
			'all_items'             => __( 'All Coupons', 'car-repair-services' ),
			'add_new_item'          => __( 'Add New Coupon', 'car-repair-services' ),
			'add_new'               => __( 'Add New Coupon', 'car-repair-services' ),
			'new_item'              => __( 'New Service Item', 'car-repair-services' ),
			'edit_item'             => __( 'Edit Coupon Item', 'car-repair-services' ),
			'update_item'           => __( 'Update Coupon Item', 'car-repair-services' ),
			'view_item'             => __( 'View Coupon Item', 'car-repair-services' ),
			'search_items'          => __( 'Search Item', 'car-repair-services' ),
			'not_found'             => __( 'Not found', 'car-repair-services' ),
			'not_found_in_trash'    => __( 'Not found in Trash', 'car-repair-services' ),
			'featured_image'        => __( 'Featured Image', 'car-repair-services' ),
			'set_featured_image'    => __( 'Set featured image', 'car-repair-services' ),
			'remove_featured_image' => __( 'Remove featured image', 'car-repair-services' ),
			'use_featured_image'    => __( 'Use as featured image', 'car-repair-services' ),
			'insert_into_item'      => __( 'Insert into item', 'car-repair-services' ),
			'uploaded_to_this_item' => __( 'Uploaded to this item', 'car-repair-services' ),
			'items_list'            => __( 'Items list', 'car-repair-services' ),
			'items_list_navigation' => __( 'Items list navigation', 'car-repair-services' ),
			'filter_items_list'     => __( 'Filter items list', 'car-repair-services' ),
		);
		
		$args = array(
			'labels'             => $labels,
	        'description'        => __( 'Description.', 'car-repair-services' ),
			'public'             => true,
			'publicly_queryable' => true,
			'show_ui'            => true,
			'show_in_menu'       => true,
			'query_var'          => true,
			'rewrite'            => array( 'slug' => 'our-coupons' ),
			'capability_type'    => 'post',
			'has_archive'        => true,
			'hierarchical'       => false,
			'menu_position'      => null,
			'supports'              => array( 'title',  'thumbnail' ),
		);


		register_post_type( 'our-coupons', $args );
		}
	}
}
add_action( 'init', 'car_repair_services_coupons_post_type', 0 );