<?php
namespace CarRepairSerivces\Widgets;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Elementor\Group_Control_Background;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Repeater;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes;

class Services extends Widget_Base {

	public function get_name() {
		return 'crs_services';
	}

	public function get_title() {
		return __( 'Services', 'car-repair-services' );
	}

	public function get_icon() {
		return 'eicon-info-box';
	}

	public function get_categories() {
		return array( 'car-repair-services' );
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'crs_section_services',
			array(
				'label' => __( 'Services', 'car-repair-services' ),
			)
		);

		$this->add_control(
			'limit_per_tab',
			array(
				'label'   => __( 'Posts Per Tab', 'car-repair-services' ),
				'type'    => Controls_Manager::TEXT,
				'default' => 6,
			)
		);

		$this->add_control(
			'per_page',
			array(
				'label'   => __( 'Posts Per Page', 'car-repair-services' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 18,
			)
		);

		$this->add_control(
			'pagination',
			array(
				'label'   => __( 'Pagination', 'car-repair-services' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 1,
				'options' => array(
					1 => __( 'Yes', 'car-repair-services' ),
					0 => __( 'No', 'car-repair-services' ),
				),
			)
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'text_style_section',
			array(
				'label' => __( 'Text Style', 'car-repair-services-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'title_typography',
				'label'    => __( 'Title Typography', 'car-repair-services-core' ),
				'scheme'   => Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .services-block-alt .caption .title',
			)
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'content_typography',
				'label'    => __( 'Content Typography', 'car-repair-services-core' ),
				'scheme'   => Schemes\Typography::TYPOGRAPHY_1,
				'selector' => '{{WRAPPER}} .services-block-alt .caption .text',
			)
		);
		$this->end_controls_section();
	}

	protected function render() {

		$settings = $this->get_settings();
		$orderby  = 'DESC';
		$args     = array(
			'posts_per_page' => $settings['per_page'],
			'post_type'      => 'car_services',
			'orderby'        => $orderby,
			'no_found_rows'  => true,
		);

		$query         = new \WP_Query( $args );
		$rand          = rand( 000000, 999999 );
		$loop          = 1;
		$limit_per_tab = (int) $settings['limit_per_tab'];
		$pagination    = $settings['pagination'];

		?>
		<div class="block">
			<div class="container no-indent">
				<div class="tab-services hide-mobile">
					<div class="tab-content">
						<div class="row services-alt tab-pane fade in active" id="services<?php echo esc_attr( $loop ); ?>">
							<?php
							if ( $query->have_posts() ) {
								$totalfound = $query->post_count;
								while ( $query->have_posts() ) :
									$query->the_post();
									$post_id       = get_the_ID();
									$page_icon     = get_post_meta( get_the_ID(), 'framework-service-icon', true );
									$page_sub_head = get_post_meta( get_the_ID(), 'framework-service-page-sub-head', true );
									$page_icon_image = get_post_meta( get_the_ID(), 'framework-service-icon-image', true );
									?>
									<div class="col-xs-6 col-sm-6 col-md-4">
										<div class="services-block-alt">
											<div class="image">
												<a href="<?php the_permalink(); ?>" class="image-scale-color">
												<?php echo get_the_post_thumbnail( $post_id, 'car-repair-services-thumbnail' ); ?>
												</a>
												<?php if(empty($page_icon_image)){ ?>
												<i class="icon <?php echo esc_attr( $page_icon ); ?>"></i>
												<?php } else { ?>
												<i class="icon"><?php echo wp_get_attachment_image( $page_icon_image); ?></i>
												<?php } ?>
											</div>
											<div class="caption">
												<h3 class="title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
												<div class="text">
												<?php echo $page_sub_head; ?>
												</div>
											</div>
										</div>
									</div>
									<?php
									if ( $loop % $limit_per_tab == 0 && $pagination == 1 && $loop < $totalfound ) {
										$index = (int) ( $loop / $limit_per_tab ) + 1;
										echo '</div><div class="row services-alt tab-pane fade in" id="services' . esc_attr( $index ) . '">';
									}
									$loop++;
								endwhile;
							}
							?>
						</div>
					</div>
					<?php
					if ( $pagination == 1 ) :
						$total_pages = ceil( $totalfound / $limit_per_tab );
						if ( $total_pages > 1 ) {
							?>
							<ul class="nav nav-pills">
								<?php
								for ( $ii = 1; $ii <= $total_pages; $ii++ ) {
									$nav_active = '';
									if ( $ii == 1 ) {
										$nav_active = 'active';
									}
									?>
									<li class="<?php echo esc_attr( $nav_active ); ?>">
										<a data-toggle="pill" href="#services<?php echo esc_attr( $ii ); ?>"><?php echo esc_html( $ii ); ?></a>
									</li>
								<?php } ?>
							</ul>
							<?php
						}
					endif;
					?>
				</div>
				<div class="tab-services show-mobile">
				  
						<div class="row services-alt">
							<?php
							if ( $query->have_posts() ) {
								$totalfound = $query->post_count;
								while ( $query->have_posts() ) :
									$query->the_post();
									$post_id       = get_the_ID();
									$page_icon     = get_post_meta( get_the_ID(), 'framework-service-icon', true );
									$page_sub_head = get_post_meta( get_the_ID(), 'framework-service-page-sub-head', true );
									$page_icon_image = get_post_meta( get_the_ID(), 'framework-service-icon-image', true );
									?>
									<div class="col-xs-6 col-sm-6 col-md-4">
										<div class="services-block-alt">
											<div class="image">
												<a href="<?php the_permalink(); ?>" class="image-scale-color">
												<?php echo get_the_post_thumbnail( $post_id, 'car-repair-services-thumbnail' ); ?>
												</a>
												<?php if(empty($page_icon_image)){ ?>
												<i class="icon <?php echo esc_attr( $page_icon ); ?>"></i>
												<?php } else { ?>
												<i class="icon"><?php echo wp_get_attachment_image( $page_icon_image); ?></i>
												<?php } ?>
											</div>
											<div class="caption">
												<h3 class="title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
												<div class="text">
												<?php echo $page_sub_head; ?>
												</div>
											</div>
										</div>
									</div>
									<?php
									if ( $loop % $limit_per_tab == 0 && $pagination == 1 && $loop < $totalfound ) {
										$index = (int) ( $loop / $limit_per_tab ) + 1;
										echo '</div><div class="row services-alt tab-pane fade in" id="services' . esc_attr( $index ) . '">';
									}
									$loop++;
								endwhile;
							}
							?>
						</div>
					</div>
			
			</div>
		</div>
		<?php
	}
}

?>
