<?php
/**
 * Order Item Details
 *
 * @package WooCommerce\Templates
 * @version 5.2.0
 */

if ( ! defined( 'ABSPATH' ) ) exit;

if ( ! apply_filters( 'woocommerce_order_item_visible', true, $item ) ) return;
?>

<tr class="<?php echo esc_attr( apply_filters( 'woocommerce_order_item_class', 'woocommerce-table__line-item order_item', $item, $order ) ); ?>">
	<td class="woocommerce-table__product-name product-name">
		<?php
		$is_visible        = $product && $product->is_visible();
		$product_permalink = apply_filters( 'woocommerce_order_item_permalink', $is_visible ? $product->get_permalink( $item ) : '', $item, $order );

		echo wp_kses_post( apply_filters( 'woocommerce_order_item_name', $product_permalink ? sprintf( '<a href="%s">%s</a>', $product_permalink, $item->get_name() ) : $item->get_name(), $item, $is_visible ) );

		$qty          = $item->get_quantity();
		$refunded_qty = $order->get_qty_refunded_for_item( $item_id );

		if ( $refunded_qty ) {
			$qty_display = '<del>' . esc_html( $qty ) . '</del> <ins>' . esc_html( $qty - ( $refunded_qty * -1 ) ) . '</ins>';
		} else {
			$qty_display = esc_html( $qty );
		}

		echo apply_filters( 'woocommerce_order_item_quantity_html', ' <strong class="product-quantity">&times;&nbsp;' . $qty_display . '</strong>', $item );

		do_action( 'woocommerce_order_item_meta_start', $item_id, $item, $order, false );
		wc_display_item_meta( $item );
		do_action( 'woocommerce_order_item_meta_end', $item_id, $item, $order, false );

		
		// Custom Booking Fields
		$adults    = $item->get_meta('_adults');
		$children  = $item->get_meta('_children');
		$checkin   = $item->get_meta('_checkin');
		$checkout  = $item->get_meta('_checkout');
		$lis_id_raw = $item->get_meta('_listing_id');
		$lis_id_array = json_decode($lis_id_raw, true);

		$lis_id = is_array($lis_id_array) ? $lis_id_array[0] : $lis_id_raw;

		$listing_type_id = get_post_meta($lis_id, 'rz_listing_type', true);

	 	$listing_type_id = get_post_meta($lis_id, 'rz_listing_type', true);

		$action_types_json = get_post_meta($listing_type_id, 'rz_action_types', true);

		$action_types = json_decode($action_types_json, true);

		$first_template_id = '';

		if (is_array($action_types) && isset($action_types[0]['template']['id'])) {
    		$first_template_id = $action_types[0]['template']['id'];
		}
		

		// Output Booking Info
		if ($adults) {
			echo '<div><strong>' . esc_html__( 'Adults x', 'brikk' ) . ' ' . esc_html( $adults ) . '</strong></div>';
		}

		if ($children) {
			echo '<div><strong>' . esc_html__( 'Children x', 'brikk' ) . ' ' . esc_html( $children ) . '</strong></div>';
		}

		if (!empty($checkin)) {
			if ($first_template_id === 'booking_appointments') {
				echo '<div><strong>' . esc_html__( 'Checkin:', 'brikk' ) . '</strong> ' . esc_html( Rz()->local_datetime_i18n( $checkin ) ) . '</div>';
			} else {
				echo '<div><strong>' . esc_html__( 'Checkin:', 'brikk' ) . '</strong> ' . esc_html( date_i18n( wc_date_format(), $checkin ) ) . '</div>';
			}
		}

		if (!empty($checkout)) {
			if ($first_template_id === 'booking_appointments') {
				echo '<div><strong>' . esc_html__( 'Checkout:', 'brikk' ) . '</strong> ' . esc_html( Rz()->local_datetime_i18n( $checkout ) ) . '</div>';
			} else {
				echo '<div><strong>' . esc_html__( 'Checkout:', 'brikk' ) . '</strong> ' . esc_html( date_i18n( wc_date_format(), $checkout ) ) . '</div>';
			}
		}

		// Booking Summary
		$pricing = $item->get_meta('_pricing');
		if ( is_object($pricing) ) : ?>
			<table class="shop_table" style="margin-top: 15px; width: 100%; border-collapse: collapse;">
				<thead>
					<tr>
						<th colspan="2" style="text-align: left; background-color: black; padding: 8px; border: 1px solid #ddd;">
							<?php esc_html_e( 'Booking Summary', 'brikk' ); ?>
						</th>
					</tr>
				</thead>
				<tbody>
					<?php if (!empty($pricing->base)) : ?>
					<tr>
						<td style="padding: 8px; border: 1px solid #ddd;"><?php esc_html_e( 'Base Price:', 'brikk' ); ?></td>
						<td style="text-align: right; padding: 8px; border: 1px solid #ddd;"><?php echo wc_price($pricing->base); ?></td>
					</tr>
					<?php endif; ?>

					<?php if (!empty($pricing->guest_price)) : ?>
					<tr>
						<td style="padding: 8px; border: 1px solid #ddd;"><?php esc_html_e( 'Guest Price:', 'brikk' ); ?></td>
						<td style="text-align: right; padding: 8px; border: 1px solid #ddd;"><?php echo wc_price($pricing->guest_price); ?></td>
					</tr>
					<?php endif; ?>

					<?php if (!empty($pricing->child_price)) : ?>
					<tr>
						<td style="padding: 8px; border: 1px solid #ddd;"><?php esc_html_e( 'Child Price:', 'brikk' ); ?></td>
						<td style="text-align: right; padding: 8px; border: 1px solid #ddd;"><?php echo wc_price($pricing->child_price); ?></td>
					</tr>
					<?php endif; ?>

					<?php if (!empty($pricing->security_deposit)) : ?>
					<tr>
						<td style="padding: 8px; border: 1px solid #ddd;"><?php esc_html_e( 'Security Deposit:', 'brikk' ); ?></td>
						<td style="text-align: right; padding: 8px; border: 1px solid #ddd;"><?php echo wc_price($pricing->security_deposit); ?></td>
					</tr>
					<?php endif; ?>

					<?php if (!empty($pricing->service_fee)) : ?>
					<tr>
						<td style="padding: 8px; border: 1px solid #ddd;"><?php esc_html_e( 'Service Fee:', 'brikk' ); ?></td>
						<td style="text-align: right; padding: 8px; border: 1px solid #ddd;"><?php echo wc_price($pricing->service_fee); ?></td>
					</tr>
					<?php endif; ?>

					<?php if (!empty($pricing->extras_total)) : ?>
					<tr>
						<td style="padding: 8px; border: 1px solid #ddd;"><?php esc_html_e( 'Extra Service Total:', 'brikk' ); ?></td>
						<td style="text-align: right; padding: 8px; border: 1px solid #ddd;"><?php echo wc_price($pricing->extras_total); ?></td>
					</tr>
					<?php endif; ?>


					<?php if (!empty($pricing->addons_total)) : ?>
					<tr>
						<td style="padding: 8px; border: 1px solid #ddd;"><?php esc_html_e( 'Addons Total:', 'brikk' ); ?></td>
						<td style="text-align: right; padding: 8px; border: 1px solid #ddd;"><?php echo wc_price($pricing->addons_total); ?></td>
					</tr>
					<?php endif; ?>

					<?php if (!empty($pricing->payment_processing_name)) : ?>
					<tr>
					    <td style="padding: 8px; border: 1px solid #ddd;"><?php esc_html_e( 'Payment Process:', 'brikk' ); ?></td>
					    <td style="text-align: right; padding: 8px; border: 1px solid #ddd;">
					        <?php 
					        echo esc_html($pricing->payment_processing_name); 

					        // if type is percentage code by ashwani
					        if ( isset($pricing->payment_processing) && $pricing->payment_processing === 'percentage' && ! empty($pricing->total) ) {
					            $percentage = ($pricing->processing / $pricing->total) * 100;
					            echo ' (' . round($percentage, 2) . '%)';
					        }
					        ?>
					    </td>
					</tr>
					<?php endif; ?>


						<?php if (!empty($pricing->total)) : ?>
						<tr>
							<th style="padding: 8px; border: 1px solid #ddd;"><?php esc_html_e( 'Booking Total:', 'brikk' ); ?></th>
							<th style="text-align: right; padding: 8px; border: 1px solid #ddd;"><?php echo wc_price($pricing->total); ?></th>
						</tr>
						<?php endif; ?>
				</tbody>
			</table>
		<?php endif; ?>
	</td>
</tr>

<?php if ( $show_purchase_note && $purchase_note ) : ?>
<tr class="woocommerce-table__product-purchase-note product-purchase-note">
	<td colspan="2"><?php echo wpautop( do_shortcode( wp_kses_post( $purchase_note ) ) ); ?></td>
</tr>
<?php endif; ?>
