<?php
/**
 * The template part for displaying single post sortable sections
 *
 * @package BoomBox_Theme
 * @since   2.0.0
 * @version 2.0.0
 */

// Prevent direct script access.
if ( ! defined( 'ABSPATH' ) ) {
	die( 'No direct script access allowed' );
}

$sections = boombox_get_single_sortable_sections();
foreach ( $sections as $section ) {
	switch ( $section ) {
		case 'reactions':
			if ( 'post' == get_post_type() ) {
				do_action( 'boombox/single/sortables/before_reactions' );
				get_template_part( 'template-parts/single/reaction', 'vote' );
				do_action( 'boombox/single/sortables/after_reactions' );
			}

			break;
		case 'author_info':
			if ( 'post' == get_post_type() ) {
				do_action( 'boombox/single/sortables/before_author_info' );
				boombox_post_author_expanded_info();
				do_action( 'boombox/single/sortables/after_author_info' );
			}

			break;
		case 'comments':
			if ( comments_open() || get_comments_number() ) {
				do_action( 'boombox/single/sortables/before_comments' );
				echo '<div id="boombox_comments" class="mb-md">';
				comments_template();
				echo '</div>';
				do_action( 'boombox/single/sortables/after_comments' );
			}

			break;
		case 'navigation':
			do_action( 'boombox/single/sortables/before_navigation' );
			get_template_part( 'template-parts/single/navigation' );
			do_action( 'boombox/single/sortables/after_navigation' );

			break;
		case 'related_posts':
			if ( 'post' == get_post_type() ) {
				do_action( 'boombox/single/sortables/before_related_posts' );
				get_template_part( 'template-parts/single/posts', 'related' );
				do_action( 'boombox/single/sortables/after_related_posts' );
			}
			break;
		case 'more_from_posts':
			if ( 'post' == get_post_type() ) {
				do_action( 'boombox/single/sortables/before_more_from_posts' );
				get_template_part( 'template-parts/single/posts', 'more-from' );
				do_action( 'boombox/single/sortables/after_more_from_posts' );
			}

			break;
		case 'dont_miss_posts':
			if ( 'post' == get_post_type() ) {
				do_action( 'boombox/single/sortables/before_dont_miss_posts' );
				get_template_part( 'template-parts/single/posts', 'dont-miss' );
				do_action( 'boombox/single/sortables/after_dont_miss_posts' );
			}
			break;
		case 'subscribe_form':
			do_action( 'boombox/single/sortables/before_subscribe_form' );
			boombox_mailchimp_form();
			do_action( 'boombox/single/sortables/before_subscribe_form' );
			break;
		default:
			if( $section ){
				do_action( 'boombox/single/sortables/' . $section );
			}
	}
}