<?php
/**
 * The template part for displaying the single post header section
 *
 * @package BoomBox_Theme
 * @since   1.0.0
 * @version 2.0.0
 *
 * @var $template_helper Boombox_Single_Post_Template_Helper Template Helper
 */

// Prevent direct script access.
if ( ! defined( 'ABSPATH' ) ) {
	die( 'No direct script access allowed' );
}

$template_helper = Boombox_Template::init( 'post' );
$template_options = $template_helper->get_hide_elements_options();

/***** badges list */
if ( $template_options[ 'badges' ] ) {
	$badges_list = boombox_get_post_badge_list( array( 'post_id' => get_the_ID(), 'badges_count' => 4 ) );
	echo $badges_list[ 'badges' ];
}

/***** categories list */
if ( $template_options[ 'categories' ] ) {
	boombox_categories_list();
}

the_title( '<h1 class="entry-title" itemprop="headline">', '</h1>' );

/***** sub title */
if ( $template_options[ 'subtitle' ] ) {
	echo boombox_get_post_subtitle();
}

get_template_part( 'template-parts/content', 'affiliate' ); ?>