<?php
/**
 * The template part for displaying the share buttons section
 *
 * @package BoomBox_Theme
 * @since   1.0.0
 * @version 2.0.0
 */

// Prevent direct script access.
if ( ! defined( 'ABSPATH' ) ) {
	die( 'No direct script access allowed' );
}
$boombox_post_share_box_elements = boombox_get_theme_option( 'single_post_general_share_box_elements' );
$boombox_post_share_buttons = ( boombox_plugin_management_service()->is_plugin_active( 'mashsharer/mashshare.php' ) || function_exists( 'essb_core' ) );
$show_share = $show_points = $show_comments = false;
?>

<div class="content <?php echo $boombox_post_share_buttons ? 'has-share-buttons' : ''; ?>">
	<?php

	if ( ! empty( $boombox_post_share_box_elements ) ):

		$show_share = in_array( 'share_count', $boombox_post_share_box_elements );
		if ( $show_share && ( boombox_plugin_management_service()->is_plugin_active( 'mashsharer/mashshare.php' ) || boombox_plugin_management_service()->is_plugin_active( 'easy-social-share-buttons3/easy-social-share-buttons3.php' ) ) ) :
			boombox_post_share_count( true, true, 'share-box' );
		endif;

		$show_points = in_array( 'points', $boombox_post_share_box_elements );
		if ( $show_points ) :
			boombox_post_points();
		endif;

		$show_comments = ( comments_open() && in_array( 'comments', $boombox_post_share_box_elements ) );
		if ( $show_comments ) :
			boombox_post_comments();
		endif;

	endif;

	if ( $boombox_post_share_buttons ) :
		boombox_post_share_buttons();
		boombox_post_share_mobile_buttons( $show_comments, $show_share, $show_points );
	endif;
	?>
</div>

