<?php
/**
 * The template part for displaying the Next/Prev buttons
 *
 * @package BoomBox_Theme
 * @since   1.0.0
 * @version 2.0.0
 */

// Prevent direct script access.
if ( ! defined( 'ABSPATH' ) ) {
	die( 'No direct script access allowed' );
}

global $page, $numpages;
boombox_single_post_link_pages( array(
	'before'             => sprintf( '<nav class="next-prev-pagination %s">', ( $numpages <= 1 ) ? 'no-pages' : '' ),
	'after'              => '</nav>',
	'link_before'        => '',
	'link_after'         => '',
	'reverse'            => ( boombox_get_theme_option( 'single_post_general_navigation_direction' ) == 'to-oldest' ),
	'link_wrap_before'   => '<span class="nav %s">',
	'link_wrap_after'    => '</span>',
	'go_to_prev_next'    => boombox_get_theme_option( 'single_post_general_next_prev_buttons' ),
	'paging'             => sprintf( '<span class="pages"><span>%1$d</span> / %2$d</span>', $page, $numpages ),
	'previous_page_link' => sprintf( '<i class="icon icon-chevron-left"></i><span class="text">%1$s</span><span class="mobile-text">%2$s</span>', esc_html__( 'Previous Page', 'boombox' ), esc_html__( 'Previous', 'boombox' ) ),
	'next_page_link'     => sprintf( '<i class="icon icon-chevron-right"></i><span class="text">%1$s</span><span class="mobile-text">%2$s</span>', esc_html__( 'Next Page', 'boombox' ), esc_html__( 'Next', 'boombox' ) ),
	'previous_post_link' => sprintf( '<i class="icon icon-chevron-left"></i><span class="text">%1$s</span><span class="mobile-text">%2$s</span>', esc_html__( 'Previous Post', 'boombox' ), esc_html__( 'Previous', 'boombox' ) ),
	'next_post_link'     => sprintf( '<i class="icon icon-chevron-right"></i><span class="text">%1$s</span><span class="mobile-text">%2$s</span>', esc_html__( 'Next Post', 'boombox' ), esc_html__( 'Next', 'boombox' ) ),
) );