<?php
/**
 * The template part for displaying single post content
 * @package BoomBox_Theme
 * @since   1.0.0
 * @version 2.0.4
 *
 * @var $template_helper Boombox_Single_Post_Template_Helper Template Helper
 */

// Prevent direct script access.
if ( ! defined( 'ABSPATH' ) ) {
	die( 'No direct script access allowed' );
}

$template_helper = Boombox_Template::init( 'post' );
$featured_image_size = 'boombox_image768';
$template_options = $template_helper->get_options( $featured_image_size );
$has_post_thumbnail = boombox_has_post_thumbnail();
$show_media = apply_filters( 'boombox/single/show_media',
	( $template_options[ 'media' ]
		&& boombox_show_thumbnail() &&
		( $has_post_thumbnail || $template_options[ 'featured_video' ] )
	)
);
?>

<article
		id="post-<?php the_ID(); ?>" <?php post_class( $template_options[ 'classes' ] ); ?> <?php
boombox_single_article_structured_data(); ?>>

	<header class="entry-header">
		<?php get_template_part( 'template-parts/single/single', 'header' ); ?>
		<hr/>
	</header>

	<div class="post-meta-info">
		<?php if ( $template_options[ 'author' ] || $template_options[ 'date' ] ||
			$template_options[ 'views' ] || $template_options[ 'comments_count' ]
		) { ?>
			<div class="post-meta row">
				<div class="col-md-6 col-sm-6">
					<div class="author-meta">
						<?php
						boombox_post_author( array( 'display' => $template_options[ 'author' ], 'with_avatar' => true, 'microdata' => true ) );
						boombox_post_date( array( 'display' => $template_options[ 'date' ] ) );
						?>
					</div>
				</div>
				<div class="col-md-6 col-sm-6">
					<div class="view-meta">
						<?php if ( $template_options[ 'comments_count' ] ) {
							boombox_post_comments();
						}
						if ( $template_options[ 'views' ] ) {
							boombox_show_post_views();
						} ?>
					</div>
				</div>
			</div>
			<?php if ( ! $template_options[ 'enable_primary_sidebar' ] ) { ?>
				<hr/>
			<?php }
		}

		if ( $template_options[ 'share_bars' ][ 'top' ][ 'enable' ] ) {
		echo $template_options[ 'share_bars' ][ 'top' ][ 'before' ]; ?>
		<div id="sticky-share-box"
		     class="post-share-box top <?php echo $template_options[ 'share_bars' ][ 'top' ][ 'class' ]; ?>">
			<?php get_template_part( 'template-parts/single/share', 'box' ); ?>
		</div>
		<?php
			echo $template_options[ 'share_bars' ][ 'top' ][ 'after' ];
		} ?>
	</div>

	<?php
	/* Show NSFW message, if is NSFW post */
	if ( $template_options[ 'is_nsfw' ] && ! is_user_logged_in() && boombox_is_auth_allowed() ) {
		printf( '<a href="%1$s" class="entry-nsfw js-authentication" >%2$s</a>',
			esc_url( '#sign-in' ),
			boombox_get_nsfw_message()
		);
	}

	$post_thumbnail_html = '';
	if ( ! $template_options[ 'is_nsfw' ] || ( $template_options[ 'is_nsfw' ] && is_user_logged_in() ) ) {

		if ( $show_media ) { ?>
			<!-- thumbnail -->
			<div class="post-thumbnail">
				<?php
				if ( $template_options[ 'featured_video' ] ) {
					echo $template_options[ 'featured_video' ];
				} else if ( $has_post_thumbnail ) {
					$post_thumbnail_html = get_the_post_thumbnail( NULL, $featured_image_size, array( 'play' => true, 'template' => 'single' ) );
					echo $post_thumbnail_html;
					echo boombox_get_post_thumbnail_caption();
				} ?>
			</div>
			<!-- thumbnail -->
		<?php } ?>

		<!-- entry-content -->
		<div itemprop="articleBody" class="entry-content">
			<?php
			if ( is_attachment() ) {
				echo wp_get_attachment_image( get_the_ID(), 'full' );
			} else {
				echo '<!-- Start Content -->';
				the_content();
				echo '<!-- End Content -->';
			}
			get_template_part( 'template-parts/single/next-prev-buttons' );
			boombox_the_advertisement( 'boombox-single-after-next-prev-buttons', array( 'class' => 'large bb-after-next-prev-btns' ) ); ?>
		</div>
		<?php
	} ?>

	<footer class="entry-footer">

		<?php
		if ( ! $post_thumbnail_html && $has_post_thumbnail ) {
			$post_thumbnail_html = get_the_post_thumbnail( NULL, $featured_image_size, array( 'play' => true ) );
		}
		do_action( 'boombox/single/microdata', array(
			'post_thumbnail_html' => $post_thumbnail_html,
		) );
		?>

		<hr/>
		<?php if ( $template_options[ 'tags' ] ) {
			boombox_tags_list();
		} ?>
		<?php if ( $template_options[ 'share_bars' ][ 'bottom' ][ 'enable' ] ) {
			echo $template_options[ 'share_bars' ][ 'bottom' ][ 'before' ]; ?>
			<div class="post-share-box bottom <?php echo $template_options[ 'share_bars' ][ 'bottom' ][ 'class' ]; ?>">
				<?php do_action( 'boombox/single/text_before_share' ); ?>
				<?php get_template_part( 'template-parts/single/share', 'box' ); ?>
			</div>
			<?php
			echo $template_options[ 'share_bars' ][ 'bottom' ][ 'after' ];
		} ?>
	</footer>

</article>