<?php
/**
 * The template part for displaying the login form.
 *
 * @package BoomBox_Theme
 * @since   1.0.0
 * @version 2.0.0
 */

// Prevent direct script access.
if ( ! defined( 'ABSPATH' ) ) {
	die( 'No direct script access allowed' );
}

$auth_captcha_type = boombox_get_auth_captcha_type();
$options_set = boombox_get_theme_options_set( array(
	'extra_authentication_login_popup_title',
	'extra_authentication_login_popup_text',
	'extra_authentication_registration_popup_title',
	'extra_authentication_enable_login_captcha',
	'extra_authentication_google_recaptcha_site_key',
	'extra_authentication_registration_custom_url',
) ); ?>

<div class="light-modal-bg"></div>

<!-- Modal content -->
<div id="sign-in" class="light-modal sign-in authentication">
	<a href="#" class="modal-close"><i class="icon icon-close"></i></a>
	<div class="modal-body wrapper">
		<div class="content-wrapper">
			<header class="content-header">
				<?php if ( $options_set[ 'extra_authentication_login_popup_title' ] ): ?>
					<h3 class="title"><?php echo esc_html( $options_set[ 'extra_authentication_login_popup_title' ] ); ?></h3>
				<?php endif; ?>

				<?php if ( $options_set[ 'extra_authentication_login_popup_text' ] ): ?>
					<div class="intro"><?php echo wp_kses_post( $options_set[ 'extra_authentication_login_popup_text' ] ); ?></div>
				<?php endif; ?>
			</header>
			<div class="content-body">
				<?php if ( boombox_plugin_management_service()->is_plugin_active( 'wordpress-social-login/wp-social-login.php' ) ) { ?>
					<?php do_action( 'wordpress_social_login' ); ?>
				<?php } else { ?>
					<div class="clearfix"><?php do_action( 'boombox_before_login_form', 'login' ); ?></div>
				<?php } ?>

				<p class="status"></p>

				<form id="boombox-login" class="ajax-auth" action="login" method="post">
					<?php wp_nonce_field( 'ajax-login-nonce', 'security' ); ?>
					<div class="input-field">
						<input type="text" name="useremail" class="required"
						       placeholder="<?php esc_html_e( 'Your username or e-mail', 'boombox' ); ?>">
					</div>
					<div class="input-field">
						<input type="password" name="password" class="required"
						       placeholder="<?php esc_html_e( 'Your password', 'boombox' ); ?>">
					</div>
					<div class="input-field">
						<a class="reset-password-link js-authentication"
						   href="#reset-password"><?php esc_html_e( 'Forgot password?', 'boombox' ); ?></a>
					</div>

					<?php if ( $options_set[ 'extra_authentication_enable_login_captcha' ] ) { ?>

						<?php if ( $auth_captcha_type === 'image' ) { ?>
							<div class="input-field captcha-container loading">
								<div class="form-captcha">
									<img src="" alt="Captcha!" class="captcha">
									<a href="#refresh-captcha" class="auth-refresh-captcha refresh-captcha"></a>
								</div>
								<input type="text" class="required" name="captcha-code"
								       placeholder="<?php esc_html_e( 'Enter captcha', 'boombox' ); ?>">
							</div>
						<?php } else if ( $auth_captcha_type === 'google' && $options_set[ 'extra_authentication_google_recaptcha_site_key' ] ) { ?>
							<div class="input-field text-center">
								<div class="google-captcha-code" id="boombox-login-captcha"
								     data-boombox-sitekey="<?php echo $options_set[ 'extra_authentication_google_recaptcha_site_key' ]; ?>"></div>
							</div>
						<?php } ?>
					<?php } ?>
					<div class="input-field">
						<button class="bb-btn" type="submit"><?php esc_html_e( 'log in', 'boombox' ); ?></button>
					</div>
				</form>
				<?php do_action( 'boombox_after_login_form' ); ?>
			</div>
			<?php if ( boombox_user_can_register() ): ?>
				<div class="content-footer">
					<div class="bottom">
						<div class="text"><?php esc_html_e( 'Don\'t have an account?', 'boombox' ); ?></div>
						<?php
						$custom_registration_url = $options_set[ 'extra_authentication_registration_custom_url' ];
						$registration_url = '#registration';
						if ( $custom_registration_url && filter_var( $custom_registration_url, FILTER_VALIDATE_URL ) ) {
							$registration_url = $custom_registration_url;
						}
						$btn_class = ( $registration_url == '#registration' ) ? 'js-authentication' : '';
						?>
						<a class="bb-btn bb-btn-default <?php echo $btn_class; ?>"
						   href="<?php echo $registration_url; ?>">
							<?php echo esc_html( $options_set[ 'extra_authentication_registration_popup_title' ] ); ?>
						</a>
					</div>
				</div>
			<?php endif; ?>
		</div>
	</div>
</div>
