<?php
/**
 * The template part for displaying "Next/Prev buttons" pagination.
 *
 * @package BoomBox_Theme
 * @since   1.0.0
 * @version 2.0.0
 */

// Prevent direct script access.
if ( ! defined( 'ABSPATH' ) ) {
	die( 'No direct script access allowed' );
}

$has_prev = ( NULL !== get_previous_posts_link() );
$has_next = ( NULL !== get_next_posts_link() );
?>
<?php if ( $has_prev || $has_next ) { ?>
	<div class="next-prev-pagination no-pages">

    <span class="nav prev-page <?php echo $has_prev ? '' : 'disabled'; ?>">
        <a href="<?php echo $has_prev ? esc_url( get_previous_posts_page_link() ) : '#'; ?>" rel="prev">
            <i class="icon icon-chevron-left"></i>
            <span class="text"><?php esc_html_e( 'Previous', 'boombox' ); ?></span>
            <span class="mobile-text"><?php esc_html_e( 'Previous', 'boombox' ); ?></span>
        </a>
    </span>

		<span class="nav next-page <?php echo $has_next ? '' : 'disabled'; ?>">
        <a href="<?php echo $has_next ? esc_url( get_next_posts_page_link() ) : '#'; ?>" rel="next">
            <i class="icon icon-chevron-right"></i>
            <span class="text"><?php esc_html_e( 'Next', 'boombox' ); ?></span>
            <span class="mobile-text"><?php esc_html_e( 'Next', 'boombox' ); ?></span>
        </a>
    </span>

	</div>
<?php } ?>