<?php
/**
 * The template part for displaying the site header bottom navigation
 *
 * @package BoomBox_Theme
 * @since   2.0.0
 * @version 2.0.0
 */

// Prevent direct script access.
if ( ! defined( 'ABSPATH' ) ) {
	die( 'No direct script access allowed' );
}

if ( has_nav_menu( 'bottom_header_nav' ) ) { ?>
	<nav class="main-navigation">
		<?php
		wp_nav_menu( array(
			'theme_location' => 'bottom_header_nav',
			'menu_class'     => '',
			'container'      => false,
			'walker'         => new Boombox_Walker_Nav_Menu_Custom_Fields(),
		) );
		?>
	</nav>
	<?php
	if ( boombox_get_theme_option( 'header_layout_more_menu_position' ) == 'bottom' ) {
		get_template_part( 'template-parts/header/components/more-menu-icons' );
	}
} ?>