<?php
/**
 * The template part for displaying featured area item
 *
 * @package BoomBox_Theme
 * @since   2.0.0
 * @version 2.0.0
 *
 * @var $template_helper Boombox_Featured_Area_Template_Helper  Template Helper
 */
$template_helper = Boombox_Template::init( 'featured-area' );
$template_options = $template_helper->get_options();

$boombox_title = get_the_title();
if ( boombox_has_post_thumbnail() ) {
	$boombox_thumbnail_url = wp_get_attachment_image_src( get_post_thumbnail_id(), $template_options[ 'image_size' ] );
	$boombox_thumbnail_url = ! empty( $boombox_thumbnail_url ) ? $boombox_thumbnail_url[ 0 ] : boombox_get_post_dafault_thumbnail_url( $template_options[ 'image_size' ] );
	$boombox_thumb_style = $boombox_thumbnail_url ? sprintf( 'style="background-image:url(\'%s\')"', esc_url( $boombox_thumbnail_url ) ) : '';
} else {
	$boombox_thumb_style = '';
	$boombox_thumbnail_url = boombox_get_post_dafault_thumbnail_url( $template_options[ 'image_size' ] );
} ?>

<article class="featured-item" <?php echo $boombox_thumb_style; ?>>
	<?php if ( $boombox_thumbnail_url ) { ?>
		<figure class="featured-media">
			<a href="<?php echo esc_url( get_permalink() ); ?>" class="featured-link">
				<img class="mf-hide" src="<?php echo $boombox_thumbnail_url; ?>" alt="<?php echo $boombox_title; ?>"
				     title="<?php echo $boombox_title; ?>"/>
			</a>
		</figure>
	<?php } ?>

	<header class="featured-header">
		<div class="featured-caption">
			<div class="post-meta">
				<?php
				if ( $template_options[ 'share_count' ] ) {
					boombox_post_share_count();
				}
				boombox_post_view_vote_count( get_the_ID(), array(
					'show_views' => $template_options[ 'views_count' ],
					'show_votes' => $template_options[ 'votes_count' ],
				) );
				?>
			</div>

			<?php if ( $template_options[ 'post_title' ] ) { ?>
				<h2 class="entry-title">
					<a href="<?php echo esc_url( get_permalink() ); ?>" rel="bookmark"><?php the_title(); ?></a>
				</h2>
			<?php } ?>

			<?php if ( $template_options[ 'author' ] ) { ?>
				<span class="byline">
					<span class="author vcard">
						<span class="fn n"><?php esc_html_e( 'by', 'boombox' ); ?>
							&nbsp;<?php the_author_posts_link(); ?></span>
					</span>
				</span>
			<?php }

			if ( $template_options[ 'date' ] ) {
				boombox_post_date();
			} ?>
		</div>
	</header>

	<?php if ( $template_options[ 'badges' ] ) {
		$badges_list = boombox_get_post_badge_list( array(
			'post_id'      => get_the_ID(),
			'badges_count' => $template_options[ 'badges_count' ],
		) );
		if ( $badges_list[ 'badges' ] ) { ?>
			<div class="featured-badge-list">
				<?php echo $badges_list[ 'badges' ]; ?>
			</div>
		<?php }
	} ?>
</article>