<?php
/**
 * The template part for displaying post item for "grid-2-1" listing type
 *
 * @package BoomBox_Theme
 * @since   1.0.0
 * @version 2.0.0
 */

// Prevent direct script access.
if ( ! defined( 'ABSPATH' ) ) {
	die( 'No direct script access allowed' );
}

$listing_type = 'content-grid-2-1';
$featured_image_size = 'boombox_image360x180';
$post_classes = 'post bb-card-item';
$has_post_thumbnail = boombox_has_post_thumbnail();
$template_options = Boombox_Template::init( 'collection-item' )->get_options();
$show_media = apply_filters( 'boombox/loop-item/show-media', ( $template_options[ 'media' ] && $has_post_thumbnail ), $template_options[ 'media' ], $has_post_thumbnail, $listing_type );

if ( ! $show_media ) {
	$post_classes .= ' no-thumbnail';
}

if ( $template_options[ 'badges' ] || $template_options[ 'post_type_badges' ] ) {
	$badges_list = boombox_get_post_badge_list();
}

$permalink = get_permalink();
$url = apply_filters( 'boombox_loop_item_url', $permalink, get_the_ID() );
$target = apply_filters( 'boombox_loop_item_url_target', '', $permalink, $url );
$rel = apply_filters( 'boombox_loop_item_url_rel', '', $permalink, $url );

do_action( 'boombox/loop-item/before-content', $listing_type ); ?>

	<li class="post-item">
		<article id="post-<?php the_ID(); ?>" <?php post_class( $post_classes ); ?>>

			<div class="post-thumbnail">
				<?php

				if ( apply_filters( 'boombox/loop-item/show-box-index', false ) ) {
					get_template_part( 'template-parts/numeric', 'badge' );
				}

				if ( apply_filters( 'boombox/loop-item/show-badges', $template_options[ 'badges' ] ) ) {
					echo $badges_list[ 'badges' ];
				}

				if ( $show_media ) { ?>

					<a href="<?php echo $url; ?>"
					   title="<?php echo esc_attr( the_title_attribute( array( 'echo' => false ) ) ); ?>" <?php echo $target; ?> <?php echo $rel; ?>>
						<?php the_post_thumbnail( $featured_image_size, array( 'template' => 'listing', 'listing_type' => $listing_type ) ); ?>
					</a>

					<div class="post-meta">
						<?php

						if ( apply_filters( 'boombox/loop-item/show-post-vote-count', true ) ) {
							boombox_post_view_vote_count( get_the_ID(), array( 'show_views' => $template_options[ 'views_count' ], 'show_votes' => $template_options[ 'votes_count' ] ) );
						}

						if ( apply_filters( 'boombox/loop-item/show-share-count', $template_options[ 'share_count' ] ) ) {
							boombox_post_share_count();
						} ?>
					</div>

					<?php if ( apply_filters( 'boombox/loop-item/show-post-type-badges', $template_options[ 'post_type_badges' ] ) ) {
						echo $badges_list[ 'post_type_badges' ];
					}
				} ?>

			</div>

			<div class="content">
				<header class="entry-header">
					<?php

					do_action( 'boombox/loop-item/content-start' );

					if ( apply_filters( 'boombox/loop-item/show-categories', $template_options[ 'categories' ] ) ) {
						boombox_categories_list();
					}

					if ( apply_filters( 'boombox/loop-item/show-comments-count', ( comments_open() && $template_options[ 'comments_count' ] ) ) ) {
						boombox_post_comments();
					}

					the_title( sprintf( '<h2 class="entry-title"><a href="%1$s" rel="bookmark" %2$s %3$s>', $url, $target, $rel ), '</a></h2>' );

					if ( apply_filters( 'boombox/loop-item/show-subtitle', $template_options[ 'subtitle' ] ) ) {
						echo boombox_get_post_subtitle();
					}

					get_template_part( 'template-parts/content', 'affiliate' );

					if ( apply_filters( 'boombox/loop-item/show-post-author-meta', true ) ) {
						boombox_post_author_meta( array(
							'author'      => $template_options[ 'author' ],
							'author_args' => array( 'with_avatar' => true ),
							'date'        => $template_options[ 'date' ],
						) );
					}

					do_action( 'boombox/loop-item/content-end' );
					?>

				</header>
			</div>

		</article>
	</li>

<?php do_action( 'boombox/loop-item/after-content', $listing_type ); ?>