<?php
/**
 * The template part for displaying post item for "classic" listing type
 *
 * @package BoomBox_Theme
 * @since   1.0.0
 * @version 2.0.0
 */

// Prevent direct script access.
if ( ! defined( 'ABSPATH' ) ) {
	die( 'No direct script access allowed' );
}

$listing_type = 'content-classic';
$featured_image_size = 'boombox_image768';
$post_classes = 'post bb-card-item';
$has_post_thumbnail = boombox_has_post_thumbnail();
$template_options = Boombox_Template::init( 'collection-item' )->get_options();
$featured_video = boombox_get_post_featured_video( get_the_ID(), $featured_image_size, array( 'template' => 'listing', 'listing_type' => $listing_type ) );
$full_post_button_conditions = boombox_get_theme_option( 'single_post_general_enable_full_post_button_conditions' );
$full_post_button_label = boombox_get_theme_option( 'single_post_general_post_button_label' );
$is_nsfw_post = boombox_is_nsfw_post();
$show_media = apply_filters( 'boombox/loop-item/show-media', ( $template_options[ 'media' ] && ( $has_post_thumbnail || $featured_video ) ), $template_options[ 'media' ], ( $has_post_thumbnail || $featured_video ), $listing_type );

if ( ! $show_media ) {
	$post_classes .= ' no-thumbnail';
}

if ( false !== array_search( 'post_content', $full_post_button_conditions ) && get_the_content() ) {
	$post_classes .= ' full-post-show';
}

$permalink = get_permalink();
$url = apply_filters( 'boombox_loop_item_url', $permalink, get_the_ID() );
$target = apply_filters( 'boombox_loop_item_url_target', '', $permalink, $url );
$rel = apply_filters( 'boombox_loop_item_url_rel', '', $permalink, $url );

do_action( 'boombox/loop-item/before-content', $listing_type ); ?>

	<li class="post-item">
		<article id="post-<?php the_ID(); ?>" <?php post_class( $post_classes ); ?>>

			<!-- thumbnail -->
			<div class="post-thumbnail">
				<?php

				if ( apply_filters( 'boombox/loop-item/show-box-index', false ) ) {
					get_template_part( 'template-parts/numeric', 'badge' );
				}

				if ( apply_filters( 'boombox/loop-item/show-badges', $template_options[ 'badges' ] ) ) {
					$badges_list = boombox_get_post_badge_list();
					echo $badges_list[ 'badges' ];
				}

				if ( $show_media ) {

					if ( $featured_video ) {
						echo $featured_video;
					} else {
						$boombox_post_thumbnail_html = get_the_post_thumbnail( NULL, $featured_image_size, array( 'play' => true, 'template' => 'listing', 'listing_type' => $listing_type ) );
						$boombox_post_thumbnail_wrapper = boombox_get_post_thumbnail_wrapper( $boombox_post_thumbnail_html, $is_nsfw_post, $url, $target, $rel );

						echo $boombox_post_thumbnail_wrapper[ 'before' ] . $boombox_post_thumbnail_html . $boombox_post_thumbnail_wrapper[ 'after' ];
					}

					if ( ! $is_nsfw_post && $full_post_button_label ) { ?>
						<a class="view-full-post" href="<?php echo $url; ?>" <?php echo $target; ?> <?php echo $rel; ?>>
							<span class="bb-btn bb-btn-primary"><?php echo esc_html( $full_post_button_label ); ?></span>
						</a>
					<?php }
				} ?>
			</div>
			<!-- thumbnail -->

			<div class="content">
				<!-- entry-header -->
				<header class="entry-header">
					<?php

					do_action( 'boombox/loop-item/content-start' );

					if ( apply_filters( 'boombox/loop-item/show-categories', $template_options[ 'categories' ] ) ) {
						boombox_categories_list();
					}

					if ( apply_filters( 'boombox/loop-item/show-comments-count', ( comments_open() && $template_options[ 'comments_count' ] ) ) ) {
						boombox_post_comments();
					}

					the_title( sprintf( '<h2 class="entry-title"><a href="%1$s" rel="bookmark" %2$s %3$s>', $url, $target, $rel ), '</a></h2>' );

					if ( apply_filters( 'boombox/loop-item/show-subtitle', $template_options[ 'subtitle' ] ) ) {
						echo boombox_get_post_subtitle();
					}

					if ( apply_filters( 'boombox/loop-item/show-post-author-meta', true ) ) {
						boombox_post_author_meta( array(
							'author'      => $template_options[ 'author' ],
							'author_args' => array( 'with_avatar' => true ),
							'date'        => $template_options[ 'date' ],
						) );
					}

					do_action( 'boombox/loop-item/content-end' );
					?>
				</header>
				<!-- entry-header -->

				<?php if ( $template_options[ 'excerpt' ] ) { ?>
					<div class="entry-content"><?php echo wp_trim_excerpt(); ?></div>
				<?php } ?>

			</div>

			<!-- entry-footer -->
			<footer class="entry-footer">
				<div class="post-share-box">
					<?php get_template_part( 'template-parts/single/share', 'box' ); ?>
				</div>
			</footer>
			<!-- entry-footer -->

			<?php get_template_part( 'template-parts/content', 'affiliate' ); ?>

		</article>
	</li>

<?php do_action( 'boombox/loop-item/after-content', $listing_type ); ?>