/**
 * THIS FILE SHOULD INCLUDE GLOBAL FUNCTIONS THAT CAN BE USED THROUGHOUT THE PROJECT
*/

/**
 *  Global Variables
 */
var bb = {
    isMobile : false,
    isRTL : false,
    html  : jQuery('html'),
    windowWidth : jQuery(window).width(),
    windowHeight : jQuery(window).height(),
    stickyBorder : jQuery('#sticky-border').offset().top,
    fixedHeader : 0,
    scrollTop : 0,
    floatingPagination : 0,
    adminBar : 0,
    stickyAdminBar : 0,
    videoOptions : boombox_global_vars.videoOptions
};


/**
 * Set Global Variables
 */
(function ($) {
    "use strict";

    if( bb_detect_mobile() ){
        bb.isMobile = true;
        bb.html.addClass('mobile');
        $('body').trigger('bbMobile');
    } else {
        bb.isMobile = false;
        bb.html.addClass('desktop');
        $('body').trigger('bbDesktop');
    }

    if($('body').hasClass('rtl')){
        bb.isRTL = true;
    }

    function bb_detect_mobile() {
        //var is_mobile = ( /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test( navigator.userAgent ) );
        var is_mobile = $('html').hasClass('touchevents');
        return is_mobile;
    }

    if (bb.isMobile && boombox_gif_event == 'hover') {
        boombox_gif_event = 'click';
    }

    function setSize(){
        bb.windowWidth = $(window).width();
        bb.windowHeight = $(window).height();
        $('.wh').css('height', bb.windowHeight +'px');
        $('.min-wh').css('min-height', bb.windowHeight +'px');
        $('.error404 .page-wrapper').css('min-height', bb.windowHeight);

        var pageWidth = $('.page-wrapper').width();

        $('.bb-header.header-desktop .top-header').css('width',pageWidth);
        $('.bb-header.header-desktop .bottom-header').css('width',pageWidth);

        getSetAdminBars();
    }

    setSize();
    getSetFixedHeader();

    /* Global Window Load */
    $(window).load(function () {
        setSize();
        getSetFixedHeader();
        bb.html.addClass('page-loaded');
    });

    /* Global Window Resize */
    $(window).resize(function () {
        setSize();
    });

    /* Global Window Scroll */
    jQuery(window).scroll(function () {
        bb.scrollTop = jQuery(window).scrollTop();
        bb.stickyBorder = jQuery('#sticky-border').offset().top;
    });

})(jQuery);


/**
 *  Site Helper Functions
 **/
/* Set Height for Fixed Header */
function getSetFixedHeader(){
    if(jQuery('.bb-sticky.bb-sticky-nav').length && jQuery('.bb-sticky.bb-sticky-nav').is(":visible"))
        bb.fixedHeader = jQuery('.bb-sticky.bb-sticky-nav:visible').innerHeight();
    return bb.fixedHeader;
}

/* Set Height for Admin Bars */
function getSetAdminBars() {
    if(jQuery('#wpadminbar').length){
        bb.adminBar = jQuery('#wpadminbar').outerHeight(true);
        if(jQuery('#wpadminbar').css('position')=='fixed')
            bb.stickyAdminBar = jQuery('#wpadminbar').outerHeight(true);
        else
            bb.stickyAdminBar = 0;
    }
    return bb.stickyAdminBar;
}

/* Sets/Gets Height for Floating Pagination */
function getSetFloatingPagHeight() {
    if (jQuery('.bb-sticky.bb-fixed-next-page').length)
        bb.floatingPagination = jQuery('.bb-fixed-next-page .fixed-next-page').outerHeight(true);
    return bb.floatingPagination;
}

/* Get Header Height */
function getHeaderHeight() {
    var headerSel = jQuery('.bb-header');
    var headerH = 0;
    if(headerSel.length)
        headerH = headerSel.height();
    return headerH;
}

/* Get Sharebox offset */
function getShareBoxOffset() {
    var shareBoxOffset = getSetFloatingPagHeight() + getSetFixedHeader() + getSetAdminBars();
    return shareBoxOffset;
}


/**
 *  BB Side Navigation
 **/
function bbSideNav() {

    var $selector = jQuery('.widget_bb-side-navigation .dropdown-toggle');

    $selector.on("touchstart click", function (e) {
        e.preventDefault();
        e.stopPropagation();

        var $this = jQuery(this);
            $target = $this.parent(),
            $subMenu = $this.next('.sub-menu');

        if($target.hasClass('active-menu')) {
            $subMenu.stop( true, true ).slideUp(200, function(){
                $target.removeClass('active-menu');
            });
        }
        else {
            $subMenu.stop( true, true ).slideDown(200, function(){
                $target.addClass('active-menu');
            });
        }
    });

}


/**
 *  Shows Full Post
 **/
function ShowFullPost(obj) {

    // var $selector = jQuery('.post-list.standard .post-thumbnail img');
    //
    // if (!$selector.length) {
    //     return;
    // }

    var oW = obj.attr('width'),
        oH = obj.attr('height');

    if (oH / oW >= 3) {
        obj.parents('.post-thumbnail').addClass('show-short-media');
        obj.parents('.post').addClass('full-post-show');
    }
}

/**
 *  Sets Form Placeholders
 **/
function setFormPlaceholders(wrapperSel, rowSel){
    jQuery(wrapperSel + ' ' +rowSel).each(function(){
        if(jQuery(this).children('label').text())
            jQuery(this).find('input').attr('placeholder',jQuery(this).children('label').text());
    })
};


/**
 *  Tabs
 **/
function initializeTabs() {
    var tabActive = jQuery('.bb-tabs .tabs-menu>li.active');
    if( tabActive.length > 0 ){
        for (var i = 0; i < tabActive.length; i++) {
            var tab_id = jQuery(tabActive[i]).children().attr('href');

            jQuery(tab_id).addClass('active').show();
        }
    }

    jQuery('.bb-tabs .tabs-menu a').on("click", function(e){
        var tab = jQuery(this);
        var tab_id = tab.attr('href');
        var tab_wrap = tab.closest('.bb-tabs');
        var tab_content = tab_wrap.find('.tab-content');

        tab.parent().addClass("active");
        tab.parent().siblings().removeClass('active');
        tab_content.not(tab_id).removeClass('active').hide();
        jQuery(tab_id).addClass('active').fadeIn(500);

        e.preventDefault();
    });
}


/**
 *  Sticky Sidebar
 **/
jQuery.fn.bbStickySidebar = function (action) {

    if(bb.isMobile) return; // not init in mobile

    return this.each(function () {

        //not init if sidebar height more than main content height
        if (jQuery(this).parent().outerHeight(true) >= jQuery('.main-container').outerHeight(true))  return;

        // Variables
        var $sticky = jQuery(this),
            $parent = $sticky.parent(),
            adminBarOffset = 0,
            stickyHeight = 1,
            stickyWidth = 1,
            stickyOffset = 25;

        var BB = {
            init: function () {
                BB.build();
                BB.calculate();
                BB.offset();
                BB.css();
            },
            refresh: function () {
                BB.calculate();
                BB.offset();
                BB.css();
                jQuery(window).scroll();
            },
            build: function () {
                var $next = $sticky.nextAll('.widget');
                jQuery($next).appendTo($sticky);
            },
            calculate: function () {
                stickyHeight = $sticky.innerHeight(); //calculate sticky widget height
                stickyWidth = $parent.outerWidth() //calculate sticky widget width
            },
            offset: function () {
                if (bb.adminBar) adminBarOffset = bb.adminBar;

                if (bb.fixedHeader) {
                    stickyOffset = bb.fixedHeader + adminBarOffset + 25;
                } else if (bb.floatingPagination) {
                    stickyOffset = bb.floatingPagination + adminBarOffset + 25;
                }
            },
            waypoint:function () {
                var StickyWaypoint = new Waypoint.Sticky({
                    element: $sticky[0],
                    offset: stickyOffset
                });
            },
            css:function () {
                $sticky.removeAttr('style');
                $sticky.css({
                    'width': stickyWidth,
                    'top': stickyOffset + 'px'
                });
            },
            scroll: function () {
                if (bb.scrollTop >= (bb.stickyBorder - stickyHeight - stickyOffset)) {
                    if($sticky.css('position') === 'fixed') {

                        $sticky.css({
                            'position': 'absolute',
                            'bottom': 0,
                            'top': 'inherit',
                            'width': stickyWidth
                        });
                    }
                } else {
                    $sticky.removeAttr('style');
                    $sticky.css({
                        'width': stickyWidth,
                        'top': stickyOffset + 'px'
                    });
                }
            }
        };

        if (action === 'refresh') {
            BB.refresh();
            return;
        }

        // Plugin init
        BB.init();

        // Refresh when new content loaded
        jQuery('body').on('bbNewContentLoaded',function () {
            BB.refresh();
        });

        // Windows scroll coll plugin scroll
        jQuery(window).scroll(function () {
            BB.scroll();
        });

        // Windows resize coll plugin refresh for recolculation
        jQuery(window).resize(function () {
            BB.refresh();
        });

        // Windows load coll plugin refresh for recolculation
        jQuery(window).load(function () {
            BB.refresh();
            BB.waypoint();
        });
    });
};


/**
 *  Masonry
 **/
function postMasonry() {
    if (!jQuery.fn.isotope) {
        return;
    }

    var $selector = jQuery('.masonry-grid .post-items');

    if (!$selector.length) {
        return;
    }

    var $masonryGrid = $selector.isotope({
        itemSelector:   '.post-item',
        layoutMode:     'masonry'
    });

    jQuery('body').on( 'bbNewContentLoaded', function(e, newItems) {
        $selector.isotope('appended', newItems);

      //  layout Isotope after each image loads
        $masonryGrid.imagesLoaded().progress( function() {
            $masonryGrid.isotope('layout');
        });
    });

    $masonryGrid.imagesLoaded().progress( function() {
        $masonryGrid.isotope('layout');
    });
}

/**
 *  Toggle Functionality
 **/
jQuery.bbToggle = function() {
    var toggleElSel = ".bb-toggle .element-toggle";
    var toggleContentSel = ".bb-toggle .toggle-content";

    jQuery(toggleElSel).on('touchstart click', function(e){
       if(jQuery(this).hasClass('only-mobile') && !bb.isMobile){
           return;
       } else {
           e.preventDefault();
           jQuery(this).toggleClass('active');
           var toggleContent = jQuery(this).attr('data-toggle');
           jQuery(toggleContentSel).not(jQuery(toggleContent)).removeClass('active');
           jQuery(toggleContent).toggleClass('active');
       }
    });

    var closeToggleContent = function(event){
        var exceptElemsStr = toggleElSel  + ' , ' + toggleElSel + ' *' + ' , ' + toggleContentSel + ' , ' + toggleContentSel + ' *';
        if(!jQuery( event.target ).is(exceptElemsStr)) {
            jQuery(toggleElSel).removeClass('active');
            jQuery(toggleContentSel).removeClass('active');
        }

    }
    jQuery(document).on("click", 'body', function (e) {
        closeToggleContent(e);
    });
    jQuery(document).on("touchend", 'body', function (e) {
        closeToggleContent(e);
    });

};


/**
 * Sticky Functionality
 **/
jQuery.fn.bbSticky = function( options ) {
    if(!jQuery(this).length) return;

    this.each(function(){
        /* **Parameters** */
        var settings = jQuery.extend({
            scrollStyle: 'classic', // 'smart', 'none'
            topOffset: null, // by default current element offset top will be used
            fixedOffset: null, // by default current element offset top will be used
            fullWidth: false, // by default sticky takes auto width
            animation: false, // by default no animation
            keepWrapperHeight: true, // This option keeps wrapper fictive height
            fixedOffsetFunc: function(){}, // by default current element offset top will be used
            scrollFunc: function(){},
            resizeFunc: function(){},
        }, options);

        /* **Variables** */
        var curEl = jQuery(this);
        var childEl = curEl.children('.bb-sticky-el');
        var offsetFromTop;
        var fixedClass = 'affix';
        var notFixedClass = 'no-affix';
        var posAnimateClass = 'pos-animate';
        var lastScrollTop = 0;
        var fixedOffset = settings.fixedOffsetFunc.call(this);

        /* **Functions** */
        /**
         * Sets sticky element size
         */
        var setStickySize = function() {
            /* Width Set */
            if(!settings.fullWidth) {
                curEl.css('width', 'auto');
                childEl.outerWidth(curEl.outerWidth());
            }

            /* Height Set */
            if(settings.keepWrapperHeight) {
                curEl.css('height', 'auto');
                curEl.height(childEl.outerHeight(true));
            }

            /* Offset from Top */
            offsetFromTop = (settings.topOffset==null)? curEl.offset().top : settings.topOffset;

            /* Fixed Elements Offset */
            offsetFromTop = (fixedOffset==null)? offsetFromTop : offsetFromTop - fixedOffset;
        };

        var smartStickyFunc = function(){
            var st = jQuery(this).scrollTop();
            //console.log("sticky"+st);
            if (st >= lastScrollTop){ // if scrolled down
                if((fixedOffset!=null))
                    childEl.css('top',0);
                curEl.removeClass(fixedClass);
                if (jQuery(window).scrollTop() > offsetFromTop+curEl.height() && offsetFromTop >= 0) {
                    setTimeout(
                        function(){
                            curEl.addClass(notFixedClass);
                            curEl.removeClass(posAnimateClass);
                        },
                        5);
                }

            } else { // if scrolled up
                if (jQuery(window).scrollTop() > offsetFromTop) {
                    if(fixedOffset!=null)
                        childEl.css('top',fixedOffset);
                    curEl.addClass(fixedClass);
                    setTimeout(
                        function(){
                            curEl.removeClass(notFixedClass);
                            curEl.removeClass(posAnimateClass);
                        },
                        5);
                }
                else {
                    if(fixedOffset!=null) childEl.css('top',0);
                    curEl.removeClass(fixedClass);
                    curEl.addClass(posAnimateClass);
                }
            }
            lastScrollTop = st;
        }

        var classicStickyFunc = function(){
            if (jQuery(window).scrollTop() > offsetFromTop) {
                if(fixedOffset!=null)
                    childEl.css('top',fixedOffset);
                curEl.addClass(fixedClass);
                if(settings.animation)
                    setTimeout(
                        function(){
                            curEl.removeClass(posAnimateClass);
                        },
                        50);
            }
            else {
                if(fixedOffset!=null) childEl.css('top',0);
                curEl.removeClass(fixedClass);
                if(settings.animation)
                    setTimeout(
                        function(){
                            curEl.addClass(posAnimateClass);
                        },
                        50);
            }
        }

        /* **Main Functionality** */
        setStickySize();
        jQuery(window).resize(function(){
            setStickySize();
            settings.resizeFunc.call(this);
            fixedOffset = settings.fixedOffsetFunc.call(this);

            /* Smart Scroll Functionality */
            if(settings.scrollStyle =='smart') {
                smartStickyFunc();
            }

            /* Classic Scroll Functionality */
            if(settings.scrollStyle =='classic') {
                classicStickyFunc();
            }
        });

        /* **Settings** */
        /* Animate */
        if(settings.animation)
            curEl.addClass('animated');

        /* Scroll Function */
        settings.scrollFunc.call(this);

        /* Smart Scroll Functionality */
        if(settings.scrollStyle =='smart') {
            jQuery(window).scroll(function(event){
                smartStickyFunc();
            });
        }

        /* Classic Scroll Functionality */
        if(settings.scrollStyle =='classic') {
            jQuery(window).scroll(function (event) {
                classicStickyFunc();
            });
        }
     })

};


/**
 *  Toggles Mobile Menu
 **/
function mobileMenuToggle(e, curEl) {
    e.preventDefault();
    e.stopPropagation();
    var targetSel =  curEl.next('.sub-menu');
    if(curEl.hasClass('toggled-on')) {
        targetSel.stop( true, true ).slideUp(300, function(){
            curEl.removeClass('toggled-on');
        });
    }
    else {
        targetSel.stop( true, true ).slideDown(300, function(){
            curEl.addClass('toggled-on');
        });
    }
}


/**
 *  Mobile Navigation
 **/
function bbMobileNavigation() {
    /* Mobile navigation sidebar open/close  */
    jQuery(document).on("click", '#menu-button', function (e) {
        e.preventDefault();
        e.stopPropagation();
        var curEl = jQuery(this);
        var mbNavEl = jQuery('.bb-mobile-navigation');
        if(curEl.hasClass('pos-left')) {
            mbNavEl.addClass('pos-left');
            mbNavEl.removeClass('pos-right');
        }
        else {
            mbNavEl.addClass('pos-right');
            mbNavEl.removeClass('pos-left');
        }
        setTimeout(function(){
            bb.html.toggleClass('main-menu-open');
        }, 50);

    });
    jQuery(document).on("click", '#menu-close', function (e) {
        e.preventDefault();
        e.stopPropagation();
        setTimeout(function(){
            bb.html.toggleClass('main-menu-open');
        }, 50);

    });
    /* Mobile menu toggle */
    jQuery('.bb-mobile-navigation .dropdown-toggle').on('touchstart click',function(e){
        mobileMenuToggle(e, jQuery(this));
    });
    /* Mobile Nav Bg Click Events */
    var mbNavBgClickEvents = function(target) {
        jQuery('.toggled-on').removeClass('toggled-on');
        if (bb.html.hasClass('main-menu-open')) {
            target.preventDefault();
            bb.html.removeClass('main-menu-open');
        }
    }
    /* When closing something on background click, we need to set touchend and click events.
     Because otherwise when clicking on any target under which we have link, the link will be clicked and the page will redirect */
    jQuery(document).on("click", '#mobile-nav-bg', function (target) {
        mbNavBgClickEvents(target);
    });
    jQuery(document).on("touchend", '#mobile-nav-bg', function (target) {
        mbNavBgClickEvents(target);
    });
}


/**
 *  Hides some elements when reaching to footer area
 **/
function hideElementsOnScroll() {
    jQuery(window).scroll(function () {
        if (bb.scrollTop >= 500) {
            jQuery('#go-top').addClass('show');
        } else {
            jQuery('#go-top').removeClass('show');
        }

        if (bb.scrollTop >= bb.stickyBorder - 500) {
            jQuery('.bb-fixed-pagination').addClass('hide');
        } else {
            jQuery('.bb-fixed-pagination').removeClass('hide');
        }

        if (bb.scrollTop >= bb.stickyBorder - 500) {
            jQuery('.bb-sticky-share-box').addClass('hidden');
        } else {
            jQuery('.bb-sticky-share-box').removeClass('hidden');
        }
    });
}


/**
 *  Animation to page top
 **/
function animationPageTop() {
    jQuery(document).on("click", '#go-top', function () {
        bbPageAnimate(0,500);
        return false;
    });
}


/**
 *  Disabled Links Behaviour
 **/
function disabledLinksBehaviour() {
    jQuery('.bb-disabled a').click(function(e){
        e.preventDefault();
    });
}


/**
 *  Sidebar First Widget
 **/
function sidebarFirstWidget() {
    jQuery('#secondary .widget:first,#secondary-small .widget:first').addClass('first');
}


/**
 *  Fits Text
 **/
jQuery.fn.fitText = function () {
    return this.each(function () {

        var $this = jQuery(this),
            style = $this.css('font-size'),
            fontSize = parseFloat(style);

        //  resize items based on the object width
        for (var i = fontSize; i > 3; i--) {

            $this.css('font-size', i);

            if ($this.width() <= $this.parent().width()) break;
        }
    });
};
// $(".badge-text .badge .text,.badge-text-angle .badge .text,.no-svg  .badge .text").fitText();



/* Youtube Stream */
// if ($('#stream-player').length) {
//     var player, container = $('#video-stream'), videoID = $('#stream-player').data('id');
//
//     function onYouTubeIframeAPIReady() {
//         player = new YT.Player('stream-player', {
//             height: '420',
//             width: '760',
//             videoId: videoID,
//             events: {
//                 'onReady': onPlayerReady,
//                 'onStateChange': onPlayerStateChange
//             }
//         });
//     }
//
//     onYouTubeIframeAPIReady();
//
//     function onPlayerReady(event) {
//
//         container.find('.video-play').on("click", function (e) {
//             e.preventDefault();
//             event.target.playVideo();
//             container.addClass('isPlaying');
//         });
//     }
//
//     function onPlayerStateChange(event) {
//     }
//
//     function stopVideo() {
//         player.stopVideo();
//     }
//
//     var activeVideo = container.find('li.active'),
//         pos = activeVideo.position(),
//         scrollContainner = document.getElementById("stream-scroll");
//     scrollContainner.scrollTop = pos.top;
// }
