<?php
/**
 * Boombox Single Post Template Helper
 *
 * @package BoomBox_Theme
 * @since   2.0.0
 * @version 2.0.0
 */

// Prevent direct script access.
if ( ! defined( 'ABSPATH' ) ) {
	die( 'No direct script access allowed' );
}

if ( ! class_exists( 'Boombox_Single_Post_Template_Helper' ) ) {

	final class Boombox_Single_Post_Template_Helper {

		/**
		 * Holds class single instance
		 * @var null
		 */
		private static $_instance = NULL;

		/**
		 * Get instance
		 * @return Boombox_Single_Post_Template_Helper|null
		 */
		public static function get_instance() {

			if ( NULL == static::$_instance ) {
				static::$_instance = new self();
			}

			return static::$_instance;

		}

		/**
		 * Holds additional data
		 * @var array
		 */
		private $data = array();

		/**
		 * Setter
		 *
		 * @param string $name  Variable key
		 * @param mixed  $value Variable value
		 */
		public function __set( $name, $value ) {
			$this->data[ $name ] = $value;
		}

		/**
		 * Getter
		 *
		 * @param string $name Variable key
		 *
		 * @return mixed Variable value if it exists or null otherwise
		 */
		public function __get( $name ) {
			if ( array_key_exists( $name, $this->data ) ) {
				return $this->data[ $name ];
			}

			return null;
		}

		/**
		 * Boombox_Single_Post_Template_Helper constructor.
		 */
		private function __construct() {
		}

		/**
		 * A dummy magic method to prevent Boombox_Single_Post_Template_Helper from being cloned.
		 *
		 */
		public function __clone() {
			throw new Exception( 'Cloning ' . __CLASS__ . ' is forbidden' );
		}

		/**
		 * Get hide elements options
		 * @return array
		 */
		public function get_hide_elements_options() {
			$hide_elements_options = array();

			$choices = Boombox_Choices_Helper::get_instance()->get_post_hide_elements();
			$hide_elements = boombox_get_theme_option( 'single_post_general_hide_elements' );
			foreach ( $choices as $name => $element ) {
				$hide_elements_options[ $name ] = ! in_array( $name, $hide_elements );
			}

			return $hide_elements_options;
		}

		/**
		 * Get single post layout
		 * @return mixed
		 */
		public function get_layout() {
			global $post;

			$layout = boombox_get_post_meta( $post->ID, 'boombox_layout' );
			if ( $layout == 'custom' ) {
				$layout = array(
					'sidebar_type'        => boombox_get_post_meta( $post->ID, 'boombox_sidebar_type' ),
					'sidebar_orientation' => boombox_get_post_meta( $post->ID, 'boombox_sidebar_orientation' ),
					'sidebar_reverse'     => boombox_get_post_meta( $post->ID, 'boombox_sidebar_reverse' ),
				);
			} else {
				$layout = array(
					'sidebar_type'        => boombox_get_theme_option( 'single_post_general_sidebar_type' ),
					'sidebar_orientation' => boombox_get_theme_option( 'single_post_general_sidebar_orientation' ),
					'sidebar_reverse'     => false,
				);
			}


			return $layout;
		}

		/**
		 * Get template options
		 * @param string $featured_image_size Featured image size
		 *
		 * @return array
		 */
		public function get_options( $featured_image_size ) {
			$post_id = get_the_ID();

			$hash = md5( json_encode( array(
				'post_id'             => $post_id,
				'featured_image_size' => $featured_image_size,
			) ) );
			$single_post_settings = boombox_cache_get( $hash );

			if ( ! $single_post_settings ) {

				if ( boombox_is_fragment_cache_enabled() ) {
					?>
					<!-- mfunc <?php echo W3TC_DYNAMIC_SECURITY; ?>
						$featured_strip = in_array( 'post', boombox_get_theme_option( 'header_strip_visibility' ) );

						if( wp_is_mobile() ) {
							$featured_strip = ( $featured_strip && boombox_get_theme_option( 'mobile_global_enable_strip' ) );
						}
					-->
					<?php
					$featured_strip = in_array( 'post', boombox_get_theme_option( 'header_strip_visibility' ) );
					if( wp_is_mobile() ) {
						$featured_strip = ( $featured_strip && boombox_get_theme_option( 'mobile_global_enable_strip' ) );
					}
					?>
					<!-- /mfunc <?php echo W3TC_DYNAMIC_SECURITY; ?> -->
					<?php
				} else if ( boombox_is_page_cache_enabled() ) {
					$featured_strip = in_array( 'post', boombox_get_theme_option( 'header_strip_visibility' ) );
				} else {
					$featured_strip = in_array( 'post', boombox_get_theme_option( 'header_strip_visibility' ) );
					if( wp_is_mobile() ) {
						$featured_strip = ( $featured_strip && boombox_get_theme_option( 'mobile_global_enable_strip' ) );
					}
				}

				$layout = $this->get_layout();

				$single_post_settings = array_merge(
					$this->get_hide_elements_options(),
					array(
						'is_nsfw'                  => has_category( apply_filters( 'boombox/nsfw_category', 'nsfw' ), $post_id ),
						'classes'                  => 'single post',
						'featured_strip'            => $featured_strip,
						'featured_video'           => boombox_get_post_featured_video( $post_id, $featured_image_size, array( 'template' => 'single' ) ),
						'media'                    => boombox_show_media_for_post( $post_id ),
						'share_bars' => array(
							'top' => array(
								'enable' => boombox_get_theme_option( 'single_post_general_top_sharebar' ),
								'sticky' => boombox_get_theme_option( 'single_post_general_sticky_top_sharebar' ),
								'before' => '',
								'after'  => '',
								'class'  => ''
							),
							'bottom' => array(
								'enable' => boombox_get_theme_option( 'single_post_general_bottom_sharebar' ),
								'sticky' => false,
								'before' => '',
								'after'  => '',
								'class'  => ''
							)
						),
						'side_navigation'          => boombox_get_theme_option( 'single_post_general_side_navigation' ),
						'enable_primary_sidebar'   => boombox_is_primary_sidebar_enabled( $layout[ 'sidebar_type' ] ),
						'enable_secondary_sidebar' => boombox_is_secondary_sidebar_enabled( $layout[ 'sidebar_type' ] ),
					)
				);

				if(
					$single_post_settings['share_bars']['top']['enable']
					&& $single_post_settings['share_bars']['top']['sticky']
				) {
					$single_post_settings['share_bars']['top']['before'] = '<div class="bb-sticky bb-sticky-share-box">';
					$single_post_settings['share_bars']['top']['after'] = '</div>';
					$single_post_settings['share_bars']['top']['class'] = 'bb-sticky-el';
				}
				boombox_cache_set( $hash, $single_post_settings );

			}

			return apply_filters( 'boombox/single_template_settings', $single_post_settings );
		}

	}

}