<?php
/**
 * Boombox customizer "bb-number" field type
 *
 * @package BoomBox_Theme
 * @since   2.0.0
 * @version 2.0.0
 */

// Prevent direct script access.
if ( ! defined( 'ABSPATH' ) ) {
	die( 'No direct script access allowed' );
}

if ( ! class_exists( 'Boombox_Controls_Number_Control' ) ) {

	/**
	 * The "bb-number" class
	 */
	class Boombox_Controls_Number_Control extends WP_Customize_Control {

		/**
		 * @var string Control's Type.
		 */
		public $type = 'bb-number';

		/**
		 * Render the control's content.
		 */
		public function render_content() { ?>
			<label>

				<?php
				if ( ! empty( $this->label ) ) { ?>
					<span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
				<?php }

				if ( ! empty( $this->description ) ) { ?>
					<span class="description customize-control-description"><?php echo wp_kses_post( $this->description ); ?></span>
				<?php } ?>

				<div class="customize-control-content">
					<input type="number" <?php $this->input_attrs(); ?> <?php $this->link(); ?> value="<?php echo
					esc_attr( $this->value() ); ?>"/>
				</div>

			</label>
			<?php
		}

	}

	/**
	 * Register "bb-number"
	 */
	add_filter( 'kirki/control_types', function ( $controls ) {
		$controls[ 'bb-number' ] = 'Boombox_Controls_Number_Control';

		return $controls;
	} );

}