<?php
/**
 * Register a category meta box using a class.
 */

// Prevent direct script access.
if ( ! defined( 'ABSPATH' ) ) {
	die( 'No direct script access allowed' );
}

if ( ! class_exists( 'Boombox_Category_Custom_Meta_Box' ) ) {

	class Boombox_Category_Custom_Meta_Box {

		/**
		 * Constructor.
		 */
		public function __construct() {
			add_action( 'category_add_form_fields', array( $this, 'add_category_fields' ) );
			add_action( 'category_edit_form_fields', array( $this, 'edit_category_fields' ), 10 );
			add_action( 'created_term', array( $this, 'save_category_fields' ), 10, 1 );
			add_action( 'edit_term', array( $this, 'save_category_fields' ), 10, 1 );
			add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_script' ) );
		}

		/**
		 * Singleton.
		 */
		public static function get_instance() {
			static $Inst = NULL;
			if ( $Inst == NULL ) {
				$Inst = new self();
			}

			return $Inst;
		}

		/**
		 * Load scripts
		 */
		public function enqueue_script() {
			global $current_screen;
			global $wp_scripts;
			if ( isset( $current_screen ) && 'edit-category' === $current_screen->id ) {
				$protocol = is_ssl() ? 'https' : 'http';
				$ui = $wp_scripts->query( 'jquery-ui-core' );
				$url = "$protocol://ajax.googleapis.com/ajax/libs/jqueryui/{$ui->ver}/themes/smoothness/jquery-ui.min.css";
				wp_enqueue_style( 'jquery-ui-smoothness', $url, array(), boombox_get_assets_version() );
				wp_enqueue_style( 'boombox-icomoon-style', BOOMBOX_THEME_URL . 'fonts/icon-fonts/icomoon/icons.min.css', array(), boombox_get_assets_version() );
				wp_enqueue_style( 'boombox-admin-meta-style', BOOMBOX_ADMIN_URL . 'metaboxes/assets/css/boombox-metabox-style.css', array(), boombox_get_assets_version() );

				wp_enqueue_media();
				wp_enqueue_script( 'jquery-ui-selectmenu' );
				wp_enqueue_script( 'boombox-admin-meta-script', BOOMBOX_ADMIN_URL . 'metaboxes/assets/js/boombox-metabox-script.js', array( 'jquery' ), boombox_get_assets_version(), true );
			}

		}

		/**
		 * Category fields.
		 */
		public function add_category_fields() {
			$choices_helper = Boombox_Choices_Helper::get_instance();

			wp_nonce_field( 'update_term_meta', 'term_meta_nonce' ); ?>

			<div class="bb-term-advanced-fields">

				<?php // Category thumbnail ?>
				<div class="form-field bb-cat-thumbnail-id-wrap boombox-form-row-image bb-hidden">
					<label for="cat_thumbnail_id">
						<?php _e( 'Thumbnail', 'boombox' ); ?>
					</label>
					<div class="upload-wrapper">
						<div class="image-wrapper">

							<div class="placeholder"><?php _e( 'No File Selected' ) ?></div>

							<div class="image-holder"></div>
						</div>
						<div class="buttons-wrapper">
							<button type="button" class="button button-upload">
								<?php esc_html_e( 'Select File', 'boombox' ); ?>
							</button>
							<button type="button" class="button button-remove">
								<?php esc_html_e( 'Remove', 'boombox' ); ?>
							</button>
						</div>
						<input type="hidden" class="image_id" name="cat_thumbnail_id" id="cat_thumbnail_id" value="" />
					</div>
				</div>

				<?php // Category Icon ?>
				<?php $category_icons = get_icomoon_icons_array(); ?>
				<div class="form-field term-icon-name-wrap">
					<label for="cat_icon_name"><?php esc_html_e( 'Badge Icon', 'boombox' ); ?></label>
					<select id="cat_icon_name" name="cat_icon_name">
						<option value="" data-class=""><?php echo esc_html__( 'Select icon', 'boombox' ); ?></option>
						<?php foreach ( $category_icons as $category_icon ) { ?>
							<option value="<?php echo esc_html( esc_attr( $category_icon[ 'icon' ] ) ); ?>"
							        data-class="icon-<?php echo esc_attr( $category_icon[ 'icon' ] ); ?>">
								<?php echo esc_html( $category_icon[ 'name' ] ); ?>
							</option>
						<?php } ?>
					</select>
					<div class="clear"></div>
				</div>

				<?php // Category image icon ?>
				<div class="form-field bb-title-area-term-image-icon-wrap boombox-form-row-image">
					<label for="term_image_icon_id">
						<?php _e( 'Custom Badge Icon', 'boombox' ); ?>
					</label>
					<div class="upload-wrapper">
						<div class="image-wrapper">

							<div class="placeholder"><?php _e( 'No File Selected' ) ?></div>

							<div class="image-holder"></div>
						</div>
						<div class="buttons-wrapper">
							<button type="button" class="button button-upload">
								<?php esc_html_e( 'Select File', 'boombox' ); ?>
							</button>
							<button type="button" class="button button-remove">
								<?php esc_html_e( 'Remove', 'boombox' ); ?>
							</button>
						</div>
						<input type="hidden" class="image_id" name="term_image_icon_id" id="term_image_icon_id" value="" />
					</div>
					<p class="description"><?php _e( 'Upload .svg, .png, .jpg with optimal size of 80x80px', 'boombox' ); ?></p>
				</div>

				<?php // Category badge background color ?>
				<?php $term_icon_background_color = boombox_get_theme_option( 'extras_badges_category_background_color' ); ?>
				<div class="form-field boombox-form-row-color">
					<label for="term_icon_background_color"><?php esc_html_e( 'Badge Background Color', 'boombox' ); ?></label>
					<input type="text" value="<?php echo esc_attr( $term_icon_background_color ); ?>"
					       name="term_icon_background_color"/>
					<div class="clear"></div>
				</div>

				<?php // Category hide featured area ?>
				<div class="form-field hide-featured-area-wrap">
					<input name="hide_featured_area" type="hidden" value="0">
					<label for="hide_featured_area">
						<input name="hide_featured_area" id="hide_featured_area" type="checkbox" value="1">
						<?php _e( 'Hide featured area', 'boombox' ); ?>
					</label>
					<p><?php _e( 'Check to hide featured area for this category', 'boombox' ); ?></p>
				</div>

				<?php // Category hide featured media for attached posts ?>
				<div class="form-field hide-attached-posts-featured-media-wrap">
					<input name="hide_attached_posts_featured_media" type="hidden" value="0">
					<label for="hide_attached_posts_featured_media">
						<input name="hide_attached_posts_featured_media" id="hide_attached_posts_featured_media"
						       type="checkbox" value="1">
						<?php _e( 'Hide Attached Posts Featured Media', 'boombox' ); ?>
					</label>
					<p><?php _e( 'Check to hide featured media from the single article page of posts - attached to this category', 'boombox' ); ?></p>
				</div>

				<div><h3><?php _e( 'Title Area', 'boombox' ); ?></h3><hr></div>

				<?php /***** Style */ ?>
				<div class="form-field bb-title-area-style-wrap">
					<label for="title_area_style">
						<?php _e( 'Style', 'boombox' ); ?>
					</label>
					<select name="title_area_style" id="title_area_style">
						<?php
						$choices = array_merge( array(
							'inherit' => __( 'Inherit' ),
						), $choices_helper->get_template_header_style_choices() );
						foreach( $choices as $key => $label ) { ?>
							<option value="<?php echo $key; ?>"><?php echo $label; ?></option>
						<?php } ?>
					</select>
				</div>

				<?php /***** Container Type */ ?>
				<div class="form-field bb-title-area-bg-container-wrap">
					<label for="title_area_background_container">
						<?php _e( 'Container Type', 'boombox' ); ?>
					</label>
					<select name="title_area_background_container" id="title_area_background_container">
						<?php
						$choices = array_merge( array(
							'inherit' => __( 'Inherit' ),
						), $choices_helper->get_template_header_background_container_choices() );
						foreach( $choices as $key => $label ) { ?>
							<option value="<?php echo $key; ?>"><?php echo $label; ?></option>
						<?php } ?>
					</select>
				</div>

				<?php /***** Text Color */ ?>
				<div class="form-field bb-title-area-text-color-wrap boombox-form-row-color">
					<label for="title_area_text_color">
						<?php _e( 'Text Color', 'boombox' ); ?>
					</label>
					<input
							type="text"
							name="title_area_text_color"
							id="title_area_text_color"
							value="" />
				</div>

				<?php /***** Background Color */ ?>
				<div class="form-field bb-title-area-bg-color-wrap boombox-form-row-color">
					<label for="title_area_bg_color">
						<?php _e( 'Background Color', 'boombox' ); ?>
					</label>
					<input
							type="text"
							name="title_area_bg_color"
							id="title_area_bg_color"
							value="" />
				</div>

				<?php /***** Gradient Color */ ?>
				<div class="form-field bb-title-area-gradient-color-wrap boombox-form-row-color">
					<label for="title_area_gradient_color">
						<?php _e( 'Gradient Color', 'boombox' ); ?>
					</label>
					<input
							type="text"
							name="title_area_gradient_color"
							id="title_area_gradient_color"
							value="" />
				</div>

				<?php /***** Gradient Direction */ ?>
				<div class="form-field bb-title-area-gradient-direction-wrap">
					<label for="title_area_bg_gradient_direction">
						<?php _e( 'Gradient Direction', 'boombox' ); ?>
					</label>
					<select name="title_area_bg_gradient_direction" id="title_area_bg_gradient_direction">
						<?php
						foreach( $choices_helper->get_template_header_background_gradient_direction_choices() as $key => $label ) { ?>
							<option value="<?php echo $key; ?>"><?php echo $label; ?></option>
						<?php } ?>
					</select>
				</div>

				<?php /***** Background Image */ ?>
				<div class="form-field bb-title-area-bg-image-wrap boombox-form-row-image">
					<label for="title_area_background_image">
						<?php _e( 'Background Image', 'boombox' ); ?>
					</label>
					<div class="upload-wrapper">
						<div class="image-wrapper">

							<div class="placeholder"><?php _e( 'No File Selected' ) ?></div>

							<div class="image-holder"></div>
						</div>
						<div class="buttons-wrapper">
							<button type="button" class="button button-upload">
								<?php esc_html_e( 'Select File', 'boombox' ); ?>
							</button>
							<button type="button" class="button button-remove">
								<?php esc_html_e( 'Remove', 'boombox' ); ?>
							</button>
						</div>
						<input type="hidden" class="image_id" name="title_area_background_image" id="title_area_background_image" value="" />
					</div>
				</div>

				<?php /***** Background Image Size */ ?>
				<div class="form-field bb-title-area-bg-image-size-wrap">
					<label for="title_area_background_image_size">
						<?php _e( 'Background Image Size', 'boombox' ); ?>
					</label>
					<select name="title_area_background_image_size" id="title_area_background_image_size">
						<?php
						foreach( $choices_helper->get_template_header_background_image_size_choices() as $key => $label ) { ?>
							<option value="<?php echo $key; ?>"><?php echo $label; ?></option>
						<?php } ?>
					</select>
				</div>

				<?php /***** Background Image Position */ ?>
				<div class="form-field bb-title-area-bg-image-position-wrap">
					<label for="title_area_background_image_position">
						<?php _e( 'Background Image Position', 'boombox' ); ?>
					</label>
					<select name="title_area_background_image_position" id="title_area_background_image_position">
						<?php
						foreach( $choices_helper->get_template_header_background_image_position_choices() as $key => $label ) { ?>
							<option value="<?php echo $key; ?>"><?php echo $label; ?></option>
						<?php } ?>
					</select>
				</div>

				<?php /***** Background Image Repeat */ ?>
				<div class="form-field bb-title-area-bg-image-repeat-wrap">
					<label for="title_area_background_image_repeat">
						<?php _e( 'Background Image Repeat', 'boombox' ); ?>
					</label>
					<select name="title_area_background_image_repeat" id="title_area_background_image_repeat">
						<?php
						foreach( $choices_helper->get_template_header_background_image_repeat_choices() as $key => $label ) { ?>
							<option value="<?php echo $key; ?>"><?php echo $label; ?></option>
						<?php } ?>
					</select>
				</div>

				<div><hr></div>

				<?php do_action( 'boombox/admin/category/meta-boxes/add-fields', $this ); ?>

			</div>

			<?php

		}

		/**
		 * Edit category field.
		 *
		 * @param mixed $term Term (category) being edited
		 */
		public function edit_category_fields( $term ) {
			// Put the term ID into a variable.
			$t_id = $term->term_id;
			$choices_helper = Boombox_Choices_Helper::get_instance();

			$thumbnail_id = absint( boombox_get_term_meta( $t_id, 'cat_thumbnail_id' ) );
			$cat_icon_name = sanitize_text_field( boombox_get_term_meta( $t_id, 'cat_icon_name' ) );
			$term_image_icon_id = boombox_get_term_meta( $t_id, 'term_image_icon_id' );
			$term_icon_background_color = boombox_get_term_meta( $t_id, 'term_icon_background_color' );
			$term_icon_background_color = ! empty( $term_icon_background_color ) ? sanitize_text_field( $term_icon_background_color ) : boombox_get_theme_option( 'extras_badges_category_background_color' );
			$hide_featured_area = boombox_get_term_meta( $t_id, 'hide_featured_area' );
			$hide_attached_posts_featured_media = boombox_get_term_meta( $t_id, 'hide_attached_posts_featured_media' );

			/***** Title Area */
			$title_area_style = boombox_get_term_meta( $t_id, 'title_area_style' );
			$title_area_background_container = boombox_get_term_meta( $t_id, 'title_area_background_container' );
			$title_area_text_color = boombox_get_term_meta( $t_id, 'title_area_text_color' );
			$title_area_bg_color = boombox_get_term_meta( $t_id, 'title_area_bg_color' );
			$title_area_gradient_color = boombox_get_term_meta( $t_id, 'title_area_gradient_color' );
			$title_area_bg_gradient_direction = boombox_get_term_meta( $t_id, 'title_area_bg_gradient_direction' );
			$title_area_background_image = boombox_get_term_meta( $t_id, 'title_area_background_image' );
			$title_area_background_image_size = boombox_get_term_meta( $t_id, 'title_area_background_image_size' );
			$title_area_background_image_position = boombox_get_term_meta( $t_id, 'title_area_background_image_position' );
			$title_area_background_image_repeat = boombox_get_term_meta( $t_id, 'title_area_background_image_repeat' );

			wp_nonce_field( 'update_term_meta', 'term_meta_nonce' ); ?>

			<table class="form-table term-thumbnail-wrap bb-term-advanced-fields">
				<tbody>
				<?php // Category thumbnail ?>
				<tr class="form-field bb-cat-thumbnail-id-wrap boombox-form-row-image bb-hidden">
					<th scope="row">
						<label for="cat_thumbnail_id">
							<?php _e( 'Thumbnail', 'boombox' ); ?>
						</label>
					</th>
					<td>
						<div class="upload-wrapper <?php echo $thumbnail_id ? 'has-image' : ''; ?>">
							<div class="image-wrapper">

								<div class="placeholder"><?php _e( 'No File Selected' ) ?></div>

								<div class="image-holder">
									<?php if( $thumbnail_id ) {
										echo wp_get_attachment_image( $thumbnail_id, 'medium' );
									} ?>
								</div>
							</div>
							<div class="buttons-wrapper">
								<button type="button" class="button button-upload">
									<?php esc_html_e( 'Select File', 'boombox' ); ?>
								</button>
								<button type="button" class="button button-remove">
									<?php esc_html_e( 'Remove', 'boombox' ); ?>
								</button>
							</div>
							<input type="hidden"
							       class="image_id" name="cat_thumbnail_id" value="<?php echo $thumbnail_id; ?>" />
						</div>
					</td>
				</tr>

				<?php // Category Icon ?>
				<tr>
					<th scope="row" valign="top">
						<label for="cat_icon_name"><?php esc_html_e( 'Badge Icon', 'boombox' ); ?></label>
					</th>
					<td>
						<?php $category_icons = get_icomoon_icons_array(); ?>
						<div class="form-field term-icon-name-wrap">
							<select id="cat_icon_name" name="cat_icon_name">
								<option value=""
								        data-class=""><?php echo esc_html__( 'Select icon', 'boombox' ); ?></option>
								<?php foreach ( $category_icons as $category_icon ) {
									$selected = selected( $category_icon[ 'icon' ], $cat_icon_name, false ); ?>
									<option value="<?php echo esc_html( esc_attr( $category_icon[ 'icon' ] ) ); ?>"
									        data-class="icon-<?php echo esc_attr( $category_icon[ 'icon' ] ); ?>" <?php echo $selected; ?>>
										<?php echo esc_html( $category_icon[ 'name' ] ); ?>
									</option>
								<?php } ?>
							</select>

							<div class="clear"></div>
						</div>
					</td>
				</tr>

				<?php // Category image icon ?>
				<tr class="form-field term-taxonomy-wrap boombox-form-row-image">
					<th scope="row" valign="top">
						<label><?php esc_html_e( 'Custom Badge Icon', 'boombox' ); ?></label>
					</th>
					<td class="row-thumbnail">
						<div class="upload-wrapper <?php echo $term_image_icon_id ? 'has-image' : ''; ?>">
							<div class="image-wrapper">

								<div class="placeholder"><?php _e( 'No File Selected' ) ?></div>

								<div class="image-holder">
									<?php if( $term_image_icon_id ) {
										echo wp_get_attachment_image( $term_image_icon_id, 'medium' );
									} ?>
								</div>
							</div>
							<div class="buttons-wrapper">
								<button type="button" class="button button-upload">
									<?php esc_html_e( 'Select File', 'boombox' ); ?>
								</button>
								<button type="button" class="button button-remove">
									<?php esc_html_e( 'Remove', 'boombox' ); ?>
								</button>
							</div>
							<input type="hidden" class="image_id" name="term_image_icon_id" value="<?php echo esc_html( $term_image_icon_id ); ?>" />
						</div>
						<p class="description"><?php _e( 'Upload .svg, .png, .jpg with optimal size of 80x80px', 'boombox' ); ?></p>
					</td>
				</tr>

				<?php // Category badge background color ?>
				<tr class="form-field boombox-form-row-color">
					<th scope="row" valign="top">
						<label for="term_icon_background_color"><?php esc_html_e( 'Badge Background Color', 'boombox' ); ?></label>
					</th>
					<td>
						<input type="text" value="<?php echo esc_attr( $term_icon_background_color ); ?>"
						       name="term_icon_background_color"/>
					</td>
				</tr>

				<?php // Category hide featured area ?>
				<tr class="form-field hide-featured-area-wrap">
					<th scope="row">
						<label for="hide_featured_area"><?php _e( 'Hide Featured Area', 'boombox' ); ?></label>
					</th>
					<td>
						<input name="hide_featured_area" type="hidden" value="0">
						<input name="hide_featured_area" id="hide_featured_area"
						       type="checkbox" <?php checked( $hide_featured_area, 1 ); ?> value="1">
						<p class="description"><?php _e( 'Check to hide featured area for this category', 'boombox' ); ?></p>
					</td>
				</tr>

				<?php // Category hide featured media for attached posts ?>
				<tr class="form-field hide-attached-posts-featured-media-wrap">
					<th scope="row">
						<label for="hide_attached_posts_featured_media">
							<?php _e( 'Hide Attached Posts Featured Media', 'boombox' ); ?>
						</label>
					</th>
					<td>
						<input name="hide_attached_posts_featured_media" type="hidden" value="0">
						<input name="hide_attached_posts_featured_media" id="hide_attached_posts_featured_media"
						       type="checkbox" <?php checked( $hide_attached_posts_featured_media, 1 ); ?> value="1">
						<p class="description"><?php _e( 'Check to hide featured media from the single article page of posts - attached to this category', 'boombox' ); ?></p>
					</td>
				</tr>

				<?php /***** Title Area */ ?>
				<tr>
					<td colspan="2" style="padding: 0;">
						<h3><?php _e( 'Title Area', 'boombox' ); ?></h3><hr>
					</td>
				</tr>

				<?php /***** Style */ ?>
				<tr class="form-field bb-title-area-style-wrap">
					<th scope="row">
						<label for="title_area_style">
							<?php _e( 'Style', 'boombox' ); ?>
						</label>
					</th>
					<td>
						<select name="title_area_style" id="title_area_style">
							<?php
							$choices = array_merge( array(
								'inherit' => __( 'Inherit' ),
							), $choices_helper->get_template_header_style_choices() );
							foreach( $choices as $key => $label ) { ?>
							<option value="<?php echo $key; ?>" <?php selected( $key, $title_area_style ); ?>>
								<?php echo $label; ?>
							</option>
							<?php } ?>
						</select>
					</td>
				</tr>

				<?php /***** Container Type */ ?>
				<tr class="form-field bb-title-area-bg-container-wrap">
					<th scope="row">
						<label for="title_area_background_container">
							<?php _e( 'Container Type', 'boombox' ); ?>
						</label>
					</th>
					<td>
						<select name="title_area_background_container" id="title_area_background_container">
							<?php
							$choices = array_merge( array(
								'inherit' => __( 'Inherit' ),
							), $choices_helper->get_template_header_background_container_choices() );
							foreach( $choices as $key => $label ) { ?>
								<option value="<?php echo $key; ?>" <?php selected( $key, $title_area_background_container ); ?>>
									<?php echo $label; ?>
								</option>
							<?php } ?>
						</select>
					</td>
				</tr>

				<?php /***** Text Color */ ?>
				<tr class="form-field bb-title-area-text-color-wrap boombox-form-row-color">
					<th scope="row">
						<label for="title_area_text_color">
							<?php _e( 'Text Color', 'boombox' ); ?>
						</label>
					</th>
					<td>
						<input
								type="text"
								name="title_area_text_color"
								id="title_area_text_color"
								value="<?php echo $title_area_text_color; ?>" />
					</td>
				</tr>

				<?php /***** Background Color */ ?>
				<tr class="form-field bb-title-area-bg-color-wrap boombox-form-row-color">
					<th scope="row">
						<label for="title_area_bg_color">
							<?php _e( 'Background Color', 'boombox' ); ?>
						</label>
					</th>
					<td>
						<input
								type="text"
								name="title_area_bg_color"
								id="title_area_bg_color"
								value="<?php echo $title_area_bg_color; ?>" />
					</td>
				</tr>

				<?php /***** Gradient Color */ ?>
				<tr class="form-field bb-title-area-gradient-color-wrap boombox-form-row-color">
					<th scope="row">
						<label for="title_area_gradient_color">
							<?php _e( 'Gradient Color', 'boombox' ); ?>
						</label>
					</th>
					<td>
						<input
								type="text"
								name="title_area_gradient_color"
								id="title_area_gradient_color"
								value="<?php echo $title_area_gradient_color; ?>" />
					</td>
				</tr>

				<?php /***** Gradient Direction */ ?>
				<tr class="form-field bb-title-area-gradient-direction-wrap">
					<th scope="row">
						<label for="title_area_bg_gradient_direction">
							<?php _e( 'Gradient Direction', 'boombox' ); ?>
						</label>
					</th>
					<td>
						<select name="title_area_bg_gradient_direction" id="title_area_bg_gradient_direction">
							<?php
							foreach( $choices_helper->get_template_header_background_gradient_direction_choices() as $key => $label ) { ?>
								<option value="<?php echo $key; ?>"
									<?php selected( $key, $title_area_bg_gradient_direction ); ?>>
									<?php echo $label; ?>
								</option>
							<?php } ?>
						</select>
					</td>
				</tr>

				<?php /***** Background Image */ ?>
				<tr class="form-field bb-title-area-bg-image-wrap boombox-form-row-image">
					<th scope="row">
						<label for="title_area_background_image">
							<?php _e( 'Background Image', 'boombox' ); ?>
						</label>
					</th>
					<td>
						<div class="upload-wrapper <?php echo $title_area_background_image ? 'has-image' : ''; ?>">
							<div class="image-wrapper">

								<div class="placeholder"><?php _e( 'No File Selected' ) ?></div>

								<div class="image-holder">
									<?php if( $title_area_background_image ) {
										echo wp_get_attachment_image( $title_area_background_image, 'medium' );
									} ?>
								</div>
							</div>
							<div class="buttons-wrapper">
								<button type="button" class="button button-upload">
									<?php esc_html_e( 'Select File', 'boombox' ); ?>
								</button>
								<button type="button" class="button button-remove">
									<?php esc_html_e( 'Remove', 'boombox' ); ?>
								</button>
							</div>
							<input type="hidden"
							       class="image_id"
							       name="title_area_background_image"
							       id="title_area_background_image"
							       value="<?php echo $title_area_background_image; ?>" />
						</div>
					</td>
				</tr>

				<?php /***** Background Image Size */ ?>
				<tr class="form-field bb-title-area-bg-image-size-wrap">
					<th scope="row">
						<label for="title_area_background_image_size">
							<?php _e( 'Background Image Size', 'boombox' ); ?>
						</label>
					</th>
					<td>
						<select name="title_area_background_image_size" id="title_area_background_image_size">
							<?php
							foreach( $choices_helper->get_template_header_background_image_size_choices() as $key => $label ) { ?>
								<option value="<?php echo $key; ?>" <?php selected( $key, $title_area_background_image_size ); ?>>
									<?php echo $label; ?>
								</option>
							<?php } ?>
						</select>
					</td>
				</tr>

				<?php /***** Background Image Position */ ?>
				<tr class="form-field bb-title-area-bg-image-position-wrap">
					<th scope="row">
						<label for="title_area_background_image_position">
							<?php _e( 'Background Image Position', 'boombox' ); ?>
						</label>
					</th>
					<td>
						<select name="title_area_background_image_position" id="title_area_background_image_position">
							<?php
							foreach( $choices_helper->get_template_header_background_image_position_choices() as $key => $label ) { ?>
								<option value="<?php echo $key; ?>" <?php selected( $key, $title_area_background_image_position ); ?>>
									<?php echo $label; ?>
								</option>
							<?php } ?>
						</select>
					</td>
				</tr>

				<?php /***** Background Image Repeat */ ?>
				<tr class="form-field bb-title-area-bg-image-repeat-wrap">
					<th scope="row">
						<label for="title_area_background_image_repeat">
							<?php _e( 'Background Image Repeat', 'boombox' ); ?>
						</label>
					</th>
					<td>
						<select name="title_area_background_image_repeat" id="title_area_background_image_repeat">
							<?php
							foreach( $choices_helper->get_template_header_background_image_repeat_choices() as $key => $label ) { ?>
								<option value="<?php echo $key; ?>" <?php selected( $key, $title_area_background_image_repeat ); ?>>
									<?php echo $label; ?>
								</option>
							<?php } ?>
						</select>
					</td>
				</tr>

				<tr><td colspan="2" style="padding: 0;"><hr></td></tr>

				<?php /***** -/end Title Area */ ?>
				<?php
				// allow third part to add custom meta fields including child theme
				do_action( 'boombox/admin/category/meta-boxes/edit-fields', $this, $term ); ?>

				</tbody>
			</table>
			<?php ob_end_flush();
		}

		/**
		 * Save category function.
		 *
		 * @param mixed $term_id Term ID being saved
		 */
		public function save_category_fields( $term_id ) {
			$nonce_name = isset( $_POST[ 'term_meta_nonce' ] ) ? $_POST[ 'term_meta_nonce' ] : '';
			$nonce_action = 'update_term_meta';

			// Check if nonce is set.
			if ( ! isset( $nonce_name ) ) {
				return;
			}

			// Check if nonce is valid.
			if ( ! wp_verify_nonce( $nonce_name, $nonce_action ) ) {
				return;
			}

			if ( isset( $_POST[ 'cat_thumbnail_id' ] ) ) {
				update_term_meta( $term_id, 'cat_thumbnail_id', absint( $_POST[ 'cat_thumbnail_id' ] ) );
			}

			if ( isset( $_POST[ 'cat_icon_name' ] ) ) {
				update_term_meta( $term_id, 'cat_icon_name', sanitize_text_field( $_POST[ 'cat_icon_name' ] ) );
			}

			if ( isset( $_POST[ 'term_image_icon_id' ] ) ) {
				update_term_meta( $term_id, 'term_image_icon_id', sanitize_text_field( $_POST[ 'term_image_icon_id' ] ) );
			}

			if ( isset( $_POST[ 'term_icon_background_color' ] ) ) {
				update_term_meta( $term_id, 'term_icon_background_color', sanitize_text_field( $_POST[ 'term_icon_background_color' ] ) );
			}

			if ( isset( $_POST[ 'hide_featured_area' ] ) ) {
				$hide_featured_area = ( isset( $_POST[ 'hide_featured_area' ] ) && $_POST[ 'hide_featured_area' ] ) ? 1 : 0;
				update_term_meta( $term_id, 'hide_featured_area', $hide_featured_area );
			}

			if ( isset( $_POST[ 'hide_attached_posts_featured_media' ] ) ) {
				$hide_attached_posts_featured_media = $_POST[ 'hide_attached_posts_featured_media' ] ? 1 : 0;
				update_term_meta( $term_id, 'hide_attached_posts_featured_media', $hide_attached_posts_featured_media );
			}

			if( isset( $_POST['title_area_style'] ) ){
				update_term_meta( $term_id, 'title_area_style', sanitize_text_field( $_POST['title_area_style'] ) );
			}

			if( isset( $_POST['title_area_background_container'] ) ){
				update_term_meta( $term_id, 'title_area_background_container', sanitize_text_field( $_POST[ 'title_area_background_container' ] ) );
			}

			if( isset( $_POST['title_area_text_color'] ) ){
				update_term_meta( $term_id, 'title_area_text_color', sanitize_text_field( $_POST['title_area_text_color'] ) );
			}

			if( isset( $_POST['title_area_bg_color'] ) ){
				update_term_meta( $term_id, 'title_area_bg_color', sanitize_text_field( $_POST['title_area_bg_color'] ) );
			}

			if( isset( $_POST['title_area_gradient_color'] ) ){
				update_term_meta( $term_id, 'title_area_gradient_color', sanitize_text_field( $_POST['title_area_gradient_color'] ) );
			}

			if( isset( $_POST['title_area_bg_gradient_direction'] ) ){
				update_term_meta( $term_id, 'title_area_bg_gradient_direction', sanitize_text_field( $_POST['title_area_bg_gradient_direction'] ) );
			}

			if( isset( $_POST['title_area_background_image'] ) ){
				update_term_meta( $term_id, 'title_area_background_image', sanitize_text_field( $_POST['title_area_background_image'] ) );
			}

			if( isset( $_POST['title_area_background_image_size'] ) ){
				update_term_meta( $term_id, 'title_area_background_image_size', sanitize_text_field( $_POST['title_area_background_image_size'] ) );
			}

			if( isset( $_POST['title_area_background_image_position'] ) ){
				update_term_meta( $term_id, 'title_area_background_image_position', sanitize_text_field( $_POST['title_area_background_image_position'] ) );
			}

			if( isset( $_POST['title_area_background_image_repeat'] ) ){
				update_term_meta( $term_id, 'title_area_background_image_repeat', sanitize_text_field( $_POST['title_area_background_image_repeat'] ) );
			}

			do_action( 'boombox/admin/category/meta-boxes/save', $this, $term_id );

		}

		/**
		 * Sort array by key 'name'
		 *
		 * @param $a
		 * @param $b
		 *
		 * @return int
		 */
		public function sort_by_name( $a, $b ) {
			if ( $a[ 'name' ] < $b[ 'name' ] ) return -1;
			if ( $a[ 'name' ] > $b[ 'name' ] ) return 1;

			return 0;
		}
	}
}

Boombox_Category_Custom_Meta_Box::get_instance();