jQuery(function ($) {
    'use strict';

    $(document).ready( function() {

        ////////////////////////////// Category //////////////////////////////

        /**
         * Category Thumbnail
         */
        // Only show the "remove image" button when needed
        $('.thumbnail_id').each(function(){
            var _this = $(this),
                _wrap = _this.closest( '.row-thumbnail' ),
                _remove_btn = _wrap.find( '.remove_image_button' );

            if( ! _this.val() ) {
                _remove_btn.hide();
            }
        });

        // Uploading files
        var file_frame;
        $( document ).on( 'click', '.upload_image_button', function (event) {

            var _this = $(this),
                _wrap = _this.closest( '.row-thumbnail' ),
                _thumbnail_wrap = _wrap.find( '.thumbnail-wrap' ),
                _buttons_wrap = _wrap.find( '.buttons-wrap' );

            event.preventDefault();

            // If the media frame already exists, reopen it.
            if (file_frame) {
                file_frame.open();
                return;
            }

            // Create the media frame.
            file_frame = wp.media.frames.downloadable_file = wp.media({
                title: 'Choose an image',
                button: {
                    text: 'Use image'
                },
                multiple: false
            });

            // When an image is selected, run a callback.
            file_frame.on( 'select', function () {
                var attachment = file_frame.state().get( 'selection' ).first().toJSON();

                _buttons_wrap.find( '.thumbnail_id' ).val( attachment.id );
                _thumbnail_wrap.find( 'img' ).attr( 'src', attachment.url ).show();
                _buttons_wrap.find( '.remove_image_button' ).show();
            });

            // Finally, open the modal.
            file_frame.open();
        });

        $( document ).on( 'click', '.remove_image_button', function () {
            var _this = $(this),
                _wrap = _this.closest( '.row-thumbnail' ),
                _thumbnail_wrap = _wrap.find( '.thumbnail-wrap' ),
                _default_img = _thumbnail_wrap.data( 'default-img' ) || false,
                _buttons_wrap = _wrap.find( '.buttons-wrap' );

            if( _default_img ) {
                _thumbnail_wrap.find('img').attr('src', _default_img).show();
            } else {
                _thumbnail_wrap.find('img').hide();
            }
            _buttons_wrap.find( '.thumbnail_id' ).val('');
            _buttons_wrap.find( '.remove_image_button' ).hide();
            return false;
        });

        /**
         *  Category Icon
         */
        var boombox_category_icon_container = $( "#cat_icon_name");
        if( boombox_category_icon_container.length > 0){
            $.widget( 'custom.iconselectmenu', $.ui.selectmenu, {
                _renderItem: function( ul, item ) {
                    var li = $( "<li>", { text: item.label } );

                    $( "<span>", {
                        "class": "icon " + item.element.attr( "data-class" )
                    }).prependTo( li );

                    return li.appendTo( ul );
                }
            });
            boombox_category_icon_container.iconselectmenu().iconselectmenu( 'menuWidget' ).addClass( 'ui-menu-icons customicons' );
        }


        ////////////////////////////// Page //////////////////////////////

        /**
         * Show / hide listing settings
         */
        var boombox_listing_type = $( '#boombox_listing_type' );
        boombox_run_show_hide_element_functionality( boombox_listing_type, '.boombox-listing-settings' );

        /**
         * Show / hide pagination elements
         */
        var boombox_pagination_type = $( '#boombox_pagination_type' );
        boombox_run_show_hide_element_functionality( boombox_pagination_type, '.boombox-page-form-posts-per-page' );

        /**
         * Show / hide adv elements
         */
        var boombox_adv = $( '#boombox_page_ad' );
        boombox_run_show_hide_element_functionality( boombox_adv, '.boombox-page-form-adv-instead' );

        /**
         * Show / hide newsletter elements
         */
        var boombox_newsletter = $( '#boombox_page_newsletter' );
        boombox_run_show_hide_element_functionality( boombox_newsletter, '.boombox-page-form-newsletter-instead' );

        /**
         * Show / hide product elements
         */
        var boombox_products = $( '#boombox_page_products_inject' );
        boombox_run_show_hide_element_functionality( boombox_products, '.boombox-page-form-products-sentence' );

        var posts_per_page = $( '#boombox_posts_per_page' );
        $( posts_per_page ).on( 'change', function( e ){
            var _this = $(this),
                _page_adv_condition_input = $( '#boombox_page_ad' ),
                _page_adv_position_input = $( '#boombox_inject_ad_instead_post'),
                _page_newsletter_condition_input = $( '#boombox_page_newsletter' ),
                _page_newsletter_position_input = $( '#boombox_inject_newsletter_instead_post'),
                _page_products_condition_input = $( '#boombox_page_products_inject' ),
                _page_products_position_input = $( '#boombox_page_injected_products_position' );

            if( 'none' != _page_adv_condition_input.val() ) {
                _page_adv_position_input.attr( 'max', _this.val() );
            } else {
                _page_adv_position_input.removeAttr( 'max' );
            }
            if( 'none' != _page_newsletter_condition_input.val() ) {
                _page_newsletter_position_input.attr( 'max', _this.val() );
            } else {
                _page_newsletter_position_input.removeAttr( 'max' );
            }
            if( 'none' != _page_products_condition_input.val() ) {
                _page_products_position_input.attr( 'max', _this.val() );
            } else {
                _page_products_position_input.removeAttr( 'max' );
            }
        } );

        $( '#boombox_page_ad, #boombox_page_newsletter, #boombox_page_products_inject' ).on( 'change', function(){
            posts_per_page.trigger( 'change' );
        } );

        /**
         * Running show/hide elements functionality
         *
         * @param selected_element
         * @param elements_selector
         */
        function boombox_run_show_hide_element_functionality( selected_element, elements_selector ){
            if( selected_element.length > 0 ){
                var selected_val = selected_element.val();
                var elements = selected_element.closest('.boombox-advanced-fields').find( elements_selector );
                boombox_show_hide_elements( selected_val, elements );

                selected_element.change( function() {
                    var cur_selected_val = $( this ).val();
                    boombox_show_hide_elements( cur_selected_val, elements );
                } );
            }
        }

        /**
         * Show/hide elements
         *
         * @param selected_val
         * @param elements
         */
        function boombox_show_hide_elements( selected_val, elements ){
            if( 'none' == selected_val ){
                elements.fadeOut();
            }else{
                elements.fadeIn();
            }
        }


        ////////////////////////////// Nav Menus //////////////////////////////

        var boombox_menu_item_icon = $( ".edit-menu-item-icon");
        if( boombox_menu_item_icon.length > 0 ){
            $.widget( 'custom.iconselectmenu', $.ui.selectmenu, {
                _renderItem: function( ul, item ) {
                    var li = $( "<li>", { text: item.label } );

                    $( "<span>", {
                        "class": "icon " + item.element.attr( "data-class" )
                    }).prependTo( li );

                    return li.appendTo( ul );
                }
            });
            $.each( boombox_menu_item_icon, function(){
                $( this ).addClass('menu-item-custom-select');
                $( this ).iconselectmenu().iconselectmenu( 'menuWidget' ).addClass( 'ui-menu-icons customicons' );
            });

            jQuery("#post-body-content .menu").bind("DOMSubtreeModified", function() {
                $(".pending .edit-menu-item-icon").each( function(){
                    if( !$( this).hasClass('menu-item-custom-select') ) {
                        $( this ).iconselectmenu().iconselectmenu('menuWidget').addClass('ui-menu-icons customicons');
                        $( this ).addClass('menu-item-custom-select');
                    }
                });
            });

        }

        ////////////////////////////// Tabs //////////////////////////////

        var tabActive = $('.boombox-admin-tabs-menu>li.active');
        if( tabActive.length > 0 ){
            for (var i = 0; i < tabActive.length; i++) {
                var tab_id = $(tabActive[i]).children().attr('href');

                $(tab_id).addClass('active').show();
            }
        }

        $('.boombox-admin-tabs-menu a').on('click', function(e){
            var tab = $(this);
            var tab_id = tab.attr('href');
            var tab_wrap = tab.closest('.boombox-admin-tabs');
            var tab_content = tab_wrap.find('.boombox-admin-tab-content');

            tab.parent().addClass("active");
            tab.parent().siblings().removeClass('active');
            tab_content.not(tab_id).removeClass('active').hide();
            $(tab_id).addClass('active').fadeIn(500);

            e.preventDefault();
        });

        /***** remove iframe from featured video url field */
        $( '.boombox-advanced-fields #boombox_video_url' ).on( 'change', function(){
            var _this = $(this),
                _value = _this.val();

            if( _value.indexOf( '<iframe' ) != '-1' ) {
                var matches = _value.match( /src="([^"]+)"/ );
                if( matches ) {
                    _this.val( matches[1] );
                }
            }
        } );

    });

    /** Fields dependency */

    function is_field_visible( selector, value, compare ) {
        var _node = $(selector),
            _sel_val = _node.val();
        _sel_val = typeof _sel_val == 'undefined' ? 0 : _sel_val;

        switch ( compare ) {
            case '===':
                var _show = ( _sel_val === value ) ? true : false;
                break;
            case '==':
            case '=':
                var _show = ( _sel_val == value ) ? true : false;
                break;
            case '!==':
                var _show = ( _sel_val !== value ) ? true : false;
                break;
            case '!=':
                var _show = ( _sel_val != value ) ? true : false;
                break;
            case '>=':
                var _show = ( value >= _sel_val ) ? true : false;
                break;
            case '<=':
                var _show = ( value <= _sel_val ) ? true : false;
                break;
            case '>':
                var _show = ( value > _sel_val ) ? true : false;
                break;
            case '<':
                var _show = ( value < _sel_val ) ? true : false;
                break;
            case 'IN':
                var _show = value.indexOf( _sel_val ) != '-1' ? true : false;
                break;
            case 'NOT IN':
                var _show = value.indexOf( _sel_val ) == '-1' ? true : false;
                break;
            default:
                var _show = ( _sel_val == value ) ? true : false;
        }

        return _show;
    }

    // radio
    $( '.boombox-advanced-fields input[type="radio"], .boombox-advanced-fields input[type="checkbox"], .boombox-advanced-fields select' ).on( 'change', function(){

        var _node = $(this),
            _id = _node.attr( 'id' ),
            _value = _node.val(),
            _depended_data_holders = $( '.boombox-advanced-fields .bb-superior-' + _id );

        if( _depended_data_holders.length <= 0 ) {
            return false;
        }

        for( var i=0; i<_depended_data_holders.length; i++ ) {
            var
                _data_holder = $( _depended_data_holders[i] ),
                _wrapper = _data_holder.parent(),
                _json = JSON.parse( _data_holder.text() );


            if( _json ) {
                var _is_visible = ( _json.relation == 'AND' );
                for( var j=0; j<_json.fields.length; j++ ) {

                    var _show = is_field_visible( _json.fields[j].jq_selector, _json.fields[j].value, _json.fields[j].compare );

                    if( _json.relation == 'AND' ) {
                        _is_visible = _is_visible && _show;
                    } else {
                        _is_visible = _is_visible || _show;
                    }
                }

                if( _is_visible ) {
                    _wrapper.removeClass( 'bb-hidden' );
                } else {
                    _wrapper.addClass( 'bb-hidden' );
                }
            }
        }

    } );

    // image radio
    $( '.boombox-advanced-fields .boombox-form-row-radio-image .field-list-item' ).on( 'click', function(){
        var _this = $(this);

        if( _this.is( '.selected' ) ) {
            return;
        }

        _this.addClass('selected')
            .siblings().removeClass( 'selected' )
            .end().find( 'input[type="radio"]' ).prop( 'checked', true ).trigger( 'change' );
    } );

    // color picker
    if( $('.boombox-form-row-color, .boombox-form-row-multicolor' ).length > 0 ) {
        $('.boombox-form-row-color input, .boombox-form-row-multicolor input').wpColorPicker({
            change: function (event, ui) {},
            clear: function () {},
            hide: true
        });
    }

    // image
    (function(){

        // Media library open button functionality
        $( document ).on( 'click', '.boombox-form-row-image .button-upload', function ( event ) {

            var _this = $(this),
                _upload_wrapper = _this.closest( '.upload-wrapper' ),
                _hidden_field = _upload_wrapper.find( '.image_id' ),
                _image_wrapper = _upload_wrapper.find( '.image-wrapper' ),
                _image_holder = _image_wrapper.find( '.image-holder' ),
                _buttons_wraper = _upload_wrapper.find( '.buttons-wrapper' ),
                _file_frame = _upload_wrapper.data( 'file_frame' );

            event.preventDefault();

            // If the media frame already exists, reopen it.
            if ( _file_frame ) {
                _file_frame.open();
                return;
            }

            // Create the media frame.
            _file_frame = wp.media.frames.downloadable_file = wp.media({
                multiple: false
            });

            // When an image is selected, run a callback.
            _file_frame.on( 'select', function () {
                var
                    _image_data = _file_frame.state().get( 'selection' ).first().toJSON(),
                    _old_image = _image_holder.find( 'img' ),
                    _alt = _image_data.name,
                    _url = _image_data.url,
                    _new_image = '';

                if( _image_data.hasOwnProperty( 'sizes' ) ) {
                    if( _image_data.sizes.hasOwnProperty( 'medium' ) ) {
                        _url = _image_data.sizes.medium.url;
                    } else if( _image_data.sizes.hasOwnProperty( 'thumbnail' ) ) {
                        _url = _image_data.sizes.thumbnail.url;
                    } else if( _image_data.sizes.hasOwnProperty( 'full' ) ) {
                        _url = _image_data.sizes.full.url;
                    }
                }

                _new_image = '<img src="' + _url + '" alt="' + _alt + '" />';

                _hidden_field.val( _image_data.id );
                if( _old_image.length > 0 ) {
                    _old_image.replaceWith( _new_image );
                } else {
                    _image_holder.append( _new_image );
                }
                _upload_wrapper.addClass( 'has-image' );

            });

            $.data( _upload_wrapper, '_file_frame', _file_frame );

            // Finally, open the modal.
            _file_frame.open();

        });

        $( document ).on( 'click', '.boombox-form-row-image .placeholder', function(){
            $(this).closest( '.boombox-form-row-image' ).find( '.button-upload' ).trigger( 'click' );
        });

        // remove button functionality
        $( document ).on( 'click', '.boombox-form-row-image .button-remove', function ( event ) {
            var _this = $(this),
                _upload_wrapper = _this.closest( '.upload-wrapper' ),
                _hidden_field = _upload_wrapper.find( '.image_id' );

            event.preventDefault();

            _hidden_field.val( '' );
            _upload_wrapper.removeClass( 'has-image' );

        });

    })();

});