<?php
/**
 * Text field for metaboxes
 *
 * @package BoomBox_Theme
 * @since   2.0.0
 * @verion  2.0.0
 */

// Prevent direct script access.
if ( ! defined( 'ABSPATH' ) ) {
	die( 'No direct script access allowed' );
}

if( ! class_exists( 'AIOM_Base_Field' ) ) {
	require_once ( 'base-field.php' );
}

if( ! class_exists( 'AIOM_Text_Field' ) && class_exists( 'AIOM_Base_Field' ) ) {

	/**
	 * Class AIOM_Text_Field
	 */
	class AIOM_Text_Field extends AIOM_Base_Field {

		/**
		 * Render field
		 */
		public function render() { ?>
			<div class="boombox-form-row boombox-form-row-text <?php echo $this->get_wrapper_class(); ?>"
				<?php echo $this->get_wrapper_attributes(); ?>>
				<div class="label-col">
					<label for="<?php echo $this->get_id(); ?>"><?php echo $this->get_label(); ?></label>
				</div>
				<div class="control-col">
					<input type="text"
					       id="<?php echo $this->get_id(); ?>"
					       name="<?php echo $this->get_name(); ?>"
					       class="<?php echo $this->get_class(); ?>"
						<?php echo $this->get_attributes(); ?>
						   value="<?php echo $this->get_value(); ?>"/>
					<?php if ($description = $this->get_description()) { ?>
						<p class="description"><?php echo $description; ?></p>
					<?php } ?>
				</div>
				<?php echo $this->get_active_callback(); ?>
			</div>
			<?php
		}

	}

}