<?php
/**
 * Image Radio HTML field for metaboxes
 *
 * @package BoomBox_Theme
 * @since   2.0.0
 * @verion  2.0.0
 */

// Prevent direct script access.
if ( ! defined( 'ABSPATH' ) ) {
	die( 'No direct script access allowed' );
}

if( ! class_exists( 'AIOM_Base_Field' ) ) {
	require_once ( 'base-field.php' );
}

if( ! class_exists( 'AIOM_Radio_Image_Field' ) && class_exists( 'AIOM_Base_Field' ) ) {

	/**
	 * Class AIOM_Radio_Image_Field
	 */
	class AIOM_Radio_Image_Field extends AIOM_Base_Field {

		/**
		 * Holds field choices
		 * @var array
		 */
		private $choices;

		/**
		 * Get field choices
		 * @return array
		 */
		private function get_choices() {
			return $this->choices;
		}

		/**
		 * AIOM_Radio_Image_Field constructor.
		 *
		 * @param array            $args
		 * @param bool|null|string $tab_id
		 * @param array            $data
		 * @param array            $structure
		 * @see AIOM_Base_Field::__construct()
		 */
		public function __construct( array $args, $tab_id, array $data, array $structure ) {
			parent::__construct( $args, $tab_id, $data, $structure );

			/***** Field choices */
			$choices = isset( $args['choices'] ) && is_array( $args['choices'] ) ? $args['choices'] : array();
			$this->choices = $choices;
		}

		/**
		 * Render field
		 */
		public function render() { ?>
			<div class="boombox-form-row boombox-form-row-radio-image boombox-field-list <?php echo
			$this->get_wrapper_class();?>"
				<?php echo $this->get_wrapper_attributes(); ?>>
				<div class="label-col">
					<label for="<?php echo $this->get_id(); ?>"><?php echo $this->get_label(); ?></label>
				</div>

				<div class="control-col">
					<div class="field-list">
						<?php
						foreach( $this->get_choices() as $key => $value ) {
							$checked = checked( $this->get_value(), esc_html( esc_attr( $key ) ), false ); ?>
							<div class="field-list-item <?php echo $checked ? 'selected' : ''; ?>">
								<input type="radio"
								       id="<?php echo $this->get_id(); ?>"
								       name="<?php echo $this->get_name(); ?>"
								       value="<?php echo esc_html( esc_attr( $key ) ); ?>"
								       class="bb-hidden <?php echo $this->get_class(); ?>"
									<?php echo $checked; ?>
									<?php echo $this->get_attributes(); ?> />
								<?php if( $value ) { ?>
									<img src="<?php echo $value; ?>" />
								<?php } ?>
							</div>
						<?php } ?>
					</div>
					<?php if( $description = $this->get_description() ) { ?>
						<p class="description"><?php echo $description; ?></p>
					<?php } ?>
				</div>
				<?php echo $this->get_active_callback(); ?>
			</div>
			<?php
		}

	}

}