<?php
/**
 * Color Picker field for metaboxes
 *
 * @package BoomBox_Theme
 * @since   2.0.0
 * @verion  2.0.0
 */

// Prevent direct script access.
if ( ! defined( 'ABSPATH' ) ) {
	die( 'No direct script access allowed' );
}

if ( ! class_exists( 'AIOM_Base_Field' ) ) {
	require_once( 'base-field.php' );
}

if ( ! class_exists( 'AIOM_Multicolor_Field' ) && class_exists( 'AIOM_Base_Field' ) ) {

	/**
	 * Class AIOM_Multicolor_Field
	 */
	class AIOM_Multicolor_Field extends AIOM_Base_Field {

		/**
		 * Holds field choices
		 * @var array
		 */
		private $choices;

		/**
		 * Get field choices
		 * @return array
		 */
		private function get_choices() {
			return $this->choices;
		}

		/**
		 * AIOM_Multicheck_Field constructor.
		 *
		 * @param array            $args
		 * @param bool|null|string $tab_id
		 * @param array            $data
		 * @param array            $structure
		 *
		 * @see AIOM_Base_Field::__construct()
		 */
		public function __construct( array $args, $tab_id, array $data, array $structure ) {
			parent::__construct( $args, $tab_id, $data, $structure );

			/***** Field choices */
			$choices = isset( $args[ 'choices' ] ) && is_array( $args[ 'choices' ] ) ? $args[ 'choices' ] : array();
			$this->choices = $choices;
		}

		/**
		 * Get form field attributes
		 * @return string
		 */
		protected function get_choice_attribute( $key ) {
			$values = $this->get_value();
			return $this->get_attributes() . ' data-default-color="' . $values[ $key ] . '"';
		}



		/**
		 * Enqueue color picker assets
		 */
		public function enqueue() {
			wp_enqueue_style( 'wp-color-picker' );
			wp_enqueue_script( 'wp-color-picker' );
		}

		/**
		 * Render field
		 */
		public function render() {
			$values = $this->get_value(); ?>
			<div class="boombox-form-row boombox-form-row-multicolor <?php echo $this->get_wrapper_class(); ?>"
				<?php echo $this->get_wrapper_attributes(); ?>>
				<div class="label-col">
					<label for="<?php echo $this->get_id(); ?>"><?php echo $this->get_label(); ?></label>
				</div>
				<div class="control-col">
					<div class="field-list">
					<?php foreach ( $this->get_choices() as $key => $label ) { ?>
						<div class="field-list-item">
							<label><?php echo $label; ?></label>
							<input type="text"
						       id="<?php echo $this->get_id(); ?>"
					           name="<?php echo $this->get_name(); ?>[<?php echo $key; ?>]"
						       class="<?php echo $this->get_class(); ?>"
						       value="<?php echo $values[ $key ]; ?>"
							   <?php echo $this->get_choice_attribute( $key ); ?>
							/>
						</div>
					<?php } ?>
					</div>
					<?php if ( $description = $this->get_description() ) { ?>
						<p class="description"><?php echo $description; ?></p>
					<?php } ?>
				</div>
				<?php echo $this->get_active_callback(); ?>
			</div>
			<?php
		}

	}

}