<?php
/**
 * Dropdown field for metaboxes
 *
 * @package BoomBox_Theme
 * @since   2.0.0
 * @verion  2.0.0
 */

// Prevent direct script access.
if ( ! defined( 'ABSPATH' ) ) {
	die( 'No direct script access allowed' );
}

if( ! class_exists( 'AIOM_Base_Field' ) ) {
	require_once ( 'base-field.php' );
}

if( ! class_exists( 'AIOM_Select_Field' ) && class_exists( 'AIOM_Base_Field' ) ) {

	/**
	 * Class AIOM_Select_Field
	 */
	class AIOM_Select_Field extends AIOM_Base_Field {

		/**
		 * Holds field choices
		 * @var array
		 */
		private $choices;

		/**
		 * Get field choices
		 * @return array
		 */
		private function get_choices() {
			return $this->choices;
		}

		/**
		 * AIOM_Select_Field constructor.
		 *
		 * @param array            $args
		 * @param bool|null|string $tab_id
		 * @param array            $data
		 * @param array            $structure
		 * @see AIOM_Base_Field::__construct()
		 */
		public function __construct( array $args, $tab_id, array $data, array $structure ) {
			parent::__construct( $args, $tab_id, $data, $structure );

			/***** Field choices */
			$choices = isset( $args['choices'] ) && is_array( $args['choices'] ) ? $args['choices'] : array();
			$this->choices = $choices;
		}

		/**
		 * Render field
		 */
		public function render() { ?>
			<div class="boombox-form-row boombox-form-row-dropdown <?php echo $this->get_wrapper_class(); ?>"
				<?php echo $this->get_wrapper_attributes(); ?>>
				<div class="label-col">
					<label for="<?php echo $this->get_id(); ?>"><?php echo $this->get_label(); ?></label>
				</div>
				<div class="control-col">
					<select
							id="<?php echo $this->get_id(); ?>"
							class="<?php echo $this->get_class(); ?>"
							name="<?php echo $this->get_name(); ?><?php echo $this->has_attribute( 'multiple' ) ? '[]' : ''; ?>"
						<?php echo $this->get_attributes(); ?>>

						<?php foreach ( $this->get_choices() as $key => $value ) {
							if ( is_array( $this->get_value() ) ) {
								$selected = selected( in_array( $key, $this->get_value(), true ), true, false );
							} else {
								$selected = selected( $this->get_value(), $key, false );
							}
							?>
							<option value="<?php echo esc_html( esc_attr( $key ) ); ?>" <?php echo $selected; ?>>
								<?php echo esc_html( $value ); ?>
							</option>
						<?php } ?>
					</select>
					<?php if( $description = $this->get_description() ) { ?>
						<p class="description"><?php echo $description; ?></p>
					<?php } ?>
				</div>
				<?php echo $this->get_active_callback(); ?>
			</div>
			<?php
		}

	}

}