<?php
/**
 * The template part for generating single post sticky next page navigation.
 *
 * @package Boombox_Theme
 * @since   2.0.0
 * @version 2.0.0
 */

// Prevent direct script access.
if ( ! defined( 'ABSPATH' ) ) {
	die( 'No direct script access allowed' );
}

if ( is_single() && boombox_get_theme_option( 'single_post_general_floating_navbar' ) && have_posts() ) {
	the_post(); ?>

	<div class="bb-sticky bb-fixed-next-page">
		<nav class="bb-sticky-el fixed-next-page">
			<div class="container">
				<?php
				the_title( '<div class="post-title"><h2>', '</h2></div>' );

				global $page, $numpages;
				boombox_single_post_link_pages( array(
					'before'             => '<div class="next-pagination">',
					'after'              => '</div>',
					'prev'               => false,
					'link_wrap_before'   => '<span class="%s">',
					'link_wrap_after'    => '</span>',
					'go_to_prev_next'    => boombox_get_theme_option( 'single_post_general_next_prev_buttons' ),
					'reverse'            => ( boombox_get_theme_option( 'single_post_general_navigation_direction' ) == 'to-oldest' ),
					'paging'             => '<span class="pages">' . sprintf( '<b>%1$d</b> / %2$d', $page, $numpages ) . '</span>',
					'previous_page_link' => '',
					'next_page_link'     => '<i class="icon icon-chevron-right"></i><span class="text">' . apply_filters( 'boombox/fixed_header/next_page_link_label', esc_html__( 'Next', 'boombox' ) ) . '</span>',
					'previous_post_link' => '',
					'next_post_link'     => '<i class="icon icon-chevron-right"></i><span class="text">' . apply_filters( 'boombox/fixed_header/next_post_link_label', esc_html__( 'Next Post', 'boombox' ) ) . '</span>',
				) );
				?>
			</div>
		</nav>
	</div>

<?php }
rewind_posts();
wp_reset_query(); ?>