<?php
/**
 * The template part for displaying single post "Don't Miss" section.
 *
 * @package BoomBox_Theme
 * @since   1.0.0
 * @version 2.0.0
 */

// Prevent direct script access.
if ( ! defined( 'ABSPATH' ) ) {
	die( 'No direct script access allowed' );
}

$boombox_disable_dont_miss_block = boombox_get_theme_option( 'single_post_related_posts_disable_dont_miss_block' );
$boombox_dont_miss_entries_per_page = boombox_get_theme_option( 'single_post_related_posts_dont_miss_entries_per_page' );
$boombox_dont_miss_entries_heading = boombox_get_theme_option( 'single_post_related_posts_dont_miss_entries_heading' );
$boombox_dont_miss_listing_type = apply_filters( 'boombox_dont_miss_listing_type', 'grid' );

if ( ! $boombox_disable_dont_miss_block ):
	$boombox_dont_miss_posts = boombox_get_dont_miss_posts_items( 'dont_miss', $boombox_dont_miss_entries_per_page );
	if ( NULL != $boombox_dont_miss_posts && count( $boombox_dont_miss_posts->posts ) > 0 ): ?>
		<div class="other-posts bb-post-collection <?php echo boombox_get_list_type_classes( $boombox_dont_miss_listing_type, array( 'col-3' ) ); ?>">

			<?php if ( $boombox_dont_miss_entries_heading ): ?>
				<h2 class="title"><?php echo esc_html( $boombox_dont_miss_entries_heading ); ?></h2>
			<?php endif; ?>

			<ul class="post-items">

				<?php while ( $boombox_dont_miss_posts->have_posts() ) : $boombox_dont_miss_posts->the_post(); ?>

					<?php get_template_part( 'template-parts/content', $boombox_dont_miss_listing_type ); ?>

				<?php endwhile; ?>

				<?php wp_reset_postdata(); ?>
			</ul>

		</div>
		<?php boombox_the_advertisement( 'boombox-single-after-dont-miss-section', array( 'class' => 'large' ) );
	endif;
endif;
wp_reset_query(); ?>