<?php
/**
 * The template part for displaying the post fixed navigation
 *
 * @package BoomBox_Theme
 * @since   1.0.0
 * @version 2.0.0
 */

// Prevent direct script access.
if ( ! defined( 'ABSPATH' ) ) {
	die( 'No direct script access allowed' );
}

$boombox_reverse_pagination = ( boombox_get_theme_option( 'single_post_general_navigation_direction' ) == 'to-oldest' );
?>

<div class="fixed-pagination">
	<?php

	$boombox_post = $boombox_reverse_pagination ? get_next_post() : get_previous_post();
	$boombox_post = apply_filters( 'boombox_fixed_navigation_post', $boombox_post, 'prev' );

	if ( $boombox_post ) { ?>
		<div class="page prev">
			<?php $boombox_post_url = esc_url( get_permalink( $boombox_post->ID ) ); ?>
			<a class="arrow" href="<?php echo $boombox_post_url; ?>">
                <span class="info">
                    <i class="icon icon-chevron-left"></i>
                </span>
			</a>

			<a class="content" href="<?php echo $boombox_post_url; ?>">

				<?php if ( boombox_has_post_thumbnail( $boombox_post->ID ) ) { ?>
					<span class="thumb"><?php echo get_the_post_thumbnail( $boombox_post->ID, 'thumbnail' ); ?></span>
				<?php } ?>

				<span class="title"><?php echo wp_trim_words( $boombox_post->post_title, 10, '...' ); ?></span>

			</a>
		</div>
	<?php } ?>

	<?php
	$boombox_post = $boombox_reverse_pagination ? get_previous_post() : get_next_post();
	$boombox_post = apply_filters( 'boombox_fixed_navigation_post', $boombox_post, 'next' );

	if ( $boombox_post ) { ?>
		<div class="page next">
			<?php $boombox_post_url = esc_url( get_permalink( $boombox_post->ID ) ); ?>
			<a class="arrow " href="<?php echo $boombox_post_url; ?>">
                <span class="info">
                    <i class="icon icon-chevron-right"></i>
                </span>
			</a>
			<a class="content" href="<?php echo $boombox_post_url; ?>">

				<?php if ( boombox_has_post_thumbnail( $boombox_post->ID ) ) { ?>
					<span class="thumb"><?php echo get_the_post_thumbnail( $boombox_post->ID, 'thumbnail' ); ?></span>
				<?php } ?>

				<span class="title"><?php echo wp_trim_words( $boombox_post->post_title, 10, '...' ); ?></span>

			</a>
		</div>
	<?php } ?>

</div>