<?php
/**
 * The template part for displaying the registration form.
 *
 * @package BoomBox_Theme
 * @since   1.0.0
 * @version 2.0.0
 */

// Prevent direct script access.
if ( ! defined( 'ABSPATH' ) ) {
	die( 'No direct script access allowed' );
}

$auth_captcha_type = boombox_get_auth_captcha_type();
$options_set = boombox_get_theme_options_set( array(
	'extra_authentication_registration_popup_title',
	'extra_authentication_registration_popup_text',
	'extra_authentication_terms_of_use_page',
	'extra_authentication_privacy_policy_page',
	'extra_authentication_login_popup_title',
	'extra_authentication_enable_registration_captcha',
	'extra_authentication_google_recaptcha_site_key',
) ); ?>

<!-- Modal content -->
<div id="registration" class="light-modal authentication">
	<a href="#" class="modal-close"><i class="icon icon-close"></i></a>
	<div class="modal-body wrapper">
		<div class="content-wrapper">
			<header class="content-header">
				<?php if ( $options_set[ 'extra_authentication_registration_popup_title' ] ): ?>
					<h3 class="title"><?php echo esc_html( $options_set[ 'extra_authentication_registration_popup_title' ] ); ?></h3>
				<?php endif; ?>

				<?php if ( $options_set[ 'extra_authentication_registration_popup_text' ] ): ?>
					<div class="intro"><?php echo wp_kses_post( $options_set[ 'extra_authentication_registration_popup_text' ] ); ?></div>
				<?php endif; ?>
			</header>
			<div class="content-body">

				<?php if ( boombox_plugin_management_service()->is_plugin_active( 'wordpress-social-login/wp-social-login.php' ) ) { ?>
					<?php do_action( 'wordpress_social_login' ); ?>
				<?php } else { ?>
					<div class="clearfix"><?php do_action( 'boombox_before_register_form', 'register' ); ?></div>
				<?php } ?>

				<p class="status"></p>

				<form id="boombox-register" class="ajax-auth" action="register" method="post">
					<?php wp_nonce_field( 'ajax-register-nonce', 'signonsecurity' ); ?>
					<div class="input-field">
						<input type="email" name="signonemail" class="required"
						       placeholder="<?php esc_html_e( 'Your e-mail address', 'boombox' ); ?>">
					</div>
					<div class="input-field">
						<input type="text" name="signonusername" class="required"
						       placeholder="<?php esc_html_e( 'Your username', 'boombox' ); ?>">
					</div>
					<div class="input-field">
						<input type="password" name="signonpassword" class="required"
						       placeholder="<?php esc_html_e( 'Your password', 'boombox' ); ?>">
					</div>
					<?php if ( $options_set[ 'extra_authentication_enable_registration_captcha' ] ) { ?>
						<?php if ( $auth_captcha_type === 'image' ) { ?>
							<div class="input-field captcha-container loading">
								<div class="form-captcha">
									<img src="" alt="Captcha!" class="captcha">
									<a href="#refresh-captcha" class="auth-refresh-captcha refresh-captcha"></a>
								</div>
								<input type="text" name="signoncaptcha" class="required"
								       placeholder="<?php esc_html_e( 'Enter captcha', 'boombox' ); ?>">
							</div>
						<?php } else if ( $auth_captcha_type === 'google' && $options_set[ 'extra_authentication_google_recaptcha_site_key' ] ) { ?>
							<div class="input-field text-center">
								<div class="google-captcha-code" id="boombox-register-captcha"
								     data-boombox-sitekey="<?php echo $options_set[ 'extra_authentication_google_recaptcha_site_key' ]; ?>"></div>
							</div>
						<?php } ?>
					<?php } ?>
					<div class="input-field">
						<button class="bb-btn" type="submit"><?php esc_html_e( 'sign up', 'boombox' ); ?></button>
					</div>
				</form>
				<?php do_action( 'boombox_after_register_form' ); ?>
				<?php
				if ( $options_set[ 'extra_authentication_terms_of_use_page' ] || $options_set[ 'extra_authentication_privacy_policy_page' ] ):
					$boombox_links = false;
					$boombox_terms_of_use_link = $options_set[ 'extra_authentication_terms_of_use_page' ] ? sprintf( ' %1$s <a href="%2$s" target="_blank">%3$s</a> ', esc_html__( 'the', 'boombox' ), get_permalink( $options_set[ 'extra_authentication_terms_of_use_page' ] ), esc_html__( 'terms of use', 'boombox' ) ) : false;
					$boombox_privacy_policy_link = $options_set[ 'extra_authentication_privacy_policy_page' ] ? sprintf( ' %1$s <a href="%2$s" target="_blank">%3$s</a> ', esc_html__( 'the', 'boombox' ), get_permalink( $options_set[ 'extra_authentication_privacy_policy_page' ] ), esc_html__( 'privacy policy', 'boombox' ) ) : false;
					if ( $boombox_terms_of_use_link && $boombox_privacy_policy_link ) {
						$boombox_links = $boombox_terms_of_use_link . esc_html__( 'and', 'boombox' ) . $boombox_privacy_policy_link;
					} else if ( $boombox_terms_of_use_link ) {
						$boombox_links = $boombox_terms_of_use_link;
					} else if ( $boombox_privacy_policy_link ) {
						$boombox_links = $boombox_privacy_policy_link;
					}
					if ( $boombox_links ): ?>
						<p class="note"><?php printf( esc_html__( 'By signing up, you agree that you have read and accepted %s', 'boombox' ), $boombox_links ); ?></p>
						<?php
					endif;
				endif; ?>
			</div>
			<div class="content-footer">
				<div class="bottom">
					<div class="text"><?php esc_html_e( 'Back to ', 'boombox' ); ?></div>
					<a class="bb-btn bb-btn-default js-authentication"
					   href="#sign-in"><?php echo esc_html( $options_set[ 'extra_authentication_login_popup_title' ] ); ?></a>
				</div>
			</div>
		</div>
	</div>
</div>
