<?php
/**
 * The template part for displaying the site mobile navigation
 *
 * @package BoomBox_Theme
 * @since   2.0.0
 * @version 2.0.0
 */

// Prevent direct script access.
if ( ! defined( 'ABSPATH' ) ) {
	die( 'No direct script access allowed' );
}
$template_helper = Boombox_Template::init( 'header' );
if ( $template_helper->mobile_navigation_render_required && ! $template_helper->mobile_navigation_rendered ) {
	$badges_position = boombox_get_theme_option( 'header_layout_badges_position' ); ?>

	<div id="mobile-nav-bg"></div>
	<div id="mobile-navigation" class="bb-mobile-navigation">
		<button id="menu-close" class="close">
			<i class="icon icon-close"></i>
		</button>
		<div class="holder">
			<div class="more-menu">
				<div class="more-menu-header">
					<?php get_template_part( 'template-parts/header/search', 'box' ); ?>
				</div>
				<?php
				get_template_part( 'template-parts/header/navigation/header', 'top' );
				get_template_part( 'template-parts/header/navigation/header', 'bottom' );
				get_template_part( 'template-parts/header/navigation/burger', 'bottom' );
				if ( in_array( $badges_position, array( 'top', 'bottom' ) ) ) {
					get_template_part( 'template-parts/header/navigation/badges' );
				} ?>
				<div class="more-menu-footer">
					<?php get_template_part( 'template-parts/header/community' ); ?>
					<div class="social circle">
						<?php
						if ( function_exists( 'boombox_get_social_links' ) ) :
							echo boombox_get_social_links();
						endif; ?>
					</div>
				</div>
			</div>

		</div>
	</div>
	<?php
	$template_helper->mobile_navigation_render_required = false;
	$template_helper->mobile_navigation_rendered = true;
} ?>