<?php
/**
 * The template part for displaying the site mobile navigation "Brand Bottom" template
 *
 * @package BoomBox_Theme
 * @since   2.0.0
 * @version 2.0.0
 * @var $template_helper Boombox_Header_Template_Helper Header Template Helper
 */

// Prevent direct script access.
if ( ! defined( 'ABSPATH' ) ) {
	die( 'No direct script access allowed' );
}

$template_helper = Boombox_Template::init( 'header' );
$template_options = $template_helper->get_mobile_options();

echo $template_options[ 'before' ]; ?>
	<header class="bb-header header-mobile g-style g-style-btm large <?php echo $template_options[ 'class' ]; ?>">

		<?php echo $template_options[ 'components_before' ]; ?>
		<div class="container header-row header-main <?php echo $template_options[ 'components_class' ]; ?>">
			<div class="header-row-layout">

				<?php if ( ! empty( $template_options[ 'components' ][ 'left' ] ) ) {
					$template_helper->set_component_location( 'left' ); ?>
					<div class="header-col header-l">
						<?php foreach ( $template_options[ 'components' ][ 'left' ] as $component ) {
							get_template_part( 'template-parts/header/components/' . $component );
						} ?>
					</div>
				<?php } ?>

				<?php if ( ! empty( $template_options[ 'components' ][ 'right' ] ) ) {
					$template_helper->set_component_location( 'right' ); ?>
					<div class="header-col header-r">
						<?php foreach ( $template_options[ 'components' ][ 'right' ] as $component ) {
							get_template_part( 'template-parts/header/components/' . $component );
						} ?>
					</div>
				<?php } ?>

			</div>
		</div>
		<?php echo $template_options[ 'components_after' ]; ?>

		<div class="container header-row header-row-btm header-c">
			<?php get_template_part( 'template-parts/header/mobile/branding' ); ?>
		</div>

	</header>
<?php echo $template_options[ 'after' ]; ?>