<?php
/**
 * The template part for displaying ad before header
 *
 * @package BoomBox_Theme
 * @since   1.0.0
 * @version 2.0.0
 */

// Prevent direct script access.
if ( ! defined( 'ABSPATH' ) ) {
	die( 'No direct script access allowed' );
}

if ( is_single() ) {
	$location = 'boombox-single-before-header';
} else if ( is_archive() ) {
	$location = 'boombox-archive-before-header';
} else if ( is_page() ) {
	$location = 'boombox-page-before-header';
} else {
	$location = false;
}

if ( $location ) {
	boombox_the_advertisement( $location, array( 'class' => 'large' ) );
}