/**
 * ************ Dom Ready ************
 */
(function ($) {
    "use strict";

    /* Functions */
    $('.has-full-post-button .post-list.standard .post-thumbnail img').each(function(){
        ShowFullPost($(this));
    });

    /* BB Side Navigation */
    bbSideNav();

    /* Sticky Sidebar  */
    $('.sticky-sidebar').bbStickySidebar();

    /* Masonry Post   */
   // postImageSizes('#post-items .post-thumbnail a');
    postMasonry();

    /* Tabs */
    initializeTabs();

    /* Set Placeholders */
    setFormPlaceholders('.woocommerce','.form-row');

    /* Featured Carousel */
    $(".featured-carousel").each(function(){

        var itemWidth = $(this).hasClass('big-item')? 200 : 150,
            containerWidth = $(this).width(),
            slidesToShow = Math.round(containerWidth / itemWidth),
            firstImgHeight = $(this).find('.item img').height();


        $(this).find('ul').slick({
            infinite: true,
            slidesToShow: slidesToShow,
            slidesToScroll: slidesToShow - 3,
            prevArrow:'<a type="button" href="#" class="bb-arrow-prev"></a>',
            nextArrow:'<a type="button" href="#" class="bb-arrow-next"></a>',
            swipe: true,
            rtl: bb.isRTL,
            arrows: true,
            responsive: [{
                breakpoint: 600,
                settings: {
                    slidesToShow: Math.round(600 / itemWidth),
                    slidesToScroll: Math.round(600 / itemWidth)-1,
                }
            },{
                breakpoint: 480,
                settings: {
                    slidesToShow: Math.round(480 / itemWidth),
                    slidesToScroll: Math.round(480 / itemWidth)-1,
                }
            },]
        });
    });

    /* LightModal Popup Plugin */
    $('.js-inline-popup').lightModal ({});

    /* Scroll Area Plugin */
    $('.bb-scroll-area.arrow-control').bbScrollableArea({});

    /* Sidebar First Widget */
    sidebarFirstWidget();

    /* Mobile Navigation */
    bbMobileNavigation();

    /* Hides Some Elements when Reaching to Footer Area */
    hideElementsOnScroll();

    /* Page Top Animation */
    animationPageTop();

    /* Disabled Links Behaviour */
    disabledLinksBehaviour();

    /* Gif and Video Functionality */

    // Post GIF play on scroll & click
    function GIFimage() {

        var excluded_selectors = [
            '.gallery-item img[src*=".gif"]',
            '.regif_row_parent img[src*=".gif"]',
            '.next-prev-pagination img[src*=".gif"]'
        ];
        excluded_selectors = excluded_selectors.concat( boombox_global_vars.single_post_animated_hyena_gifs_excluded_js_selectors );
        excluded_selectors = excluded_selectors.join( ', ' );

        var hyena_possible_nodes = $('.single .single.post img[src*=".gif"], .post-list.standard img[src*=".gif"]').not( excluded_selectors );

        if( hyena_possible_nodes.length ) {
            hyena_possible_nodes.Hyena({
                "style": 1,
                "controls": false,
                "on_hover": (boombox_gif_event == 'hover'),
                "on_scroll": (boombox_gif_event == 'scroll')
            });
        }
    }

    GIFimage();

    // Post Featured Video autoplay
    if (bb.html.hasClass('video')) {
        $('.post-thumbnail video').not('.gif-video').each(function () {
            var video = $(this)[0];
            featuredVideo(video);
        });

        $(' video.gif-video').each(function () {
            var video = $(this)[0];
            GIFvideo(video);
        });

        $(' img.gif-image').each(function () {
            var img = $(this)[0];
            GIFtoVideo(img);
        });
    }

    /**
     * Plays featured video based on the options below
     * Options:
         bb.videoOptions = {
         playerControls: ( string ) mute | full_controls
         autoPlay: 		( string ) scroll | hover|none
         sound: 			( string ) muted | with_sound
         clickEvent: 	( string ) mute_unmute | play_pause
         loop: 			( int )    0 | 1 ( 0 if disabled, 1 if enabled )
         }
     */
    function featuredVideo(video) {
        /* *** Variables *** */
        var $videoWrapper = $(video).parent();
        var $btnVolume= $videoWrapper.find('.btn-volume');
        var durationBadge = $videoWrapper.find('.badge-duration');
        var durationTimeout;

        /* *** Helper Functions *** */
        // Play video
        var playVideo = function() {
            if (!$videoWrapper.hasClass('play')) {
                $videoWrapper.addClass('play');
                video.play();
                $btnVolume.removeClass('hidden');
                if(bb.videoOptions.playerControls =='mute')
                    durationTimeout = setTimeout(function(){
                        durationBadge.addClass('hidden');
                    }, 3000);
            }
        };

        // Pause video
        var pauseVideo = function() {
            if ($videoWrapper.hasClass('play')) {
                $videoWrapper.removeClass('play');
                video.pause();
                $btnVolume.addClass('hidden');
                clearTimeout(durationTimeout);
                if(bb.videoOptions.playerControls =='mute')
                    durationBadge.removeClass('hidden');
            }
        };

        // Mute/Unmute click event
        var clickMuteUnmute = function() {
            var mutedVal = $(video).prop('muted');
            if(mutedVal)
                $(video).prop('muted', false);
            else
                $(video).prop('muted', true);
            $videoWrapper.find('.btn-volume .icon').toggleClass('hidden');
        };

        // Play/Pause click event
        var clickPlayPause = function() {
            if($videoWrapper.hasClass('play'))
                pauseVideo();
            else
                playVideo();
        };

        // Set video duration
        var setVideoDuration = function(){
            var durationInterval = window.setInterval(function(t){
                if(video.readyState > 0) {
                    var videoDuration = numberToTwoDigits(Math.floor(video.duration));
                    if (videoDuration < 60)
                        videoDuration = "00:" + videoDuration.toString();
                    if (videoDuration > 60) {
                        var timeRoundPart = numberToTwoDigits(Math.floor(videoDuration / 60));
                        var timeReminder = numberToTwoDigits(Math.round(videoDuration % 60));
                        videoDuration = timeRoundPart + ":" + timeReminder;
                    }

                    durationBadge.text(videoDuration);
                    durationBadge.removeClass('hidden');
                    clearInterval(durationInterval);
                }
            },300);

        };

        /* *** General *** */
        $videoWrapper.find('.btn-volume').on("click", function (e) {
            e.stopPropagation();
            clickMuteUnmute();
        });
        // Video click play functionality by default
        $videoWrapper.on("click", function () {
            playVideo();
        });

        /* *** Options *** */
        // Video scroll autoplay/ pause functionality
            var videoView = new Waypoint.Inview({
                element: video,
                entered: function () {
                       if(bb.videoOptions.autoPlay =='scroll' && !bb.isMobile)
                            playVideo();
                },
                exited: function () {
                        setTimeout(function () {
                            pauseVideo();
                        }, 150);
                }
            });

        // Video hover play functionality
        if(bb.videoOptions.autoPlay =='hover' && !bb.isMobile)
            $videoWrapper.on('mouseenter touchstart', function () {
                playVideo();
            })

        // Video click play/ pause functionality
        if(bb.videoOptions.clickEvent =='play_pause') {
            $videoWrapper.off('click');
            $videoWrapper.on("click", function (e) {
                clickPlayPause();
            });
        }

        // Video click mute/ unmute functionality
        if(bb.videoOptions.clickEvent =='mute_unmute') {
            $videoWrapper.off('click');
            $videoWrapper.on("click", function (e) {
                if($videoWrapper.hasClass('play'))
                    clickMuteUnmute();
                else
                    playVideo();
            });
        }

        // Video duration
        if(bb.videoOptions.playerControls =='mute') {
            setVideoDuration();
        }

        // Video Loop
        if(bb.videoOptions.loop == 0)
        {
            video.onended = function() {
                $videoWrapper.removeClass('play');
                if(bb.videoOptions.playerControls =='mute')
                    durationBadge.removeClass('hidden');
            };
        }
    }

    function GIFvideo(video) {

        video.pause();

        $(video).attr('width', '100%').attr('height', 'auto');

        var $videoWrapper = $(video).parent(),
            canPlay = true;


        if (bb.isMobile) {
            $(video).attr('webkit-playsinline', 'webkit-playsinline');
        }
        if (boombox_gif_event == 'hover') {

            $videoWrapper.on('mouseenter touchstart', function () {
                $videoWrapper.addClass('play');
                video.play();

            }).on('mouseleave touchend', function () {
                $videoWrapper.removeClass('play');
                video.pause();
            });

        } else if (boombox_gif_event == 'scroll') {

            var videoView = new Waypoint.Inview({
                element: video,
                entered: function () {
                    if (canPlay) {
                        $videoWrapper.addClass('play');
                        video.play();
                    }

                },
                exited: function () {
                    if (canPlay) {
                        setTimeout(function () {
                            $videoWrapper.removeClass('play');
                            video.pause();
                        }, 150);

                    }
                }
            });
        }
        $videoWrapper.on('click', function (e) {
            e.stopPropagation();
            if (!$videoWrapper.hasClass('play')) {
                video.play();
                $videoWrapper.addClass('play');
            } else {
                video.pause();
                $videoWrapper.removeClass('play');
            }
            return false;
        });
    }

    function GIFtoVideo(img) {
        var $videoWrapper = $(img).parent();
        var imgUrl = $(img).attr('src');
        var video;

        $videoWrapper[0].addEventListener('click', function () {

            if (!$(this).hasClass('video-done')) {

                var videoUrl = $(img).data('video');

                video = document.createElement("video");

                video.setAttribute("loop", true);
                video.setAttribute("poster", imgUrl);
                video.setAttribute("webkit-playsinline", "webkit-playsinline");

                var videoSrc = document.createElement("source");

                videoSrc.setAttribute("src", videoUrl);
                videoSrc.setAttribute("type", "video/mp4");

                video.appendChild(videoSrc);
                $(this)[0].appendChild(video);

                toggleVideoPlaying(video);

                $(this).find('img').remove();
                $(this).addClass('video-done');

            } else {

                toggleVideoPlaying(video);
            }
        });

        var videoView = new Waypoint.Inview({
            element: $videoWrapper,
            exited: function () {
                if ($videoWrapper.hasClass('video-done')) {
                    var img = '<img  src=' + imgUrl + ' alt="">';
                    $(img).appendTo($videoWrapper);
                    $videoWrapper.find('video').remove();
                    $videoWrapper.removeClass('play');
                    $videoWrapper.removeClass('video-done');
                }
            }
        });
    }

    function toggleVideoPlaying(video) {
        if (video.paused) {

            var promise = video.play();

            // promise won�t be defined in browsers that don't support promisified play()
            if (promise === undefined) {

                //Promisified video play() not supported

                video.setAttribute("controls", true);

            } else {
                promise.then(function () {
                    // Video playback successfully initiated, returning a promise
                }).catch(function (error) {
                    // Error initiating video playback

                    video.setAttribute("controls", true);
                });
            }

            $(video).parent().addClass('play');

        } else {
            video.pause();
            $(video).parent().removeClass('play');

        }
    }

    /* ************ Ends - Gif and Video Functionality ************ */


    /**
     * ************ Load More Content ************
     */
    if ($('#load-more-button').length) {

        var
            load_more_btn = $('#load-more-button'),
            loading = false,
            firstClick = false,
            loadType = load_more_btn.data('scroll');


        $('#load-more-button').on("click", function () {
            if (loading) return;

            loading = true;

            var next_page_url = load_more_btn.attr('data-next_url');

            load_more_btn.parent().addClass('loading');
            jQuery.post(next_page_url, {},
                function (response) {
                    var html = $(response),
                        container = html.find('#post-items'),
                        articles = container.find('.post-item').addClass('item-added'),
                        more_btn = html.find('#load-more-button');

                    $('#post-items').append(articles);

                    //postImageSizes($('#post-items .item-added .post-thumbnail a'));

                    // load new content
                    $('body').trigger( 'bbNewContentLoaded', [ articles ] );

                    // Post GIF play on scroll & click
                    $('.post-list.standard .item-added  img[src*=".gif"]').Hyena({
                        "style": 1,
                        "controls": false,
                        "on_hover": (boombox_gif_event == 'hover'),
                        "on_scroll": (boombox_gif_event == 'scroll')
                    });

                    // Post Featured Video autoplay
                    if ($("html").hasClass('video')) {
                        $('#post-items  .item-added video').not('.gif-video').each(function () {
                            var video = $(this)[0];
                            featuredVideo(video);
                        });
                        $('#post-items  .item-added video.gif-video').each(function () {
                            var video = $(this)[0];
                            GIFvideo(video);
                        });

                        $('#post-items  .item-added img.gif-image').each(function () {
                            var img = $(this)[0];
                            GIFtoVideo(img);
                        });
                    }

                    $('.has-full-post-button .post-list.standard .item-added .post-thumbnail img').each(function(){
                        ShowFullPost($(this));
                    });

                    $('#post-items  .item-added').removeClass('item-added');

                    load_more_btn.parent().removeClass('loading');

                    if (more_btn.length > 0) {
                        var next_url = more_btn.data('next_url');
                        load_more_btn.attr('data-next_url', next_url);
                    } else {
                        load_more_btn.parent().remove();
                    }

                    loading = false;
                    firstClick = true;
                    if (loadType === 'on_demand' || loadType === 'infinite_scroll') {
                        infiniteScroll();
                    }
                }
            );

        });


        var infiniteScroll = function () {

            if (loadType === 'on_demand' && !firstClick) {
                return false;
            }

            load_more_btn.waypoint(function (direction) {
                if (direction === 'down') {
                    load_more_btn.trigger("click");
                }
            }, {
                offset: '150%'
            });
        }

        if (loadType === 'infinite_scroll') {
            infiniteScroll();
        }

    }

    $("body").on( "alnp-post-loaded", function(){
        $("div#balnp_content_container  .item-added video").not(".gif-video").each(function () {
            var video = $(this)[0];
            featuredVideo(video);
        });

        $("div#balnp_content_container  .item-added video.gif-video").each(function () {
            var video = $(this)[0];
            GIFvideo(video);
        });

        $("div#balnp_content_container  .item-added img.gif-image").each(function () {
            var img = $(this)[0];
            GIFtoVideo(img);
        });


        if (typeof ZombifyOnAjax !== 'undefined' && ZombifyOnAjax) {
            ZombifyOnAjax();
        }

        $("div#balnp_content_container .item-added").removeClass("item-added");
    } );

    /* ************ Ends - Load More Content ************ */

})(jQuery);

/**
 * ************ Window Load ************
 */
jQuery(window).load(function () {
    /* Sticky Navbar */
    jQuery('.bb-sticky.sticky-smart').bbSticky({
        scrollStyle: 'smart',
        fixedOffsetFunc: function(){
            return  getSetAdminBars();
        },
        animation: true
    });
    jQuery('.bb-sticky.sticky-classic').bbSticky({
        fixedOffsetFunc: function(){
            return  getSetAdminBars();
        },
    });

    /* Sticky Fixed Next Page */
    jQuery('.bb-sticky.bb-fixed-next-page').bbSticky({
        scrollStyle: 'classic',
        fixedOffsetFunc: function(){
            getHeaderHeight();
        },
        keepWrapperHeight: false,
        fullWidth: true,
        animation: true
    });

    /* Sticky Share Box */
    jQuery('.bb-sticky.bb-sticky-share-box').bbSticky({
        fixedOffsetFunc: function(){
            return getShareBoxOffset();
        },
    });

    /* Toggle Functionality */
    jQuery.bbToggle();

    /* Floating Pagination */
    setFormPlaceholders('.woocommerce','.form-row');
});

/**
 * ************ Window Resize ************
 */
jQuery(window).resize(function () {

});

/**
 * ************ Window Scroll ************
 */
jQuery(window).scroll(function () {

});

