<?php

// Prevent direct script access.
if ( ! defined( 'ABSPATH' ) ) {
	die( 'No direct script access allowed' );
}

if ( ! class_exists( 'Boombox_VC_Listing' ) ) {

	final class Boombox_VC_Listing {

		/**
		 * Holds class single instance
		 * @var null
		 */
		private static $_instance = NULL;

		/**
		 * Get instance
		 * @return Boombox_VC_Listing|null
		 */
		public static function get_instance() {

			if ( NULL == static::$_instance ) {
				static::$_instance = new self();
			}

			return static::$_instance;

		}

		/**
		 * Boombox_VC constructor.
		 */
		private function __construct() {
			$this->hooks();
		}

		/**
		 * A dummy magic method to prevent Boombox_VC_Listing from being cloned.
		 */
		public function __clone() {
			throw new Exception( 'Cloning ' . __CLASS__ . ' is forbidden' );
		}

		/**
		 * Setup Hooks
		 */
		public function hooks() {
			add_shortcode( 'boombox_listing', array( $this, 'render' ) );
			add_action( 'vc_before_init', array( $this, 'init' ) );
		}

		/**
		 * Init
		 */
		public function init() {

			$listing_type_choices = Boombox_Choices_Helper::get_instance()->get_listing_types( 'label=>value' );

			$params = array(
				'name'     => __( 'Boombox Listing', 'boombox' ),
				'base'     => 'boombox_listing',
				'class'    => '',
				'category' => __( 'Boombox', 'boombox' ),
				'params'   => array(
					array(
						'type'        => 'dropdown',
						'heading'     => __( 'Listing Type', 'boombox' ),
						'value'       => $listing_type_choices,
						'std'         => 'grid',
						'param_name'  => 'type',
						'description' => __( 'Choose listing type.', 'boombox' ),
					),
					array(
						'type'        => 'dropdown',
						'heading'     => __( 'Listing Condition', 'boombox' ),
						'value'       => array_flip( Boombox_Choices_Helper::get_instance()->get_conditions() ),
						'std'         => 'recent',
						'param_name'  => 'condition',
						'description' => __( 'Choose listing condition.', 'boombox' ),
					),
					array(
						'type'        => 'dropdown',
						'heading'     => __( 'Listing Time Range', 'boombox' ),
						'value'       => array_flip( Boombox_Choices_Helper::get_instance()->get_time_ranges() ),
						'std'         => 'all',
						'param_name'  => 'time_range',
						'description' => __( 'Choose listing time range.', 'boombox' ),
					),
					array(
						'type'        => 'autocomplete',
						'heading'     => __( 'Listing Category', 'boombox' ),
						'param_name'  => 'category',
						'std'         => '',
						'description' => __( 'Choose listing category.', 'boombox' ),
						'settings'    => array(
							'multiple'       => true,
							'min_length'     => 0,
							'unique_values'  => true,
							'display_inline' => false,
							'delay'          => 500,
							'auto_focus'     => true,
						),
					),
					array(
						'type'        => 'autocomplete',
						'heading'     => __( 'Listing Tag', 'boombox' ),
						'param_name'  => 'post_tag',
						'std'         => '',
						'description' => __( 'Choose listing tag.', 'boombox' ),
						'settings'    => array(
							'multiple'       => true,
							'min_length'     => 0,
							'unique_values'  => true,
							'display_inline' => true,
							'delay'          => 500,
							'auto_focus'     => true,
						),
					),
					array(
						'type'        => 'boombox_number',
						'heading'     => __( 'Posts Count', 'boombox' ),
						'std'         => get_option( 'posts_per_page' ),
						'min'         => 1,
						'param_name'  => 'posts_per_page',
						'description' => __( 'Choose posts count per page.', 'boombox' ),
					),
					array(
						'type'        => 'boombox_number',
						'heading'     => __( 'Offset', 'boombox' ),
						'std'         => 0,
						'min'         => 1,
						'param_name'  => 'offset',
						'description' => __( 'Choose offset.', 'boombox' ),
					),
				),
			);

			vc_map( $params );
		}

		/**
		 * Render shortcode
		 *
		 * @param array       $atts    Shortcode attributes
		 * @param null|string $content Shorcode content
		 *
		 * @return string
		 */
		public function render( $atts, $content = NULL ) {

			global $wp_query;
			$tmp_query = $wp_query;

			$atts = shortcode_atts( array(
				'type'           => 'grid',
				'condition'      => 'recent',
				'time_range'     => 'all',
				'category'       => '',
				'post_tag'       => '',
				'posts_per_page' => get_option( 'posts_per_page' ),
				'offset'         => 0,
			), $atts, 'boombox_listing' );

			if ( 'none' != $atts[ 'type' ] ) {

				$args = array(
					'posts_per_page'      => $atts[ 'posts_per_page' ],
					'offset'              => $atts[ 'offset' ],
					'post_type'           => 'post',
					'posts_count'         => -1,
					'is_grid'             => in_array( $atts[ 'type' ], array( 'grid' ) ),
					'ignore_sticky_posts' => ! is_front_page(),
				);

				$wp_query = boombox_get_posts_query(
					$atts[ 'condition' ],
					$atts[ 'time_range' ],
					array( 'category' => $atts[ 'category' ], 'tag' => $atts[ 'post_tag' ] ),
					$args
				);

				if ( is_object( $wp_query ) ) {
					$wp_query->is_page = true;
					$wp_query->is_singular = true;
				}

			}

			ob_start();

			if ( Boombox_Loop_Helper::have_posts() ) {
				do_action( 'boombox/vc/loop-start' ); ?>
				<div class="bb-post-collection <?php echo boombox_get_list_type_classes( $atts[ 'type' ], array( 'col-2' ) ); ?>">
					<ul id="post-items" class="post-items">
						<?php
						while ( Boombox_Loop_Helper::have_posts() ) {
							$the_post = Boombox_Loop_Helper::the_post();
							if ( $the_post->is_injected && $the_post->is_adv ) {
								$adv_settings = boombox_get_adv_settings( $atts[ 'type' ] );
								boombox_the_advertisement( $adv_settings[ 'location' ], array(
									'tag' => 'li',
									'class' => array( $adv_settings[ 'size' ], 'post-item' ),
									'tmp_query' => $tmp_query,
									'cur_query' => $wp_query
								) );
							} else if ( $the_post->is_injected && $the_post->is_newsletter ) {
								boombox_mailchimp_form( array( 'tag' => 'li', 'class' => 'post-item' ) );
							} else if ( get_the_ID() ) {
								get_template_part( 'template-parts/content-' . $atts[ 'type' ], get_post_format() );
							}
						} ?>
					</ul>
				</div>
				<?php
				do_action( 'boombox/vc/loop-end' );
			}
			$content = ob_get_clean();

			$wp_query = $tmp_query;
			wp_reset_query();

			return $content;

		}

	}

	Boombox_VC_Listing::get_instance();

}